/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna.consume;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaApplyRecordService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaPermFileService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaRoleAssignService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaSchemeMatchService;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.perm.DepInfo;
import kd.hr.hrcs.common.model.perm.PersonInfo;
import kd.hr.hrcs.common.model.perm.SceneRoleInfo;
import kd.hr.hrcs.common.model.perm.UserRoleRelat;
import kd.hr.hrcs.common.model.perm.dyna.ApplyRecord;
import kd.hr.hrcs.common.model.perm.dyna.DynaDs;
import kd.hr.hrcs.common.model.perm.dyna.DynaDsPerson;
import kd.hr.hrcs.common.model.perm.dyna.DynaPermConsumeContext;
import kd.hr.hrcs.common.model.perm.dyna.DynaScheme;
import org.apache.commons.collections4.CollectionUtils;

@ExcludeFromJacocoGeneratedReport
public class DynaSchemeService {
    private static final Log LOGGER = LogFactory.getLog(DynaSchemeService.class);

    public static List<DynaScheme> getDynaSchemeByScene(Long sceneId, DynaDs assignDynaDs, String billEntityNumber) {
        HRBaseServiceHelper schemeHelper = new HRBaseServiceHelper("hrcs_dynascheme");
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)16);
        QFilter aFilter = new QFilter("assignsceneentry.assignscene.id", "=", (Object)sceneId);
        QFilter bFilter = new QFilter("cancelsceneentry.cancelscene.id", "=", (Object)sceneId);
        QFilter version = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter filter = aFilter.or(bFilter);
        filterList.add(version);
        filterList.add(filter);
        filterList.add(enable);
        filterList.add(status);
        DynamicObjectCollection schemeVidColl = schemeHelper.queryOriginalCollection("sourcevid", HRPermCommonUtil.listToQFilters((List)filterList));
        Set schemeVidSet = schemeVidColl.stream().map(dyna -> dyna.getLong("sourcevid")).collect(Collectors.toSet());
        DynamicObject[] schemeDynArr = schemeHelper.query("id,boid,name,assigndays,containmanualassign,authaction,condition,assignsceneentry.assignscene,assignsceneentry.assignpersonitem,cancelsceneentry.cancelscene,cancelsceneentry.cancelpersonitem,roleentry.role,roleentry.customenable", new QFilter[]{new QFilter("id", "in", schemeVidSet)});
        ArrayList schemeList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject schemeDyn : schemeDynArr) {
            Object assignSceneDyna2;
            DynaScheme scheme = new DynaScheme();
            scheme.setId(Long.valueOf(schemeDyn.getLong("id")));
            scheme.setBoid(Long.valueOf(schemeDyn.getLong("boid")));
            scheme.setNumber(schemeDyn.getString("number"));
            scheme.setName(schemeDyn.getString("name"));
            scheme.setAuthAction(schemeDyn.getString("authaction"));
            scheme.setCondition(schemeDyn.getString("condition"));
            scheme.setContainManualAssign(schemeDyn.getBoolean("containmanualassign"));
            int assignDays = schemeDyn.getInt("assigndays");
            if (assignDays >= 1) {
                --assignDays;
            }
            scheme.setAssignDays(assignDays);
            scheme.setSceneId(sceneId);
            DynamicObjectCollection assignSceneColl = schemeDyn.getDynamicObjectCollection("assignsceneentry");
            for (Object assignSceneDyna2 : assignSceneColl) {
                Long id = assignSceneDyna2.getLong("assignscene.id");
                if (!Objects.equals(id, sceneId)) continue;
                Long assignPersonItemId = assignSceneDyna2.getLong("assignpersonitem.id");
                scheme.setAssignPersonItemId(assignPersonItemId);
            }
            DynamicObjectCollection cancelSceneColl = schemeDyn.getDynamicObjectCollection("cancelsceneentry");
            assignSceneDyna2 = cancelSceneColl.iterator();
            while (assignSceneDyna2.hasNext()) {
                DynamicObject cancelSceneDyna = (DynamicObject)assignSceneDyna2.next();
                Long id = cancelSceneDyna.getLong("cancelscene.id");
                if (!Objects.equals(id, sceneId)) continue;
                Long cancelPersonItemId = cancelSceneDyna.getLong("cancelpersonitem.id");
                scheme.setCancelPersonItemId(cancelPersonItemId);
            }
            ArrayList roleList = Lists.newArrayListWithExpectedSize((int)16);
            DynamicObjectCollection roleColl = schemeDyn.getDynamicObjectCollection("roleentry");
            for (DynamicObject roleDyn : roleColl) {
                boolean roleEnable = roleDyn.getBoolean("role.enable");
                if (!roleEnable) continue;
                String roleNum = roleDyn.getString("role.number");
                String roleId = roleDyn.getString("role.id");
                String customEnable = roleDyn.getString("customenable");
                Long roleEntryId = roleDyn.getLong("id");
                SceneRoleInfo sceneRoleInfo = new SceneRoleInfo(roleNum, customEnable, roleId);
                sceneRoleInfo.setRoleEntryId(roleEntryId);
                roleList.add(sceneRoleInfo);
            }
            scheme.setRoleList((List)roleList);
            schemeList.add(scheme);
        }
        return schemeList;
    }

    public static void calSchemeNeedCancelRelat(DynaPermConsumeContext context, List<DynaScheme> schemeList, List<DynaDsPerson> dsPersonList, DynaDs cancelDs) {
        HashSet needCancelRoleIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet needCancelUserIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynaScheme scheme : schemeList) {
            if (!HRStringUtils.equals((String)scheme.getAuthAction(), (String)"2") && !HRStringUtils.equals((String)scheme.getAuthAction(), (String)"3")) continue;
            HashSet schemeRoleIds = Sets.newHashSetWithExpectedSize((int)16);
            for (SceneRoleInfo roleInfo : scheme.getRoleList()) {
                schemeRoleIds.add(roleInfo.getRoleId());
            }
            needCancelRoleIds.addAll(schemeRoleIds);
        }
        if (CollectionUtils.isEmpty((Collection)needCancelRoleIds)) {
            LOGGER.info("DynaPermMsgConsumer calSchemeNeedCancelRelat donot have role.return");
            return;
        }
        for (DynaDsPerson dsPerson : dsPersonList) {
            PersonInfo personInfo = dsPerson.getPersonInfo();
            if (Objects.isNull(personInfo)) continue;
            needCancelUserIds.add(personInfo.getUserId());
        }
        HRBaseServiceHelper relatHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        DynamicObjectCollection mayCancelRelats = relatHelper.queryOriginalCollection("id,permfile.id,user.id,role.id,customenable,validstart,validend,assigntype,scheme.id,scheme.boid,sourcetype", new QFilter[]{new QFilter("user.id", "in", (Object)needCancelUserIds), new QFilter("role.id", "in", (Object)needCancelRoleIds)});
        ArrayList needCheckRelatList = Lists.newArrayListWithExpectedSize((int)mayCancelRelats.size());
        for (DynamicObject relatDyna : mayCancelRelats) {
            UserRoleRelat relatBean = new UserRoleRelat(Long.valueOf(relatDyna.getLong("id")), Long.valueOf(relatDyna.getLong("permfile.id")), Long.valueOf(relatDyna.getLong("user.id")), relatDyna.getString("role.id"));
            relatBean.setValidStart(relatDyna.getDate("validstart"));
            relatBean.setValidEnd(relatDyna.getDate("validend"));
            relatBean.setSourceType(relatDyna.getString("sourcetype"));
            relatBean.setSchemeId(Long.valueOf(relatDyna.getLong("scheme.id")));
            relatBean.setSchemeBoid(Long.valueOf(relatDyna.getLong("scheme.boid")));
            relatBean.setCustomRange(Boolean.valueOf(relatDyna.getBoolean("customenable")));
            needCheckRelatList.add(relatBean);
        }
        HashSet allNeedCancelRelats = Sets.newHashSetWithExpectedSize((int)16);
        Map cancelApiInfo = DynaSchemeMatchService.getApiInParamInfoByDs((DynaDs)context.getCancelDs());
        for (DynaScheme scheme : schemeList) {
            try {
                if (HRStringUtils.equals((String)scheme.getAuthAction(), (String)"1")) continue;
                List<PersonInfo> schemePersonInfos = DynaSchemeService.getSchemePersonInfosByItemId(dsPersonList, scheme.getCancelPersonItemId());
                for (PersonInfo personInfo : schemePersonInfos) {
                    personInfo.setDepSet(personInfo.getAllDepSet());
                }
                scheme.setCancelPersonInfos(schemePersonInfos);
                if (CollectionUtils.isEmpty(schemePersonInfos)) {
                    LOGGER.info("DynaPermMsgConsumer calSchemeNeedCancelRelat Scheme id={},name={},cancelPersonItemId={} donot have cancel person", new Object[]{scheme.getId(), scheme.getName(), scheme.getCancelPersonItemId()});
                    continue;
                }
                List dealedPersonInfos = DynaSchemeMatchService.schemeMatchRule((DynaPermConsumeContext)context, (String)"2", (DynaScheme)scheme, schemePersonInfos, (DynamicObject)context.getCancelDyna(), (Map)cancelApiInfo);
                Set matchedUserIds = dealedPersonInfos.stream().filter(info -> info.getIsMatchRule()).map(PersonInfo::getUserId).collect(Collectors.toSet());
                HashSet noMatchedUserIds = Sets.newHashSetWithExpectedSize((int)16);
                HashMap noMatchedReasonMap = Maps.newHashMapWithExpectedSize((int)16);
                for (PersonInfo personInfo : dealedPersonInfos) {
                    Long userId = personInfo.getUserId();
                    if (matchedUserIds.contains(userId)) continue;
                    noMatchedUserIds.add(userId);
                    String noMatchReason = DynaSchemeService.collectNoMatchReason(personInfo);
                    noMatchedReasonMap.put(userId, noMatchReason);
                }
                scheme.setNoMatchedUserIds((Set)noMatchedUserIds);
                if (CollectionUtils.isEmpty((Collection)noMatchedUserIds)) continue;
                Set schemeRoleIds = scheme.getRoleList().stream().map(SceneRoleInfo::getRoleId).collect(Collectors.toSet());
                HashSet needCancelRelats = Sets.newHashSetWithExpectedSize((int)16);
                for (UserRoleRelat relat : needCheckRelatList) {
                    boolean isSchemeOk;
                    boolean isManual;
                    boolean isUserRoleOk;
                    if (allNeedCancelRelats.contains(relat) || !(isUserRoleOk = noMatchedUserIds.contains(relat.getUserId()) && schemeRoleIds.contains(relat.getRoleId()))) continue;
                    boolean bl = isManual = Objects.isNull(relat.getSchemeId()) || Objects.equals(relat.getSchemeId(), 0L);
                    if (HRStringUtils.equals((String)scheme.getAuthAction(), (String)"2")) {
                        if (!isManual) continue;
                        String cancelReason = String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3:%1$s\u52a8\u6001\u6388\u6743\u65b9\u6848\uff0c\u539f\u56e0:%2$s\u3002", (String)"DynaSchemeService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), scheme.getName(), noMatchedReasonMap.get(relat.getUserId()));
                        relat.setCancelReason(cancelReason);
                        needCancelRelats.add(relat);
                        allNeedCancelRelats.add(relat);
                        continue;
                    }
                    if (!HRStringUtils.equals((String)scheme.getAuthAction(), (String)"3") || !(isSchemeOk = Objects.equals(relat.getSchemeBoid(), scheme.getBoid())) && (!scheme.isContainManualAssign() || !isManual)) continue;
                    String cancelReason = String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3:%1$s\u52a8\u6001\u6388\u6743\u65b9\u6848\uff0c\u539f\u56e0:%2$s\u3002", (String)"DynaSchemeService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), scheme.getName(), noMatchedReasonMap.get(relat.getUserId()));
                    if (isManual) {
                        cancelReason = String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3:%s\u52a8\u6001\u6388\u6743\u65b9\u6848\uff0c\u540c\u6b65\u5220\u9664\u624b\u5de5\u5206\u914d\u7684\u76f8\u5173\u89d2\u8272", (String)"DynaSchemeService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), scheme.getName());
                    }
                    relat.setCancelReason(cancelReason);
                    needCancelRelats.add(relat);
                    allNeedCancelRelats.add(relat);
                }
                scheme.setNeedCancelRelats((Set)needCancelRelats);
            }
            catch (Exception ex) {
                LOGGER.error("DynaPermMsgConsumer calSchemeNeedCancelRelat happen_exception,skip the scheme:" + scheme.toString(), (Throwable)ex);
            }
        }
    }

    private static String collectNoMatchReason(PersonInfo personInfo) {
        Set depSet = personInfo.getDepSet();
        if (CollectionUtils.isEmpty((Collection)depSet)) {
            return personInfo.getMatchRuleMsg();
        }
        StringBuilder sb = new StringBuilder();
        for (DepInfo depInfo : depSet) {
            if (depInfo.getIsMatchRule().booleanValue()) continue;
            sb.append(depInfo.getMatchRuleMsg()).append(" ");
        }
        return sb.toString();
    }

    public static void doCancelRelats(List<DynaScheme> schemeList, ApplyRecord applyRecord) {
        HashSet allNeedCancelRelats = Sets.newHashSetWithExpectedSize((int)16);
        HashMap relateIdSchemeMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynaScheme scheme : schemeList) {
            if (HRStringUtils.equals((String)scheme.getAuthAction(), (String)"1")) continue;
            Set needCancelRelats = scheme.getNeedCancelRelats();
            allNeedCancelRelats.addAll(needCancelRelats);
            for (UserRoleRelat relat : needCancelRelats) {
                relateIdSchemeMap.put(relat.getId(), scheme);
                applyRecord.getUserSet().add(relat.getUserId());
                applyRecord.getCancelRdList().add(DynaApplyRecordService.buildCancelRecord((UserRoleRelat)relat, (DynaScheme)scheme));
            }
        }
        Set allNeedCancelRelatIds = allNeedCancelRelats.stream().map(UserRoleRelat::getId).collect(Collectors.toSet());
        DynaRoleAssignService.cancelUserRole(allNeedCancelRelatIds, (HashMap)relateIdSchemeMap);
    }

    public static void calSchemeNeedAssignPermFiles(DynaPermConsumeContext context, List<DynaScheme> schemeList, List<DynaDsPerson> dsPersonList) {
        Map assignApiInfo = DynaSchemeMatchService.getApiInParamInfoByDs((DynaDs)context.getAssignDs());
        for (DynaScheme scheme : schemeList) {
            try {
                if (HRStringUtils.equals((String)scheme.getAuthAction(), (String)"2")) continue;
                Long assignPersonItemId = scheme.getAssignPersonItemId();
                List<PersonInfo> assignPersonInfos = DynaSchemeService.getSchemePersonInfosByItemId(dsPersonList, assignPersonItemId);
                scheme.setAssignPersonInfos(assignPersonInfos);
                if (CollectionUtils.isEmpty(assignPersonInfos)) {
                    LOGGER.info("DynaPermMsgConsumer calSchemeNeedAssignPermFiles Scheme id={},name={},assignPersonItemId={} donot have assign person.", new Object[]{scheme.getId(), scheme.getName(), assignPersonItemId});
                    continue;
                }
                List dealedPersonInfos = DynaSchemeMatchService.schemeMatchRule((DynaPermConsumeContext)context, (String)"1", (DynaScheme)scheme, assignPersonInfos, (DynamicObject)context.getAssignDyna(), (Map)assignApiInfo);
                ArrayList matchedPersonInfos = Lists.newArrayListWithExpectedSize((int)16);
                for (PersonInfo personInfo : dealedPersonInfos) {
                    if (!personInfo.getIsMatchRule().booleanValue()) continue;
                    Set depSet = personInfo.getDepSet();
                    if (CollectionUtils.isNotEmpty((Collection)depSet)) {
                        Set matchedDepSet = depSet.stream().filter(DepInfo::getIsMatchRule).collect(Collectors.toSet());
                        personInfo.setDepSet(matchedDepSet);
                    }
                    matchedPersonInfos.add(personInfo);
                }
                scheme.setMatchedAssignPersonInfos((List)matchedPersonInfos);
                if (CollectionUtils.isEmpty((Collection)matchedPersonInfos)) continue;
                Set permFiles = DynaPermFileService.geneUserPermFile((List)matchedPersonInfos);
                scheme.setNeedAssignPermFiles((List)Lists.newArrayList((Iterable)permFiles));
            }
            catch (Exception ex) {
                LOGGER.error("DynaPermMsgConsumer calSchemeNeedAssignPermFiles happen_exception,skip the scheme:" + scheme.toString(), (Throwable)ex);
            }
        }
    }

    private static List<PersonInfo> getSchemePersonInfosByItemId(List<DynaDsPerson> dsPersonList, Long personItemId) {
        ArrayList personInfos = Lists.newArrayListWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(dsPersonList)) {
            return personInfos;
        }
        for (DynaDsPerson dynaDsPerson : dsPersonList) {
            if (!Objects.equals(dynaDsPerson.getPersonItemId(), personItemId)) continue;
            personInfos.add((PersonInfo)dynaDsPerson.getPersonInfo().clone());
        }
        return personInfos;
    }
}

