/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.permfile;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeSetItemValueEventArgs;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.AfterBindingDataEvent;
import kd.bos.form.field.events.BasedataEditListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRPermServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.role.HRRolePermHelper;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class HRCopyPermPlugin
extends HRDynamicFormBasePlugin
implements BasedataEditListener,
IDataModelChangeListener,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(HRCopyPermPlugin.class);
    private static final String ROLE_LIST_ENTRY = "rolelist";
    private static final String FIELD_ORIGINUSER = "originuser";
    private static final String FIELD_TARGETUSER = "targetuser";
    private static final String FIELD_VALIDPERIOD = "validperiod";
    private static final String FIELD_USERROLERELAT = "userrolerelat";
    private static final String FIELD_ROLE = "role";
    private static final String FIELD_CUSTOMENABLE = "customenable";
    private static final String FIELD_ROLEVALIDPERIOD = "rolevalidperiod";
    private static final String FIELD_CREATOR = "creator";
    private static final String FIELD_PERMROLE = "permrole";
    public static final String KEY_BTN_OK = "btnok";
    public static final String KEY_BTN_CANCEL = "btncancel";
    private static final String MUL_BASEDATA_FIELD = "targetuser";
    private static final String ORG = "org";
    private static final String NAME = "name";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Long permFileId = this.getPermFileId();
        DynamicObject permFile = RoleMemberAssignServiceHelper.getPermFileById((Long)permFileId);
        String orgUser = permFile.getString("user.name") + "(" + permFile.getString("org.name") + ")";
        this.getModel().setValue(FIELD_ORIGINUSER, (Object)orgUser);
        DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl(FIELD_VALIDPERIOD);
        boolean enableTime = RoleMemberAssignServiceHelper.enablePermValidateTime();
        if (enableTime) {
            Date date = new Date();
            Date startDate = PermRoleUtil.formatStartDate((Date)date);
            Date endDate = PermRoleUtil.formatStartDate((Date)PermRoleUtil.dateIncreaseByMonth((Date)date, (int)36));
            this.getModel().setValue(headFieldEdit.getStartDateFieldKey(), (Object)startDate);
            this.getModel().setValue(headFieldEdit.getEndDateFieldKey(), (Object)endDate);
        }
        this.fillRoleList();
    }

    public void afterBindData(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ROLE_LIST_ENTRY);
        int size = this.getModel().getEntryEntity(ROLE_LIST_ENTRY).size();
        int[] selectRows = new int[size];
        for (int i = 0; i < size; ++i) {
            selectRows[i] = i;
        }
        entryGrid.selectRows(selectRows, 0);
        boolean enableTime = RoleMemberAssignServiceHelper.enablePermValidateTime();
        ((DateRangeEdit)this.getControl(FIELD_VALIDPERIOD)).setMustInput(enableTime);
        this.getView().setVisible(Boolean.valueOf(enableTime), new String[]{FIELD_VALIDPERIOD});
        this.getView().setVisible(Boolean.valueOf(enableTime), new String[]{FIELD_ROLEVALIDPERIOD});
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CANCEL});
        this.getModel().addDataModelChangeListener((IDataModelChangeListener)this);
        BasedataEdit mulEdit = (BasedataEdit)this.getControl("targetuser");
        mulEdit.addBasedataEditListener((BasedataEditListener)this);
        mulEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindingData(AfterBindingDataEvent evt) {
        Object valueFast;
        IDataEntityProperty p4;
        String nameKey;
        BasedataEdit edit = (BasedataEdit)evt.getSource();
        Object dataEntity = evt.getDataEntity();
        String editSearchProp = "";
        Object displayProp = "";
        if (dataEntity == null) {
            return;
        }
        BasedataEntityType dt = ((DynamicObject)dataEntity).getDataEntityType() instanceof BasedataEntityType ? (BasedataEntityType)((DynamicObject)dataEntity).getDataEntityType() : (BasedataEntityType)((BasedataProp)edit.getProperty()).getComplexType();
        IDataEntityProperty p2 = dt.findProperty(nameKey = dt.getNameProperty());
        if (p2 != null && (displayProp = p2.getValueFast(dataEntity)) instanceof ILocaleString) {
            displayProp = displayProp.toString();
        }
        if ("targetuser".equals(edit.getKey())) {
            nameKey = ORG;
        }
        if ((p4 = dt.findProperty(nameKey)) != null && (valueFast = p4.getValueFast(dataEntity)) instanceof DynamicObject) {
            displayProp = String.format("%s(%s)", displayProp.toString(), ((DynamicObject)p4.getValueFast(dataEntity)).getString(NAME));
        }
        if ((editSearchProp = this.getEditSearchProp(edit.getProperty())) != null) {
            editSearchProp = editSearchProp.toString().replace(NAME, ObjectUtils.isEmpty((Object)displayProp) ? "" : displayProp.toString());
        }
        evt.setDisplayProp(ObjectUtils.isEmpty((Object)displayProp) ? "" : displayProp.toString());
        evt.setEditSearchProp(editSearchProp == null ? "" : editSearchProp.toString());
    }

    public void beforeSetItemValue(BeforeSetItemValueEventArgs e) {
        Object value = e.getValue();
        if (value == null) {
            return;
        }
        String searchKey = null;
        IDataEntityProperty property = e.getProperty();
        if ("targetuser".equals(property.getName())) {
            searchKey = ORG;
        }
        if (kd.bos.orm.util.StringUtils.isEmpty((Object)searchKey)) {
            return;
        }
        String[] split = value.toString().split(",|;");
        String[] qfliterArr = new String[split.length];
        e.setSearchKey(searchKey);
        e.setSearchArgs(qfliterArr);
    }

    private String getEditSearchProp(IDataEntityProperty property) {
        BasedataProp basedataProp = null;
        if (property instanceof BasedataProp) {
            basedataProp = (BasedataProp)property;
        } else if (property instanceof MulBasedataProp) {
            basedataProp = (BasedataProp)((MulBasedataProp)property).getRefBaseProp();
        }
        return basedataProp != null ? basedataProp.getEditSearchProp() : null;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (KEY_BTN_OK.equalsIgnoreCase(ctlSource.getKey())) {
            if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"15NPDX/GJFOO", (String)"hrcs_permfilequery", (String)"3O+YUNND//S3")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u7528\u6237\u6388\u6743\u201d\u7684\u201c\u590d\u5236\u6743\u9650\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRCopyPermPlugin_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.checkParam()) {
                return;
            }
            try {
                this.copyPermOnProgress();
            }
            catch (Exception ex) {
                LOGGER.error("HRCopyPermPlugin.copyPerm error", (Throwable)ex);
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u6743\u9650\u590d\u5236\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u8bbe\u7f6e\u3002", (String)"HRCopyPermPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            }
        } else if (KEY_BTN_CANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    private boolean checkParam() {
        EntryGrid eg;
        int[] selectRows;
        IDataModel model = this.getModel();
        Object targetUserObjs = model.getValue("targetuser");
        if (targetUserObjs == null || targetUserObjs instanceof DynamicObjectCollection && ((DynamicObjectCollection)targetUserObjs).size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u7528\u6237\u3002", (String)"HRCopyPermPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (RoleMemberAssignServiceHelper.enablePermValidateTime()) {
            boolean endNotNull;
            DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl(FIELD_VALIDPERIOD);
            Date validStart = (Date)this.getModel().getValue(headFieldEdit.getStartDateFieldKey());
            Date validEnd = (Date)this.getModel().getValue(headFieldEdit.getEndDateFieldKey());
            StringBuilder message = new StringBuilder();
            boolean startNotNull = null != validStart;
            boolean bl = endNotNull = null != validEnd;
            if (!startNotNull) {
                message.append(ResManager.loadKDString((String)"\u6709\u6548\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRCopyPermPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            if (!endNotNull) {
                message.append(ResManager.loadKDString((String)"\u6709\u6548\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRCopyPermPlugin_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            if (startNotNull && endNotNull && HRDateTimeUtils.dayBefore((Date)validEnd, (Date)validStart)) {
                message.append(ResManager.loadKDString((String)"\u6709\u6548\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6709\u6548\u5f00\u59cb\u65e5\u671f\uff1b", (String)"HRCopyPermPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            if (!kd.bos.orm.util.StringUtils.isEmpty((Object)message.toString())) {
                this.getView().showTipNotification(message.toString());
                return true;
            }
        }
        if (ArrayUtils.isEmpty((int[])(selectRows = (eg = (EntryGrid)this.getControl(ROLE_LIST_ENTRY)).getSelectRows()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u89d2\u8272\u3002", (String)"HRCopyPermPlugin_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void copyPermOnProgress() {
        try {
            JobInfo jobInfo = new JobInfo();
            jobInfo.setRunByLang(RequestContext.get().getLang());
            jobInfo.setAppId("hrcs");
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
            jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
            jobInfo.setName("hrcs-usercopypermtask job");
            String jobId = UUID.randomUUID().toString();
            jobInfo.setId(jobId);
            LOGGER.info("HRCopyPermPlugin.copyPerm JobId:{}", (Object)jobId);
            jobInfo.setTaskClassname("kd.hr.hrcs.bussiness.task.UserCopyPermTask");
            IDataModel dataModel = this.getModel();
            DynamicObjectCollection targetUserCollection = (DynamicObjectCollection)dataModel.getValue("targetuser");
            ArrayList<Long> targetUserIdSet = new ArrayList<Long>(16);
            for (DynamicObject targetUser : targetUserCollection) {
                DynamicObject user = targetUser.getDynamicObject("fbasedataid");
                Long userId = user.getLong("id");
                targetUserIdSet.add(userId);
            }
            Pair<List<String>, List<Pair<String, Long>>> pairUserRoleIdSet = this.getSourceUserRoleIdSet(this.getModel());
            DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl(FIELD_VALIDPERIOD);
            Date startDate = (Date)this.getModel().getValue(headFieldEdit.getStartDateFieldKey());
            Date endDate = (Date)this.getModel().getValue(headFieldEdit.getEndDateFieldKey());
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("sourceUserRoleId", pairUserRoleIdSet.getLeft());
            params.put("customSourceUserRoleId", JSON.toJSONString((Object)pairUserRoleIdSet.getRight()));
            params.put("targetUserId", targetUserIdSet);
            params.put("startDate", Objects.nonNull(startDate) ? Long.valueOf(startDate.getTime()) : null);
            params.put("endDate", Objects.nonNull(endDate) ? Long.valueOf(endDate.getTime()) : null);
            jobInfo.setParams(params);
            this.getView().getFormShowParameter().getCustomParams().putAll(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setCaption(ResManager.loadKDString((String)"\u590d\u5236\u6743\u9650\u5f02\u6b65\u4efb\u52a1\u7684\u6267\u884c", (String)"HRCopyPermPlugin_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            jobFormInfo.setCloseCallBack(closeCallBack);
            jobFormInfo.setCanStop(false);
            jobFormInfo.setClickClassName("kd.hr.hrcs.bussiness.task.PermTaskClick");
            HRCopyPermPlugin.dispatch(jobFormInfo, this.getView());
            this.writeOperateLog(targetUserIdSet);
        }
        catch (Exception ex) {
            LOGGER.error("UserCopyPermPlugin.copyPerm error", (Throwable)ex);
            throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
        }
    }

    private static void dispatch(JobFormInfo jobFormInfo, IFormView view) {
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(view.getPageId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sch_taskprogress");
        OpenStyle openStyle = showParameter.getOpenStyle();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("450px");
        cssValue.setHeight("240px");
        openStyle.setInlineStyleCss(cssValue);
        if (StringUtils.isNotBlank((CharSequence)jobFormInfo.getCaption())) {
            showParameter.setCaption(jobFormInfo.getCaption());
        } else if (StringUtils.isNotBlank((CharSequence)jobFormInfo.getJobInfo().getName())) {
            showParameter.setCaption(jobFormInfo.getJobInfo().getName());
        }
        showParameter.getCustomParams().put("ServiceAppId", view.getFormShowParameter().getServiceAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        showParameter.setCloseCallBack(jobFormInfo.getCloseCallBack());
        view.showForm(showParameter);
    }

    private void writeOperateLog(List<Long> targetUserIdSet) {
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u590d\u5236\u6743\u9650", "PermfilesListPlugin_43", "hrmp-hrcs-formplugin");
        appLogInfo.setOpName("copyperm", langEnumBridge);
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7528\u6237\u590d\u5236\u6743\u9650\u5f02\u6b65\u4efb\u52a1\u5df2\u6267\u884c\uff0c\u539f\u7528\u6237\uff1a%1$s\uff0c\u76ee\u6807\u7528\u6237\uff1a%2$s", "HRCopyPermPlugin_7", "hrmp-hrcs-formplugin");
        appLogInfo.setOpDesc(opDesc, new String[]{String.valueOf(this.getPermFileId()), targetUserIdSet.toString()});
        appLogInfo.setBizObjID("hrcs_permfilequery");
        appLogInfo.setBizAppID("15NPDX/GJFOO");
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        service.addLog((AppLogInfo)appLogInfo);
    }

    private Pair<List<String>, List<Pair<String, Long>>> getSourceUserRoleIdSet(IDataModel model) {
        int[] selectRows;
        ArrayList sourceUserRoleIdSet = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList customSourceUserRoleIdSet = Lists.newArrayListWithExpectedSize((int)16);
        Set roleIds = HRRolePermHelper.queryViewableRoles((long)RequestContext.get().getCurrUserId());
        String id = null;
        DynamicObjectCollection entryEntity = model.getEntryEntity(ROLE_LIST_ENTRY);
        EntryGrid eg = (EntryGrid)this.getControl(ROLE_LIST_ENTRY);
        for (int index : selectRows = eg.getSelectRows()) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            Object value = dynamicObject.get(FIELD_PERMROLE);
            String customenable = dynamicObject.getString(FIELD_CUSTOMENABLE);
            Long relationId = (Long)dynamicObject.getDynamicObject(FIELD_USERROLERELAT).getPkValue();
            if (value instanceof String) {
                id = (String)value;
            } else if (value instanceof DynamicObject) {
                id = ((DynamicObject)value).getPkValue().toString();
            } else if (value instanceof Long) {
                id = value.toString();
            }
            if (kd.bos.orm.util.StringUtils.isEmpty((Object)id) || CollectionUtils.isEmpty((Collection)roleIds) || !roleIds.contains(id)) continue;
            if ("1".equals(customenable)) {
                customSourceUserRoleIdSet.add(Pair.of((Object)id, (Object)relationId));
                continue;
            }
            sourceUserRoleIdSet.add(id);
        }
        return Pair.of((Object)sourceUserRoleIdSet, (Object)customSourceUserRoleIdSet);
    }

    private void fillRoleList() {
        Object[] relations = this.getUserRelatesByPermFields(new Object[]{this.getPermFileId()});
        if (ArrayUtils.isEmpty((Object[])relations)) {
            return;
        }
        Set roleIds = HRRolePermHelper.queryViewableRoles((long)RequestContext.get().getCurrUserId());
        ArrayList viewRelations = Lists.newArrayListWithCapacity((int)relations.length);
        for (Object relation : relations) {
            String roleId = relation.getString("role.id");
            if (!roleIds.contains(roleId)) continue;
            viewRelations.add(relation);
        }
        if (CollectionUtils.isEmpty((Collection)viewRelations)) {
            return;
        }
        this.getModel().deleteEntryData(ROLE_LIST_ENTRY);
        this.getModel().batchCreateNewEntryRow(ROLE_LIST_ENTRY, viewRelations.size());
        for (int index = 0; index < viewRelations.size(); ++index) {
            DynamicObject userRole = (DynamicObject)viewRelations.get(index);
            String roleId = userRole.getString("role.id");
            String roleName = userRole.getString("role.number") + " " + userRole.getString("role.name");
            this.getModel().setValue(FIELD_ROLE, (Object)roleName, index);
            this.getModel().setValue(FIELD_PERMROLE, (Object)userRole.getString("role.id"), index);
            this.getModel().setValue(FIELD_USERROLERELAT, (Object)userRole.getLong("id"), index);
            this.getModel().setValue(FIELD_CUSTOMENABLE, userRole.get(FIELD_CUSTOMENABLE), index);
            this.getModel().setValue("scheme", userRole.get("scheme"), index);
            Date validStart = userRole.getDate("validstart");
            Date validEnd = userRole.getDate("validend");
            if (!ObjectUtils.isEmpty((Object)validStart) && !ObjectUtils.isEmpty((Object)validEnd)) {
                this.getModel().setValue(FIELD_ROLEVALIDPERIOD, (Object)(DateUtils.getDate((Date)validStart) + "~" + DateUtils.getDate((Date)validEnd)), index);
            }
            this.getModel().setValue(FIELD_CREATOR, userRole.get(FIELD_CREATOR), index);
        }
    }

    private Long getPermFileId() {
        return (Long)this.getView().getFormShowParameter().getCustomParams().get("permfileId");
    }

    private DynamicObject[] getUserRelatesByPermFields(Object[] permFileIds) {
        HRBaseServiceHelper permFileHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        return permFileHelper.query("id,user.id,user.name,user.number,permfile.org.id,permfile.org.name,permfile.org.number,role.id,role.number,role.name,role.enable,customenable,validstart,validend,creator,scheme", new QFilter[]{new QFilter("permfile.id", "in", (Object)permFileIds), new QFilter("role.enable", "=", (Object)"1")}, "role.number,user.name");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)"targetuser")) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            long currUserId = RequestContext.get().getCurrUserId();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("user.id", "not in", (Object)currUserId));
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", (Object)this.getPermFileId()));
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("user.isforbidden", "=", (Object)"0"));
            long level = HRPermServiceHelper.getUserGroupMinLevel();
            if (-1L == level || level > 2L) {
                List userOrg = HRPermServiceHelper.getUserPermFile();
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("org.id", "in", (Object)userOrg));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"taskcloseback")) {
            this.taskCallBack(e.getReturnData());
        }
    }

    private void taskCallBack(Object returnData) {
        if (returnData instanceof Map) {
            TaskInfo taskInfo;
            Map result = (Map)returnData;
            Object taskInfoObj = result.get("taskinfo");
            if (null == taskInfoObj) {
                return;
            }
            String taskInfoStr = (String)taskInfoObj;
            if (StringUtils.isNotBlank((CharSequence)taskInfoStr) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String data = taskInfo.getData();
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                IFormView view = this.getView();
                String msg = String.valueOf(dataMap.get("msg"));
                switch (String.valueOf(dataMap.get("msgType"))) {
                    case "errorNotice": {
                        view.showErrorNotification(msg);
                        break;
                    }
                    case "successNotice": {
                        this.getModel().setDataChanged(false);
                        this.getPageCache().remove("pgCache_custom_dataChanged");
                        Integer showTime = (Integer)dataMap.get("showTime");
                        view.getParentView().showSuccessNotification(msg, showTime);
                        view.sendFormAction(this.getView().getParentView());
                        view.close();
                    }
                }
            }
        }
    }
}

