/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.taskdatasync.service;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.ssc.hstc.business.taskdatasync.BizTaskEntityService;
import kd.ssc.hstc.business.taskdatasync.cache.BatchBizTaskAppCacheFactory;
import kd.ssc.hstc.business.taskdatasync.service.TaskDataSyncBusinessService;
import kd.ssc.hstc.business.taskdatasync.service.TaskDataSyncFunctionInterface;
import kd.ssc.hstc.business.taskdatasync.util.BizTaskEntityUtil;
import kd.ssc.hstc.common.taskdatasync.enums.TaskRecordDataChangeTypeEnum;
import kd.ssc.hstc.common.taskdatasync.enums.TaskRecordSyncStatusEnum;

public class BatchTaskDataSyncBusinessService
extends TaskDataSyncBusinessService {
    private static final Log LOGGER = LogFactory.getLog(BatchTaskDataSyncBusinessService.class);

    public BatchTaskDataSyncBusinessService(DynamicObject taskdataSyncRecordDy) {
        super(taskdataSyncRecordDy);
    }

    @Override
    public void doSyncData() {
        if (CollectionUtils.isEmpty((Collection)this.taskdataSyncRecordEntryEntityDyColl)) {
            LOGGER.info("{}: ssctasksyncdata BatchTask.doSyncData taskdataSyncRecordEntryEntityDyColl isEmpty.", (Object)this.batchNumber);
            return;
        }
        if (StringUtils.equals((CharSequence)TaskRecordDataChangeTypeEnum.DELETE.getCode(), (CharSequence)this.dataChangeType)) {
            this.doSyncData((targetEntityNumber, taskIdList) -> {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}: ssctasksyncdata BatchTask.deleteDataBatch. taskId:{}, dataChangeType:{}, targetEntityNumber:{}", new Object[]{this.batchNumber, taskIdList, this.dataChangeType, targetEntityNumber});
                }
                this.deleteData(targetEntityNumber, taskIdList);
            });
        } else if (StringUtils.equals((CharSequence)TaskRecordDataChangeTypeEnum.INSERT.getCode(), (CharSequence)this.dataChangeType)) {
            this.doSyncData((targetEntityNumber, taskIdList) -> {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}: ssctasksyncdata BatchTask.insertDataBatch. taskId:{}, dataChangeType:{}, targetEntityNumber:{}", new Object[]{this.batchNumber, taskIdList, this.dataChangeType, targetEntityNumber});
                }
                this.insertData(targetEntityNumber, taskIdList);
            });
        } else if (StringUtils.equals((CharSequence)TaskRecordDataChangeTypeEnum.UPDATE.getCode(), (CharSequence)this.dataChangeType)) {
            this.doSyncData((targetEntityNumber, taskIdList) -> {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}: ssctasksyncdata BatchTask.updateDataBatch. taskId:{}, dataChangeType:{}, targetEntityNumber:{}", new Object[]{this.batchNumber, taskIdList, this.dataChangeType, targetEntityNumber});
                }
                this.updateData(targetEntityNumber, taskIdList);
            });
        } else {
            LOGGER.info("{}: ssctasksyncdata BatchTask.doSyncData not support dataChangeType:{}", (Object)this.batchNumber, (Object)this.dataChangeType);
        }
    }

    private void doSyncData(TaskDataSyncFunctionInterface function) {
        for (DynamicObject entryentity : this.taskdataSyncRecordEntryEntityDyColl) {
            String targetEntityNumber = entryentity.getString("targetentitynumber");
            List<Long> taskIdList = entryentity.getDynamicObjectCollection("subentryentity").stream().map(subDy -> subDy.getLong("taskid")).collect(Collectors.toList());
            String targetsyncstatus = entryentity.getString("targetsyncstatus");
            if (TaskRecordSyncStatusEnum.isFinish((String)targetsyncstatus)) continue;
            if (BizTaskEntityUtil.isBlankMainQuery(targetEntityNumber)) {
                String tableName = BizTaskEntityService.getInstance().queryBizTaskTableNumberByTaskEntity(targetEntityNumber, this.isProcssing);
                entryentity.set("targetsyncmsg", (Object)String.format("isBlankMainQuery. tableName:%s", tableName));
                continue;
            }
            try {
                function.apply(targetEntityNumber, taskIdList);
                this.cleanCache(targetEntityNumber, taskIdList);
                entryentity.set("targetsyncstatus", (Object)TaskRecordSyncStatusEnum.FINISH.getCode());
                entryentity.set("targetfinishtime", (Object)new Date());
                entryentity.set("targetsyncmsg", (Object)"");
            }
            catch (Exception e) {
                LOGGER.error(this.batchNumber + ": " + e.getMessage(), (Throwable)e);
                entryentity.set("targetsyncstatus", (Object)TaskRecordSyncStatusEnum.FAIL.getCode());
                entryentity.set("targetsyncmsg", (Object)"BatchTask.doSyncData fail.");
                this.syncStatus = false;
            }
        }
    }

    private void cleanCache(String targetEntityNumber, List<Long> taskIdList) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: ssctasksyncdata BatchTask.doSyncData clean cache dataChangeType:{}, targetEntityNumber:{} ", new Object[]{this.batchNumber, this.dataChangeType, targetEntityNumber});
        }
        BatchBizTaskAppCacheFactory.batchRemoveCache((String)this.dataChangeType, (String)targetEntityNumber, taskIdList, (Object)this.batchNumber);
    }
}

