/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.taskdatasync.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.hstc.business.taskdatasync.service.TaskDataSyncFunctionInterface;
import kd.ssc.hstc.common.taskdatasync.enums.TaskRecordSyncStatusEnum;
import org.apache.commons.lang3.ArrayUtils;

public abstract class TaskDataSyncBusinessService {
    private static final Log LOGGER = LogFactory.getLog(TaskDataSyncBusinessService.class);
    private static final Integer BATCH_COUNT = 1000;
    protected final DynamicObject taskdataSyncRecordDy;
    protected final DynamicObjectCollection taskdataSyncRecordEntryEntityDyColl;
    protected final Long batchNumber;
    protected final String taskEntityNumber;
    protected final String dataChangeType;
    protected final int retrycount;
    protected final boolean isProcssing;
    protected boolean syncStatus = true;

    public TaskDataSyncBusinessService(DynamicObject taskdataSyncRecordDy) {
        this.taskdataSyncRecordDy = taskdataSyncRecordDy;
        this.taskdataSyncRecordEntryEntityDyColl = taskdataSyncRecordDy.getDynamicObjectCollection("entryentity");
        this.batchNumber = taskdataSyncRecordDy.getLong("batchnumber");
        this.taskEntityNumber = taskdataSyncRecordDy.getString("taskentitynumber");
        this.dataChangeType = taskdataSyncRecordDy.getString("datachangetype");
        this.retrycount = taskdataSyncRecordDy.getInt("retrycount");
        this.isProcssing = StringUtils.equals((CharSequence)this.taskEntityNumber, (CharSequence)"task_task");
    }

    public DynamicObject syncData() {
        try {
            this.doSyncData();
        }
        catch (Exception e) {
            LOGGER.error(this.batchNumber + ": " + e.getMessage(), (Throwable)e);
            this.taskdataSyncRecordDy.set("syncmsg", (Object)"TaskData.syncData fail.");
            this.syncStatus = false;
        }
        finally {
            this.updateRecord();
        }
        return this.taskdataSyncRecordDy;
    }

    public abstract void doSyncData();

    protected void splitData(String targetEntityNumber, List<Long> idList, TaskDataSyncFunctionInterface function) {
        if (idList.size() > BATCH_COUNT) {
            ArrayList<Long> splitList = new ArrayList<Long>(10);
            for (Long taskId : idList) {
                splitList.add(taskId);
                if (splitList.size() != BATCH_COUNT.intValue()) continue;
                function.apply(targetEntityNumber, splitList);
                splitList.clear();
            }
            if (!splitList.isEmpty()) {
                function.apply(targetEntityNumber, splitList);
            }
        } else {
            function.apply(targetEntityNumber, idList);
        }
    }

    protected void deleteData(String targetEntityNumber, List<Long> idList) {
        this.splitData(targetEntityNumber, idList, this::doDeleteData);
    }

    protected void doDeleteData(String targetEntityNumber, List<Long> idList) {
        MainEntityType targetEataEntityType = MetadataServiceHelper.getDataEntityType((String)targetEntityNumber);
        DeleteServiceHelper.delete((IDataEntityType)targetEataEntityType, (Object[])idList.toArray(new Object[0]));
    }

    protected void insertData(String targetEntityNumber, List<Long> idList) {
        this.splitData(targetEntityNumber, idList, this::doSaveData);
    }

    protected void doSaveData(String targetEntityNumber, List<Long> idList) {
        Set<String> selectPropertiesSet = this.getSelectProperty(targetEntityNumber);
        String selectProperties = String.join((CharSequence)",", selectPropertiesSet);
        Object[] taskDyArr = BusinessDataServiceHelper.load((String)this.taskEntityNumber, (String)selectProperties, (QFilter[])new QFilter[]{this.buildPrimaryQFilter(idList)});
        if (ArrayUtils.isNotEmpty((Object[])taskDyArr)) {
            try {
                DynamicObjectType targetDyType = BusinessDataServiceHelper.newDynamicObject((String)targetEntityNumber).getDynamicObjectType();
                DynamicObject[] targetDyArr = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)targetDyType);
                HashMap targetDyMap = ArrayUtils.isNotEmpty((Object[])taskDyArr) ? Arrays.stream(targetDyArr).collect(Collectors.toMap(targetDy -> targetDy.getLong("id"), targetDy -> targetDy)) : new HashMap(10);
                DynamicObject[] saveDyArr = (DynamicObject[])Arrays.stream(taskDyArr).map(taskDy -> {
                    long taskId = taskDy.getLong("id");
                    DynamicObject targetDy = targetDyMap.getOrDefault(taskId, BusinessDataServiceHelper.newDynamicObject((String)targetEntityNumber));
                    for (String field : selectPropertiesSet) {
                        targetDy.set(field, taskDy.get(field));
                    }
                    targetDy.set("id", (Object)taskId);
                    return targetDy;
                }).toArray(DynamicObject[]::new);
                SaveServiceHelper.save((DynamicObject[])saveDyArr);
            }
            catch (Exception e) {
                LOGGER.error(String.format("%s: sscsynctaskdata targetEntityNumber:%s save error! ", this.batchNumber, targetEntityNumber) + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    protected void updateData(String targetEntityNumber, List<Long> idList) {
        this.splitData(targetEntityNumber, idList, this::doSaveData);
    }

    protected void doUpdateData(String targetEntityNumber, List<Long> idList) {
        Set<String> selectPropertiesSet = this.getSelectProperty(targetEntityNumber);
        String selectProperties = String.join((CharSequence)",", selectPropertiesSet);
        Object[] taskDyArr = BusinessDataServiceHelper.load((String)this.taskEntityNumber, (String)selectProperties, (QFilter[])new QFilter[]{this.buildPrimaryQFilter(idList)});
        Object[] targetDyArr = BusinessDataServiceHelper.load((String)targetEntityNumber, (String)selectProperties, (QFilter[])new QFilter[]{this.buildPrimaryQFilter(idList)});
        if (ArrayUtils.isNotEmpty((Object[])taskDyArr) && ArrayUtils.isNotEmpty((Object[])targetDyArr)) {
            Map<Long, DynamicObject> taskDyMap = Arrays.stream(taskDyArr).collect(Collectors.toMap(taskDy -> taskDy.getLong("id"), taskDy -> taskDy));
            for (Object targetDy : targetDyArr) {
                DynamicObject taskDy2 = taskDyMap.get(targetDy.getLong("id"));
                for (String field : selectPropertiesSet) {
                    targetDy.set(field, taskDy2.get(field));
                }
                targetDy.set("id", taskDy2.get("id"));
            }
            try {
                SaveServiceHelper.update((DynamicObject[])targetDyArr);
            }
            catch (Exception e) {
                LOGGER.error(String.format("%s: sscsynctaskdata targetEntityNumber:%s update error! ", this.batchNumber, targetEntityNumber) + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    protected Set<String> getSelectProperty(String targetEntityNumber) {
        MainEntityType taskEntityType = MetadataServiceHelper.getDataEntityType((String)this.taskEntityNumber);
        MainEntityType targetEntityType = MetadataServiceHelper.getDataEntityType((String)targetEntityNumber);
        Map allFields = targetEntityType.getAllFields();
        Iterator iterator = allFields.entrySet().iterator();
        while (iterator.hasNext()) {
            String taskType;
            Map.Entry entry = iterator.next();
            String field = (String)entry.getKey();
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            if (StringUtils.isEmpty((CharSequence)property.getAlias())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}: sscsynctaskdata not support alias field:{}, property:{}", new Object[]{this.batchNumber, field, property.getClass().getSimpleName()});
                }
                iterator.remove();
                continue;
            }
            DynamicProperty taskProperty = taskEntityType.getProperty(field);
            if (taskProperty == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}: sscsynctaskdata getSelectProperty taskEntityNumber:{} has not field:{}. targetEntityNumber:{}", new Object[]{this.batchNumber, this.taskEntityNumber, field, targetEntityNumber});
                }
                iterator.remove();
                continue;
            }
            String targetType = property.getPropertyType().getSimpleName();
            if (StringUtils.equals((CharSequence)targetType, (CharSequence)(taskType = taskProperty.getPropertyType().getSimpleName()))) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}: sscsynctaskdata getSelectProperty taskEntityNumber:{} not match propertyType field:{}. targetEntityNumber:{}, targetType:{}, taskType:{}", new Object[]{this.batchNumber, this.taskEntityNumber, field, targetEntityNumber, targetType, taskType});
            }
            iterator.remove();
        }
        String primaryKey = targetEntityType.getPrimaryKey().getName();
        HashSet<String> resultSet = new HashSet<String>(allFields.keySet());
        resultSet.add(primaryKey);
        return resultSet;
    }

    protected QFilter buildPrimaryQFilter(List<Long> idList) {
        return new QFilter("id", "in", idList);
    }

    protected void updateRecord() {
        if (this.syncStatus) {
            this.taskdataSyncRecordDy.set("syncstatus", (Object)TaskRecordSyncStatusEnum.FINISH.getCode());
            this.taskdataSyncRecordDy.set("taskfinishtime", (Object)new Date());
            this.taskdataSyncRecordDy.set("syncmsg", (Object)"");
        } else {
            this.taskdataSyncRecordDy.set("syncstatus", (Object)TaskRecordSyncStatusEnum.FAIL.getCode());
            this.taskdataSyncRecordDy.set("retrycount", (Object)(this.retrycount + 1));
        }
        SaveServiceHelper.update((DynamicObject)this.taskdataSyncRecordDy);
    }
}

