/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.taskdatasync.util;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;

public class BizTaskEntityUtil {
    private static final Log LOGGER = LogFactory.getLog(BizTaskEntityUtil.class);
    private static final Set<String> BLANK_MAINQUERY = Sets.newHashSet((Object[])new String[]{"task_task", "task_taskhistory"});

    public static boolean isWhiteMainQuery(String targetEntityNumber) {
        return !BizTaskEntityUtil.isBlankMainQuery(targetEntityNumber);
    }

    public static boolean isBlankMainQuery(String targetEntityNumber) {
        if (StringUtils.isEmpty((CharSequence)targetEntityNumber)) {
            return true;
        }
        if (BLANK_MAINQUERY.contains(targetEntityNumber)) {
            return true;
        }
        try {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
            String tableName = dataEntityType.getAlias();
            String dbRouteKey = dataEntityType.getDBRouteKey();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ssctasksyncdata isBlankMainQuery. targetEntityNumber:{}, tableName:{}, dbRouteKey:{}", new Object[]{targetEntityNumber, tableName, dbRouteKey});
            }
            for (String blankMainQueryEntityNumber : BLANK_MAINQUERY) {
                MainEntityType blankMainQueryEntity = EntityMetadataCache.getDataEntityType((String)blankMainQueryEntityNumber);
                if (!StringUtils.equals((CharSequence)tableName, (CharSequence)blankMainQueryEntity.getAlias())) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return true;
        }
        return false;
    }

    public static String getMainEntityFormId(String entityName) {
        QueryEntity queryEntity = BizTaskEntityUtil.getQueryEntity(entityName);
        if (queryEntity == null) {
            return null;
        }
        return queryEntity.getEntityName();
    }

    public static QueryEntity getQueryEntity(String entityName) {
        String queryEntityName = null;
        Map meta = FormMetadataCache.getListMeta((String)entityName);
        if (meta != null && meta.containsKey(BillList.class.getSimpleName())) {
            String strBillList = (String)meta.get(BillList.class.getSimpleName());
            BillList list = (BillList)ControlTypes.fromJsonString((String)strBillList);
            queryEntityName = list.getEntityId();
        }
        if (StringUtils.isEmpty(queryEntityName)) {
            return null;
        }
        String queryFormId = MetadataDao.getIdByNumber(queryEntityName, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isEmpty((CharSequence)queryFormId)) {
            return null;
        }
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)queryFormId, (MetaCategory)MetaCategory.Entity);
        if (entityMeta == null) {
            return null;
        }
        return (QueryEntity)entityMeta.getRootEntity();
    }
}

