/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.cloudcolla.adjsalfile;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.cloudcolla.adjsalfile.AdjSalFileCollaHelper;
import kd.swc.hcdm.business.cloudcolla.adjsalfile.handler.CollaAdjSalFileHandlerFactory;
import kd.swc.hcdm.business.cloudcolla.adjsalfile.handler.ICollaAdjSalFileHandler;
import kd.swc.hcdm.business.salaryadjfile.AdjFileInfoServiceHelper;
import kd.swc.hsbp.business.cloudcolla.CloudCollaContextHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.AbstractCloudCollaExecutePlugin;
import kd.swc.hsbp.common.vo.CollaRuleExecuteContext;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AdjSalFileCloudCollaExecutePlugin
implements AbstractCloudCollaExecutePlugin {
    private static final Log log = LogFactory.getLog(AdjSalFileCloudCollaExecutePlugin.class);
    private Map<String, List<DynamicObject>> dataList;
    private Long taskCenterId = 0L;
    private CollaRuleExecuteContext executeInfo;
    private Long currentTriggerId = 0L;

    public List<String> afterAssembleData(Map<String, List<DynamicObject>> fieldMapResult, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, String currentTriggerObjectName) {
        log.info("[colla]AdjSalFileCloudCollaExecutePlugin afterAssembleData start...");
        log.info("[colla]AdjSalFileCloudCollaExecutePlugin afterAssembleData ruleEngineData{}", ruleEngineData);
        this.executeInfo = (CollaRuleExecuteContext)commonParams.get("executeInfo");
        this.currentTriggerId = MapUtils.getLong(commonParams, (Object)"currentTriggerId", (Long)0L);
        if (CollectionUtils.isEmpty(fieldRuleResult)) {
            log.info("[colla]AdjSalFileCloudCollaExecutePlugin afterAssembleData fieldRuleResult is empty.");
            return null;
        }
        List datas = fieldRuleResult.getOrDefault(currentTriggerObjectName, new ArrayList(0));
        if (CollectionUtils.isEmpty((Collection)datas)) {
            log.info("[colla]AdjSalFileCloudCollaExecutePlugin afterAssembleData datas is empty.");
            return null;
        }
        DynamicObject file = (DynamicObject)datas.get(0);
        String flowType = (String)commonParams.get("flowType");
        ICollaAdjSalFileHandler handler = CollaAdjSalFileHandlerFactory.create((String)flowType);
        CloudCollaContextHelper contextHelper = CloudCollaContextHelper.getInstance();
        contextHelper.parseAndSetCustomizeResultOnlyFlowOutData(file, commonParams);
        this.dataList = handler.assembleData(file, fieldMapResult, fieldRuleResult, assembleSaveData, commonParams, ruleEngineData);
        this.taskCenterId = AdjSalFileCollaHelper.getTaskCenterId(commonParams);
        log.info("[colla]AdjSalFileCloudCollaExecutePlugin afterAssembleData end...");
        return null;
    }

    public List<String> execute(List<DynamicObject> executeData, Map<String, Object> ruleEngineData) {
        if (CollectionUtils.isEmpty(this.dataList)) {
            log.info("[colla]AdjSalFileCloudCollaExecutePlugin execute saveType is empty.");
            return null;
        }
        SWCDataServiceHelper triggerHelper = new SWCDataServiceHelper("hsbs_triggercolla");
        DynamicObject trigger = triggerHelper.queryOne((Object)this.currentTriggerId);
        List<String> msg = null;
        ArrayList<DynamicObject> waitDisableFiles = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> waitSaveFiles = new ArrayList<DynamicObject>(10);
        for (Map.Entry<String, List<DynamicObject>> entry : this.dataList.entrySet()) {
            String type = entry.getKey();
            List<DynamicObject> files = entry.getValue();
            if (CollectionUtils.isEmpty(files)) continue;
            switch (type) {
                case "DISABLE": {
                    waitDisableFiles.addAll(files);
                    break;
                }
                case "CHANGE": 
                case "NEW": {
                    waitSaveFiles.addAll(files);
                    break;
                }
            }
        }
        if (!CollectionUtils.isEmpty(waitDisableFiles)) {
            log.info("[colla]AdjSalFileCloudCollaExecutePlugin execute loseEffectFile...");
            msg = this.loseEffectFile(waitDisableFiles, this.taskCenterId);
            if (!CollectionUtils.isEmpty(msg)) {
                return msg;
            }
        }
        if (!CollectionUtils.isEmpty(waitSaveFiles)) {
            log.info("[colla]AdjSalFileCloudCollaExecutePlugin execute saveFile...");
            msg = this.saveFile(waitSaveFiles, ruleEngineData, this.taskCenterId, trigger);
            if (!CollectionUtils.isEmpty(msg)) {
                return msg;
            }
        }
        this.writeBackResult(this.dataList);
        return msg;
    }

    private void writeBackResult(Map<String, List<DynamicObject>> dataList) {
        ArrayList tempList = new ArrayList(10);
        dataList.forEach((type, list) -> {
            Set<Long> idSet = list.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
            switch (type) {
                case "DISABLE": {
                    tempList.addAll(this.processTempMap(idSet, "DISABLE"));
                    break;
                }
                case "NEW": {
                    tempList.addAll(this.processTempMap(idSet, "NEW"));
                    break;
                }
                case "DO_NOTHING": {
                    tempList.addAll(this.processTempMap(idSet, "DO_NOTHING"));
                    break;
                }
                case "CHANGE": {
                    tempList.addAll(this.processTempMap(idSet, "CHANGE"));
                    break;
                }
            }
        });
        this.executeInfo.getResult().put("hcdm_adjfileinfo", tempList);
    }

    private List<Map<String, Object>> processTempMap(Set<Long> datas, String type) {
        if (CollectionUtils.isEmpty(datas)) {
            return Collections.emptyList();
        }
        return datas.stream().map(item -> {
            ImmutableMap temp = ImmutableMap.of((Object)"entityNumber", (Object)"hcdm_adjfileinfo", (Object)"type", (Object)type, (Object)"dataId", (Object)item);
            return temp;
        }).collect(Collectors.toList());
    }

    private List<String> saveFile(List<DynamicObject> files, Map<String, Object> ruleEngineData, Long taskCenterId, DynamicObject trigger) {
        HashMap<String, DynamicObject> uniqueCodeObjectMap = new HashMap<String, DynamicObject>(16);
        List para = AdjSalFileCollaHelper.transToSaveParaMap(files, ruleEngineData, (Long)taskCenterId, (DynamicObject)trigger, uniqueCodeObjectMap);
        Map<String, Object> result = null;
        try {
            log.info("[colla]AdjSalFileCloudCollaExecutePlugin saveFile para{}", (Object)para);
            AdjFileInfoServiceHelper helper = new AdjFileInfoServiceHelper();
            result = helper.saveAdjFile(para);
        }
        catch (Exception e) {
            log.error("[colla]AdjSalFileCloudCollaExecutePlugin saveFile error : ", (Throwable)e);
            result = Maps.newLinkedHashMapWithExpectedSize((int)2);
            result.put("success", Boolean.FALSE);
            result.put("message", e.toString());
        }
        log.info("[colla]AdjSalFileCloudCollaExecutePlugin saveFile result{}", (Object)result);
        return this.parseSaveResult(para, result, uniqueCodeObjectMap);
    }

    private List<String> loseEffectFile(List<DynamicObject> files, Long taskCenterId) {
        HashMap uniqueCodeObjectMap = new HashMap(16);
        List fileList = AdjSalFileCollaHelper.transToLoseEffectParaMap(files, uniqueCodeObjectMap);
        Map result = null;
        try {
            log.info("[colla]AdjSalFileCloudCollaExecutePlugin loseEffectFile files{}", (Object)fileList);
            AdjFileInfoServiceHelper helper = new AdjFileInfoServiceHelper();
            result = helper.unableAdjFile("8&" + taskCenterId, true, fileList);
        }
        catch (Exception e) {
            log.error("[colla]AdjSalFileCloudCollaExecutePlugin loseEffectFile error : ", (Throwable)e);
            result = Maps.newLinkedHashMapWithExpectedSize((int)2);
            result.put("success", Boolean.FALSE);
            result.put("message", e.toString());
        }
        log.info("[colla]AdjSalFileCloudCollaExecutePlugin loseEffectFile result{}", (Object)result);
        return this.parseDisableResult(fileList, result);
    }

    private List<String> parseSaveResult(List<Map<String, Object>> dataList, Map<String, Object> result, Map<String, DynamicObject> uniqueCodeObjectMap) {
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        String nullMsg = ResManager.loadKDString((String)"\u66f4\u65b0\u6863\u6848\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"AdjSalFileCloudCollaExecutePlugin_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(result)) {
            return Lists.newArrayList((Object[])new String[]{nullMsg});
        }
        boolean success = MapUtils.getBoolean(result, (Object)"success");
        List fileMsgMap = (List)MapUtils.getObject(result, (Object)"data", Collections.emptyList());
        Map fileResultMap = fileMsgMap.stream().collect(Collectors.toMap(obj -> MapUtils.getString((Map)obj, (Object)"uniquecode"), Function.identity()));
        if (success) {
            for (Map<String, Object> data : dataList) {
                String uniqueCode = MapUtils.getString(data, (Object)"uniquecode");
                DynamicObject dynamicObject = uniqueCodeObjectMap.get(uniqueCode);
                Map fileMsg = (Map)fileResultMap.get(uniqueCode);
                if (dynamicObject == null || dynamicObject.getLong("id") != 0L) continue;
                dynamicObject.set("id", (Object)MapUtils.getLong((Map)fileMsg, (Object)"salaryfileid"));
            }
            return Collections.emptyList();
        }
        ArrayList errorMsgList = Lists.newArrayListWithCapacity((int)dataList.size());
        String errorMsg = MapUtils.getString(result, (Object)"message");
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            errorMsgList.add(errorMsg);
        }
        for (Map<String, Object> data : dataList) {
            List decAdjResultList;
            String uniqueCode = MapUtils.getString(data, (Object)"uniquecode");
            Map fileMsg = (Map)MapUtils.getObject(fileResultMap, (Object)uniqueCode, Collections.emptyMap());
            Boolean fileIsSuccess = MapUtils.getBoolean((Map)fileMsg, (Object)"success", (Boolean)Boolean.FALSE);
            if (fileIsSuccess.booleanValue()) continue;
            String fileErrorMsg = MapUtils.getString((Map)fileMsg, (Object)"errormsg");
            if (SWCStringUtils.isNotEmpty((String)fileErrorMsg)) {
                errorMsgList.add(fileErrorMsg);
            }
            if (CollectionUtils.isEmpty((Collection)(decAdjResultList = (List)MapUtils.getObject((Map)fileMsg, (Object)"decadj_data", Collections.emptyList())))) continue;
            for (Map decAdjResult : decAdjResultList) {
                Boolean isSuccess = MapUtils.getBoolean((Map)decAdjResult, (Object)"success", (Boolean)Boolean.FALSE);
                if (isSuccess.booleanValue()) continue;
                errorMsgList.add(MapUtils.getString((Map)decAdjResult, (Object)"message"));
            }
        }
        if (CollectionUtils.isEmpty((Collection)errorMsgList)) {
            errorMsgList.add(nullMsg);
        }
        return errorMsgList;
    }

    private List<String> parseDisableResult(List<Map<String, Object>> dataList, Map<String, Object> result) {
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        String nullMsg = ResManager.loadKDString((String)"\u5931\u6548\u6863\u6848\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"AdjSalFileCloudCollaExecutePlugin_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(result)) {
            return Lists.newArrayList((Object[])new String[]{nullMsg});
        }
        if (MapUtils.getBoolean(result, (Object)"success", (Boolean)Boolean.FALSE).booleanValue()) {
            return Collections.emptyList();
        }
        List resultData = (List)MapUtils.getObject(result, (Object)"data", Collections.emptyList());
        ArrayList errorMsgList = Lists.newArrayListWithCapacity((int)dataList.size());
        String errorMsg = MapUtils.getString(result, (Object)"message");
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            errorMsgList.add(errorMsg);
        }
        for (Map data : resultData) {
            String fileErrorMsg;
            Boolean fileIsSuccess = MapUtils.getBoolean((Map)data, (Object)"success", (Boolean)Boolean.FALSE);
            if (fileIsSuccess.booleanValue() || !SWCStringUtils.isNotEmpty((String)(fileErrorMsg = MapUtils.getString((Map)data, (Object)"errormsg")))) continue;
            errorMsgList.add(fileErrorMsg);
        }
        if (CollectionUtils.isEmpty((Collection)errorMsgList)) {
            errorMsgList.add(nullMsg);
        }
        return errorMsgList;
    }
}

