/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.business.cal.service.CalResultCoverService;
import kd.swc.hsas.business.cal.service.ResultCoverService;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsas.common.utils.FormulaUtils;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ResultCoverProrationService
extends ResultCoverService {
    private static final Log logger = LogFactory.getLog(ResultCoverProrationService.class);
    private static final String systemType = "swc-hsas-business";
    private static final Pattern PATTERN = Pattern.compile("-?[0-9]+.?[0-9]+");

    @Override
    public void doSaveAndReCal(String versionNo, boolean needBackStatus, Long taskId, String personPageId, String saveType) {
        List<String> waitDeleteIdList = CalResultCoverHelper.getWaitDeleteData(personPageId, taskId);
        Map<String, List<Long>> personIdListCalblockMap = this.saveCoverChangeData(needBackStatus, waitDeleteIdList, saveType, taskId, personPageId);
        this.doReCal(versionNo, personIdListCalblockMap, taskId);
    }

    @Override
    public void doOnlySave(boolean needBackStatus, String saveType, Long taskId, String personPageId) {
        List<String> waitDeleteIdList = CalResultCoverHelper.getWaitDeleteData(personPageId, taskId);
        this.saveCoverChangeData(needBackStatus, waitDeleteIdList, saveType, taskId, personPageId);
    }

    @Override
    public void removeCacheDataByIdList(String curPageIndex, Long taskId, String pageId, List<String> idList) {
        String cacheKeyProration;
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        List personProrationDataList = (List)appCache.get(cacheKeyProration = String.format(Locale.ROOT, "prorationCoverData_%d_%s", taskId, pageId), List.class);
        if (personProrationDataList == null || personProrationDataList.size() == 0) {
            return;
        }
        ArrayList<Map> newDataList = new ArrayList<Map>(10);
        for (Map data : personProrationDataList) {
            if (idList.contains(data.get("idstr"))) continue;
            newDataList.add(data);
        }
        appCache.put(cacheKeyProration, newDataList);
        Map<String, Map<String, Object>> prorationChangeData = CalResultCoverHelper.getProrationChangeDataAllPage(pageId, taskId);
        Map<String, Object> valueDataMap = prorationChangeData.get(curPageIndex);
        if (valueDataMap != null && valueDataMap.size() > 0) {
            for (String personId : idList) {
                valueDataMap.remove(personId);
            }
            CalResultCoverHelper.updateCacheProrationChangeData(prorationChangeData, taskId, pageId);
        }
    }

    @Override
    public void addNewPersonData(List<Long> personIdList, Long taskId, String personPageId) {
        DynamicObjectCollection calPersonData = CalResultCoverHelper.getCalPersonData(personIdList, "2DXPSF5JTISP");
        if (SWCListUtils.isEmpty((List)calPersonData)) {
            return;
        }
        List<Long> validPersonIdList = calPersonData.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById((Long)taskId);
        DynamicObject calRuleHisObj = task.getDynamicObject("calrulev");
        List<DynamicObject> prorationItemDataList = CalResultCoverHelper.getProrationItemDataList(calRuleHisObj.getLong("id"), validPersonIdList, false, taskId);
        if (SWCListUtils.isEmpty(prorationItemDataList)) {
            return;
        }
        List<Map<String, String>> prorationItemCoverDataList = CalResultCoverHelper.assembleProrationItemCoverDataList(taskId, prorationItemDataList, false);
        List<Map<String, String>> cachedProrationItemCoverList = CalResultCoverHelper.getCacheProrationCoverDataList(taskId, personPageId, false);
        List<Map<String, String>> newProrationCoverDataList = this.mergeProrationCoverDataList(prorationItemCoverDataList, cachedProrationItemCoverList);
        CalResultCoverHelper.updateProrationCachePersonDataMap(newProrationCoverDataList, taskId, personPageId);
    }

    @Override
    public void saveOpLogData(List<String> waitDeleteIdList, Long taskId, String personPageId) {
        Map<String, Object> waitDeleteChangeData = this.assembleWaitDeleteChangeData(waitDeleteIdList);
        List<DynamicObject> coverLogDataList = this.assembleCoverLogDataList(null, waitDeleteIdList, true, waitDeleteChangeData, taskId, personPageId);
        logger.info("saveImportLogData_begin");
        long start = System.currentTimeMillis();
        SWCDataServiceHelper logServiceHelper = new SWCDataServiceHelper("hsas_resultcoveroplog");
        Object[] saveResult = logServiceHelper.save(coverLogDataList.toArray(new DynamicObject[coverLogDataList.size()]));
        logger.info("saveImportLogData_finish,count:{},cost:{} ms", (Object)saveResult.length, (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public void exportExcelTemplate(IFormView view, Boolean taxCalEnable) {
        FormShowParameter parameter = view.getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("taskId");
        String pageId = (String)parameter.getCustomParam("pageId");
        Map personSortColumnMap = (Map)parameter.getCustomParam("personSortColumnMap");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "resultCoverImportKey_%d_%s", taskId, pageId);
        List personIdList = (List)appCache.get(cacheKey, List.class);
        List partition = new ArrayList(0);
        if (!SWCListUtils.isEmpty((List)personIdList)) {
            partition = Lists.partition((List)personIdList, (int)500);
        }
        try (SXSSFWorkbook wb = new SXSSFWorkbook(1000);){
            Map exportDescInfo = (Map)SWCJSONUtils.cast((String)parameter.getCustomParam("exportDescInfo").toString(), LinkedHashMap.class);
            String dd = new Date().getTime() + "";
            String exportFileName = MessageFormat.format(ResManager.loadKDString((String)"\u5206\u6bb5\u6570\u636e\u8986\u76d6_\u6570\u636e\u5bfc\u5165\u6a21\u677f_{0}", (String)"ResultCoverProrationService_0", (String)systemType, (Object[])new Object[0]), dd);
            String sheetName = ResManager.loadKDString((String)"\u8986\u76d6\u6570\u636e\u586b\u5199", (String)"ResultCoverProrationService_1", (String)systemType, (Object[])new Object[0]);
            SXSSFSheet sheet = wb.createSheet(sheetName);
            sheet.setRandomAccessWindowSize(-1);
            this.setSheetColumnWidth(sheet, 7);
            this.writeTaskInfoRow(false, sheet, exportDescInfo, true, "1");
            this.writeExportHeadRow(sheet, "1");
            int index = 3;
            long start = System.currentTimeMillis();
            if (!SWCListUtils.isEmpty(partition)) {
                for (List singleList : partition) {
                    List<Map<String, String>> singleDataList = CalResultCoverHelper.getProrationCoverDataForImport(singleList, taskId);
                    personSortColumnMap.put("6", "itemname|asc");
                    personSortColumnMap.put("7", "startdate|asc");
                    CalResultCoverHelper.sortProrationPersonData(personSortColumnMap, singleDataList);
                    index = this.writeExportPersonData(index, sheet, singleDataList);
                }
                logger.info("createCalResultCoverDataSheet cost:{} ms", (Object)(System.currentTimeMillis() - start));
            }
            start = System.currentTimeMillis();
            this.createCalResultCoverDescSheet(wb, taxCalEnable, taskId);
            logger.info("flushAllAndDownload begin");
            this.flushAllAndDownload(wb, exportFileName, view);
            logger.info("flushAllAndDownload end cost:{} ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception exception) {
            logger.error("ResultCoverProrationService  error : ", (Throwable)exception);
            String str = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"ResultCoverProrationService_2", (String)systemType, (Object[])new Object[0]);
            view.showErrorNotification(str + exception.getMessage());
        }
    }

    @Override
    public boolean checkExcelTemplate(List<Map<Integer, String>> dataHead, Long taskId) {
        String memo;
        String coverValueStr;
        String endDateStr;
        String startDateStr;
        String taskNameStr;
        if (SWCListUtils.isEmpty(dataHead) || dataHead.size() < 3) {
            return false;
        }
        Map<Integer, String> taskRowMap = dataHead.get(0);
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById((Long)taskId);
        String taskName = task.getString("name");
        if (!SWCStringUtils.equals((String)taskName, (String)(taskNameStr = taskRowMap.get(1)))) {
            return false;
        }
        Map<Integer, String> headItemMap = dataHead.get(2);
        if (headItemMap.size() < 7) {
            return false;
        }
        String fileNumberStr = headItemMap.get(0);
        if (SWCStringUtils.isNotEmpty((String)fileNumberStr) && fileNumberStr.startsWith("*")) {
            fileNumberStr = fileNumberStr.substring(1);
        }
        String nameStr = headItemMap.get(1);
        String empNumberStr = headItemMap.get(2);
        String itemStr = headItemMap.get(3);
        if (SWCStringUtils.isNotEmpty((String)itemStr) && itemStr.startsWith("*")) {
            itemStr = itemStr.substring(1);
        }
        if (SWCStringUtils.isNotEmpty((String)(startDateStr = headItemMap.get(4))) && startDateStr.startsWith("*")) {
            startDateStr = startDateStr.substring(1);
        }
        if (SWCStringUtils.isNotEmpty((String)(endDateStr = headItemMap.get(5))) && endDateStr.startsWith("*")) {
            endDateStr = endDateStr.substring(1);
        }
        if (SWCStringUtils.isNotEmpty((String)(coverValueStr = headItemMap.get(6))) && coverValueStr.startsWith("*")) {
            coverValueStr = coverValueStr.substring(1);
        }
        return this.checkExcelHead(fileNumberStr, nameStr, empNumberStr, itemStr, startDateStr, endDateStr, coverValueStr, memo = headItemMap.get(7));
    }

    private boolean checkExcelHead(String fileNumberStr, String nameStr, String empNumberStr, String itemStr, String startDateStr, String endDateStr, String coverValueStr, String memo) {
        if (SWCStringUtils.isEmpty((String)fileNumberStr) || !SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"ResultCoverProrationService_13", (String)systemType, (Object[])new Object[0]), (String)fileNumberStr)) {
            return false;
        }
        if (SWCStringUtils.isEmpty((String)nameStr) || !SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u59d3\u540d", (String)"ResultCoverProrationService_14", (String)systemType, (Object[])new Object[0]), (String)nameStr)) {
            return false;
        }
        if (SWCStringUtils.isEmpty((String)empNumberStr) || !SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ResultCoverProrationService_15", (String)systemType, (Object[])new Object[0]), (String)empNumberStr)) {
            return false;
        }
        if (SWCStringUtils.isEmpty((String)itemStr) || !SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee", (String)"ResultCoverProrationService_17", (String)systemType, (Object[])new Object[0]), (String)itemStr)) {
            return false;
        }
        if (SWCStringUtils.isEmpty((String)startDateStr) || !SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u5206\u6bb5\u5f00\u59cb\u65e5\u671f", (String)"ResultCoverProrationService_18", (String)systemType, (Object[])new Object[0]), (String)startDateStr)) {
            return false;
        }
        if (SWCStringUtils.isEmpty((String)endDateStr) || !SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u5206\u6bb5\u7ed3\u675f\u65e5\u671f", (String)"ResultCoverProrationService_19", (String)systemType, (Object[])new Object[0]), (String)endDateStr)) {
            return false;
        }
        if (SWCStringUtils.isEmpty((String)coverValueStr) || !SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u8986\u76d6\u503c", (String)"ResultCoverProrationService_20", (String)systemType, (Object[])new Object[0]), (String)coverValueStr)) {
            return false;
        }
        return !SWCStringUtils.isEmpty((String)memo) && SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u5907\u6ce8", (String)"ResultCoverProrationService_23", (String)systemType, (Object[])new Object[0]), (String)memo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSaveImportResultCoverData(String traceId, int dataIndex, List<Long> needReCalList, int precision, Map<String, Map<String, String>> salaryItemMap, Map<Integer, String> dataHead, List<Map<Integer, String>> dataRow, Long taskId, List<DynamicObject> validCoverDataList, List<Map<String, String>> errDataList, List<DynamicObject> coverLogDataList, Map<Long, List<Long>> importData, Boolean taxCalEnable) {
        long st = System.currentTimeMillis();
        logger.info("ResultCoverProrationService_doSaveImportResultCoverData_begin");
        HashMap<String, Object> prorationChangeData = new HashMap<String, Object>(dataRow.size());
        ArrayList<Map<String, String>> prorationPersonDataList = new ArrayList<Map<String, String>>(dataRow.size());
        try {
            this.assembleResultCoverDataObjs(dataIndex, needReCalList, precision, dataRow, taskId, validCoverDataList, errDataList, coverLogDataList, importData, taxCalEnable, prorationChangeData, prorationPersonDataList);
        }
        catch (Exception exception) {
            logger.error("assembleResultCoverDataObjs_error", (Throwable)exception);
            errDataList.add(this.assembleErrMap(0, true, "", JSON.toJSONString((Object)exception)));
            CalResultCoverHelper.updateImportProgress(traceId, taskId, 0, dataRow.size(), "resultcoverimport_%s");
            return;
        }
        logger.info("CalResultCoverImportTask_assembleResultCoverDataObjs_finish,cost:{} ms", (Object)(System.currentTimeMillis() - st));
        if (importData.size() == 0 || validCoverDataList.size() == 0) {
            CalResultCoverHelper.updateImportProgress(traceId, taskId, 0, errDataList.size(), "prorationcoverimport_%s");
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            List<String> idStrList = prorationChangeData.keySet().stream().collect(Collectors.toList());
            this.clearPersonCoverData(idStrList);
            this.saveImportData(validCoverDataList, "1");
            st = System.currentTimeMillis();
            logger.info("saveCoverLog_begin,coverLogDataList.size:{}", (Object)coverLogDataList.size());
            this.saveResultCoverOpLogData(coverLogDataList);
            logger.info("saveCoverLog_finish,cost:{} ms", (Object)(System.currentTimeMillis() - st));
        }
        CalResultCoverHelper.updateImportProgress(traceId, taskId, validCoverDataList.size(), errDataList.size(), "prorationcoverimport_%s");
    }

    @Override
    public List<Long> getNeedRecalPersonIdList(Long taskId, String pageId) {
        List<String> waitDeleteIdList = CalResultCoverHelper.getWaitDeleteData(pageId, taskId);
        List<Map<String, String>> prorationPersonDataList = CalResultCoverHelper.getCacheProrationCoverDataList(taskId, pageId, false);
        Map<String, Object> prorationChangeData = CalResultCoverHelper.getProrationChangeData(pageId, taskId);
        Map<String, List<Long>> personIdListCalblockMap = this.assemblePersonIdByCalblock(waitDeleteIdList, prorationPersonDataList, prorationChangeData);
        ArrayList<Long> allIdList = new ArrayList<Long>(10);
        personIdListCalblockMap.values().forEach(allIdList::addAll);
        return allIdList;
    }

    @Override
    public boolean checkItemDuplicate(Map<Integer, String> itemMap) {
        return true;
    }

    public void assembleResultCoverDataObjs(int dataIndex, List<Long> needReCalList, int precision, List<Map<Integer, String>> dataRow, Long taskId, List<DynamicObject> validCoverDataList, List<Map<String, String>> errDataList, List<DynamicObject> coverLogDataList, Map<Long, List<Long>> importData, Boolean taxCalEnable, Map<String, Object> prorationChangeData, List<Map<String, String>> prorationPersonDataList) {
        ArrayList<Long> personIdList = new ArrayList<Long>(10);
        HashSet<String> fileNumberSet = new HashSet<String>(16);
        for (Map<Integer, String> row : dataRow) {
            String fileNumber = row.get(0);
            fileNumberSet.add(fileNumber);
        }
        long st = System.currentTimeMillis();
        Map<String, Map<String, String>> taskPersonMap = CalResultCoverHelper.getTaskPersonMap(taskId, personIdList, new ArrayList<String>(fileNumberSet), new ArrayList<Long>(0));
        logger.info("ResultCoverProrationService.getTaskPersonMap_cost:{} ms", (Object)(System.currentTimeMillis() - st));
        if (taskPersonMap.size() == 0) {
            for (Map<Integer, String> row : dataRow) {
                String fileNumber = row.get(0);
                errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, MessageFormat.format(ResManager.loadKDString((String)"\u65e0\u6863\u6848\u7f16\u53f7\uff1a\u201c{0}\u201d\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7533\u8bf7\u6743\u9650\u3002", (String)"ResultCoverProrationService_22", (String)systemType, (Object[])new Object[0]), fileNumber)));
            }
            return;
        }
        st = System.currentTimeMillis();
        Map<Long, String> declareStatusMap = CalResultCoverHelper.getCalPersonTaxDeclareStatus(taskId, personIdList);
        Map<String, Object> oldCoverDataMap = CalResultCoverHelper.getOldProrationCoverDataMap(personIdList);
        logger.info("ResultCoverProrationService.getOldCoverDataMap_cost:{} ms", (Object)(System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        Map<Long, Set<Long>> existPersonItemMap = CalResultCoverHelper.assembleExistPersonItemMap(new ArrayList<Long>(personIdList), new ArrayList<Long>(0), "2");
        logger.info("ResultCoverProrationService.assembleExistPersonItemMap_cost:{} ms", (Object)(System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        HashMap<String, Long> salaryItemMap = new HashMap<String, Long>(16);
        List<String> personProrationItemList = this.assembleItemProrationData(taskId, personIdList, salaryItemMap);
        CalResultCoverService service = new CalResultCoverService();
        Map itemDataMap = service.getTaskRuleSalaryItemInfo(taskId.longValue());
        Map<Long, Map<String, String>> salaryItemDataMap = itemDataMap.values().stream().collect(Collectors.toMap(key -> Long.parseLong((String)key.get("itemid")), Function.identity()));
        logger.info("ResultCoverProrationService.assembleItemProrationData_cost:{} ms", (Object)(System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        if (SWCListUtils.isEmpty(personProrationItemList)) {
            errDataList.add(this.assembleErrMap(dataIndex, true, "", ResManager.loadKDString((String)"\u8be5\u85aa\u916c\u9879\u76ee\u4e0d\u5728\u5206\u6bb5\u4e8b\u4ef6\u4e2d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_7", (String)systemType, (Object[])new Object[0])));
            return;
        }
        for (Map<Integer, String> row : dataRow) {
            String empNumber;
            String name;
            String fileNumber = row.get(0);
            boolean check = this.checkPerson(declareStatusMap, needReCalList, dataIndex, fileNumber, name = row.get(1), empNumber = row.get(2), taskPersonMap, errDataList, taxCalEnable);
            if (!check) {
                ++dataIndex;
                continue;
            }
            this.dataRowCheckAndAssembleData(importData, coverLogDataList, validCoverDataList, precision, taskId, salaryItemMap, existPersonItemMap, oldCoverDataMap, dataIndex, row, errDataList, taskPersonMap.get(fileNumber), needReCalList, personProrationItemList, prorationChangeData, prorationPersonDataList, salaryItemDataMap);
            ++dataIndex;
        }
        logger.info("checkAndAssembleData_cost:{} ms", (Object)(System.currentTimeMillis() - st));
    }

    private Map<Long, Map<String, String>> assembleSalaryItemDataMap(Set<Long> itemIdSet) {
        HashMap<Long, Map<String, String>> salaryItemMap = new HashMap<Long, Map<String, String>>(itemIdSet.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        String fields = "id,calblock,datatype.storagetype,dataprecision.scale,datalength,dataround.id";
        QFilter filter = new QFilter("id", "in", itemIdSet);
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return salaryItemMap;
        }
        for (DynamicObject obj : dynamicObjects) {
            Map itemMap = salaryItemMap.computeIfAbsent(obj.getLong("id"), single -> new HashMap(16));
            itemMap.put("itemid", obj.getLong("id") + "");
            itemMap.put("calblock", obj.getString("calblock"));
            itemMap.put("datatype", obj.getString("datatype.storagetype"));
            itemMap.put("scale", obj.getString("dataprecision.scale"));
            itemMap.put("datalength", obj.getString("datalength"));
            itemMap.put("dataround", obj.getString("dataround.id"));
        }
        return salaryItemMap;
    }

    private void dataRowCheckAndAssembleData(Map<Long, List<Long>> importData, List<DynamicObject> coverLogDataList, List<DynamicObject> validCoverDataList, int precision, Long taskId, Map<String, Long> salaryItemMap, Map<Long, Set<Long>> existPersonItemMap, Map<String, Object> oldCoverDataMap, int dataIndex, Map<Integer, String> row, List<Map<String, String>> errDataList, Map<String, String> personMap, List<Long> needReCalList, List<String> personProrationItemList, Map<String, Object> prorationChangeData, List<Map<String, String>> prorationPersonDataList, Map<Long, Map<String, String>> salaryItemDataMap) {
        long st = System.currentTimeMillis();
        boolean dataCheck = this.checkData(precision, salaryItemMap, existPersonItemMap, dataIndex, row, errDataList, personMap, needReCalList, personProrationItemList, salaryItemDataMap);
        logger.info("ResultCoverProrationService.checkData.cost:{} ms", (Object)(System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        if (!dataCheck) {
            return;
        }
        this.assembleProrationCoverDataObjs(importData, taskId, validCoverDataList, row, salaryItemMap, personMap, prorationChangeData, prorationPersonDataList, salaryItemDataMap);
        this.assembleProrationCoverLogObjs(precision, row, oldCoverDataMap, coverLogDataList, personMap, taskId, salaryItemMap);
        logger.info("ResultCoverProrationService.assembleData.cost:{} ms", (Object)(System.currentTimeMillis() - st));
    }

    private void assembleProrationCoverLogObjs(int precision, Map<Integer, String> row, Map<String, Object> oldCoverDataMap, List<DynamicObject> coverLogDataList, Map<String, String> personMap, Long taskId, Map<String, Long> salaryItemMap) {
        try {
            String itemName = row.get(3);
            String startDate = SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)row.get(4)), (String)"yyyy-MM-dd");
            String endDate = SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)row.get(5)), (String)"yyyy-MM-dd");
            String newValue = row.get(6);
            String memo = row.get(7);
            Long itemId = salaryItemMap.get(itemName);
            String personId = personMap.get("id");
            String salaryfileId = personMap.get("salaryfileid");
            StringBuilder idStrSb = new StringBuilder();
            String idStr = idStrSb.append(personId).append('#').append(itemId).append('#').append(startDate).append('#').append(endDate).toString();
            Object oldValue = oldCoverDataMap.get(idStr);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_resultcoveroplog");
            DynamicObject coverLogObj = this.assembleSingleCoverLogObj(helper, memo, precision, taskId, Long.parseLong(personId), Long.parseLong(salaryfileId), itemId, oldValue, newValue, false, SWCDateTimeUtils.parseDate((String)startDate, (String)"yyyy-MM-dd"), SWCDateTimeUtils.parseDate((String)endDate, (String)"yyyy-MM-dd"), "2");
            coverLogDataList.add(coverLogObj);
        }
        catch (ParseException exception) {
            logger.error("date parse error", (Throwable)exception);
        }
    }

    private void assembleProrationCoverDataObjs(Map<Long, List<Long>> importData, Long taskId, List<DynamicObject> validCoverDataList, Map<Integer, String> row, Map<String, Long> salaryItemMap, Map<String, String> personMap, Map<String, Object> prorationChangeData, List<Map<String, String>> prorationPersonDataList, Map<Long, Map<String, String>> salaryItemDataMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        String itemName = row.get(3);
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = SWCDateTimeUtils.parseDate((String)row.get(4), (String)"yyyy-MM-dd");
            endDate = SWCDateTimeUtils.parseDate((String)row.get(5), (String)"yyyy-MM-dd");
        }
        catch (ParseException exception) {
            logger.error("data parse error", (Throwable)exception);
        }
        String coverValue = row.get(6);
        Long itemId = salaryItemMap.get(itemName);
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        DynamicObject object = helper.generateEmptyDynamicObject();
        Long personId = Long.valueOf(personMap.get("id"));
        object.set("calperson", (Object)personId);
        object.set("salaryfile", (Object)Long.valueOf(personMap.get("salaryfileid")));
        object.set("salaryitem", (Object)itemId);
        object.set("datasource", (Object)"2");
        object.set("covervalue", (Object)coverValue);
        object.set("startdate", (Object)startDate);
        object.set("enddate", (Object)endDate);
        object.set("creator", (Object)currUserId);
        object.set("modifier", (Object)currUserId);
        object.set("createtime", (Object)now);
        object.set("modifytime", (Object)now);
        object.set("caltaskid", (Object)taskId);
        validCoverDataList.add(object);
        List itemIdList = importData.computeIfAbsent(personId, single -> new ArrayList(10));
        itemIdList.add(itemId);
        StringBuilder idStrSb = new StringBuilder();
        String idStr = idStrSb.append(personId).append('#').append(itemId).append('#').append(SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd")).append('#').append(SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd")).toString();
        prorationChangeData.put(idStr, coverValue);
        HashMap<String, String> map = new HashMap<String, String>(16);
        Map<String, String> itemMap = salaryItemDataMap.get(itemId);
        map.put("personid", personId + "");
        map.put("idstr", idStr);
        map.put("itemid", itemId + "");
        map.put("calblock", itemMap.get("calblock"));
        map.put("calstatus", personMap.get("calstatus"));
        prorationPersonDataList.add(map);
    }

    private boolean checkData(int precision, Map<String, Long> salaryItemMap, Map<Long, Set<Long>> existPersonItemMap, int dataIndex, Map<Integer, String> row, List<Map<String, String>> errDataList, Map<String, String> personMap, List<Long> needReCalList, List<String> personProrationItemList, Map<Long, Map<String, String>> salaryItemDataMap) {
        boolean emptyCheck = this.checkEmpty(dataIndex, row, errDataList, personMap, needReCalList);
        if (!emptyCheck) {
            return false;
        }
        boolean allowCheck = this.checkAllowCover(salaryItemMap, salaryItemDataMap, dataIndex, row, errDataList, personMap, needReCalList);
        if (!allowCheck) {
            return false;
        }
        boolean itemCheck = this.checkItemProration(salaryItemMap, dataIndex, row, errDataList, personMap, needReCalList, personProrationItemList);
        if (!itemCheck) {
            return false;
        }
        boolean existSumDataCheck = this.checkExistSumData(salaryItemMap, existPersonItemMap, row, errDataList, personMap, needReCalList, dataIndex);
        if (!existSumDataCheck) {
            return false;
        }
        boolean isNumberCheck = this.checkIsNumber(row, errDataList, personMap, needReCalList, dataIndex);
        if (!isNumberCheck) {
            return false;
        }
        boolean precisionCheck = this.checkPrecision(precision, row, errDataList, personMap, needReCalList, dataIndex);
        if (!precisionCheck) {
            return false;
        }
        boolean memoLengthCheck = this.checkMemoLength(row, errDataList, personMap, needReCalList, dataIndex);
        return memoLengthCheck;
    }

    private boolean checkPrecision(int precision, Map<Integer, String> row, List<Map<String, String>> errDataList, Map<String, String> personMap, List<Long> needReCalList, int dataIndex) {
        String coverValue = row.get(6);
        coverValue = this.numberRemoveZero(coverValue);
        String fileNumber = personMap.get("filenumber");
        String[] split = coverValue.split("\\.");
        if (split[0].length() > 13 || split.length == 2 && split[1].length() > precision) {
            this.removeErrorPerson(personMap, needReCalList);
            String errMsg = ResManager.loadKDString((String)"\u8986\u76d6\u503c\u586b\u5199\u7684\u7cbe\u5ea6\u957f\u5ea6\u8d85\u8fc7\u6838\u7b97\u5e01\u79cd\u7cbe\u5ea6\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_25", (String)systemType, (Object[])new Object[0]);
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, errMsg));
            return false;
        }
        return true;
    }

    private boolean checkIsNumber(Map<Integer, String> row, List<Map<String, String>> errDataList, Map<String, String> personMap, List<Long> needReCalList, int dataIndex) {
        String coverValue = row.get(6);
        String fileNumber = personMap.get("filenumber");
        boolean check = FormulaUtils.isNumber((String)coverValue);
        if (!check) {
            this.removeErrorPerson(personMap, needReCalList);
            String errMsg = ResManager.loadKDString((String)"\u8986\u76d6\u503c\u53ea\u80fd\u586b\u5199\u6570\u5b57\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_21", (String)systemType, (Object[])new Object[0]);
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, errMsg));
            return false;
        }
        return true;
    }

    private boolean checkMemoLength(Map<Integer, String> row, List<Map<String, String>> errDataList, Map<String, String> personMap, List<Long> needReCalList, int dataIndex) {
        boolean check;
        String memo = row.get(7);
        String fileNumber = personMap.get("filenumber");
        boolean bl = check = !SWCStringUtils.isNotEmpty((String)memo) || memo.length() <= 255;
        if (!check) {
            this.removeErrorPerson(personMap, needReCalList);
            String errMsg = ResManager.loadKDString((String)"\u201c\u5907\u6ce8\u201d\u5185\u5bb9\u8d85\u8fc7\u4e86255\u5b57\u7b26\u957f\u5ea6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_24", (String)systemType, (Object[])new Object[0]);
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, errMsg));
            return false;
        }
        return true;
    }

    private String numberRemoveZero(String coverValue) {
        BigDecimal value = new BigDecimal(coverValue);
        String newValue = value.compareTo(BigDecimal.ZERO) == 0 ? "0" : value.stripTrailingZeros().toPlainString();
        return newValue;
    }

    private boolean checkExistSumData(Map<String, Long> salaryItemMap, Map<Long, Set<Long>> existPersonItemMap, Map<Integer, String> row, List<Map<String, String>> errDataList, Map<String, String> personMap, List<Long> needReCalList, int dataIndex) {
        String personId = personMap.get("id");
        String fileNumber = personMap.get("filenumber");
        String itemName = row.get(3);
        Long itemId = salaryItemMap.get(itemName);
        Set<Long> existSumDataPersonSet = existPersonItemMap.get(Long.parseLong(personId));
        if (existSumDataPersonSet != null && existSumDataPersonSet.contains(itemId)) {
            this.removeErrorPerson(personMap, needReCalList);
            String errMsg = MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u5b58\u5728\u6c47\u603b\u503c\u7684\u8986\u76d6\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u518d\u8986\u76d6\u5206\u6bb5\u660e\u7ec6\u503c\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_11", (String)systemType, (Object[])new Object[0]), itemName);
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, errMsg));
            return false;
        }
        return true;
    }

    private boolean checkAllowCover(Map<String, Long> salaryItemMap, Map<Long, Map<String, String>> salaryItemDataMap, int dataIndex, Map<Integer, String> row, List<Map<String, String>> errDataList, Map<String, String> personMap, List<Long> needReCalList) {
        String itemName = row.get(3);
        String fileNumber = personMap.get("filenumber");
        Long itemId = salaryItemMap.get(itemName);
        if (itemId == null || salaryItemDataMap.get(itemId) == null) {
            this.removeErrorPerson(personMap, needReCalList);
            String errMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u5bf9\u5e94\u7684\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u4e0d\u5b58\u5728\u201c{0}\u201d\u6216\u8be5\u85aa\u916c\u9879\u76ee\u4e0d\u5141\u8bb8\u7ed3\u679c\u8986\u76d6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_10", (String)systemType, (Object[])new Object[0]), itemName);
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, errMsg));
            return false;
        }
        Map<String, String> itemMap = salaryItemDataMap.get(itemId);
        String allowResultCover = itemMap.get("allowresultcover");
        if (!SWCStringUtils.equals((String)"1", (String)allowResultCover)) {
            this.removeErrorPerson(personMap, needReCalList);
            String errMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u5bf9\u5e94\u7684\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u4e0d\u5b58\u5728\u201c{0}\u201d\u6216\u8be5\u85aa\u916c\u9879\u76ee\u4e0d\u5141\u8bb8\u7ed3\u679c\u8986\u76d6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_10", (String)systemType, (Object[])new Object[0]), itemName);
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, errMsg));
            return false;
        }
        return true;
    }

    private boolean checkItemProration(Map<String, Long> salaryItemMap, int dataIndex, Map<Integer, String> row, List<Map<String, String>> errDataList, Map<String, String> personMap, List<Long> needReCalList, List<String> personProrationItemList) {
        String personId = personMap.get("id");
        String fileNumber = personMap.get("filenumber");
        String itemName = row.get(3);
        String startDate = null;
        String endDate = null;
        try {
            startDate = SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)row.get(4)), (String)"yyyy-MM-dd");
            endDate = SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)row.get(5)), (String)"yyyy-MM-dd");
        }
        catch (ParseException exception) {
            logger.error("date parse error", (Throwable)exception);
        }
        ArrayList itemIdList = Lists.newArrayListWithCapacity((int)personProrationItemList.size());
        personProrationItemList.stream().forEach(single -> {
            String[] split = single.split("#");
            itemIdList.add(Long.parseLong(split[1]));
        });
        Long itemId = salaryItemMap.get(itemName);
        if (itemId == null || !itemIdList.contains(itemId)) {
            this.removeErrorPerson(personMap, needReCalList);
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, ResManager.loadKDString((String)"\u8be5\u85aa\u916c\u9879\u76ee\u4e0d\u5728\u5206\u6bb5\u4e8b\u4ef6\u4e2d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_7", (String)systemType, (Object[])new Object[0])));
            return false;
        }
        StringBuilder idStrSb = new StringBuilder();
        String idStr = idStrSb.append(personId).append('#').append(itemId).append('#').append(startDate).append('#').append(endDate).toString();
        if (!personProrationItemList.contains(idStr)) {
            this.removeErrorPerson(personMap, needReCalList);
            String errMsg = MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u7684\u201c\u5206\u6bb5\u5f00\u59cb\u65e5\u671f\u201d\u6216\u201c\u5206\u6bb5\u7ed3\u675f\u65e5\u671f\u201d\u4e0e\u5206\u6bb5\u4e8b\u4ef6\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_8", (String)systemType, (Object[])new Object[0]), itemName);
            errDataList.add(this.assembleErrMap(dataIndex, false, row.get(0), errMsg));
            return false;
        }
        return true;
    }

    private boolean checkEmpty(int dataIndex, Map<Integer, String> row, List<Map<String, String>> errDataList, Map<String, String> personMap, List<Long> needReCalList) {
        String itemName = row.get(3);
        if (SWCStringUtils.isEmpty((String)itemName)) {
            this.removeErrorPerson(personMap, needReCalList);
            errDataList.add(this.assembleErrMap(dataIndex, false, row.get(0), ResManager.loadKDString((String)"\u201c\u85aa\u916c\u9879\u76ee\u201d\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_3", (String)systemType, (Object[])new Object[0])));
            return false;
        }
        String startDate = row.get(4);
        if (SWCStringUtils.isEmpty((String)startDate)) {
            this.removeErrorPerson(personMap, needReCalList);
            errDataList.add(this.assembleErrMap(dataIndex, false, row.get(0), ResManager.loadKDString((String)"\u201c\u5206\u6bb5\u5f00\u59cb\u65e5\u671f\u201d\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_4", (String)systemType, (Object[])new Object[0])));
            return false;
        }
        String endDate = row.get(5);
        if (SWCStringUtils.isEmpty((String)endDate)) {
            this.removeErrorPerson(personMap, needReCalList);
            errDataList.add(this.assembleErrMap(dataIndex, false, row.get(0), ResManager.loadKDString((String)"\u201c\u5206\u6bb5\u7ed3\u675f\u65e5\u671f\u201d\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_5", (String)systemType, (Object[])new Object[0])));
            return false;
        }
        String coverValue = row.get(6);
        if (SWCStringUtils.isEmpty((String)coverValue)) {
            this.removeErrorPerson(personMap, needReCalList);
            errDataList.add(this.assembleErrMap(dataIndex, false, row.get(0), ResManager.loadKDString((String)"\u201c\u8986\u76d6\u503c\u201d\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverProrationService_6", (String)systemType, (Object[])new Object[0])));
            return false;
        }
        return true;
    }

    private List<String> assembleItemProrationData(Long taskId, List<Long> personIdList, Map<String, Long> salariItemMap) {
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById((Long)taskId);
        DynamicObject calRuleHisObj = task.getDynamicObject("calrulev");
        List<DynamicObject> personProrationItemObjList = CalResultCoverHelper.getProrationItemDataList(calRuleHisObj.getLong("id"), personIdList, false, taskId);
        ArrayList personProrationItemList = Lists.newArrayListWithCapacity((int)personProrationItemObjList.size());
        for (DynamicObject obj : personProrationItemObjList) {
            StringBuilder idStrSb = new StringBuilder();
            String personId = obj.getString("calpersonid");
            long itemId = obj.getLong("salaryitem.id");
            String itemName = obj.getString("salaryitem.name");
            String startDate = SWCDateTimeUtils.format((Date)obj.getDate("startdate"), (String)"yyyy-MM-dd");
            String endDate = SWCDateTimeUtils.format((Date)obj.getDate("enddate"), (String)"yyyy-MM-dd");
            idStrSb.append(personId).append('#').append(itemId).append('#').append(startDate).append('#').append(endDate);
            personProrationItemList.add(idStrSb.toString());
            salariItemMap.put(itemName, itemId);
        }
        return personProrationItemList;
    }

    private int writeExportPersonData(int dataIndex, SXSSFSheet sheet, List<Map<String, String>> prorationCoverDataList) {
        for (Map<String, String> data : prorationCoverDataList) {
            if (dataIndex > 1000002) break;
            SXSSFRow row = sheet.createRow(dataIndex++);
            String fileNumber = data.get("filenumber");
            String name = data.get("name");
            String empNumber = data.get("empnumber");
            String itemName = data.get("itemname");
            String startDate = data.get("startdate");
            String endDate = data.get("enddate");
            this.addPersonFixedColumnRowData(false, row, fileNumber, name, empNumber, itemName, startDate, endDate);
        }
        return dataIndex;
    }

    public void addPersonFixedColumnRowData(boolean isErrExcel, SXSSFRow row, String fileNumber, String name, String empNumber, String itemName, String startDate, String endDate) {
        SXSSFCell fileNumberCell = row.createCell(isErrExcel ? 1 : 0);
        SXSSFCell nameCell = row.createCell(isErrExcel ? 2 : 1);
        SXSSFCell empNumberCell = row.createCell(isErrExcel ? 3 : 2);
        SXSSFCell itemNameCell = row.createCell(isErrExcel ? 4 : 3);
        SXSSFCell startDateCell = row.createCell(isErrExcel ? 5 : 4);
        SXSSFCell endDateCell = row.createCell(isErrExcel ? 6 : 5);
        fileNumberCell.setCellValue(fileNumber);
        nameCell.setCellValue(name);
        empNumberCell.setCellValue(empNumber);
        itemNameCell.setCellValue(itemName);
        startDateCell.setCellValue(startDate);
        endDateCell.setCellValue(endDate);
    }

    private List<Map<String, String>> mergeProrationCoverDataList(List<Map<String, String>> prorationItemCoverDataList, List<Map<String, String>> cachedProrationItemCoverList) {
        ArrayList<Map<String, String>> validDataList = new ArrayList<Map<String, String>>(10);
        List idStrList = cachedProrationItemCoverList.stream().map(single -> (String)single.get("idstr")).collect(Collectors.toList());
        for (Map<String, String> map : prorationItemCoverDataList) {
            String idstr = map.get("idstr");
            if (idStrList.contains(idstr)) continue;
            validDataList.add(map);
        }
        validDataList.addAll(cachedProrationItemCoverList);
        return validDataList;
    }

    private Map<String, Object> assembleWaitDeleteChangeData(List<String> waitDeleteIdList) {
        HashMap<String, Object> deleteMap = new HashMap<String, Object>(16);
        for (String idStr : waitDeleteIdList) {
            deleteMap.put(idStr, null);
        }
        return deleteMap;
    }

    public List<DynamicObject> assembleCoverLogDataList(Map<String, String> memoChangeData, List<String> waitDeleteIdList, boolean isDelete, Map<String, Object> changeData, Long calTaskId, String personPageId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        List<Map<String, String>> prorationDataList = CalResultCoverHelper.getCacheProrationCoverDataList(calTaskId, personPageId, false);
        Map<Object, Object> personSalaryfileMap = new HashMap(16);
        if (isDelete) {
            personSalaryfileMap = CalResultCoverHelper.getProrationPersonSalaryfileMap(waitDeleteIdList);
        } else {
            for (Map<String, String> data : prorationDataList) {
                personSalaryfileMap.put(Long.valueOf(data.get("personid")), Long.valueOf(data.get("salaryfileid")));
            }
        }
        List<String> idList = changeData.keySet().stream().collect(Collectors.toList());
        Map<String, Object> oldCoverDataMap = CalResultCoverHelper.getOldProrationCoverDataMapByIdStr(idList);
        int precision = this.getTaskCurrencyPrecision(calTaskId);
        try {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_resultcoveroplog");
            for (Map.Entry<String, Object> data : changeData.entrySet()) {
                String idStr = data.getKey();
                Object newValue = data.getValue();
                Object oldValue = oldCoverDataMap.get(idStr);
                String[] split = idStr.split("#");
                Long personId = Long.valueOf(split[0]);
                Long itemId = Long.valueOf(split[1]);
                Date startDate = SWCDateTimeUtils.parseDate((String)split[2], (String)"yyyy-MM-dd");
                Date endDate = SWCDateTimeUtils.parseDate((String)split[3], (String)"yyyy-MM-dd");
                Long salaryfileId = (Long)personSalaryfileMap.get(personId);
                String memo = "";
                if (memoChangeData != null) {
                    memo = memoChangeData.get(idStr);
                }
                DynamicObject coverLogObj = this.assembleSingleCoverLogObj(helper, memo, precision, calTaskId, personId, salaryfileId, itemId, oldValue, newValue, isDelete, startDate, endDate, "1");
                list.add(coverLogObj);
            }
        }
        catch (ParseException exception) {
            logger.error("date parse error", (Throwable)exception);
        }
        return list;
    }

    public DynamicObject assembleSingleCoverLogObj(SWCDataServiceHelper helper, String memo, int precision, Long calTaskId, Long personId, Long salaryfileId, Long itemId, Object itemOldValue, Object itemNewValue, boolean isDelete, Date startDate, Date endDate, String resultCoverType) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        DynamicObject object = helper.generateEmptyDynamicObject();
        if (itemOldValue != null && !SWCStringUtils.equals((String)"null", (String)(itemOldValue + ""))) {
            itemOldValue = new BigDecimal(itemOldValue + "").setScale(precision, 4).toPlainString();
        }
        if (itemNewValue != null && !SWCStringUtils.equals((String)"null", (String)(itemNewValue + ""))) {
            itemNewValue = new BigDecimal(itemNewValue + "").setScale(precision, 4).toPlainString();
        }
        object.set("creator", (Object)currUserId);
        object.set("modifier", (Object)currUserId);
        object.set("createtime", (Object)now);
        object.set("modifytime", (Object)now);
        object.set("caltask", (Object)calTaskId);
        object.set("calperson", (Object)personId);
        object.set("salaryfile", (Object)salaryfileId);
        object.set("salaryitem", (Object)itemId);
        object.set("resultcovertype", (Object)resultCoverType);
        object.set("bisnull", (Object)(itemOldValue == null ? 1 : 0));
        object.set("aisnull", (Object)(itemNewValue == null ? 1 : 0));
        object.set("btextvalue", itemOldValue);
        object.set("atextvalue", isDelete ? "" : itemNewValue);
        object.set("startdate", (Object)startDate);
        object.set("enddate", (Object)endDate);
        object.set("covertype", (Object)"1");
        if (SWCStringUtils.isNotEmpty((String)memo)) {
            object.set("memo", (Object)memo);
        }
        return object;
    }

    public void clearPersonCoverData(List<String> idList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        QFilter filter = CalResultCoverHelper.getProrationQFilterByIdstrList(idList);
        DynamicObjectCollection coverDataObjs = helper.queryOriginalCollection("id,calperson,salaryitem.id,startdate,enddate", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)coverDataObjs)) {
            return;
        }
        ArrayList<Long> dataIdList = new ArrayList<Long>(10);
        for (DynamicObject coverObj : coverDataObjs) {
            StringBuilder idSb = new StringBuilder();
            idSb.append(coverObj.getString("calperson")).append('#').append(coverObj.getString("salaryitem.id")).append('#').append(SWCDateTimeUtils.format((Date)coverObj.getDate("startdate"), (String)"yyyy-MM-dd")).append('#').append(SWCDateTimeUtils.format((Date)coverObj.getDate("enddate"), (String)"yyyy-MM-dd"));
            if (!idList.contains(idSb.toString())) continue;
            dataIdList.add(coverObj.getLong("id"));
        }
        filter = new QFilter("id", "in", dataIdList);
        helper.deleteByFilter(new QFilter[]{filter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Long>> saveCoverChangeData(boolean needBackStatus, List<String> waitDeleteData, String saveType, Long taskId, String personPageId) {
        try (TXHandle txHandle = TX.requiresNew();){
            List<Long> backToUncalList;
            Object split;
            Map<String, Object> prorationChangeData = CalResultCoverHelper.getProrationChangeData(personPageId, taskId);
            Map<String, String> memoChangeData = CalResultCoverHelper.getMemoChangeData(personPageId, taskId);
            List<Map<String, String>> prorationPersonDataList = CalResultCoverHelper.getCacheProrationCoverDataList(taskId, personPageId, false);
            HashMap<Long, String> personCalStatusMap = new HashMap<Long, String>(16);
            for (Map<String, String> map : prorationPersonDataList) {
                personCalStatusMap.put(Long.valueOf(map.get("personid")), map.get("calstatus"));
            }
            HashMap<Long, Long> personSalaryfileMap = new HashMap<Long, Long>(16);
            for (Map<String, String> map : prorationPersonDataList) {
                personSalaryfileMap.put(Long.valueOf(map.get("personid")), Long.valueOf(map.get("salaryfileid")));
            }
            List<String> list = prorationChangeData.keySet().stream().collect(Collectors.toList());
            if (prorationChangeData.size() > 0) {
                SWCDataServiceHelper sWCDataServiceHelper = new SWCDataServiceHelper("hsas_proratecoverdata");
                Iterator coverLogDataList = this.assembleCoverLogDataList(memoChangeData, waitDeleteData, false, prorationChangeData, taskId, personPageId);
                this.clearPersonCoverData(list);
                List<DynamicObject> saveData = this.assembleSaveData(prorationChangeData, sWCDataServiceHelper, saveType, taskId, personSalaryfileMap);
                sWCDataServiceHelper.save(saveData.toArray(new DynamicObject[saveData.size()]));
                logger.info("CalItemOperateLogSaveTask_saveCoverLog_begin");
                this.saveResultCoverOpLogData((List<DynamicObject>)((Object)coverLogDataList));
            }
            HashSet<Long> hashSet = new HashSet<Long>(16);
            for (String delIdStr : waitDeleteData) {
                split = delIdStr.split("#");
                hashSet.add(Long.valueOf(split[0]));
            }
            for (String idStr : list) {
                split = idStr.split("#");
                hashSet.add(Long.valueOf(split[0]));
            }
            ArrayList<Long> caledPersonIdList = new ArrayList<Long>(10);
            List<String> caledStatusList = Arrays.asList(CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode());
            for (Long personId : hashSet) {
                String calStatus = (String)personCalStatusMap.get(personId);
                if (!caledStatusList.contains(calStatus)) continue;
                caledPersonIdList.add(personId);
            }
            Map<String, List<Long>> personIdListCalblockMap = this.assemblePersonIdByCalblock(waitDeleteData, prorationPersonDataList, prorationChangeData);
            if (needBackStatus && !SWCListUtils.isEmpty(caledPersonIdList)) {
                logger.info("doCalBack:personIdList:{}", (Object)personIdListCalblockMap.toString());
                ArrayList<Long> allIdList = new ArrayList<Long>(10);
                personIdListCalblockMap.values().forEach(allIdList::addAll);
                CalResultCoverHelper.doCalBack(taskId, allIdList);
            }
            if (!SWCListUtils.isEmpty(backToUncalList = personIdListCalblockMap.get("0"))) {
                this.updatePersonDataStatus(prorationPersonDataList, backToUncalList);
                CalResultCoverHelper.updateProrationCachePersonDataMap(prorationPersonDataList, taskId, personPageId);
            }
            PayrollTaskHelper.updateCalPayRollTaskStatus((Long)taskId);
            Map<String, List<Long>> map = personIdListCalblockMap;
            return map;
        }
        return new HashMap<String, List<Long>>(0);
    }

    private void updatePersonDataStatus(List<Map<String, String>> prorationPersonDataList, List<Long> personIdList) {
        for (Map<String, String> personMap : prorationPersonDataList) {
            long personId = Long.parseLong(personMap.get("personid"));
            if (!personIdList.contains(personId)) continue;
            personMap.put("calstatus", CalStateEnum.UNCAL.getCode());
        }
    }

    private Map<String, List<Long>> assemblePersonIdByCalblock(List<String> waitDeleteData, List<Map<String, String>> prorationPersonDataList, Map<String, Object> prorationChangeData) {
        HashMap<String, List<Long>> personCalblockMap = new HashMap<String, List<Long>>(16);
        HashMap<String, String> itemCalblockMap = new HashMap<String, String>(16);
        HashMap<String, String> personStatusMap = new HashMap<String, String>(16);
        prorationPersonDataList.stream().forEach(dataMap -> {
            String personId = (String)dataMap.get("personid");
            String itemId = (String)dataMap.get("itemid");
            String calblock = (String)dataMap.get("calblock");
            String status = (String)dataMap.get("calstatus");
            itemCalblockMap.put(itemId, calblock);
            personStatusMap.put(personId, status);
        });
        ArrayList<Long> backToUncalPersonList = new ArrayList<Long>(10);
        ArrayList<Long> backToPreCaledPersonList = new ArrayList<Long>(10);
        List<String> itemList = this.assembleBackToPreCaledPersonList(backToPreCaledPersonList, backToUncalPersonList, waitDeleteData, itemCalblockMap, personStatusMap, prorationChangeData);
        personCalblockMap.put("1", backToPreCaledPersonList);
        personCalblockMap.put("0", backToUncalPersonList);
        return personCalblockMap;
    }

    private List<String> assembleBackToPreCaledPersonList(List<Long> backToPreCaledPersonList, List<Long> backToUncalPersonList, List<String> waitDeleteData, Map<String, String> itemCalblockMap, Map<String, String> personStatusMap, Map<String, Object> prorationChangeData) {
        List<String> caledStatusList = Arrays.asList(CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode());
        HashMap<Long, Set> personItemCalblockMap = new HashMap<Long, Set>(16);
        waitDeleteData.addAll(prorationChangeData.keySet());
        HashSet<String> itemIdSet = new HashSet<String>(16);
        for (String string : waitDeleteData) {
            String[] split = string.split("#");
            String personId = split[0];
            String calStatus = personStatusMap.get(personId);
            if (!caledStatusList.contains(calStatus)) continue;
            Set calblockSet = personItemCalblockMap.computeIfAbsent(Long.valueOf(personId), valueSet -> new HashSet(16));
            String itemId = split[1];
            String itemCalblock = itemCalblockMap.get(itemId);
            calblockSet.add(itemCalblock);
            itemIdSet.add(itemId);
        }
        for (Map.Entry entry : personItemCalblockMap.entrySet()) {
            Long personId = (Long)entry.getKey();
            Set blockSet = (Set)entry.getValue();
            String status = personStatusMap.get(personId + "");
            if (blockSet.contains("0")) {
                backToUncalPersonList.add(personId);
            }
            if (!SWCStringUtils.equals((String)CalStateEnum.ALL_CALED.getCode(), (String)status) || blockSet.contains("0")) continue;
            backToPreCaledPersonList.add(personId);
        }
        return new ArrayList<String>(itemIdSet);
    }

    public List<DynamicObject> assembleSaveData(Map<String, Object> changeData, SWCDataServiceHelper helper, String saveType, Long calTaskId, Map<Long, Long> personSalaryfileMap) throws Exception {
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(10);
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        for (Map.Entry<String, Object> data : changeData.entrySet()) {
            String idStr = data.getKey();
            Object value = data.getValue();
            String[] split = idStr.split("#");
            if (SWCObjectUtils.isEmpty((Object)value)) continue;
            DynamicObject object = helper.generateEmptyDynamicObject();
            Long personId = Long.valueOf(split[0]);
            Long salaryFileId = personSalaryfileMap.get(personId);
            Long itemId = Long.valueOf(split[1]);
            object.set("caltaskid", (Object)calTaskId);
            object.set("calperson", (Object)personId);
            object.set("salaryfile", (Object)salaryFileId);
            object.set("salaryitem", (Object)itemId);
            object.set("startdate", (Object)SWCDateTimeUtils.parseDate((String)split[2], (String)"yyyy-MM-dd"));
            object.set("enddate", (Object)SWCDateTimeUtils.parseDate((String)split[3], (String)"yyyy-MM-dd"));
            object.set("covervalue", value);
            object.set("datasource", (Object)saveType);
            object.set("creator", (Object)currUserId);
            object.set("modifier", (Object)currUserId);
            object.set("createtime", (Object)now);
            object.set("modifytime", (Object)now);
            saveData.add(object);
        }
        return saveData;
    }

    @Override
    public SXSSFSheet createCalResultCoverDescSheet(SXSSFWorkbook wb, Boolean taxCalEnable, Long taskId) {
        String sheetName = ResManager.loadKDString((String)"\u8986\u76d6\u540e\u5904\u7406\u7b56\u7565", (String)"ResultCoverService_8", (String)systemType, (Object[])new Object[0]);
        SXSSFSheet sheet = wb.createSheet(sheetName);
        this.setDescSheetColumnWidth(sheet);
        this.writeDescSheet(sheet, taxCalEnable, 0);
        this.mergeCell(sheet, 0, 0, 0, 2);
        this.mergeCell(sheet, 6, 6, 0, 2);
        return sheet;
    }
}

