/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.business.cal.service.CalResultCoverService;
import kd.swc.hsas.business.cal.service.ResultCoverService;
import kd.swc.hsas.business.cal.thread.CalResultCoverOperateLogSaveTask;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCNumberValidateUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ResultCoverSumService
extends ResultCoverService {
    private static final Log logger = LogFactory.getLog(ResultCoverSumService.class);
    private static final String systemType = "swc-hsas-business";

    @Override
    public void doSaveAndReCal(String versionNo, boolean needBackStatus, Long taskId, String personPageId, String saveType) {
        List<String> waitDeleteIdList = CalResultCoverHelper.getWaitDeleteData(personPageId, taskId);
        Map<String, List<Long>> personIdListCalblockMap = this.saveCoverChangeData(needBackStatus, waitDeleteIdList, saveType, taskId, personPageId);
        this.doReCal(versionNo, personIdListCalblockMap, taskId);
    }

    @Override
    public void doOnlySave(boolean needBackStatus, String saveType, Long taskId, String personPageId) {
        List<String> waitDeleteIdList = CalResultCoverHelper.getWaitDeleteData(personPageId, taskId);
        this.saveCoverChangeData(needBackStatus, waitDeleteIdList, saveType, taskId, personPageId);
    }

    @Override
    public void removeCacheDataByIdList(String curPageIndex, Long taskId, String pageId, List<String> idList) {
        String cacheKey;
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        Map personSimpleDataMap = (Map)appCache.get(cacheKey = String.format(Locale.ROOT, "personSimpleData_%d_%s", taskId, pageId), Map.class);
        if (personSimpleDataMap == null || personSimpleDataMap.size() == 0) {
            return;
        }
        idList.stream().forEach(personId -> {
            Map cfr_ignored_0 = (Map)personSimpleDataMap.remove(personId);
        });
        appCache.put(cacheKey, (Object)personSimpleDataMap);
        Map<String, Map<String, Map<String, Object>>> changeData = CalResultCoverHelper.getSumChangeDataAllPage(pageId, taskId);
        Map<String, Map<String, Object>> valueDataMap = changeData.get(curPageIndex);
        if (valueDataMap != null && valueDataMap.size() > 0) {
            for (String personId2 : idList) {
                valueDataMap.remove(personId2);
            }
            CalResultCoverHelper.updateCacheChangeData(changeData, taskId, pageId);
        }
    }

    @Override
    public void addNewPersonData(List<Long> personIdList, Long taskId, String personPageId) {
        DynamicObject[] calPersonData = CalResultCoverHelper.getCalPersonData(personIdList, taskId, false, "2DXPSF5JTISP");
        if (calPersonData == null || calPersonData.length == 0) {
            return;
        }
        List<DynamicObject> personObjList = Arrays.asList(calPersonData);
        Map<String, Map<String, String>> calPersonSimpleDataMap = CalResultCoverHelper.assembleCalPersonSimpleDataMap(personObjList, taskId, false);
        Map<String, Map<String, String>> cachePersonDataMap = CalResultCoverHelper.getCachePersonSimpleDataMap(taskId, personPageId, false);
        calPersonSimpleDataMap.putAll(cachePersonDataMap);
        CalResultCoverHelper.updateSumCachePersonDataMap(calPersonSimpleDataMap, taskId, personPageId);
    }

    @Override
    public void saveOpLogData(List<String> waitDeleteIdList, Long taskId, String personPageId) {
        Map<String, Map<String, String>> salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap(taskId, personPageId);
        List<String> itemIdList = salaryItemMap.keySet().stream().collect(Collectors.toList());
        Map<String, Map<String, Object>> waitDeleteChangeData = this.assembleWaitDeleteChangeData(waitDeleteIdList, itemIdList);
        int precision = this.getTaskCurrencyPrecision(taskId);
        List<DynamicObject> coverLogDataList = this.assembleCoverLogDataList(null, precision, salaryItemMap, true, waitDeleteChangeData, taskId, personPageId, itemIdList);
        logger.info("CalItemOperateLogSaveTask_saveCoverLog_begin");
        CalResultCoverOperateLogSaveTask saveLogTask = new CalResultCoverOperateLogSaveTask(coverLogDataList);
        saveLogExecutorService.submit(saveLogTask);
        logger.info("CalItemOperateLogSaveTask_saveCoverLog_end");
    }

    public int assembleResultCoverImportDataObjs(int dataIndex, List<Long> needReCalList, int precision, Map<String, Map<String, String>> salaryItemMap, Map<Integer, String> dataHead, List<Map<Integer, String>> dataRow, Long taskId, List<DynamicObject> validCoverDataList, List<Map<String, String>> errDataList, List<DynamicObject> coverLogDataList, Map<Long, List<Long>> importData, Boolean taxCalEnable) {
        ArrayList<Long> personIdList = new ArrayList<Long>(10);
        ArrayList<Long> resultIdList = new ArrayList<Long>(10);
        ArrayList<String> fileNumberList = new ArrayList<String>(10);
        for (Map<Integer, String> row : dataRow) {
            String fileNumber = row.get(0);
            fileNumberList.add(fileNumber);
        }
        long st = System.currentTimeMillis();
        Map<String, Map<String, String>> taskPersonMap = CalResultCoverHelper.getTaskPersonMap(taskId, personIdList, fileNumberList, resultIdList);
        logger.info("coverService.getTaskPersonMap_cost:{} ms", (Object)(System.currentTimeMillis() - st));
        if (taskPersonMap.size() == 0) {
            for (Map<Integer, String> row : dataRow) {
                String fileNumber = row.get(0);
                errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, MessageFormat.format(ResManager.loadKDString((String)"\u65e0\u6863\u6848\u7f16\u53f7\uff1a\u201c{0}\u201d\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7533\u8bf7\u6743\u9650\u3002", (String)"ResultCoverSumService_15", (String)systemType, (Object[])new Object[0]), fileNumber)));
            }
            return 0;
        }
        st = System.currentTimeMillis();
        Map<Long, String> declareStatusMap = CalResultCoverHelper.getCalPersonTaxDeclareStatus(taskId, personIdList);
        logger.info("coverService.getCalPersonTaxDeclareStatus_cost:{} ms", (Object)(System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        Map<Long, Map<Long, Map<String, Object>>> oldCoverDataMap = this.getOldCoverDataMap(personIdList, null);
        logger.info("coverService.getOldCoverDataMap_cost:{} ms", (Object)(System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        Map<Long, Map<Long, Map<String, Object>>> calDataMap = CalResultCoverHelper.getCalDataMap(taskId, resultIdList);
        logger.info("coverService.getCalDataMap_cost:{} ms", (Object)(System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        List<Long> itemIds = salaryItemMap.values().stream().map(item -> Long.parseLong((String)item.get("itemid"))).collect(Collectors.toList());
        Map<Long, Set<Long>> existPersonItemMap = CalResultCoverHelper.assembleExistPersonItemMap(personIdList, itemIds, "1");
        logger.info("assembleExistPersonItemMap_cost:{} ms", (Object)(System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        SWCDataServiceHelper coverDataHelper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        SWCDataServiceHelper coverLogHelper = new SWCDataServiceHelper("hsas_resultcoveroplog");
        int successCount = 0;
        for (Map<Integer, String> row : dataRow) {
            String fileNumber = row.get(0);
            String name = row.get(1);
            String empNumber = row.get(2);
            String memo = row.get(3);
            int itemIndex = 4;
            if (SWCStringUtils.isEmpty((String)name)) {
                --itemIndex;
            }
            if (SWCStringUtils.isEmpty((String)empNumber)) {
                --itemIndex;
            }
            if (SWCStringUtils.isEmpty((String)memo)) {
                --itemIndex;
            }
            if (SWCStringUtils.isNotEmpty((String)memo) && memo.length() > 255) {
                this.removeErrorPerson(taskPersonMap.get(fileNumber), needReCalList);
                errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, ResManager.loadKDString((String)"\u201c\u5907\u6ce8\u201d\u5185\u5bb9\u8d85\u8fc7\u4e86255\u5b57\u7b26\u957f\u5ea6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverSumService_19", (String)systemType, (Object[])new Object[0])));
                ++dataIndex;
                continue;
            }
            boolean check = this.checkPerson(declareStatusMap, needReCalList, dataIndex, fileNumber, name, empNumber, taskPersonMap, errDataList, taxCalEnable);
            if (!check) {
                ++dataIndex;
                continue;
            }
            if (row.size() <= itemIndex) {
                this.removeErrorPerson(taskPersonMap.get(fileNumber), needReCalList);
                errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4e3a\u4e00\u4e2a\u85aa\u916c\u9879\u76ee\u586b\u5199\u7ed3\u679c\u8986\u76d6\u503c\u3002", (String)"ResultCoverSumService_3", (String)systemType, (Object[])new Object[0])));
                ++dataIndex;
                continue;
            }
            boolean hasErr = this.checkSalaryItemAndAssembleData(coverDataHelper, coverLogHelper, existPersonItemMap, needReCalList, dataIndex, precision, calDataMap, taskId, oldCoverDataMap, row, salaryItemMap, dataHead, validCoverDataList, errDataList, taskPersonMap.get(fileNumber), coverLogDataList, importData, declareStatusMap);
            if (!hasErr) {
                ++successCount;
            }
            ++dataIndex;
        }
        logger.info("checkAndAssembleData_cost:{} ms", (Object)(System.currentTimeMillis() - st));
        return successCount;
    }

    @Override
    public void exportExcelTemplate(IFormView view, Boolean taxCalEnable) {
        FormShowParameter parameter = view.getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("taskId");
        String pageId = (String)parameter.getCustomParam("pageId");
        Map personSortColumnMap = (Map)parameter.getCustomParam("personSortColumnMap");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "resultCoverImportKey_%d_%s", taskId, pageId);
        List personIdList = (List)appCache.get(cacheKey, List.class);
        List partition = new ArrayList(0);
        if (!SWCListUtils.isEmpty((List)personIdList)) {
            partition = Lists.partition((List)personIdList, (int)500);
        }
        try (SXSSFWorkbook wb = new SXSSFWorkbook(1000);){
            String dd = new Date().getTime() + "";
            String exportFileName = MessageFormat.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6_\u6570\u636e\u5bfc\u5165\u6a21\u677f_{0}", (String)"ResultCoverSumService_2", (String)systemType, (Object[])new Object[0]), dd);
            Map exportDescInfo = (Map)SWCJSONUtils.cast((String)parameter.getCustomParam("exportDescInfo").toString(), LinkedHashMap.class);
            String sheetName = ResManager.loadKDString((String)"\u8986\u76d6\u6570\u636e\u586b\u5199", (String)"ResultCoverSumService_0", (String)systemType, (Object[])new Object[0]);
            SXSSFSheet sheet = wb.createSheet(sheetName);
            sheet.setRandomAccessWindowSize(-1);
            this.setSheetColumnWidth(sheet, 3);
            this.writeTaskInfoRow(false, sheet, exportDescInfo, true, "2");
            this.writeExportHeadRow(sheet, "2");
            int index = 3;
            logger.info("writeExportPersonData begin");
            long start = System.currentTimeMillis();
            if (!SWCListUtils.isEmpty(partition)) {
                for (List singleList : partition) {
                    Map<String, Map<String, String>> personDataInfo = CalResultCoverHelper.getPersonDataMap(singleList);
                    personDataInfo = CalResultCoverHelper.sortSumPersonData(personSortColumnMap, personDataInfo);
                    index = this.writeExportPersonData(index, sheet, personDataInfo);
                }
                logger.info("writeExportPersonData end cost:{} ms", (Object)(System.currentTimeMillis() - start));
            }
            this.createCalResultCoverDescSheet(wb, taxCalEnable, taskId);
            this.flushAllAndDownload(wb, exportFileName, view);
        }
        catch (Exception exception) {
            logger.error("ResultCoverSumService  error : ", (Throwable)exception);
            String str = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"ResultCoverSumService_1", (String)systemType, (Object[])new Object[0]);
            view.showErrorNotification(str + exception.getMessage());
        }
    }

    @Override
    public SXSSFSheet createCalResultCoverDescSheet(SXSSFWorkbook wb, Boolean taxCalEnable, Long taskId) {
        String sheetName = ResManager.loadKDString((String)"\u53ef\u8986\u76d6\u85aa\u916c\u9879\u76ee\u5217\u8868\u53ca\u8986\u76d6\u540e\u5904\u7406\u7b56\u7565", (String)"ResultCoverSumService_20", (String)systemType, (Object[])new Object[0]);
        SXSSFSheet sheet = wb.createSheet(sheetName);
        this.setDescSheetColumnWidth(sheet);
        this.writeDescSheet(sheet, taxCalEnable, 2);
        this.writeDescSheetItemInfo(sheet, taskId);
        this.mergeCell(sheet, 0, 0, 2, 4);
        this.mergeCell(sheet, 6, 6, 2, 4);
        return sheet;
    }

    public void writeDescSheetItemInfo(SXSSFSheet sheet, Long taskId) {
        CellStyle commonColumnStyle = this.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), (short)9, true);
        CellStyle boldColumnStyle = this.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), (short)9, true);
        CellStyle yellowColumnStyle = this.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.CENTER, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.LIGHT_ORANGE.getIndex(), true);
        commonColumnStyle.setWrapText(true);
        Font font = sheet.getWorkbook().createFont();
        font.setBold(true);
        boldColumnStyle.setFont(font);
        yellowColumnStyle.setFont(font);
        CalResultCoverService service = new CalResultCoverService();
        Map salaryItemMapTemp = service.getTaskRuleSalaryItemInfo(taskId.longValue());
        SXSSFRow row0 = sheet.getRow(0);
        row0.setHeight((short)400);
        this.addRowCellInfo(row0, 0, commonColumnStyle, ResManager.loadKDString((String)"\u53ef\u8986\u76d6\u7684\u85aa\u916c\u9879\u76ee\u5217\u8868", (String)"ResultCoverSumService_21", (String)systemType, (Object[])new Object[0]));
        SXSSFRow row1 = sheet.getRow(1);
        row1.setHeight((short)400);
        this.addRowCellInfo(row1, 0, yellowColumnStyle, ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u540d\u79f0", (String)"ResultCoverSumService_22", (String)systemType, (Object[])new Object[0]));
        if (salaryItemMapTemp == null || salaryItemMapTemp.size() == 0) {
            return;
        }
        ArrayList itemNameList = new ArrayList(salaryItemMapTemp.size());
        for (Map.Entry entry : salaryItemMapTemp.entrySet()) {
            Map itemDataMap = (Map)entry.getValue();
            String allowResultCover = (String)itemDataMap.get("allowresultcover");
            String itemId = (String)itemDataMap.get("itemid");
            if (!SWCStringUtils.equals((String)"1", (String)allowResultCover) || !SWCStringUtils.isNotEmpty((String)itemId)) continue;
            itemNameList.add(entry.getKey());
        }
        int startRow = 2;
        for (String itemName : itemNameList) {
            SXSSFRow row = sheet.getRow(startRow);
            if (row == null) {
                row = sheet.createRow(startRow);
                row.setHeight((short)400);
            }
            this.addRowCellInfo(row, 0, commonColumnStyle, itemName);
            ++startRow;
        }
    }

    @Override
    public boolean checkExcelTemplate(List<Map<Integer, String>> dataHead, Long taskId) {
        String startDate;
        String taskNameStr;
        if (SWCListUtils.isEmpty(dataHead) || dataHead.size() < 3) {
            return false;
        }
        Map<Integer, String> taskRowMap = dataHead.get(0);
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById((Long)taskId);
        String taskName = task.getString("name");
        if (!SWCStringUtils.equals((String)taskName, (String)(taskNameStr = taskRowMap.get(1)))) {
            return false;
        }
        Map<Integer, String> headItemMap = dataHead.get(2);
        String fileNumberStr = headItemMap.get(0);
        if (SWCStringUtils.isNotEmpty((String)fileNumberStr) && fileNumberStr.startsWith("*")) {
            fileNumberStr = fileNumberStr.substring(1);
        }
        String nameStr = headItemMap.get(1);
        String empNumberStr = headItemMap.get(2);
        String memoStr = headItemMap.get(3);
        if (SWCStringUtils.isEmpty((String)fileNumberStr) || !SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"ResultCoverSumService_11", (String)systemType, (Object[])new Object[0]), (String)fileNumberStr)) {
            return false;
        }
        if (SWCStringUtils.isEmpty((String)nameStr) || !SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u59d3\u540d", (String)"ResultCoverSumService_12", (String)systemType, (Object[])new Object[0]), (String)nameStr)) {
            return false;
        }
        if (SWCStringUtils.isEmpty((String)empNumberStr) || !SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ResultCoverSumService_13", (String)systemType, (Object[])new Object[0]), (String)empNumberStr)) {
            return false;
        }
        if (SWCStringUtils.isEmpty((String)memoStr) || !SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u5907\u6ce8", (String)"ResultCoverSumService_18", (String)systemType, (Object[])new Object[0]), (String)memoStr)) {
            return false;
        }
        String salaryItem = headItemMap.get(4);
        if (SWCStringUtils.isNotEmpty((String)salaryItem) && salaryItem.startsWith("*")) {
            salaryItem = salaryItem.substring(1);
        }
        if (SWCStringUtils.isNotEmpty((String)(startDate = headItemMap.get(5))) && startDate.startsWith("*")) {
            startDate = startDate.substring(1);
        }
        if (SWCStringUtils.isNotEmpty((String)salaryItem) && SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee", (String)"ResultCoverSumService_16", (String)systemType, (Object[])new Object[0]), (String)salaryItem)) {
            return false;
        }
        return !SWCStringUtils.isNotEmpty((String)startDate) || !SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u5206\u6bb5\u5f00\u59cb\u65e5\u671f", (String)"ResultCoverSumService_17", (String)systemType, (Object[])new Object[0]), (String)startDate);
    }

    public void deleteExistCoverData(Map<Long, List<Long>> importData) {
        long st = System.currentTimeMillis();
        ArrayList<Long> coverDataIdList = new ArrayList<Long>(10);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        ArrayList<Long> personIdList = new ArrayList<Long>(10);
        HashSet itemIdSet = new HashSet(16);
        for (Map.Entry<Long, List<Long>> entry : importData.entrySet()) {
            personIdList.add(entry.getKey());
            itemIdSet.addAll(entry.getValue());
        }
        QFilter queryFilter = new QFilter("calperson", "in", personIdList);
        queryFilter.and("salaryitem.id", "in", itemIdSet);
        DynamicObjectCollection queryObjs = helper.queryOriginalCollection("id,calperson,salaryitem.id", new QFilter[]{queryFilter});
        if (SWCListUtils.isEmpty((List)queryObjs)) {
            return;
        }
        for (DynamicObject obj : queryObjs) {
            long personId = obj.getLong("calperson");
            long salaryItemId = obj.getLong("salaryitem.id");
            List<Long> personItemIdList = importData.get(personId);
            if (SWCListUtils.isEmpty(personItemIdList) || !personItemIdList.contains(salaryItemId)) continue;
            coverDataIdList.add(obj.getLong("id"));
        }
        QFilter deleteFilter = new QFilter("id", "in", coverDataIdList);
        helper.deleteByFilter(new QFilter[]{deleteFilter});
        logger.info("deleteExistCoverData_end,cost:{} ms", (Object)(System.currentTimeMillis() - st));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSaveImportResultCoverData(String traceId, int dataIndex, List<Long> needReCalList, int precision, Map<String, Map<String, String>> salaryItemMap, Map<Integer, String> dataHead, List<Map<Integer, String>> dataRow, Long taskId, List<DynamicObject> validCoverDataList, List<Map<String, String>> errDataList, List<DynamicObject> coverLogDataList, Map<Long, List<Long>> importData, Boolean taxCalEnable) {
        long st = System.currentTimeMillis();
        int successCount = 0;
        try {
            successCount = this.assembleResultCoverImportDataObjs(dataIndex, needReCalList, precision, salaryItemMap, dataHead, dataRow, taskId, validCoverDataList, errDataList, coverLogDataList, importData, taxCalEnable);
        }
        catch (Exception exception) {
            logger.error("assembleResultCoverImportDataObjs_error", (Throwable)exception);
            errDataList.add(this.assembleErrMap(0, true, "", JSON.toJSONString((Object)exception)));
            CalResultCoverHelper.updateImportProgress(traceId, taskId, 0, dataRow.size(), "resultcoverimport_%s");
            return;
        }
        logger.info("ResultCoverSumService_assembleResultCoverImportDataObjs_finihs,cost:{} ms", (Object)(System.currentTimeMillis() - st));
        if (importData.size() == 0 || validCoverDataList.size() == 0) {
            CalResultCoverHelper.updateImportProgress(traceId, taskId, 0, errDataList.size(), "resultcoverimport_%s");
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            this.deleteExistCoverData(importData);
            this.saveImportData(validCoverDataList, "2");
            st = System.currentTimeMillis();
            logger.info("saveCoverLog_begin,coverLogDataList.size:{}", (Object)coverLogDataList.size());
            this.saveResultCoverOpLogData(coverLogDataList);
            logger.info("saveSumCoverLog_finish cost:{}", (Object)(System.currentTimeMillis() - st));
        }
        CalResultCoverHelper.updateImportProgress(traceId, taskId, successCount, errDataList.size(), "resultcoverimport_%s");
    }

    @Override
    public List<Long> getNeedRecalPersonIdList(Long taskId, String pageId) {
        List<String> waitDeleteIdList = CalResultCoverHelper.getWaitDeleteData(pageId, taskId);
        Map<String, Map<String, Object>> sumChangeData = CalResultCoverHelper.getSumChangeData(pageId, taskId);
        List<Long> waitDeletePersonIdList = waitDeleteIdList.stream().map(single -> Long.valueOf(single)).collect(Collectors.toList());
        Map<String, Map<String, String>> cacheSalaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap(taskId, pageId);
        Map<String, Map<String, String>> personSimpleDataMap = CalResultCoverHelper.getCachePersonSimpleDataMap(taskId, pageId, false);
        Map<String, List<Long>> personIdListCalblockMap = this.getPersonIdListCalblockMap(cacheSalaryItemMap, sumChangeData, personSimpleDataMap, waitDeletePersonIdList);
        ArrayList<Long> allIdList = new ArrayList<Long>(10);
        personIdListCalblockMap.values().forEach(allIdList::addAll);
        return allIdList;
    }

    @Override
    public boolean checkItemDuplicate(Map<Integer, String> itemMap) {
        ArrayList itemNameList = Lists.newArrayListWithCapacity((int)itemMap.size());
        for (Map.Entry<Integer, String> entry : itemMap.entrySet()) {
            Integer itemIndex = entry.getKey();
            String itemName = entry.getValue();
            if (itemIndex < 4) continue;
            if (itemNameList.contains(itemName)) {
                return false;
            }
            itemNameList.add(itemName);
        }
        return true;
    }

    private int writeExportPersonData(int dataIndex, SXSSFSheet sheet, Map<String, Map<String, String>> personDataInfo) {
        for (Map.Entry<String, Map<String, String>> entry : personDataInfo.entrySet()) {
            SXSSFRow row = sheet.createRow(dataIndex++);
            String fileNumber = entry.getValue().get("filenumber");
            String name = entry.getValue().get("name");
            String empNumber = entry.getValue().get("empnumber");
            this.addPersonFixedColumnRowData(false, row, fileNumber, name, empNumber);
        }
        return dataIndex;
    }

    public void addPersonFixedColumnRowData(boolean isErrExcel, SXSSFRow row, String fileNumber, String name, String empNumber) {
        SXSSFCell fileNumberCell = row.createCell(isErrExcel ? 1 : 0);
        SXSSFCell nameCell = row.createCell(isErrExcel ? 2 : 1);
        SXSSFCell empNumberCell = row.createCell(isErrExcel ? 3 : 2);
        fileNumberCell.setCellValue(fileNumber);
        nameCell.setCellValue(name);
        empNumberCell.setCellValue(empNumber);
    }

    public Map<String, Map<String, Object>> assembleWaitDeleteChangeData(List<String> waitDeletePersonIdList, List<String> itemIdList) {
        HashMap<String, Map<String, Object>> waitDeleteChangeData = new HashMap<String, Map<String, Object>>(16);
        for (String personId : waitDeletePersonIdList) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
            for (String itemId : itemIdList) {
                itemMap.put(itemId, null);
            }
            waitDeleteChangeData.put(personId, itemMap);
        }
        return waitDeleteChangeData;
    }

    public List<DynamicObject> assembleCoverLogDataList(Map<String, String> memoChangeData, int precision, Map<String, Map<String, String>> salaryItemMap, boolean isDelete, Map<String, Map<String, Object>> changeData, Long calTaskId, String personPageId, List<String> itemIdList) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        SWCDataServiceHelper coverLogHelper = new SWCDataServiceHelper("hsas_resultcoveroplog");
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        List<Long> personIdList = changeData.keySet().stream().map(personId -> Long.valueOf(personId)).collect(Collectors.toList());
        List<Long> itemIds = itemIdList.stream().map(single -> Long.valueOf(single)).collect(Collectors.toList());
        Map<Long, Map<Long, Map<String, Object>>> oldCoverDataMap = this.getOldCoverDataMap(personIdList, itemIds);
        if (isDelete) {
            Map<String, Map<String, String>> personSimpleDataMap = CalResultCoverHelper.assembleSumPersonDataMapForView(personIdList, calTaskId, "", personPageId);
            for (Map.Entry<Long, Map<Long, Map<String, Object>>> oldCoverData : oldCoverDataMap.entrySet()) {
                Long personId2 = oldCoverData.getKey();
                Map<Long, Map<String, Object>> coverData = oldCoverData.getValue();
                for (Map.Entry<Long, Map<String, Object>> itemEntry : coverData.entrySet()) {
                    Long itemId = itemEntry.getKey();
                    Map<String, String> itemData = salaryItemMap.get(String.valueOf(itemId));
                    Map<String, Object> itemMap = itemEntry.getValue();
                    Object itemOldValue = this.getOldItemCoverValue(precision, itemData, itemMap);
                    DynamicObject coverLogObj = this.assembleSingleCoverLogObj("", coverLogHelper, currUserId, now, calTaskId, personId2, personSimpleDataMap, itemId, itemOldValue, null, true);
                    list.add(coverLogObj);
                }
            }
        } else {
            Map<String, Map<String, String>> personSimpleDataMap = CalResultCoverHelper.getCachePersonSimpleDataMap(calTaskId, personPageId, false);
            for (Map.Entry<String, Map<String, Object>> changeEntry : changeData.entrySet()) {
                String personId3 = changeEntry.getKey();
                Map<String, Object> itemMap = changeEntry.getValue();
                if (itemMap == null || itemMap.size() == 0) continue;
                String memo = memoChangeData.get(personId3);
                for (Map.Entry<String, Object> itemEntry : itemMap.entrySet()) {
                    Object itemOldValue;
                    String itemKey = itemEntry.getKey();
                    Long itemId = Long.valueOf(itemKey.substring(4));
                    Map<String, String> itemData = salaryItemMap.get(String.valueOf(itemId));
                    Object itemNewValue = this.getNewItemCoverValue(precision, itemData, itemEntry.getValue());
                    if (oldCoverDataMap == null || oldCoverDataMap.size() == 0) {
                        itemOldValue = null;
                    } else {
                        Map oldCoverMap = oldCoverDataMap.getOrDefault(Long.valueOf(personId3), new HashMap(16));
                        itemOldValue = this.getOldItemCoverValue(precision, itemData, (Map)oldCoverMap.get(itemId));
                    }
                    DynamicObject coverLogObj = this.assembleSingleCoverLogObj(memo, coverLogHelper, currUserId, now, calTaskId, Long.valueOf(personId3), personSimpleDataMap, itemId, itemOldValue, itemNewValue, false);
                    list.add(coverLogObj);
                }
            }
        }
        return list;
    }

    public DynamicObject assembleSingleCoverLogObj(String memo, SWCDataServiceHelper helper, long currUserId, Date now, Long calTaskId, Long personId, Map<String, Map<String, String>> personSimpleDataMap, Long itemId, Object itemOldValue, Object itemNewValue, boolean isDelete) {
        DynamicObject object = helper.generateEmptyDynamicObject();
        Map<String, String> personDataMap = personSimpleDataMap.get(String.valueOf(personId));
        object.set("creator", (Object)currUserId);
        object.set("modifier", (Object)currUserId);
        object.set("createtime", (Object)now);
        object.set("modifytime", (Object)now);
        object.set("caltask", (Object)calTaskId);
        object.set("calperson", (Object)personId);
        object.set("salaryfile", (Object)(personDataMap == null ? "" : personDataMap.get("salaryfile")));
        object.set("salaryitem", (Object)itemId);
        object.set("resultcovertype", (Object)"1");
        object.set("bisnull", (Object)(itemOldValue == null ? 1 : 0));
        object.set("aisnull", (Object)(itemNewValue == null ? 1 : 0));
        object.set("btextvalue", itemOldValue);
        object.set("atextvalue", isDelete ? "" : itemNewValue);
        object.set("covertype", (Object)"2");
        object.set("memo", (Object)memo);
        return object;
    }

    public Object getNewItemCoverValue(int precision, Map<String, String> itemData, Object value) {
        if (value == null || SWCStringUtils.isEmpty((String)value.toString()) || itemData == null) {
            return value;
        }
        String dataType = itemData.get("datatype");
        int scale = Integer.parseInt(itemData.get("scale"));
        String dataround = itemData.get("dataround");
        Object newValue = null;
        if (SWCShowType.INT.getCode().equals(dataType) || SWCShowType.NUM.getCode().equals(dataType)) {
            newValue = new BigDecimal(value.toString()).setScale(scale, CalResultCoverHelper.getRoundingMode(Long.parseLong(dataround))).toPlainString();
        } else if (SWCShowType.AMOUNT.getCode().equals(dataType)) {
            newValue = new BigDecimal(value.toString()).setScale(precision).toPlainString();
        } else if (SWCShowType.TEXT.getCode().equals(dataType)) {
            newValue = value;
        } else if (SWCShowType.DATE.getCode().equals(dataType)) {
            if (value instanceof Date) {
                newValue = SWCInteDateTimeUtil.formateDate((Date)((Date)value));
            } else {
                try {
                    newValue = SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)value.toString()), (String)"yyyy-MM-dd");
                }
                catch (ParseException exception) {
                    logger.error("date parse error :{0}", (Throwable)exception);
                }
            }
        }
        return newValue;
    }

    public Object getOldItemCoverValue(int precision, Map<String, String> itemData, Map<String, Object> itemMap) {
        if (itemMap == null) {
            return null;
        }
        String dataType = itemData.get("datatype");
        int scale = Integer.parseInt(itemData.get("scale"));
        String dataround = itemData.get("dataround");
        Object value = null;
        if (SWCShowType.INT.getCode().equals(dataType) || SWCShowType.NUM.getCode().equals(dataType)) {
            value = new BigDecimal(itemMap.get("numvalue").toString()).setScale(scale, CalResultCoverHelper.getRoundingMode(Long.parseLong(dataround))).toPlainString();
        } else if (SWCShowType.AMOUNT.getCode().equals(dataType)) {
            value = new BigDecimal(itemMap.get("calamountvalue").toString()).setScale(precision, CalResultCoverHelper.getRoundingMode(Long.parseLong(dataround))).toPlainString();
        } else if (SWCShowType.TEXT.getCode().equals(dataType)) {
            value = itemMap.get("textvalue");
        } else if (SWCShowType.DATE.getCode().equals(dataType)) {
            try {
                value = SWCInteDateTimeUtil.formateDate((Date)SWCDateTimeUtils.parseDate((String)itemMap.get("datevalue").toString()));
            }
            catch (ParseException exception) {
                logger.error("date parse error :{0}", (Throwable)exception);
            }
        }
        return value;
    }

    public Map<Long, Map<Long, Map<String, Object>>> getOldCoverDataMap(List<Long> personIdList, List<Long> itemIdList) {
        String fields;
        DynamicObjectCollection dynamicObjects;
        HashMap<Long, Map<Long, Map<String, Object>>> oldCoverDataMap = new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        QFilter filter = new QFilter("calperson", "in", personIdList);
        if (!SWCListUtils.isEmpty(itemIdList)) {
            filter.and("salaryitem.id", "in", itemIdList);
        }
        if ((dynamicObjects = helper.queryOriginalCollection(fields = "calperson,salaryitem.id,salaryitem.datatype.storagetype,numvalue,datevalue,textvalue,calamountvalue,datasource", new QFilter[]{filter})) == null || dynamicObjects.size() == 0) {
            return oldCoverDataMap;
        }
        for (DynamicObject object : dynamicObjects) {
            long personId = object.getLong("calperson");
            Map coverDataMap = oldCoverDataMap.getOrDefault(personId, new HashMap(16));
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("itemId", object.getLong("salaryitem.id"));
            data.put("datatype", object.getString("salaryitem.datatype.storagetype"));
            data.put("numvalue", object.getBigDecimal("numvalue"));
            data.put("datevalue", object.getDate("datevalue"));
            data.put("textvalue", object.getString("textvalue"));
            data.put("calamountvalue", object.getBigDecimal("calamountvalue"));
            data.put("datasource", object.getString("datasource"));
            coverDataMap.put(object.getLong("salaryitem.id"), data);
            oldCoverDataMap.put(personId, coverDataMap);
        }
        return oldCoverDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Long>> saveCoverChangeData(boolean needBackStatus, List<String> waitDeleteData, String saveType, Long calTaskId, String personPageId) {
        try (TXHandle txHandle = TX.requiresNew();){
            Map<String, Map<String, String>> cacheSalaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap(calTaskId, personPageId);
            Map<String, Map<String, Object>> sumChangeData = CalResultCoverHelper.getSumChangeData(personPageId, calTaskId);
            Map<String, String> memoChangeData = CalResultCoverHelper.getMemoChangeData(personPageId, calTaskId);
            Map<String, Map<String, String>> personSimpleDataMap = CalResultCoverHelper.getCachePersonSimpleDataMap(calTaskId, personPageId, false);
            Map<String, String> itemTypeMap = cacheSalaryItemMap.values().stream().collect(Collectors.toMap(key -> (String)key.get("itemid"), value -> (String)value.get("datatype")));
            logger.info("itemTypeMap:{}", (Object)SWCJSONUtils.toString(itemTypeMap));
            Set personIdSet = sumChangeData.keySet().stream().map(personId -> Long.valueOf(personId)).collect(Collectors.toSet());
            List<String> itemIdList = itemTypeMap.keySet().stream().collect(Collectors.toList());
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
            List<Long> waitDeletePersonIdList = waitDeleteData.stream().map(single -> Long.valueOf(single)).collect(Collectors.toList());
            personIdSet.addAll(waitDeletePersonIdList);
            if (sumChangeData.size() > 0) {
                int precision = this.getTaskCurrencyPrecision(calTaskId);
                List<DynamicObject> coverLogDataList = this.assembleCoverLogDataList(memoChangeData, precision, cacheSalaryItemMap, false, sumChangeData, calTaskId, personPageId, itemIdList);
                this.clearPersonItemCoverData(sumChangeData);
                List<DynamicObject> saveData = this.assembleSaveData(sumChangeData, personSimpleDataMap, helper, saveType, itemTypeMap, calTaskId);
                helper.save(saveData.toArray(new DynamicObject[saveData.size()]));
                logger.info("CalItemOperateLogSaveTask_saveCoverLog_begin");
                this.saveResultCoverOpLogData(coverLogDataList);
            }
            Map<String, List<Long>> personIdListCalblockMap = this.getPersonIdListCalblockMap(cacheSalaryItemMap, sumChangeData, personSimpleDataMap, waitDeletePersonIdList);
            ArrayList<Long> allIdList = new ArrayList<Long>(10);
            personIdListCalblockMap.values().forEach(allIdList::addAll);
            if (needBackStatus && !SWCListUtils.isEmpty(allIdList)) {
                CalResultCoverHelper.doCalBack(calTaskId, allIdList);
                this.updatePersonDataStatus(personSimpleDataMap, personIdListCalblockMap.get("0"));
                CalResultCoverHelper.updateSumCachePersonDataMap(personSimpleDataMap, calTaskId, personPageId);
            }
            PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
            Map<String, List<Long>> map = personIdListCalblockMap;
            return map;
        }
        return new HashMap<String, List<Long>>(0);
    }

    public void updatePersonDataStatus(Map<String, Map<String, String>> personSimpleDataMap, List<Long> personIdList) {
        for (Map.Entry<String, Map<String, String>> personEntry : personSimpleDataMap.entrySet()) {
            long personId = Long.parseLong(personEntry.getKey());
            if (!personIdList.contains(personId)) continue;
            Map<String, String> personMap = personEntry.getValue();
            personMap.put("calstatus", CalStateEnum.UNCAL.getCode());
        }
    }

    public Map<String, List<Long>> getPersonIdListCalblockMap(Map<String, Map<String, String>> cacheSalaryItemMap, Map<String, Map<String, Object>> sumChangeData, Map<String, Map<String, String>> personSimpleDataMap, List<Long> waitDeletePersonIdList) {
        Map<String, String> itemCalblockMap = cacheSalaryItemMap.values().stream().collect(Collectors.toMap(key -> (String)key.get("itemid"), value -> (String)value.get("calblock")));
        Map<String, String> personStatusMap = personSimpleDataMap.values().stream().collect(Collectors.toMap(key -> (String)key.get("id"), value -> (String)value.get("calstatus")));
        return this.assemblePersonIdByCalblock(itemCalblockMap, waitDeletePersonIdList, personStatusMap, sumChangeData);
    }

    private Map<String, List<Long>> assemblePersonIdByCalblock(Map<String, String> itemCalblockMap, List<Long> waitDeletePersonIdList, Map<String, String> personStatusMap, Map<String, Map<String, Object>> sumChangeData) {
        HashMap<String, List<Long>> personCalblockMap = new HashMap<String, List<Long>>(16);
        ArrayList<Long> backToUncalPersonList = new ArrayList<Long>(10);
        ArrayList<Long> backToPreCaledPersonList = new ArrayList<Long>(10);
        this.assembleBackToPreCaledPersonList(backToPreCaledPersonList, backToUncalPersonList, waitDeletePersonIdList, itemCalblockMap, personStatusMap, sumChangeData);
        personCalblockMap.put("1", backToPreCaledPersonList);
        personCalblockMap.put("0", backToUncalPersonList);
        return personCalblockMap;
    }

    public void assembleBackToPreCaledPersonList(List<Long> backToPreCaledList, List<Long> backToUncalPersonList, List<Long> waitDeletePersonIdList, Map<String, String> itemCalblockMap, Map<String, String> personStatusMap, Map<String, Map<String, Object>> sumChangeData) {
        Object personId;
        String itemCalblock;
        String itemId;
        QFilter qFilter;
        SWCDataServiceHelper helper;
        DynamicObjectCollection dynamicObjects;
        List<String> caledStatusList = Arrays.asList(CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode());
        ArrayList<Long> needBackList = new ArrayList<Long>(10);
        for (Long personId2 : waitDeletePersonIdList) {
            String string = personStatusMap.get(personId2 + "");
            if (!caledStatusList.contains(string)) continue;
            needBackList.add(personId2);
        }
        HashMap<Long, Set> personItemCalblockMap = new HashMap<Long, Set>(16);
        if (!SWCListUtils.isEmpty(needBackList) && !SWCListUtils.isEmpty((List)(dynamicObjects = (helper = new SWCDataServiceHelper("hsas_calresultcoverdata")).queryOriginalCollection("calperson,salaryitem.id", new QFilter[]{qFilter = new QFilter("calperson", "in", needBackList)})))) {
            for (DynamicObject obj : dynamicObjects) {
                long calperson = obj.getLong("calperson");
                Set calblockSet = personItemCalblockMap.computeIfAbsent(calperson, valueSet -> new HashSet(16));
                itemId = obj.getString("salaryitem.id");
                itemCalblock = itemCalblockMap.get(itemId);
                calblockSet.add(itemCalblock);
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : sumChangeData.entrySet()) {
            personId = entry.getKey();
            String status = personStatusMap.get(personId);
            if (!caledStatusList.contains(status)) continue;
            Map<String, Object> itemMap = entry.getValue();
            Set calblockSet = personItemCalblockMap.computeIfAbsent(Long.valueOf((String)personId), valueSet -> new HashSet(16));
            for (String itemIdStr : itemMap.keySet()) {
                itemId = itemIdStr.substring(4);
                itemCalblock = itemCalblockMap.get(itemId);
                calblockSet.add(itemCalblock);
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : personItemCalblockMap.entrySet()) {
            personId = (Long)((Object)entry.getKey());
            Set blockSet = (Set)((Object)entry.getValue());
            String status = personStatusMap.get(personId + "");
            if (blockSet.contains("0")) {
                backToUncalPersonList.add((Long)personId);
            }
            if (!SWCStringUtils.equals((String)CalStateEnum.ALL_CALED.getCode(), (String)status) || blockSet.contains("0")) continue;
            backToPreCaledList.add((Long)personId);
        }
    }

    public void clearPersonItemCoverData(Map<String, Map<String, Object>> changeData) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        ArrayList<Long> coverDataIdList = new ArrayList<Long>(10);
        ArrayList<Long> personIdList = new ArrayList<Long>(10);
        HashSet itemIdSet = new HashSet(16);
        for (Map.Entry<String, Map<String, Object>> entry : changeData.entrySet()) {
            personIdList.add(Long.valueOf(entry.getKey()));
            List itemIdList = entry.getValue().keySet().stream().map(itemKey -> Long.valueOf(itemKey.substring(4))).collect(Collectors.toList());
            itemIdSet.addAll(itemIdList);
        }
        QFilter queryFilter = new QFilter("calperson", "in", personIdList);
        queryFilter.and("salaryitem.id", "in", itemIdSet);
        DynamicObjectCollection queryObjs = helper.queryOriginalCollection("id,calperson,salaryitem.id", new QFilter[]{queryFilter});
        if (SWCListUtils.isEmpty((List)queryObjs)) {
            return;
        }
        for (DynamicObject obj : queryObjs) {
            long personId = obj.getLong("calperson");
            long salaryItemId = obj.getLong("salaryitem.id");
            String itemKey2 = "key_" + salaryItemId;
            Map<String, Object> personItemIdMap = changeData.get(personId + "");
            if (personItemIdMap == null || !personItemIdMap.containsKey(itemKey2)) continue;
            coverDataIdList.add(obj.getLong("id"));
        }
        QFilter deleteFilter = new QFilter("id", "in", coverDataIdList);
        helper.deleteByFilter(new QFilter[]{deleteFilter});
        logger.info("deleteExistCoverData_end");
    }

    public void filterNoNeedReCalData(Map<String, Map<String, String>> personSimpleDataMap, List<Long> personIdList) {
        List<String> needBackStatus = Arrays.asList(CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode());
        for (Map.Entry<String, Map<String, String>> personData : personSimpleDataMap.entrySet()) {
            long personId = Long.parseLong(personData.getKey());
            Map<String, String> dataMap = personData.getValue();
            String calStatus = dataMap.get("calstatus");
            if (needBackStatus.contains(calStatus)) continue;
            personIdList.remove(personId);
        }
    }

    public List<DynamicObject> assembleSaveData(Map<String, Map<String, Object>> changeData, Map<String, Map<String, String>> personSimpleDataMap, SWCDataServiceHelper helper, String saveType, Map<String, String> itemTypeMap, Long calTaskId) throws Exception {
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(10);
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        for (Map.Entry<String, Map<String, Object>> data : changeData.entrySet()) {
            Long personId = Long.valueOf(data.getKey());
            String salaryfile = personSimpleDataMap.get(data.getKey()).get("salaryfile");
            Long salaryFileId = 0L;
            if (SWCStringUtils.isNotEmpty((String)salaryfile)) {
                salaryFileId = Long.valueOf(salaryfile);
            }
            for (Map.Entry<String, Object> itemData : data.getValue().entrySet()) {
                Object value = itemData.getValue();
                if (SWCObjectUtils.isEmpty((Object)value)) continue;
                DynamicObject object = helper.generateEmptyDynamicObject();
                String itemKey = itemData.getKey();
                Long itemId = Long.valueOf(itemKey.substring(4));
                object.set("caltask", (Object)calTaskId);
                object.set("calperson", (Object)personId);
                object.set("salaryfile", (Object)salaryFileId);
                object.set("salaryitem", (Object)itemId);
                object.set("datasource", (Object)saveType);
                object.set("creator", (Object)currUserId);
                object.set("modifier", (Object)currUserId);
                object.set("createtime", (Object)now);
                object.set("modifytime", (Object)now);
                String dataType = itemTypeMap.get(itemId + "");
                if (SWCShowType.TEXT.getCode().equals(dataType)) {
                    object.set("textvalue", value);
                } else if (SWCShowType.INT.getCode().equals(dataType) || SWCShowType.NUM.getCode().equals(dataType)) {
                    object.set("numvalue", value);
                } else if (SWCShowType.AMOUNT.getCode().equals(dataType)) {
                    object.set("calamountvalue", value);
                } else if (SWCShowType.DATE.getCode().equals(dataType)) {
                    logger.info("dateValue:{}", value);
                    object.set("datevalue", value);
                }
                saveData.add(object);
            }
        }
        return saveData;
    }

    private boolean checkSalaryItemAndAssembleData(SWCDataServiceHelper coverDataHelper, SWCDataServiceHelper coverLogHelper, Map<Long, Set<Long>> existPersonItemMap, List<Long> needReCalList, int dataIndex, int precision, Map<Long, Map<Long, Map<String, Object>>> calDataMap, long taskId, Map<Long, Map<Long, Map<String, Object>>> oldCoverDataMap, Map<Integer, String> row, Map<String, Map<String, String>> salaryItemMap, Map<Integer, String> dataHead, List<DynamicObject> validCoverDataList, List<Map<String, String>> errDataList, Map<String, String> personMap, List<DynamicObject> coverLogDataList, Map<Long, List<Long>> importData, Map<Long, String> declareStatusMap) {
        Long itemId;
        Map<String, String> itemMap;
        boolean hasErr = false;
        StringBuilder errSb = new StringBuilder();
        String fileNumber = personMap.get("filenumber");
        Long personId = Long.parseLong(personMap.get("id"));
        Set<Long> existProrationDataItems = existPersonItemMap.get(personId);
        for (Map.Entry<Integer, String> rowEntry : row.entrySet()) {
            if (rowEntry.getKey() < 4) continue;
            String itemName = dataHead.get(rowEntry.getKey());
            if (SWCStringUtils.isEmpty((String)itemName)) {
                this.removeErrorPerson(personMap, needReCalList);
                String msg = ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u5bf9\u5e94\u7684\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u4e0d\u5b58\u5728\u201c{0}\u201d\u85aa\u916c\u9879\u76ee\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverSumService_9", (String)systemType, (Object[])new Object[0]);
                errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, MessageFormat.format(msg, "")));
                return true;
            }
            itemMap = salaryItemMap.get(itemName);
            boolean checked = this.checkItemValue(needReCalList, declareStatusMap, personMap, errSb, itemMap, precision, rowEntry.getValue());
            if (!checked) {
                hasErr = true;
            }
            itemId = Long.valueOf(itemMap.get("itemid"));
            if (existProrationDataItems == null || !existProrationDataItems.contains(itemId)) continue;
            String msg = ResManager.loadKDString((String)"\u5b58\u5728\u5206\u6bb5\u660e\u7ec6\u7684\u8986\u76d6\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u518d\u8986\u76d6\u6c47\u603b\u503c\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ResultCoverSumService_10", (String)systemType, (Object[])new Object[0]);
            errSb.append(itemName).append(msg);
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, errSb.toString()));
            return true;
        }
        if (!hasErr) {
            String memo = row.get(3);
            for (Map.Entry<Integer, String> rowEntry : row.entrySet()) {
                if (rowEntry.getKey() < 4) continue;
                itemMap = salaryItemMap.get(dataHead.get(rowEntry.getKey()));
                String dataType = itemMap.get("datatype");
                itemId = Long.valueOf(itemMap.get("itemid"));
                List itemIdList = importData.getOrDefault(personId, new ArrayList(10));
                itemIdList.add(itemId);
                importData.put(personId, itemIdList);
                this.assembleSingleResultCoverData(coverDataHelper, taskId, personMap, itemId, dataType, rowEntry.getValue(), validCoverDataList);
                this.assembleItemCoverLogData(memo, coverLogHelper, itemMap, precision, calDataMap.get(personId), taskId, oldCoverDataMap.get(personId), personMap, itemId, dataType, rowEntry.getValue(), coverLogDataList);
            }
        }
        if (hasErr && errSb.length() > 0) {
            errSb.append(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5e76\u91cd\u65b0\u586b\u5199\u3002", (String)"CalResultCoverImportTask_17", (String)systemType, (Object[])new Object[0]));
            errDataList.add(this.assembleErrMap(dataIndex, false, fileNumber, errSb.toString()));
        }
        return hasErr;
    }

    public void assembleItemCoverLogData(String memo, SWCDataServiceHelper coverLogHelper, Map<String, String> itemMap, int precision, Map<Long, Map<String, Object>> calDataMap, long taskId, Map<Long, Map<String, Object>> oldCoverDataMap, Map<String, String> personMap, Long itemId, String dataType, String value, List<DynamicObject> coverLogDataList) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        boolean bisnull = true;
        boolean hasCalData = false;
        Map<String, Object> oldDataMap = null;
        Map<String, Object> calData = null;
        if (oldCoverDataMap != null && oldCoverDataMap.get(itemId) != null) {
            bisnull = false;
            oldDataMap = oldCoverDataMap.get(itemId);
        }
        if (calDataMap != null && calDataMap.get(itemId) != null) {
            hasCalData = true;
            calData = calDataMap.get(itemId);
        }
        DynamicObject object = coverLogHelper.generateEmptyDynamicObject();
        object.set("creator", (Object)currUserId);
        object.set("modifier", (Object)currUserId);
        object.set("createtime", (Object)now);
        object.set("modifytime", (Object)now);
        object.set("caltask", (Object)taskId);
        object.set("calperson", (Object)personMap.get("id"));
        object.set("salaryfile", (Object)personMap.get("salaryfileid"));
        object.set("salaryitem", (Object)itemId);
        object.set("resultcovertype", (Object)"2");
        object.set("covertype", (Object)"2");
        object.set("bisnull", (Object)bisnull);
        object.set("aisnull", (Object)(value == null ? 1 : 0));
        object.set("btextvalue", this.getItemOldValue(itemMap, precision, bisnull, dataType, oldDataMap, hasCalData, calData));
        object.set("atextvalue", this.getNewItemCoverValue(precision, itemMap, value));
        if (SWCStringUtils.isNotEmpty((String)memo)) {
            object.set("memo", (Object)memo);
        }
        coverLogDataList.add(object);
    }

    public Object getItemOldValue(Map<String, String> itemMap, int precision, boolean bisnull, String dataType, Map<String, Object> oldDataMap, boolean hasCalData, Map<String, Object> calData) {
        Object oldValue = null;
        int scale = Integer.parseInt(itemMap.get("scale"));
        String dataround = itemMap.get("dataround");
        if (SWCShowType.TEXT.getCode().equals(dataType)) {
            if (!bisnull && oldDataMap != null) {
                oldValue = oldDataMap.get("textvalue");
            } else if (hasCalData) {
                oldValue = calData.get("textvalue");
            }
        } else if (SWCShowType.INT.getCode().equals(dataType) || SWCShowType.NUM.getCode().equals(dataType)) {
            if (!bisnull && oldDataMap != null) {
                oldValue = new BigDecimal(oldDataMap.get("numvalue").toString()).setScale(scale, CalResultCoverHelper.getRoundingMode(Long.parseLong(dataround))).toPlainString();
            } else if (hasCalData) {
                oldValue = new BigDecimal(calData.get("numvalue").toString()).setScale(scale, CalResultCoverHelper.getRoundingMode(Long.parseLong(dataround))).toPlainString();
            }
        } else if (SWCShowType.AMOUNT.getCode().equals(dataType)) {
            if (!bisnull && oldDataMap != null) {
                oldValue = new BigDecimal(oldDataMap.get("calamountvalue").toString()).setScale(precision, CalResultCoverHelper.getRoundingMode(Long.parseLong(dataround))).toPlainString();
            } else if (hasCalData) {
                oldValue = new BigDecimal(calData.get("calamountvalue").toString()).setScale(precision, CalResultCoverHelper.getRoundingMode(Long.parseLong(dataround))).toPlainString();
            }
        } else if (SWCShowType.DATE.getCode().equals(dataType)) {
            try {
                if (!bisnull && oldDataMap != null) {
                    oldValue = SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)oldDataMap.get("datevalue").toString()), (String)"yyyy-MM-dd");
                } else if (hasCalData) {
                    oldValue = SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)calData.get("datevalue").toString()), (String)"yyyy-MM-dd");
                }
            }
            catch (ParseException exception) {
                logger.error("date parse error:{0}", (Throwable)exception);
            }
        }
        return oldValue;
    }

    public void assembleSingleResultCoverData(SWCDataServiceHelper helper, long taskId, Map<String, String> personMap, Long itemId, String dataType, String value, List<DynamicObject> validCoverDataList) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        DynamicObject object = helper.generateEmptyDynamicObject();
        object.set("calperson", (Object)Long.valueOf(personMap.get("id")));
        object.set("salaryfile", (Object)Long.valueOf(personMap.get("salaryfileid")));
        object.set("salaryitem", (Object)itemId);
        object.set("datasource", (Object)"2");
        if (SWCShowType.TEXT.getCode().equals(dataType)) {
            object.set("textvalue", (Object)value);
        } else if (SWCShowType.INT.getCode().equals(dataType) || SWCShowType.NUM.getCode().equals(dataType)) {
            object.set("numvalue", (Object)value);
        } else if (SWCShowType.AMOUNT.getCode().equals(dataType)) {
            object.set("calamountvalue", (Object)value);
        } else if (SWCShowType.DATE.getCode().equals(dataType)) {
            try {
                object.set("datevalue", (Object)SWCDateTimeUtils.parseDate((String)value));
            }
            catch (ParseException exception) {
                logger.error("assembleSingleResultCoverData_parseData_error", (Throwable)exception);
            }
        }
        object.set("creator", (Object)currUserId);
        object.set("modifier", (Object)currUserId);
        object.set("createtime", (Object)now);
        object.set("modifytime", (Object)now);
        object.set("caltask", (Object)taskId);
        validCoverDataList.add(object);
    }

    public boolean checkItemValue(List<Long> needReCalList, Map<Long, String> declareStatusMap, Map<String, String> personMap, StringBuilder errSb, Map<String, String> itemMap, int precision, String value) {
        String dataType = itemMap.get("datatype");
        String itemName = itemMap.get("itemname");
        String calStatus = personMap.get("calstatus");
        String personId = personMap.get("id");
        String declareStatus = declareStatusMap.get(Long.parseLong(personId));
        int scale = Integer.parseInt(itemMap.get("scale"));
        int datalength = Integer.parseInt(itemMap.get("datalength"));
        int hasRadix = value.lastIndexOf(46);
        if (SWCStringUtils.equals((String)CalStateEnum.AUDIT.getCode(), (String)calStatus) || SWCStringUtils.equals((String)"1", (String)declareStatus)) {
            errSb.append(itemName).append('-').append(ResManager.loadKDString((String)"\u8be5\u85aa\u916c\u9879\u76ee\u4e0d\u5141\u8bb8\u8986\u76d6\u7ed3\u679c\u3002", (String)"CalResultCoverImportTask_19", (String)systemType, (Object[])new Object[0]));
            this.removeErrorPerson(personMap, needReCalList);
            return false;
        }
        if (SWCShowType.NUM.getCode().equals(dataType)) {
            boolean numCheck = this.checkNum(errSb, value, itemName, scale, datalength, hasRadix);
            if (!numCheck) {
                this.removeErrorPerson(personMap, needReCalList);
            }
            return numCheck;
        }
        if (SWCShowType.AMOUNT.getCode().equals(dataType)) {
            boolean amountCheck = this.checkAmount(errSb, precision, value, itemName, hasRadix);
            if (!amountCheck) {
                this.removeErrorPerson(personMap, needReCalList);
            }
            return amountCheck;
        }
        if (SWCShowType.DATE.getCode().equals(dataType)) {
            return this.checkDate(errSb, value, itemName, personMap, needReCalList);
        }
        if (SWCShowType.TEXT.getCode().equals(dataType) && value.length() > datalength) {
            errSb.append(itemName).append('-').append(ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u957f\u5ea6\u8d85\u51fa\u8981\u6c42\uff0c\u8d85\u8fc7\u4e86\u85aa\u916c\u9879\u76ee\u4e0a\u8bbe\u7f6e\u7684\u957f\u5ea6\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CalResultCoverImportTask_20", (String)systemType, (Object[])new Object[0]));
            this.removeErrorPerson(personMap, needReCalList);
            return false;
        }
        return true;
    }

    public boolean checkDate(StringBuilder errSb, String value, String itemName, Map<String, String> personMap, List<Long> needReCalList) {
        boolean flag;
        try {
            if (SWCStringUtils.isNotEmpty((String)value)) {
                SWCDateTimeUtils.parseDate((String)value);
            }
            flag = true;
        }
        catch (ParseException exception) {
            logger.error("checkItemValue_error", (Throwable)exception);
            errSb.append(itemName).append('-').append(ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u6570\u636e\u7c7b\u578b\u683c\u5f0f\u586b\u5199\u6709\u8bef\u3002", (String)"CalResultCoverImportTask_4", (String)systemType, (Object[])new Object[0]));
            this.removeErrorPerson(personMap, needReCalList);
            flag = false;
        }
        return flag;
    }

    public boolean checkAmount(StringBuilder errSb, int precision, String value, String itemName, int hasRadix) {
        boolean numeric = SWCNumberValidateUtils.isRealNumber((String)value);
        if (!numeric) {
            errSb.append(itemName).append('-').append(ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u6570\u636e\u7c7b\u578b\u683c\u5f0f\u586b\u5199\u6709\u8bef\u3002", (String)"CalResultCoverImportTask_4", (String)systemType, (Object[])new Object[0]));
            return false;
        }
        if (hasRadix > 0) {
            String radix = value.substring(hasRadix + 1);
            if (radix.length() > precision) {
                errSb.append(itemName).append('-').append(ResManager.loadKDString((String)"\u8be5\u85aa\u916c\u9879\u76ee\u586b\u5199\u7684\u7cbe\u5ea6\u957f\u5ea6\u8d85\u8fc7\u6838\u7b97\u5e01\u79cd\u7cbe\u5ea6\u8981\u6c42\uff1b", (String)"CalResultCoverImportTask_21", (String)systemType, (Object[])new Object[0]));
                return false;
            }
        } else if (value.length() > 13) {
            errSb.append(itemName).append('-').append(ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u586b\u5199\u7cbe\u5ea6\u8fc7\u957f\uff0c\u8d85\u8fc7\u4e86\u85aa\u916c\u9879\u76ee\u4e0a\u8bbe\u7f6e\u7684\u7cbe\u5ea6\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CalResultCoverImportTask_18", (String)systemType, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public boolean checkNum(StringBuilder errSb, String value, String itemName, int scale, int datalength, int hasRadix) {
        boolean check;
        boolean numeric = SWCNumberValidateUtils.isRealNumber((String)value);
        if (!numeric) {
            errSb.append(itemName).append('-').append(ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u6570\u636e\u7c7b\u578b\u683c\u5f0f\u586b\u5199\u6709\u8bef\u3002", (String)"CalResultCoverImportTask_4", (String)systemType, (Object[])new Object[0]));
            return false;
        }
        boolean bl = check = datalength > 0 && value.length() > datalength || datalength == 0 && value.length() > 13;
        if (hasRadix > 0) {
            String radix = value.substring(hasRadix + 1);
            if (scale > 0 && radix.length() > scale) {
                errSb.append(itemName).append('-').append(ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u586b\u5199\u7cbe\u5ea6\u8fc7\u957f\uff0c\u8d85\u8fc7\u4e86\u85aa\u916c\u9879\u76ee\u4e0a\u8bbe\u7f6e\u7684\u7cbe\u5ea6\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CalResultCoverImportTask_18", (String)systemType, (Object[])new Object[0]));
                return false;
            }
        } else if (check) {
            errSb.append(itemName).append('-').append(ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u586b\u5199\u7cbe\u5ea6\u8fc7\u957f\uff0c\u8d85\u8fc7\u4e86\u85aa\u916c\u9879\u76ee\u4e0a\u8bbe\u7f6e\u7684\u7cbe\u5ea6\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CalResultCoverImportTask_18", (String)systemType, (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

