/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.importtaskguide;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsas.business.importtaskguide.utils.ImportTaskUtils;
import kd.swc.hsas.business.payrolltask.helper.PayRollTaskHelper;
import kd.swc.hsas.business.payrolltask.service.PayRollTaskService;
import kd.swc.hsas.common.constants.ImportTaskConstants;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.ImportTaskFailMsgEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDateUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskVO;
import org.jetbrains.annotations.NotNull;

public class DataPreDealService {
    private static final Log logger = LogFactory.getLog(DataPreDealService.class);
    private static final String FAILTYPE_ISEXIST = "0";
    private static final String FAILTYPE_RELATION = "1";
    private int successCount;
    private int failCount;
    private List<String> errorList;
    private DynamicObjectCollection successDataList;
    private DynamicObjectCollection verifyDetailList;
    private DynamicObjectCollection calTaskList;
    private Map<String, DynamicObject> payRollGrpCacheMap;
    private Map<String, DynamicObject> payRollSceCacheMap;
    private Map<String, Long> calRuleCacheMap;
    private Long importTaskId;
    private Long verifyRecordId;

    public DataPreDealService(Long importTaskId, Long cacheKey) {
        this.reset();
        this.importTaskId = importTaskId;
        this.verifyRecordId = cacheKey;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public List<String> getErrorList() {
        return this.errorList;
    }

    private void reset() {
        this.successCount = 0;
        this.failCount = 0;
        this.errorList = new ArrayList<String>(10);
        this.successDataList = new DynamicObjectCollection();
        this.verifyDetailList = new DynamicObjectCollection();
        this.calTaskList = new DynamicObjectCollection();
        this.payRollGrpCacheMap = new HashMap<String, DynamicObject>(16);
        this.payRollSceCacheMap = new HashMap<String, DynamicObject>(16);
        this.calRuleCacheMap = new HashMap<String, Long>(16);
    }

    public void dataPreDealForCommon(List<Long> temporaryIdList) {
        DynamicObject[] temporaryList;
        logger.info("dataPreDealForCommon begin,importTaskId = {}", (Object)this.importTaskId);
        if (ImportTaskUtils.isCancelPreDeal((Long)this.verifyRecordId)) {
            return;
        }
        String fields = "id,datastatus,modifytime,modifier";
        for (DynamicObject temp : temporaryList = this.getTemporaryData(temporaryIdList, fields)) {
            temp.set("datastatus", (Object)FAILTYPE_RELATION);
            temp.set("modifier", (Object)RequestContext.get().getCurrUserId());
            temp.set("modifytime", (Object)new Date());
        }
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
            helper.update(temporaryList);
            this.successCount = temporaryIdList.size();
        }
    }

    public void dataPreDeal(List<Long> temporaryIdList, Long creatorId, String empGroupName) {
        logger.info("dataPreDeal begin,importTaskId = {}", (Object)this.importTaskId);
        if (ImportTaskUtils.isCancelPreDeal((Long)this.verifyRecordId)) {
            return;
        }
        DynamicObjectCollection matchFileList = new DynamicObjectCollection();
        String fields = "id,datastatus,importtask.org.id,caltaskname,payrollgroup,payrollscene,periodtypename,periodname,filenumber,caltask,modifier,modifytime,filenumber,empname,empnumber,empgroup,empgroupname,workstartdate";
        DynamicObject[] temporaryList = this.getTemporaryData(temporaryIdList, fields);
        DynamicObjectCollection temporaryCollection = new DynamicObjectCollection();
        HashSet<Long> payRollGrpIdSet = new HashSet<Long>(16);
        HashSet<String> periodTypeNameSet = new HashSet<String>(16);
        HashSet<String> periodNameSet = new HashSet<String>(16);
        for (DynamicObject temp : temporaryList) {
            periodNameSet.add(temp.getString("periodname"));
            periodTypeNameSet.add(temp.getString("periodtypename"));
            if (SWCStringUtils.isNotEmpty((String)temp.getString("caltaskname"))) {
                if (SWCStringUtils.isEmpty((String)temp.getString("filenumber"))) {
                    matchFileList.add((Object)temp);
                }
                temp.set("datastatus", (Object)FAILTYPE_RELATION);
                temp.set("modifier", (Object)RequestContext.get().getCurrUserId());
                temp.set("modifytime", (Object)new Date());
                this.successDataList.add((Object)temp);
                continue;
            }
            payRollGrpIdSet.add(temp.getLong("payrollgroup.id"));
            temporaryCollection.add((Object)temp);
        }
        Map<String, Long> periodTypeMap = this.getPeriodTypeMap(periodTypeNameSet);
        Map<String, Map<Long, DynamicObject>> periodMap = this.getPeriodMap(periodNameSet);
        this.checkDataForCalTaskNameIsEmpty(temporaryCollection, payRollGrpIdSet, periodTypeMap, periodMap, creatorId, matchFileList);
        if (matchFileList.size() > 0) {
            Map<String, List<DynamicObject>> matchFileMap = matchFileList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("payrollgroup.id") + obj.getLong("payrollscene.id") + obj.getString("periodtypename") + obj.getString("periodname")));
            for (Map.Entry entry : matchFileMap.entrySet()) {
                this.matchSalaryFile((List)entry.getValue(), periodTypeMap, periodMap);
            }
        }
        for (DynamicObject obj2 : this.successDataList) {
            if (!SWCStringUtils.isEmpty((String)obj2.getString("empgroupname")) || !SWCStringUtils.isEmpty((String)obj2.getString("filenumber"))) continue;
            obj2.set("empgroup", (Object)ImportTaskConstants.DEFAULT_EMPGROUPID);
            obj2.set("empgroupname", (Object)empGroupName);
        }
        if (ImportTaskUtils.isCancelPreDeal((Long)this.verifyRecordId)) {
            return;
        }
        this.saveData();
        logger.info("dataPreDeal end,importTaskId={}", (Object)this.importTaskId);
    }

    private void matchSalaryFile(List<DynamicObject> dataList, Map<String, Long> periodTypeMap, Map<String, Map<Long, DynamicObject>> periodMap) {
        DynamicObject tempObj = dataList.get(0);
        Long periodTypeId = periodTypeMap.get(tempObj.getString("periodtypename"));
        if (periodTypeId == null) {
            return;
        }
        Map<Long, DynamicObject> periodInfoMap = periodMap.get(tempObj.getString("periodname"));
        if (periodInfoMap == null) {
            return;
        }
        DynamicObject periodInfo = periodInfoMap.get(periodTypeId);
        if (periodInfo == null) {
            return;
        }
        Set<String> empNumberSet = dataList.stream().map(obj -> obj.getString("empnumber")).collect(Collectors.toSet());
        Map<Long, Long> employeeTemparyRelMap = this.getEmployeeData(empNumberSet, dataList);
        DynamicObjectCollection salaryFileList = this.getSalaryFileList(tempObj.getLong("payrollgroup.id"), employeeTemparyRelMap.keySet());
        if (salaryFileList.size() == 0) {
            return;
        }
        DynamicObject payRollScene = tempObj.getDynamicObject("payrollscene");
        List<Long> fileIdList = salaryFileList.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        if (payRollScene == null) {
            this.matchSalaryFileHisData(fileIdList, periodInfo, dataList, employeeTemparyRelMap);
        } else {
            DynamicObject payRollSceV = this.getPayRollSceV(tempObj.getLong("payrollscene.id"), periodInfo);
            CalPayRollTaskVO payRoll = new CalPayRollTaskVO();
            payRoll.setEnddate(periodInfo.getDate("enddate"));
            payRoll.setStartdate(periodInfo.getDate("startdate"));
            payRoll.setPeriodId(Long.valueOf(periodInfo.getLong("id")));
            payRoll.setPayrollgroupId(Long.valueOf(tempObj.getLong("payrollgroup.id")));
            payRoll.setPayrollsceneId(Long.valueOf(tempObj.getLong("payrollscene.id")));
            payRoll.setPayrollsceneVid(Long.valueOf(payRollSceV.getLong("id")));
            payRoll.setId(Long.valueOf(tempObj.getLong("id")));
            payRoll.setTrackerId(Long.valueOf(RequestContext.get().getCurrUserId()));
            payRoll.setExratedate(periodInfo.getDate("ratedate"));
            payRoll.setPaydate(periodInfo.getDate("paydate"));
            payRoll.setCountryId(Long.valueOf(tempObj.getLong("payrollgroup.country.id")));
            payRoll.setPeriodTypeId(Long.valueOf(tempObj.getLong("payrollscene.periodtype.id")));
            payRoll.setIslimitadd(payRollSceV.getBoolean("islimitadd"));
            String groupcontent = payRollSceV.getString("groupcontent");
            List sceneGroupVOS = (List)JSON.parseObject((String)groupcontent, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            payRoll.setGroups(sceneGroupVOS);
            Date payRollDate = periodInfo.getDate("perioddate");
            int payrollYear = SWCDateTimeUtils.getYear((Date)payRollDate);
            int month = SWCDateTimeUtils.getMonth((Date)payRollDate);
            payRoll.setPayrollmonth(month);
            payRoll.setPayrollyear(payrollYear);
            List salaryFileVidList = CalPersonHelper.getSalaryFileHisByRule(new HashSet<Long>(fileIdList), (CalPayRollTaskVO)payRoll);
            QFilter filter = new QFilter("id", "in", (Object)salaryFileVidList);
            this.setFileNumber(dataList, filter, employeeTemparyRelMap);
        }
    }

    private Map<Long, Long> getEmployeeData(Set<String> empNumberSet, List<DynamicObject> dataList) {
        HashMap<Long, Long> employeeTemparyRelMap = new HashMap<Long, Long>(empNumberSet.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_employee");
        QFilter filter = new QFilter("empnumber", "in", empNumberSet);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        DynamicObjectCollection result = helper.queryOriginalCollection("id,empnumber,startdate", new QFilter[]{filter});
        Map<String, List<DynamicObject>> employeeMap = result.stream().collect(Collectors.groupingBy(obj -> obj.getString("empnumber")));
        List<DynamicObject> employeeList = null;
        DynamicObject matchEmployee = null;
        Date workStartDate = null;
        for (DynamicObject obj2 : dataList) {
            employeeList = employeeMap.get(obj2.getString("empnumber"));
            if (employeeList == null || (matchEmployee = (workStartDate = obj2.getDate("workstartdate")) == null ? employeeList.get(0) : this.matchEmployee(employeeList, workStartDate)) == null) continue;
            employeeTemparyRelMap.put(matchEmployee.getLong("id"), obj2.getLong("id"));
        }
        return employeeTemparyRelMap;
    }

    private DynamicObject matchEmployee(List<DynamicObject> employeeList, Date workStartDate) {
        DynamicObject tempObj = null;
        for (DynamicObject obj : employeeList) {
            if (!SWCDateUtils.isEqual((Date)obj.getDate("startdate"), (Date)workStartDate)) continue;
            tempObj = obj;
            break;
        }
        return tempObj;
    }

    private void matchSalaryFileHisData(List<Long> fileIdList, DynamicObject periodInfo, List<DynamicObject> dataList, Map<Long, Long> employeeTemparyRelMap) {
        Long currentUserId = RequestContext.get().getCurrUserId();
        QFilter filter = new QFilter("boid", "in", fileIdList);
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        filter.and("paystatus", "=", (Object)FAILTYPE_RELATION);
        filter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
        filter.and("bsed", "<=", (Object)periodInfo.getDate("enddate"));
        filter.and("bsled", ">=", (Object)periodInfo.getDate("startdate"));
        List qFilterList = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((long)currentUserId, (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"47150e89000000ac");
        if (qFilterList != null) {
            qFilterList.stream().forEach(obj -> filter.and(obj));
        }
        this.setFileNumber(dataList, filter, employeeTemparyRelMap);
    }

    private void setFileNumber(List<DynamicObject> dataList, QFilter filter, Map<Long, Long> employeeTemparyRelMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObjectCollection fileHisData = helper.queryOriginalCollection("id,number,employee.id", new QFilter[]{filter}, "number asc,bsed desc");
        HashMap<Long, String> fileMap = new HashMap<Long, String>(fileHisData.size());
        HashSet<String> salaryFileNumberSet = new HashSet<String>(fileHisData.size());
        for (DynamicObject obj : fileHisData) {
            if (salaryFileNumberSet.contains(obj.getString("number"))) continue;
            salaryFileNumberSet.add(obj.getString("number"));
            fileMap.put(employeeTemparyRelMap.get(obj.getLong("employee.id")), obj.getString("number"));
        }
        if (fileMap.size() == 0) {
            return;
        }
        String fileNumber = null;
        for (DynamicObject temp : dataList) {
            fileNumber = (String)fileMap.get(temp.getLong("id"));
            if (!SWCStringUtils.isNotEmpty((String)fileNumber)) continue;
            temp.set("filenumber", (Object)fileNumber);
        }
    }

    private DynamicObjectCollection getSalaryFileList(Long payRollGrpId, Set<Long> employeeIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("payrollgroup.id", "=", (Object)payRollGrpId);
        filter.and("employee.id", "in", employeeIdSet);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        return helper.queryOriginalCollection("id", new QFilter[]{filter});
    }

    private DynamicObject[] getTemporaryData(List<Long> temporaryIdList, String fields) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        QFilter filter = new QFilter("id", "in", temporaryIdList);
        return helper.query(fields, new QFilter[]{filter});
    }

    private void saveData() {
        if (ImportTaskUtils.isCancelPreDeal((Long)this.verifyRecordId)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        try (TXHandle txHandle = TX.requiresNew();){
            this.successCount += this.successDataList.size();
            this.failCount += this.verifyDetailList.size();
            if (this.successDataList.size() > 0) {
                helper.update((DynamicObject[])this.successDataList.toArray((Object[])new DynamicObject[this.successDataList.size()]));
            }
            if (this.calTaskList.size() > 0) {
                helper.setEntityName("hsas_calpayrolltask");
                helper.save(this.calTaskList);
            }
            if (this.verifyDetailList.size() > 0) {
                helper.setEntityName("hsas_verifydetail");
                helper.save(this.verifyDetailList);
            }
        }
    }

    private void checkDataForCalTaskNameIsEmpty(DynamicObjectCollection temporaryCollection, Set<Long> payRollGrpIdSet, Map<String, Long> periodTypeMap, Map<String, Map<Long, DynamicObject>> periodMap, Long creatorId, DynamicObjectCollection matchFileList) {
        if (ImportTaskUtils.isCancelPreDeal((Long)this.verifyRecordId)) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_verifydetail");
        Map<Long, Map<Long, DynamicObject>> payRollGrpMap = this.getPayRollGrpMap(payRollGrpIdSet);
        HashSet<Long> payRollSceIdSet = new HashSet<Long>(16);
        payRollGrpIdSet.clear();
        HashSet<Long> periodIdSet = new HashSet<Long>(16);
        Long periodTypeId = null;
        Long payRollSceId = null;
        DynamicObject periodObj = null;
        Map<Long, DynamicObject> tempMap = null;
        DynamicObject payRollGrpEntry = null;
        HashMap<String, List> temporaryMap = new HashMap<String, List>(16);
        List tempList = null;
        String mapKey = null;
        for (DynamicObject temp : temporaryCollection) {
            periodTypeId = periodTypeMap.get(temp.getString("periodtypename"));
            if (null == periodTypeId) {
                this.verifyDetailList.add((Object)ImportTaskUtils.getVerifyDetailObj((DynamicObjectType)type, (DynamicObject)temp, (String)FAILTYPE_ISEXIST, (ImportTaskFailMsgEnum)ImportTaskFailMsgEnum.CALPERIODTYPE_NOT_EXIST, (Long)this.verifyRecordId));
                continue;
            }
            tempMap = payRollGrpMap.get(temp.getLong("payrollgroup.id"));
            if (tempMap == null) {
                this.verifyDetailList.add((Object)ImportTaskUtils.getVerifyDetailObj((DynamicObjectType)type, (DynamicObject)temp, (String)FAILTYPE_ISEXIST, (ImportTaskFailMsgEnum)ImportTaskFailMsgEnum.PAYROLLGROUP_NOT_EXIST, (Long)this.verifyRecordId));
                continue;
            }
            payRollSceId = temp.getLong("payrollscene.id");
            if (payRollSceId != 0L) {
                payRollGrpEntry = tempMap.get(payRollSceId);
                if (null == payRollGrpEntry) {
                    this.verifyDetailList.add((Object)ImportTaskUtils.getVerifyDetailObj((DynamicObjectType)type, (DynamicObject)temp, (String)FAILTYPE_RELATION, (ImportTaskFailMsgEnum)ImportTaskFailMsgEnum.PAYROLLSCENCE_AND_PAYROLLGROUP_NOT_MATCH, (Long)this.verifyRecordId));
                    continue;
                }
                if (!periodTypeId.equals(payRollGrpEntry.getLong("payrollsceneentry.payrollscene.periodtype.id"))) {
                    this.verifyDetailList.add((Object)ImportTaskUtils.getVerifyDetailObj((DynamicObjectType)type, (DynamicObject)temp, (String)FAILTYPE_RELATION, (ImportTaskFailMsgEnum)ImportTaskFailMsgEnum.PAYROLLSCENCE_AND_CALPERIODTYPE_NOT_MATCH, (Long)this.verifyRecordId));
                    continue;
                }
            }
            if (null == (tempMap = periodMap.get(temp.getString("periodname")))) {
                this.verifyDetailList.add((Object)ImportTaskUtils.getVerifyDetailObj((DynamicObjectType)type, (DynamicObject)temp, (String)FAILTYPE_ISEXIST, (ImportTaskFailMsgEnum)ImportTaskFailMsgEnum.CALPERIOD_NOT_EXIST, (Long)this.verifyRecordId));
                continue;
            }
            if (null == tempMap.get(periodTypeId)) {
                this.verifyDetailList.add((Object)ImportTaskUtils.getVerifyDetailObj((DynamicObjectType)type, (DynamicObject)temp, (String)FAILTYPE_RELATION, (ImportTaskFailMsgEnum)ImportTaskFailMsgEnum.CALPERIODTYPE_AND_CALPERIOD_NOT_MATCH, (Long)this.verifyRecordId));
                continue;
            }
            periodObj = tempMap.get(periodTypeId);
            mapKey = this.getMapKey(temp.getLong("payrollgroup.id"), temp.getLong("payrollscene.id"), periodObj.getLong("id"));
            tempList = temporaryMap.getOrDefault(mapKey, new ArrayList());
            tempList.add(temp);
            temporaryMap.put(mapKey, tempList);
            payRollSceIdSet.add(temp.getLong("payrollscene.id"));
            payRollGrpIdSet.add(temp.getLong("payrollgroup.id"));
            periodIdSet.add(periodObj.getLong("id"));
        }
        if (temporaryMap.size() == 0) {
            return;
        }
        Map<String, List<DynamicObject>> calTaskMap = this.getCalTaskMap(payRollGrpIdSet, payRollSceIdSet, periodIdSet);
        List<DynamicObject> calTaskTempList = null;
        Map<String, Object> taskMap = null;
        DynamicObject calTask = null;
        for (Map.Entry entry : temporaryMap.entrySet()) {
            calTaskTempList = calTaskMap.get(entry.getKey());
            if (calTaskTempList == null) {
                taskMap = this.createCalTaskObj((String)entry.getKey(), periodMap, (DynamicObject)((List)entry.getValue()).get(0), periodTypeMap, creatorId);
                this.setCalTaskName((List)entry.getValue(), (Long)taskMap.get("id"), (String)taskMap.get("name"), matchFileList);
                continue;
            }
            if (calTaskTempList.size() > 1) {
                this.addErrorData((List)entry.getValue(), (DynamicObjectType)type);
                continue;
            }
            calTask = calTaskTempList.get(0);
            this.setCalTaskName((List)entry.getValue(), calTask.getLong("id"), calTask.getString("name"), matchFileList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> createCalTaskObj(String key, Map<String, Map<Long, DynamicObject>> periodMap, DynamicObject temporary, Map<String, Long> periodTypeMap, Long creatorId) {
        String lockKey = "_createCalTask_" + key;
        DLock lock = DLock.create((String)lockKey);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "datapredeal_cache_%s", this.verifyRecordId));
        try {
            if (lock.tryLock(10000L)) {
                Map<String, Object> calTaskMap = (Map<String, Object>)appCache.get(key, Map.class);
                if (calTaskMap == null) {
                    calTaskMap = this.createCalTask(periodMap, temporary, periodTypeMap, creatorId);
                    appCache.put(key, calTaskMap);
                }
                Map<String, Object> map = calTaskMap;
                return map;
            }
            Map<String, Object> map = this.createCalTask(periodMap, temporary, periodTypeMap, creatorId);
            return map;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    private Map<String, Object> createCalTask(Map<String, Map<Long, DynamicObject>> periodMap, DynamicObject temporary, Map<String, Long> periodTypeMap, Long creatorId) {
        DynamicObject attPeriodObj;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_calpayrolltask");
        DynamicObject calTask = (DynamicObject)type.createInstance();
        calTask.set("calcount", (Object)1);
        calTask.set("payrollgroup", (Object)temporary.getLong("payrollgroup.id"));
        calTask.set("payrollscene", (Object)temporary.getLong("payrollscene.id"));
        Map<Long, DynamicObject> tempMap = periodMap.get(temporary.getString("periodname"));
        Long periodTypeId = periodTypeMap.get(temporary.getString("periodtypename"));
        DynamicObject period = tempMap.get(periodTypeId);
        DynamicObject payRollGrp = temporary.getDynamicObject("payrollgroup");
        DynamicObject payRollSce = temporary.getDynamicObject("payrollscene");
        DynamicObject payRollGrpV = this.getPayRollGrpV(temporary.getLong("payrollgroup.id"), period);
        if (payRollGrpV != null) {
            calTask.set("payrollgroupv", (Object)payRollGrpV.getLong("id"));
            calTask.set("country", (Object)payRollGrpV.getLong("country.id"));
        }
        String name = "";
        DynamicObject payRollSceV = null;
        if (payRollSce != null) {
            name = String.format("%s-%s-%s-%s", payRollGrp.getString("name"), payRollSce.getString("name"), temporary.getString("periodtypename"), period.getString("name"));
            payRollSceV = this.getPayRollSceV(temporary.getLong("payrollscene.id"), period);
            calTask.set("payrollscenev", (Object)payRollSceV.getLong("id"));
            calTask.set("calrule", (Object)payRollSceV.getLong("calrule.id"));
            calTask.set("calrulev", (Object)this.getCalRuleVid(payRollSceV.getLong("calrule.id"), period));
            calTask.set("callistviewv", (Object)PayRollTaskHelper.queryCalListViewVId((Long)payRollSceV.getLong("callistview.id")));
            calTask.set("aftercal", (Object)payRollSceV.getString("aftercal"));
            if (payRollGrpV != null) {
                calTask.set("ishandleproration", (Object)PayRollTaskHelper.getProrationCalValue((long)payRollGrpV.getLong("id"), (long)temporary.getLong("payrollscene.id")));
            } else {
                calTask.set("ishandleproration", (Object)FAILTYPE_ISEXIST);
            }
        } else {
            name = String.format("%s-%s-%s", payRollGrp.getString("name"), temporary.getString("periodtypename"), period.getString("name"));
        }
        long payrollTaskId = DB.genLongId((String)"hsas_calpayrolltask");
        calTask.set("masterid", (Object)payrollTaskId);
        calTask.set("id", (Object)payrollTaskId);
        if (name.length() > 255) {
            name = name.substring(0, 254);
        }
        calTask.set("name", (Object)name);
        calTask.set("simplename", (Object)"");
        calTask.set("calpersoncount", (Object)0);
        calTask.set("handlestate", (Object)FAILTYPE_ISEXIST);
        calTask.set("viewdetailfield", (Object)FAILTYPE_ISEXIST);
        calTask.set("tasktype", (Object)"2");
        calTask.set("islimitadd", (Object)Boolean.FALSE);
        calTask.set("isautoaddperson", (Object)Boolean.FALSE);
        calTask.set("org", (Object)temporary.getLong("importtask.org.id"));
        calTask.set("tasknewtplhis", null);
        calTask.set("tasknewmethod", (Object)"2");
        calTask.set("taskstatus", (Object)CalPayrollTaskStateEnum.AUDIT.getCode());
        calTask.set("createtime", (Object)new Date());
        this.setCalTaskPropValue(creatorId, calTask, period);
        PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
        if (payRollSceV != null && payRollSceV.getBoolean("isenableatt") && !SWCObjectUtils.isEmpty((Object)(attPeriodObj = payRollTaskService.getAttDateRange(payRollSceV, period, payRollSceV.getDynamicObject("periodtype"))))) {
            calTask.set("ATTSTARTDATE", (Object)attPeriodObj.getDate("STARTDATE"));
            calTask.set("ATTENDDATE", (Object)attPeriodObj.getDate("ENDDATE"));
        }
        String number = CodeRuleHelper.getNumber((DynamicObject)calTask, null);
        calTask.set("number", (Object)number);
        this.calTaskList.add((Object)calTask);
        HashMap<String, Object> taskMap = new HashMap<String, Object>(2);
        taskMap.put("id", payrollTaskId);
        taskMap.put("name", name);
        return taskMap;
    }

    private void setCalTaskPropValue(Long creatorId, DynamicObject calTask, DynamicObject period) {
        calTask.set("period", (Object)period.getLong("id"));
        calTask.set("periodtype", (Object)period.getLong("periodtypeid"));
        calTask.set("calfrequency", (Object)period.getLong("periodcalfrequency.id"));
        calTask.set("STARTDATE", (Object)period.getDate("startdate"));
        calTask.set("ENDDATE", (Object)period.getDate("enddate"));
        calTask.set("exratedate", (Object)period.getDate("ratedate"));
        calTask.set("paydate", (Object)period.getDate("paydate"));
        Date payRollDate = period.getDate("perioddate");
        if (payRollDate != null) {
            int payrollYear = SWCDateTimeUtils.getYear((Date)payRollDate);
            int month = SWCDateTimeUtils.getMonth((Date)payRollDate);
            calTask.set("payrollyear", (Object)payrollYear);
            Calendar calendar = Calendar.getInstance();
            calendar.set(payrollYear, month - 1, 1);
            calTask.set("payrollmonth", (Object)month);
            calTask.set("payrolldate", (Object)payRollDate);
            if (payrollYear != 0) {
                calendar.set(1, payrollYear);
                calTask.set("payrollyearshow", (Object)calendar.getTime());
            }
        }
        this.setMulBaseDataFieldValue(creatorId, calTask);
        calTask.set("creator", (Object)RequestContext.get().getCurrUserId());
        calTask.set("modifytime", null);
        calTask.set("modifier", (Object)0L);
        calTask.set("status", (Object)"A");
        calTask.set("disabler", (Object)0L);
        calTask.set("disabledate", null);
        calTask.set("enable", (Object)FAILTYPE_RELATION);
        calTask.set("index", (Object)0);
        calTask.set("issyspreset", (Object)FAILTYPE_ISEXIST);
    }

    private void setMulBaseDataFieldValue(Long currentUserId, DynamicObject calTaskDy) {
        MulBasedataProp mulBasedataProp = (MulBasedataProp)calTaskDy.getDataEntityType().getProperties().get((Object)"tracker");
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        DynamicObjectCollection rows = (DynamicObjectCollection)mulBasedataProp.getValue((Object)calTaskDy);
        DynamicObject newRow = new DynamicObject(subEntityType);
        rows.add((Object)newRow);
        DynamicObject newBasedataObj = BusinessDataServiceHelper.loadSingleFromCache((Object)currentUserId, (DynamicObjectType)basedataProp.getDynamicComplexPropertyType());
        basedataProp.setValue((Object)newRow, (Object)newBasedataObj);
    }

    private Long getCalRuleVid(Long calRuleId, DynamicObject period) {
        Long calRuleVid = this.calRuleCacheMap.get(String.format("%s_%s", calRuleId, period.getLong("id")));
        if (calRuleVid != null) {
            return calRuleVid;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        QFilter filter = new QFilter("boid", "=", (Object)calRuleId);
        filter.and(ImportTaskUtils.getDateFilter((Date)period.getDate("startdate"), (Date)period.getDate("enddate")));
        filter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        String fields = "id";
        DynamicObject result = helper.queryOriginalOne(fields, new QFilter[]{filter}, "bsed desc");
        if (result == null) {
            calRuleVid = null;
        } else {
            calRuleVid = result.getLong("id");
            this.calRuleCacheMap.put(String.format("%s_%s", calRuleId, period.getLong("id")), calRuleVid);
        }
        return calRuleVid;
    }

    private DynamicObject getPayRollSceV(Long payRollSceId, DynamicObject period) {
        DynamicObject payRollSce = this.payRollSceCacheMap.get(String.format("%s_%s", payRollSceId, period.getLong("id")));
        if (payRollSce != null) {
            return payRollSce;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        QFilter filter = new QFilter("boid", "=", (Object)payRollSceId);
        filter.and(new QFilter("datastatus", "=", (Object)FAILTYPE_RELATION));
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        String fields = "id,calrule.id,callistview.id,aftercal,callistrule.id, isenableatt,islimitadd,groupcontent,periodtype.id,matchattperiod";
        payRollSce = helper.queryOne(fields, new QFilter[]{filter});
        this.payRollSceCacheMap.put(String.format("%s_%s", payRollSceId, period.getLong("id")), payRollSce);
        return payRollSce;
    }

    private DynamicObject getPayRollGrpV(Long payRollGrpId, DynamicObject period) {
        DynamicObject payRollGrp = this.payRollGrpCacheMap.get(String.format("%s_%s", payRollGrpId, period.getLong("id")));
        if (payRollGrp != null) {
            return payRollGrp;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter filter = new QFilter("boid", "=", (Object)payRollGrpId);
        filter.and(ImportTaskUtils.getDateFilter((Date)period.getDate("startdate"), (Date)period.getDate("enddate")));
        filter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        String fields = "id,country.id";
        payRollGrp = helper.queryOriginalOne(fields, new QFilter[]{filter}, "bsed desc");
        this.payRollGrpCacheMap.put(String.format("%s_%s", payRollGrpId, period.getLong("id")), payRollGrp);
        return payRollGrp;
    }

    private void addErrorData(List<DynamicObject> temporaryList, DynamicObjectType type) {
        for (DynamicObject obj : temporaryList) {
            this.verifyDetailList.add((Object)ImportTaskUtils.getVerifyDetailObj((DynamicObjectType)type, (DynamicObject)obj, (String)FAILTYPE_ISEXIST, (ImportTaskFailMsgEnum)ImportTaskFailMsgEnum.CALTASK_HAS_MULTIPLE_OPTIONS, (Long)this.verifyRecordId));
        }
    }

    private void setCalTaskName(List<DynamicObject> temporaryList, Long calTaskId, String calTaskName, DynamicObjectCollection matchFileList) {
        for (DynamicObject obj : temporaryList) {
            obj.set("caltask", (Object)calTaskId);
            obj.set("caltaskname", (Object)calTaskName);
            obj.set("datastatus", (Object)FAILTYPE_RELATION);
            obj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            obj.set("modifytime", (Object)new Date());
            this.successDataList.add((Object)obj);
            if (!SWCStringUtils.isEmpty((String)obj.getString("filenumber"))) continue;
            matchFileList.add((Object)obj);
        }
    }

    private Map<String, List<DynamicObject>> getCalTaskMap(Set<Long> payRollGrpIdSet, Set<Long> payRollSceIdSet, Set<Long> periodIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String fields = "id,name,payrollgroup.id,payrollscene.id,period.id";
        QFilter filter = new QFilter("payrollgroup.id", "in", payRollGrpIdSet);
        filter.and("payrollscene.id", "in", payRollSceIdSet);
        filter.and("period.id", "in", periodIdSet);
        filter.and("taskstatus", "!=", (Object)CalPayrollTaskStateEnum.DISUSED.getCode());
        filter.and("tasktype", "=", (Object)"2");
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        return result.stream().collect(Collectors.groupingBy(obj -> this.getMapKey(obj.getLong("payrollgroup.id"), obj.getLong("payrollscene.id"), obj.getLong("period.id"))));
    }

    private String getMapKey(Long payRollGrpId, Long payRollSceId, Long periodId) {
        return String.format("%s_%s_%s", payRollGrpId, payRollSceId, periodId);
    }

    private Map<Long, Map<Long, DynamicObject>> getPayRollGrpMap(Set<Long> payRollGrpIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        String fields = "id,name,payrollsceneentry.payrollscene.id,payrollsceneentry.payrollscene.periodtype.id";
        QFilter filter = new QFilter("id", "in", payRollGrpIdSet);
        filter.and(BaseDataHisHelper.getHisCurrFilter());
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)FAILTYPE_RELATION);
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        HashMap<Long, Map<Long, DynamicObject>> payRollGrpMap = new HashMap<Long, Map<Long, DynamicObject>>(result.size());
        Map payRollSceMap = null;
        for (DynamicObject obj : result) {
            payRollSceMap = payRollGrpMap.getOrDefault(obj.getLong("id"), new HashMap(16));
            payRollSceMap.put(obj.getLong("payrollsceneentry.payrollscene.id"), obj);
            payRollGrpMap.put(obj.getLong("id"), payRollSceMap);
        }
        return payRollGrpMap;
    }

    private Map<String, Long> getPeriodTypeMap(Set<String> periodTypeNameSet) {
        SWCDataServiceHelper periodHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
        String fields = "id,name";
        QFilter filter = new QFilter("name", "in", periodTypeNameSet);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)FAILTYPE_RELATION);
        DynamicObjectCollection result = periodHelper.queryOriginalCollection(fields, new QFilter[]{filter});
        return result.stream().collect(Collectors.toMap(obj -> obj.getString("name"), obj -> obj.getLong("id")));
    }

    public Map<String, Map<Long, DynamicObject>> getPeriodMap(Set<String> periodNameSet) {
        SWCDataServiceHelper periodHelper = new SWCDataServiceHelper("hsbs_calperiod");
        String fields = "id,name,periodtypeid,startdate,enddate,ratedate,periodyear,perioddate,paydate,periodcalfrequency.id";
        QFilter filter = new QFilter("name", "in", periodNameSet);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)FAILTYPE_RELATION);
        DynamicObjectCollection result = periodHelper.queryOriginalCollection(fields, new QFilter[]{filter});
        HashMap<String, Map<Long, DynamicObject>> periodMap = new HashMap<String, Map<Long, DynamicObject>>(16);
        Map tempMap = null;
        for (DynamicObject obj : result) {
            tempMap = periodMap.getOrDefault(obj.getString("name"), new HashMap(16));
            tempMap.put(obj.getLong("periodtypeid"), obj);
            periodMap.put(obj.getString("name"), tempMap);
        }
        return periodMap;
    }
}

