/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg.service;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.pcs.business.extpoint.costcfg.ICostCfgExportExtService;
import kd.sdk.swc.pcs.common.events.CostCfgEvent;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgExportExtService;
import kd.swc.pcs.business.costcfg.CostCfgExportHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;
import kd.swc.pcs.business.costcommon.CostExportCommonHelper;
import kd.swc.pcs.business.costthread.CostCfgExportThread;
import kd.swc.pcs.common.constants.CostExportConstants;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CostCfgExportService {
    public static final String SWC_PCS_BUSINESS = "swc-pcs-business";
    protected static final Log logger = LogFactory.getLog(CostCfgExportService.class);
    private Map<Long, String> costAdaptionNumberMap = new HashMap<Long, String>();

    public void doExport(IFormView view) {
        IListView listView = (IListView)view;
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.doExportAll(view);
        } else {
            ArrayList<Long> selectIdList = new ArrayList<Long>(10);
            for (ListSelectedRow row : selectedRows) {
                Long primaryKeyValue = (Long)row.getPrimaryKeyValue();
                if (selectIdList.contains(primaryKeyValue)) continue;
                selectIdList.add(primaryKeyValue);
            }
            this.doExportSelectedById(selectIdList, view);
        }
    }

    private void doExportSelectedById(List<Long> selectIdList, IFormView view) {
        logger.info("CostCfgExportService doExportSelected 6-1");
        this.openExportProgressBar(selectIdList.size(), view);
        this.execute(selectIdList, view);
    }

    private void execute(List<Long> selectIdList, IFormView view) {
        logger.info("CostCfgExportService execute export data 1");
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"EXPORT_COST_CFG_EXCEL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            Map<Long, SXSSFWorkbook> workBookMap = this.doExportSelected(selectIdList, view);
            CostExportCommonHelper.writeWorkBookToFile(workBookMap, (IFormView)view, this.costAdaptionNumberMap, (String)"1");
        });
    }

    private Map<Long, SXSSFWorkbook> doExportSelected(List<Long> selectIdList, IFormView view) {
        logger.info("CostCfgExportService doExportSelected 6-1");
        String billFormId = this.getBillFormId(view);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"1ANC8T4UC434", (String)billFormId);
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
            List hasPermOrgList = hasPermOrgResult.getHasPermOrgs();
            filters.add(new QFilter("createorg", "in", (Object)hasPermOrgList));
            logger.info("CostCfgExportService doExportSelected hasPermOrgList: {}", (Object)hasPermOrgList);
        }
        List<FutureTask<Map<Long, List<DynamicObject>>>> taskList = this.getSelectExportDataFutureTask(selectIdList, billFormId, filters);
        return this.executeExportData(view, taskList);
    }

    private void doExportAll(IFormView view) {
        logger.info("CostCfgExportService doExportAll 6-1");
        String billFormId = this.getBillFormId(view);
        Long sourceTypeId = CostCommonHelper.getCostCfgTypeIdByFormId((String)billFormId);
        List<QFilter> allFilterList = this.getAllFilterList(view, billFormId);
        int totalSize = CostCfgExportHelper.getExportTotalSize((String)billFormId, (Long)sourceTypeId, allFilterList);
        if (totalSize == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5bfc\u51fa\u6570\u636e\u3002", (String)"CostAllotBillExportService_12", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
            return;
        }
        this.openExportProgressBar(totalSize, view);
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"EXPORT_ALL_COST_CFG_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            List<FutureTask<Map<Long, List<DynamicObject>>>> taskList = this.getAllExportDataFutureTask(totalSize, billFormId, allFilterList);
            Map<Long, SXSSFWorkbook> longSXSSFWorkbookMap = this.executeExportData(view, taskList);
            CostExportCommonHelper.writeWorkBookToFile(longSXSSFWorkbookMap, (IFormView)view, this.costAdaptionNumberMap, (String)"1");
        });
    }

    private List<QFilter> getAllFilterList(IFormView view, String billFormId) {
        BillList billList;
        List filters;
        ArrayList<QFilter> allFilter = new ArrayList<QFilter>(10);
        List<QFilter> otherQFilters = this.addOtherFilter(billFormId);
        if (CollectionUtils.isNotEmpty(otherQFilters)) {
            allFilter.addAll(otherQFilters);
        }
        if (CollectionUtils.isNotEmpty((Collection)(filters = (billList = (BillList)((IListView)view).getControl("billlistap")).generalFilterParameter().getQFilters()))) {
            allFilter.addAll(filters);
        }
        return allFilter;
    }

    private List<QFilter> addOtherFilter(String billFormId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Long sourceTypeId = CostCommonHelper.getCostCfgTypeIdByFormId((String)billFormId);
        QFilter sourceTypeQFilter = new QFilter("sourcetype.id", "=", (Object)sourceTypeId);
        filterList.add(sourceTypeQFilter);
        QFilter isCurrentVersionQFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        filterList.add(isCurrentVersionQFilter);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"1ANC8T4UC434", (String)billFormId, (String)"47150e89000000ac");
        if (authorizedDataRuleQFilter != null) {
            filterList.addAll(authorizedDataRuleQFilter);
        }
        return filterList;
    }

    private String getBillFormId(IFormView view) {
        ListView listView = (ListView)view;
        return listView.getBillFormId();
    }

    private String getBillFormName(IFormView view) {
        ListView listView = (ListView)view;
        return listView.getFormShowParameter().getCaption();
    }

    private void openExportProgressBar(int totalSize, IFormView view) {
        this.updateProgress(totalSize, view);
        FormShowParameter para = new FormShowParameter();
        para.setFormId("pcs_costcommonprogress");
        para.getOpenStyle().setShowType(ShowType.Modal);
        IListView listView = (IListView)view;
        String costCfgName = listView.getFormShowParameter().getCaption();
        para.setCustomParam("title", (Object)ResManager.loadKDString((String)"{0}\u5bfc\u51fa\u8fdb\u5ea6", (String)"CostCfgExportService_40", (String)SWC_PCS_BUSINESS, (Object[])new Object[]{costCfgName}));
        String pageId = view.getPageId();
        para.setCustomParam("pageId", (Object)pageId);
        view.showForm(para);
    }

    private void updateProgress(int totalSize, IFormView view) {
        SWCPageCache pageCache = new SWCPageCache(view);
        if (totalSize <= 0) {
            pageCache.put("progress", (Object)CostExportConstants.DOUBLE_HUNDRED);
        } else {
            pageCache.put("progress", (Object)CostExportConstants.DOUBLE_ZERO);
        }
        pageCache.saveChanges();
    }

    private Map<Long, SXSSFWorkbook> executeExportData(IFormView view, List<FutureTask<Map<Long, List<DynamicObject>>>> taskList) {
        logger.info("CostCfgExportService executeExportData begin 6-3");
        HashMap<Long, List<DynamicObject>> allResultMap = new HashMap<Long, List<DynamicObject>>(16);
        for (FutureTask<Map<Long, List<DynamicObject>>> task : taskList) {
            try {
                Map<Long, List<DynamicObject>> resultList = task.get();
                allResultMap.putAll(resultList);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("doExportSelected Exception", (Throwable)e);
            }
        }
        String billFormName = this.getBillFormName(view);
        this.costAdaptionNumberMap = this.queryAdapterIdByAllotBills(new ArrayList<Long>(allResultMap.keySet()), billFormName);
        logger.info("CostAllotBillExportService doExportSelected 3");
        String billFormId = this.getBillFormId(view);
        return this.batchCreateWorkbook(billFormId, allResultMap);
    }

    private Map<Long, String> queryAdapterIdByAllotBills(List<Long> selectIdList, String billFormName) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_costadaption");
        QFilter idFilter = new QFilter("id", "in", selectIdList);
        DynamicObject[] costAdaptionArr = serviceHelper.query("id,number,name", new QFilter[]{idFilter});
        HashMap<Long, String> costAdaptionIdAndNumberMap = new HashMap<Long, String>(costAdaptionArr.length);
        for (int i = 0; i < costAdaptionArr.length; ++i) {
            DynamicObject costAdaptionDy = costAdaptionArr[i];
            String costAdapterName = costAdaptionDy.getString("name");
            long costAdaptionDyId = costAdaptionDy.getLong("id");
            costAdaptionIdAndNumberMap.put(costAdaptionDyId, billFormName + '_' + costAdapterName);
        }
        return costAdaptionIdAndNumberMap;
    }

    private Map<Long, SXSSFWorkbook> batchCreateWorkbook(String billFormId, Map<Long, List<DynamicObject>> allResultMap) {
        LinkedHashMap<Long, SXSSFWorkbook> workBookMap = new LinkedHashMap<Long, SXSSFWorkbook>(allResultMap.size());
        for (Map.Entry<Long, List<DynamicObject>> next : allResultMap.entrySet()) {
            List<DynamicObject> resultList = next.getValue();
            Long costAdapterId = next.getKey();
            SXSSFWorkbook workbook = this.createSheetAndWriteData(billFormId, resultList, costAdapterId);
            workBookMap.put(costAdapterId, workbook);
        }
        logger.info("CostCfgExportService manageSelected 6-7");
        return workBookMap;
    }

    private SXSSFWorkbook createSheetAndWriteData(String billFormId, List<DynamicObject> allData, Long costAdapterId) {
        Map costCfgHeaders = CostCfgExportHelper.getExportColumnMap((String)billFormId, (Long)costAdapterId);
        LinkedHashMap costCfgLinkHeaders = new LinkedHashMap(costCfgHeaders);
        CostCfgExportExtService extService = new CostCfgExportExtService();
        CostCfgEvent event = new CostCfgEvent(billFormId, allData, costCfgLinkHeaders);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, ICostCfgExportExtService.class, (String)"kd.sdk.swc.pcs.business.extpoint.costcfg.ICostCfgExportExtService#setCostCfgExportFieldAndValue", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.setCostCfgExportFieldAndValue(event);
            return null;
        });
        ArrayList<String> newAddKeyList = new ArrayList<String>(10);
        LinkedHashMap newCostCfgHeaders = event.getCostCfgHeaders();
        if (!SWCObjectUtils.isEmpty((Object)newCostCfgHeaders)) {
            for (Map.Entry next : newCostCfgHeaders.entrySet()) {
                String key = (String)next.getKey();
                if (costCfgHeaders.containsKey(key)) continue;
                newAddKeyList.add(key);
            }
            costCfgHeaders = newCostCfgHeaders;
        }
        Map baseDataExportType = event.getBaseDataExportType();
        SXSSFWorkbook wb = new SXSSFWorkbook(CostExportConstants.ROW_ACCESS_WINDOWS_SIZE);
        String costCfgSheetName = ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e", (String)"CostCfgExportService_18", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
        SXSSFSheet costCfgSheet = this.createCostCfgSheet(wb, costCfgHeaders, costCfgSheetName, billFormId, costAdapterId);
        logger.info("CostCfgExportService manageSelected 6-5");
        List headList = CostExportCommonHelper.headMapToListMap((Map)costCfgHeaders);
        CostExportCommonHelper.createValidation((SXSSFSheet)costCfgSheet, (Integer)1, (List)headList, (String)billFormId);
        ArrayList<Long> costSegmentIds = new ArrayList<Long>(10);
        for (DynamicObject costCfgDy : allData) {
            this.getSegmentIdFromCostCfg(costSegmentIds, costCfgDy);
            this.getSegmentIdFromCostCfgType(costSegmentIds, costCfgDy);
        }
        Map costSegmentIdMap = CostCfgExportHelper.getCostSegmentMap(costSegmentIds);
        ArrayList<Map<String, Object>> costCfgList = new ArrayList<Map<String, Object>>(10);
        logger.info("CostCfgExportService manageSelected 6-6");
        this.convertColumnValue(costCfgList, allData, costSegmentIdMap, costAdapterId, billFormId, newAddKeyList, baseDataExportType);
        CostExportCommonHelper.write2ExportContent((SXSSFSheet)costCfgSheet, (Integer)2, costCfgList, (Map)costCfgHeaders);
        return wb;
    }

    private void getSegmentIdFromCostCfg(List<Long> costSegmentIds, DynamicObject costCfgDy) {
        this.getSegmentIdListByType(costSegmentIds, costCfgDy, "costcfgentryentity", "costsegstore.id");
    }

    private void getSegmentIdFromCostCfgType(List<Long> costSegmentIds, DynamicObject costCfgDy) {
        String billName = costCfgDy.getDataEntityType().getName();
        if ("pcs_costitemcfg".equals(billName) || "pcs_costdeptcfg".equals(billName)) {
            this.getSegmentIdListByType(costSegmentIds, costCfgDy, "costcfgtypeentryentity", "costtypesegstore.id");
        }
    }

    private void getSegmentIdListByType(List<Long> costSegmentIds, DynamicObject costCfgDy, String entityKey, String idKey) {
        DynamicObjectCollection entryEntityDys = costCfgDy.getDynamicObjectCollection(entityKey);
        for (DynamicObject entryEntityDy : entryEntityDys) {
            long segStoreId = entryEntityDy.getLong(idKey);
            costSegmentIds.add(segStoreId);
        }
    }

    private SXSSFSheet createCostCfgSheet(SXSSFWorkbook wb, Map<String, String> costCfgHeaders, String sheetName, String billName, Long costAdapterId) {
        SXSSFSheet sheet = wb.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(-1);
        CostExportCommonHelper.write2ExportCostCfgHead((SXSSFSheet)sheet, costCfgHeaders, (String)billName, (long)costAdapterId);
        return sheet;
    }

    private void convertColumnValue(List<Map<String, Object>> costCfgList, List<DynamicObject> coll, Map<Long, DynamicObject> costSegmentIdMap, Long costAdapterId, String billFormId, List<String> newAddKeyList, Map<String, String> baseDataExportType) {
        logger.info("convertColumnValue begin");
        Long costStruId = CostCfgExportHelper.queryCostStruByAdapter((Long)costAdapterId);
        Map segmentAndDimNameMap = CostCommonHelper.queryCostStruSegmentMap((long)costStruId, (String)billFormId);
        Map<String, Map<Long, DynamicObject>> segmentValMap = this.queryCostSegmentVal(coll, costSegmentIdMap, segmentAndDimNameMap);
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject costCfgDy = coll.get(i);
            String billName = costCfgDy.getDataEntityType().getName();
            logger.info("convertColumnValue costCfgDyType \uff1a{}", (Object)billName);
            Map<String, Object> valueMap = this.packageFixColumnValue(costCfgDy);
            if (CollectionUtils.isNotEmpty(newAddKeyList)) {
                DataEntityPropertyCollection properties = costCfgDy.getDataEntityType().getProperties();
                this.putNewAddKeyValue(costCfgDy, newAddKeyList, properties, valueMap, baseDataExportType);
            }
            this.packageCostCfgEntryValue(costCfgList, costSegmentIdMap, valueMap, costCfgDy, segmentAndDimNameMap, segmentValMap, newAddKeyList, baseDataExportType);
            this.packageCostCfgTypeEntryValue(costCfgList, costSegmentIdMap, valueMap, costCfgDy, segmentAndDimNameMap, segmentValMap, newAddKeyList, baseDataExportType);
        }
        logger.info("convertColumnValue end");
    }

    private Map<String, Map<Long, DynamicObject>> queryCostSegmentVal(List<DynamicObject> coll, Map<Long, DynamicObject> costSegmentIdMap, Map<String, DynamicObject> segmentAndDimNameMap) {
        HashMap<String, Map<Long, DynamicObject>> segmentValMap = new HashMap<String, Map<Long, DynamicObject>>(16);
        HashMap<String, List<Long>> entityIdsMap = new HashMap<String, List<Long>>(16);
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject costCfgDy = coll.get(i);
            this.collectDataId(costSegmentIdMap, segmentAndDimNameMap, entityIdsMap, costCfgDy, "costcfgentryentity", "costsegstore.id");
            this.collectDataId(costSegmentIdMap, segmentAndDimNameMap, entityIdsMap, costCfgDy, "costcfgtypeentryentity", "costtypesegstore.id");
        }
        for (Map.Entry entry : entityIdsMap.entrySet()) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper((String)entry.getKey());
            DynamicObject[] dataDyArr = serviceHelper.query(((List)entry.getValue()).toArray());
            Map<Long, DynamicObject> dataMap = Arrays.stream(dataDyArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v1));
            segmentValMap.put((String)entry.getKey(), dataMap);
        }
        return segmentValMap;
    }

    private void collectDataId(Map<Long, DynamicObject> costSegmentIdMap, Map<String, DynamicObject> segmentAndDimNameMap, Map<String, List<Long>> entityIdsMap, DynamicObject costCfgDy, String entityKey, String costsegstoreKey) {
        if (!costCfgDy.getDataEntityType().getProperties().containsKey((Object)entityKey)) {
            return;
        }
        DynamicObjectCollection entryEntityDys = costCfgDy.getDynamicObjectCollection(entityKey);
        for (DynamicObject dynamicObject : entryEntityDys) {
            long costSegmentId = dynamicObject.getLong(costsegstoreKey);
            DynamicObject costSegmentDy = costSegmentIdMap.get(costSegmentId);
            if (costSegmentDy == null) continue;
            for (Map.Entry<String, DynamicObject> next : segmentAndDimNameMap.entrySet()) {
                String index = next.getKey();
                DynamicObject dimVal = next.getValue();
                String propertyName = "segment" + index;
                String segmentResult = costSegmentDy.getString(propertyName);
                if (segmentResult == null || !segmentResult.contains("||")) continue;
                String dataId = segmentResult.substring(0, segmentResult.indexOf("||"));
                String valueSource = this.getValueSource(dimVal);
                if (SWCStringUtils.isEmpty((String)valueSource)) continue;
                List<Long> dataIds = entityIdsMap.get(valueSource);
                if (dataIds == null) {
                    dataIds = new ArrayList<Long>(10);
                    entityIdsMap.put(valueSource, dataIds);
                }
                dataIds.add(Long.parseLong(dataId));
            }
        }
    }

    private void packageCostCfgEntryValue(List<Map<String, Object>> costCfgEntryList, Map<Long, DynamicObject> costSegmentIdMap, Map<String, Object> valueMap, DynamicObject costCfgDy, Map<String, DynamicObject> segmentAndDimNameMap, Map<String, Map<Long, DynamicObject>> segmentValMap, List<String> newAddKeyList, Map<String, String> baseDataExportType) {
        this.packageDateByType(costCfgEntryList, costSegmentIdMap, valueMap, costCfgDy, segmentAndDimNameMap, "costCfg", segmentValMap, newAddKeyList, baseDataExportType);
    }

    private void packageCostCfgTypeEntryValue(List<Map<String, Object>> costCfgEntryList, Map<Long, DynamicObject> costSegmentIdMap, Map<String, Object> valueMap, DynamicObject costCfgDy, Map<String, DynamicObject> segmentAndDimNameMap, Map<String, Map<Long, DynamicObject>> segmentValMap, List<String> newAddKeyList, Map<String, String> baseDataExportType) {
        String billName = costCfgDy.getDataEntityType().getName();
        if ("pcs_costitemcfg".equals(billName) || "pcs_costdeptcfg".equals(billName)) {
            this.packageDateByType(costCfgEntryList, costSegmentIdMap, valueMap, costCfgDy, segmentAndDimNameMap, "costCfgType", segmentValMap, newAddKeyList, baseDataExportType);
        }
    }

    private void packageDateByType(List<Map<String, Object>> costCfgEntryList, Map<Long, DynamicObject> costSegmentIdMap, Map<String, Object> valueMap, DynamicObject costCfgDy, Map<String, DynamicObject> segmentAndDimNameMap, String costCfg, Map<String, Map<Long, DynamicObject>> segmentValMap, List<String> newAddKeyList, Map<String, String> baseDataExportType) {
        boolean isCostCfg = "costCfg".equals(costCfg);
        String entityKey = isCostCfg ? "costcfgentryentity" : "costcfgtypeentryentity";
        String costSegStoreIdKey = isCostCfg ? "costsegstore.id" : "costtypesegstore.id";
        String proportionKey = isCostCfg ? "calcostproportion" : "costcfgtypeproportion";
        String costTypeName = "";
        String billName = costCfgDy.getDataEntityType().getName();
        if (isCostCfg) {
            costTypeName = ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e", (String)"CostCfgExportService_18", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
        } else if ("pcs_costitemcfg".equals(billName)) {
            costTypeName = ResManager.loadKDString((String)"\u4f18\u5148\u6210\u672c\u8bbe\u7f6e", (String)"CostCfgExportService_19", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
        } else if ("pcs_costdeptcfg".equals(billName) || "pcs_costgroupcfg".equals(billName)) {
            costTypeName = ResManager.loadKDString((String)"\u515c\u5e95\u6210\u672c\u8bbe\u7f6e", (String)"CostCfgExportService_20", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
        }
        DynamicObjectCollection entryEntityDys = costCfgDy.getDynamicObjectCollection(entityKey);
        DataEntityPropertyCollection entryProperties = null;
        if (CollectionUtils.isNotEmpty((Collection)entryEntityDys)) {
            entryProperties = ((DynamicObject)entryEntityDys.get(0)).getDataEntityType().getProperties();
        }
        for (DynamicObject dynamicObject : entryEntityDys) {
            LinkedHashMap<String, Object> newEntryValueMap = new LinkedHashMap<String, Object>(16);
            newEntryValueMap.putAll(valueMap);
            long costSegmentId = dynamicObject.getLong(costSegStoreIdKey);
            DynamicObject costSegmentDy = costSegmentIdMap.get(costSegmentId);
            newEntryValueMap.put("costCfgType", costTypeName);
            BigDecimal proportion = !isCostCfg && "pcs_costdeptcfg".equals(billName) ? new BigDecimal(100) : dynamicObject.getBigDecimal(proportionKey);
            BigDecimal resultBigDecimal = proportion.setScale(2, RoundingMode.HALF_UP);
            String exportProportion = String.valueOf(resultBigDecimal);
            newEntryValueMap.put("proportion", exportProportion.isEmpty() ? "" : exportProportion);
            if (costSegmentDy != null) {
                for (Map.Entry<String, DynamicObject> next : segmentAndDimNameMap.entrySet()) {
                    String index = next.getKey();
                    DynamicObject dimensionDy = next.getValue();
                    String valueSource = this.getValueSource(dimensionDy);
                    Map<Long, DynamicObject> segmentVals = segmentValMap.get(valueSource);
                    this.setEntryValue(newEntryValueMap, costSegmentDy, "segment" + index, dimensionDy, segmentVals);
                }
                if (entryProperties != null) {
                    this.putNewAddKeyValue(dynamicObject, newAddKeyList, entryProperties, newEntryValueMap, baseDataExportType);
                }
            }
            costCfgEntryList.add(newEntryValueMap);
        }
    }

    private String getValueSource(DynamicObject dimensionDy) {
        String valuesource = "";
        String valueType = dimensionDy.getString("costdimension.valuetype");
        if ("1".equals(valueType)) {
            valuesource = dimensionDy.getString("costdimension.valuesource.number");
        } else if ("2".equals(valueType)) {
            valuesource = "bos_assistantdata_detail";
        }
        return valuesource;
    }

    private void putNewAddKeyValue(DynamicObject dynamicObject, List<String> newAddKeyList, DataEntityPropertyCollection entryProperties, Map<String, Object> newEntryValueMap, Map<String, String> baseDataExportTypeMap) {
        for (String key : newAddKeyList) {
            boolean containsKey = entryProperties.containsKey((Object)key);
            if (!containsKey) continue;
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)entryProperties.get((Object)key);
            if (iDataEntityProperty instanceof BasedataProp) {
                String valueKey = key + ".number";
                if (!SWCObjectUtils.isEmpty(baseDataExportTypeMap)) {
                    String baseDataExportType = baseDataExportTypeMap.get(key);
                    valueKey = "1".equals(baseDataExportType) ? key + ".number" : key + ".name";
                }
                String number = dynamicObject.getString(valueKey);
                newEntryValueMap.put(key, number);
                continue;
            }
            Object value = dynamicObject.get(key);
            newEntryValueMap.put(key, value);
        }
    }

    private void setEntryValue(Map<String, Object> newEntryValueMap, DynamicObject costSegmentDy, String propertyName, DynamicObject dimensionDy, Map<Long, DynamicObject> segmentVals) {
        String segmentResult = costSegmentDy.getString(propertyName);
        if (segmentResult != null && segmentResult.contains("||")) {
            String dataId = segmentResult.substring(0, segmentResult.indexOf("||"));
            if (segmentVals == null) {
                return;
            }
            DynamicObject segmentDy = segmentVals.get(Long.parseLong(dataId));
            if (segmentDy == null || dimensionDy == null) {
                return;
            }
            String importProperty = dimensionDy.getString("costdimension.importproperty");
            String dataVal = segmentDy.getString("name");
            if ("1".equals(importProperty)) {
                dataVal = segmentDy.getString("number");
            }
            newEntryValueMap.put(propertyName, dataVal);
        } else {
            newEntryValueMap.put(propertyName, segmentResult);
        }
    }

    private Map<String, Object> packageFixColumnValue(DynamicObject costCfgDy) {
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>(16);
        valueMap.put("bsed", costCfgDy.getDate("bsed"));
        valueMap.put("orgNumber", costCfgDy.getString("createorg.number"));
        String billFormId = costCfgDy.getDataEntityType().getName();
        this.setCostCfgName(valueMap, billFormId, costCfgDy);
        return valueMap;
    }

    private void setCostCfgName(Map<String, Object> valueMap, String billFormId, DynamicObject costCfgDy) {
        if ("pcs_costempcfg".equals(billFormId)) {
            valueMap.put("costCfgName", costCfgDy.getString("source.person.name"));
            valueMap.put("costCfgNumber", costCfgDy.getString("source.person.number"));
        } else {
            valueMap.put("costCfgName", costCfgDy.getString("source.name"));
            valueMap.put("costCfgNumber", costCfgDy.getString("source.number"));
        }
        if ("pcs_costsalaryitemcfg".equals(billFormId)) {
            valueMap.put("personName", costCfgDy.getString("creatorobj.name"));
            valueMap.put("salaryFileNumber", costCfgDy.getString("creatorobj.number"));
        }
    }

    private List<FutureTask<Map<Long, List<DynamicObject>>>> getAllExportDataFutureTask(int totalSize, String billFormId, List<QFilter> filters) {
        logger.info("CostCfgExportService getAllExportDataFutureTask 6-2");
        int totalPages = (int)Math.ceil((double)totalSize * 1.0 / (double)CostExportConstants.PAGE_SIZE.intValue());
        RequestContext cxt = RequestContext.get();
        ArrayList<FutureTask<Map<Long, List<DynamicObject>>>> taskList = new ArrayList<FutureTask<Map<Long, List<DynamicObject>>>>(10);
        for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
            CostCfgExportThread task = new CostCfgExportThread(pageIndex, cxt, Collections.emptyList(), CostExportConstants.PAGE_SIZE.intValue(), billFormId, filters);
            FutureTask futureTask = new FutureTask(task);
            CostExportConstants.QUERY_COST_CFG_POOL.submit(futureTask);
            taskList.add(futureTask);
        }
        return taskList;
    }

    private List<FutureTask<Map<Long, List<DynamicObject>>>> getSelectExportDataFutureTask(List<Long> selectIdList, String billFormId, List<QFilter> filters) {
        logger.info("CostCfgExportService getSelectExportDataFutureTask 6-2");
        int totalSize = selectIdList.size();
        int totalPages = (int)Math.ceil((double)totalSize * 1.0 / (double)CostExportConstants.PAGE_SIZE.intValue());
        RequestContext cxt = RequestContext.get();
        ArrayList<FutureTask<Map<Long, List<DynamicObject>>>> taskList = new ArrayList<FutureTask<Map<Long, List<DynamicObject>>>>(10);
        for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
            int fromIndex = Math.min(pageIndex * CostExportConstants.PAGE_SIZE, totalSize);
            int toIndex = Math.min(fromIndex + CostExportConstants.PAGE_SIZE, totalSize);
            ImmutableList batchList = ImmutableList.copyOf(selectIdList.subList(fromIndex, toIndex));
            CostCfgExportThread costCfgExportThread = new CostCfgExportThread(pageIndex, cxt, (List)batchList, CostExportConstants.PAGE_SIZE.intValue(), billFormId, filters);
            FutureTask futureTask = new FutureTask(costCfgExportThread);
            CostExportConstants.QUERY_COST_CFG_POOL.submit(futureTask);
            taskList.add(futureTask);
        }
        return taskList;
    }
}

