/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.shift;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.common.constants.WTCBaseKDString;
import kd.wtc.wtbs.common.model.evaluation.BaseDataVo;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.model.evaluation.ShiftMiddleRule;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.model.sign.TakeCardRule;
import kd.wtc.wtbs.common.model.sign.TimeSeq;
import kd.wtc.wtbs.common.util.TimeUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.wtte.common.enums.OutWorkType;

public class ShiftService {
    private static final Log LOG = LogFactory.getLog(ShiftService.class);
    private static final ShiftService INS = new ShiftService();
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("wtbd_shift");
    private static final HRBaseServiceHelper TAKE_CARD_RULE_HELPER = new HRBaseServiceHelper("wtbd_takecardrule");

    public static ShiftService getInstance() {
        return INS;
    }

    public Map<Long, TakeCardRule> getTaleCardRuleMap(Collection<Long> takeCardRuleIds) {
        DynamicObject[] takeCardRuleDys = TAKE_CARD_RULE_HELPER.loadDynamicObjectArray(takeCardRuleIds.toArray());
        return Arrays.stream(takeCardRuleDys).collect(Collectors.toMap(dy -> dy.getLong("id"), this::getTakeCardRule, (k1, k2) -> k2));
    }

    public Map<Long, Shift> getShiftEvalVoMapByQFilter(QFilter qFilter) {
        LOG.debug("getShiftEvalVoMapByQFilter.params:{}", (Object)qFilter);
        DynamicObjectCollection dyColl = HELPER.queryOriginalCollection("id", qFilter.toArray());
        if (dyColl != null) {
            return this.getShiftEvalVoMapByVids(dyColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        }
        return new HashMap<Long, Shift>(0);
    }

    public Map<Long, Shift> getShiftEvalVoMapByVids(Collection<Long> shiftVIds) {
        DynamicObject[] shiftDyArr;
        if (LOG.isDebugEnabled() && shiftVIds.size() <= 10) {
            LOG.debug("getShiftEvalVoMapByVids.params:{}", shiftVIds);
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)shiftVIds.size());
        QFilter qFilter = new QFilter("id", "in", shiftVIds);
        for (DynamicObject shiftDy : shiftDyArr = HELPER.loadDynamicObjectArray(qFilter.toArray())) {
            Shift shift = this.getShiftByDynamicObj(shiftDy);
            resultMap.put(shift.getId(), shift);
        }
        if (LOG.isDebugEnabled() && resultMap.size() <= 1) {
            LOG.debug("getShiftEvalVoMapByVids.result:{}", (Object)resultMap);
        }
        return resultMap;
    }

    public Map<Long, Map<Long, Shift>> getShiftEvalVoHisMapByBoIds(Collection<Long> shiftBoIds) {
        DynamicObject[] shiftDyArr;
        LOG.info("getShiftEvalVoHisMapByBoIds.params:{}", shiftBoIds);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)shiftBoIds.size());
        QFilter qFilter = new QFilter("boid", "in", shiftBoIds).and(WTCHisServiceHelper.dataStatusValidQFilter());
        for (DynamicObject shiftDy : shiftDyArr = HELPER.loadDynamicObjectArray(qFilter.toArray())) {
            Shift shift = this.getShiftByDynamicObj(shiftDy);
            long boId = shiftDy.getLong("boid");
            Map shiftMap = resultMap.computeIfAbsent(boId, key -> Maps.newHashMap());
            shiftMap.put(shift.getId(), shift);
        }
        LOG.info("getShiftEvalVoHisMapByBoIds.result:{}", (Object)resultMap);
        return resultMap;
    }

    public Shift getShiftByDynamicObj(DynamicObject shiftDy) {
        Shift shift = new Shift();
        shift.setId(Long.valueOf(shiftDy.getLong("id")));
        shift.setBoId(Long.valueOf(shiftDy.getLong("boid")));
        shift.setShiftType(shiftDy.getString("shifttype"));
        shift.setCheckCardTimes(Long.valueOf(shiftDy.getLong("cardsnum")));
        shift.setShiftColor(shiftDy.getString("shiftcolor"));
        shift.setName(shiftDy.getString("name"));
        ILocaleString localeString = shiftDy.getLocaleString("name");
        shift.setChineseName(localeString != null ? localeString.getLocaleValue_zh_CN() : null);
        shift.setNumber(shiftDy.getString("number"));
        shift.setOff(shiftDy.getBoolean("isoff"));
        shift.setOffNonPlan(shiftDy.getBoolean("offnonplan"));
        shift.setLastRefStartDay(shiftDy.getString("referencestartday"));
        shift.setLastRefEndDay(shiftDy.getString("referenceendday"));
        shift.setLastShiftStartDate(shiftDy.getInt("shiftstart"));
        shift.setLastShiftEndDate(shiftDy.getInt("shiftend"));
        shift.setClockRuleId(Long.valueOf(shiftDy.getLong("clockrule.id")));
        shift.setBsed(shiftDy.getDate("bsed"));
        shift.setBsled(shiftDy.getDate("bsled"));
        ShiftMiddleRule shiftMiddleRule = new ShiftMiddleRule();
        shiftMiddleRule.setMiddlepoint(shiftDy.getInt("middlepoint"));
        shiftMiddleRule.setAllday(shiftDy.getBigDecimal("allday"));
        shiftMiddleRule.setAlldayhour(shiftDy.getBigDecimal("alldayhour"));
        shiftMiddleRule.setHalfday(shiftDy.getBigDecimal("halfday"));
        shiftMiddleRule.setHalfdayhour(shiftDy.getBigDecimal("halfdayhour"));
        shiftMiddleRule.setMiddleRefDate(RefDateType.from((String)shiftDy.getString("refmiddlepoint")));
        shift.setShiftMiddleRule(shiftMiddleRule);
        shift.setOneCardType(shiftDy.getString("onecardtype"));
        this.handleTakeCardRule(shiftDy, shift);
        this.handleShiftDetail(shiftDy, shift);
        shift.setStandardTime(Integer.valueOf(this.getStandardTime(shiftDy)));
        return shift;
    }

    private void handleTakeCardRule(DynamicObject shiftDy, Shift shift) {
        DynamicObject clockRule = shiftDy.getDynamicObject("clockrule");
        if (clockRule != null) {
            TakeCardRule takeCardRule = this.getTakeCardRule(clockRule);
            shift.setTakeCardRule(takeCardRule);
        }
    }

    private TakeCardRule getTakeCardRule(DynamicObject clockRule) {
        TakeCardRule takeCardRule = new TakeCardRule();
        takeCardRule.setId(clockRule.getLong("id"));
        takeCardRule.setConfigId(null != clockRule.get("takecardconfig") ? clockRule.getLong("takecardconfig.id") : 0L);
        takeCardRule.setOffShift(clockRule.getBoolean("isoff"));
        takeCardRule.setOffShiftTaskCardMode(clockRule.getString("offmode"));
        takeCardRule.setContinueCard(clockRule.getBoolean("iscontinuecard"));
        takeCardRule.setOvertimeTakeCardMode(clockRule.getBoolean("isotapplytakecard"));
        takeCardRule.setCardShare(clockRule.getBoolean("iscardshare"));
        takeCardRule.setOffShiftStart(clockRule.getInt("takecardstarttime"));
        takeCardRule.setOffShiftEnd(clockRule.getInt("takecardendtime"));
        DynamicObjectCollection ruleEntry = clockRule.getDynamicObjectCollection("wtbd_tcardruleentry");
        ArrayList<TimeSeq> timeSeqList = new ArrayList<TimeSeq>(ruleEntry.size());
        for (DynamicObject entry : ruleEntry) {
            TimeSeq timeSeq = new TimeSeq();
            timeSeq.setTimeSeq(Integer.valueOf(entry.getInt("timeseq")));
            timeSeq.setStartBeforeScope(Integer.valueOf(entry.getInt("sbeforescope")));
            timeSeq.setStartAfterScope(Integer.valueOf(entry.getInt("safterscope")));
            timeSeq.setStartTakeCardRule(entry.getString("stakecardrule"));
            timeSeq.setStartTakeCardSameLen((String)entry.get("stakecardsamelen"));
            timeSeq.setEndBeforeScope(Integer.valueOf(entry.getInt("ebeforescope")));
            timeSeq.setEndAfterScope(Integer.valueOf(entry.getInt("eafterscope")));
            timeSeq.setEndTakeCardRule(entry.getString("etakecardrule"));
            timeSeq.setEndTakeCardSameLen((String)entry.get("etakecardsamelen"));
            timeSeqList.add(timeSeq);
        }
        takeCardRule.setTimeSeqList(timeSeqList);
        return takeCardRule;
    }

    private void handleShiftDetail(DynamicObject shiftDy, Shift shift) {
        List<ShiftDetail> shiftDetailList = this.getShiftDetailList(shiftDy);
        shift.setFlexShift(this.getShiftCoreDetailList(shiftDetailList));
        shift.setShiftDetailList(shiftDetailList);
    }

    public List<ShiftDetail> getShiftDetailList(DynamicObject shiftDy) {
        DynamicObjectCollection entryEntity = shiftDy.getDynamicObjectCollection("entryentity");
        ArrayList shiftDetailList = Lists.newArrayListWithCapacity((int)entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            ShiftDetail shiftDetail = new ShiftDetail();
            shiftDetail.setOutWorkType(entry.getString("outworktype"));
            shiftDetail.setRefStartDay(entry.getString("refstartday"));
            shiftDetail.setRefEndDay(entry.getString("refendday"));
            shiftDetail.setShiftStartDate(entry.getInt("shiftstartdate"));
            shiftDetail.setShiftEndDate(entry.getInt("shiftenddate"));
            shiftDetail.setShiftStartDateStr(new TimeUtils(0, 0, 0, shiftDetail.getShiftStartDate()).getHourMinuteString());
            shiftDetail.setShiftEndDateStr(new TimeUtils(0, 0, 0, shiftDetail.getShiftEndDate()).getHourMinuteString());
            shiftDetail.setWorkTimeStart(entry.getBoolean("isworktimestart"));
            shiftDetail.setWorkTimeEnd(entry.getBoolean("isworktimeend"));
            shiftDetail.setWorkTime(entry.getBigDecimal("worktime"));
            long shiftPeriodId = entry.getLong("shiftperiod.id");
            if (shiftPeriodId != 0L) {
                BaseDataVo shiftPeriod = new BaseDataVo();
                shiftPeriod.setId(shiftPeriodId);
                shiftPeriod.setNumber(entry.getString("shiftperiod.number"));
                shiftDetail.setShiftPeriod(shiftPeriod);
            }
            shiftDetailList.add(shiftDetail);
            DynamicObject obj = entry.getDynamicObject("punchcardpairid");
            if (obj == null) continue;
            if (shiftDetail.isWorkTimeStart()) {
                DynamicObject startPunchCardPoint = (DynamicObject)obj.getDynamicObjectCollection("entryentity").get(0);
                shiftDetail.setStartPunchCardPointEntryId(startPunchCardPoint.getLong("id"));
                shiftDetail.setStartPunchCardPoint(startPunchCardPoint.getString("punch"));
            }
            if (!shiftDetail.isWorkTimeEnd()) continue;
            DynamicObject endPunchCardPoint = (DynamicObject)obj.getDynamicObjectCollection("entryentity").get(1);
            shiftDetail.setEndPunchCardPointEntryId(endPunchCardPoint.getLong("id"));
            shiftDetail.setEndPunchCardPoint(endPunchCardPoint.getString("punch"));
        }
        return shiftDetailList;
    }

    public List<ShiftDetail> getShiftCoreDetailList(List<ShiftDetail> shiftDetailList) {
        return shiftDetailList.stream().filter(shiftDetail -> OutWorkType.CORE_TIME.code.equals(shiftDetail.getOutWorkType())).collect(Collectors.toList());
    }

    public String seconds2Time(int seconds) {
        int minute = seconds / 60;
        int hour = 0;
        if (minute >= 60) {
            hour = minute / 60;
            minute %= 60;
        }
        return String.format("%02d:%02d", hour, minute);
    }

    public String genShiftPeriodDesc(Shift shift, String delimiter) {
        String shiftStartStr = this.seconds2Time(shift.getLastShiftStartDate());
        String shiftEndStr = this.seconds2Time(shift.getLastShiftEndDate());
        return shiftStartStr + delimiter + shiftEndStr;
    }

    public int getStandardTime(DynamicObject shift) {
        int shiftEnd = this.getRefTime(shift.getInt("shiftend"), shift.getString("referenceendday"));
        int shiftStart = this.getRefTime(shift.getInt("shiftstart"), shift.getString("referencestartday"));
        int restTime = shift.getDynamicObjectCollection("entryentity").stream().filter(detail -> OutWorkType.BREAK.code.equals(detail.getString("outworktype"))).map(detail -> this.getRefTime(detail.getInt("shiftenddate"), detail.getString("refendday")) - this.getRefTime(detail.getInt("shiftstartdate"), detail.getString("refstartday"))).reduce(Integer::sum).orElse(0);
        return shiftEnd - shiftStart - restTime;
    }

    private int getRefTime(int seconds, String refDateType) {
        if (RefDateType.NEXTDAY.code.equals(refDateType)) {
            return seconds + 86400;
        }
        return seconds;
    }

    public String getShiftEntryTip(DynamicObject shiftDy, String lineSeparator) {
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection shiftEntryDys = shiftDy.getDynamicObjectCollection("entryentity");
        String symbol = WTCSymbolMultiLanguageUtil.getColonSymbol();
        for (DynamicObject shiftEntryDy : shiftEntryDys) {
            String outWorkType;
            OutWorkType outWorkTypeEnum;
            if (sb.length() != 0) {
                sb.append(lineSeparator);
            }
            sb.append((outWorkTypeEnum = OutWorkType.from((String)(outWorkType = shiftEntryDy.getString("outworktype")))) != null ? outWorkTypeEnum.getName() : outWorkType);
            sb.append(symbol);
            int startTime = shiftEntryDy.getInt("shiftstartdate");
            int endTime = shiftEntryDy.getInt("shiftenddate");
            sb.append(WTCDateUtils.secondToTime((long)startTime, (String)"h:m"));
            String refStart = shiftEntryDy.getString("refstartday");
            if (RefDateType.NEXTDAY.code.equals(refStart)) {
                ComboProp refDayProp = (ComboProp)shiftEntryDy.getDataEntityType().getProperties().get((Object)"refstartday");
                sb.append(String.format(WTCBaseKDString.bracket(), refDayProp.getItemByName(refStart)));
                startTime = RefDateType.NEXTDAY.getAdjustSecond(startTime);
            }
            sb.append("~");
            sb.append(WTCDateUtils.secondToTime((long)endTime, (String)"h:m"));
            String refEnd = shiftEntryDy.getString("refendday");
            if (RefDateType.NEXTDAY.code.equals(refEnd)) {
                ComboProp refDayProp = (ComboProp)shiftEntryDy.getDataEntityType().getProperties().get((Object)"refendday");
                sb.append(String.format(WTCBaseKDString.bracket(), refDayProp.getItemByName(refEnd)));
                endTime = RefDateType.NEXTDAY.getAdjustSecond(endTime);
            }
            int gap = endTime - startTime;
            sb.append("(").append(WTCDateUtils.secondToTime((long)gap, (String)(gap % 3600 == 0 ? "hh" : "hhmm"))).append(")");
        }
        return sb.toString();
    }
}

