/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.history.service.WTCSnapService;
import kd.wtc.wtbs.business.shift.DutyShiftQueryResponse;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.lang.WTCBizException;
import kd.wtc.wtbs.common.lang.WTCErrorCodes;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.RosterRepairAndAdvance;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.util.TimeUtils;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class WTCRosterService {
    private static final Log LOGGER = LogFactory.getLog(WTCRosterService.class);
    private static final int QUERY_PAGE_FACTOR = WTCAppContextHelper.getProjectParams().getInteger("kd.wtc.wtbs.roster.querySize", Integer.valueOf(999));
    private static final HRBaseServiceHelper ROSTERHELPER = new HRBaseServiceHelper("wts_personroster");
    private static final HRBaseServiceHelper ROSTERHISHELPER = new HRBaseServiceHelper("wts_personrosterhis");
    private static final HRBaseServiceHelper DATETYPESERVICEHELPER = new HRBaseServiceHelper("wtbd_datetype");
    private static final String ORG_ROSTER_SELECT_PROPERTY = "id,boid,adminorg.id adminorg,adminorg.name adminorgname,ischange,rosterdate,islock,plancomplete,shift.id shift,modifytime";
    private static final String SELECT_WORKDAYS_PROPERTY = "id,boid,attfilebase,rosterdate,dateproperty,rostertype,modifytime";
    private static final int BATCH_SAVE_SIZE = WTCAppContextHelper.getProjectParams().getInteger("kd.wtc.wtbs.roster.batchSaveSize", Integer.valueOf(999));

    public static DynamicObject[] getPersonRosterDy(Collection<Long> attPersonIdList, Date startDate, Date endDate) {
        return WTCRosterService.getPersonRosterDy(attPersonIdList, startDate, endDate, null);
    }

    public static DynamicObject[] getPersonRosterDy(Collection<Long> attPersonIdList, Date startDate, Date endDate, QFilter qFilter) {
        QFilter[] qFilters = WTCRosterService.getRosterQFilters(attPersonIdList, startDate, endDate, qFilter);
        String rostersSelectProperty = "id,boid,attperson.id attperson,ischange,workschedule,rosterdate,rostersource,islock,plancomplete,rostertype,datetype,holiday,shift.id shift, dateproperty, orgindatetype, orgindateproperty,attfilebase,createtime,modifytime";
        return WTCRosterService.getDistinctDys(ROSTERHELPER.queryOriginalArray(rostersSelectProperty, qFilters, "rosterdate asc"));
    }

    public static DynamicObject[] getPersonRosterDyByAttFileBaseBoId(Collection<Long> attAttFileBoIdList, Date startDate, Date endDate, QFilter dateListFilter) {
        return WTCRosterService.getPersonRosterDyByAttFileBaseBoId(null, attAttFileBoIdList, startDate, endDate, dateListFilter, null);
    }

    public static DynamicObject[] getPersonRosterDyByAttFileBaseBoId(Collection<Long> attAttFileBoIdList, Date startDate, Date endDate, QFilter dateListFilter, QFilter commonQFilter) {
        return WTCRosterService.getPersonRosterDyByAttFileBaseBoId(null, attAttFileBoIdList, startDate, endDate, dateListFilter, commonQFilter);
    }

    private static DynamicObject[] getPersonRosterDyByAttFileBaseBoId(String selectProperty, Collection<Long> attAttFileBoIdList, Date startDate, Date endDate, QFilter dateListFilter, QFilter commonQFilter) {
        LOGGER.debug("TieInitializerRoster getPersonRosterDyByAttFileBaseBoId step 1, attAttFileBoIdList.size:{}, startDate:{}, endDate:{}", new Object[]{attAttFileBoIdList.size(), startDate, endDate});
        QFilter currentVersionQFilter = WTCHisServiceHelper.isCurrentVersion((boolean)true);
        QFilter dateRangeFilter = new QFilter("rosterdate", ">=", (Object)startDate).and(new QFilter("rosterdate", "<=", (Object)endDate));
        DynamicObject[] allRosterDys = WTCRosterService.batchQueryRosterData(selectProperty, attAttFileBoIdList, dateListFilter, currentVersionQFilter, dateRangeFilter, commonQFilter);
        DynamicObject[] distinctDys = WTCRosterService.getDistinctDys(allRosterDys);
        return distinctDys;
    }

    private static DynamicObject[] batchQueryRosterData(String selectProperty, Collection<Long> attAttFileBoIdList, QFilter dateListFilter, QFilter currentVersionQFilter, QFilter dateRangeFilter, QFilter commonQFilter) {
        ArrayList list = new ArrayList(0);
        int pageSize = attAttFileBoIdList.size() % QUERY_PAGE_FACTOR == 0 ? attAttFileBoIdList.size() / QUERY_PAGE_FACTOR : attAttFileBoIdList.size() / QUERY_PAGE_FACTOR + 1;
        for (int i = 0; i < pageSize; ++i) {
            QFilter attFileBoIdFilter = new QFilter("attfilebase", "in", attAttFileBoIdList.stream().skip((long)i * (long)QUERY_PAGE_FACTOR).limit(QUERY_PAGE_FACTOR).collect(Collectors.toList()));
            QFilter[] qFilters = new QFilter[]{attFileBoIdFilter, currentVersionQFilter, dateRangeFilter, commonQFilter};
            DynamicObject[] dateRangeRosterDyArr = HRStringUtils.isEmpty((String)selectProperty) ? WTCRosterService.loadRosterDys(qFilters) : ROSTERHELPER.queryOriginalArray(selectProperty, qFilters);
            list.addAll(Arrays.stream(dateRangeRosterDyArr).collect(Collectors.toList()));
            if (dateListFilter == null) continue;
            qFilters = new QFilter[]{attFileBoIdFilter, dateListFilter, currentVersionQFilter, commonQFilter};
            DynamicObject[] dateListRosterDyArr = HRStringUtils.isEmpty((String)selectProperty) ? WTCRosterService.loadRosterDys(qFilters) : ROSTERHELPER.queryOriginalArray(selectProperty, qFilters);
            list.addAll(Arrays.stream(dateListRosterDyArr).collect(Collectors.toList()));
        }
        LOGGER.debug("TieInitializerRoster.getPersonRosterDyByAttFileBaseBoId step 2\uff0c list.size:{}", (Object)list.size());
        return list.toArray(new DynamicObject[0]);
    }

    private static DynamicObject[] loadRosterDys(QFilter[] qFilters) {
        ArrayList listIds = new ArrayList();
        try (DataSet ds = null;){
            ds = QueryServiceHelper.queryDataSet((String)"WTCRosterService.loadRosterDys", (String)"wts_personroster", (String)"id", (QFilter[])qFilters, null);
            ds.forEach(row -> listIds.add(row.get(0)));
        }
        if (listIds.size() > HugeInConfig.inMaxSize()) {
            throw new WTCBizException(WTCErrorCodes.QUERY_OVER_MAX_SIZE, new Object[]{"roster"});
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"wts_personroster");
        return BusinessDataServiceHelper.load((Object[])listIds.toArray(), (DynamicObjectType)type);
    }

    public static DynamicObject[] getPersonRosterWithFilter(String selectProperty, Collection<Long> attAttFileBoIdList, Date startDate, Date endDate, QFilter filter) {
        QFilter attFileBoIdFilter = new QFilter("attfilebase", "in", attAttFileBoIdList);
        QFilter dateRangeFilter = new QFilter("rosterdate", ">=", (Object)startDate).and(new QFilter("rosterdate", "<=", (Object)endDate));
        attFileBoIdFilter.and(WTCHisServiceHelper.isCurrentVersion((boolean)true));
        QFilter[] qFilters = new QFilter[]{attFileBoIdFilter, dateRangeFilter, filter};
        return WTCRosterService.getDistinctDys(HRStringUtils.isEmpty((String)selectProperty) ? WTCRosterService.loadRosterDys(qFilters) : ROSTERHELPER.queryOriginalArray(selectProperty, qFilters));
    }

    public static DynamicObject[] getAdminOrgRosterDy(Collection<Long> adminOrgIdList, Date startDate, Date endDate, QFilter qFilter) {
        QFilter dateQFilter = WTCRosterService.getDateFilter(startDate, endDate);
        QFilter adminOrgQFilter = WTCHisServiceHelper.isCurrentVersion((boolean)true);
        if (adminOrgIdList != null) {
            adminOrgQFilter.and(new QFilter("adminorg", "in", adminOrgIdList));
        }
        HRBaseServiceHelper rosterServiceHelper = new HRBaseServiceHelper("wts_orgroster");
        DynamicObject[] orgRosterDys = rosterServiceHelper.queryOriginalArray(ORG_ROSTER_SELECT_PROPERTY, new QFilter[]{adminOrgQFilter, dateQFilter, qFilter}, "rosterdate asc");
        return Arrays.stream(orgRosterDys).collect(Collectors.toMap(dy -> dy.getString("adminorg") + (dy.getDate("rosterdate") == null ? null : Long.valueOf(dy.getDate("rosterdate").getTime())), Function.identity(), (dy1, dy2) -> {
            Date createTime1 = dy1.getDate("modifytime");
            if (createTime1 == null) {
                return dy1;
            }
            Date createTime2 = dy2.getDate("modifytime");
            if (createTime2 == null) {
                return dy2;
            }
            return createTime1.after(createTime2) ? dy1 : dy2;
        })).values().toArray(new DynamicObject[0]);
    }

    public static DutyShiftResponse getAdminDutyShiftResponse(DynamicObject[] dynamicObjects, Date startDate, Date endDate) {
        ArrayList<DutyShift> list = new ArrayList<DutyShift>(dynamicObjects.length);
        for (DynamicObject rosterDy : dynamicObjects) {
            DutyShift dutyShift = new DutyShift();
            Long shiftId = WTCRosterService.getBaseDataId(rosterDy, "shift");
            if (shiftId == 0L) continue;
            dutyShift.setId(rosterDy.getLong("id"));
            dutyShift.setBoId(rosterDy.getLong("boid"));
            dutyShift.setAdminOrgId(WTCRosterService.getBaseDataId(rosterDy, "adminorg").longValue());
            dutyShift.setShiftId(WTCRosterService.getBaseDataId(rosterDy, "shift").longValue());
            dutyShift.setRosterDate(rosterDy.getDate("rosterdate"));
            dutyShift.setLock(Boolean.valueOf(rosterDy.getBoolean("islock")));
            dutyShift.setPlanComplete(Boolean.valueOf(rosterDy.getBoolean("plancomplete")));
            list.add(dutyShift);
        }
        Map<Long, List<DutyShift>> dutyShiftMap = list.stream().collect(Collectors.groupingBy(DutyShift::getAdminOrgId));
        return new DutyShiftQueryResponse(dutyShiftMap);
    }

    private static QFilter[] getRosterQFilters(Collection<Long> attPersonIdList, Date startDate, Date endDate, QFilter qFilter) {
        QFilter dateQFilter = WTCRosterService.getDateFilter(startDate, endDate);
        QFilter attPersonQFilter = new QFilter("attperson.id", "in", attPersonIdList);
        attPersonQFilter.and(WTCHisServiceHelper.isCurrentVersion((boolean)true));
        return new QFilter[]{attPersonQFilter, dateQFilter, qFilter};
    }

    private static QFilter getDateFilter(Date startDate, Date endDate) {
        QFilter dateQFilter = new QFilter("rosterdate", ">=", (Object)startDate);
        dateQFilter.and(new QFilter("rosterdate", "<=", (Object)endDate));
        return dateQFilter;
    }

    public static Map<Long, List<DutyShift>> getShiftDutyMap(Collection<Long> attPersonIdList, Date startDate, Date endDate, DynamicObject[] rosterDataArr) {
        List<DynamicObject> rosterDataList = Arrays.stream(rosterDataArr).collect(Collectors.toList());
        WTCRosterService.filterSameData(rosterDataList);
        rosterDataList.forEach(d -> d.set("rostersource", (Object)"0"));
        Long[] dateTypeIds = (Long[])rosterDataList.stream().map(dy -> dy.getLong("datetype")).distinct().toArray(Long[]::new);
        Long[] originDateTypeIds = (Long[])rosterDataList.stream().map(dy -> dy.getLong("orgindatetype")).distinct().toArray(Long[]::new);
        HashSet<Long> typeSets = new HashSet<Long>(16);
        typeSets.addAll(Arrays.asList(dateTypeIds));
        typeSets.addAll(Arrays.asList(originDateTypeIds));
        DynamicObject[] dateTypeDyArr = DATETYPESERVICEHELPER.loadDynamicObjectArray(typeSets.toArray());
        Map dateTypeDyMap = Arrays.stream(dateTypeDyArr).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        HRBaseServiceHelper datePropertyHelper = new HRBaseServiceHelper("wtbd_dateproperty");
        Long[] datePropertyIds = (Long[])rosterDataList.stream().map(dy -> dy.getLong("dateproperty")).distinct().toArray(Long[]::new);
        Long[] orginDatePropertyIds = (Long[])rosterDataList.stream().map(dy -> dy.getLong("orgindateproperty")).distinct().toArray(Long[]::new);
        HashSet<Long> propertySets = new HashSet<Long>(16);
        propertySets.addAll(Arrays.asList(datePropertyIds));
        propertySets.addAll(Arrays.asList(orginDatePropertyIds));
        DynamicObject[] datePropertyArr = datePropertyHelper.loadDynamicObjectArray(propertySets.toArray());
        Map<Long, String> datePropertyMap = Arrays.stream(datePropertyArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy1 -> dy1.getString("number"), (n1, n2) -> n1));
        return rosterDataList.stream().map(dy -> WTCRosterService.genDutyShiftObj(dy, dateTypeDyMap, datePropertyMap)).collect(Collectors.groupingBy(DutyShift::getAttPersonId));
    }

    private static Long getAttFileBoId(DynamicObject rosterDy) {
        return rosterDy.get("attfilebase") instanceof Long ? rosterDy.getLong("attfilebase") : rosterDy.getLong("attfilebase.boid");
    }

    public static Map<Long, List<DutyShift>> getShiftDutyMapByAttFileBaseBoId(Collection<Long> attFileBaseBoIdList, Date startDate, Date endDate, DynamicObject[] rosterDataArr) {
        HashMap<Long, List<DutyShift>> map = new HashMap<Long, List<DutyShift>>(16);
        if (rosterDataArr == null || rosterDataArr.length == 0) {
            LOGGER.debug("WTCRosterService.getShiftDutyMapByAttFileBaseBoId rosterArr is null");
            return map;
        }
        LOGGER.debug("rosterArr.size\uff1a{}", (Object)rosterDataArr.length);
        List<DynamicObject> rosterDataList = Arrays.stream(rosterDataArr).collect(Collectors.toList());
        WTCRosterService.filterSameData(rosterDataList);
        Long[] dateTypeIds = (Long[])rosterDataList.stream().map(WTCRosterService::getDateTypeId).distinct().toArray(Long[]::new);
        Long[] originDateTypeIds = (Long[])rosterDataList.stream().map(WTCRosterService::getOriginDateTypeId).distinct().toArray(Long[]::new);
        HashSet<Long> typeSets = new HashSet<Long>(16);
        typeSets.addAll(Arrays.asList(dateTypeIds));
        typeSets.addAll(Arrays.asList(originDateTypeIds));
        DynamicObject[] dateTypeDyArr = DATETYPESERVICEHELPER.loadDynamicObjectArray(typeSets.toArray());
        Map dateTypeDyMap = Arrays.stream(dateTypeDyArr).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        HRBaseServiceHelper datePropertyHelper = new HRBaseServiceHelper("wtbd_dateproperty");
        Long[] datePropertyIds = (Long[])rosterDataList.stream().map(WTCRosterService::getDatePropertyId).distinct().toArray(Long[]::new);
        Long[] orginDatePropertyIds = (Long[])rosterDataList.stream().map(WTCRosterService::getOriginDatePropertyId).distinct().toArray(Long[]::new);
        HashSet<Long> propertySets = new HashSet<Long>(16);
        propertySets.addAll(Arrays.asList(datePropertyIds));
        propertySets.addAll(Arrays.asList(orginDatePropertyIds));
        DynamicObject[] datePropertyArr = datePropertyHelper.loadDynamicObjectArray(propertySets.toArray());
        Map<Long, String> datePropertyMap = Arrays.stream(datePropertyArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy1 -> dy1.getString("number"), (n1, n2) -> n1));
        return rosterDataList.stream().map(dy -> WTCRosterService.genDutyShiftObjByBoId(dy, dateTypeDyMap, datePropertyMap)).collect(Collectors.groupingBy(DutyShift::getAttFileBaseBoId));
    }

    private static void filterSameData(List<DynamicObject> syncWsRosterList) {
        if (CollectionUtils.isEmpty(syncWsRosterList)) {
            return;
        }
        Iterator<DynamicObject> iterator = syncWsRosterList.iterator();
        HashMap map = Maps.newHashMapWithExpectedSize((int)syncWsRosterList.size());
        while (iterator.hasNext()) {
            DynamicObject next = iterator.next();
            Long attFileBase = WTCRosterService.getAttFileBoId(next);
            Date rosterDate = next.getDate("rosterdate");
            String rosterType = next.getString("rostertype");
            String key = attFileBase + ":" + WTCDateUtils.date2Str((Date)rosterDate, (String)"yyyy-MM-dd") + ":" + rosterType;
            String existKey = (String)map.get(key);
            if (HRStringUtils.isEmpty((String)existKey)) {
                map.put(key, key);
                continue;
            }
            iterator.remove();
        }
    }

    public static Map<String, DynamicObject> getWorkScheduleEntryMap(Date startDate, Date endDate, Set<Long> workScheduleIdSet) {
        HRBaseServiceHelper workScheduleServiceHelper = new HRBaseServiceHelper("wtbd_workscheduleentryq");
        String workScheduleSelectProperty = "fid,workdate,shiftid,holidayid,datetype,datepropertyid,oridatetype,oridatepropertyid";
        QFilter workScheduleQFilter = new QFilter("fid", "in", workScheduleIdSet);
        QFilter workScheduleDateQFilter = new QFilter("workdate", ">=", (Object)startDate);
        workScheduleDateQFilter.and(new QFilter("workdate", "<=", (Object)endDate));
        DynamicObject[] workScheduleEntryArr = workScheduleServiceHelper.query(workScheduleSelectProperty, new QFilter[]{workScheduleQFilter, workScheduleDateQFilter});
        return Arrays.stream(workScheduleEntryArr).collect(Collectors.toMap(dy -> WTCRosterService.getMapKey(dy, "fid", "workdate"), dy -> dy, (n1, n2) -> n1));
    }

    public static DutyShift genDutyShiftObj(DynamicObject rosterDy, Map<Long, DynamicObject> dateTypeDyMap, Map<Long, String> datePropertyMap) {
        DynamicObject originDateTypeDy;
        DynamicObject dateTypeDy;
        String orginDateProperty;
        DutyShift dutyShift = new DutyShift();
        dutyShift.setId(rosterDy.getLong("id"));
        dutyShift.setBoId(rosterDy.getLong("boid"));
        dutyShift.setAttPersonId(rosterDy.getLong("attperson"));
        dutyShift.setShiftId(rosterDy.getLong("shift"));
        dutyShift.setRosterDate(rosterDy.getDate("rosterdate"));
        dutyShift.setDateType(rosterDy.getString("datetype"));
        dutyShift.setAttFileBaseBoId(Long.valueOf(rosterDy.getLong("attfilebase")));
        String dateProperty = datePropertyMap.get(rosterDy.getLong("dateproperty"));
        if (dateProperty != null) {
            dutyShift.setDateAttribute(DateAttribute.from((String)dateProperty));
        }
        if ((orginDateProperty = datePropertyMap.get(rosterDy.getLong("orgindateproperty"))) != null) {
            dutyShift.setOrginDateAttribute(DateAttribute.from((String)orginDateProperty));
        }
        if ((dateTypeDy = dateTypeDyMap.get(rosterDy.getLong("datetype"))) != null) {
            long dateTypeId = dateTypeDy.getLong("id");
            String name = dateTypeDy.getString("name");
            ILocaleString localeString = dateTypeDy.getLocaleString("name");
            String chineseName = localeString != null ? localeString.getLocaleValue_zh_CN() : null;
            String number = dateTypeDy.getString("number");
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)dateTypeDy.get("name");
            dutyShift.setDateTypeModel(new DateType(Long.valueOf(dateTypeId), number, name, chineseName, null, ormLocaleValue));
        }
        if ((originDateTypeDy = dateTypeDyMap.get(rosterDy.getLong("orgindatetype"))) != null) {
            long dateTypeId = originDateTypeDy.getLong("id");
            String name = originDateTypeDy.getString("name");
            String number = originDateTypeDy.getString("number");
            dutyShift.setOriginDateTypeModel(new DateType(Long.valueOf(dateTypeId), number, name, null));
        }
        dutyShift.setRosterType(rosterDy.getString("rostertype"));
        dutyShift.setHoliday(rosterDy.getString("holiday"));
        dutyShift.setLock(Boolean.valueOf(rosterDy.getBoolean("islock")));
        dutyShift.setPlanComplete(Boolean.valueOf(rosterDy.getBoolean("plancomplete")));
        dutyShift.setRosterSource(rosterDy.getString("rostersource"));
        return dutyShift;
    }

    public static DutyShift genDutyShiftObjByBoId(DynamicObject rosterDy, Map<Long, DynamicObject> dateTypeDyMap, Map<Long, String> datePropertyMap) {
        DynamicObject originDateTypeDy;
        DynamicObject dateTypeDy;
        String orginDateProperty;
        DutyShift dutyShift = new DutyShift();
        dutyShift.setId(rosterDy.getLong("id"));
        dutyShift.setBoId(rosterDy.getLong("boid"));
        dutyShift.setAttPersonId(WTCRosterService.getBaseDataId(rosterDy, "attperson").longValue());
        dutyShift.setShiftId(WTCRosterService.getBaseDataId(rosterDy, "shift").longValue());
        dutyShift.setRosterDate(rosterDy.getDate("rosterdate"));
        dutyShift.setAttFileBaseBoId(WTCRosterService.getBaseDataId(rosterDy, "attfilebase"));
        String dateProperty = datePropertyMap.get(WTCRosterService.getDatePropertyId(rosterDy));
        if (dateProperty != null) {
            dutyShift.setDateAttribute(DateAttribute.from((String)dateProperty));
        }
        if ((orginDateProperty = datePropertyMap.get(WTCRosterService.getOriginDatePropertyId(rosterDy))) != null) {
            dutyShift.setOrginDateAttribute(DateAttribute.from((String)orginDateProperty));
        }
        if ((dateTypeDy = dateTypeDyMap.get(WTCRosterService.getDateTypeId(rosterDy))) != null) {
            long dateTypeId = dateTypeDy.getLong("id");
            String name = dateTypeDy.getString("name");
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)dateTypeDy.get("name");
            ILocaleString localeString = dateTypeDy.getLocaleString("name");
            String chineseName = localeString != null ? localeString.getLocaleValue_zh_CN() : null;
            String number = dateTypeDy.getString("number");
            dutyShift.setDateTypeModel(new DateType(Long.valueOf(dateTypeId), number, name, chineseName, null, ormLocaleValue));
        }
        if ((originDateTypeDy = dateTypeDyMap.get(WTCRosterService.getOriginDateTypeId(rosterDy))) != null) {
            long dateTypeId = originDateTypeDy.getLong("id");
            String name = originDateTypeDy.getString("name");
            String number = originDateTypeDy.getString("number");
            dutyShift.setOriginDateTypeModel(new DateType(Long.valueOf(dateTypeId), number, name, null));
        }
        dutyShift.setRosterType(rosterDy.getString("rostertype"));
        dutyShift.setHoliday(rosterDy.getString("holiday"));
        dutyShift.setLock(Boolean.valueOf(rosterDy.getBoolean("islock")));
        dutyShift.setPlanComplete(Boolean.valueOf(rosterDy.getBoolean("plancomplete")));
        dutyShift.setRosterSource(rosterDy.getString("rostersource"));
        return dutyShift;
    }

    private static Long getBaseDataId(DynamicObject dynamicObject, String baseDataKey) {
        Object obj = dynamicObject.get(baseDataKey);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        return 0L;
    }

    private static Long getDatePropertyId(DynamicObject rosterDy) {
        return rosterDy.get("dateproperty") instanceof Long ? rosterDy.getLong("dateproperty") : rosterDy.getLong("dateproperty.id");
    }

    private static Long getOriginDatePropertyId(DynamicObject rosterDy) {
        return rosterDy.get("orgindateproperty") instanceof Long ? rosterDy.getLong("orgindateproperty") : rosterDy.getLong("orgindateproperty.id");
    }

    private static Long getDateTypeId(DynamicObject rosterDy) {
        return rosterDy.get("datetype") instanceof Long ? rosterDy.getLong("datetype") : rosterDy.getLong("datetype.id");
    }

    private static Long getOriginDateTypeId(DynamicObject rosterDy) {
        return rosterDy.get("orgindatetype") instanceof Long ? rosterDy.getLong("orgindatetype") : rosterDy.getLong("orgindatetype.id");
    }

    public static ShiftDetail genShiftDetailObj(DynamicObject shiftEntryDy) {
        ShiftDetail shiftDetail = new ShiftDetail();
        shiftDetail.setWorkTimeEnd(shiftEntryDy.getBoolean("isworktimeend"));
        shiftDetail.setWorkTimeStart(shiftEntryDy.getBoolean("isworktimestart"));
        shiftDetail.setRefEndDay(shiftEntryDy.getString("refendday"));
        shiftDetail.setRefStartDay(shiftEntryDy.getString("refstartday"));
        shiftDetail.setOutWorkType(shiftEntryDy.getString("outworktype"));
        int shiftEndDate = shiftEntryDy.getInt("shiftenddate");
        shiftDetail.setShiftEndDate(shiftEndDate);
        int shiftStartDate = shiftEntryDy.getInt("shiftstartdate");
        shiftDetail.setShiftStartDate(shiftStartDate);
        shiftDetail.setShiftStartDateStr(new TimeUtils(0, 0, 0, shiftStartDate).getHourMinuteString());
        shiftDetail.setShiftEndDateStr(new TimeUtils(0, 0, 0, shiftEndDate).getHourMinuteString());
        shiftDetail.setWorkTime(shiftEntryDy.getBigDecimal("worktime") == null ? BigDecimal.valueOf(0L) : shiftEntryDy.getBigDecimal("worktime"));
        return shiftDetail;
    }

    public static String getMapKey(DynamicObject dy, String workScheduleName, String dateName) {
        return dy.getString(workScheduleName) + HRDateTimeUtils.format((Date)dy.getDate(dateName), (String)"yyyy-MM-dd");
    }

    public static DynamicObject[] getDistinctDys(DynamicObject[] rosterDys) {
        HashMap distinctMap = Maps.newHashMapWithExpectedSize((int)rosterDys.length);
        for (DynamicObject rosterDy : rosterDys) {
            String uniqueKey = WTCRosterService.genRosterDataUniqueKey(rosterDy);
            distinctMap.merge(uniqueKey, rosterDy, (rosterDy1, rosterDy2) -> {
                Date createTime1 = rosterDy1.getDate("modifytime");
                if (createTime1 == null) {
                    return rosterDy1;
                }
                Date createTime2 = rosterDy2.getDate("modifytime");
                if (createTime2 == null) {
                    return rosterDy2;
                }
                return createTime1.after(createTime2) ? rosterDy1 : rosterDy2;
            });
        }
        return distinctMap.values().toArray(new DynamicObject[0]);
    }

    private static String genRosterDataUniqueKey(DynamicObject rosterDy) {
        Long attFileBaseId = WTCRosterService.getBaseDataId(rosterDy, "attfilebase");
        Date rosterDate = rosterDy.getDate("rosterdate");
        String rosterType = rosterDy.getString("rostertype");
        return WTCRosterService.genRosterDataUniqueKey(attFileBaseId, rosterDate, rosterType);
    }

    public static String genRosterDataUniqueKey(Long attFileBoId, Date rosterDate, String rosterType) {
        return rosterType + '_' + attFileBoId + '_' + rosterDate.getTime();
    }

    public static void saveRosterData(DynamicObject[] rosterDys) {
        LOGGER.info("WTCRosterService.saveRosterData.start.size:{}", (Object)rosterDys.length);
        if (rosterDys.length > 0) {
            int totalSize = rosterDys.length;
            int pages = totalSize % BATCH_SAVE_SIZE == 0 ? totalSize / BATCH_SAVE_SIZE : totalSize / BATCH_SAVE_SIZE + 1;
            List<DynamicObject> list = Arrays.asList(rosterDys);
            int addCount = (int)list.stream().filter(dy -> dy.getLong("boid") == 0L).count();
            long[] ids = ID.genLongIds((int)addCount);
            int index = 0;
            String tableName = rosterDys[0].getDataEntityType().getAlias();
            long userId = RequestContext.get().getCurrUserId();
            for (DynamicObject rosterDy : list) {
                long boid = rosterDy.getLong("boid");
                if (boid == 0L) {
                    long id = ids[index++];
                    rosterDy.set("id", (Object)id);
                    rosterDy.set("boid", (Object)id);
                    rosterDy.set("iscurrentversion", (Object)Boolean.TRUE);
                    rosterDy.set("datastatus", (Object)"1");
                    rosterDy.set("creator", (Object)userId);
                    continue;
                }
                if (rosterDy.getDataEntityState().getPkSnapshotSet() != null) continue;
                PkSnapshotSet pkSnapshotSet = new PkSnapshotSet();
                PkSnapshot pkSnapshot = new PkSnapshot();
                pkSnapshot.TableName = tableName;
                pkSnapshot.Oids = new Object[]{boid};
                pkSnapshot.setLoaded(true);
                pkSnapshotSet.Snapshots = Collections.singletonList(pkSnapshot);
                rosterDy.getDataEntityState().setPkSnapshotSet(pkSnapshotSet);
                rosterDy.set("id", (Object)boid);
            }
            for (int i = 0; i < pages; ++i) {
                int startIndex = i * BATCH_SAVE_SIZE;
                int endIndex = Math.min(totalSize, (i + 1) * BATCH_SAVE_SIZE);
                List<DynamicObject> subList = list.subList(startIndex, endIndex);
                if (subList.isEmpty()) continue;
                DynamicObjectCollection rosterSaveList = new DynamicObjectCollection(subList.get(0).getDynamicObjectType(), null, subList);
                WTCSnapService.snapHisAndCurrentSaveAssignBoField((HRBaseServiceHelper)ROSTERHELPER, (HRBaseServiceHelper)ROSTERHISHELPER, (DynamicObjectCollection)rosterSaveList, (String)"boid");
            }
        }
    }

    public static Map<RosterRepairAndAdvance, Integer> calWorkDaysBetweenTwoDate(Set<RosterRepairAndAdvance> repairAndAdvanceSet) {
        Map<String, Long> personRosterMap = WTCRosterService.queryRosterWithWorkDays(repairAndAdvanceSet);
        HashMap result = Maps.newHashMapWithExpectedSize((int)repairAndAdvanceSet.size());
        for (RosterRepairAndAdvance req : repairAndAdvanceSet) {
            boolean isRepair = req.getBaselineDate().compareTo(req.getCompareDate()) > 0;
            Date rosterEndDate = req.getRosterEndDate();
            Date rosterStartDate = req.getRosterStartDate();
            int workdaysNum = 0;
            int daysBetween = WTCDateUtils.daysBetween((Date)rosterStartDate, (Date)rosterEndDate);
            for (int i = 0; i <= daysBetween; ++i) {
                if (req.getBaselineDate().compareTo(rosterStartDate) == 0) {
                    rosterStartDate = WTCDateUtils.addDays((Date)rosterStartDate, (int)1);
                    continue;
                }
                String key = req.getAttFileBoId() + WTCDateUtils.date2Str((Date)rosterStartDate, (String)"yyyy-MM-dd");
                Long propId = personRosterMap.get(key);
                if (propId != null) {
                    ++workdaysNum;
                }
                rosterStartDate = WTCDateUtils.addDays((Date)rosterStartDate, (int)1);
            }
            result.put(req, isRepair ? -workdaysNum : workdaysNum);
        }
        return result;
    }

    private static Map<String, Long> queryRosterWithWorkDays(Set<RosterRepairAndAdvance> repairAndAdvanceSet) {
        Tuple<Date, Date> minStartAndMaxEndDate = WTCRosterService.getMinStartAndMaxEndDate(repairAndAdvanceSet);
        Date minRosterStartDate = (Date)minStartAndMaxEndDate.getKey();
        Date maxRosterEndDate = (Date)minStartAndMaxEndDate.getValue();
        List<Long> attFileBoIdList = repairAndAdvanceSet.stream().map(RosterRepairAndAdvance::getAttFileBoId).distinct().collect(Collectors.toList());
        QFilter filter = new QFilter("shift", "!=", (Object)0L);
        filter.and(new QFilter("rostertype", "=", (Object)Character.valueOf('0')));
        filter.and(new QFilter("dateproperty", "=", (Object)DateAttribute.WORKDAY.getId()));
        DynamicObject[] personRosterDyArr = WTCRosterService.getPersonRosterWithFilter(SELECT_WORKDAYS_PROPERTY, attFileBoIdList, minRosterStartDate, maxRosterEndDate, filter);
        return Arrays.stream(personRosterDyArr).collect(Collectors.toMap(dy -> dy.getLong("attfilebase") + WTCDateUtils.date2Str((Date)dy.getDate("rosterdate"), (String)"yyyy-MM-dd"), dy -> dy.getLong("dateproperty"), (e1, e2) -> e1));
    }

    public static Set<RosterRepairAndAdvance> getWorkDays(Set<RosterRepairAndAdvance> repairAndAdvanceSet) {
        Map<String, Long> personRosterMap = WTCRosterService.queryRosterWithWorkDays(repairAndAdvanceSet);
        for (RosterRepairAndAdvance req : repairAndAdvanceSet) {
            int daysBetween;
            Date rosterEndDate = req.getBaselineDate();
            Date rosterStartDate = req.getCompareDate();
            Integer needRepairDays = req.getNeedRepairDays();
            int workdaysNum = 0;
            for (int i = daysBetween = WTCDateUtils.daysBetween((Date)rosterStartDate, (Date)rosterEndDate); i >= 0; --i) {
                if (rosterEndDate.compareTo(req.getBaselineDate()) == 0) {
                    rosterEndDate = WTCDateUtils.addDays((Date)rosterEndDate, (int)-1);
                    continue;
                }
                String key = req.getAttFileBoId() + WTCDateUtils.date2Str((Date)rosterEndDate, (String)"yyyy-MM-dd");
                Long propId = personRosterMap.get(key);
                if (propId != null) {
                    ++workdaysNum;
                }
                if (needRepairDays != null && needRepairDays.compareTo(workdaysNum) == 0) {
                    req.setLatestDate(rosterEndDate);
                }
                rosterEndDate = WTCDateUtils.addDays((Date)rosterEndDate, (int)-1);
            }
            req.setWorkDays(Integer.valueOf(workdaysNum));
        }
        return repairAndAdvanceSet;
    }

    private static Tuple<Date, Date> getMinStartAndMaxEndDate(Set<RosterRepairAndAdvance> repairAndAdvanceSet) {
        Date minRosterStartDate = null;
        Date maxRosterEndDate = null;
        for (RosterRepairAndAdvance req : repairAndAdvanceSet) {
            boolean isRepair = req.getBaselineDate().compareTo(req.getCompareDate()) >= 0;
            req.setRosterStartDate(isRepair ? req.getCompareDate() : req.getBaselineDate());
            req.setRosterEndDate(isRepair ? req.getBaselineDate() : req.getCompareDate());
            minRosterStartDate = minRosterStartDate == null ? req.getRosterStartDate() : WTCDateUtils.getMinDate((Date)minRosterStartDate, (Date)req.getRosterStartDate());
            maxRosterEndDate = maxRosterEndDate == null ? req.getRosterEndDate() : WTCDateUtils.getMaxDate((Date)maxRosterEndDate, (Date)req.getRosterEndDate());
        }
        return new Tuple(minRosterStartDate, maxRosterEndDate);
    }
}

