/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.evaluation;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.shift.DutyShiftQueryResponse;
import kd.wtc.wtbs.business.web.WTCRosterService;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.RosterRepairAndAdvance;

public abstract class EvaluationServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(EvaluationServiceHelper.class);

    @Deprecated
    public static DutyShiftResponse getDutyShifts(List<Long> attPersonIdList, Date startDate, Date endDate) {
        DynamicObject[] rosterDataArr = WTCRosterService.getPersonRosterDy(attPersonIdList, startDate, endDate);
        Map<Long, List<DutyShift>> dutyShiftMap = WTCRosterService.getShiftDutyMap(attPersonIdList, startDate, endDate, rosterDataArr);
        return new DutyShiftQueryResponse(dutyShiftMap);
    }

    public static DutyShiftResponse getDutyShiftsByAttFileBoId(List<Long> attFileBaseBoIds, Date startDate, Date endDate) {
        LOGGER.debug("EvaluationServiceHelper.getDutyShiftsByAttFileBoId, startDate: {}, endDate: {}", (Object)startDate, (Object)endDate);
        DynamicObject[] rosterDataArr = WTCRosterService.getPersonRosterDyByAttFileBaseBoId(attFileBaseBoIds, startDate, endDate, null);
        Map<Long, List<DutyShift>> dutyShiftMap = WTCRosterService.getShiftDutyMapByAttFileBaseBoId(attFileBaseBoIds, startDate, endDate, rosterDataArr);
        for (List<DutyShift> dutyShifts : dutyShiftMap.values()) {
            dutyShifts.removeIf(dutyShift -> dutyShift.getShiftId() == 0L);
        }
        LOGGER.debug("EvaluationServiceHelper.rosterdata, rosterDataArr.length: {}", (Object)rosterDataArr.length);
        return new DutyShiftQueryResponse(dutyShiftMap);
    }

    public static DutyShiftResponse getPlanDutyShiftsByAttFileBoId(List<Long> attFileBaseBoIds, Date startDate, Date endDate) {
        LOGGER.debug("EvaluationServiceHelper.getDutyShiftsByAttFileBoId, startDate: {}, endDate: {}", (Object)startDate, (Object)endDate);
        QFilter planQFilter = new QFilter("rostertype", "=", (Object)"0");
        DynamicObject[] rosterDataArr = WTCRosterService.getPersonRosterDyByAttFileBaseBoId(attFileBaseBoIds, startDate, endDate, null, planQFilter);
        Map<Long, List<DutyShift>> dutyShiftMap = WTCRosterService.getShiftDutyMapByAttFileBaseBoId(attFileBaseBoIds, startDate, endDate, rosterDataArr);
        for (List<DutyShift> dutyShifts : dutyShiftMap.values()) {
            dutyShifts.removeIf(dutyShift -> dutyShift.getShiftId() == 0L);
        }
        LOGGER.debug("EvaluationServiceHelper.rosterdata, rosterDataArr.length: {}", (Object)rosterDataArr.length);
        return new DutyShiftQueryResponse(dutyShiftMap);
    }

    public static Map<RosterRepairAndAdvance, Integer> getWorkDaysBetween2Date(Set<RosterRepairAndAdvance> repairAndAdvanceSet) {
        LOGGER.debug("EvaluationServiceHelper.getWorkDaysBetweenTwoDate ...start  repairAndAdvanceList={}", repairAndAdvanceSet);
        if (CollectionUtils.isEmpty(repairAndAdvanceSet)) {
            return null;
        }
        return WTCRosterService.calWorkDaysBetweenTwoDate(repairAndAdvanceSet);
    }

    public static Set<RosterRepairAndAdvance> getWorkDays(Set<RosterRepairAndAdvance> repairAndAdvanceSet) {
        LOGGER.debug("EvaluationServiceHelper.getWorkDays ...start ");
        if (CollectionUtils.isEmpty(repairAndAdvanceSet)) {
            return null;
        }
        return WTCRosterService.getWorkDays(repairAndAdvanceSet);
    }

    public static DutyShiftResponse getAdminOrgRosterDy(Collection<Long> adminOrgIdList, Date startDate, Date endDate, QFilter qFilter) {
        LOGGER.debug("EvaluationServiceHelper.getAdminOrgRosterDy, startDate: {}, endDate: {}, adminOrgIdList: {}", new Object[]{startDate, endDate, adminOrgIdList});
        DynamicObject[] adminOrgRosterDy = WTCRosterService.getAdminOrgRosterDy(adminOrgIdList, startDate, endDate, qFilter);
        return WTCRosterService.getAdminDutyShiftResponse(adminOrgRosterDy, startDate, endDate);
    }

    public static DutyShiftResponse getDutyShiftByAttFileBoIdWithDateList(List<Long> attFileBaseBoIds, Date startDate, Date endDate, List<Date> dateList) {
        LOGGER.debug("EvaluationServiceHelper.getDutyShiftsByAttFileBoId, startDate: {}, endDate: {}, dateList:{}", new Object[]{startDate, endDate, dateList});
        LOGGER.debug("TieInitializerRoster getDutyShiftByAttFileBoIdWithDateList step 1");
        if (CollectionUtils.isEmpty(dateList)) {
            return EvaluationServiceHelper.getDutyShiftsByAttFileBoId(attFileBaseBoIds, startDate, endDate);
        }
        LOGGER.debug("TieInitializerRoster getDutyShiftByAttFileBoIdWithDateList step 2");
        QFilter datListFilter = new QFilter("rosterdate", "in", dateList);
        DynamicObject[] rosterDataArr = WTCRosterService.getPersonRosterDyByAttFileBaseBoId(attFileBaseBoIds, startDate, endDate, datListFilter);
        LOGGER.debug("TieInitializerRoster getDutyShiftByAttFileBoIdWithDateList step 3");
        Map<Long, List<DutyShift>> dutyShiftMap = WTCRosterService.getShiftDutyMapByAttFileBaseBoId(attFileBaseBoIds, startDate, endDate, rosterDataArr);
        for (List<DutyShift> dutyShifts : dutyShiftMap.values()) {
            dutyShifts.removeIf(dutyShift -> dutyShift.getShiftId() == 0L);
        }
        LOGGER.debug("TieInitializerRoster getDutyShiftByAttFileBoIdWithDateList step 4");
        LOGGER.debug("EvaluationServiceHelper.rosterdata, rosterDataArr.length: {}", (Object)rosterDataArr.length);
        return new DutyShiftQueryResponse(dutyShiftMap);
    }
}

