/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.model.ofd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import kd.imc.bdm.file.fpy.model.ofd.OFDBound;
import kd.imc.bdm.file.fpy.model.ofd.OFDDocument;
import kd.imc.bdm.file.fpy.model.ofd.OFDObject;
import kd.imc.bdm.file.fpy.model.ofd.OFDResource;
import kd.imc.bdm.file.fpy.model.ofd.OFDTemplate;
import kd.imc.bdm.file.fpy.service.ofd.util.XmlHelperUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class OFDPage
extends OFDObject {
    private final String id;
    private final int pageIndex;
    private final Document pageXmlDoc;
    private final Element layerInfo;
    private final OFDDocument doc;

    public OFDPage(OFDDocument doc, int pageIndex, OFDTemplate tpl) {
        this.doc = doc;
        this.pageIndex = pageIndex;
        this.id = doc.getNewID();
        this.pageXmlDoc = XmlHelperUtils.createDocument((String)"ofd:Page");
        Element root = this.pageXmlDoc.getRootElement();
        if (tpl != null) {
            Element eleTpl = root.addElement("ofd:Template");
            eleTpl.addAttribute("TemplateID", tpl.getID());
            eleTpl.addAttribute("ZOrder", "Background");
            Element elePageArea = XmlHelperUtils.addNode((Element)root, (String)"ofd:Area", null);
            XmlHelperUtils.addNode((Element)elePageArea, (String)"ofd:PhysicalBox", (String)tpl.getOfdSize().toString());
        }
        Element eleContent = XmlHelperUtils.addNode((Element)root, (String)"ofd:Content", null);
        Element eleLayer = XmlHelperUtils.addNode((Element)eleContent, (String)"ofd:Layer", null);
        eleLayer.addAttribute("ID", this.doc.getNewID());
        this.layerInfo = eleLayer;
    }

    public String getID() {
        return this.id;
    }

    public String getPath() {
        return this.doc.getPath() + "Pages" + "/" + "Page_" + this.pageIndex + "/";
    }

    public void flush() throws IOException {
        String strPath = this.getPath();
        byte[] bytes = XmlHelperUtils.toByteArray((Document)this.pageXmlDoc);
        this.doc.getOfdFile().p_AddFile(strPath + "Content.xml", bytes);
    }

    public void addElementArray(JSONArray eleArray) {
        if (eleArray != null && !eleArray.isEmpty()) {
            eleArray.forEach(item -> {
                Element copy = ((Element)item).createCopy();
                this.layerInfo.add(copy);
            });
        }
    }

    public void addElement(Element element) {
        if (element != null) {
            Element copy = element.createCopy();
            copy.addAttribute("ID", this.doc.getNewID());
            this.layerInfo.add(copy);
        }
    }

    public Element addImage(OFDBound bound, String format, byte[] imageData) {
        String resourceID = this.doc.getNewID();
        this.doc.addResource(resourceID, resourceID, "Image", format, imageData);
        return this.showResource(bound, resourceID);
    }

    public Element showResource(OFDBound bound, String resourceName) {
        OFDResource resource = this.doc.getResource(resourceName);
        if (resource == null) {
            return null;
        }
        Element eleImageObject = XmlHelperUtils.addNode((Element)this.layerInfo, (String)("ofd:" + resource.getResourceType() + "Object"), null);
        eleImageObject.addAttribute("CTM", bound.getWidth() + " 0 0 " + bound.getHeight() + " 0 0");
        eleImageObject.addAttribute("ResourceID", resource.getResourceID());
        eleImageObject.addAttribute("Boundary", bound.toString());
        return eleImageObject;
    }

    public void setTagElement(Element rootElement, JSONObject idJson) {
        XmlHelperUtils.addRefNode((Element)rootElement, (String)"InvoiceNo", (String)idJson.getString("invoiceNo"), (String)this.id);
        XmlHelperUtils.addRefNode((Element)rootElement, (String)"IssueDate", (String)idJson.getString("issueTime"), (String)this.id);
        Element gmfElement = rootElement.addElement("Buyer");
        XmlHelperUtils.addRefNode((Element)gmfElement, (String)"BuyerName", (String)idJson.getString("buyerName"), (String)this.id);
        XmlHelperUtils.addRefNode((Element)gmfElement, (String)"BuyerTaxID", (String)idJson.getString("buyerTaxNo"), (String)this.id);
        Element xsfElement = rootElement.addElement("Seller");
        XmlHelperUtils.addRefNode((Element)xsfElement, (String)"SellerName", (String)idJson.getString("salerName"), (String)this.id);
        XmlHelperUtils.addRefNode((Element)xsfElement, (String)"SellerTaxID", (String)idJson.getString("salerTaxNo"), (String)this.id);
        XmlHelperUtils.addRefNode((Element)rootElement, (String)"InvoiceClerk", (String)idJson.getString("drawer"), (String)this.id);
        XmlHelperUtils.addRefNode((Element)rootElement, (String)"TaxInclusiveTotalAmount", (String)idJson.getString("totalAmount"), (String)this.id);
        XmlHelperUtils.addRefNode((Element)rootElement, (String)"TaxExclusiveTotalAmount", (String)idJson.getString("invoiceAmount"), (String)this.id);
        XmlHelperUtils.addRefNode((Element)rootElement, (String)"TaxTotalAmount", (String)idJson.getString("totalTaxAmount"), (String)this.id);
        XmlHelperUtils.addRefNode((Element)rootElement, (String)"Note", (String)idJson.getString("remark"), (String)this.id);
        this.addItemNodes(rootElement, idJson.getJSONArray("item"));
        this.addSpecialItemNodes(rootElement, idJson.getJSONArray("specialItemIdArray"));
    }

    private void addItemNodes(Element rootElement, JSONArray itemIdArray) {
        Element itemsElement = rootElement.addElement("GoodsInfos");
        for (int i = 0; i < itemIdArray.size(); ++i) {
            JSONObject itemIdJson = itemIdArray.getJSONObject(i);
            Element itemElement = itemsElement.addElement("GoodsInfo");
            XmlHelperUtils.addRefNode((Element)itemElement, (String)"Item", (String)itemIdJson.getString("goodsName"), (String)this.id);
            XmlHelperUtils.addRefNode((Element)itemElement, (String)"Specification", (String)itemIdJson.getString("specModel"), (String)this.id);
            XmlHelperUtils.addRefNode((Element)itemElement, (String)"MeasurementDimension", (String)itemIdJson.getString("unit"), (String)this.id);
            XmlHelperUtils.addRefNode((Element)itemElement, (String)"Quantity", (String)itemIdJson.getString("num"), (String)this.id);
            XmlHelperUtils.addRefNode((Element)itemElement, (String)"Price", (String)itemIdJson.getString("unitPrice"), (String)this.id);
            XmlHelperUtils.addRefNode((Element)itemElement, (String)"Amount", (String)itemIdJson.getString("detailAmount"), (String)this.id);
            XmlHelperUtils.addRefNode((Element)itemElement, (String)"TaxScheme", (String)itemIdJson.getString("taxRate"), (String)this.id);
            XmlHelperUtils.addRefNode((Element)itemElement, (String)"TaxAmount", (String)itemIdJson.getString("taxAmount"), (String)this.id);
        }
    }

    private void addSpecialItemNodes(Element rootElement, JSONArray itemIdArray) {
        if (itemIdArray == null || itemIdArray.isEmpty()) {
            return;
        }
        Element itemsElement = rootElement.addElement("\u7279\u6b8a\u660e\u7ec6\u5217\u8868");
        for (int i = 0; i < itemIdArray.size(); ++i) {
            JSONObject itemIdJSON = itemIdArray.getJSONObject(i);
            Element itemElement = itemsElement.addElement("\u7279\u6b8a\u660e\u7ec6");
            for (String key : itemIdJSON.keySet()) {
                XmlHelperUtils.addRefNode((Element)itemElement, (String)key, (String)itemIdJSON.getString(key), (String)this.id);
            }
        }
    }

    public void setCarTagElement(Element rootElement, JSONObject idJson) {
        if (idJson == null || idJson.isEmpty()) {
            return;
        }
        for (String key : idJson.keySet()) {
            XmlHelperUtils.addRefNode((Element)rootElement, (String)key, (String)idJson.getString(key), (String)this.id);
        }
    }
}

