/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.service.ofd.fdei;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.file.fpy.constants.FullDigitalEInvoiceConstant;
import kd.imc.bdm.file.fpy.enums.DifferenceTaxTypeEnum;
import kd.imc.bdm.file.fpy.enums.InvoiceTypeEnum;
import kd.imc.bdm.file.fpy.enums.SpecialTypeEnum;
import kd.imc.bdm.file.fpy.enums.ZeroTaxRateFlagEnum;
import kd.imc.bdm.file.fpy.model.ofd.OFDBound;
import kd.imc.bdm.file.fpy.model.ofd.OFDDocument;
import kd.imc.bdm.file.fpy.model.ofd.OFDInvoice;
import kd.imc.bdm.file.fpy.model.ofd.OFDPage;
import kd.imc.bdm.file.fpy.model.ofd.OFDSize;
import kd.imc.bdm.file.fpy.model.ofd.OFDTemplate;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoice;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoiceItem;
import kd.imc.bdm.file.fpy.service.ofd.fdei.FullDigitalEInvoiceCarOfdService;
import kd.imc.bdm.file.fpy.service.ofd.util.XmlHelperUtils;
import kd.imc.bdm.file.fpy.util.EInvoicePdfUtils;
import kd.imc.bdm.file.fpy.util.MoneyUtil;
import kd.imc.bdm.file.fpy.util.PDFXmlUtils;
import kd.imc.bdm.file.fpy.util.QRCodeUtil;
import kd.imc.bdm.file.util.DateUtils;
import kd.imc.bdm.file.util.ErrorType;
import kd.imc.bdm.file.util.Handle;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class FullDigitalEInvoiceOfdService {
    private static Log log = LogFactory.getLog(FullDigitalEInvoiceOfdService.class);

    public byte[] createOfd(FullDigitalEInvoice fullDigitalEInvoice) {
        Date startDate = new Date();
        InvoiceTypeEnum invoiceType = InvoiceTypeEnum.getInvoiceTypeByValue(fullDigitalEInvoice.getInvoiceType());
        if (invoiceType == null) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0420.errcode, ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u79cd\u7c7b\u4e0d\u652f\u6301\u751f\u6210OFD!", (String)"FullDigitalEInvoiceOfdService_0", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        if (InvoiceTypeEnum.CAR_VEHICLE_INVOICE == invoiceType || InvoiceTypeEnum.USED_CAR_INVOICE == invoiceType) {
            FullDigitalEInvoiceCarOfdService ofdService = new FullDigitalEInvoiceCarOfdService();
            return ofdService.createCarOfd(fullDigitalEInvoice);
        }
        String specialTypeStr = fullDigitalEInvoice.getSpecialType();
        SpecialTypeEnum specialType = SpecialTypeEnum.getSpecialTypeByValue((String)specialTypeStr);
        String templateXml = null;
        try {
            templateXml = PDFXmlUtils.readTempFileStr((String)"template/full-digital-invoice-ofd_20250605.xml");
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0160.errcode, ResManager.loadKDString((String)"OFD\u751f\u6210\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728!", (String)"FullDigitalEInvoiceOfdService_1", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        Document templateDocument = XmlHelperUtils.loadXML((String)templateXml);
        Element templateRootElement = templateDocument.getRootElement();
        List bottomElement = templateRootElement.element("BOTTOM").elements();
        List remarkElement = templateRootElement.element("REMARK").elements();
        Element paramElement = templateRootElement.element("PARAM");
        OFDInvoice ofdInvoice = new OFDInvoice(fullDigitalEInvoice);
        OFDDocument doc = ofdInvoice.ofdFile.getDocument();
        JSONObject detailElementJson = this.getDataElementList(fullDigitalEInvoice, paramElement, doc, specialType);
        int contentPageNo = detailElementJson.getIntValue("contentPageNo");
        JSONArray diffYArray = detailElementJson.getJSONArray("diffYArray");
        JSONArray itemArray = detailElementJson.getJSONArray("itemArray");
        JSONArray idArray = detailElementJson.getJSONArray("idArray");
        JSONArray specialDiffYArray = detailElementJson.getJSONArray("specialDiffYArray");
        JSONArray remarkDiffYArray = detailElementJson.getJSONArray("remarkDiffYArray");
        Document tagDocument = XmlHelperUtils.createDocument((String)"ofd:eInvoice");
        Element tagRoot = tagDocument.getRootElement();
        tagRoot.addAttribute("version", "1.0");
        boolean multiPage = detailElementJson.getBoolean("multiPage");
        boolean multiFlag = itemArray.size() > 1;
        Element qrCodeElement = null;
        int remarkIndex = 0;
        for (int i = 0; i < itemArray.size(); ++i) {
            BigDecimal currentSpecialHeight = specialDiffYArray.getBigDecimal(i);
            BigDecimal diffY = diffYArray.getBigDecimal(i);
            boolean lastFlag = i == contentPageNo - 1;
            boolean normalFlag = currentSpecialHeight.compareTo(BigDecimal.ZERO) == 0 || diffY.compareTo(BigDecimal.ZERO) >= 0;
            boolean moreRemark = false;
            if (i > contentPageNo - 1 && !remarkDiffYArray.isEmpty()) {
                normalFlag = false;
                moreRemark = true;
                currentSpecialHeight = remarkDiffYArray.getBigDecimal(remarkIndex);
                specialType = null;
                ++remarkIndex;
            }
            if (multiFlag && !lastFlag) {
                diffY = diffY.subtract(FullDigitalEInvoiceConstant.AMOUNT_REMARK_SPACING_BIG);
            }
            OFDSize ofdSize = new OFDSize(FullDigitalEInvoiceConstant.DEFAULT_WIDTH_DECIMAL, FullDigitalEInvoiceConstant.DEFAULT_HEIGHT_DECIMAL.add(diffY).add(currentSpecialHeight));
            OFDTemplate template = this.getTemplate(templateRootElement, fullDigitalEInvoice, normalFlag, invoiceType, specialType, doc, ofdSize, i);
            BigDecimal diffYCurrent = diffYArray.getBigDecimal(i);
            if (specialType != null && currentSpecialHeight.compareTo(BigDecimal.ZERO) > 0 && (SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType || SpecialTypeEnum.PASSENGER_TRANSPORT == specialType)) {
                template.addElementList(this.getSpecialItemTemplate(templateRootElement, specialType, diffYCurrent));
            }
            if (i >= contentPageNo - 1) {
                template.addElementList(this.getRemarkTemplate(remarkElement, diffYCurrent, currentSpecialHeight, moreRemark));
            }
            template.addElementList(this.getBottomEleList(bottomElement, diffYCurrent, currentSpecialHeight, multiPage, normalFlag, lastFlag));
            OFDPage page = doc.addPage(template);
            JSONArray itemEleArray = itemArray.getJSONArray(i);
            if (multiFlag) {
                this.setPageNo(itemEleArray, i + 1, itemArray.size(), paramElement, doc);
            }
            page.addElementArray(itemArray.getJSONArray(i));
            if (qrCodeElement == null) {
                byte[] imageBytes = QRCodeUtil.encoderQRCodeByte(fullDigitalEInvoice);
                qrCodeElement = page.addImage(new OFDBound("8, 6, 20, 20"), "png", imageBytes);
            } else {
                page.addElement(qrCodeElement);
            }
            page.setTagElement(tagRoot, idArray.getJSONObject(i));
        }
        doc.addCustomTag(tagDocument);
        ofdInvoice.flush();
        Date endTime = new Date();
        log.info("OFD\u751f\u6210\u8017\u65f6{}", (Object)(endTime.getTime() - startDate.getTime()));
        return ofdInvoice.getData();
    }

    private List<Element> getSpecialItemTemplate(Element templateRootElement, SpecialTypeEnum specialType, BigDecimal diffY) {
        String specialTypeStr;
        Element specialItemElement = templateRootElement.element("SPECIALITEM");
        Element specialElement = specialItemElement.element(specialTypeStr = specialType.getIdentification().toUpperCase());
        if (specialElement == null) {
            return null;
        }
        ArrayList<Element> list = new ArrayList<Element>(8);
        List specialElementList = specialElement.elements();
        for (Element element : specialElementList) {
            this.setBottomEle(element, diffY, list);
        }
        return list;
    }

    public List<Element> getRemarkTemplate(List<Element> remarkElement, BigDecimal diffYCurrent, BigDecimal currentSpecialHeight, boolean moreRemark) {
        ArrayList<Element> list = new ArrayList<Element>(8);
        for (Element element : remarkElement) {
            String name = element.getName();
            if (moreRemark) {
                OFDBound ofdBoundary;
                String boundary;
                Element newBottomEle;
                if ("PathObject".equals(name)) {
                    newBottomEle = element.createCopy();
                    boundary = newBottomEle.attributeValue("Boundary");
                    ofdBoundary = new OFDBound(boundary);
                    ofdBoundary.setY(FullDigitalEInvoiceConstant.MORE_REMARK_LINE_Y);
                    BigDecimal height = ofdBoundary.getHeight().add(currentSpecialHeight).add(new BigDecimal("0.5"));
                    ofdBoundary.setHeight(height);
                    newBottomEle.addAttribute("Boundary", ofdBoundary.toString());
                    Element abbreviatedDataEle = newBottomEle.element("AbbreviatedData");
                    if (abbreviatedDataEle != null) {
                        String lineStr = String.format("M 0.2 0 L 0.2 %s", height);
                        abbreviatedDataEle.setText(lineStr);
                    }
                    list.add(newBottomEle);
                    continue;
                }
                newBottomEle = element.createCopy();
                boundary = newBottomEle.attributeValue("Boundary");
                ofdBoundary = new OFDBound(boundary);
                BigDecimal textDiff = currentSpecialHeight.divide(new BigDecimal("2"), 3, RoundingMode.HALF_UP);
                ofdBoundary.setY(ofdBoundary.getY().subtract(FullDigitalEInvoiceConstant.MORE_REMARK_LINE_DIFF).add(textDiff));
                newBottomEle.addAttribute("Boundary", ofdBoundary.toString());
                list.add(newBottomEle);
                continue;
            }
            BigDecimal diffY = currentSpecialHeight.add(diffYCurrent);
            this.setBottomEle(element, diffY, list);
        }
        return list;
    }

    private JSONObject getDataElementList(FullDigitalEInvoice fullDigitalEInvoice, Element paramElement, OFDDocument doc, SpecialTypeEnum specialType) {
        int i;
        JSONObject itemJson = new JSONObject();
        int totalPageNo = 1;
        int lineNum = 0;
        boolean multiPage = false;
        BigDecimal diffY = BigDecimal.ZERO;
        BigDecimal subAmount = BigDecimal.ZERO;
        BigDecimal subTaxAmount = BigDecimal.ZERO;
        JSONArray diffYArray = new JSONArray();
        JSONArray dataElementArray = new JSONArray();
        JSONArray everyPageEleArray = new JSONArray();
        JSONArray idArray = new JSONArray();
        JSONObject idJson = new JSONObject();
        JSONArray idItemArray = new JSONArray();
        JSONArray specialDiffYArray = new JSONArray();
        JSONArray remarkDiffYArray = new JSONArray();
        Element remarkElement = paramElement.element("remark");
        List<List<String>> remarkDetailList = this.getRemarkDetailList(remarkElement, fullDigitalEInvoice.getRemark());
        List<String> firstRemarkList = null;
        if (!remarkDetailList.isEmpty()) {
            firstRemarkList = remarkDetailList.get(0);
        }
        List<FullDigitalEInvoiceItem> itemList = fullDigitalEInvoice.getItemList();
        Element detailElement = paramElement.element("item");
        String detailType = specialType.getIdentification();
        Element detailParamElement = detailElement.element(detailType);
        Element goodsNameEle = detailParamElement.element("goodsName");
        Element specModelEle = detailParamElement.element("specModel");
        Element unitEle = detailParamElement.element("unit");
        boolean differenceTaxFlag = false;
        String differenceTaxType = fullDigitalEInvoice.getDifferenceTaxType();
        if (DifferenceTaxTypeEnum.PART_DIFF == DifferenceTaxTypeEnum.getDifferenceTaxTypeByValue((String)differenceTaxType)) {
            differenceTaxFlag = true;
        }
        List<Map<String, List<String>>> specialDataMapList = this.getSpecialDataMapList(fullDigitalEInvoice, paramElement, specialType);
        for (FullDigitalEInvoiceItem item : itemList) {
            JSONObject idItemJson = new JSONObject(true);
            String goodsName = EInvoicePdfUtils.replaceBreakLine((String)item.getGoodsName());
            int goodsNameMaxLength = XmlHelperUtils.getAttributeValue((Element)goodsNameEle, (String)"maxLength", (int)11);
            List goodsNameList = EInvoicePdfUtils.subStringByChineseLength((String)goodsName, (int)goodsNameMaxLength, (boolean)true);
            String specModel = EInvoicePdfUtils.replaceBreakLine((String)item.getSpecModel());
            int specModelMaxLength = XmlHelperUtils.getAttributeValue((Element)specModelEle, (String)"maxLength", (int)7);
            List specModelList = EInvoicePdfUtils.subStringByChineseLength((String)specModel, (int)specModelMaxLength, (boolean)true);
            String unit = EInvoicePdfUtils.replaceBreakLine((String)item.getUnit());
            int unitMaxLength = XmlHelperUtils.getAttributeValue((Element)unitEle, (String)"maxLength", (int)4);
            List unitList = EInvoicePdfUtils.subStringByChineseLength((String)unit, (int)unitMaxLength, (boolean)true);
            int maxNum = Math.max(Math.max(goodsNameList.size(), specModelList.size()), unitList.size());
            for (int j = 0; j < maxNum; ++j) {
                int everyMaxNum;
                int n = everyMaxNum = !specialDataMapList.isEmpty() && totalPageNo == 1 ? 20 : 47;
                if (lineNum >= everyMaxNum) {
                    multiPage = true;
                    diffY = diffY.add(FullDigitalEInvoiceConstant.SUB_MONEY_SPACING_BIG);
                    diffY = diffY.subtract(FullDigitalEInvoiceConstant.DEFAULT_DETAIL_HEIGHT).add(FullDigitalEInvoiceConstant.LINE_SPACING_BIG);
                    this.setEveryPageData(everyPageEleArray, specialDiffYArray, fullDigitalEInvoice, paramElement, subAmount, subTaxAmount, diffY, firstRemarkList, true, specialDataMapList, totalPageNo, specialType, false, multiPage, idJson, doc);
                    dataElementArray.add((Object)everyPageEleArray);
                    diffYArray.add((Object)diffY);
                    idJson.put("item", (Object)idItemArray);
                    idArray.add((Object)idJson);
                    everyPageEleArray = new JSONArray();
                    ++totalPageNo;
                    lineNum = 0;
                    subAmount = BigDecimal.ZERO;
                    subTaxAmount = BigDecimal.ZERO;
                    idJson = new JSONObject();
                    idItemArray = new JSONArray();
                }
                diffY = new BigDecimal(lineNum).multiply(FullDigitalEInvoiceConstant.LINE_SPACING_BIG);
                if (j < goodsNameList.size() && !Handle.isEmpty(goodsNameList.get(j))) {
                    String currentGoodsName = (String)goodsNameList.get(j);
                    this.addTextEleArrayWithKey(everyPageEleArray, "goodsName", currentGoodsName, detailParamElement, diffY, true, idItemJson, doc);
                }
                if (j < specModelList.size() && !Handle.isEmpty(specModelList.get(j))) {
                    String currentSpecModel = (String)specModelList.get(j);
                    this.addTextEleArrayWithKey(everyPageEleArray, "specModel", currentSpecModel, detailParamElement, diffY, true, idItemJson, doc);
                }
                if (j < unitList.size() && !Handle.isEmpty(unitList.get(j))) {
                    String currentUnit = (String)unitList.get(j);
                    this.addTextEleArrayWithKey(everyPageEleArray, "unit", currentUnit, detailParamElement, diffY, true, idItemJson, doc);
                }
                if (j == 0) {
                    this.addTextEleArrayWithKey(everyPageEleArray, "num", EInvoicePdfUtils.getBigDecimalStr((BigDecimal)item.getNum()), detailParamElement, diffY, true, idItemJson, doc);
                    this.addTextEleArrayWithKey(everyPageEleArray, "unitPrice", EInvoicePdfUtils.getBigDecimalStr((BigDecimal)item.getUnitPrice()), detailParamElement, diffY, true, idItemJson, doc);
                    this.addTextEleArrayWithKey(everyPageEleArray, "detailAmount", EInvoicePdfUtils.getBigDecimalStr((BigDecimal)item.getDetailAmount()), detailParamElement, diffY, true, idItemJson, doc);
                    String taxAmountStr = null;
                    if (item.getTaxRate() != null) {
                        ZeroTaxRateFlagEnum zeroTaxRateFlag;
                        BigDecimal taxRate = item.getTaxRate();
                        String taxRateStr = "***";
                        String zeroTaxRateFlagStr = item.getZeroTaxRateFlag();
                        boolean zeroTaxFlag = false;
                        if (!Handle.isEmpty(zeroTaxRateFlagStr) && (zeroTaxRateFlag = ZeroTaxRateFlagEnum.getZeroTaxRateFlagByValue((String)zeroTaxRateFlagStr)) != null) {
                            if (!differenceTaxFlag) {
                                taxRateStr = zeroTaxRateFlag.getMsg();
                            }
                            taxAmountStr = zeroTaxRateFlag.getTaxAmount();
                            zeroTaxFlag = true;
                        }
                        if (!zeroTaxFlag && !differenceTaxFlag) {
                            taxRateStr = taxRate.compareTo(new BigDecimal("1")) <= 0 ? item.getTaxRate().multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString() + "%" : taxRate.stripTrailingZeros().toPlainString() + "%";
                        }
                        this.addTextEleArrayWithKey(everyPageEleArray, "taxRate", taxRateStr, detailParamElement, diffY, true, idItemJson, doc);
                    }
                    if (taxAmountStr == null) {
                        taxAmountStr = EInvoicePdfUtils.getBigDecimalStr((BigDecimal)item.getTaxAmount());
                    }
                    this.addTextEleArrayWithKey(everyPageEleArray, "taxAmount", taxAmountStr, detailParamElement, diffY, true, idItemJson, doc);
                    subAmount = subAmount.add(item.getDetailAmount());
                    subTaxAmount = subTaxAmount.add(item.getTaxAmount());
                    idItemArray.add((Object)idItemJson);
                }
                ++lineNum;
            }
        }
        if (!everyPageEleArray.isEmpty()) {
            diffY = lineNum > 8 ? diffY.subtract(FullDigitalEInvoiceConstant.DEFAULT_DETAIL_HEIGHT).add(FullDigitalEInvoiceConstant.LINE_SPACING_BIG) : BigDecimal.ZERO;
            if (multiPage) {
                diffY = diffY.add(FullDigitalEInvoiceConstant.SUB_MONEY_SPACING_BIG);
            }
            boolean lastPageFlag = specialDataMapList.size() < 2;
            this.setEveryPageData(everyPageEleArray, specialDiffYArray, fullDigitalEInvoice, paramElement, subAmount, subTaxAmount, diffY, firstRemarkList, true, specialDataMapList, totalPageNo, specialType, lastPageFlag, multiPage, idJson, doc);
            dataElementArray.add((Object)everyPageEleArray);
            diffYArray.add((Object)diffY);
            idJson.put("item", (Object)idItemArray);
            idArray.add((Object)idJson);
            ++totalPageNo;
        }
        for (i = 1; i < specialDataMapList.size(); ++i) {
            idJson = new JSONObject();
            everyPageEleArray = new JSONArray();
            diffY = FullDigitalEInvoiceConstant.LINE_SPACING_BIG.multiply(FullDigitalEInvoiceConstant.DEFAULT_LINE_NUM).add(FullDigitalEInvoiceConstant.DEFAULT_LINE_NUM).negate();
            boolean lastPageFlag = i == specialDataMapList.size() - 1;
            this.setEveryPageData(everyPageEleArray, specialDiffYArray, fullDigitalEInvoice, paramElement, BigDecimal.ZERO, BigDecimal.ZERO, diffY, firstRemarkList, true, specialDataMapList, i, specialType, lastPageFlag, multiPage, idJson, doc);
            dataElementArray.add((Object)everyPageEleArray);
            diffYArray.add((Object)diffY);
            idJson.put("item", (Object)new JSONArray());
            idArray.add((Object)idJson);
            ++totalPageNo;
        }
        itemJson.put("contentPageNo", (Object)(totalPageNo - 1));
        for (i = 1; i < remarkDetailList.size(); ++i) {
            idJson = new JSONObject();
            everyPageEleArray = new JSONArray();
            List<String> moreRemarkDetailList = remarkDetailList.get(i);
            diffY = FullDigitalEInvoiceConstant.MORE_REMARK_LINE_UP_BIG;
            this.setEveryPageData(everyPageEleArray, remarkDiffYArray, fullDigitalEInvoice, paramElement, BigDecimal.ZERO, BigDecimal.ZERO, diffY, moreRemarkDetailList, false, null, i, specialType, false, multiPage, idJson, doc);
            specialDiffYArray.add((Object)BigDecimal.ZERO);
            dataElementArray.add((Object)everyPageEleArray);
            diffYArray.add((Object)diffY);
            idJson.put("item", (Object)new JSONArray());
            idArray.add((Object)idJson);
            ++totalPageNo;
        }
        itemJson.put("multiPage", (Object)multiPage);
        itemJson.put("specialDiffYArray", (Object)specialDiffYArray);
        itemJson.put("remarkDiffYArray", (Object)remarkDiffYArray);
        itemJson.put("itemArray", (Object)dataElementArray);
        itemJson.put("totalPageNo", (Object)totalPageNo);
        itemJson.put("diffYArray", (Object)diffYArray);
        itemJson.put("idArray", (Object)idArray);
        return itemJson;
    }

    private void setEveryPageData(JSONArray everyPageEleArray, JSONArray specialDiffYArray, FullDigitalEInvoice fullDigitalEInvoice, Element paramElement, BigDecimal subAmount, BigDecimal subTaxAmount, BigDecimal diffY, List<String> remarkList, boolean firstRemark, List<Map<String, List<String>>> specialDataMapList, int specialIndex, SpecialTypeEnum specialType, boolean lastPage, boolean multiPage, JSONObject idJson, OFDDocument doc) {
        if (!everyPageEleArray.isEmpty()) {
            specialIndex = specialIndex == 1 ? 0 : -1;
        }
        this.setBaseDataArray(everyPageEleArray, fullDigitalEInvoice, paramElement, diffY, idJson, doc);
        if (specialIndex == -1 || specialIndex == 0) {
            this.addTextEleArrayWithKey(everyPageEleArray, "invoiceAmount", EInvoicePdfUtils.getPriceWithSymbol((BigDecimal)fullDigitalEInvoice.getInvoiceAmount()), paramElement, diffY, false, idJson, doc);
            this.addTextEleArrayWithKey(everyPageEleArray, "totalTaxAmount", EInvoicePdfUtils.getPriceWithSymbol((BigDecimal)fullDigitalEInvoice.getTotalTaxAmount()), paramElement, diffY, false, idJson, doc);
            if (multiPage) {
                this.setSubAmount(everyPageEleArray, subAmount, subTaxAmount, paramElement, diffY, idJson, doc);
            }
        }
        BigDecimal specialDiffY = this.setSpecialItemList(everyPageEleArray, specialDataMapList, specialIndex, paramElement, specialType, diffY, idJson, doc);
        if (firstRemark) {
            specialDiffYArray.add((Object)specialDiffY);
        }
        BigDecimal drawerDiffY = diffY.add(specialDiffY);
        if (lastPage) {
            this.addTextEleArrayWithKey(everyPageEleArray, "totalAmount", EInvoicePdfUtils.getPriceWithSymbol((BigDecimal)fullDigitalEInvoice.getTotalAmount()), paramElement, drawerDiffY, false, idJson, doc);
            this.addTextEleArrayWithKey(everyPageEleArray, "bigTotalAmount", MoneyUtil.moneyCapital((String)EInvoicePdfUtils.getPriceWithScale((BigDecimal)fullDigitalEInvoice.getTotalAmount())), paramElement, drawerDiffY, false, idJson, doc);
        } else {
            drawerDiffY = drawerDiffY.subtract(FullDigitalEInvoiceConstant.AMOUNT_REMARK_SPACING_BIG);
        }
        if (!(remarkList == null || remarkList.isEmpty() || !lastPage && firstRemark)) {
            Element remarkElement = paramElement.element("remark");
            this.setRemark(everyPageEleArray, remarkElement, remarkList, drawerDiffY, idJson, doc, firstRemark);
            if (!firstRemark) {
                int size = Math.max(remarkList.size(), 18);
                BigDecimal remarkY = FullDigitalEInvoiceConstant.MORE_REMARK_LINE_SPACING_BIG.multiply(new BigDecimal(size - 5));
                drawerDiffY = drawerDiffY.add(remarkY);
                specialDiffYArray.add((Object)remarkY);
            }
        }
        this.addTextEleArrayWithKey(everyPageEleArray, "drawer", fullDigitalEInvoice.getDrawer(), paramElement, drawerDiffY, false, idJson, doc);
    }

    public void setWaterMark(JSONArray everyPageEleArray, Element element, BigDecimal diffY, OFDDocument doc) {
        Element waterMarkParamEle = element.element("waterMark");
        if (waterMarkParamEle != null) {
            BigDecimal height = FullDigitalEInvoiceConstant.DEFAULT_HEIGHT_DECIMAL.add(diffY);
            List elements = waterMarkParamEle.elements();
            if (elements == null || elements.size() != 2) {
                return;
            }
            Element waterMarkRedEle = (Element)elements.get(0);
            everyPageEleArray.add((Object)this.getOneEle(waterMarkRedEle, 0, 0, null, doc));
            Element waterMarkGrayEle = (Element)elements.get(1);
            BigDecimal diff = new BigDecimal("35");
            int xTimes = FullDigitalEInvoiceConstant.DEFAULT_WIDTH_DECIMAL.divide(diff, 0, RoundingMode.DOWN).intValue();
            int yTimes = height.divide(diff, 0, RoundingMode.DOWN).intValue();
            for (int i = 0; i < xTimes; ++i) {
                for (int j = 0; j < yTimes; ++j) {
                    everyPageEleArray.add((Object)this.getOneEle(waterMarkGrayEle, i, j, diff, doc));
                }
            }
        }
    }

    private Element getOneEle(Element paramEle, int i, int j, BigDecimal diff, OFDDocument doc) {
        Element currentEle = paramEle.createCopy();
        String boundary = currentEle.attributeValue("Boundary");
        OFDBound ofdBoundary = new OFDBound(boundary);
        boolean isChange = false;
        if (i != 0) {
            isChange = true;
            ofdBoundary.setX(ofdBoundary.getX().add(new BigDecimal(i).multiply(diff)));
        }
        if (j != 0) {
            isChange = true;
            ofdBoundary.setY(ofdBoundary.getY().add(new BigDecimal(j).multiply(diff)));
        }
        if (isChange) {
            currentEle.addAttribute("Boundary", ofdBoundary.toString());
        }
        currentEle.addAttribute("ID", doc.getNewID());
        return currentEle;
    }

    private BigDecimal setSpecialItemList(JSONArray everyPageEleArray, List<Map<String, List<String>>> specialDataMapList, int specialIndex, Element paramElement, SpecialTypeEnum specialType, BigDecimal diffY, JSONObject idJson, OFDDocument doc) {
        if (SpecialTypeEnum.CARGO_TRANSPORT_SERVICE != specialType && SpecialTypeEnum.PASSENGER_TRANSPORT != specialType) {
            return BigDecimal.ZERO;
        }
        if (specialDataMapList == null || specialDataMapList.isEmpty()) {
            return BigDecimal.ZERO;
        }
        if (specialIndex < 0) {
            return BigDecimal.ZERO;
        }
        Element specialItemElement = paramElement.element("specialItem").element(specialType.getIdentification());
        Map<String, List<String>> dataMap = specialDataMapList.get(specialIndex);
        Set<Map.Entry<String, List<String>>> dataEntrySet = dataMap.entrySet();
        BigDecimal specialDiffY = BigDecimal.ZERO;
        for (Map.Entry<String, List<String>> dataEntry : dataEntrySet) {
            String key = dataEntry.getKey();
            List<String> dataList = dataEntry.getValue();
            BigDecimal currentDiffY = diffY;
            for (String dataStr : dataList) {
                this.addTextEleArrayWithKey(everyPageEleArray, key, dataStr, specialItemElement, currentDiffY, true, idJson, doc);
                currentDiffY = currentDiffY.add(FullDigitalEInvoiceConstant.LINE_SPACING_BIG);
            }
            if (specialDiffY.compareTo(currentDiffY) >= 0) continue;
            specialDiffY = currentDiffY;
        }
        if ((specialDiffY = specialDiffY.subtract(diffY)).compareTo(FullDigitalEInvoiceConstant.DEFAULT_DETAIL_HEIGHT) < 0) {
            specialDiffY = FullDigitalEInvoiceConstant.DEFAULT_DETAIL_HEIGHT;
        }
        return specialDiffY.add(FullDigitalEInvoiceConstant.SUB_MONEY_SPACING_BIG);
    }

    private void setPageNo(JSONArray everyPageEleArray, int pageNo, int totalPageNo, Element paramElement, OFDDocument doc) {
        String info = String.format("\u5171%s\u9875 \u7b2c%s\u9875", totalPageNo, pageNo);
        Element element = paramElement.element("pageNo");
        this.addTextEleArray(everyPageEleArray, element, info, false, BigDecimal.ZERO, doc.getNewID());
    }

    private void setSubAmount(JSONArray everyPageEleArray, BigDecimal subAmount, BigDecimal subTaxAmount, Element paramElement, BigDecimal diffY, JSONObject idJson, OFDDocument doc) {
        this.addTextEleArrayWithKey(everyPageEleArray, "subAmount", EInvoicePdfUtils.getPriceWithSymbol((BigDecimal)subAmount), paramElement, diffY, false, idJson, doc);
        this.addTextEleArrayWithKey(everyPageEleArray, "subTaxAmount", EInvoicePdfUtils.getPriceWithSymbol((BigDecimal)subTaxAmount), paramElement, diffY, false, idJson, doc);
    }

    private void setBaseDataArray(JSONArray everyPageEleArray, FullDigitalEInvoice fullDigitalEInvoice, Element paramElement, BigDecimal diffY, JSONObject idJson, OFDDocument doc) {
        DifferenceTaxTypeEnum differenceTaxType;
        this.addTextEleArrayWithKey(everyPageEleArray, "invoiceNo", fullDigitalEInvoice.getInvoiceNo(), paramElement, diffY, false, idJson, doc);
        String issueTimeCn = DateUtils.format((Date)fullDigitalEInvoice.getIssueTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5");
        this.addTextEleArrayWithKey(everyPageEleArray, "issueTime", issueTimeCn, paramElement, diffY, false, idJson, doc);
        this.addTextEleArrayWithKey(everyPageEleArray, "buyerName", fullDigitalEInvoice.getBuyerName(), paramElement, diffY, false, idJson, doc);
        this.addTextEleArrayWithKey(everyPageEleArray, "buyerTaxNo", fullDigitalEInvoice.getBuyerTaxNo(), paramElement, diffY, false, idJson, doc);
        this.addTextEleArrayWithKey(everyPageEleArray, "salerName", fullDigitalEInvoice.getSalerName(), paramElement, diffY, false, idJson, doc);
        this.addTextEleArrayWithKey(everyPageEleArray, "salerTaxNo", fullDigitalEInvoice.getSalerTaxNo(), paramElement, diffY, false, idJson, doc);
        String specialType = fullDigitalEInvoice.getSpecialType();
        SpecialTypeEnum specialTypeEnum = SpecialTypeEnum.getSpecialTypeByValue((String)specialType);
        if (specialTypeEnum != null) {
            this.addTextEleArrayWithKey(everyPageEleArray, "specialType", specialTypeEnum.getMsg(), paramElement, diffY, false, idJson, doc);
        }
        if ((differenceTaxType = DifferenceTaxTypeEnum.getDifferenceTaxTypeByValue((String)fullDigitalEInvoice.getDifferenceTaxType())) != null) {
            this.addTextEleArrayWithKey(everyPageEleArray, "differenceTaxType", differenceTaxType.getMsg(), paramElement, diffY, false, idJson, doc);
        }
        if (fullDigitalEInvoice.isInput()) {
            this.addTextEleArrayWithKey(everyPageEleArray, "inputFlag", "\u5e95\u8d26\u6570\u636e", paramElement, diffY, false, idJson, doc);
        }
        if (fullDigitalEInvoice.isTest()) {
            this.setWaterMark(everyPageEleArray, paramElement, diffY, doc);
        }
    }

    private List<Map<String, List<String>>> getSpecialDataMapList(FullDigitalEInvoice fullDigitalEInvoice, Element paramElement, SpecialTypeEnum specialType) {
        ArrayList<Map<String, List<String>>> list = new ArrayList<Map<String, List<String>>>(8);
        if (SpecialTypeEnum.PASSENGER_TRANSPORT != specialType && SpecialTypeEnum.CARGO_TRANSPORT_SERVICE != specialType) {
            return list;
        }
        Element specialItemElement = paramElement.element("specialItem").element(specialType.getIdentification());
        JSONObject elementMaxLengthJson = EInvoicePdfUtils.getElementMaxLengthJson((Element)specialItemElement);
        Map specialDataMap = EInvoicePdfUtils.getSpecialDataMap((FullDigitalEInvoice)fullDigitalEInvoice, (JSONObject)elementMaxLengthJson, (SpecialTypeEnum)specialType);
        if (specialDataMap.isEmpty()) {
            return list;
        }
        specialDataMap.remove("maxNum");
        for (Map.Entry entry : specialDataMap.entrySet()) {
            int pageNo = 0;
            String key = (String)entry.getKey();
            List valueList = (List)entry.getValue();
            ArrayList<String> newValueList = null;
            for (int i = 0; i < valueList.size(); ++i) {
                int maxNum;
                String value = (String)valueList.get(i);
                int n = maxNum = pageNo == 0 ? 21 : 47;
                if (newValueList == null) {
                    newValueList = new ArrayList<String>(8);
                }
                newValueList.add(value);
                if (newValueList.size() != maxNum && i != valueList.size() - 1) continue;
                boolean newFlag = pageNo >= list.size();
                Map map = newFlag ? new LinkedHashMap() : (Map)list.get(pageNo);
                map.put(key, newValueList);
                if (newFlag) {
                    list.add(map);
                }
                newValueList = null;
                ++pageNo;
            }
        }
        return list;
    }

    public void addTextEleArrayWithKey(JSONArray everyPageEleArray, String key, String value, Element paramElement, BigDecimal diffY, boolean itemFlag, JSONObject idJson, OFDDocument doc) {
        Element element = paramElement.element(key);
        this.addTextEleArrayWithEle(everyPageEleArray, key, value, element, diffY, itemFlag, idJson, doc);
    }

    private void addTextEleArrayWithEle(JSONArray everyPageEleArray, String key, String value, Element element, BigDecimal diffY, boolean itemFlag, JSONObject idJson, OFDDocument doc) {
        String id = doc.getNewID();
        if (element != null) {
            String hisId = idJson.getString(key);
            if (!Handle.isEmpty(hisId)) {
                idJson.put(key, (Object)(hisId + "," + id));
            } else {
                idJson.put(key, (Object)id);
            }
            this.addTextEleArray(everyPageEleArray, element, value, itemFlag, diffY, id);
        }
    }

    private void setRemark(JSONArray everyPageEleArray, Element remarkElement, List<String> remarkStrList, BigDecimal diffY, JSONObject idJson, OFDDocument doc, boolean firstPage) {
        BigDecimal currentLineHigh;
        BigDecimal remarkDiffY = diffY;
        BigDecimal bigDecimal = currentLineHigh = firstPage ? FullDigitalEInvoiceConstant.FIRST_REMARK_LINE_SPACING_BIG : FullDigitalEInvoiceConstant.MORE_REMARK_LINE_SPACING_BIG;
        if (!remarkStrList.isEmpty()) {
            for (String remarkStr : remarkStrList) {
                String id = doc.getNewID();
                this.addTextEleArray(everyPageEleArray, remarkElement, remarkStr, false, remarkDiffY, id);
                remarkDiffY = remarkDiffY.add(currentLineHigh);
            }
        }
    }

    private List<List<String>> getRemarkDetailList(Element remarkElement, String remark) {
        ArrayList<List<String>> remarkStrList = new ArrayList<List<String>>(8);
        ArrayList<String> everyPageRemarkList = new ArrayList<String>(8);
        int maxLength = XmlHelperUtils.getAttributeValue((Element)remarkElement, (String)"maxLength", (int)61);
        List remarkDetailList = EInvoicePdfUtils.subStringByChineseLength((String)remark, (int)maxLength, (boolean)true);
        boolean firstPage = true;
        int pageSize = 0;
        for (String lineRemarkStr : remarkDetailList) {
            everyPageRemarkList.add(lineRemarkStr);
            if ((++pageSize != 6 || !firstPage) && pageSize != 66) continue;
            remarkStrList.add(everyPageRemarkList);
            everyPageRemarkList = new ArrayList(8);
            firstPage = false;
        }
        if (!everyPageRemarkList.isEmpty()) {
            remarkStrList.add(everyPageRemarkList);
        }
        return remarkStrList;
    }

    private void addTextEleArray(JSONArray everyPageEleArray, Element paramEle, Object textObj, boolean item, BigDecimal diffY, String id) {
        if (textObj == null || paramEle == null) {
            return;
        }
        String text = textObj instanceof BigDecimal ? ((BigDecimal)textObj).stripTrailingZeros().toPlainString() : textObj.toString();
        if (Handle.isEmpty(text)) {
            return;
        }
        Element paramItextEle = this.getParamItextEle(paramEle, text, item, diffY);
        paramItextEle.addAttribute("ID", id);
        everyPageEleArray.add((Object)paramItextEle);
    }

    private OFDTemplate getTemplate(Element templateRootElement, FullDigitalEInvoice fullDigitalEInvoice, boolean normalFlag, InvoiceTypeEnum invoiceType, SpecialTypeEnum specialType, OFDDocument doc, OFDSize ofdSize, int index) {
        String taxNo = fullDigitalEInvoice.getSalerTaxNo();
        if (SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS == specialType || SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS_02 == specialType) {
            taxNo = fullDigitalEInvoice.getBuyerTaxNo();
        }
        String areaCodeStr = EInvoicePdfUtils.getAreaCodeByNsrsbh((String)taxNo, (String)fullDigitalEInvoice.getTaxBureauCode());
        List jjzElement = templateRootElement.element("JJZ").element(areaCodeStr).elements();
        List titleElement = templateRootElement.element("TITLE").element(invoiceType.name()).elements();
        List bodyElement = templateRootElement.element("BODY").elements();
        OFDTemplate template = doc.addTemplate(bodyElement, index, ofdSize);
        if (normalFlag) {
            Element itemElement = templateRootElement.element("ITEM");
            String itemTypeFlag = "common";
            if (specialType != null) {
                itemTypeFlag = specialType.getIdentification();
            }
            List itemElements = itemElement.element(itemTypeFlag.toUpperCase()).elements();
            template.addElementList(itemElements);
        }
        template.addElementList(jjzElement);
        template.addElementList(titleElement);
        return template;
    }

    private Element getParamItextEle(Element paramEle, String text, boolean item, BigDecimal diffY) {
        String format = paramEle.attributeValue("format");
        Element textObjectEle = paramEle.element("TextObject").createCopy();
        if (Handle.isNotEmpty(format) && Handle.isNotEmpty(text) && StringUtils.isNumeric((CharSequence)text)) {
            DecimalFormat df = new DecimalFormat(format);
            text = df.format(new BigDecimal(text));
        }
        String bottom = paramEle.attributeValue("bottom");
        String boundary = textObjectEle.attributeValue("Boundary");
        OFDBound ofdBoundary = new OFDBound(boundary);
        if (item || "true".equals(bottom)) {
            ofdBoundary.setY(ofdBoundary.getY().add(diffY));
        }
        textObjectEle.addAttribute("Boundary", ofdBoundary.toString());
        String spaceStr = paramEle.attributeValue("space");
        BigDecimal space = Handle.isEmpty(spaceStr) ? BigDecimal.ZERO : new BigDecimal(spaceStr);
        String align = paramEle.attributeValue("align");
        this.setText(textObjectEle, ofdBoundary, text, space, align);
        return textObjectEle;
    }

    private void setText(Element textObjectEle, OFDBound ofdBoundary, String text, BigDecimal space, String fontAlign) {
        String fontSizeStr = textObjectEle.attributeValue("Size");
        BigDecimal fontSize = new BigDecimal(fontSizeStr);
        BigDecimal currentFontSize = this.getFontSize(fontSize, ofdBoundary.getWidth(), text);
        textObjectEle.addAttribute("Size", currentFontSize.stripTrailingZeros().toPlainString());
        BigDecimal diffY = fontSize.subtract(currentFontSize);
        BigDecimal textLength = new BigDecimal("0");
        StringBuilder strDeltaX = new StringBuilder();
        int num = 0;
        BigDecimal spaceX = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(space) == 0) {
            for (int i = 0; i < text.length(); ++i) {
                BigDecimal spaceBig = currentFontSize;
                char ch = text.charAt(i);
                if (!this.isChineseChar(ch)) {
                    spaceBig = spaceBig.multiply(new BigDecimal("0.5"));
                }
                if (spaceX.compareTo(BigDecimal.ZERO) != 0 && spaceX.compareTo(spaceBig) != 0) {
                    if (num != 1) {
                        strDeltaX.append("g ").append(num).append(' ');
                    }
                    strDeltaX.append(spaceX.stripTrailingZeros().toPlainString()).append(' ');
                    num = 0;
                }
                spaceX = spaceBig;
                ++num;
                textLength = textLength.add(spaceBig);
            }
            if (num != 1) {
                strDeltaX.append("g ").append(num).append(' ');
            }
            strDeltaX.append(spaceX.stripTrailingZeros().toPlainString()).append(' ');
        } else {
            space = currentFontSize.multiply(space).setScale(4, RoundingMode.HALF_UP);
            int length = text.length();
            strDeltaX.append("g ").append(length).append(' ').append(space.stripTrailingZeros().toPlainString());
            textLength = textLength.add(space.multiply(new BigDecimal(length)));
        }
        BigDecimal width = ofdBoundary.getWidth();
        String xIndex = "middle".equals(fontAlign) ? width.subtract(textLength).divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).abs().stripTrailingZeros().toPlainString() : ("right".equals(fontAlign) ? (width.compareTo(textLength) < 0 ? "0" : width.subtract(textLength).setScale(2, RoundingMode.HALF_UP).abs().stripTrailingZeros().toPlainString()) : "0");
        Element eleTextCode = textObjectEle.addElement("ofd:TextCode");
        eleTextCode.addAttribute("X", xIndex);
        String yStr = currentFontSize.multiply(new BigDecimal("1.2")).add(diffY).stripTrailingZeros().toPlainString();
        eleTextCode.addAttribute("Y", yStr);
        eleTextCode.addAttribute("DeltaX", strDeltaX.toString());
        eleTextCode.setText(text);
    }

    private List<Element> getBottomEleList(List<Element> bottomEleList, BigDecimal diffY, BigDecimal specialHeight, boolean multiPage, boolean normalFlag, boolean lastFlag) {
        ArrayList<Element> newBottomEleList = new ArrayList<Element>(8);
        BigDecimal drawerDiffY = diffY.add(specialHeight);
        if (!lastFlag) {
            drawerDiffY = drawerDiffY.subtract(FullDigitalEInvoiceConstant.AMOUNT_REMARK_SPACING_BIG);
        }
        for (Element bottomEle : bottomEleList) {
            List elements;
            String name = bottomEle.getName();
            if ("DIFF_HEIGHT".equals(name)) {
                this.addVerticalLine(bottomEle, drawerDiffY, newBottomEleList);
                continue;
            }
            if ("RIGHT_LINE".equals(name)) {
                this.addRightLine(bottomEle, drawerDiffY, newBottomEleList);
                continue;
            }
            if (normalFlag) {
                if ("SUBTOTAL".equals(name) && multiPage) {
                    elements = bottomEle.elements();
                    this.setBottomEleList(elements, diffY, newBottomEleList);
                    continue;
                }
                if ("TOTAL".equals(name)) {
                    elements = bottomEle.elements();
                    this.setBottomEleList(elements, diffY, newBottomEleList);
                    continue;
                }
            }
            if ("DRAWER".equals(name)) {
                elements = bottomEle.elements();
                this.setBottomEleList(elements, drawerDiffY, newBottomEleList);
                continue;
            }
            if (lastFlag && "LAST".equals(name)) {
                elements = bottomEle.elements();
                this.setBottomEleList(elements, drawerDiffY, newBottomEleList);
                continue;
            }
            this.setBottomEle(bottomEle, diffY.add(specialHeight), newBottomEleList);
        }
        return newBottomEleList;
    }

    private void setBottomEleList(List<Element> bottomEleList, BigDecimal diffY, List<Element> newBottomEleList) {
        for (Element bottomEle : bottomEleList) {
            this.setBottomEle(bottomEle, diffY, newBottomEleList);
        }
    }

    private void setBottomEle(Element bottomEle, BigDecimal diffY, List<Element> newBottomEleList) {
        String name = bottomEle.getName();
        if (!"PathObject".equals(name) && !"TextObject".equals(name)) {
            return;
        }
        Element newBottomEle = bottomEle.createCopy();
        String boundary = newBottomEle.attributeValue("Boundary");
        OFDBound ofdBoundary = new OFDBound(boundary);
        ofdBoundary.setY(ofdBoundary.getY().add(diffY));
        newBottomEle.addAttribute("Boundary", ofdBoundary.toString());
        newBottomEleList.add(newBottomEle);
    }

    private void addRightLine(Element bottomEle, BigDecimal diffY, List<Element> newBottomEleList) {
        Element topElement = bottomEle.element("TOP").element("PathObject").createCopy();
        BigDecimal diffYHalf = diffY.divide(new BigDecimal("2"), 3, RoundingMode.HALF_UP);
        String topBoundaryStr = topElement.attributeValue("Boundary");
        OFDBound topBoundary = new OFDBound(topBoundaryStr);
        BigDecimal height = topBoundary.getHeight().add(diffYHalf);
        topBoundary.setHeight(height);
        topElement.addAttribute("Boundary", topBoundary.toString());
        String abbreviatedData = String.format("M 0.2 0 L 0.2 %s", height.toPlainString());
        XmlHelperUtils.addNode((Element)topElement, (String)"ofd:AbbreviatedData", (String)abbreviatedData);
        Element bottomElement = bottomEle.element("BOTTOM").element("PathObject").createCopy();
        String bottomBoundaryStr = bottomElement.attributeValue("Boundary");
        OFDBound bottomBoundary = new OFDBound(bottomBoundaryStr);
        bottomBoundary.setHeight(height);
        bottomBoundary.setY(bottomBoundary.getY().add(diffYHalf));
        bottomElement.addAttribute("Boundary", bottomBoundary.toString());
        XmlHelperUtils.addNode((Element)bottomElement, (String)"ofd:AbbreviatedData", (String)abbreviatedData);
        newBottomEleList.add(topElement);
        newBottomEleList.add(bottomElement);
    }

    private void addVerticalLine(Element bottomEle, BigDecimal diffY, List<Element> newBottomEleList) {
        List diffHeightList = bottomEle.elements("PathObject");
        for (Element diffHeightEle : diffHeightList) {
            Element newBottomEle = diffHeightEle.createCopy();
            String boundary = newBottomEle.attributeValue("Boundary");
            OFDBound ofdBoundary = new OFDBound(boundary);
            BigDecimal height = ofdBoundary.getHeight().add(diffY);
            ofdBoundary.setHeight(height);
            newBottomEle.addAttribute("Boundary", ofdBoundary.toString());
            String lineStr = String.format("M 0.2 0 L 0.2 %s", height.toPlainString());
            XmlHelperUtils.addNode((Element)newBottomEle, (String)"ofd:AbbreviatedData", (String)lineStr);
            newBottomEleList.add(newBottomEle);
        }
    }

    private BigDecimal getFontSize(BigDecimal fontSize, BigDecimal bigLen, String text) {
        BigDecimal currentFontSize = fontSize;
        BigDecimal nTextLen = BigDecimal.ZERO;
        for (int i = 0; i < text.length(); ++i) {
            char n = text.charAt(i);
            nTextLen = this.isChineseChar(n) ? nTextLen.add(BigDecimal.ONE) : nTextLen.add(new BigDecimal("0.5"));
        }
        BigDecimal currentLen = nTextLen.multiply(currentFontSize).setScale(3, RoundingMode.HALF_UP);
        while (currentLen.compareTo(bigLen) > 0) {
            currentFontSize = currentFontSize.subtract(new BigDecimal("0.1"));
            currentLen = nTextLen.multiply(currentFontSize).setScale(3, RoundingMode.HALF_UP);
        }
        return currentFontSize;
    }

    private boolean isChineseChar(int n) {
        return (0 > n || n > 127) && n != 165;
    }
}

