/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.service.xml;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.dto.allelespecial.BillCoBuyerItemVo;
import kd.imc.bdm.file.fpy.enums.BusinessSectorTypeEnum;
import kd.imc.bdm.file.fpy.enums.ConsumptionTaxpayerTypeEnum;
import kd.imc.bdm.file.fpy.enums.DifferenceTaxTypeEnum;
import kd.imc.bdm.file.fpy.enums.ExportEnterpriseClassificationEnum;
import kd.imc.bdm.file.fpy.enums.InvoiceIssuanceMethodEnum;
import kd.imc.bdm.file.fpy.enums.InvoiceTypeEnum;
import kd.imc.bdm.file.fpy.enums.SpecialTypeEnum;
import kd.imc.bdm.file.fpy.enums.SpecificTaxationMethodEnum;
import kd.imc.bdm.file.fpy.enums.TaxpayerCreditGradeEnum;
import kd.imc.bdm.file.fpy.enums.TaxpayerTypeEnum;
import kd.imc.bdm.file.fpy.model.pdf.fedi.CargoTransportItem;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoiceItem;
import kd.imc.bdm.file.fpy.model.pdf.fedi.PassengerTransportItem;
import kd.imc.bdm.file.fpy.model.pdf.fedi.UserCarInfo;
import kd.imc.bdm.file.fpy.model.pdf.fedi.VehicleCarInfo;
import kd.imc.bdm.file.fpy.model.xml.ConstructionServicesItem;
import kd.imc.bdm.file.fpy.model.xml.EtaxInvoiceExtraInfo;
import kd.imc.bdm.file.fpy.model.xml.FullDigitalEInvoiceXml;
import kd.imc.bdm.file.fpy.model.xml.RealEstateLeaseItem;
import kd.imc.bdm.file.fpy.model.xml.RealEstateSalesItem;
import kd.imc.bdm.file.fpy.model.xml.TaxationOfVehicleAndVesselUseTax;
import kd.imc.bdm.file.fpy.model.xml.TractorandHarvesterItem;
import kd.imc.bdm.file.fpy.service.ofd.util.XmlHelperUtils;
import kd.imc.bdm.file.fpy.util.AreaUtil;
import kd.imc.bdm.file.fpy.util.EInvoicePdfUtils;
import kd.imc.bdm.file.fpy.util.MoneyUtil;
import kd.imc.bdm.file.util.DateUtils;
import kd.imc.bdm.file.util.ErrorType;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FullDigitalEInvoiceXmlService {
    private static Log log = LogFactory.getLog(FullDigitalEInvoiceXmlService.class);

    public byte[] createXml(FullDigitalEInvoiceXml fullDigitalEInvoiceXml) {
        byte[] standaloneByteArray;
        Date startDate = new Date();
        InvoiceTypeEnum invoiceType = InvoiceTypeEnum.getInvoiceTypeByValue(fullDigitalEInvoiceXml.getInvoiceType());
        if (invoiceType == null) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0420.errcode, ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u79cd\u7c7b\u4e0d\u652f\u6301\u751f\u6210XML!", (String)"FullDigitalEInvoiceXmlService_0", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        String taxNo = fullDigitalEInvoiceXml.getSalerTaxNo();
        SpecialTypeEnum specialType = SpecialTypeEnum.getSpecialTypeByValue((String)fullDigitalEInvoiceXml.getSpecialType());
        if (SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS == specialType || SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS_02 == specialType) {
            taxNo = fullDigitalEInvoiceXml.getBuyerTaxNo();
        }
        String areaCode = EInvoicePdfUtils.getFullTaxCodeByNsrsbh((String)taxNo, (String)fullDigitalEInvoiceXml.getTaxBureauCode());
        Element eInvoiceElement = DocumentHelper.createElement((String)"EInvoice");
        Document document = DocumentHelper.createDocument((Element)eInvoiceElement);
        this.addHeader(fullDigitalEInvoiceXml, eInvoiceElement, areaCode);
        this.addEInvoiceData(fullDigitalEInvoiceXml, eInvoiceElement);
        this.addSellerAuthentication(eInvoiceElement);
        this.addTaxSupervisionInfo(fullDigitalEInvoiceXml, eInvoiceElement, areaCode);
        this.addPtbh(fullDigitalEInvoiceXml.getPtbh(), eInvoiceElement);
        try {
            standaloneByteArray = XmlHelperUtils.toStandaloneByteArray((Document)document);
        }
        catch (IOException e) {
            throw new KDBizException(new ErrorCode(ErrorType.SYSTEM_ERROR_B0001.errcode, ResManager.loadKDString((String)"\u751f\u6210XML\u51fa\u9519!", (String)"FullDigitalEInvoiceXmlService_1", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        Date endTime = new Date();
        log.info("XML\u751f\u6210\u8017\u65f6{}", (Object)(endTime.getTime() - startDate.getTime()));
        return standaloneByteArray;
    }

    private void addHeader(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceElement, String areaCode) {
        Element headerElement = eInvoiceElement.addElement("Header");
        XmlHelperUtils.addNotEmptyNode((Element)headerElement, (String)"EIid", (String)fullDigitalEInvoiceXml.getInvoiceNo());
        XmlHelperUtils.addNotEmptyNode((Element)headerElement, (String)"EInvoiceTag", (String)("SWEI" + areaCode));
        XmlHelperUtils.addNotEmptyNode((Element)headerElement, (String)"Version", (String)"0.3");
        this.addHeaderInHerentLabel(fullDigitalEInvoiceXml, headerElement);
        this.addHeaderUndefinedLabel(fullDigitalEInvoiceXml, headerElement);
    }

    private void addHeaderInHerentLabel(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element headerElement) {
        InvoiceTypeEnum invoiceTypeEnum = InvoiceTypeEnum.getInvoiceTypeByValue(fullDigitalEInvoiceXml.getInvoiceType());
        Element inherentLabelElement = headerElement.addElement("InherentLabel");
        String inIssueType = fullDigitalEInvoiceXml.getTotalAmount().compareTo(BigDecimal.ZERO) >= 0 ? "Y" : "N";
        XmlHelperUtils.addLabelByKey((Element)inherentLabelElement, (String)"InIssuType", null, (String)inIssueType, (String)"\u662f\u5426\u84dd\u5b57\u53d1\u7968\u6807\u5fd7");
        SpecialTypeEnum specialType = SpecialTypeEnum.getSpecialTypeByValue((String)fullDigitalEInvoiceXml.getSpecialType());
        String invoiceType = "01";
        String invoiceName = "\u7535\u5b50\u53d1\u7968";
        String billType = "01";
        String billName = "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968";
        if (SpecialTypeEnum.MOTOR_VEHICLE == specialType || InvoiceTypeEnum.CAR_VEHICLE_INVOICE == invoiceTypeEnum) {
            invoiceType = "02";
            invoiceName = "\u673a\u52a8\u8f66\u9500\u552e\u7535\u5b50\u7edf\u4e00\u53d1\u7968";
            billType = "03";
            billName = "\u673a\u52a8\u8f66\u7edf\u4e00\u9500\u552e\u53d1\u7968";
        } else if (SpecialTypeEnum.USED_CAR == specialType || InvoiceTypeEnum.USED_CAR_INVOICE == invoiceTypeEnum) {
            invoiceType = "03";
            invoiceName = "\u4e8c\u624b\u8f66\u9500\u552e\u7535\u5b50\u7edf\u4e00\u53d1\u7968";
            billType = "04";
            billName = "\u4e8c\u624b\u8f66\u7edf\u4e00\u9500\u552e\u53d1\u7968";
        } else if (InvoiceTypeEnum.ORDINARY_INVOICE == invoiceTypeEnum) {
            billType = "02";
            billName = "\u666e\u901a\u53d1\u7968";
        }
        XmlHelperUtils.addLabelByKey((Element)inherentLabelElement, (String)"EInvoiceType", null, (String)invoiceType, (String)invoiceName);
        XmlHelperUtils.addLabelByKey((Element)inherentLabelElement, (String)"GeneralOrSpecialVAT", null, (String)billType, (String)billName);
        TaxpayerTypeEnum taxpayerType = TaxpayerTypeEnum.getTaxpayerTypeEnumByValue((String)fullDigitalEInvoiceXml.getTaxpayerType());
        if (taxpayerType != null) {
            XmlHelperUtils.addLabelByKey((Element)inherentLabelElement, (String)"TaxpayerType", null, (String)taxpayerType.getValue(), (String)taxpayerType.getMsg());
        }
    }

    private void addHeaderUndefinedLabel(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element headerElement) {
        TaxpayerCreditGradeEnum taxpayerCreditGrade;
        DifferenceTaxTypeEnum differenceTaxType;
        String specificTaxationMethod;
        String specificTaxationMethodMsg;
        ExportEnterpriseClassificationEnum exportEnterpriseClassification;
        String consumptionTaxpayerType;
        String consumptionTaxpayerTypeMsg;
        InvoiceIssuanceMethodEnum invoiceIssuanceMethodEnum;
        Element undefinedLabelElement = headerElement.addElement("UndefinedLabel");
        String businessSectorTypeValue = fullDigitalEInvoiceXml.getBusinessSectorType();
        String businessSectorTypeMsg = BusinessSectorTypeEnum.getBusinessSectorTypeMsgByValue((String)businessSectorTypeValue);
        if (StringUtils.isNotEmpty((CharSequence)businessSectorTypeMsg)) {
            XmlHelperUtils.addLabel((Element)undefinedLabelElement, (String)"\u4f01\u4e1a\u884c\u4e1a\u6027\u8d28\u7c7b\u6807\u7b7e", (String)businessSectorTypeValue, (String)businessSectorTypeMsg);
        }
        if ((invoiceIssuanceMethodEnum = InvoiceIssuanceMethodEnum.getinvoiceIssuanceMethodEnum((String)fullDigitalEInvoiceXml.getInvoiceIssuanceMethod())) != null) {
            XmlHelperUtils.addLabel((Element)undefinedLabelElement, (String)"\u53d1\u7968\u5f00\u5177\u65b9\u5f0f\u6807\u7b7e", (String)invoiceIssuanceMethodEnum.getValue(), (String)invoiceIssuanceMethodEnum.getMsg());
        }
        if (StringUtils.isNotEmpty((CharSequence)(consumptionTaxpayerTypeMsg = ConsumptionTaxpayerTypeEnum.getConsumptionTaxpayerTypeMsgByValue((String)(consumptionTaxpayerType = fullDigitalEInvoiceXml.getConsumptionTaxpayerType()))))) {
            XmlHelperUtils.addLabel((Element)undefinedLabelElement, (String)"\u6d88\u8d39\u7a0e\u7eb3\u7a0e\u4eba\u6807\u7b7e", (String)consumptionTaxpayerType, (String)consumptionTaxpayerTypeMsg);
        }
        if ((exportEnterpriseClassification = ExportEnterpriseClassificationEnum.getExportEnterpriseClassificationEnum((String)fullDigitalEInvoiceXml.getExportEnterpriseClassification())) != null) {
            XmlHelperUtils.addLabel((Element)undefinedLabelElement, (String)"\u51fa\u53e3\u4f01\u4e1a\u5206\u7c7b\u7ba1\u7406\u6807\u7b7e", (String)exportEnterpriseClassification.getValue(), (String)exportEnterpriseClassification.getMsg());
        }
        if (StringUtils.isNotEmpty((CharSequence)(specificTaxationMethodMsg = SpecificTaxationMethodEnum.getSpecificTaxationMethodMsgByValue((String)(specificTaxationMethod = fullDigitalEInvoiceXml.getSpecificTaxationMethod()))))) {
            XmlHelperUtils.addLabel((Element)undefinedLabelElement, (String)"\u7279\u5b9a\u5f81\u7a0e\u65b9\u5f0f\u6807\u7b7e", (String)specificTaxationMethod, (String)specificTaxationMethodMsg);
        }
        if ((differenceTaxType = DifferenceTaxTypeEnum.getDifferenceTaxTypeByValue((String)fullDigitalEInvoiceXml.getDifferenceTaxType())) != null) {
            XmlHelperUtils.addLabel((Element)undefinedLabelElement, (String)"\u5dee\u989d\u5f81\u7a0e\u6807\u7b7e", (String)differenceTaxType.getValue(), (String)differenceTaxType.getMsg());
        }
        if ((taxpayerCreditGrade = TaxpayerCreditGradeEnum.getTaxpayerCreditGradeEnumByValue((String)fullDigitalEInvoiceXml.getTaxpayerCreditGrade())) != null) {
            XmlHelperUtils.addLabel((Element)undefinedLabelElement, (String)"\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u6807\u7b7e", (String)taxpayerCreditGrade.getValue(), (String)taxpayerCreditGrade.getMsg());
        }
    }

    private void addEInvoiceData(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceElement) {
        Element eInvoiceDataElement = eInvoiceElement.addElement("EInvoiceData");
        this.addSellerInfo(fullDigitalEInvoiceXml, eInvoiceDataElement);
        this.addBuyerInfo(fullDigitalEInvoiceXml, eInvoiceDataElement);
        this.addBasicInformation(fullDigitalEInvoiceXml, eInvoiceDataElement);
        this.addIssuItemInformation(fullDigitalEInvoiceXml, eInvoiceDataElement);
        this.addSpecificInformation(fullDigitalEInvoiceXml, eInvoiceDataElement);
        this.addAdditionalInformation(fullDigitalEInvoiceXml, eInvoiceDataElement);
    }

    private void addSellerInfo(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        Element sellerInformationElement = eInvoiceDataElement.addElement("SellerInformation");
        XmlHelperUtils.addNotEmptyNode((Element)sellerInformationElement, (String)"SellerIdNum", (String)fullDigitalEInvoiceXml.getSalerTaxNo());
        XmlHelperUtils.addNotEmptyNode((Element)sellerInformationElement, (String)"SellerName", (String)fullDigitalEInvoiceXml.getSalerName());
        XmlHelperUtils.addNotEmptyNode((Element)sellerInformationElement, (String)"SellerAddr", (String)fullDigitalEInvoiceXml.getSalerAddr());
        XmlHelperUtils.addNotEmptyNode((Element)sellerInformationElement, (String)"SellerTelNum", (String)fullDigitalEInvoiceXml.getSalerTelNum());
        XmlHelperUtils.addNotEmptyNode((Element)sellerInformationElement, (String)"SellerBankName", (String)fullDigitalEInvoiceXml.getSalerBankName());
        XmlHelperUtils.addNotEmptyNode((Element)sellerInformationElement, (String)"SellerBankAccNum", (String)fullDigitalEInvoiceXml.getSalerBankAccNum());
    }

    private void addBuyerInfo(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        Element buyerInformationElement = eInvoiceDataElement.addElement("BuyerInformation");
        XmlHelperUtils.addNotEmptyNode((Element)buyerInformationElement, (String)"BuyerIdNum", (String)fullDigitalEInvoiceXml.getBuyerTaxNo());
        XmlHelperUtils.addNotEmptyNode((Element)buyerInformationElement, (String)"BuyerName", (String)fullDigitalEInvoiceXml.getBuyerName());
        XmlHelperUtils.addNotEmptyNode((Element)buyerInformationElement, (String)"BuyerAddr", (String)fullDigitalEInvoiceXml.getBuyerAddr());
        XmlHelperUtils.addNotEmptyNode((Element)buyerInformationElement, (String)"BuyerTelNum", (String)fullDigitalEInvoiceXml.getBuyerTelNum());
        XmlHelperUtils.addNotEmptyNode((Element)buyerInformationElement, (String)"BuyerBankName", (String)fullDigitalEInvoiceXml.getBuyerBankName());
        XmlHelperUtils.addNotEmptyNode((Element)buyerInformationElement, (String)"BuyerBankAccNum", (String)fullDigitalEInvoiceXml.getBuyerBankAccNum());
        XmlHelperUtils.addNotEmptyNode((Element)buyerInformationElement, (String)"BuyerHandlingName", (String)fullDigitalEInvoiceXml.getBuyerHandlingName());
    }

    private void addBasicInformation(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        Element basicInformationElement = eInvoiceDataElement.addElement("BasicInformation");
        XmlHelperUtils.addNotEmptyNode((Element)basicInformationElement, (String)"TotalAmWithoutTax", (String)EInvoicePdfUtils.getPriceWithScale((BigDecimal)fullDigitalEInvoiceXml.getInvoiceAmount()));
        XmlHelperUtils.addNotEmptyNode((Element)basicInformationElement, (String)"TotalTaxAm", (String)EInvoicePdfUtils.getPriceWithScale((BigDecimal)fullDigitalEInvoiceXml.getTotalTaxAmount()));
        XmlHelperUtils.addNotEmptyNode((Element)basicInformationElement, (String)"TotalTax-includedAmount", (String)EInvoicePdfUtils.getPriceWithScale((BigDecimal)fullDigitalEInvoiceXml.getTotalAmount()));
        XmlHelperUtils.addNotEmptyNode((Element)basicInformationElement, (String)"TotalTax-includedAmountInChinese", (String)MoneyUtil.moneyCapital((String)EInvoicePdfUtils.getPriceWithScale((BigDecimal)fullDigitalEInvoiceXml.getTotalAmount())));
        XmlHelperUtils.addNotEmptyNode((Element)basicInformationElement, (String)"Drawer", (String)fullDigitalEInvoiceXml.getDrawer());
        XmlHelperUtils.addNotEmptyNode((Element)basicInformationElement, (String)"RequestTime", (String)DateUtils.format((Date)fullDigitalEInvoiceXml.getIssueTime(), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    private void addIssuItemInformation(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        List<FullDigitalEInvoiceItem> itemList = fullDigitalEInvoiceXml.getItemList();
        if (itemList != null && !itemList.isEmpty()) {
            for (FullDigitalEInvoiceItem item : itemList) {
                Element itemInformation = eInvoiceDataElement.addElement("IssuItemInformation");
                XmlHelperUtils.addNotEmptyNode((Element)itemInformation, (String)"ItemName", (String)item.getGoodsName());
                XmlHelperUtils.addNotEmptyNode((Element)itemInformation, (String)"SpecMod", (String)item.getSpecModel());
                XmlHelperUtils.addNotEmptyNode((Element)itemInformation, (String)"MeaUnits", (String)item.getUnit());
                XmlHelperUtils.addNotEmptyNode((Element)itemInformation, (String)"Quantity", (String)EInvoicePdfUtils.getBigDecimalStr((BigDecimal)item.getNum()));
                XmlHelperUtils.addNotEmptyNode((Element)itemInformation, (String)"UnPrice", (String)EInvoicePdfUtils.getBigDecimalStr((BigDecimal)item.getUnitPrice()));
                XmlHelperUtils.addNotEmptyNode((Element)itemInformation, (String)"Amount", (String)EInvoicePdfUtils.getBigDecimalStr((BigDecimal)item.getDetailAmount()));
                XmlHelperUtils.addNotEmptyNode((Element)itemInformation, (String)"TaxRate", (String)EInvoicePdfUtils.getBigDecimalStr((BigDecimal)item.getTaxRate()));
                XmlHelperUtils.addNotEmptyNode((Element)itemInformation, (String)"ComTaxAm", (String)EInvoicePdfUtils.getBigDecimalStr((BigDecimal)item.getTaxAmount()));
                XmlHelperUtils.addNotEmptyNode((Element)itemInformation, (String)"TotaltaxIncludedAmount", (String)EInvoicePdfUtils.getBigDecimalStr((BigDecimal)item.getDetailAmount().add(item.getTaxAmount())));
                XmlHelperUtils.addNotEmptyNode((Element)itemInformation, (String)"TaxClassificationCode", (String)item.getClassificationCode());
            }
        }
    }

    private void addSpecificInformation(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        String invoiceType = fullDigitalEInvoiceXml.getInvoiceType();
        SpecialTypeEnum specialType = SpecialTypeEnum.getSpecialTypeByValue((String)fullDigitalEInvoiceXml.getSpecialType());
        if (SpecialTypeEnum.CONSTRUCTION_SERVICE == specialType) {
            this.addConstructionServices(fullDigitalEInvoiceXml.getConstructionServicesItem(), eInvoiceDataElement);
        } else if (SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType) {
            this.addFreightService(fullDigitalEInvoiceXml.getCargoTransportList(), eInvoiceDataElement);
        } else if (SpecialTypeEnum.PASSENGER_TRANSPORT == specialType) {
            this.addPassengerTransportation(fullDigitalEInvoiceXml.getTravelerList(), eInvoiceDataElement);
        } else if (SpecialTypeEnum.SALE_OF_REAL_ESTATE == specialType) {
            this.addSaleOfRealEstate(fullDigitalEInvoiceXml.getRealEstateSalesItems(), eInvoiceDataElement, fullDigitalEInvoiceXml.getCoBuyerItems());
        } else if (SpecialTypeEnum.REAL_ESTATE_OPERATING_LEASE == specialType) {
            this.addRealEstateOperatingLease(fullDigitalEInvoiceXml.getRealEstateLeasesItems(), eInvoiceDataElement);
        } else if (SpecialTypeEnum.COLLECT_VEHICLE_AND_SHIP_TAXES == specialType) {
            this.addTaxationOfVehicleAndVesselUseTax(fullDigitalEInvoiceXml.getTaxationOfVehicleAndVesselUseTax(), eInvoiceDataElement);
        } else if (SpecialTypeEnum.TRACTORS_AND_COMBINE_HARVESTERS == specialType) {
            this.addTractorandHarvesterItem(fullDigitalEInvoiceXml.getTractorandHarvesterItem(), eInvoiceDataElement);
        } else if (InvoiceTypeEnum.CAR_VEHICLE_INVOICE.getValue().equals(invoiceType)) {
            this.addCarVehicleEle(fullDigitalEInvoiceXml.getVehicleCar(), eInvoiceDataElement);
        } else if (InvoiceTypeEnum.USED_CAR_INVOICE.getValue().equals(invoiceType)) {
            this.addUserCarEle(fullDigitalEInvoiceXml.getUserCar(), eInvoiceDataElement);
        }
        this.addSpecialDifferentialTaxation(fullDigitalEInvoiceXml, eInvoiceDataElement);
        this.addSpecialRedEInvoice(fullDigitalEInvoiceXml, eInvoiceDataElement);
    }

    private void addSpecialDifferentialTaxation(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        DifferenceTaxTypeEnum differenceTaxType = DifferenceTaxTypeEnum.getDifferenceTaxTypeByValue((String)fullDigitalEInvoiceXml.getDifferenceTaxType());
        if (differenceTaxType != null && (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoiceXml.getDeduction()) || StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoiceXml.getSalesIncludingTax()))) {
            Element specificInformation = eInvoiceDataElement.element("SpecificInformation");
            if (specificInformation == null) {
                specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            }
            Element differentialTaxation = specificInformation.addElement("DifferentialTaxation");
            XmlHelperUtils.addNotEmptyNode((Element)differentialTaxation, (String)"Deduction", (String)fullDigitalEInvoiceXml.getDeduction());
            XmlHelperUtils.addNotEmptyNode((Element)differentialTaxation, (String)"SalesIncludingTax", (String)fullDigitalEInvoiceXml.getSalesIncludingTax());
        }
    }

    private void addSpecialRedEInvoice(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        boolean redInvoice;
        boolean bl = redInvoice = fullDigitalEInvoiceXml.getTotalAmount().compareTo(BigDecimal.ZERO) < 0;
        if (redInvoice && (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoiceXml.getOriginalInvoiceCode()) || StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoiceXml.getCreditNoteNumber()))) {
            Element specificInformation = eInvoiceDataElement.element("SpecificInformation");
            if (specificInformation == null) {
                specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            }
            Element redEInvoice = specificInformation.addElement("RedEInvoice");
            XmlHelperUtils.addNotEmptyNode((Element)redEInvoice, (String)"OriginalInvoiceCode", (String)fullDigitalEInvoiceXml.getOriginalInvoiceCode());
            XmlHelperUtils.addNotEmptyNode((Element)redEInvoice, (String)"CreditNoteNumber", (String)fullDigitalEInvoiceXml.getCreditNoteNumber());
        }
    }

    private void addConstructionServices(ConstructionServicesItem constructionServicesItem, Element eInvoiceDataElement) {
        if (constructionServicesItem != null) {
            Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            Element constructionServices = specificInformation.addElement("ConstructionServices");
            XmlHelperUtils.addNotEmptyNode((Element)constructionServices, (String)"OccurredSite", (String)constructionServicesItem.getOccurredSite());
            XmlHelperUtils.addNotEmptyNode((Element)constructionServices, (String)"ItemName", (String)constructionServicesItem.getItemName());
            XmlHelperUtils.addNotEmptyNode((Element)constructionServices, (String)"LandValueAddedTaxProjectNumber", (String)constructionServicesItem.getLandValueAddedTaxProjectNumber());
            XmlHelperUtils.addNotEmptyNode((Element)constructionServices, (String)"CrossRegionIdentifier", (String)constructionServicesItem.getCrossRegionIdentifier());
        }
    }

    private void addFreightService(List<CargoTransportItem> cargoTransportList, Element eInvoiceDataElement) {
        if (cargoTransportList != null && !cargoTransportList.isEmpty()) {
            for (CargoTransportItem item : cargoTransportList) {
                Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
                Element freightService = specificInformation.addElement("FreightService");
                XmlHelperUtils.addNotEmptyNode((Element)freightService, (String)"FreightService", (String)item.getStartPlace());
                XmlHelperUtils.addNotEmptyNode((Element)freightService, (String)"Destination", (String)item.getEndPlace());
                XmlHelperUtils.addNotEmptyNode((Element)freightService, (String)"TypeOfTransportationMeans", (String)item.getTransportType());
                XmlHelperUtils.addNotEmptyNode((Element)freightService, (String)"TransportationMeansNo", (String)item.getLicensePlate());
                XmlHelperUtils.addNotEmptyNode((Element)freightService, (String)"NameOfGoodsTransported", (String)item.getTransportGoods());
            }
        }
    }

    private void addPassengerTransportation(List<PassengerTransportItem> travelerList, Element eInvoiceDataElement) {
        if (travelerList != null && !travelerList.isEmpty()) {
            for (PassengerTransportItem item : travelerList) {
                Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
                Element passengerTransportation = specificInformation.addElement("PassengerTransportation");
                XmlHelperUtils.addNotEmptyNode((Element)passengerTransportation, (String)"Traveler", (String)item.getTraveler());
                XmlHelperUtils.addNotEmptyNode((Element)passengerTransportation, (String)"TravelDate", (String)item.getTravelDate());
                XmlHelperUtils.addNotEmptyNode((Element)passengerTransportation, (String)"Departure", (String)item.getStartPlace());
                XmlHelperUtils.addNotEmptyNode((Element)passengerTransportation, (String)"Destination", (String)item.getEndPlace());
                XmlHelperUtils.addNotEmptyNode((Element)passengerTransportation, (String)"Grade", (String)item.getSeatClass());
                XmlHelperUtils.addNotEmptyNode((Element)passengerTransportation, (String)"Vehicletype", (String)item.getTransportType());
                XmlHelperUtils.addNotEmptyNode((Element)passengerTransportation, (String)"TypeOfPassengerDocument", (String)item.getCardType());
                XmlHelperUtils.addNotEmptyNode((Element)passengerTransportation, (String)"ValidIDNumber", (String)item.getCardNo());
            }
        }
    }

    private void addSaleOfRealEstate(List<RealEstateSalesItem> realEstateSalesItems, Element eInvoiceDataElement, List<BillCoBuyerItemVo> coBuyerItems) {
        if (!CollectionUtils.isEmpty(realEstateSalesItems)) {
            Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            for (RealEstateSalesItem realEstateSalesItem : realEstateSalesItems) {
                Element realEstateSales = specificInformation.addElement("RealEstateSales");
                XmlHelperUtils.addNotEmptyNode((Element)realEstateSales, (String)"HouseTitleCertificateNumber", (String)realEstateSalesItem.getHouseTitleCertificateNumber());
                XmlHelperUtils.addNotEmptyNode((Element)realEstateSales, (String)"RealEstateAddress", (String)realEstateSalesItem.getRealEstateAddress());
                XmlHelperUtils.addNotEmptyNode((Element)realEstateSales, (String)"RealEstateUnitNumber", (String)realEstateSalesItem.getRealEstateUnitNumber());
                XmlHelperUtils.addNotEmptyNode((Element)realEstateSales, (String)"RealOnlineContracteNo", (String)realEstateSalesItem.getRealOnlineContracteNo());
                XmlHelperUtils.addNotEmptyNode((Element)realEstateSales, (String)"ActualTransactionAmountIncludingTax", (String)realEstateSalesItem.getActualTransactionAmountIncludingTax());
                XmlHelperUtils.addNotEmptyNode((Element)realEstateSales, (String)"LandValueAddedTaxProjectNumber", (String)realEstateSalesItem.getLandValueAddedTaxProjectNumber());
                XmlHelperUtils.addNotEmptyNode((Element)realEstateSales, (String)"CrossRegionIdentifier", (String)realEstateSalesItem.getCrossRegionIdentifier());
                XmlHelperUtils.addNotEmptyNode((Element)realEstateSales, (String)"ApprovedTaxPrice", (String)realEstateSalesItem.getApprovedTaxPrice());
            }
        }
        if (!CollectionUtils.isEmpty(coBuyerItems)) {
            Element coBuyers = eInvoiceDataElement.addElement("CoBuyerInformation");
            for (BillCoBuyerItemVo coBuyerItem : coBuyerItems) {
                Element realCoBuyer = coBuyers.addElement("CoBuyers");
                XmlHelperUtils.addNotEmptyNode((Element)realCoBuyer, (String)"CoBuyer", (String)coBuyerItem.getCoBuyer());
                XmlHelperUtils.addNotEmptyNode((Element)realCoBuyer, (String)"CardType", (String)coBuyerItem.getCardType());
                XmlHelperUtils.addNotEmptyNode((Element)realCoBuyer, (String)"CardNo", (String)coBuyerItem.getCardNo());
            }
        }
    }

    private void addRealEstateOperatingLease(List<RealEstateLeaseItem> realEstateLeaseItems, Element eInvoiceDataElement) {
        if (!CollectionUtils.isEmpty(realEstateLeaseItems)) {
            Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            for (RealEstateLeaseItem realEstateLeaseItem : realEstateLeaseItems) {
                Element realEstateLease = specificInformation.addElement("RealEstateLease");
                XmlHelperUtils.addNotEmptyNode((Element)realEstateLease, (String)"RealEstateWarrantNumber", (String)realEstateLeaseItem.getHouseTitleCertificateNumber());
                XmlHelperUtils.addNotEmptyNode((Element)realEstateLease, (String)"RealEstateAddress", (String)realEstateLeaseItem.getRealEstateAddress());
                XmlHelperUtils.addNotEmptyNode((Element)realEstateLease, (String)"TheLeaseTermBeginsAndEnds", (String)realEstateLeaseItem.getTheLeaseTermBeginsAndEnds());
                XmlHelperUtils.addNotEmptyNode((Element)realEstateLease, (String)"CrossRegionIdentifier", (String)realEstateLeaseItem.getCrossRegionIdentifier());
                XmlHelperUtils.addNotEmptyNode((Element)realEstateLease, (String)"PlateNumber", (String)realEstateLeaseItem.getCarBrandNo());
            }
        }
    }

    private void addTaxationOfVehicleAndVesselUseTax(TaxationOfVehicleAndVesselUseTax vehicleAndShipTaxesItem, Element eInvoiceDataElement) {
        if (vehicleAndShipTaxesItem != null) {
            Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            Element taxationOfVehicleAndVesselUseTax = specificInformation.addElement("TaxationOfVehicleAndVesselUseTax");
            XmlHelperUtils.addNotEmptyNode((Element)taxationOfVehicleAndVesselUseTax, (String)"PolicyNo", (String)vehicleAndShipTaxesItem.getPolicyNo());
            XmlHelperUtils.addNotEmptyNode((Element)taxationOfVehicleAndVesselUseTax, (String)"ClassNO", (String)vehicleAndShipTaxesItem.getClassNo());
            XmlHelperUtils.addNotEmptyNode((Element)taxationOfVehicleAndVesselUseTax, (String)"TaxPeriod", (String)vehicleAndShipTaxesItem.getTaxPeriod());
            XmlHelperUtils.addNotEmptyNode((Element)taxationOfVehicleAndVesselUseTax, (String)"Amount", (String)vehicleAndShipTaxesItem.getAmount());
            XmlHelperUtils.addNotEmptyNode((Element)taxationOfVehicleAndVesselUseTax, (String)"LateFeeAmount", (String)vehicleAndShipTaxesItem.getLateFeeAmount());
            XmlHelperUtils.addNotEmptyNode((Element)taxationOfVehicleAndVesselUseTax, (String)"TotalAmount", (String)vehicleAndShipTaxesItem.getTotalAmount());
            XmlHelperUtils.addNotEmptyNode((Element)taxationOfVehicleAndVesselUseTax, (String)"TheFrameNumber", (String)vehicleAndShipTaxesItem.getTheFrameNumber());
        }
    }

    private void addTractorandHarvesterItem(TractorandHarvesterItem tractorandHarvesterItem, Element eInvoiceDataElement) {
        if (tractorandHarvesterItem != null) {
            Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            Element tractorandHarvester = specificInformation.addElement("TractorandHarvester");
            XmlHelperUtils.addNotEmptyNode((Element)tractorandHarvester, (String)"EngineCode", (String)tractorandHarvesterItem.getEngineCode());
            XmlHelperUtils.addNotEmptyNode((Element)tractorandHarvester, (String)"ChassisCode", (String)tractorandHarvesterItem.getChassisCode());
        }
    }

    private void addCarVehicleEle(VehicleCarInfo vehicleCar, Element eInvoiceDataElement) {
        if (vehicleCar != null) {
            Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            Element motorVehicleSales = specificInformation.addElement("MotorVehicleSales");
            XmlHelperUtils.addNotEmptyNode((Element)motorVehicleSales, (String)"VehicleModel", (String)vehicleCar.getVehicleType());
            XmlHelperUtils.addNotEmptyNode((Element)motorVehicleSales, (String)"MakeAndType", (String)vehicleCar.getBrandModel());
            XmlHelperUtils.addNotEmptyNode((Element)motorVehicleSales, (String)"PlaceOfOrigin", (String)vehicleCar.getProducingArea());
            XmlHelperUtils.addNotEmptyNode((Element)motorVehicleSales, (String)"QualifiedNumber", (String)vehicleCar.getCertificateNum());
            XmlHelperUtils.addNotEmptyNode((Element)motorVehicleSales, (String)"ImportCertificateIsBN", (String)vehicleCar.getImportCertificate());
            XmlHelperUtils.addNotEmptyNode((Element)motorVehicleSales, (String)"CommodityInspectionSlipNumber", (String)vehicleCar.getCommodityInspectionNum());
            XmlHelperUtils.addNotEmptyNode((Element)motorVehicleSales, (String)"EngineNo", (String)vehicleCar.getEngineNum());
            XmlHelperUtils.addNotEmptyNode((Element)motorVehicleSales, (String)"VehicleIdentificationNumberFrameNumber", (String)vehicleCar.getVehicleIdentificationCode());
            XmlHelperUtils.addNotEmptyNode((Element)motorVehicleSales, (String)"NumberOfTaxPaymentVoucher", (String)vehicleCar.getOverTaxCode());
            XmlHelperUtils.addNotEmptyNode((Element)motorVehicleSales, (String)"Ton", (String)vehicleCar.getTotalTon());
            XmlHelperUtils.addNotEmptyNode((Element)motorVehicleSales, (String)"MaximumCapacity", (String)vehicleCar.getLimitePeople());
        }
    }

    private void addUserCarEle(UserCarInfo userCar, Element eInvoiceDataElement) {
        if (userCar != null) {
            Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            Element usedCarSales = specificInformation.addElement("UsedCarSales");
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"LicensePlateNo", (String)userCar.getLicensePlateNumber());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"RegistrationNo", (String)userCar.getRegistrationNumber());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"VehicleType", (String)userCar.getVehicleType());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"VehicleIdentificationNumberFrameNumber", (String)userCar.getVehicleIdentificationNo());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"MakeAndType", (String)userCar.getBrandModel());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"NameOfTheLocalVehicleManagementOffice", (String)userCar.getVehicleManagementName());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"BusinessAuctionUnit", (String)userCar.getAuctionName());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"AddressOfBusinessAuctionUnit", (String)userCar.getAuctionAddress());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"BusinessAuctionUnitNum", (String)userCar.getAuctionTaxpayerId());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"BusinessAuctionUnitBankName", (String)userCar.getAuctionBankName());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"BusinessAuctionUnitBankAccNum", (String)userCar.getAuctionBankAccNum());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"BusinessAuctionUnitTel", (String)userCar.getAuctionPhoneNumber());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"UsedCarMarket", (String)userCar.getMarketName());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"UsedCarMarketNum", (String)userCar.getMarketTaxpayerId());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"UsedCarMarketAddr", (String)userCar.getMarketAddress());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"UsedCarMarketBankName", (String)userCar.getMarketBankName());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"UsedCarMarketBankAccNum", (String)userCar.getMarketBankAccNum());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"UsedCarMarketTel", (String)userCar.getMarketPhoneNumber());
            XmlHelperUtils.addNotEmptyNode((Element)usedCarSales, (String)"LicensePlateNumber", (String)userCar.getLicensePlateNumber());
        }
    }

    private void addAdditionalInformation(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        Element additionalInformation = eInvoiceDataElement.addElement("AdditionalInformation");
        XmlHelperUtils.addNotEmptyNode((Element)additionalInformation, (String)"Remark", (String)fullDigitalEInvoiceXml.getRemark());
        List<EtaxInvoiceExtraInfo> etaxInvoiceExtraInfos = fullDigitalEInvoiceXml.getEtaxInvoiceExtraInfos();
        if (etaxInvoiceExtraInfos != null && !etaxInvoiceExtraInfos.isEmpty()) {
            for (EtaxInvoiceExtraInfo etaxInvoiceExtraInfo : etaxInvoiceExtraInfos) {
                Element additional = additionalInformation.addElement("Additional");
                XmlHelperUtils.addNotEmptyNode((Element)additional, (String)"InformationType", (String)etaxInvoiceExtraInfo.getExtraType());
                XmlHelperUtils.addNotEmptyNode((Element)additional, (String)"InformationValue", (String)etaxInvoiceExtraInfo.getExtraValue());
                XmlHelperUtils.addNotEmptyNode((Element)additional, (String)"Information", (String)etaxInvoiceExtraInfo.getExtraName());
            }
        }
    }

    private void addSellerAuthentication(Element eInvoiceElement) {
        Element sellerAuthentication = eInvoiceElement.addElement("SellerAuthentication");
        XmlHelperUtils.addNotEmptyNode((Element)sellerAuthentication, (String)"AuthenticationMethods", (String)"01");
    }

    private void addTaxSupervisionInfo(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceElement, String areaCode) {
        String[] taxBureauArr;
        String taxBureau = (String)AreaUtil.getTaxBureauMap().get(areaCode);
        String taxBureauCode = null;
        String taxBureauName = null;
        if (StringUtils.isNotEmpty((CharSequence)taxBureau) && (taxBureauArr = taxBureau.split("-")).length == 2) {
            taxBureauCode = taxBureauArr[0];
            taxBureauName = taxBureauArr[1];
        }
        Element taxSupervisionInfo = eInvoiceElement.addElement("TaxSupervisionInfo");
        XmlHelperUtils.addNotEmptyNode((Element)taxSupervisionInfo, (String)"InvoiceNumber", (String)fullDigitalEInvoiceXml.getInvoiceNo());
        XmlHelperUtils.addNotEmptyNode((Element)taxSupervisionInfo, (String)"IssueTime", (String)DateUtils.format((Date)fullDigitalEInvoiceXml.getIssueTime(), (String)"yyyy-MM-dd"));
        XmlHelperUtils.addNotEmptyNode((Element)taxSupervisionInfo, (String)"TaxBureauCode", (String)taxBureauCode);
        XmlHelperUtils.addNotEmptyNode((Element)taxSupervisionInfo, (String)"TaxBureauName", (String)taxBureauName);
    }

    private void addPtbh(String ptbh, Element eInvoiceElement) {
        if (StringUtils.isNotEmpty((CharSequence)ptbh)) {
            XmlHelperUtils.addNotEmptyNode((Element)eInvoiceElement, (String)"ptbh", (String)ptbh);
        }
    }
}

