/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.util;

import com.alibaba.fastjson.JSONObject;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.file.fpy.enums.InvoiceTypeEnum;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoice;
import kd.imc.bdm.file.fpy.util.CRCUtil;
import kd.imc.bdm.file.util.DateUtils;
import kd.imc.bdm.file.util.ErrorType;
import org.apache.commons.lang3.StringUtils;

public class QRCodeUtil {
    private static final String character_set = "UTF-8";
    private static final ErrorCorrectionLevel error_correction = ErrorCorrectionLevel.M;
    private static final int margin = 0;
    private static final String qr_version = "5";
    private static final String image_type = "png";
    private static final Color font_color = new Color(250, 239, 173);
    private static final String font_name = "\u5b8b\u4f53";
    private static final int font_size = 22;
    private static final String middle_text = "\u7a0e";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encoderQRCodeByte(String content) {
        try {
            int width = 148;
            int height = 148;
            Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, character_set);
            hints.put(EncodeHintType.ERROR_CORRECTION, error_correction);
            hints.put(EncodeHintType.MARGIN, 0);
            hints.put(EncodeHintType.QR_VERSION, qr_version);
            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
            BufferedImage originalImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
            BufferedImage image = QRCodeUtil.addText(originalImage);
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)image, image_type, out);
                byte[] byArray = out.toByteArray();
                return byArray;
            }
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0400.errcode, ResManager.loadKDString((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff01", (String)"QRCodeUtil_1", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
    }

    private static BufferedImage addText(BufferedImage originalImage) {
        BufferedImage image = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 1);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.drawImage((Image)originalImage, 0, 0, null);
        Font font = new Font(font_name, 1, 22);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int textWidth = fontMetrics.stringWidth(middle_text);
        int textHeight = fontMetrics.getHeight();
        int x = (image.getWidth() - textWidth) / 2;
        int y = (image.getHeight() - textHeight) / 2 + textHeight;
        int bgSize = 5;
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(x - bgSize, y - textHeight, textWidth + 2 * bgSize, textHeight + 2 * bgSize);
        graphics2D.setColor(font_color);
        graphics2D.drawString(middle_text, x, y);
        graphics2D.dispose();
        return image;
    }

    public static String createString(JSONObject dataJson) throws UnsupportedEncodingException {
        String invoiceCode;
        StringBuilder content = new StringBuilder();
        String versionNo = "01";
        String invoiceTypeStr = InvoiceTypeEnum.ORDINARY_INVOICE.getTaxValue();
        InvoiceTypeEnum invoiceType = InvoiceTypeEnum.getInvoiceTypeByValue(dataJson.getString("invoiceType"));
        if (invoiceType != null) {
            invoiceTypeStr = invoiceType.getTaxValue();
        }
        if (StringUtils.isEmpty((CharSequence)(invoiceCode = dataJson.getString("invoiceCode")))) {
            invoiceCode = "";
        }
        String invoiceNo = dataJson.getString("invoiceNo");
        String totalMoney = dataJson.getString("totalAmount");
        String invoiceDate = DateUtils.format((Date)dataJson.getDate("issueTime"), (String)"yyyyMMdd");
        String invoiceCheckCode = dataJson.getString("JYM");
        if (StringUtils.isEmpty((CharSequence)invoiceCheckCode)) {
            invoiceCheckCode = "";
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceDate)) {
            invoiceDate = invoiceDate.substring(0, 8);
        }
        content.append(versionNo).append(',');
        content.append(invoiceTypeStr).append(',');
        content.append(invoiceCode).append(',');
        content.append(invoiceNo).append(',');
        content.append(totalMoney).append(',');
        content.append(invoiceDate).append(',');
        content.append(invoiceCheckCode);
        content.append(',');
        String crcCode = CRCUtil.getCrc((String)content.toString());
        content.append(crcCode);
        return content.toString();
    }

    public static String createStringByBean(FullDigitalEInvoice fullDigitalEInvoice) throws UnsupportedEncodingException {
        String totalMoney = fullDigitalEInvoice.getTotalAmount() != null ? fullDigitalEInvoice.getTotalAmount().toPlainString() : "";
        String invoiceDate = DateUtils.format((Date)fullDigitalEInvoice.getIssueTime(), (String)"yyyyMMdd");
        return QRCodeUtil.createStringByStr(fullDigitalEInvoice.getInvoiceType(), fullDigitalEInvoice.getInvoiceNo(), totalMoney, invoiceDate);
    }

    public static String createStringByStr(String invoiceType, String invoiceNo, String totalMoney, String invoiceDate) {
        try {
            StringBuilder content = new StringBuilder();
            String versionNo = "01";
            String invoiceTypeStr = InvoiceTypeEnum.ORDINARY_INVOICE.getTaxValue();
            InvoiceTypeEnum invoiceTypeEnum = InvoiceTypeEnum.getInvoiceTypeByValue(invoiceType);
            if (invoiceTypeEnum != null) {
                invoiceTypeStr = invoiceTypeEnum.getTaxValue();
            }
            String invoiceCode = "";
            invoiceNo = (String)StringUtils.defaultIfEmpty((CharSequence)invoiceNo, (CharSequence)"");
            String invoiceCheckCode = "";
            content.append(versionNo).append(",");
            content.append(invoiceTypeStr).append(",");
            content.append(invoiceCode).append(",");
            content.append(invoiceNo).append(",");
            if (totalMoney != null) {
                totalMoney = totalMoney.replace("\u00a5", "");
                totalMoney = totalMoney.replace("CNY", "");
                totalMoney = totalMoney.replace(" ", "");
            }
            content.append(totalMoney).append(",");
            content.append(invoiceDate).append(",");
            content.append(invoiceCheckCode);
            content.append(",");
            String crcCode = CRCUtil.getCrc((String)content.toString());
            content.append(crcCode);
            return content.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0400.errcode, ResManager.loadKDString((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u53c2\u6570\u7f16\u7801\u4e0d\u652f\u6301\uff01", (String)"QRCodeUtil_0", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0400.errcode, ResManager.loadKDString((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff01", (String)"QRCodeUtil_1", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
    }

    public static com.lowagie.text.Image encoderQRCodeImage(JSONObject dataJson) {
        try {
            String ewmStr = QRCodeUtil.createString(dataJson);
            return QRCodeUtil.encoderQRCodeImageByString(ewmStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0400.errcode, ResManager.loadKDString((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u53c2\u6570\u7f16\u7801\u4e0d\u652f\u6301\uff01", (String)"QRCodeUtil_0", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0400.errcode, ResManager.loadKDString((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff01", (String)"QRCodeUtil_1", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
    }

    public static com.lowagie.text.Image encoderQRCodeImageByString(String ewmStr) {
        try {
            byte[] ewmBytes = QRCodeUtil.encoderQRCodeByte(ewmStr);
            return com.lowagie.text.Image.getInstance((byte[])ewmBytes);
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0400.errcode, ResManager.loadKDString((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff01", (String)"QRCodeUtil_1", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
    }

    public static byte[] encoderQRCodeByte(FullDigitalEInvoice fullDigitalEInvoice) {
        try {
            String ewmStr = QRCodeUtil.createStringByBean(fullDigitalEInvoice);
            return QRCodeUtil.encoderQRCodeByte(ewmStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0400.errcode, ResManager.loadKDString((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u53c2\u6570\u7f16\u7801\u4e0d\u652f\u6301\uff01", (String)"QRCodeUtil_0", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0400.errcode, ResManager.loadKDString((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff01", (String)"QRCodeUtil_1", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
    }

    public static byte[] encoderQRCodeByte(JSONObject dataJson) {
        BigDecimal totalAmount = dataJson.getBigDecimal("totalAmount");
        String totalMoney = totalAmount != null ? totalAmount.toPlainString() : "";
        String invoiceDate = DateUtils.format((Date)dataJson.getDate("issueTime"), (String)"yyyyMMdd");
        String ewmStr = QRCodeUtil.createStringByStr(dataJson.getString("invoiceType"), dataJson.getString("invoiceNo"), totalMoney, invoiceDate);
        return QRCodeUtil.encoderQRCodeByte(ewmStr);
    }
}

