/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.util.ofd;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.file.util.Base64Util;
import kd.imc.bdm.file.util.OfdErrorType;
import kd.imc.bdm.file.util.XmlUtil;
import kd.imc.bdm.file.util.ofd.SvgUtil;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SVGConversionUtil {
    private static final Log LOGGER = LogFactory.getLog(SVGConversionUtil.class);

    public static List<String> svgSplit(String svgStr) throws Exception {
        ArrayList<String> strList = new ArrayList<String>(16);
        Document svgDocument = XmlUtil.loadXML((String)svgStr);
        Element rootElement = svgDocument.getRootElement();
        List elementList = rootElement.elements("svg");
        for (int i = 0; i < elementList.size(); ++i) {
            Element elementI = (Element)elementList.get(i);
            elementI.addAttribute("xmlns", "http://www.w3.org/2000/svg");
            elementI.addAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
            elementI.addAttribute("version", "1.1");
            strList.add(elementI.asXML());
        }
        return strList;
    }

    public static List<Object> convertSvgBytes2MulImage(String svgStr, float zoomScale, boolean strFlag, int imageType) {
        try {
            ArrayList<Object> imageList = new ArrayList<Object>(16);
            List<String> svgList = SVGConversionUtil.svgSplit(svgStr);
            for (int i = 0; i < svgList.size(); ++i) {
                String svgElementStr = svgList.get(i);
                Document document = DocumentHelper.parseText((String)svgElementStr);
                String widthStr = document.getRootElement().attributeValue("width").replace("mm", "");
                String heightStr = document.getRootElement().attributeValue("height").replace("mm", "");
                float width = SvgUtil.getPxByMM((float)(Float.parseFloat(widthStr) * zoomScale));
                float height = SvgUtil.getPxByMM((float)(Float.parseFloat(heightStr) * zoomScale));
                byte[] svgIBytes = XmlUtil.toByteArray((Document)document);
                try (ByteArrayInputStream in = new ByteArrayInputStream(svgIBytes);
                     ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    byte[] imageBytes = SVGConversionUtil.convert2Image(in, byteArrayOutputStream, width, height, imageType);
                    if (strFlag) {
                        imageList.add(Base64Util.base64encoder((byte[])imageBytes));
                        continue;
                    }
                    imageList.add(imageBytes);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error(OfdErrorType.CONVERT_PNG_ERROR.toString(), (Throwable)e);
                    throw new RuntimeException(OfdErrorType.CONVERT_PNG_ERROR.getDescription(), e);
                }
            }
            return imageList;
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.CONVERT_PNG_ERROR.toString(), (Throwable)e);
            throw new RuntimeException(OfdErrorType.CONVERT_PNG_ERROR.getDescription(), e);
        }
    }

    private static Transcoder getTranscoderByType(int imageType) {
        JPEGTranscoder transcoder;
        switch (imageType) {
            case 2: {
                transcoder = new JPEGTranscoder();
                break;
            }
            case 3: {
                transcoder = new TIFFTranscoder();
                break;
            }
            default: {
                transcoder = new PNGTranscoder();
            }
        }
        return transcoder;
    }

    /*
     * Exception decompiling
     */
    public static byte[] convertSvgBytes2Image(byte[] svgBytes, float width, float height, int imageType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] convert2Image(InputStream in, ByteArrayOutputStream out, float width, float height, int imageType) throws TranscoderException {
        Transcoder transcoder = SVGConversionUtil.getTranscoderByType(imageType);
        TranscoderInput input = new TranscoderInput(in);
        TranscoderOutput output = new TranscoderOutput((OutputStream)out);
        float size = width * height;
        if (size > 2.1474836E9f) {
            throw new RuntimeException(OfdErrorType.CONVERT_PNG_TOO_LARGE.getDescription());
        }
        transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(width * 2.0f));
        transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height * 2.0f));
        transcoder.addTranscodingHint(PNGTranscoder.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
        try {
            transcoder.transcode(input, output);
        }
        catch (OutOfMemoryError e) {
            LOGGER.error(OfdErrorType.CONVERT_PNG_ERROR.toString(), (Throwable)e);
            throw new RuntimeException(OfdErrorType.CONVERT_PNG_TOO_LARGE.getDescription(), e);
        }
        return out.toByteArray();
    }
}

