/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.util.pdf;

import com.alibaba.fastjson.JSONObject;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoice;
import kd.imc.bdm.file.util.XmlUtil;
import kd.imc.bdm.file.util.ofd.SVGConversionUtil;
import kd.imc.bdm.file.util.pdf.PdfWriteDataUtils;
import kd.imc.bdm.file.util.pdf.PdfWritePathUtils;

public class PdfUtils {
    public static byte[] convertToPdf(String svgStr) throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            BaseFont courierFont = BaseFont.createFont((String)"fonts/cour.ttf", (String)"Identity-H", (boolean)false);
            BaseFont kaiFont = BaseFont.createFont((String)"fonts/simkai.ttf", (String)"Identity-H", (boolean)false);
            BaseFont songFont = BaseFont.createFont((String)"fonts/simsun.ttc,0", (String)"Identity-H", (boolean)false);
            BaseFont[] fonts = new BaseFont[]{songFont, courierFont, kaiFont};
            List<String> strList = SVGConversionUtil.svgSplit(svgStr);
            ArrayList<byte[]> bytesList = new ArrayList<byte[]>(strList.size());
            for (int i = 0; i < strList.size(); ++i) {
                String svgDetailStr = strList.get(i);
                try (ByteArrayOutputStream bao = new ByteArrayOutputStream();){
                    org.dom4j.Document document = XmlUtil.loadXML((String)svgDetailStr);
                    org.dom4j.Element rootElement = document.getRootElement();
                    float width = PdfUtils.getFloatPxByStr(rootElement.attributeValue("width"));
                    float height = PdfUtils.getFloatPxByStr(rootElement.attributeValue("height"));
                    byte[] blankBytes = PdfUtils.generateBlankPdf(width, height);
                    PdfReader reader = new PdfReader(blankBytes);
                    PdfStamper stamp = new PdfStamper(reader, (OutputStream)bao);
                    PdfContentByte under = stamp.getOverContent(1);
                    List elements = rootElement.elements();
                    for (org.dom4j.Element detailElement : elements) {
                        String name = detailElement.getName();
                        if ("text".equals(name)) {
                            PdfWriteDataUtils.setTextValue((org.dom4j.Element)detailElement, (float)height, (PdfContentByte)under, (BaseFont[])fonts);
                            continue;
                        }
                        if ("path".equals(name)) {
                            PdfWritePathUtils.setPathValue((org.dom4j.Element)detailElement, (PdfContentByte)under, (float)height);
                            continue;
                        }
                        if (!"image".equals(name)) continue;
                        PdfUtils.setImageValue(detailElement, under, height);
                    }
                    if (stamp != null) {
                        stamp.setFormFlattening(true);
                        stamp.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                    bytesList.add(bao.toByteArray());
                    continue;
                }
            }
            Document doc = new Document();
            PdfCopy pdfCopy = new PdfCopy(doc, (OutputStream)bos);
            pdfCopy.setFullCompression();
            doc.open();
            for (int i = 0; i < bytesList.size(); ++i) {
                PdfImportedPage impPage = pdfCopy.getImportedPage(new PdfReader((byte[])bytesList.get(i)), 1);
                pdfCopy.addPage(impPage);
            }
            doc.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static byte[] generateBlankPdf(float width, float height) throws IOException, DocumentException {
        byte[] blankPdfBytes;
        try (ByteArrayOutputStream bao = new ByteArrayOutputStream();){
            Document document = new Document(new Rectangle(width, height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)bao);
            document.open();
            document.add((Element)new Paragraph(" "));
            document.close();
            writer.close();
            blankPdfBytes = bao.toByteArray();
        }
        return blankPdfBytes;
    }

    private static void setImageValue(org.dom4j.Element detailElement, PdfContentByte under, float fileHeight) throws IOException, DocumentException {
        float width = PdfUtils.getFloatPxByStr(detailElement.attributeValue("width"));
        float height = PdfUtils.getFloatPxByStr(detailElement.attributeValue("height"));
        float x = PdfUtils.getFloatPxByStr(detailElement.attributeValue("x"));
        float y = fileHeight - PdfUtils.getFloatPxByStr(detailElement.attributeValue("y")) - height;
        String imageData = detailElement.attributeValue("href").replace("data:image/png;base64,", "");
        Image image = Image.getInstance((byte[])Base64.getDecoder().decode(imageData));
        image.setAbsolutePosition(x, y);
        image.scaleAbsolute(width, height);
        under.addImage(image);
    }

    public static float getFloatPxByStr(String str) {
        float mm = Float.parseFloat(str.replace("mm", "").trim());
        return PdfUtils.getPxByMm(mm);
    }

    public static float getPxByMm(float mmValue) {
        return mmValue * 72.0f / 25.4f;
    }

    public static float getNormalPxBySvgPx(float pxValue) {
        return pxValue * 72.0f / 96.0f;
    }

    public static float getNormalPxBySvgStrPx(String pxValueStr) {
        return PdfUtils.getNormalPxBySvgPx(Float.parseFloat(pxValueStr));
    }

    public static float[] ctmCalPoint(float x, float y, float fileHeight, String[] ctmStrArr) {
        float svgY = fileHeight - y;
        float a = Float.parseFloat(ctmStrArr[0]);
        float b = Float.parseFloat(ctmStrArr[1]);
        float c = Float.parseFloat(ctmStrArr[2]);
        float d = Float.parseFloat(ctmStrArr[3]);
        float e = PdfUtils.getNormalPxBySvgStrPx(ctmStrArr[4]);
        float f = PdfUtils.getNormalPxBySvgStrPx(ctmStrArr[5]);
        float ctmX = x * a + svgY * c + 1.0f * e;
        float ctmY = x * b + svgY * d + 1.0f * f;
        return new float[]{a, b, c, d, ctmX, fileHeight - ctmY};
    }

    public static JSONObject getCarDataJson(FullDigitalEInvoice fullDigitalEInvoice) {
        JSONObject userCar;
        JSONObject dataJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)fullDigitalEInvoice));
        JSONObject vehicleCar = dataJson.getJSONObject("vehicleCar");
        if (vehicleCar != null) {
            dataJson.putAll((Map)vehicleCar);
        }
        if ((userCar = dataJson.getJSONObject("userCar")) != null) {
            dataJson.putAll((Map)userCar);
        }
        return dataJson;
    }
}

