/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.schedule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.AwsFpyConstant;
import kd.imc.bdm.common.constant.table.EnterPriseBaseInfoConstant;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.lqpt.model.response.base.SpbmResponseItem;
import kd.imc.bdm.lqpt.service.SpbmAndSlvService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxCodeUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(TaxCodeUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (DLock lock = DLock.create((String)("bdm" + TaxCodeUpdateTask.class.getSimpleName() + "lock"));){
            logger.info("\u8fdb\u884c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1");
            if (!lock.tryLock()) {
                logger.info("\u672a\u83b7\u53d6\u5230\u9501\uff0c\u4e0d\u66f4\u65b0");
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)("bdm" + TaxCodeUpdateTask.class.getSimpleName())))) {
                logger.info("\u7f13\u5b58\u672a\u5931\u6548\uff0c\u4e0d\u66f4\u65b0");
                return;
            }
            QFilter qFilter = new QFilter("issuechannel", "in", (Object)EnterPriseBaseInfoConstant.LQPT_CHANNEL_DIRECT);
            DynamicObjectCollection epInfoList = QueryServiceHelper.query((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "number", "enterpriserole"), (QFilter[])qFilter.toArray());
            if (epInfoList.size() == 0) {
                this.querySpbmByAws();
                return;
            }
            List<SpbmResponseItem> itemList = new ArrayList<SpbmResponseItem>(5000);
            SpbmAndSlvService taxpayerService = new SpbmAndSlvService();
            List accessTaxNo = epInfoList.stream().filter(epInfo -> "1".equals(epInfo.getString("enterpriserole"))).map(epInfo -> epInfo.getString("number")).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(accessTaxNo)) {
                DeleteServiceHelper.delete((String)"bdm_lqpt_spbm", (QFilter[])new QFilter("nsrsbh", "not in", accessTaxNo).toArray());
                for (String taxNo : accessTaxNo) {
                    try {
                        List<SpbmResponseItem> tempItemList = taxpayerService.querySpbmFromLq(taxNo);
                        if (!CollectionUtils.isNotEmpty(tempItemList)) continue;
                        itemList = tempItemList;
                    }
                    catch (Exception e) {
                        logger.error("\u540c\u6b65\u5546\u54c1\u5206\u7c7b\u7f16\u7801\u5931\u8d25" + taxNo, (Throwable)e);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(itemList)) {
                new SpbmAndSlvService().syncTaxCode2Base("", itemList);
            }
        }
    }

    private void querySpbmByAws() {
        Map awsConfigMap = ImcConfigUtil.getValue((String)"dim_imc_config_fpy");
        String clientId = ImcConfigUtil.getValue((Map)awsConfigMap, (String[])new String[]{"clientid", "dim_imc_config_fpy_clientid"});
        if (StringUtils.isBlank((CharSequence)clientId)) {
            logger.info("clientId\u4e3a\u7a7a");
            return;
        }
        try {
            AwsFpyService awsFpyService = AwsFpyService.newInstance();
            String url = ImcConfigUtil.getValue((Map)awsConfigMap, (String[])new String[]{"url", "dim_imc_config_fpy_url"});
            url = url + AwsFpyConstant.getUrl((String)"query_spbm") + "?access_token=" + awsFpyService.getAccessToken(Long.valueOf(0L), awsFpyService.getAwsConfig("use_tenant_clientid"));
            JSONObject jsonObject = awsFpyService.getAppJson(url, null);
            if (!ErrorType.SUCCESS.getCode().equals(jsonObject.getString("errcode"))) {
                logger.info("\u540c\u6b65\u5546\u54c1\u5206\u7c7b\u7f16\u7801\u5931\u8d25:" + jsonObject.toJSONString());
                return;
            }
            JSONObject data = jsonObject.getJSONObject("data");
            String versionNum = data.getString("versionNum");
            JSONArray items = data.getJSONArray("items");
            ArrayList<SpbmResponseItem> itemList = new ArrayList<SpbmResponseItem>(items.size());
            for (int i = 0; i < items.size(); ++i) {
                JSONObject spbmJson = items.getJSONObject(i);
                if ("N".equals(spbmJson.getString("availableState"))) continue;
                SpbmResponseItem item = new SpbmResponseItem();
                item.setSphfwssflhbbm(spbmJson.getString("goodsCode"));
                item.setSphfwmc(spbmJson.getString("goodsName"));
                item.setSphfwfljc(spbmJson.getString("goodsJmmc"));
                item.setZzssl(spbmJson.getString("taxRate"));
                item.setSm(spbmJson.getString("instruction"));
                item.setZzstsgl(spbmJson.getString("zzstsgl"));
                item.setXfszcyj("");
                item.setXfstsnrdm("");
                item.setXfsgl("");
                item.setGjz(spbmJson.getString("keyword"));
                item.setZzszcyj(spbmJson.getString("zzszcyj"));
                item.setDytjjbm(spbmJson.getString("tjjbm"));
                item.setSfhzx(spbmJson.getString("summaryItem"));
                itemList.add(item);
            }
            new SpbmAndSlvService().syncTaxCode2Base(versionNum, itemList);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5546\u54c1\u5206\u7c7b\u7f16\u7801\u5931\u8d25", (Throwable)e);
        }
    }
}

