/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.lqpt.constant.LqptErrorCode;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadItem;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadResultRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.electinvoiceupload.ElectInvoiceUploadResultResponse;
import kd.imc.bdm.lqpt.model.response.base.electinvoiceupload.ElectInvoiceUploadResultResponseItem;
import kd.imc.bdm.lqpt.service.ElectInvoiceUploadService;
import kd.imc.bdm.lqpt.service.InvoiceNoService;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.bdm.lqpt.service.OilService;
import kd.imc.bdm.lqpt.service.SxedService;

/*
 * Exception performing whole class analysis ignored.
 */
public class ElectInvoiceUploadService {
    public LqptResponse uploadInvoiceData(ElectInvoiceUploadRequest request, boolean subSxed) {
        LqptResponse stockReulst;
        if (request == null) {
            throw new KDBizException(LqptErrorCode.PARAM_EMPTY, new Object[0]);
        }
        if (subSxed) {
            boolean flag;
            String issueTimeMonth;
            String originalIssueMpnth;
            Date originalIssueTime;
            boolean flag2;
            LqptResponse lqptResponse = new LqptResponse(LqptErrorCode.SXED_LESS, false);
            lqptResponse.setBusinessFail(true);
            SxedService sxedService = new SxedService();
            if (request.getHjje().compareTo(BigDecimal.ZERO) > 0 ? !(flag2 = sxedService.subtract(request.getNsrsbh(), request.getFphm(), request.getHjje())) : (originalIssueTime = request.getOriginalIssueTime()) != null && (originalIssueMpnth = DateUtils.format((Date)originalIssueTime, (String)"MM")).equals(issueTimeMonth = DateUtils.format((Date)request.getKprq(), (String)"MM")) && !(flag = sxedService.subtract(request.getNsrsbh(), request.getFphm(), request.getHjje()))) {
                return lqptResponse;
            }
        }
        if (!(stockReulst = this.checkSpecial(request)).success()) {
            stockReulst.setBusinessFail(true);
            return stockReulst;
        }
        LqptService service = new LqptService();
        return service.send(request);
    }

    public LqptResponse uploadResult(DynamicObject invoice, DynamicObject asyncInvoice) {
        List list;
        ElectInvoiceUploadResultResponse uploadResult;
        String nsrsbh = invoice.getString("salertaxno");
        ElectInvoiceUploadResultRequest request = new ElectInvoiceUploadResultRequest();
        request.setNsrsbh(nsrsbh);
        request.setSllsh(asyncInvoice.getString("govorderno"));
        request.setInvoiceNo(invoice.getString("invoiceno"));
        String specialType = invoice.getString("specialtype");
        this.setAbilityAndServiceId(request, specialType);
        LqptService service = new LqptService();
        LqptResponse response = service.send((LqptRequest)request);
        if (response.success() && (uploadResult = (ElectInvoiceUploadResultResponse)response.getData()) != null && (list = uploadResult.getResultList()) != null && !list.isEmpty()) {
            ElectInvoiceUploadResultResponseItem item = (ElectInvoiceUploadResultResponseItem)list.get(0);
            SxedService sxedService = new SxedService();
            String status = item.getStatus();
            if (ElectInvoiceUploadResultRequestEnum.ALL_ELE_OIL.getSpecialType().equals(specialType) && "00".equals(status) && "1".equals(item.getCpyycbs())) {
                status = "02";
            }
            if (this.isUploadSuccess(status)) {
                InvoiceNoService invoiceNoService = new InvoiceNoService();
                invoiceNoService.invoiceSuccess(nsrsbh, item.getFphm());
                sxedService.updateSxed(nsrsbh, item.getFphm(), true);
                if (ElectInvoiceUploadResultRequestEnum.ALL_ELE_OIL.getSpecialType().equals(specialType)) {
                    OilService oilService = new OilService();
                    oilService.updateStock(nsrsbh, request.getInvoiceNo());
                }
            } else if ("02".equals(status)) {
                sxedService.updateSxed(nsrsbh, item.getFphm(), false);
            }
            if ("00".equals(status)) {
                return new LqptResponse("0000", ResManager.loadKDString((String)"\u6210\u529f", (String)"ElectInvoiceUploadService_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
            }
            return new LqptResponse(status, item.getMessage());
        }
        return new LqptResponse("01", response.getDescription());
    }

    private void setAbilityAndServiceId(ElectInvoiceUploadResultRequest request, String specialType) {
        if (StringUtils.isBlank((CharSequence)specialType) || "00".equals(specialType)) {
            return;
        }
        ElectInvoiceUploadResultRequestEnum enumBySpecialType = ElectInvoiceUploadResultRequestEnum.getEnumBySpecialType((String)specialType);
        if (enumBySpecialType == null) {
            return;
        }
        request.setAbilityId(enumBySpecialType.getAbilityId());
        request.setServiceId(enumBySpecialType.getServiceId());
    }

    private boolean isUploadSuccess(String status) {
        return "00".equals(status) || "03".equals(status);
    }

    private LqptResponse checkSpecial(ElectInvoiceUploadRequest request) {
        if ("01".equals(request.getTdys())) {
            OilService service = new OilService();
            List<ElectInvoiceUploadItem> itemList = request.getFpmxList();
            HashMap<String, BigDecimal> stockMap = new HashMap<String, BigDecimal>(8);
            for (ElectInvoiceUploadItem item : itemList) {
                BigDecimal sl = BigDecimalUtil.transDecimal((Object)item.getSl());
                sl = service.changeSl(item.getSphfwssflhbbm(), item.getDw(), sl);
                BigDecimal total = (BigDecimal)stockMap.get(item.getSphfwssflhbbm());
                if (total == null) {
                    stockMap.put(item.getSphfwssflhbbm(), sl);
                    continue;
                }
                stockMap.put(item.getSphfwssflhbbm(), sl.add(total));
            }
            LqptResponse response = service.checkStock(request.getNsrsbh(), stockMap);
            return response;
        }
        return new LqptResponse("0000", "");
    }
}

