/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.base.InvoiceNoRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.InvoiceNoResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.bdm.lqpt.service.SxedService;
import org.apache.commons.collections.CollectionUtils;

public class InvoiceNoService {
    private static Log logger = LogFactory.getLog(InvoiceNoService.class);
    private static final String yearFormat = "yy";
    private static String invoiceno_entity = "bdm_lqpt_invoiceno";
    private static String yfm_entity = "bdm_lqpt_yfm";

    private static int getPreInvoiceSize() {
        int yfmSize = 400;
        try {
            String yfmSizeStr = ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"yfm");
            if (StringUtils.isNotBlank((CharSequence)yfmSizeStr)) {
                yfmSize = Integer.parseInt(yfmSizeStr);
                if (yfmSize < 100) {
                    yfmSize = 100;
                }
                if (yfmSize > 5000) {
                    yfmSize = 5000;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5355\u6b21\u9884\u8d4b\u7801\u6570\u91cf\u5931\u8d25");
        }
        return yfmSize;
    }

    private static int getSplitInvoiceSize(Integer preInvoiceSize) {
        int invoiceNoSize = 100;
        try {
            if (null == preInvoiceSize) {
                preInvoiceSize = InvoiceNoService.getPreInvoiceSize();
            }
            invoiceNoSize = preInvoiceSize >> 2;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u62c6\u5206\u53d1\u7968\u5931\u8d25");
        }
        return invoiceNoSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getInvoiceNo(String nsrsbh, Date invoiceDate) {
        long start = System.currentTimeMillis();
        String year = new SimpleDateFormat(yearFormat).format(invoiceDate);
        String invoiceNo = this.getFromRedis(nsrsbh, year, start);
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
            return invoiceNo;
        }
        try (DLock lock = DLock.create((String)("lqpt_invoiceno" + nsrsbh), (String)"getLqInvoiceNo");){
            String string;
            if (!lock.tryLock(5000L)) {
                logger.info("\u8d4b\u7801{}\u672a\u83b7\u53d6\u5230\u9501", (Object)nsrsbh);
                String string2 = null;
                return string2;
            }
            invoiceNo = this.getFromRedis(nsrsbh, year, start);
            if (StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
                String string3 = invoiceNo;
                return string3;
            }
            QFilter[] qFilter = new QFilter("nsrsbh", "=", (Object)nsrsbh).and("status", "=", (Object)"0").and("invoice_no", "like", (Object)(year + "%")).and("collecttype", "!=", (Object)"1").toArray();
            List invocieNoList = QueryServiceHelper.queryPrimaryKeys((String)invoiceno_entity, (QFilter[])qFilter, (String)"id", (int)1);
            if (CollectionUtils.isEmpty((Collection)invocieNoList)) {
                try (TXHandle tx = TX.requiresNew();){
                    this.spitInvoiceNo(nsrsbh, year);
                }
                invocieNoList = QueryServiceHelper.queryPrimaryKeys((String)invoiceno_entity, (QFilter[])qFilter, (String)"id", (int)1);
            }
            if (!CollectionUtils.isNotEmpty((Collection)invocieNoList)) return null;
            invoiceNo = this.getFromRedis(nsrsbh, year, start);
            if (StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
                string = invoiceNo;
                return string;
            }
            invoiceNo = (String)invocieNoList.get(0);
            this.updateInvoiceNoStatus(invoiceNo, "1");
            logger.info("\u8d4b\u7801{}\u4ece\u53f7\u7801\u5217\u8868\u83b7\u53d6-{}\u8017\u65f6{}", new Object[]{nsrsbh, invoiceNo, System.currentTimeMillis() - start});
            string = invoiceNo;
            return string;
        }
        finally {
            logger.info("\u83b7\u53d6\u5230\u7684\u53d1\u7968\u53f7\u7801\u662f" + invoiceNo);
        }
    }

    private void updateInvoiceNoStatus(String invoiceNo, String status) {
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)invoiceno_entity);
            obj.set("id", (Object)invoiceNo);
            obj.set("status", (Object)status);
            SaveServiceHelper.update((DynamicObject)obj);
        }
    }

    private String getFromRedis(String nsrsbh, String year, long start) {
        String invoiceNo = CacheHelper.rpop((String)(nsrsbh + '-' + year));
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
            this.updateInvoiceNoStatus(invoiceNo, "1");
            logger.info("\u8d4b\u7801{}\u4eceredis\u4e2d\u83b7\u53d6-{}\u8017\u65f6{}", new Object[]{nsrsbh, invoiceNo, System.currentTimeMillis() - start});
        }
        return invoiceNo;
    }

    public void sendBack(String nsrsbh, String invoiceNo) {
        if (!StringUtils.isEmpty((CharSequence)invoiceNo)) {
            this.updateInvoiceNoStatus(invoiceNo, "0");
            new SxedService().updateSxed(nsrsbh, invoiceNo, false);
        }
    }

    public void invoiceSuccess(String nsrsbh, String invoiceNo) {
        if (!StringUtils.isEmpty((CharSequence)invoiceNo)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)invoiceno_entity);
            DeleteServiceHelper.delete((IDataEntityType)mainEntityType, (Object[])new Object[]{invoiceNo});
        }
    }

    private void spitInvoiceNo(String nsrsbh, String yy) {
        QFilter[] qFilter = new QFilter("nsrsbh", "=", (Object)nsrsbh).and("year", "=", (Object)yy).and("sysl", ">", (Object)0).and("collecttype", "!=", (Object)"1").toArray();
        DynamicObject[] yfmArr = BusinessDataServiceHelper.load((String)yfm_entity, (String)"id,fpqshm,fpzzhm,lysl,sysl,update_time", (QFilter[])qFilter, (String)"id", (int)5);
        SimpleDateFormat sdf = new SimpleDateFormat(yearFormat);
        String curryear = sdf.format(new Date());
        if ((yfmArr == null || yfmArr.length == 0) && curryear.equals(yy)) {
            logger.info("\u8d4b\u7801{}\u9884\u8d4b\u7801\u5168\u90e8\u7528\u5b8c\uff0c\u4ece\u7a0e\u5c40\u7533\u8bf7\u9884\u8d4b\u7801", (Object)nsrsbh);
            yfmArr = this.getYfmInvoiceNo(nsrsbh, qFilter);
        }
        if (yfmArr == null || yfmArr.length == 0) {
            logger.info("\u8d4b\u7801{}\u672a\u67e5\u8be2\u5230\u9884\u8d4b\u7801", (Object)nsrsbh);
            return;
        }
        int invoiceNoSize = InvoiceNoService.getSplitInvoiceSize(null);
        ArrayList<String> allList = new ArrayList<String>(invoiceNoSize);
        ArrayList<DynamicObject> yfmList = new ArrayList<DynamicObject>(4);
        for (DynamicObject obj : yfmArr) {
            int sysl = obj.getInt("sysl");
            if ((long)sysl <= 0L) continue;
            List<String> list = this.getInvoiceNoList(obj.getString("fpzzhm"), sysl, invoiceNoSize - allList.size());
            allList.addAll(list);
            obj.set("sysl", (Object)(sysl -= list.size()));
            yfmList.add(obj);
            if (allList.size() >= invoiceNoSize) break;
        }
        ImcSaveServiceHelper.update(yfmList);
        if (CollectionUtils.isEmpty(allList)) {
            logger.info("\u8d4b\u7801{}\u62c6\u5206\u51fa\u7684\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a", (Object)nsrsbh);
            return;
        }
        ArrayList<DynamicObject> invoiceNoList = new ArrayList<DynamicObject>(4);
        logger.info("\u8d4b\u7801{}\u62c6\u5206\u9884\u8d4b\u7801\uff0c\u62c6\u5206\u6570\u91cf{}\uff0c\u8d77\u59cb\u53f7\u7801{}\uff0c\u7ec8\u6b62\u53f7\u7801{}", new Object[]{nsrsbh, allList.size(), allList.get(0), allList.get(allList.size() - 1)});
        Object orgId = TaxUtils.getOrgDynamicObjectByTaxNo((String)nsrsbh).getPkValue();
        for (String invoiceNo : allList) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)invoiceno_entity);
            obj.set("id", (Object)invoiceNo);
            obj.set("nsrsbh", (Object)nsrsbh);
            obj.set("org", orgId);
            obj.set("invoice_no", (Object)invoiceNo);
            obj.set("status", (Object)"0");
            obj.set("collecttype", (Object)"0");
            invoiceNoList.add(obj);
        }
        ImcSaveServiceHelper.save(invoiceNoList);
        for (String invoiceNo : allList) {
            CacheHelper.lpush((String)(nsrsbh + '-' + yy), (String[])new String[]{invoiceNo});
        }
    }

    private DynamicObject[] getYfmInvoiceNo(String nsrsbh, QFilter[] qFilter) {
        DynamicObject result = this.request(nsrsbh, null);
        if (result != null) {
            return BusinessDataServiceHelper.load((String)yfm_entity, (String)"id,fpqshm,fpzzhm,lysl,sysl,update_time", (QFilter[])qFilter, (String)"id", (int)5);
        }
        return null;
    }

    private DynamicObject request(String taxNo, Integer lysl) {
        InvoiceNoRequest request = new InvoiceNoRequest();
        request.setNsrsbh(taxNo);
        if (null == lysl) {
            request.setLysl(Integer.valueOf(InvoiceNoService.getPreInvoiceSize()));
        } else {
            request.setLysl(lysl);
        }
        LqptService service = new LqptService();
        LqptResponse queryResponse = service.send((LqptRequest)request);
        if (queryResponse.success()) {
            InvoiceNoResponse respnse = (InvoiceNoResponse)queryResponse.getData();
            DynamicObject updateObj = BusinessDataServiceHelper.newDynamicObject((String)yfm_entity);
            updateObj.set("fpqshm", (Object)respnse.getFpqshm());
            updateObj.set("fpzzhm", (Object)respnse.getFpzzhm());
            updateObj.set("lysl", (Object)respnse.getLysl());
            updateObj.set("sysl", (Object)respnse.getLysl());
            updateObj.set("create_time", (Object)new Date());
            updateObj.set("update_time", (Object)new Date());
            updateObj.set("year", (Object)respnse.getFpqshm().subSequence(0, 2));
            updateObj.set("nsrsbh", (Object)taxNo);
            updateObj.set("org", TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo).getPkValue());
            if (null == lysl) {
                updateObj.set("collecttype", (Object)"0");
            } else {
                updateObj.set("collecttype", (Object)"1");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updateObj});
            return updateObj;
        }
        return null;
    }

    private List<String> getInvoiceNoList(String fpzzhm, int sysl, int size) {
        ArrayList<String> list = new ArrayList<String>(10);
        BigInteger endInvoiceNo = new BigInteger(fpzzhm);
        BigInteger remain = new BigInteger(String.valueOf(sysl));
        BigInteger startInvoiceNo = endInvoiceNo.subtract(remain).add(BigInteger.ONE);
        if (sysl >= size) {
            endInvoiceNo = endInvoiceNo.subtract(remain.subtract(new BigInteger(String.valueOf(size))));
        }
        while (startInvoiceNo.compareTo(endInvoiceNo) <= 0) {
            list.add(startInvoiceNo.toString());
            startInvoiceNo = startInvoiceNo.add(BigInteger.ONE);
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    public boolean collectInvoiceNoByHandler(String nsrsbh, int collectSize) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 29[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

