/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.base.SlvRequest;
import kd.imc.bdm.lqpt.model.request.base.SpbmRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.SlvResponse;
import kd.imc.bdm.lqpt.model.response.base.SlvResponseItem;
import kd.imc.bdm.lqpt.model.response.base.SpbmResponse;
import kd.imc.bdm.lqpt.model.response.base.SpbmResponseItem;
import kd.imc.bdm.lqpt.model.response.base.SpbmResponseItemHy;
import kd.imc.bdm.lqpt.schedule.TaxCodeUpdateTask;
import kd.imc.bdm.lqpt.service.CigaretteService;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.bdm.lqpt.service.OilService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SpbmAndSlvService {
    private static Log logger = LogFactory.getLog(SpbmAndSlvService.class);

    public List<SpbmResponseItem> querySpbmFromLq(String taxNo) {
        List<SpbmResponseItem> cigaretteList;
        logger.info("\u4ece\u4e50\u4f01\u4e0b\u8f7d\u7a0e\u6536\u5206\u7c7b\u7f16\u7801{}", (Object)taxNo);
        SpbmRequest request = new SpbmRequest();
        request.setNsrsbh(taxNo);
        List<SpbmResponseItem> itemList = this.dispatchLqTaxCode(request);
        if (CollectionUtils.isEmpty(itemList)) {
            return new ArrayList<SpbmResponseItem>(1);
        }
        DynamicObject[] array = this.convertSpbmListToDynamicObject(taxNo, itemList);
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"bdm_lqpt_spbm", (QFilter[])new QFilter("nsrsbh", "=", (Object)taxNo).toArray());
            SaveServiceHelper.save((DynamicObject[])array);
        }
        List<SpbmResponseItem> oillist = new OilService().querySpbmFromLq(taxNo);
        if (!oillist.isEmpty()) {
            itemList.addAll(oillist);
        }
        if (!(cigaretteList = new CigaretteService().querySpbmFromLq(taxNo)).isEmpty()) {
            itemList.addAll(cigaretteList);
        }
        return itemList;
    }

    List<SpbmResponseItem> dispatchLqTaxCode(SpbmRequest request) {
        LqptService service = new LqptService();
        LqptResponse response = service.send((LqptRequest)request);
        if (!response.success()) {
            return new ArrayList<SpbmResponseItem>(1);
        }
        SpbmResponse spbmResponse = (SpbmResponse)response.getData();
        if (spbmResponse == null) {
            return new ArrayList<SpbmResponseItem>(1);
        }
        return spbmResponse.getSsbmList();
    }

    DynamicObject[] convertSpbmListToDynamicObject(String taxNo, List<SpbmResponseItem> itemList) {
        int count = 0;
        DynamicObject[] array = new DynamicObject[itemList.size()];
        for (SpbmResponseItem item : itemList) {
            DynamicObject slObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_lqpt_spbm");
            slObject.set("nsrsbh", (Object)taxNo);
            slObject.set("create_time", (Object)new Date());
            slObject.set("number", (Object)item.getSphfwssflhbbm());
            slObject.set("name", (Object)item.getSphfwmc());
            slObject.set("fjbm", (Object)item.getFjbm());
            slObject.set("tdyslxdm", (Object)item.getTdyslxdm());
            slObject.set("cezs", (Object)item.getCezs());
            slObject.set("bzs", (Object)item.getBzs());
            slObject.set("jzjtdm", (Object)item.getJzjtdm());
            slObject.set("sphfwfljc", (Object)item.getSphfwfljc());
            slObject.set("sm", (Object)item.getSm());
            slObject.set("zzssl", (Object)item.getZzssl());
            slObject.set("zsl", (Object)item.getZsl());
            slObject.set("zzstsgl", (Object)item.getZzstsgl());
            slObject.set("zzszcyj", (Object)item.getZzszcyj());
            slObject.set("zzstsnrdm", (Object)item.getZzstsnrdm());
            slObject.set("xfsgl", (Object)item.getXfsgl());
            slObject.set("xfszcyj", (Object)item.getXfszcyj());
            slObject.set("xfstsnrdm", (Object)item.getXfstsnrdm());
            slObject.set("gjz", (Object)item.getGjz());
            slObject.set("sfhzx", (Object)item.getSfhzx());
            slObject.set("dytjjbm", (Object)item.getDytjjbm());
            slObject.set("hgjcksppm", (Object)item.getHgjcksppm());
            slObject.set("qyrq", (Object)item.getQyrq());
            slObject.set("tyrq", (Object)item.getTyrq());
            List zspmList = item.getZspmList();
            if (zspmList != null && !zspmList.isEmpty()) {
                DynamicObjectCollection collect = slObject.getDynamicObjectCollection("zspmlist");
                for (SpbmResponseItemHy hy : zspmList) {
                    DynamicObject entry = collect.addNew();
                    entry.set("hydm", (Object)hy.getHydm());
                    entry.set("dydhy", (Object)hy.getDydhy());
                    entry.set("hydydzspm1", (Object)hy.getHydydzspm1());
                    entry.set("hydydzsmc1", (Object)hy.getHydydzsmc1());
                    entry.set("hydydzspm2", (Object)hy.getHydydzspm2());
                    entry.set("hydydzsmc2", (Object)hy.getHydydzsmc2());
                }
            }
            array[count++] = slObject;
        }
        return array;
    }

    public void queryLvFromLq(String taxNo) {
        logger.info("\u4ece\u4e50\u4f01\u4e0b\u8f7d\u53ef\u7528\u7a0e\u7387{}", (Object)taxNo);
        int count = 0;
        SlvRequest request = new SlvRequest();
        request.setNsrsbh(taxNo);
        LqptService service = new LqptService();
        LqptResponse response = service.send((LqptRequest)request);
        if (!response.success()) {
            return;
        }
        SlvResponse slvResponse = (SlvResponse)response.getData();
        List list = slvResponse.getSlzslList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        DynamicObject[] array = new DynamicObject[list.size()];
        for (SlvResponseItem item : list) {
            DynamicObject slObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_lqpt_sl");
            slObject.set("nsrsbh", (Object)taxNo);
            slObject.set("create_time", (Object)new Date());
            slObject.set("update_time", (Object)new Date());
            slObject.set("csxz", (Object)item.getCsxz());
            slObject.set("slzsl", (Object)item.getSlzsl());
            slObject.set("yslbz", (Object)item.getYslbz());
            slObject.set("dyysl", (Object)item.getDyysl());
            slObject.set("cszt", (Object)item.getCszt());
            slObject.set("yxqq", (Object)item.getYxqq());
            slObject.set("yxqz", (Object)item.getYxqz());
            slObject.set("tyrq", (Object)item.getTyrq());
            array[count++] = slObject;
        }
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"bdm_lqpt_sl", (QFilter[])new QFilter("nsrsbh", "=", (Object)taxNo).toArray());
            SaveServiceHelper.save((DynamicObject[])array);
        }
    }

    public void syncTaxCode2Base(String versionNum, List<SpbmResponseItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u7a0e\u6536\u5206\u7c7b\u7f16\u7801");
            return;
        }
        boolean notExistDisable = "1".equals(ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"taxCode"));
        Map<String, SpbmResponseItem> taxCodeMap = itemList.stream().collect(Collectors.toMap(SpbmResponseItem::getSphfwssflhbbm, v -> v, (v1, v2) -> v2));
        DynamicObject[] taxCodeObjArr = BusinessDataServiceHelper.load((String)"er_taxclasscode", (String)"", null);
        if (taxCodeObjArr != null && taxCodeObjArr.length != 0) {
            for (DynamicObject taxCodeObj : taxCodeObjArr = BusinessDataServiceHelper.load((Object[])Arrays.stream(taxCodeObjArr).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_taxclasscode"))) {
                SpbmResponseItem item = taxCodeMap.remove(taxCodeObj.getString("mergecode"));
                if (StringUtils.isNotBlank((CharSequence)versionNum)) {
                    taxCodeObj.set("version", (Object)versionNum);
                }
                if (item == null) {
                    logger.info("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5728\u8fd4\u56de\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\uff0c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}", (Object)taxCodeObj.getString("mergecode"));
                    if (!notExistDisable) continue;
                    taxCodeObj.set("enable", (Object)"0");
                    logger.info("\u7981\u7528\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}", (Object)taxCodeObj.getString("mergecode"));
                    continue;
                }
                taxCodeObj.set("enable", (Object)"1");
                taxCodeObj.set("status", (Object)"C");
                if (!taxCodeObj.getString("name").equals(item.getSphfwmc())) {
                    logger.info("\u4fee\u6539\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}\uff0c\u4fee\u6539\u540d\u79f0\uff0c\u539f\u540d\u79f0{},\u73b0\u540d\u79f0{}", new Object[]{taxCodeObj.getString("mergecode"), taxCodeObj.getString("name"), item.getSphfwmc()});
                    taxCodeObj.set("name", (Object)item.getSphfwmc());
                }
                if (!taxCodeObj.getString("simplename").equals(item.getSphfwfljc())) {
                    logger.info("\u4fee\u6539\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}\uff0c\u4fee\u6539\u7b80\u79f0\uff0c\u539f\u7b80\u79f0{},\u73b0\u7b80\u79f0{}", new Object[]{taxCodeObj.getString("mergecode"), taxCodeObj.getString("simplename"), item.getSphfwfljc()});
                    taxCodeObj.set("simplename", (Object)item.getSphfwfljc());
                }
                if (!taxCodeObj.getString("vatspecialmanagement").equals(item.getZzstsgl())) {
                    logger.info("\u4fee\u6539\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}\uff0c\u4fee\u6539\u589e\u503c\u7a0e\u7279\u6b8a\u7ba1\u7406\uff0c\u539f\u589e\u503c\u7a0e\u7279\u6b8a\u7ba1\u7406{},\u73b0\u589e\u503c\u7a0e\u7279\u6b8a\u7ba1\u7406{}", new Object[]{taxCodeObj.getString("mergecode"), taxCodeObj.getString("vatspecialmanagement"), item.getZzstsgl()});
                    taxCodeObj.set("vatspecialmanagement", (Object)item.getZzstsgl());
                }
                BigDecimal taxRate = new BigDecimal(TaxRateUtil.percent2Point((String)item.getZzssl()));
                if (taxCodeObj.getBigDecimal("taxrate").compareTo(taxRate) != 0) {
                    logger.info("\u4fee\u6539\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}\uff0c\u4fee\u6539\u7a0e\u7387\uff0c\u539f\u7a0e\u7387{},\u73b0\u7a0e\u7387{}", new Object[]{taxCodeObj.getString("mergecode"), taxCodeObj.getString("taxrate"), taxRate});
                    taxCodeObj.set("taxrate", (Object)taxRate);
                }
                boolean hzx = "Y".equals(item.getSfhzx());
                if (taxCodeObj.getBoolean("sumitem") == hzx) continue;
                logger.info("\u4fee\u6539\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}\uff0c\u4fee\u6539\u6c47\u603b\u9879\uff0c\u539f\u6c47\u603b\u9879{},\u73b0\u6c47\u603b\u9879{}", new Object[]{taxCodeObj.getString("mergecode"), taxCodeObj.getString("sumitem"), item.getSfhzx()});
                taxCodeObj.set("sumitem", (Object)hzx);
            }
            SaveServiceHelper.update((DynamicObject[])taxCodeObjArr);
        }
        CacheHelper.put((String)("bdm" + TaxCodeUpdateTask.class.getSimpleName()), (String)"11", (int)86400);
        Set<Map.Entry<String, SpbmResponseItem>> entries = taxCodeMap.entrySet();
        if (entries.size() == 0) {
            logger.info("\u6ca1\u6709\u65b0\u589e\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801");
            return;
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(entries.size());
        for (Map.Entry<String, SpbmResponseItem> entry : entries) {
            saveList.add(this.createTaxClassCodeDynamic(entry.getValue()));
            logger.info("\u4e0d\u5b58\u5728\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u65b0\u589e:{}\uff0c\u4fee\u6539\u4fe1\u606f{}", (Object)entry.getValue().getSphfwssflhbbm(), (Object)JSONObject.toJSONString((Object)entry.getValue()));
        }
        logger.info("\u4e0d\u5b58\u5728\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u65b0\u589e:{}", (Object)saveList.size());
        SaveServiceHelper.saveOperate((String)"er_taxclasscode", (DynamicObject[])saveList.toArray(new DynamicObject[0]), null);
    }

    private DynamicObject createTaxClassCodeDynamic(SpbmResponseItem item) {
        String pid;
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"er_taxclasscode");
        String spbm = item.getSphfwssflhbbm();
        String number = spbm.replaceAll("(00)+$", "");
        String longNumber = SpbmAndSlvService.getTaxClassCodeLongNumber(number);
        String[] longNumberArr = longNumber.split("\\.");
        Long id = Long.valueOf(number);
        obj.set("id", (Object)id);
        obj.set("number", (Object)number);
        obj.set("masterid", (Object)number);
        obj.set("longnumber", (Object)longNumber);
        obj.set("mergecode", (Object)spbm);
        obj.set("name", (Object)item.getSphfwmc());
        obj.set("level", (Object)(longNumberArr.length - 1));
        String string = pid = longNumber.length() > 1 ? longNumberArr[longNumberArr.length - 2] : null;
        if (pid != null) {
            DynamicObject parent = BusinessDataServiceHelper.newDynamicObject((String)"er_taxclasscode");
            parent.set("id", (Object)Long.valueOf(pid));
            obj.set("parent", (Object)parent);
        }
        obj.set("parentnum", (Object)pid);
        obj.set("taxrate", (Object)new BigDecimal(TaxRateUtil.percent2Point((String)item.getZzssl())));
        obj.set("simplename", (Object)item.getSphfwfljc());
        obj.set("vatspecialmanagement", (Object)item.getZzstsgl());
        obj.set("excisepolicy", (Object)item.getXfszcyj().replaceAll("\\{}", ""));
        obj.set("excisespecialcontentnum", (Object)item.getXfstsnrdm().replaceAll("\\{}", ""));
        obj.set("excisemanagement", (Object)item.getXfsgl().replaceAll("\\{}", ""));
        obj.set("key", (Object)item.getGjz());
        obj.set("vatspecialcontent", (Object)item.getZzszcyj());
        obj.set("vatspecialnum", (Object)item.getZzstsnrdm());
        obj.set("officecode", (Object)item.getDytjjbm());
        obj.set("sumitem", (Object)"Y".equals(item.getSfhzx()));
        obj.set("description", (Object)item.getSm());
        obj.set("status", (Object)"C");
        obj.set("enable", (Object)"1");
        obj.set("source", (Object)"2");
        obj.set("ishidden", (Object)false);
        return obj;
    }

    private static String getTaxClassCodeLongNumber(String spbm) {
        if (StringUtils.isBlank((CharSequence)spbm)) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>(16);
        list.add(spbm.substring(0, 1));
        for (int i = 1; i < spbm.length(); i += 2) {
            int endIndex = Math.min(i + 2, spbm.length());
            list.add((String)list.get(list.size() - 1) + spbm.substring(i, endIndex));
        }
        return String.join((CharSequence)".", list);
    }
}

