/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service.ability;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.ThreadPoolsHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.lqpt.annotation.LqAbilityAnnotation;
import kd.imc.bdm.lqpt.constant.LqptErrorCode;
import kd.imc.bdm.lqpt.model.LqEpConfig;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.unittest.LqptUnitTestService;
import kd.imc.bdm.lqpt.utils.SM4Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;

public class LqptAbilityService {
    static Log log = LogFactory.getLog(LqptAbilityService.class);
    private String abilityId;
    private String serviceId;
    private String responseStr;
    protected LqptRequest request;
    private String responClass;
    private LqEpConfig lqEpConfig;
    public static final ImmutableMap<String, Pair<String, String>> LQPT_OTHER = new ImmutableMap.Builder().put((Object)"202007", (Object)Pair.of((Object)"202076", (Object)"202077")).build();
    private static final ImmutableMap<String, String> BUSNESS_FAIL_CODE = new ImmutableMap.Builder().put((Object)"40322", (Object)"\u76f4\u8fde\u5355\u4f4d\u65e0\u8d44\u683c").put((Object)"40321", (Object)"\u4f7f\u7528\u5355\u4f4d\u65e0\u8d44\u683c").put((Object)"4055", (Object)"\u901a\u8fc7\u5e73\u53f0\u5e8f\u53f7\u672a\u67e5\u8be2\u5230\u6b64\u4f7f\u7528\u5355\u4f4d\u4fe1\u606f").put((Object)"4054", (Object)"\u901a\u8fc7\u5e73\u53f0\u5e8f\u53f7\u672a\u67e5\u8be2\u5230\u6b64\u76f4\u8fde\u5355\u4f4d\u4fe1\u606f").put((Object)"4047", (Object)"\u672a\u67e5\u8be2\u5230\u8be5\u5355\u4f4d\u7684\u6d4b\u8bd5\u6279\u6b21\u53f7").put((Object)"4049", (Object)"\u672a\u67e5\u8be2\u5230\u8be5\u80fd\u529b\u4e0e\u5bf9\u5e94\u670d\u52a1\u7684\u76f8\u5173\u4fe1\u606f").put((Object)"4032", (Object)"\u4f7f\u7528\u5355\u4f4d\u65e0\u6388\u6743\u670d\u52a1").put((Object)"4033", (Object)"\u4f7f\u7528\u5355\u4f4d\u672a\u6388\u6743\u6b64\u670d\u52a1").put((Object)"4057", (Object)"\u62a5\u6587\u89e3\u5bc6\u5931\u8d25").build();

    public LqptAbilityService(LqptRequest request, LqEpConfig config, String abilityId, String serviceId, String responClass) {
        this.request = request;
        this.abilityId = abilityId;
        this.serviceId = serviceId;
        this.lqEpConfig = config;
    }

    public static LqptAbilityService newInstance(LqptRequest request, LqEpConfig config) {
        if (StringUtils.isEmpty((CharSequence)request.getNsrsbh())) {
            throw new KDBizException(LqptErrorCode.CONNECT_NSRSBH_EMPTY, new Object[0]);
        }
        if (config == null || StringUtils.isBlank((CharSequence)config.getBaseUrl())) {
            throw new KDBizException(LqptErrorCode.CONNECT_LQCONFIG_EMPTY, new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)config.getLqSecret())) {
            throw new KDBizException(LqptErrorCode.CONNECT_SECRET_EMPTY, new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)config.getJrdwptbh())) {
            throw new KDBizException(LqptErrorCode.CONNECT_JRQY_EMPTY, new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)config.getSydwptbh())) {
            throw new KDBizException(LqptErrorCode.CONNECT_SYQY_EMPTY, new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)config.getLqSecret())) {
            throw new KDBizException(LqptErrorCode.CONNECT_SECRET_EMPTY, new Object[0]);
        }
        LqAbilityAnnotation ability = request.getClass().getAnnotation(LqAbilityAnnotation.class);
        if (ability == null) {
            throw new KDBizException(LqptErrorCode.CONNECT_ABILITY_EMPTY, new Object[0]);
        }
        String abilityid = ability.ability();
        if (StringUtils.isEmpty((CharSequence)abilityid)) {
            throw new KDBizException(LqptErrorCode.CONNECT_ABILITY_EMPTY, new Object[0]);
        }
        String serviceid = ability.service();
        if (StringUtils.isEmpty((CharSequence)serviceid)) {
            throw new KDBizException(LqptErrorCode.CONNECT_SERVICE_EMPTY, new Object[0]);
        }
        abilityid = StringUtils.isNotBlank((CharSequence)request.getAbilityId()) ? request.getAbilityId() : abilityid;
        Pair pair = (Pair)LQPT_OTHER.get((Object)abilityid);
        if (pair != null) {
            log.info("\u5f00\u59cb\u66ff\u6362\u8054\u7528\uff0c\u4ed6\u7528\u80fd\u529b\u7f16\u7801");
            if ("1".equals(config.getIssueChannel())) {
                abilityid = (String)pair.getValue();
            }
        }
        serviceid = StringUtils.isNotBlank((CharSequence)request.getServiceId()) ? request.getServiceId() : serviceid;
        String abilityClass = ability.className();
        if (!StringUtils.isEmpty((CharSequence)abilityClass)) {
            try {
                Class<?> cla = Class.forName(abilityClass);
                Constructor<?> cons = cla.getDeclaredConstructor(LqptRequest.class, LqEpConfig.class, String.class, String.class, String.class);
                return (LqptAbilityService)cons.newInstance(request, config, abilityid, serviceid, ability.response());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return new LqptAbilityService(request, config, abilityid, serviceid, ability.response());
    }

    public LqptResponse doBusiness(String body) {
        String url = this.getInterfaceUrl();
        try {
            String afterDecrypt;
            if (body == null) {
                body = this.getRequestContent();
            }
            LqptResponse responseObject = new LqptResponse();
            responseObject.setErrcode("0000");
            responseObject.setDescription(ResManager.loadKDString((String)"\u6210\u529f", (String)"LqptAbilityService_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
            String content = SM4Util.encryptEcb((String)this.lqEpConfig.getLqSecret(), (String)body);
            StringEntity httpEntity = new StringEntity(content, "UTF-8");
            HashMap<String, String> headers = new HashMap<String, String>(4);
            headers.put("Content-Type", "text/plain; charset=utf-8");
            headers.put("jrdwptbh", this.lqEpConfig.getJrdwptbh());
            headers.put("sydwptbh", this.lqEpConfig.getSydwptbh());
            Map lqptMap = ImcConfigUtil.getValue((String)"bdm_lqpt");
            if ("addNewheader".equals(lqptMap.get("headers"))) {
                headers.put("nlbm", this.abilityId);
                headers.put("fwbm", this.serviceId);
            }
            if (!StringUtils.isEmpty((CharSequence)this.lqEpConfig.getSxcsbz())) {
                headers.put("sxcsbz", this.lqEpConfig.getSxcsbz());
            }
            headers.put("redirectsEnabled", (String)lqptMap.get("redirectsEnabled"));
            if (log.isInfoEnabled()) {
                log.info(String.format("\u8bf7\u6c42header\u4e3a[%s]", JSONObject.toJSONString(headers)));
                log.info(String.format("\u8bf7\u6c42\u4e50\u4f01\u63a5\u5165\u5355\u4f4d\u5e73\u53f0\u7f16\u53f7[%s]\uff0c\u4f7f\u7528\u5355\u4f4d\u5e73\u53f0\u7f16\u53f7[%s]\uff0c\u6c99\u7bb1\u6d4b\u8bd5\u6807\u5fd7[%s]", this.lqEpConfig.getJrdwptbh(), this.lqEpConfig.getSydwptbh(), this.lqEpConfig.getSxcsbz()));
            }
            String result = "unittest".equals(this.lqEpConfig.getSxcsbz()) ? new LqptUnitTestService().doPost(this.lqEpConfig, this.abilityId, this.serviceId, headers, content) : HttpUtil.doPost((String)url, (String)this.lqEpConfig.getProxy(), headers, (HttpEntity)httpEntity, (int)this.lqEpConfig.getConnectTimeout(), (int)this.lqEpConfig.getSocketTimeout());
            responseObject.setRequestLq(true);
            this.responseStr = result;
            JSONObject resultJson = JSONObject.parseObject((String)result);
            String httpStatusCode = resultJson.getString("httpStatusCode");
            if (!"200".equals(httpStatusCode)) {
                responseObject.setErrcode("69" + httpStatusCode);
                responseObject.setDescription(resultJson.getString("body"));
                if (StringUtils.isNotBlank((CharSequence)httpStatusCode) && BUSNESS_FAIL_CODE.containsKey((Object)httpStatusCode)) {
                    responseObject.setBusinessFail(true);
                }
                return responseObject;
            }
            JSONObject responseBody = resultJson.getJSONObject("body");
            JSONObject Response = responseBody.getJSONObject("Response");
            JSONObject error = Response.getJSONObject("Error");
            if (error != null && !error.isEmpty()) {
                responseObject.setBusinessFail(true);
                responseObject.setErrcode("69" + error.getString("Code"));
                responseObject.setDescription(ResManager.loadKDString((String)"\u4e50\u4f01\u8fd4\u56de\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f[%s]", (String)"LqptAbilityService_1", (String)"imc-bdm-lqpt", (Object[])new Object[]{error.getString("Message")}));
                return responseObject;
            }
            String Data = Response.getString("Data");
            this.responseStr = afterDecrypt = SM4Util.decryptEcb((String)this.lqEpConfig.getLqSecret(), (String)Data);
            JSONObject dataJsonObject = JSONObject.parseObject((String)afterDecrypt);
            String returncode = dataJsonObject.getString("returncode");
            responseObject.setDescription(dataJsonObject.getString("returnmsg"));
            if ("00".equals(returncode)) {
                responseObject.setErrcode("0000");
            } else {
                responseObject.setBusinessFail(true);
                responseObject.setErrcode("69" + returncode);
            }
            responseObject.setData(this.parseResult(dataJsonObject));
            return responseObject;
        }
        catch (MsgException e) {
            LqptResponse res = this.getLqptResponse(e.getCause(), url);
            if (res != null) {
                return res;
            }
            return new LqptResponse(LqptErrorCode.SEND_ERROR, false);
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42\u4e50\u4f01\u9519\u8bef", (Object)e);
            return new LqptResponse(LqptErrorCode.SEND_ERROR, false);
        }
    }

    private LqptResponse getLqptResponse(Throwable throwable, String url) {
        if (throwable instanceof ConnectTimeoutException) {
            log.info("\u8fde\u63a5\u8d85\u65f6{}", (Object)url);
            return new LqptResponse(LqptErrorCode.SOCKET_TIMEOUT, true);
        }
        if (throwable instanceof SocketTimeoutException) {
            log.info("\u5904\u7406\u8d85\u65f6{}", (Object)url);
            return new LqptResponse(LqptErrorCode.CONNECT_TIMEOUT, true);
        }
        if (throwable instanceof ClientProtocolException) {
            log.info("\u534f\u8bae\u9519\u8bef{}", (Object)url);
            return new LqptResponse(LqptErrorCode.PROTOCOL_ERROR, true);
        }
        return null;
    }

    public String getRequestContent() {
        return SerializationUtils.toJsonString((Object)this.request);
    }

    protected Object parseResult(JSONObject data) {
        log.info("LqAbilitySerivce parseResult:{}", (Object)data);
        Class<?> resClass = this.getResponseClass();
        if (resClass != null) {
            String dataField;
            LqAbilityAnnotation ability = resClass.getAnnotation(LqAbilityAnnotation.class);
            if (ability != null && !StringUtils.isEmpty((CharSequence)(dataField = ability.dataField()))) {
                Object resultData = data.get((Object)dataField);
                if (resultData instanceof JSONObject) {
                    return ((JSONObject)resultData).toJavaObject(resClass);
                }
                if (resultData instanceof JSONArray) {
                    JSONArray array = (JSONArray)resultData;
                    ArrayList<Object> list = new ArrayList<Object>(array.size());
                    for (int i = 0; i < array.size(); ++i) {
                        list.add(array.getJSONObject(i).toJavaObject(resClass));
                    }
                    return list;
                }
            }
            return data.toJavaObject(resClass);
        }
        return null;
    }

    protected String getInterfaceUrl() {
        String baseUrl = this.lqEpConfig.getBaseUrl();
        while (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl + '/' + this.abilityId + '/' + this.serviceId;
    }

    protected Class<?> getResponseClass() {
        String className = this.responClass;
        if (StringUtils.isEmpty((CharSequence)this.responClass)) {
            className = this.request.getClass().getName().replace(".request.", ".response.").replace("Request", "Response");
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.info("\u54cd\u5e94\u5b9e\u4f53\u7c7b\u4e0d\u5b58\u5728{}", (Object)className);
            return null;
        }
    }

    public void saveLog(LqptRequest request, LqptResponse response, long takeTime) {
        try {
            RequestContext context = RequestContext.get();
            ThreadPoolsHelper.addLqptLogThreadPool.execute(() -> {
                DynamicObject logObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_lqpt_log");
                logObject.set("tax_no", (Object)request.getNsrsbh());
                logObject.set("org", TaxUtils.getOrgDynamicObjectByTaxNo((String)request.getNsrsbh()).getPkValue());
                LqAbilityAnnotation ability = request.getClass().getAnnotation(LqAbilityAnnotation.class);
                if (ability == null) {
                    logObject.set("service", (Object)(this.abilityId + this.serviceId));
                } else {
                    logObject.set("service", (Object)(ability.ability() + this.serviceId));
                }
                logObject.set("traceid", (Object)context.getTraceId());
                logObject.set("create_time", (Object)new Date());
                logObject.set("error_code", (Object)StringUtils.substring((String)response.getErrcode(), (int)0, (int)19));
                logObject.set("req_keyword", (Object)StringUtils.substring((String)request.GETReqKeyword(), (int)0, (int)49));
                logObject.set("error_msg", (Object)response.getDescription());
                logObject.set("request_tag", (Object)SerializationUtils.toJsonString((Object)request));
                logObject.set("response_tag", (Object)this.responseStr);
                logObject.set("creater", (Object)context.getUserId());
                logObject.set("take_time", (Object)takeTime);
                ImcSaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObject});
            });
        }
        catch (Exception e) {
            log.info("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25" + e.getMessage());
        }
    }

    public String getAbilityId() {
        return this.abilityId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getResponseStr() {
        return this.responseStr;
    }

    public LqEpConfig getLqEpConfig() {
        return this.lqEpConfig;
    }
}

