/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service.deduct;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imc.bdm.lqpt.constant.LqptErrorCode;
import kd.imc.bdm.lqpt.enums.DeductApiRequestEnum;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.collect.InvoiceXmlDownloadBatchRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.bdm.lqpt.utils.CommonUtil;
import kd.imc.bdm.lqpt.utils.RequestValidateUtil;

public class DeductApiService {
    private static final Log LOGGER = LogFactory.getLog(DeductApiService.class);

    public JSONObject send(JSONObject param) {
        LOGGER.info("DeductApiService send param\uff1a{}", (Object)param);
        if (param.isEmpty()) {
            throw new KDBizException(LqptErrorCode.PARAM_EMPTY, new Object[0]);
        }
        if (StringUtils.isEmpty((String)param.getString("gfsbh"))) {
            param.put("gfsbh", (Object)param.getString("nsrsbh"));
        }
        if (StringUtils.isEmpty((String)param.getString("nsrsbh"))) {
            param.put("nsrsbh", (Object)param.getString("gfsbh"));
        }
        String apiType = param.getString("api_type");
        String paramStr = JSONObject.toJSONString((Object)param);
        Class clazz = null;
        try {
            clazz = DeductApiRequestEnum.getClazzByType(apiType);
        }
        catch (Exception e) {
            LOGGER.info("DeductApiService Class Exception\uff1a{}", (Object)e);
        }
        LqptResponse response = null;
        if (clazz != null) {
            LqptRequest request = (LqptRequest)JSON.parseObject((String)paramStr, (Class)clazz);
            for (Map.Entry entry : param.entrySet()) {
                String key = (String)entry.getKey();
                if (!(entry.getValue() instanceof JSONArray)) continue;
                try {
                    JSONArray array = (JSONArray)entry.getValue();
                    Method method = clazz.getMethod("set" + CommonUtil.toUpperFirstOne((String)key), List.class);
                    List objects = JSONObject.parseArray((String)array.toJSONString(), JSONObject.class);
                    method.invoke(clazz.newInstance(), objects);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOGGER.info("DeductApiService Exception: {}", (Object)e);
                }
            }
            if (!RequestValidateUtil.checkRequestParam((LqptRequest)request)) {
                throw new KDBizException(LqptErrorCode.PARAM_EMPTY, new Object[0]);
            }
            LqptService service = new LqptService();
            response = service.send(request);
            LOGGER.info("DeductApiService send response\uff1a{}", JSON.toJSON((Object)response));
        }
        return JSON.parseObject((String)JSON.toJSONString(response));
    }

    public JSONObject downXmlFile(JSONObject param) {
        if (param.isEmpty()) {
            throw new KDBizException(LqptErrorCode.PARAM_EMPTY, new Object[0]);
        }
        String apiType = param.getString("api_type");
        if ("FPWJSQXZ".equals(apiType)) {
            return this.applyDownloadXml(param);
        }
        JSONObject result = new JSONObject();
        result.put("errcode", (Object)"0002");
        result.put("description", (Object)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684apiType", (String)"DeductApiService_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        return result;
    }

    private JSONObject applyDownloadXml(JSONObject param) {
        try {
            InvoiceXmlDownloadBatchRequest request = (InvoiceXmlDownloadBatchRequest)JSON.parseObject((String)JSONObject.toJSONString((Object)param), InvoiceXmlDownloadBatchRequest.class);
            List list = request.getReqInvoices();
            if (list != null) {
                LqptService service = new LqptService();
                JSONArray array = new JSONArray(list);
                LqptResponse response = service.send((LqptRequest)request, array.toJSONString());
                LOGGER.info("DeductApiService applyDownloadXml response\uff1a{}", JSON.toJSON((Object)response));
                return JSON.parseObject((String)JSON.toJSONString((Object)response));
            }
        }
        catch (Exception e) {
            LOGGER.info("DeductApiService applyDownloadXml Exception\uff1a{}", (Object)e);
        }
        return null;
    }
}

