/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.unittest;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.lqpt.model.LqEpConfig;
import kd.imc.bdm.lqpt.utils.SM4Util;

public class LqptUnitTestService {
    public String doPost(LqEpConfig lqEpConfig, String abilityId, String serviceId, Map<String, String> headers, String content) {
        try {
            String cache = this.getRespenseFormCache(lqEpConfig, abilityId, serviceId, content);
            if (StringUtils.isNotEmpty((CharSequence)cache)) {
                return cache;
            }
            Class<?> clazz = Class.forName("kd.imc.bdm.lqpttest.LqptUnitTestService");
            Method[] methods = clazz.getMethods();
            Method classMethod = null;
            for (Method meth : methods) {
                if (!meth.getName().equals("doPost")) continue;
                classMethod = meth;
                break;
            }
            if (classMethod != null) {
                String result = (String)classMethod.invoke(clazz.newInstance(), lqEpConfig, abilityId, serviceId, headers, content);
                return result;
            }
            return "";
        }
        catch (Exception e) {
            throw new MsgException("U0001", ResManager.loadKDString((String)"\u89e3\u5bc6\u5931\u8d25", (String)"LqptUnitTestService_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
    }

    public String getRespenseFormCache(LqEpConfig lqEpConfig, String abilityId, String serviceId, String content) {
        try {
            String cache = CacheHelper.get((String)("Lq-" + serviceId));
            if (StringUtils.isNotEmpty((CharSequence)cache)) {
                String afterDecrypt = SM4Util.decryptEcb((String)lqEpConfig.getLqSecret(), (String)content);
                JSONObject responseJson = JSONObject.parseObject((String)cache);
                String lsh = UUID.randomUUID();
                responseJson.put("lsh", (Object)lsh);
                responseJson.put("pclsh", (Object)lsh);
                if (responseJson.getString("returncode") == null) {
                    responseJson.put("returncode", (Object)"00");
                    responseJson.put("returnmsg", (Object)"\u6210\u529f");
                }
                String afterEncrypt = SM4Util.encryptEcb((String)lqEpConfig.getLqSecret(), (String)responseJson.toJSONString());
                JSONObject json = new JSONObject();
                json.put("httpStatusCode", (Object)"200");
                JSONObject body = new JSONObject();
                JSONObject Response = new JSONObject();
                Response.put("Data", (Object)afterEncrypt);
                body.put("Response", (Object)Response);
                json.put("body", (Object)body);
                return json.toJSONString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

