/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.ai;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.ViewUtil;
import org.apache.commons.lang3.StringUtils;

public class ImcAiCustomerServicePlugin
extends AbstractFormPlugin {
    private static final String CUSTOMEVENTNAME = "aicustomcontrolap";

    public void afterBindData(EventObject e) {
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, this.getAiCustomerServiceData(), (String)CUSTOMEVENTNAME);
    }

    private Map<String, Object> getAiCustomerServiceData() {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        try {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)formShowParameter.getAppId());
            param.put("appName", appInfo.getName().getLocaleValue());
            String caption = formShowParameter.getCaption();
            if (StringUtils.isBlank((CharSequence)caption)) {
                caption = formShowParameter.getFormConfig().getCaption().getLocaleValue();
            }
            param.put("caption", caption);
        }
        catch (Exception formShowParameter) {
            // empty catch block
        }
        QFilter qFilter = new QFilter("authstate", "=", (Object)"1").and("servergroup", "in", (Object)new String[]{PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo(), PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo()});
        DynamicObject permisson = QueryServiceHelper.queryOne((String)"bdm_invoice_permission", (String)String.join((CharSequence)",", "epinfo.number", "epinfo.name"), (QFilter[])qFilter.toArray());
        if (permisson != null) {
            param.put("taxNo", permisson.getString("epinfo.number"));
            param.put("companyName", permisson.getString("epinfo.name"));
        }
        Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(RequestContext.get().getUserId()));
        param.put("name", userInfo.get("name"));
        param.put("phone", userInfo.get("phone"));
        param.put("email", userInfo.get("email"));
        param.put("language", RequestContext.get().getLang().getLangTag());
        param.put("errCode", "0000");
        param.put("eventKey", "init");
        Map fpyCallbackConfig = ImcConfigUtil.getValue((String)"fpyiv_conifg");
        if (fpyCallbackConfig == null || fpyCallbackConfig.size() == 0) {
            param.put("version", "CONSTELLATION");
        } else {
            param.put("version", "KDGALAXY");
        }
        param.put("env", ImcConfigUtil.getValue((String)"aiCustomService", (String)"env"));
        String sidebar = ImcConfigUtil.getValue((String)"sidebar", (String)"sidebar_open_mode");
        param.put("sidebar", StringUtils.isEmpty((CharSequence)sidebar) ? "0" : sidebar);
        return param;
    }
}

