/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.alleinvoice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.AwsFpyConstant;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.AES128;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class EInvoiceAccountEditPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(EInvoiceAccountEditPlugin.class);
    private static final ImmutableMap<String, String> QUERYROLE_2_APPLAYROLE = new ImmutableMap.Builder().put((Object)"1", (Object)"09").put((Object)"2", (Object)"03").put((Object)"3", (Object)"02").put((Object)"4", (Object)"01").put((Object)"5", (Object)"05").put((Object)"6", (Object)"07").put((Object)"7", (Object)"08").put((Object)"8", (Object)"10").put((Object)"9", (Object)"11").put((Object)"10", (Object)"12").build();

    public void afterCreateNewData(EventObject e) {
        String itemStr;
        DynamicObject city;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        model.setValue("name", customParams.get("name"));
        model.setValue("taxno", customParams.get("taxno"));
        String cityName = (String)customParams.get("cityname");
        if (StringUtils.isNotBlank((String)cityName) && (city = QueryServiceHelper.queryOne((String)"bdm_tax_city_info", (String)"id", (QFilter[])new QFilter("name", "=", (Object)cityName).toArray())) != null) {
            model.setValue("cityname", city.get("id"));
        }
        if ((itemStr = (String)customParams.get("item")) != null) {
            Map item = (Map)SerializationUtils.fromJsonString((String)itemStr, Map.class);
            model.setValue("channeltype", item.get("channeltype"));
            model.setValue("account", item.get("account"));
            model.setValue("isdefault", item.get("isdefault"));
            model.setValue("defaultbusiness", item.get("defaultbusiness"));
            List userList = (List)item.get("user");
            if (CollectionUtils.isNotEmpty((Collection)userList)) {
                ArrayList ids = new ArrayList(userList.size());
                for (Map userMap : userList) {
                    Map basedataIdMap = (Map)userMap.get("fbasedataid");
                    if (basedataIdMap == null || !basedataIdMap.containsKey("id")) continue;
                    ids.add(basedataIdMap.get("id"));
                }
                model.setValue("user", (Object)ids.toArray());
            }
            this.queryAccountFromRpa((String)customParams.get("taxno"), item);
            IFormView view = this.getView();
            view.setEnable(Boolean.FALSE, new String[]{"account"});
        }
    }

    private void queryAccountFromRpa(String taxNo, Map<String, Object> item) {
        try {
            JSONObject data;
            AwsFpyService awsFpyService = AwsFpyService.newInstance();
            String sb = awsFpyService.getBaseUrl() + AwsFpyConstant.getUrl((String)"query_e_invoice_account") + "?loginAccountUid=" + item.get("account") + "&taxNo=" + taxNo + "&reqid=" + RequestContext.get().getTraceId() + "&access_token=" + AllEleServiceHelper.getAwsAccessToken((String)taxNo);
            JSONObject jsonObject = awsFpyService.getAppJson(sb, new HashMap(1));
            LOGGER.info("\u67e5\u8be2\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u4fe1\u606f\uff1a" + jsonObject.toJSONString());
            if (ErrorType.SUCCESS.getCode().equals(jsonObject.getString("errcode")) && (data = jsonObject.getJSONObject("data")) != null && !data.isEmpty()) {
                IDataModel model = this.getModel();
                if (StringUtils.isNotBlank((String)data.getString("etaxRoleType"))) {
                    model.setValue("etaxroletype", QUERYROLE_2_APPLAYROLE.get((Object)data.getString("etaxRoleType")));
                }
                model.setValue("logintypes", (Object)data.getString("loginType"));
                model.setValue("appkey", (Object)data.getString("appKey"));
                model.setValue("appsecret", (Object)data.getString("appSecret"));
                String etaxAccount = AES128.ECBDecrypt((String)data.getString("etaxAccount"), (String)AllEleServiceHelper.getAwsConfig((String)taxNo).getEncryptKey());
                LOGGER.info("\u67e5\u8be2\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u4fe1\u606f\uff1a" + etaxAccount);
                JSONObject etaxAccountJson = JSON.parseObject((String)etaxAccount);
                model.setValue("password", (Object)etaxAccountJson.getString("accountPasswd"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Map customParams;
        String itemStr;
        FormOperate operate = (FormOperate)args.getSource();
        if ("save".equals(operate.getOperateKey()) && (itemStr = (String)(customParams = this.getView().getFormShowParameter().getCustomParams()).get("item")) == null) {
            QFilter qFilter;
            IDataModel model = this.getModel();
            String account = (String)model.getValue("account");
            String taxNo = (String)model.getValue("taxno");
            if (StringUtils.isNotBlank((String)account) && QueryServiceHelper.exists((String)"bdm_einvoice_account", (QFilter[])(qFilter = new QFilter("taxno", "=", (Object)taxNo).and("entryentity.account", "=", (Object)account)).toArray())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%1$s]\uff0c\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7:[%2$s]\u5df2\u5b58\u5728\u3002", (String)"EInvoiceAccountEditPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]), taxNo, account));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult().isSuccess() && "save".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        }
    }
}

