/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.custommail;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.table.MailSettingConstant;
import kd.imc.bdm.common.helper.MailSettingHelper;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.formplugin.custommail.MailSettingPluginHelper;

public class MailBaseSettingFormPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String number = this.getModel().getValue("number").toString();
        if (StringUtils.isEmpty((CharSequence)number)) {
            this.getModel().setValue("number", (Object)String.format("YXSZ%s", MailSettingPluginHelper.getID()));
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
        List<String> fieldKeys = this.getFieldKeys();
        SchemeHelper.initializeFilterGrid((FilterGrid)filterGrid, fieldKeys, (String)"sim_vatinvoice");
    }

    private List<String> getFieldKeys() {
        ArrayList list = Lists.newArrayList();
        list.add("salername");
        list.add("buyername");
        list.add("issuetype");
        try {
            ViewUtil.putFieldKeys((List)list, (String)ImcConfigUtil.getValue((String)"mail_filter_config", (String)"ext_fields"), (String)"sim_vatinvoice");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ViewUtil.beforeSaveFilterTag((IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain", "advcontoolbarap1", "advcontoolbarap2"});
        this.addClickListeners(new String[]{"choosefield"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String sendInvoiceOption;
        if ("sendinvoiceoption".equals(e.getProperty().getName()) && "0".equals(sendInvoiceOption = this.getModel().getValue("sendinvoiceoption").toString())) {
            this.getModel().setValue("mailtempoption", (Object)"0");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "btn_testing": {
                MailSettingPluginHelper.testing(this);
                break;
            }
            case "btn_show": {
                this.showTemplate();
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("bar_save".equals(key)) {
            RichTextEditor editor = (RichTextEditor)this.getView().getControl("mailbodyedit");
            RichTextEditor multiEditor = (RichTextEditor)this.getView().getControl("multimailbodyedit");
            this.getModel().setValue("mailbody_tag", (Object)editor.getText());
            this.getModel().setValue("multimailbody_tag", (Object)multiEditor.getText());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("choosefield".equals(control.getKey())) {
            this.openFieldConfigPage();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if ("bdm_customs_field_config".equals(actionId) && event.getReturnData() != null) {
            String returnData = (String)event.getReturnData();
            this.getModel().setValue("multifields", (Object)returnData);
            if (StringUtils.isNotBlank((CharSequence)returnData)) {
                Label label = (Label)this.getControl("labelap1");
                String tip = MailSettingPluginHelper.getMultiFieldsTip(returnData, MailSettingHelper.getSelectMap());
                label.setText(tip);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("number", (Object)String.format("YXSZ%s", MailSettingPluginHelper.getID()));
        this.getModel().setValue("epinfos", (Object)"DONE");
        MailSettingPluginHelper.editorAutoFill(this, "bdm_mail", "YZYXSZ01_s");
        String tipMsg = ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0_\u4ef7\u7a0e\u5408\u8ba1_\u53d1\u7968\u4ee3\u7801_\u53d1\u7968\u53f7\u7801_\u5f00\u7968\u65f6\u95f4", (String)"MailBaseSettingFormPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        Label labelAp1 = (Label)this.getControl("labelap1");
        labelAp1.setText(tipMsg);
    }

    public void afterBindData(EventObject e) {
        RichTextEditor editor = (RichTextEditor)this.getView().getControl("mailbodyedit");
        RichTextEditor multiEditor = (RichTextEditor)this.getView().getControl("multimailbodyedit");
        String mailBody = this.getModel().getValue("mailbody_tag").toString();
        String multiMailBody = this.getModel().getValue("multimailbody_tag").toString();
        if (StringUtils.isBlank((CharSequence)mailBody)) {
            QFilter filter = new QFilter("number", "=", (Object)"YXSZ000001");
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bdm_mail", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_mail", (boolean)true), (QFilter[])new QFilter[]{filter});
            if (obj != null) {
                mailBody = obj.getString("mailbody_tag");
                multiMailBody = obj.getString("multimailbody_tag");
            }
        }
        editor.setText(mailBody);
        multiEditor.setText(multiMailBody);
        String fields = this.getModel().getValue("multifields").toString();
        if (StringUtils.isBlank((CharSequence)fields)) {
            fields = String.join((CharSequence)",", "buyername", "totalamount", "invoicecode", "invoiceno", "issuetime");
            this.getModel().setValue("multifields", (Object)fields);
        }
        ((Label)this.getControl("labelap1")).setText(MailSettingPluginHelper.getMultiFieldsTip(fields, MailSettingHelper.getSelectMap()));
        ViewUtil.setFilterGrid((IFormView)this.getView());
        this.getModel().setDataChanged(false);
    }

    private void showTemplate() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        RichTextEditor editor = (RichTextEditor)this.getView().getControl("mailbodyedit");
        map.put("mailtitle", MailSettingHelper.replacePlaceholder((String)String.valueOf(this.getModel().getValue("mailtitle"))));
        String mailTempType = this.getModel().getValue("mailtempoption") + "";
        if (MailSettingConstant.MailTempOption.CUSTOM_STYLE.getValue().equals(mailTempType)) {
            map.put("mailbody", MailSettingHelper.getShowTemplate((String)editor.getText()));
        }
        map.put("pagetype", "invoice");
        ViewUtil.openDialog((AbstractFormPlugin)this, map, (String)"bdm_mail_show", (String)"mailShowCallBack");
    }

    private void openFieldConfigPage() {
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("formkey", "sim_vatinvoice");
        customParam.put("selectFields", this.getModel().getValue("multifields"));
        customParam.put("configId", "");
        String tipMsg = ResManager.loadKDString((String)"\u53d1\u7968\u5b57\u6bb5\u9009\u62e9", (String)"MailBaseSettingFormPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)tipMsg, customParam, (String)"bdm_customs_field_config", (String)"bdm_customs_field_config");
    }
}

