/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.customsms;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.SmsSettingConstant;

public class SmsSettingPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(SmsSettingPlugin.class);
    private static final String TBMAIN = "tbmain";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TBMAIN});
    }

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
        filterGrid.setEntityNumber("sim_vatinvoice");
        this.setVisible();
    }

    public void afterBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
        FilterCondition filterCondition = null;
        String s = this.getModel().getDataEntity().getString("filtertag");
        if (StringUtils.isNotBlank((CharSequence)s)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)s, FilterCondition.class);
        }
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        this.getModel().setValue("filtertag", (Object)SerializationUtils.toJsonString((Object)filterCondition));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("save".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_edit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"submit_audit"});
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("submit_audit".equals(evt.getItemKey())) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7531\u4e8e\u8fd0\u8425\u5546\u653f\u7b56\u539f\u56e0\uff0c\u91d1\u8776\u53d1\u7968\u4e91\u4e0d\u518d\u63d0\u4f9b\u81ea\u5b9a\u4e49\u77ed\u4fe1\u7b7e\u540d\u529f\u80fd\uff0c\u4e14\u5df2\u63d0\u4ea4\u5ba1\u6279\u4f46\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\u4e0d\u518d\u5ba1\u6279\u3002%s\u4e3a\u60a8\u9020\u6210\u56f0\u6270\uff0c\u656c\u8bf7\u8c05\u89e3\uff0c\u611f\u8c22\u60a8\u7684\u4f7f\u7528\u3002", (String)"SmsSettingListPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]), System.lineSeparator()));
        }
    }

    private void setVisible() {
        long id = this.getModel().getDataEntity().getLong("id");
        if (0L != id) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setStatus(OperationStatus.VIEW);
            String billStatus = this.getModel().getDataEntity().getString("billstatus");
            if (!SmsSettingConstant.BILL_STATUS_CAN_SUBMIT.contains(billStatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_edit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"submit_audit"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_edit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"submit_audit"});
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }
}

