/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.invoicepermission;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.ImcLicenseServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.ThreadPoolsHelper;
import kd.imc.bdm.common.service.CAService;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InputPermissionUtils;
import kd.imc.bdm.common.util.ViewUtil;

public class InvoicePermissionListPlugin
extends AbstractTreeListPlugin {
    private Log LOGGER = LogFactory.getLog(InvoicePermissionListPlugin.class);
    private static final String CURRENT_NODE = "current_node";

    public void setFilter(SetFilterEvent e) {
        String currentNode = this.getPageCache().get(CURRENT_NODE);
        if (StringUtils.isNotBlank((CharSequence)currentNode) && !"-1".equals(currentNode)) {
            if ("2".equals(currentNode)) {
                e.setMainOrgQFilter(new QFilter("orginfo", "=", (Object)0));
            }
            QFilter qFilter = new QFilter("servergroup", "=", (Object)currentNode);
            e.getCustomQFilters().add(qFilter);
            this.getTreeListView().getTreeModel().getRoot().getChildren().stream().filter(node -> node.getId().equals(currentNode)).findFirst().ifPresent(node -> this.getTreeListView().getTreeView().focusNode(node));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "authorize": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_PERMISSION_AUTH);
                this.executeAutorize();
                break;
            }
            case "btn_refresh": {
                this.refreshList();
                break;
            }
            case "btn_select": {
                ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bdm_enterprise_baseinfo", (boolean)true);
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectEp"));
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "synccancelpermission": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BDM_SYNC_CANCEL_AUTH);
                this.executeSyncCancelPermission();
                break;
            }
            case "cancelpermission": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BDM_CANCEL_AUTH);
                this.executeCancelPermission(evt);
                break;
            }
            case "fillproductnumber": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BDM_MAINTAIN_PRODUCT_NUMBER);
                ViewUtil.openDialog((AbstractFormPlugin)this, null, null, (String)"bdm_fill_product_number", (String)"fill_product_number_fillproductnumber");
                break;
            }
            case "syncpermission": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BDM_SYNC_AUTH);
                this.executeSyncPermission();
            }
        }
    }

    private void executeSyncCancelPermission() {
        this.checkSyncCancelPermission();
        if (this.isNeedConfigProductNumber("fill_product_number_SyncCancelPermission")) {
            return;
        }
        this.executeSync("1");
        this.refreshList();
    }

    private void executeSync(String businessType) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_invoice_permission"));
        String errorMsg = ImcLicenseServiceHelper.syncPermssion2Aws((DynamicObject[])objs, (String)businessType);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.getView().showErrorNotification(errorMsg);
        } else {
            String tip = ResManager.loadKDString((String)"\u540c\u6b65\u8bb8\u53ef\u6388\u6743\u6210\u529f\u3002", (String)"InvoicePermissionListPlugin_30", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            if ("1".equals(businessType)) {
                tip = ResManager.loadKDString((String)"\u540c\u6b65\u53d6\u6d88\u6388\u6743\u6210\u529f\u3002", (String)"InvoicePermissionListPlugin_31", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            }
            this.getView().showSuccessNotification(tip);
        }
    }

    private void checkSyncCancelPermission() {
        String currentNode = this.getPageCache().get(CURRENT_NODE);
        if (StringUtils.isBlank((CharSequence)currentNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u540c\u6b65\u53d6\u6d88\u6388\u6743\u7684\u670d\u52a1", (String)"InvoicePermissionListPlugin_12", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (!PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(currentNode) && !PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(currentNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u670d\u52a1\u6682\u4e0d\u652f\u6301\u540c\u6b65\u53d6\u6d88\u6388\u6743", (String)"InvoicePermissionListPlugin_13", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u540c\u6b65\u53d6\u6d88\u6388\u6743\u7684\u8bb0\u5f55!", (String)"InvoicePermissionListPlugin_14", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_invoice_permission"));
        String serverGroup = objs[0].getString("servergroup");
        for (DynamicObject obj : objs) {
            if ("1".equals(obj.getString("authstate"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u5df2\u6388\u6743\uff0c\u4e0d\u53ef\u8fdb\u884c\u540c\u6b65\u53d6\u6d88\u6388\u6743\u64cd\u4f5c!", (String)"InvoicePermissionListPlugin_15", (String)"imc-bdm-formplugin", (Object[])new Object[0]), obj.getDynamicObject("epinfo").getString("number")));
            }
            if (null == obj.getDate("cancelpermissiontime")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u672a\u53d6\u6d88\u6388\u6743\uff0c\u4e0d\u53ef\u8fdb\u884c\u540c\u6b65\u53d6\u6d88\u6388\u6743\u64cd\u4f5c!", (String)"InvoicePermissionListPlugin_16", (String)"imc-bdm-formplugin", (Object[])new Object[0]), obj.getDynamicObject("epinfo").getString("number")));
            }
            if (serverGroup.equals(obj.getString("servergroup"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u670d\u52a1\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u53ef\u8fdb\u884c\u540c\u6b65\u53d6\u6d88\u6388\u6743\u64cd\u4f5c!", (String)"InvoicePermissionListPlugin_17", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void executeSyncPermission() {
        this.checkSyncPermission();
        if (this.isNeedConfigProductNumber("fill_product_number_syncpermission")) {
            return;
        }
        this.executeSync("0");
        this.refreshList();
    }

    private void checkSyncPermission() {
        String currentNode = this.getPageCache().get(CURRENT_NODE);
        if (StringUtils.isBlank((CharSequence)currentNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u540c\u6b65\u6388\u6743\u7684\u670d\u52a1", (String)"InvoicePermissionListPlugin_21", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (!PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(currentNode) && !PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(currentNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u670d\u52a1\u6682\u4e0d\u652f\u6301\u540c\u6b65\u6388\u6743", (String)"InvoicePermissionListPlugin_22", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u540c\u6b65\u6388\u6743\u7684\u8bb0\u5f55!", (String)"InvoicePermissionListPlugin_23", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_invoice_permission"));
        String serverGroup = objs[0].getString("servergroup");
        for (DynamicObject obj : objs) {
            if (!"1".equals(obj.getString("authstate"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u975e\u5df2\u6388\u6743\uff0c\u4e0d\u53ef\u8fdb\u884c\u540c\u6b65\u6388\u6743\u64cd\u4f5c!", (String)"InvoicePermissionListPlugin_24", (String)"imc-bdm-formplugin", (Object[])new Object[0]), obj.getDynamicObject("epinfo").getString("number")));
            }
            if (serverGroup.equals(obj.getString("servergroup"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u670d\u52a1\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u53ef\u8fdb\u884c\u540c\u6b65\u6388\u6743\u64cd\u4f5c!", (String)"InvoicePermissionListPlugin_25", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void executeCancelPermission(ItemClickEvent evt) {
        this.checkCancelData();
        if (this.isNeedConfigProductNumber("fill_product_number_cancelpermission")) {
            return;
        }
        ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d6\u6d88\u6388\u6743\u540e60\u5929\u5185\u4e0d\u5141\u8bb8\u91cd\u65b0\u6388\u6743\uff0c\u5728\u6b64\u671f\u95f4\u8be5\u7a0e\u53f7\u5c06\u65e0\u6cd5\u8fdb\u884c\u5f00\u7968/\u6536\u7968\u4e1a\u52a1\uff0c\u786e\u8ba4\u662f\u5426\u53d6\u6d88\uff1f", (String)"InvoicePermissionListPlugin_27", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (String)"cancelpermission");
    }

    private void executeAutorize() {
        try {
            this.checkAuthData();
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        if (this.isNeedConfigProductNumber("fill_product_number_authorize")) {
            return;
        }
        ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u7a0e\u53f7\u4fe1\u606f\u7684\u51c6\u786e\u6027, \u786e\u5b9a\u8981\u6388\u6743\u5417\uff1f", (String)"InvoicePermissionListPlugin_28", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (String)"authorize");
    }

    private boolean isNeedConfigProductNumber(String callBackKey) {
        String currentNode = this.getPageCache().get(CURRENT_NODE);
        boolean issueService = PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(currentNode);
        boolean collectService = PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(currentNode);
        if ((issueService || collectService) && ImcLicenseServiceHelper.isShowPop((boolean)issueService)) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("permissionType", currentNode);
            ViewUtil.openDialog((AbstractFormPlugin)this, null, param, (String)"bdm_fill_product_number", (String)callBackKey);
            return true;
        }
        return false;
    }

    private void checkCancelData() {
        String currentNode = this.getPageCache().get(CURRENT_NODE);
        if (StringUtils.isBlank((CharSequence)currentNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d6\u6d88\u6388\u6743\u7684\u670d\u52a1", (String)"InvoicePermissionListPlugin_9", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (!PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(currentNode) && !PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(currentNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u670d\u52a1\u6682\u4e0d\u652f\u6301\u53d6\u6d88\u6388\u6743", (String)"InvoicePermissionListPlugin_10", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d6\u6d88\u6388\u6743\u7684\u8bb0\u5f55!", (String)"InvoicePermissionListPlugin_11", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_invoice_permission"));
        String serverGroup = objs[0].getString("servergroup");
        for (DynamicObject obj : objs) {
            if ("0".equals(obj.getString("authstate"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u5f53\u524d\u672a\u6388\u6743\uff0c\u4e0d\u53ef\u8fdb\u884c\u53d6\u6d88\u6388\u6743\u64cd\u4f5c!", (String)"InvoicePermissionListPlugin_29", (String)"imc-bdm-formplugin", (Object[])new Object[0]), obj.getDynamicObject("epinfo").getString("number")));
            }
            if (!serverGroup.equals(obj.getString("servergroup"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u670d\u52a1\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u53ef\u8fdb\u884c\u53d6\u6d88\u6388\u6743\u64cd\u4f5c!", (String)"InvoicePermissionListPlugin_19", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            if (null == obj.getDate("cancelpermissiontime")) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u5df2\u53d6\u6d88\u8fc7\u6388\u6743\uff0c\u4e0d\u53ef\u8fdb\u884c\u53d6\u6d88\u6388\u6743\u64cd\u4f5c!", (String)"InvoicePermissionListPlugin_20", (String)"imc-bdm-formplugin", (Object[])new Object[0]), obj.getDynamicObject("epinfo").getString("number")));
        }
    }

    private void refreshList() {
        this.loadTree();
        IListView view = (IListView)this.getView();
        view.clearSelection();
        view.refresh();
    }

    private void checkAuthData() {
        String currentNode = this.getPageCache().get(CURRENT_NODE);
        if (StringUtils.isBlank((CharSequence)currentNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6388\u6743\u7684\u670d\u52a1", (String)"InvoicePermissionListPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (!PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(currentNode) && !PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(currentNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u670d\u52a1\u6682\u4e0d\u652f\u6301\u6388\u6743", (String)"InvoicePermissionListPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6388\u6743\u7684\u8bb0\u5f55!", (String)"InvoicePermissionListPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_invoice_permission"));
        String batchType = objs[0].getString("equipmenttype");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -60);
        Date threeMonthAgo = calendar.getTime();
        for (DynamicObject obj : objs) {
            if ("1".equals(obj.get("authstate"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u4e2d\u7684\u6570\u636e\u6388\u6743\u72b6\u6001\u5305\u542b\u5df2\u6388\u6743\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u6b21\u8fdb\u884c\u6388\u6743\uff01", (String)"InvoicePermissionListPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            if (!batchType.equals(obj.getString("equipmenttype"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u4e2d\u7684\u6570\u636e\u8bbe\u5907\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u6279\u91cf\u8fdb\u884c\u6388\u6743\uff01", (String)"InvoicePermissionListPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            Date cancelPermissionTime = obj.getDate("cancelpermissiontime");
            DynamicObject epInfo = obj.getDynamicObject("epinfo");
            String taxNo = epInfo.getString("number");
            if (null == cancelPermissionTime || DateUtils.timeDifference((Date)cancelPermissionTime, (Date)threeMonthAgo) >= 0L) continue;
            String message = String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%1$s\u5728%2$s\u8fdb\u884c\u8fc7\u53d6\u6d88\u6388\u6743\uff0c\u53d6\u6d88\u6388\u6743\u540e60\u5929\u5185\u4e0d\u5141\u8bb8\u91cd\u65b0\u6388\u6743\u3002", (String)"InvoicePermissionListPlugin_8", (String)"imc-bdm-formplugin", (Object[])new Object[0]), taxNo, DateUtils.format((Date)cancelPermissionTime, (String)"yyyy-MM-dd"));
            throw new KDBizException(message);
        }
        this.checkRemainLicenseCount(currentNode, objs);
    }

    private void checkRemainLicenseCount(String currentNode, DynamicObject[] objs) {
        HashSet<Long> selectEpInfo = new HashSet<Long>(objs.length);
        Set<Long> usedEpInfos = this.getLicenseUseEpInfo(currentNode);
        for (DynamicObject obj : objs) {
            long epinfoId = DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("epinfo"));
            if (epinfoId == 0L || usedEpInfos.contains(epinfoId)) continue;
            selectEpInfo.add(epinfoId);
        }
        int total = ImcLicenseServiceHelper.getLicenseTotalNumber((String)currentNode);
        if (total - usedEpInfos.size() - selectEpInfo.size() < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5269\u4f59\u8bb8\u53ef\u6570\u91cf\u4e0d\u591f\uff0c\u8bf7\u8d2d\u4e70\u540e\u518d\u8fdb\u884c\u6388\u6743\uff01", (String)"InvoicePermissionListPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("authorize".equals(callBackId)) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BDM_PERMISSION_AUTH);
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.authorizationOpr();
                this.refreshList();
            }
        }
        if ("cancelpermission".equals(callBackId)) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BDM_CANCEL_AUTH);
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.cancelPermissionOpr();
                this.refreshList();
            }
        }
    }

    private void cancelPermissionOpr() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_invoice_permission"));
        String currentNode = this.getPageCache().get(CURRENT_NODE);
        if (PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(currentNode) || PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(currentNode)) {
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(8);
            for (DynamicObject obj : objs) {
                obj.set("authstate", (Object)"0");
                obj.set("syncstatus", (Object)"0");
                obj.set("userfield", null);
                obj.set("authdate", null);
                obj.set("validstarttime", null);
                obj.set("validendtime", null);
                obj.set("cancelpermissiontime", (Object)new Date());
                updateList.add(obj);
            }
            ImcSaveServiceHelper.save(updateList);
        }
        boolean isSyncSuccess = false;
        boolean isSync = false;
        boolean isIssue = PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(currentNode);
        String errorMsg = "";
        if (StringUtils.isNotBlank((CharSequence)ImcLicenseServiceHelper.getProductNum((boolean)isIssue))) {
            errorMsg = ImcLicenseServiceHelper.syncPermssion2Aws((DynamicObject[])objs, (String)"1");
            isSync = true;
            isSyncSuccess = StringUtils.isBlank((CharSequence)errorMsg);
        }
        String successMsg = ResManager.loadKDString((String)"\u53d6\u6d88\u6388\u6743\u6210\u529f\u3002", (String)"InvoicePermissionListPlugin_32", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        if (isSync && isSyncSuccess) {
            successMsg = ResManager.loadKDString((String)"\u53d6\u6d88\u6388\u6743\u6210\u529f\u3002\u540c\u6b65\u6210\u529f\u3002", (String)"InvoicePermissionListPlugin_33", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        }
        this.getView().showSuccessNotification(successMsg);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.getView().showTipNotification(errorMsg, Integer.valueOf(10000));
        }
    }

    private void authorizationOpr() {
        Date date1 = new Date();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_invoice_permission"));
        ArrayList<String> taxnoList = new ArrayList<String>(objs.length);
        for (DynamicObject obj : objs) {
            String epinfoNumber = obj.getString("epinfo.number");
            if (taxnoList.contains(epinfoNumber)) continue;
            taxnoList.add(epinfoNumber);
        }
        if (CollectionUtils.isEmpty(taxnoList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e2d\u7684\u6570\u636e\u672a\u5305\u542b\u7a0e\u53f7\u4fe1\u606f,\u65e0\u6cd5\u6388\u6743!", (String)"InvoicePermissionListPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isSync = false;
        boolean isSyncSuccess = false;
        String errorMsg = "";
        String currentNode = this.getPageCache().get(CURRENT_NODE);
        if (PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(currentNode) || PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(currentNode)) {
            this.checkRemainLicenseCount(currentNode, objs);
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(8);
            RequestContext request = RequestContext.get();
            for (DynamicObject obj : objs) {
                if ("1".equals(obj.getString("authstate"))) continue;
                obj.set("authstate", (Object)"1");
                obj.set("userfield", (Object)request.getUserId());
                obj.set("authdate", (Object)new Date());
                obj.set("syncstatus", (Object)"0");
                obj.set("cancelpermissiontime", null);
                updateList.add(obj);
            }
            if (!updateList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
            Date date2 = new Date();
            this.LOGGER.info("\u6388\u6743\u64cd\u4f5c\u8017\u65f6:" + (date2.getTime() - date1.getTime()));
            boolean isIssue = PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(currentNode);
            if (StringUtils.isNotBlank((CharSequence)ImcLicenseServiceHelper.getProductNum((boolean)isIssue))) {
                errorMsg = ImcLicenseServiceHelper.syncPermssion2Aws((DynamicObject[])objs, (String)"0");
                isSync = true;
                isSyncSuccess = StringUtils.isBlank((CharSequence)errorMsg);
            }
            Date date3 = new Date();
            this.LOGGER.info("\u6388\u6743\u64cd\u4f5c\u8c03\u7528aws\u63a5\u53e3\u8017\u65f6:" + (date3.getTime() - date2.getTime()));
            ThreadPoolsHelper.batchApplyCaThreadPool.execute(() -> {
                RequestContext.copyAndSet((RequestContext)request);
                CAService.batchApplyCA(new ArrayList<DynamicObject>(Arrays.asList(objs)));
            });
        }
        String successMsg = ResManager.loadKDString((String)"\u8bb8\u53ef\u6388\u6743\u6210\u529f\u3002", (String)"InvoicePermissionListPlugin_34", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        if (isSync && isSyncSuccess) {
            successMsg = ResManager.loadKDString((String)"\u8bb8\u53ef\u6388\u6743\u6210\u529f\u3002\u540c\u6b65\u6210\u529f\u3002", (String)"InvoicePermissionListPlugin_35", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        }
        this.getView().showSuccessNotification(successMsg);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.getView().showTipNotification(errorMsg, Integer.valueOf(10000));
        }
    }

    private void loadTree() {
        String currentNode;
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_select"});
        this.initInvoiceWarningPerm();
        this.getTreeListView().getTreeView().deleteAllNodes();
        TreeNode root = this.createRootNode();
        this.getTreeListView().getTreeModel().setRoot(root);
        this.getTreeListView().getTreeView().addNode(root);
        String permissionNo = currentNode = this.getPageCache().get(CURRENT_NODE);
        if (currentNode == null) {
            permissionNo = PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo();
        }
        String permission = permissionNo;
        this.getTreeListView().getTreeView().treeNodeClick("-1", permission);
        root.getChildren().stream().filter(node -> node.getId().equals(permission)).findFirst().ifPresent(node -> this.getTreeListView().getTreeView().focusNode(node));
    }

    private void initInvoiceWarningPerm() {
        int totalNumber = ImcLicenseServiceHelper.getLicenseTotalNumber((String)PermissionEnum.INVOICE_WARNING_SERVICE.getPermissionNo());
        QFilter filter = new QFilter("servergroup", "=", (Object)PermissionEnum.INVOICE_WARNING_SERVICE.getPermissionNo());
        DeleteServiceHelper.delete((String)"bdm_invoice_permission", (QFilter[])filter.toArray());
        if (totalNumber <= 0) {
            return;
        }
        DynamicObject invoiceWarningPerm = BusinessDataServiceHelper.newDynamicObject((String)"bdm_invoice_permission");
        invoiceWarningPerm.set("servergroup", (Object)PermissionEnum.INVOICE_WARNING_SERVICE.getPermissionNo());
        invoiceWarningPerm.set("authstate", (Object)"1");
        Map dateRange = ImcLicenseServiceHelper.getDateRange((Long)Long.parseLong(CacheKeyEnum.IREW_INVOICE_PERMISSION_AUTH_GROUP_ID.getDefaultValue()));
        if (!CollectionUtils.isEmpty((Map)dateRange)) {
            Date beginDate = (Date)dateRange.get("beginDate");
            Date endDate = (Date)dateRange.get("expireDate");
            invoiceWarningPerm.set("validstarttime", (Object)beginDate);
            invoiceWarningPerm.set("validendtime", (Object)endDate);
            this.LOGGER.info("\u8bb8\u53ef\u63a7\u5236\u521d\u59cb\u5316\u65e5\u671f{}", (Object)dateRange);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceWarningPerm});
    }

    public void initTreeToolbar(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel", "searchap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainlower"});
    }

    public void initializeTree(EventObject e) {
        this.loadTree();
    }

    private TreeNode createRootNode() {
        TreeNode root = new TreeNode();
        root.setId("-1");
        root.addChildren(this.createTreeNodeChildren());
        root.setIsOpened(true);
        String tipMsg = ResManager.loadKDString((String)"\u5168\u90e8", (String)"InvoiceTypeManageFormPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        root.setText(tipMsg);
        HashMap<String, String> data = new HashMap<String, String>(8);
        data.put("level", "0");
        root.setData(data);
        root.setLongNumber(root.getId());
        return root;
    }

    private List<TreeNode> createTreeNodeChildren() {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(4);
        for (PermissionEnum permission : PermissionEnum.values()) {
            TreeNode node = new TreeNode();
            node.setId(permission.getPermissionNo());
            HashMap<String, String> data = (HashMap<String, String>)node.getData();
            if (data == null) {
                data = new HashMap<String, String>();
            }
            data.put("level", "1");
            String name = permission.getName();
            String description = this.getPermissionUseDescription(permission);
            node.setText(name + description);
            node.setParentid("-1");
            node.setData(data);
            nodes.add(node);
        }
        return nodes;
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        String nodeId = treenodeevent.getNodeId().toString();
        if (PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(nodeId)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_select"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_select"});
        }
        if (PermissionEnum.INVOICE_WARNING_SERVICE.getPermissionNo().equals(nodeId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"authorize"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"authorize"});
        }
        this.getPageCache().put(CURRENT_NODE, nodeId);
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainlower"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
    }

    private String getPermissionUseDescription(PermissionEnum permission) {
        if (PermissionEnum.INVOICE_WARNING_SERVICE == permission) {
            int totalNumber = ImcLicenseServiceHelper.getLicenseTotalNumber((String)permission.getPermissionNo());
            if (totalNumber > 0) {
                return "\uff081/1\uff09";
            }
            return "\uff080/0\uff09";
        }
        if (permission != PermissionEnum.ISSUE_INVOICE_SERVICE && permission != PermissionEnum.COLLECT_INVOICE_SERVICE) {
            return "\uff080/0\uff09";
        }
        return String.format("\uff08%d/%d\uff09", this.getLicenseUseEpInfo(permission.getPermissionNo()).size(), ImcLicenseServiceHelper.getLicenseTotalNumber((String)permission.getPermissionNo()));
    }

    private Set<Long> getLicenseUseEpInfo(String permissionType) {
        QFilter filter = new QFilter("authstate", "=", (Object)"1").and("servergroup", "=", (Object)permissionType);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bdm_invoice_permission", (String)"epinfo", (QFilter[])filter.toArray());
        HashSet<Long> distinctCount = new HashSet<Long>(objs.length);
        for (DynamicObject obj : objs) {
            long epInfoPk = DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("epinfo"));
            if (epInfoPk == 0L) continue;
            distinctCount.add(epInfoPk);
        }
        return distinctCount;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectRows;
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("selectEp".equals(actionId) && (selectRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !selectRows.isEmpty()) {
            InputPermissionUtils.saveInputPermissionByEp((Object[])selectRows.getPrimaryKeyValues());
            this.refreshList();
        }
        if ("fill_product_number_cancelpermission".equals(actionId) && null != returnData) {
            this.saveProductNumber((JSONObject)returnData, actionId);
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d6\u6d88\u6388\u6743\u540e60\u5929\u5185\u4e0d\u5141\u8bb8\u91cd\u65b0\u6388\u6743\uff0c\u5728\u6b64\u671f\u95f4\u8be5\u7a0e\u53f7\u5c06\u65e0\u6cd5\u8fdb\u884c\u5f00\u7968/\u6536\u7968\u4e1a\u52a1\uff0c\u786e\u8ba4\u662f\u5426\u53d6\u6d88\uff1f", (String)"InvoicePermissionListPlugin_27", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (String)"cancelpermission");
        }
        if ("fill_product_number_authorize".equals(actionId) && null != returnData) {
            this.saveProductNumber((JSONObject)returnData, actionId);
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u7a0e\u53f7\u4fe1\u606f\u7684\u51c6\u786e\u6027, \u786e\u5b9a\u8981\u6388\u6743\u5417\uff1f", (String)"InvoicePermissionListPlugin_28", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (String)"authorize");
        }
        if ("fill_product_number_fillproductnumber".equals(actionId) && null != returnData) {
            this.saveProductNumber((JSONObject)returnData, actionId);
        }
        if ("fill_product_number_syncpermission".equals(actionId) && null != returnData) {
            this.saveProductNumber((JSONObject)returnData, actionId);
            this.executeSync("0");
            this.refreshList();
        }
        if ("fill_product_number_SyncCancelPermission".equals(actionId) && null != returnData) {
            this.saveProductNumber((JSONObject)returnData, actionId);
            this.executeSync("1");
            this.refreshList();
        }
    }

    private void saveProductNumber(JSONObject returnDataJson, String callBackKey) {
        if (!returnDataJson.containsKey((Object)"issueNumber") && !returnDataJson.containsKey((Object)"collectNumber")) {
            return;
        }
        DynamicObject issueProductNumberConfig = null;
        DynamicObject collectProductNumberConfig = null;
        if (StringUtils.isNotBlank((Object)returnDataJson.get((Object)"issueNumber"))) {
            issueProductNumberConfig = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
            issueProductNumberConfig.set("config_type", (Object)CacheKeyEnum.BDM_ISSUE_PRODUCT_NUM.getConfigType());
            issueProductNumberConfig.set("config_key", (Object)CacheKeyEnum.BDM_ISSUE_PRODUCT_NUM.getConfigKey());
            issueProductNumberConfig.set("config_value", returnDataJson.get((Object)"issueNumber"));
        }
        if (StringUtils.isNotBlank((Object)returnDataJson.get((Object)"collectNumber"))) {
            collectProductNumberConfig = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
            collectProductNumberConfig.set("config_type", (Object)CacheKeyEnum.BDM_RECEIVE_PRODUCT_NUM.getConfigType());
            collectProductNumberConfig.set("config_key", (Object)CacheKeyEnum.BDM_RECEIVE_PRODUCT_NUM.getConfigKey());
            collectProductNumberConfig.set("config_value", returnDataJson.get((Object)"collectNumber"));
        }
        try (DLock lock = DLock.create((String)"saveProductPermission");){
            if (!lock.tryLock()) {
                return;
            }
            try (TXHandle tx = TX.required();){
                try {
                    QFilter filter;
                    if (null != issueProductNumberConfig) {
                        filter = new QFilter("config_type", "=", (Object)CacheKeyEnum.BDM_ISSUE_PRODUCT_NUM.getConfigType()).and("config_key", "=", (Object)CacheKeyEnum.BDM_ISSUE_PRODUCT_NUM.getConfigKey());
                        DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])filter.toArray());
                        ImcSaveServiceHelper.save((DynamicObject)issueProductNumberConfig);
                    }
                    if (null != collectProductNumberConfig) {
                        filter = new QFilter("config_type", "=", (Object)CacheKeyEnum.BDM_RECEIVE_PRODUCT_NUM.getConfigType()).and("config_key", "=", (Object)CacheKeyEnum.BDM_RECEIVE_PRODUCT_NUM.getConfigKey());
                        DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])filter.toArray());
                        ImcSaveServiceHelper.save((DynamicObject)collectProductNumberConfig);
                    }
                    if (null == issueProductNumberConfig && "fill_product_number_fillproductnumber".equals(callBackKey)) {
                        filter = new QFilter("config_type", "=", (Object)CacheKeyEnum.BDM_ISSUE_PRODUCT_NUM.getConfigType()).and("config_key", "=", (Object)CacheKeyEnum.BDM_ISSUE_PRODUCT_NUM.getConfigKey());
                        DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])filter.toArray());
                    }
                    if (null == collectProductNumberConfig && "fill_product_number_fillproductnumber".equals(callBackKey)) {
                        filter = new QFilter("config_type", "=", (Object)CacheKeyEnum.BDM_RECEIVE_PRODUCT_NUM.getConfigType()).and("config_key", "=", (Object)CacheKeyEnum.BDM_RECEIVE_PRODUCT_NUM.getConfigKey());
                        DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])filter.toArray());
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }
}

