/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.invoicetitle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.model.TitleOtherItem;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.RegexUtil;

public class InvoiceIssueTitleOtherPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        List fieldKeys = SchemeHelper.getBuyerFieldKeys();
        fieldKeys.add("invoicetype");
        fieldKeys.add("orgid.name");
        fieldKeys.add("customnameid.name");
        SchemeHelper.addFields((List)fieldKeys);
        SchemeHelper.initializeFilterGrid((FilterGrid)filterGrid, (List)fieldKeys, (String)"sim_original_bill");
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams && !customParams.isEmpty()) {
            TitleOtherItem otherItem = (TitleOtherItem)JSON.toJavaObject((JSON)((JSONObject)customParams.get("otherItem")), TitleOtherItem.class);
            IDataModel model = this.getModel();
            model.setValue("otherid", (Object)otherItem.getId());
            model.setValue("itemopeningbank", (Object)otherItem.getOpeningBank());
            model.setValue("itemaddr", (Object)otherItem.getAddr());
            model.setValue("itemcontacts", (Object)otherItem.getContacts());
            model.setValue("itemmobilephone", (Object)otherItem.getMobilePhone());
            model.setValue("itememail", (Object)otherItem.getEmail());
            model.setValue("itemredemail", (Object)otherItem.getRedEmail());
            model.setValue("isdefault", (Object)otherItem.getIsDefault());
            model.setValue("priority", (Object)otherItem.getPriority());
            String filterTag = otherItem.getFilter();
            if (StringUtils.isNotBlank((CharSequence)filterTag)) {
                SchemeHelper.setLocal((String)filterTag);
            }
        }
    }

    public void afterBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterCondition filterCondition = SchemeHelper.getFilterByLocal();
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("btnok")) {
            Object openingBank = this.getModel().getValue("itemopeningbank");
            if (StringUtils.isNotBlank((Object)openingBank) && openingBank.toString().length() > 150) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u7684\u957f\u5ea6\u8d85\u8fc7\u4e86:%s\u4e2a\u5b57\u7b26", (String)"InvoiceSettingEditPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]), 150);
                this.getView().showTipNotification(errorMsg);
                return;
            }
            Object addr = this.getModel().getValue("itemaddr");
            if (StringUtils.isNotBlank((Object)addr) && addr.toString().length() > 120) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5730\u5740\u7535\u8bdd\u7684\u957f\u5ea6\u8d85\u8fc7\u4e86:%s\u4e2a\u5b57\u7b26", (String)"InvoiceSettingEditPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]), 120);
                this.getView().showTipNotification(errorMsg);
                return;
            }
            String mobilePhone = this.getModel().getValue("itemmobilephone").toString();
            String email = this.getModel().getValue("itememail").toString();
            String redConfirmBillEmail = this.getModel().getValue("itemredemail").toString();
            String[] mobilePhones = mobilePhone.split(";");
            if (mobilePhones.length > 3) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u8054\u7cfb\u624b\u673a\"\u3002\u6700\u591a\u53ef\u586b\u51993\u4e2a\u624b\u673a\u53f7\u3002", (String)"InvoiceIssueTitleOtherPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            for (String phone : mobilePhones) {
                if (!StringUtils.isNotBlank((CharSequence)mobilePhone) || RegexUtil.isMobile((String)phone)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u8054\u7cfb\u624b\u673a\"\u3002\u8054\u7cfb\u624b\u673a\u8f93\u5165\u4e0d\u6b63\u786e\u3002", (String)"InvoiceIssueTitleOtherPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            String[] emails = email.split(";");
            String[] redEmails = redConfirmBillEmail.split(";");
            if (GBKUtils.getGBKLength((String)email) > 300 || emails.length > 10) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u53d1\u7968\u90ae\u7bb1\"\u3002\u6700\u591a\u53ef\u586b\u519910\u4e2a\u90ae\u7bb1\uff0c\u4e14\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7300\u3002", (String)"InvoiceIssueTitleOtherPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (GBKUtils.getGBKLength((String)redConfirmBillEmail) > 300 || redEmails.length > 10) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u7ea2\u5b57\u786e\u8ba4\u5355\u63d0\u9192\u90ae\u7bb1\"\u3002\u6700\u591a\u53ef\u586b\u519910\u4e2a\u90ae\u7bb1\uff0c\u4e14\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7300\u3002", (String)"InvoiceIssueTitleOtherPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            for (String oneEmail : emails) {
                if (!StringUtils.isNotBlank((CharSequence)oneEmail) || RegexUtil.isEmail((String)oneEmail)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u53d1\u7968\u90ae\u7bb1\"\u3002\u53d1\u7968\u90ae\u7bb1\u8f93\u5165\u4e0d\u6b63\u786e\u3002", (String)"InvoiceIssueTitleOtherPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            for (String redEmail : redEmails) {
                if (!StringUtils.isNotBlank((CharSequence)redEmail) || RegexUtil.isEmail((String)redEmail)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u7ea2\u5b57\u786e\u8ba4\u5355\u63d0\u9192\u90ae\u7bb1\"\u3002\u7ea2\u5b57\u786e\u8ba4\u5355\u63d0\u9192\u90ae\u7bb1\u8f93\u5165\u4e0d\u6b63\u786e\u3002", (String)"InvoiceIssueTitleOtherPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            Object otherId = this.getModel().getValue("otherid");
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            TitleOtherItem otherItem = new TitleOtherItem(openingBank, addr, this.getModel().getValue("itemcontacts"), (Object)mobilePhone, (Object)email, (Object)redConfirmBillEmail, ((Boolean)this.getModel().getValue("isdefault")).booleanValue(), Integer.parseInt(this.getModel().getValue("priority").toString()), (Object)SchemeHelper.getFilterStr((FilterGrid)filterGrid), StringUtils.isNotBlank((Object)otherId) ? otherId : Uuid16.create().toString());
            String operate = (String)this.getView().getFormShowParameter().getCustomParam("operate");
            otherItem.setOperate(StringUtils.isNotBlank((CharSequence)operate) ? operate : "new");
            otherItem.setSelectRow((Integer)this.getView().getFormShowParameter().getCustomParam("row"));
            this.getView().returnDataToParent((Object)otherItem);
            this.getView().close();
        }
    }
}

