/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.invoicetitle.strategy.op.validator;

import java.util.Collection;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.InvoiceBuyerTypeEnum;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import org.apache.commons.lang3.StringUtils;

public class InvoiceTitleFormValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity invoiceTitle : dataEntities = this.dataEntities) {
            DynamicObject dynamicObject = invoiceTitle.getDataEntity();
            try {
                this.checkTaxNo(dynamicObject);
                this.setDefaultInfo(dynamicObject);
            }
            catch (KDBizException e) {
                this.addErrorMessage(invoiceTitle, e.getMessage());
            }
        }
    }

    private void setDefaultInfo(DynamicObject invoiceTitle) {
        DynamicObjectCollection items = invoiceTitle.getDynamicObjectCollection("items");
        if (CollectionUtils.isEmpty((Collection)items)) {
            invoiceTitle.set("openingbank", (Object)"");
            invoiceTitle.set("addr", (Object)"");
            invoiceTitle.set("mobilephone", (Object)"");
            invoiceTitle.set("email", (Object)"");
            return;
        }
        if (items.stream().noneMatch(item -> item.getBoolean("isdefault"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u7684\u5730\u5740\u4fe1\u606f", (String)"InvoiceTitleFormValidator_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject item2 : items) {
            if (!item2.getBoolean("isdefault")) continue;
            invoiceTitle.set("openingbank", (Object)item2.getString("itemopeningbank"));
            invoiceTitle.set("addr", (Object)item2.getString("itemaddr"));
            invoiceTitle.set("mobilephone", (Object)item2.getString("itemmobilephone"));
            invoiceTitle.set("email", (Object)item2.getString("itememail"));
            break;
        }
    }

    private void checkTaxNo(DynamicObject invoiceTitle) {
        String taxno = invoiceTitle.getString("taxno");
        QFilter baseDataFilter = ImcBaseDataHelper.getInvTitleFilter((Object)invoiceTitle.get("createorg")).and("buyertype", "=", (Object)invoiceTitle.getString("buyertype")).and("id", "!=", invoiceTitle.getPkValue());
        if (InvoiceBuyerTypeEnum.company.getTypeCode().equals(invoiceTitle.getString("buyertype")) && StringUtils.isNotBlank((CharSequence)taxno)) {
            if (!Pattern.matches("^[0-9a-zA-Z]+$", taxno)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u7a0e\u53f7\"\u3002\u7a0e\u53f7\u53ea\u80fd\u586b\u5199\u6570\u5b57\u548c\u5b57\u6bcd\u3002", (String)"InvoiceTitleFormValidator_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            baseDataFilter.and("taxno", "=", (Object)taxno);
            if (QueryServiceHelper.exists((String)"bdm_invice_title_strate", (QFilter[])baseDataFilter.toArray())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[%s]\u5df2\u5b58\u5728", (String)"InvoiceTitleFormValidator_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), taxno));
            }
            invoiceTitle.set("idcode", (Object)"");
        } else if (InvoiceBuyerTypeEnum.person.getTypeCode().equals(invoiceTitle.getString("buyertype"))) {
            String idCode = invoiceTitle.getString("idcode");
            String name = invoiceTitle.getString("name");
            baseDataFilter.and("name", "=", (Object)name);
            baseDataFilter.and("createorg", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceTitle.get("createorg")));
            if (StringUtils.isNotBlank((CharSequence)idCode)) {
                baseDataFilter.and("idcode", "=", (Object)idCode);
            }
            if (QueryServiceHelper.exists((String)"bdm_invice_title_strate", (QFilter[])baseDataFilter.toArray())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0[%1$s]\uff0c\u8eab\u4efd\u8bc1\u53f7[%2$s]\u5df2\u5b58\u5728", (String)"InvoiceTitleFormValidator_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]), name, idCode));
            }
        } else if (InvoiceBuyerTypeEnum.NO_COMPANY_PERSON.getTypeCode().equals(invoiceTitle.getString("buyertype"))) {
            // empty if block
        }
    }
}

