/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuesetting.validate;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.RegexUtil;

public class AutoTaskBaseValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        if (null == dataEntities || 0 == dataEntities.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"AutoTaskBaseValidator_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObjectCollection items;
            String timePeriod;
            String type;
            DynamicObject task = entity.getDataEntity();
            if (StringUtils.isBlank((CharSequence)task.getString("name"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"AutoTaskBaseValidator_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)(type = task.getString("type")))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"AutoTaskBaseValidator_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            String source = task.getString("source");
            if ("0".equals(type) && StringUtils.isBlank((CharSequence)source)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (String)"AutoTaskBaseValidator_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            String dataType = task.getString("datatype");
            String invoiceType = task.getString("invoicetype");
            if ("2".equals(dataType) && "4".equals(type) && this.isInvoiceTypeContainsVehicle(invoiceType)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u7968\u7528\u9014\u72b6\u6001\u4e0d\u652f\u6301\u673a\u52a8\u8f66\u548c\u4e8c\u624b\u8f66", (String)"AutoTaskBaseValidator_12", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            if ("1".equals(type) || "5".equals(type)) {
                String applierType;
                String taxNos = task.getString("taxnos");
                if (taxNos.length() > 1000) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5bf9\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u6700\u957f1000\u4e2a\u5b57\u7b26", (String)"AutoTaskBaseValidator_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isNotBlank((CharSequence)taxNos)) {
                    List taxNoList = Arrays.stream(taxNos.split(",")).filter(o -> StringUtils.isNotBlank((CharSequence)o)).collect(Collectors.toList());
                    for (Object o2 : taxNoList) {
                        if (RegexUtil.isNsrsbh((String)((String)o2), (boolean)true)) continue;
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5bf9\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u683c\u5f0f\u6709\u8bef", (String)"AutoTaskBaseValidator_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    }
                }
                if (StringUtils.isBlank((CharSequence)(applierType = task.getString("appliertype")))) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7533\u8bf7\u65b9\u4e0d\u80fd\u4e3a\u7a7a", (String)"AutoTaskBaseValidator_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                }
            }
            if (StringUtils.isBlank((CharSequence)(timePeriod = task.getString("timeperiod")))) {
                if ("1".equals(type) || "2".equals(type) || "5".equals(type)) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5f55\u5165\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"AutoTaskBaseValidator_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                } else if ("3".equals(type) || "4".equals(type)) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"AutoTaskBaseValidator_11", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                }
            }
            if ((items = task.getDynamicObjectCollection("items")).size() <= 0) continue;
            for (int i = 0; i < items.size(); ++i) {
                DynamicObject item = (DynamicObject)items.get(i);
                if (StringUtils.isBlank((CharSequence)item.getString("confirmtaxno"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5bf9\u65b9\u4f01\u4e1a\u7a0e\u53f7%2$s\u5fc5\u586b", (String)"AutoTaskBaseValidator_8", (String)"imc-bdm-formplugin", (Object[])new Object[0]), i + 1, item.getString("confirmtaxno")));
                } else if (!RegexUtil.isNsrsbh((String)item.getString("confirmtaxno"), (boolean)true)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5bf9\u65b9\u4f01\u4e1a\u7a0e\u53f7%2$s\u683c\u5f0f\u6709\u8bef", (String)"AutoTaskBaseValidator_9", (String)"imc-bdm-formplugin", (Object[])new Object[0]), i + 1, item.getString("confirmtaxno")));
                }
                if (!StringUtils.isBlank((CharSequence)item.getString("confirmname")) || GBKUtils.getGBKLength((String)item.getString("confirmname")) <= 100) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5bf9\u65b9\u4f01\u4e1a\u540d\u79f0%2$s\u8d85\u957f\uff08100\u5b57\u8282\uff09", (String)"AutoTaskBaseValidator_10", (String)"imc-bdm-formplugin", (Object[])new Object[0]), i + 1, item.getString("confirmname")));
            }
        }
    }

    private boolean isInvoiceTypeContainsVehicle(String invoiceType) {
        return false;
    }
}

