/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.matchoriinvsetting;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.MetadataUtil;
import kd.imc.bdm.common.util.ViewUtil;

public class MatchOriInvSettingFormPlugin
extends AbstractFormPlugin {
    public static final ImmutableSet<String> SYS_PRESET = new ImmutableSet.Builder().add((Object[])new String[]{"buyertaxno", "buyername", "systemsource", "billsource", "invoicetype"}).add((Object[])new String[]{"textfield1", "textfield2", "textfield3", "textfield4", "textfield5"}).build();

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.setEntityNumber("sim_original_bill");
        filterGrid.setFilterFieldKeys(new ArrayList<String>(MatchOriInvSettingFormPlugin.getFieldList()));
    }

    public static Set<String> getFieldList() {
        HashSet<String> fieldList = new HashSet<String>((Collection<String>)SYS_PRESET);
        List isvEntityItems = MetadataUtil.getIsvEntityItems((String)"sim_original_bill");
        DynamicObjectType billItemObjectType = ((EntryProp)EntityMetadataCache.getDataEntityType((String)"sim_original_bill").getProperty("sim_original_bill_item")).getDynamicCollectionItemPropertyType();
        for (String isvEntityItem : isvEntityItems) {
            if (billItemObjectType.getProperty(isvEntityItem) != null) continue;
            fieldList.add(isvEntityItem);
        }
        MatchOriInvSettingFormPlugin.addConfigField(fieldList);
        return fieldList;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"itemmatchconfig", "invoicematchconfig"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "itemmatchconfig": {
                this.openFieldConfigPage(control.getKey());
                break;
            }
            case "invoicematchconfig": {
                this.openFieldConfigPage(control.getKey());
            }
        }
    }

    private void openFieldConfigPage(String key) {
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        if ("itemmatchconfig".equals(key)) {
            customParam.put("isBill", false);
            customParam.put("selectFields", this.getModel().getValue("itemmatchkey"));
            customParam.put("eventName", key);
            String tipMsg = ResManager.loadKDString((String)"\u5339\u914d\u660e\u7ec6\u5b57\u6bb5\u9009\u62e9", (String)"MatchOrInvSettingFormPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            ViewUtil.openDialog((AbstractFormPlugin)this, (String)tipMsg, customParam, (String)"bdm_merge_field_config", (String)"bdm_merge_field_config");
        } else if ("invoicematchconfig".equals(key)) {
            customParam.put("isBill", true);
            customParam.put("selectFields", this.getModel().getValue("invoicematchkey"));
            customParam.put("eventName", key);
            String tipMsg = ResManager.loadKDString((String)"\u5339\u914d\u53d1\u7968\u5b57\u6bb5\u9009\u62e9", (String)"MatchOrInvSettingFormPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            ViewUtil.openDialog((AbstractFormPlugin)this, (String)tipMsg, customParam, (String)"bdm_merge_field_config", (String)"bdm_merge_field_config");
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("itemmatchkey", (Object)String.join((CharSequence)",", "goodsname", "goodscode"));
        String tipMsg2 = ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0", (String)"MatchOrInvSettingFormPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg3 = ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u5408\u5e76\u7f16\u7801", (String)"MatchOrInvSettingFormPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("itemmatchfield", (Object)String.join((CharSequence)"_", tipMsg2, tipMsg3));
        this.getModel().setValue("invoicematchkey", (Object)String.join((CharSequence)",", "invoicetype", "buyername"));
        String tipMsg4 = ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b_\u8d2d\u65b9\u540d\u79f0", (String)"MatchOrInvSettingFormPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("invoicematchfield", (Object)String.join((CharSequence)"_", tipMsg4));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "deviation": {
                if (StringUtils.isBlank((Object)this.getModel().getValue("deviationtype"))) {
                    return;
                }
                if (!"percent".equals(this.getModel().getValue("deviationtype")) || !StringUtils.isNotBlank((Object)this.getModel().getValue("deviation"))) break;
                BigDecimal number = new BigDecimal(this.getModel().getValue("deviation").toString()).setScale(2, 4);
                if (number.compareTo(new BigDecimal("100")) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u767e\u5206\u767e\u4e0d\u80fd\u5927\u4e8e100%", (String)"MatchOriInvSettingFormPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getModel().setValue("deviation", (Object)number.toPlainString());
                break;
            }
            case "deviationtype": {
                this.getModel().setValue("deviation", null);
                break;
            }
            case "timerange": {
                this.getModel().setValue("starttime", null);
                this.getModel().setValue("endtime", null);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("itemmatchconfig".equals(returnData.get("eventName"))) {
            this.getModel().setValue("itemmatchkey", returnData.get("selectKeys"));
            this.getModel().setValue("itemmatchfield", returnData.get("selectNames"));
        }
        if ("invoicematchconfig".equals(returnData.get("eventName"))) {
            this.getModel().setValue("invoicematchkey", returnData.get("selectKeys"));
            this.getModel().setValue("invoicematchfield", returnData.get("selectNames"));
        }
    }

    public void afterBindData(EventObject e) {
        this.setFilterGrid();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)((FormOperate)args.getSource()).getOperateKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            this.getModel().setValue("filter_tag", (Object)SchemeHelper.getFilterStr((FilterGrid)filterGrid));
        }
    }

    private void setFilterGrid() {
        String filter = (String)this.getModel().getValue("filter_tag");
        FilterCondition filterCondition = null;
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            filterGrid.SetValue(filterCondition);
        }
    }

    private static void addConfigField(Set<String> fieldList) {
        String addFields = ImcConfigUtil.getValue((String)"bdm_match_issue", (String)"extField");
        try {
            if (StringUtils.isNotBlank((CharSequence)addFields)) {
                fieldList.addAll(Splitter.on((String)",").splitToList((CharSequence)addFields));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

