/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.matchredconfirmsetting;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.formplugin.matchoriinvsetting.MatchOriInvSettingFormPlugin;

public class MatchRedConfirmFormPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.setEntityNumber("sim_original_bill");
        filterGrid.setFilterFieldKeys(new ArrayList<String>(MatchOriInvSettingFormPlugin.getFieldList()));
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"itemmatchconfig"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "itemmatchconfig": {
                this.openFieldConfigPage(control.getKey());
            }
        }
    }

    private void openFieldConfigPage(String key) {
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        if ("itemmatchconfig".equals(key)) {
            customParam.put("isBill", false);
            customParam.put("selectFields", this.getModel().getValue("matchfields"));
            customParam.put("eventName", "matchRedConfirmConfig");
            String tipMsg = ResManager.loadKDString((String)"\u5339\u914d\u660e\u7ec6\u5b57\u6bb5\u9009\u62e9", (String)"MatchRedConfirmForm_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            ViewUtil.openDialog((AbstractFormPlugin)this, (String)tipMsg, customParam, (String)"bdm_merge_field_config", (String)"bdm_merge_field_config");
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("matchfields", (Object)String.join((CharSequence)",", "taxrate"));
        if (StringUtils.isBlank((Object)this.getModel().getValue("number"))) {
            this.getModel().setValue("number", (Object)("MRC-" + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + RandomString.nextString((int)6, (boolean)true, (boolean)false)));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (StringUtils.isBlank((Object)this.getModel().getValue("number"))) {
            this.getModel().setValue("number", (Object)("MRC-" + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + RandomString.nextString((int)6, (boolean)true, (boolean)false)));
        }
        this.setFilterGrid();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("matchRedConfirmConfig".equals(returnData.get("eventName"))) {
            String selectKeys = (String)returnData.get("selectKeys");
            String matchFields = "taxrate";
            if (StringUtils.isNotBlank((CharSequence)selectKeys)) {
                matchFields = matchFields + "," + selectKeys;
            }
            this.getModel().setValue("matchfields", (Object)matchFields);
            this.getModel().setValue("itemmatchfield", returnData.get("selectNames"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)((FormOperate)args.getSource()).getOperateKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            this.getModel().setValue("filter_tag", (Object)SchemeHelper.getFilterStr((FilterGrid)filterGrid));
        }
    }

    private void setFilterGrid() {
        String filter = (String)this.getModel().getValue("filter_tag");
        FilterCondition filterCondition = null;
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            filterGrid.SetValue(filterCondition);
        }
    }
}

