/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.CommonConstant;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.table.EnterPriseBaseInfoConstant;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.AllEInvoiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.service.CAService;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InputPermissionUtils;
import kd.imc.bdm.common.util.MetadataUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.formplugin.org.control.OrgEditControl;

public class OrgEditPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log LOGGER = LogFactory.getLog(OrgEditPlugin.class);
    private static final String KEY_SAVE = "save";
    private static final String KEY_EDIT = "edit";
    private static final String KEY_COTENT_FLEX = "cotentflex";
    private static final String EDIT_ORGID = "OrgEditPluginOrgId";
    private static final String EVENT_UPDATE_BUYER_TAX_NO = "updateBuyerTaxNo";
    private static final String KEY_CA_CREATE = "createca";
    private static final String KEY_UPDATE_CA = "updateca";
    private static final String KEY_EP_QUALIFICATION = "epqualification";
    private static final String KEY_EP_DEFAULTEQUIPMENT = "defaultequipment";
    private static final String KEY_TOBACCO_DATE = "tobaccodate";
    private static final String KEY_TOBACCO_START_DATE = "tobaccostartdate";
    private static final String KEY_TOBACCO_END_DATE = "tobaccoenddate";
    private static final String KEY_INVOICE_SETTING_ADD = "invoicesettingadd";
    private static final String KEY_INVOICE_SETTING_DEFAULT = "setinvoicesettingdefault";
    private static final String KEY_INVOICE_SETTING_EDIT = "invoicesettingedit";
    private static final String KEY_INVOICE_SETTING_DELETE = "deleteinvoicesetting";
    private static final String SIM_INVOICE_SETTING = "sim_invoice_setting_v1";
    private static final String NEED_SAVE_ENTERPRISE = "needSaveEnterprise";
    private static final String DELETE_ORG_INFO = "deleteOrgInfo";
    private static final String PAGE_CACHE_IS_EDIT = "isEdit";
    private static final String CLIENT_CALL_BACK_DISABLE_CUSTOM_VIEW = "disable_custom_view";
    private static final String KEY_SELLER_ADDR_FLEX = "saleraddrflexpanelap";
    private static final String EPNAME = "epname";
    private static final String TAX_NO = "taxno";
    private static final String PUBLIC_PERSON = "publicperson";
    private static final String[] FORMAT_DATA = new String[]{"epname", "taxno", "publicperson"};

    private static final String getYES() {
        return ResManager.loadKDString((String)"\u662f", (String)"OrgEditPlugin_39", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
    }

    private DynamicObject getCurrentEditOrg() {
        String orgEditPluginOrgId = this.getPageCache().get(EDIT_ORGID);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"id", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(orgEditPluginOrgId)).toArray());
        if (obj == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"bdm_org");
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "advtoolbar"});
        this.addClickListeners(new String[]{"upload", "deletefile"});
        this.addClickListeners(new String[]{KEY_INVOICE_SETTING_ADD, KEY_INVOICE_SETTING_DEFAULT, KEY_INVOICE_SETTING_EDIT, KEY_INVOICE_SETTING_DELETE, KEY_SAVE});
        Button upload = (Button)this.getControl("upload");
        upload.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        boolean isLQPTCombine;
        long orgId;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgNumber = (String)customParams.get("orgNumber");
        if (StringUtils.isNotBlank((CharSequence)orgNumber)) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
            if (org == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"OrgEditPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)org.getPkValue());
        } else {
            orgId = Long.parseLong(String.valueOf(customParams.get("orgId")));
        }
        this.getPageCache().put(EDIT_ORGID, String.valueOf(orgId));
        this.initData(orgId, Boolean.FALSE);
        this.initAddr();
        this.visibleDelete();
        OrgEditControl.updateOrgNameAndNumber(this, orgId);
        Object issueChannel = this.getModel().getValue("issuechannel");
        Object rimChannel = this.getModel().getValue("authtype");
        boolean bl = isLQPTCombine = "3".equals(issueChannel) || "7".equals(rimChannel);
        if (isLQPTCombine) {
            ((TextEdit)this.getView().getControl("leqiid")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4f7f\u7528\u5355\u4f4d\u4e50\u4f01ID", (String)"OrgEditPlugin_59", (String)"imc-bdm-formplugin", (Object[])new Object[0])));
        } else {
            ((TextEdit)this.getView().getControl("leqiid")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e50\u4f01ID", (String)"OrgEditPlugin_60", (String)"imc-bdm-formplugin", (Object[])new Object[0])));
        }
    }

    private void initData(Long orgId, Boolean isEditMode) {
        DynamicObject orgDynamicObject = this.getCurrentEditOrg();
        if (orgDynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"OrgEditPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
            return;
        }
        this.getView().setVisible(Boolean.valueOf(isEditMode == false), new String[]{KEY_EDIT});
        this.getView().setVisible(isEditMode, new String[]{KEY_SAVE});
        this.getView().setVisible(isEditMode, new String[]{"cardentryfixrowap"});
        IDataModel model = this.getModel();
        String taxNo = orgDynamicObject.getString("epinfo.number");
        this.getView().setVisible(Boolean.TRUE, new String[]{EPNAME});
        this.getView().setEnable(Boolean.FALSE, new String[]{EPNAME});
        this.getView().setEnable(Boolean.FALSE, new String[]{TAX_NO});
        this.getView().setEnable(Boolean.FALSE, new String[]{"orgbasedatafield"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexcustomview"});
        String terminalNo = orgDynamicObject.getString("defaultterminal");
        if (StringUtils.isEmpty((CharSequence)terminalNo)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"defaultterminal"});
        } else {
            model.setValue("defaultterminal", (Object)terminalNo);
        }
        this.initOrgAndEnterpriseData(orgDynamicObject, model, isEditMode);
        this.initEpQualification(orgId);
        String taxName = orgDynamicObject.getString("epinfo.name");
        model.setValue(EPNAME, (Object)taxName);
        model.setValue(TAX_NO, (Object)taxNo);
        model.setValue("orgbasedatafield", (Object)orgId);
        DynamicObject epInfoObject = orgDynamicObject.getDynamicObject("epinfo");
        if (epInfoObject != null) {
            Long epInfoId = epInfoObject.getLong("id");
            DynamicObject countryArea = (epInfoObject = BusinessDataServiceHelper.loadSingle((Object)epInfoId, (String)"bdm_enterprise_baseinfo")).getDynamicObject("country_area");
            if (countryArea == null) {
                DynamicObject countryObject;
                DynamicObject bosOrgObject = this.getBosOrgObject(orgDynamicObject.getString("number"));
                if (bosOrgObject != null && (countryObject = bosOrgObject.getDynamicObject("country")) != null) {
                    model.setValue("country_area", (Object)countryObject);
                }
            } else {
                model.setValue("country_area", (Object)countryArea);
            }
            DynamicObject taxCity = epInfoObject.getDynamicObject("tax_city");
            model.setValue("tax_city", (Object)taxCity);
            String company_property = epInfoObject.getString("company_property");
            if (StringUtils.isNotBlank((CharSequence)company_property)) {
                model.setValue("company_property", (Object)company_property);
            } else {
                DynamicObject bosOrgObject = this.getBosOrgObject(orgDynamicObject.getString("number"));
                if (bosOrgObject != null && DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)bosOrgObject, (String)"taxpayertype")) {
                    model.setValue("company_property", (Object)bosOrgObject.getString("taxpayertype"));
                }
            }
        }
        this.getPageCache().put("currentTaxName", taxName);
        this.getPageCache().put("currentTaxNo", taxNo);
        this.getPageCache().put(EPNAME, taxName);
        this.fillCAData(orgDynamicObject);
        this.fillUsedName(orgDynamicObject);
        this.loadIsvField(orgDynamicObject, "bdm_org");
        Object enterprise = orgDynamicObject.get("epinfo");
        if (enterprise != null) {
            DynamicObject dynamicObject = (DynamicObject)enterprise;
            DynamicObject enInfoDynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)"bdm_enterprise_baseinfo");
            this.loadIsvField(enInfoDynamicObject, "bdm_enterprise_baseinfo");
        }
        this.initAllEInvoice(orgDynamicObject);
        if (InputPermissionUtils.checkAuth((String)taxNo)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{EPNAME});
            this.getView().setEnable(Boolean.FALSE, new String[]{TAX_NO});
        }
        boolean visible = CacheKeyEnum.ELE_SCHEDULE_CONFIG.getConfigType().equals(ImcConfigUtil.getValue((String)CacheKeyEnum.ELE_SCHEDULE_CONFIG.getConfigType(), (String)CacheKeyEnum.ELE_SCHEDULE_CONFIG.getConfigKey()));
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"eleschedule"});
        EquipmentUtil.bindDevNoByOrg((AbstractFormPlugin)this, (String)KEY_EP_DEFAULTEQUIPMENT, (Long)Long.valueOf(this.getPageCache().get(EDIT_ORGID)), null);
        EquipmentUtil.showOrgEditTerminalNo((AbstractFormPlugin)this, (String)((String)this.getModel().getValue(KEY_EP_DEFAULTEQUIPMENT)), (String)((String)this.getModel().getValue(TAX_NO)), (String)"defaultterminal", (DynamicObject)orgDynamicObject, (boolean)true);
    }

    private DynamicObject getBosOrgObject(String number) {
        DynamicObject bosOrgObject = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        if (bosOrgObject != null) {
            bosOrgObject = BusinessDataServiceHelper.loadSingle((Object)bosOrgObject.getPkValue(), (String)"bos_org");
        }
        return bosOrgObject;
    }

    private void initAllEInvoice(DynamicObject orgDynamicObject) {
        Object account;
        List accounts;
        IDataModel model = this.getModel();
        DynamicObject epInfo = orgDynamicObject.getDynamicObject("epinfo");
        if (epInfo != null) {
            model.setValue("issuechannel", (Object)epInfo.getString("issuechannel"));
            model.setValue("enterpriserole", (Object)epInfo.getString("enterpriserole"));
            DynamicObject accessEpInfo = epInfo.getDynamicObject("accessepinfo");
            if (accessEpInfo != null) {
                model.setValue("accesstaxno", (Object)accessEpInfo.getString("number"));
            }
            model.setValue("leqiid", (Object)epInfo.getString("leqiid"));
            model.setValue("leqisecret", (Object)epInfo.getString("leqisecret"));
            model.setValue("leqiurl", (Object)epInfo.getString("leqiurl"));
            model.setValue("accessleqiid", (Object)epInfo.getString("accessleqiid"));
        }
        if ((accounts = AllEInvoiceHelper.queryIssueAllEAccount((DynamicObject)orgDynamicObject)).size() > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String account2 : accounts) {
                map.put(account2, account2);
            }
            ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"alleinvoiceaccount", map);
        }
        if (null != (account = orgDynamicObject.get("alleaccount"))) {
            String accountNo = ((DynamicObject)account).getString("alleinvoiceaccount");
            model.setValue("alleinvoiceaccount", (Object)accountNo);
        }
    }

    private void initEpQualification(Long orgId) {
        DynamicObject epInfoByOrg = TaxUtils.getEpInfoByOrg((Long)orgId);
        if (epInfoByOrg != null) {
            String tobaccoMark = epInfoByOrg.getString("tobaccomark");
            this.getView().getModel().setValue("authtype", (Object)epInfoByOrg.getDynamicObject("epinfo").getString("authtype"));
            this.getView().getModel().setValue(KEY_EP_QUALIFICATION, (Object)tobaccoMark);
            if (TaxUtils.isTobaccoMark((String)tobaccoMark)) {
                this.getView().getModel().setValue(KEY_TOBACCO_START_DATE, (Object)epInfoByOrg.getDate("tobaccoexpirestarttime"));
                this.getView().getModel().setValue(KEY_TOBACCO_END_DATE, (Object)epInfoByOrg.getDate("tobaccoexpireendtime"));
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TOBACCO_DATE});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TOBACCO_DATE});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TOBACCO_DATE});
        }
    }

    private void initOrgAndEnterpriseData(DynamicObject orgDynamicObject, IDataModel model, Boolean isEditMode) {
        model.setValue("number", (Object)orgDynamicObject.getString("number"));
        model.setValue("name", (Object)orgDynamicObject.getString("name"));
        model.setValue("parentname", (Object)orgDynamicObject.getString("parentname"));
        QFilter authQfilter = new QFilter("authstate", "=", (Object)"1").and("epinfo", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)orgDynamicObject.get("epinfo")));
        boolean hasAuth = QueryServiceHelper.exists((String)"bdm_invoice_permission", (QFilter[])authQfilter.toArray());
        this.getPageCache().put("hasAuth", hasAuth ? "1" : "0");
        this.getView().setVisible(isEditMode, new String[]{KEY_SAVE});
        this.getView().setEnable(isEditMode, new String[]{KEY_COTENT_FLEX});
        if (!hasAuth) {
            this.editEnterprise(isEditMode);
            if (StringUtils.isEmpty((CharSequence)this.getPageCache().get("hasInitCustomView"))) {
                this.initCustomView(orgDynamicObject);
            }
            this.getPageCache().put("hasInitCustomView", "hasInitCustomView");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{EPNAME});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexcustomview"});
        }
        if (!"1".equals(orgDynamicObject.getString("enterprisemainorg"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advtoolbar"});
        }
    }

    private void fillCAData(DynamicObject obj) {
        String[] split;
        int length;
        IDataModel model = this.getModel();
        model.setValue(PUBLIC_PERSON, obj.get("epinfo.publicperson"));
        model.setValue("authtype", obj.get("epinfo.authtype"));
        model.setValue("isvoucher", obj.get("epinfo.isvoucher"));
        model.setValue("check_type", obj.get("epinfo.check_type"));
        model.setValue("taxusername", obj.get("epinfo.taxusername"));
        model.setValue("taxpassword", obj.get("epinfo.taxpassword"));
        model.setValue("eleschedule", obj.get("epinfo.eleschedule"));
        model.setValue("filepath", obj.get("epinfo.businesslicenseurl"));
        String businesslicenseurl = obj.getString("epinfo.businesslicenseurl");
        if (StringUtils.isNotBlank((CharSequence)businesslicenseurl) && (length = (split = businesslicenseurl.split("/")).length) > 1) {
            this.getModel().setValue("filename", (Object)split[split.length - 1]);
        }
        if ("0".equals(obj.get("epinfo.castatus"))) {
            return;
        }
        if ("1".equals(obj.get("epinfo.castatus"))) {
            Date start = obj.getDate("epinfo.castarttime");
            Date endDate = obj.getDate("epinfo.caendtime");
            String startTime = DateUtils.format((Date)start, (String)"yyyy-MM-dd");
            String endTime = DateUtils.format((Date)endDate, (String)"yyyy-MM-dd");
            model.setValue("periodofdvalidity", (Object)(startTime + "~" + endTime));
            model.setValue("cacertificatestatus", (Object)"1");
        }
    }

    private void editEnterprise(Boolean isEditMode) {
        this.getPageCache().put(NEED_SAVE_ENTERPRISE, "1");
        this.getView().setEnable(isEditMode, new String[]{TAX_NO});
        this.getView().setVisible(Boolean.FALSE, new String[]{EPNAME});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexcustomview"});
    }

    private void initCustomView(DynamicObject org) {
        this.getPageCache().put(EPNAME, org.getString("epinfo.name"));
        HashMap<String, Object> showDataMap = new HashMap<String, Object>();
        CustomControl control = (CustomControl)this.getControl("epnamequery");
        showDataMap.put("buyerNameTxt", org.getString("epinfo.name"));
        showDataMap.put("showSearchIcon", "none");
        showDataMap.put("inputStyle", "border: none; border-bottom: 1px solid #999; padding-bottom: 5px;");
        showDataMap.put("pageId", this.getView().getPageId());
        showDataMap.put("time", System.currentTimeMillis());
        control.setData(showDataMap);
        this.getView().addClientCallBack(CLIENT_CALL_BACK_DISABLE_CUSTOM_VIEW, Integer.valueOf(800));
        this.getPageCache().put("setCustomViewInit", "setCustomViewInit");
    }

    public void customEvent(CustomEventArgs e) {
        String event = e.getEventName();
        String ars = e.getEventArgs();
        if ("queryTitle".equals(event)) {
            this.getModel().setValue(EPNAME, (Object)ars);
            this.getPageCache().put("queryTitle", ars);
            OrgEditControl.sendToCustomViewQueryTitle(this, ars);
        } else if (EVENT_UPDATE_BUYER_TAX_NO.equals(event)) {
            JSONObject argsJson = JSONObject.parseObject((String)ars);
            String name = argsJson.getString("name");
            if (StringUtils.isEmpty((CharSequence)name)) {
                this.getModel().setValue(EPNAME, null);
                this.getPageCache().put(EPNAME, "");
            } else {
                this.getModel().setValue(EPNAME, argsJson.get((Object)"name"));
                this.getModel().setValue(TAX_NO, argsJson.get((Object)"tax"));
                this.getPageCache().put(EPNAME, argsJson.get((Object)"name").toString());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals(SIM_INVOICE_SETTING) && "refresh".equals(closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u9500\u552e\u65b9\u62ac\u5934\u4fe1\u606f\u6210\u529f", (String)"OrgEditPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            this.initData(Long.valueOf(this.getPageCache().get(EDIT_ORGID)), Boolean.TRUE);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        String callBackId = closedEvent.getCallBackId();
        if (KEY_INVOICE_SETTING_DELETE.equals(callBackId) && closedEvent.getResult() == MessageBoxResult.Yes) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("sim_invoice_setting");
            int[] rows = entryGrid.getSelectRows();
            Object setId = this.getModel().getValue("setId", rows[0]);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_invoice_setting"), (Object[])new Object[]{setId});
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"OrgEditPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            this.initData(Long.valueOf(this.getPageCache().get(EDIT_ORGID)), Boolean.TRUE);
        }
        if (DELETE_ORG_INFO.equals(callBackId) && closedEvent.getResult() == MessageBoxResult.Yes) {
            this.deleteAllInvoiceSetting();
            this.deleteEpInfo();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u4fe1\u606f\u5220\u9664\u6210\u529f", (String)"OrgEditPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            this.getView().close();
        }
    }

    private void deleteEpInfo() {
        long orgId = Long.parseLong(this.getPageCache().get(EDIT_ORGID));
        if (orgId != 0L) {
            DynamicObject orgInfo = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bdm_org");
            Long epInfo = DynamicObjectUtil.getDynamicObjectLongValue((Object)orgInfo.getDynamicObject("epinfo"));
            DeleteServiceHelper.delete((String)"bdm_enterprise_baseinfo", (QFilter[])new QFilter("id", "=", (Object)epInfo).toArray());
            DeleteServiceHelper.delete((String)"bdm_enterprise_info", (QFilter[])new QFilter("epinfo", "=", (Object)epInfo).toArray());
            DeleteServiceHelper.delete((String)"bdm_invoice_permission", (QFilter[])new QFilter("epinfo", "=", (Object)epInfo).toArray());
            orgInfo.set("epinfo", (Object)0L);
            orgInfo.set("enterprisemainorg", (Object)"0");
            ImcSaveServiceHelper.save((DynamicObject)orgInfo);
        }
    }

    private boolean deleteAllInvoiceSetting() {
        try {
            EntryGrid entryGrid = (EntryGrid)this.getControl("sim_invoice_setting");
            DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
            ArrayList setIds = Lists.newArrayListWithCapacity((int)dataEntitys.length);
            for (DynamicObject dataEntity : dataEntitys) {
                setIds.add(dataEntity.getLong("setid"));
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_invoice_setting"), (Object[])setIds.toArray());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (KEY_SAVE.equals(key)) {
            this.formatData();
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
            this.saveOrgInfo();
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_EDIT});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SAVE});
            OrgEditControl.sendToCustomViewDisableView(this, false);
            this.getPageCache().remove(PAGE_CACHE_IS_EDIT);
        } else if (KEY_CA_CREATE.equals(key)) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_APPLY_CA);
            this.createPdfCa();
        } else if (KEY_EDIT.equals(key)) {
            this.initData(Long.valueOf(this.getPageCache().get(EDIT_ORGID)), Boolean.TRUE);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_EDIT});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SELLER_ADDR_FLEX});
            this.getPageCache().put(PAGE_CACHE_IS_EDIT, PAGE_CACHE_IS_EDIT);
            OrgEditControl.sendToCustomViewDisableView(this, true);
        } else if (KEY_UPDATE_CA.equals(key)) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_APPLY_CA);
            this.updateCa();
        }
    }

    private void updateCa() {
        Object cacertificatestatus = this.getModel().getValue("cacertificatestatus");
        if (!"1".equals(cacertificatestatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7533\u8bf7CA\u8bc1\u4e66\uff0c\u624d\u53ef\u4ee5\u8fdb\u884c\u66f4\u65b0CA", (String)"OrgEditPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        IDataModel model = this.getModel();
        Object taxno = model.getValue(TAX_NO);
        this.check(taxno, ResManager.loadKDString((String)"\u7a0e\u53f7", (String)"OrgEditPlugin_8", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        MsgResponse response = CAService.caUpdate((String)((String)taxno));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(ResManager.loadKDString((String)"CA\u7eed\u671f\u8fd4\u56de\uff1a", (String)"OrgEditPlugin_9", (String)"imc-bdm-formplugin", (Object[])new Object[0]) + JSONObject.toJSONString((Object)response));
        }
        if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
            Date now = new Date();
            Calendar instance = Calendar.getInstance();
            instance.add(1, 2);
            String startTime = DateUtils.format((Date)now, (String)"yyyy-MM-dd");
            String endTime = DateUtils.format((Date)instance.getTime(), (String)"yyyy-MM-dd");
            model.setValue("periodofdvalidity", (Object)(startTime + "~" + endTime));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0CA\u6210\u529f", (String)"OrgEditPlugin_10", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0CA\u5931\u8d25\uff1a%s", (String)"OrgEditPlugin_36", (String)"imc-bdm-formplugin", (Object[])new Object[0]), response.getErrorMsg()));
        }
    }

    private void createPdfCa() {
        try {
            Object cacertificatestatus = this.getModel().getValue("cacertificatestatus");
            if ("1".equals(cacertificatestatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7533\u8bf7CA\u8bc1\u4e66\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7", (String)"OrgEditPlugin_12", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            IDataModel model = this.getModel();
            Object epname = model.getValue(EPNAME);
            String tipMsg1 = ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0", (String)"OrgEditPlugin_40", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            this.check(epname, tipMsg1);
            Object publicperson = model.getValue(PUBLIC_PERSON);
            String tipMsg2 = ResManager.loadKDString((String)"\u6cd5\u4eba\u540d\u79f0", (String)"OrgEditPlugin_41", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            this.check(publicperson, tipMsg2);
            this.checkPublicPersonNameLength(String.valueOf(publicperson));
            Object taxno = model.getValue(TAX_NO);
            String tipMsg3 = ResManager.loadKDString((String)"\u7a0e\u53f7", (String)"OrgEditPlugin_42", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            this.check(taxno, tipMsg3);
            this.saveCaRelateData(taxno, publicperson, this.getModel().getValue("filepath"));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("CA\u7533\u8bf7\u53c2\u6570\uff1a\u4f01\u4e1a\u540d\u79f0\uff1a%s,\u7a0e\u53f7\uff1a%s,\u6cd5\u4eba\u540d\u79f0\uff1a%s", epname, taxno, publicperson));
            }
            MsgResponse response = CAService.caApply((String)String.valueOf(epname), (String)String.valueOf(taxno), (String)String.valueOf(publicperson));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("CA\u7533\u8bf7\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)response));
            }
            if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7533\u8bf7CA\u6210\u529f", (String)"OrgEditPlugin_17", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                this.getModel().setValue("cacertificatestatus", (Object)"1");
                String start = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                Calendar instance = Calendar.getInstance();
                instance.add(1, 2);
                Date end = instance.getTime();
                String endTime = DateUtils.format((Date)end, (String)"yyyy-MM-dd");
                this.getModel().setValue("periodofdvalidity", (Object)(start + "~" + endTime));
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7533\u8bf7CA\u5931\u8d25:%s", (String)"OrgEditPlugin_37", (String)"imc-bdm-formplugin", (Object[])new Object[0]), response.getErrorMsg()));
            }
        }
        catch (KDBizException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.getView().showTipNotification(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7533\u8bf7CA\u5931\u8d25:%s", (String)"OrgEditPlugin_37", (String)"imc-bdm-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public void saveCaRelateData(Object taxNo, Object publicPerson, Object businesslicenseurl) {
        DynamicObject[] enfoDynamicObjects = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"publicperson,businesslicenseurl", (QFilter[])new QFilter("number", "=", taxNo).toArray());
        if (null == enfoDynamicObjects || enfoDynamicObjects.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7\uff1a%s,\u5bf9\u5e94\u7684\u4f01\u4e1a\u4fe1\u606f\u4e3a\u627e\u5230", (String)"OrgEditPlugin_19", (String)"imc-bdm-formplugin", (Object[])new Object[0]), taxNo));
        }
        DynamicObject enfoDynamicObject = enfoDynamicObjects[0];
        enfoDynamicObject.set(PUBLIC_PERSON, publicPerson);
        if (StringUtils.isNotBlank((Object)this.getModel().getValue("filename")) && StringUtils.isNotBlank((Object)businesslicenseurl)) {
            enfoDynamicObject.set("businesslicenseurl", businesslicenseurl);
        }
        SaveServiceHelper.update((DynamicObject)enfoDynamicObject);
    }

    public void checkPublicPersonNameLength(String name) {
        Integer gbkLength = GBKUtils.getGBKLength((String)name);
        if (gbkLength > 16) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6cd5\u4eba\u540d\u79f0\u957f\u5ea6\u8d85\u957f", (String)"OrgEditPlugin_20", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void check(Object param, String name) {
        if (StringUtils.isBlank((Object)param)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"OrgEditPlugin_38", (String)"imc-bdm-formplugin", (Object[])new Object[0]), name));
        }
    }

    private void saveOrgInfo() {
        DynamicObject orgDynamicObject = this.getCurrentEditOrg();
        try {
            if ("1".equals(this.getPageCache().get(NEED_SAVE_ENTERPRISE))) {
                String taxName = this.getPageCache().get(EPNAME);
                String epname = (String)this.getModel().getValue(EPNAME);
                String taxNo = (String)this.getModel().getValue(TAX_NO);
                String key = taxNo + "fillCombineLeqiInfo";
                CacheHelper.remove((String)key);
                boolean isDelete = this.deleteOrgInfo(epname, taxNo);
                if (isDelete) {
                    return;
                }
                OrgEditControl.checkTaxName(this, taxName);
                OrgEditControl.checkTaxNo(this, taxNo);
            }
        }
        catch (Exception kdBizException) {
            this.getView().showTipNotification(kdBizException.getMessage());
            return;
        }
        this.doSaveDB(orgDynamicObject);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"OrgEditPlugin_28", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        this.initData(Long.valueOf(this.getPageCache().get(EDIT_ORGID)), Boolean.FALSE);
        InputPermissionUtils.savePermission((Long)orgDynamicObject.getLong("id"));
    }

    private void checkEquipmentAndTerminal() {
        DynamicObject[] equipmentSelectArr;
        String defaultEquipment = (String)this.getModel().getValue(KEY_EP_DEFAULTEQUIPMENT);
        String defaultTerminal = (String)this.getModel().getValue("defaultterminal");
        if (StringUtils.isNotEmpty((CharSequence)defaultEquipment) && (equipmentSelectArr = EquipmentUtil.getEquipmentListByDevNo((String)defaultEquipment, (String)((String)this.getModel().getValue(TAX_NO)))) != null && equipmentSelectArr.length > 0 && "8".equals(equipmentSelectArr[0].getString("equipmenttype")) && StringUtils.isEmpty((CharSequence)defaultTerminal)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8bbe\u5907\u4e3a\u767e\u671b\u670d\u52a1\u5668\u65f6\uff0c\u8bf7\u9009\u62e9\u9ed8\u8ba4\u7ec8\u7aef", (String)"OrgEditPlugin_22", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean deleteOrgInfo(String taxName, String taxNo) {
        if (StringUtils.isBlank((CharSequence)taxName) && StringUtils.isBlank((CharSequence)taxNo)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DELETE_ORG_INFO, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664", (String)"OrgEditPlugin_23", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"OrgEditPlugin_24", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0\u53ca\u4f01\u4e1a\u7a0e\u53f7\u540c\u65f6\u4e3a\u7a7a\uff0c\u5c06\u4f1a\u5220\u9664\u4f01\u4e1a\u6240\u6709\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"OrgEditPlugin_25", (String)"imc-bdm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
            return true;
        }
        return false;
    }

    private void saveEpQualification(DynamicObject orgDynamicObject) {
        Object epQualification = this.getModel().getValue(KEY_EP_QUALIFICATION);
        Object tobaccoStartDate = this.getModel().getValue(KEY_TOBACCO_START_DATE);
        Object tobaccoEndDate = this.getModel().getValue(KEY_TOBACCO_END_DATE);
        if ("".equals(epQualification)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f01\u4e1a\u8d44\u8d28", (String)"OrgEditPlugin_26", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject epBaseInfo = orgDynamicObject.getDynamicObject("epinfo");
        DynamicObject epInfo = TaxUtils.getEpInfoByOrg((DynamicObject)orgDynamicObject);
        if (epInfo == null) {
            epInfo = BusinessDataServiceHelper.newDynamicObject((String)"bdm_enterprise_info");
            epInfo.set("epinfo", epBaseInfo.getPkValue());
        }
        if (!TaxUtils.isTobaccoMark((String)((String)epQualification))) {
            epInfo.set("tobaccoexpirestarttime", null);
            epInfo.set("tobaccoexpireendtime", null);
        } else {
            if (tobaccoStartDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5377\u70df\u4f01\u4e1a\u542f\u7528\u65f6\u95f4", (String)"OrgEditPlugin_27", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            epInfo.set("tobaccoexpirestarttime", tobaccoStartDate);
            epInfo.set("tobaccoexpireendtime", tobaccoEndDate);
        }
        epInfo.set("tobaccomark", epQualification);
        ImcSaveServiceHelper.save((DynamicObject)epInfo);
    }

    private void doSaveDB(DynamicObject orgDynamicObject) {
        try (TXHandle tx = TX.required();){
            try {
                this.checkEquipmentAndTerminal();
                this.saveEpQualification(orgDynamicObject);
                DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgDynamicObject.get("id"), (String)"bdm_org");
                this.fillIsvField(org, "bdm_org");
                org.set("defaultdev", this.getModel().getValue(KEY_EP_DEFAULTEQUIPMENT));
                org.set("defaultterminal", this.getModel().getValue("defaultterminal"));
                String taxNo = (String)this.getModel().getValue(TAX_NO);
                String account = (String)this.getModel().getValue("alleinvoiceaccount");
                org.set("alleaccount", (Object)AllEInvoiceHelper.queryAccount((String)taxNo, (String)account));
                org.set("orgbasedatafield", orgDynamicObject.get("id"));
                this.saveEnterprise(orgDynamicObject);
                ImcSaveServiceHelper.save((DynamicObject)org);
            }
            catch (KDBizException e) {
                tx.markRollback();
                LOGGER.error("\u4fdd\u5b58\u7ec4\u7ec7\u8bbe\u5907\u5217\u8868\u4fe1\u606f\u548c\u5b58\u50a8\u8bbe\u5907\u4fe1\u606f\u5931\u8d25\uff0c\u89e6\u53d1\u4e8b\u52a1\u56de\u6eda", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u4fdd\u5b58\u7ec4\u7ec7\u8bbe\u5907\u5217\u8868\u4fe1\u606f\u548c\u5b58\u50a8\u8bbe\u5907\u4fe1\u606f\u5931\u8d25\uff0c\u89e6\u53d1\u4e8b\u52a1\u56de\u6eda", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"OrgEditPlugin_30", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.initShowTaxCityMethod();
    }

    private void initShowTaxCityMethod() {
        DynamicObject countryAreaObject = (DynamicObject)this.getModel().getValue("country_area");
        if (countryAreaObject != null) {
            String name = countryAreaObject.getString("name");
            String countryName = ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"OrgEditPlugin_61", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)name) && name.contains(countryName)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"tax_city"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tax_city"});
            }
        }
    }

    private void saveEnterprise(DynamicObject orgDynamicObject) {
        String epname = this.getPageCache().get(EPNAME);
        String taxno = (String)this.getModel().getValue(TAX_NO);
        Object enterprise = orgDynamicObject.get("epinfo");
        DynamicObject dynamicObject = (DynamicObject)enterprise;
        DynamicObject enInfoDynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)"bdm_enterprise_baseinfo");
        this.fillIsvField(enInfoDynamicObject, "bdm_enterprise_baseinfo");
        enInfoDynamicObject.set("name", (Object)epname);
        enInfoDynamicObject.set("number", (Object)taxno);
        Object publicPerson = this.getModel().getValue(PUBLIC_PERSON);
        this.checkPublicPersonNameLength(String.valueOf(publicPerson));
        enInfoDynamicObject.set(PUBLIC_PERSON, publicPerson);
        DynamicObjectCollection collect = this.getModel().getEntryEntity("usednameentry");
        DynamicObjectCollection usednameentry = enInfoDynamicObject.getDynamicObjectCollection("usednameentry");
        usednameentry.clear();
        for (DynamicObject obj : collect) {
            String used_name = obj.getString("used_name");
            if (StringUtils.isEmpty((CharSequence)used_name)) continue;
            DynamicObject newObj = usednameentry.addNew();
            newObj.set("used_name", obj.get("used_name"));
            newObj.set("used_name_date", obj.get("used_name_date"));
        }
        if (StringUtils.isNotBlank((Object)this.getModel().getValue("filename")) && StringUtils.isNotBlank((Object)this.getModel().getValue("filepath"))) {
            enInfoDynamicObject.set("businesslicenseurl", this.getModel().getValue("filepath"));
        }
        enInfoDynamicObject.set("castatus", this.getModel().getValue("cacertificatestatus"));
        enInfoDynamicObject.set("authtype", this.getModel().getValue("authtype"));
        String isvoucher = (String)this.getModel().getValue("isvoucher");
        enInfoDynamicObject.set("isvoucher", (Object)isvoucher);
        enInfoDynamicObject.set("check_type", this.getModel().getValue("check_type"));
        enInfoDynamicObject.set("taxusername", this.getModel().getValue("taxusername"));
        enInfoDynamicObject.set("taxpassword", this.getModel().getValue("taxpassword"));
        enInfoDynamicObject.set("eleschedule", this.getModel().getValue("eleschedule"));
        String issueChannel = (String)this.getModel().getValue("issuechannel");
        String oriIssueChannel = enInfoDynamicObject.getString("issuechannel");
        enInfoDynamicObject.set("issuechannel", (Object)issueChannel);
        OrgEditControl.checkAllEleIssueChannle(this, enInfoDynamicObject);
        enInfoDynamicObject.set("country_area", this.getModel().getValue("country_area"));
        enInfoDynamicObject.set("tax_city", this.getModel().getValue("tax_city"));
        enInfoDynamicObject.set("company_property", this.getModel().getValue("company_property"));
        ImcSaveServiceHelper.save((DynamicObject)enInfoDynamicObject);
        if (issueChannel != null && !issueChannel.equals(oriIssueChannel) && EnterPriseBaseInfoConstant.LQPT_CHANNEL_DIRECT.contains((Object)issueChannel)) {
            OrgEditControl.initLqptInfo(taxno, (String)this.getModel().getValue("enterpriserole"));
        }
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        List attachInfos = evt.getAttachInfos();
        int size = attachInfos.size();
        if (size > 0) {
            IDataModel model = this.getModel();
            Map map = (Map)attachInfos.get(0);
            Object fileSize = map.get("size");
            String fileName = String.valueOf(map.get("name"));
            if (fileName.length() > 100) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u957f\u5ea6\u8fc7\u957f", (String)"OrgEditPlugin_31", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(fileSize)).divide(new BigDecimal("1024"), 2, RoundingMode.HALF_UP);
            model.setValue("filename", (Object)(fileName + bigDecimal + "kb"));
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String url = (String)urls[0];
            IDataModel model = this.getModel();
            model.setValue("filepath", (Object)url);
            this.visibleDelete();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (KEY_EP_QUALIFICATION.equals(e.getProperty().getName())) {
            if ("1".equals(newValue) || "2".equals(newValue)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TOBACCO_DATE});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TOBACCO_DATE});
            }
        } else if (KEY_EP_DEFAULTEQUIPMENT.equals(e.getProperty().getName())) {
            DynamicObject orgDynamicObject = this.getCurrentEditOrg();
            EquipmentUtil.showOrgEditTerminalNo((AbstractFormPlugin)this, (String)((String)e.getChangeSet()[0].getNewValue()), (String)((String)this.getModel().getValue(TAX_NO)), (String)"defaultterminal", (DynamicObject)orgDynamicObject, (boolean)false);
        } else if ("country_area".equals(key)) {
            this.initShowTaxCityMethod();
        } else if ("issuechannel".equals(key)) {
            if ("3".equals(String.valueOf(newValue))) {
                ((TextEdit)this.getView().getControl("leqiid")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4f7f\u7528\u5355\u4f4d\u4e50\u4f01ID", (String)"OrgEditPlugin_59", (String)"imc-bdm-formplugin", (Object[])new Object[0])));
            } else {
                ((TextEdit)this.getView().getControl("leqiid")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e50\u4f01ID", (String)"OrgEditPlugin_60", (String)"imc-bdm-formplugin", (Object[])new Object[0])));
            }
        } else if ("authtype".equals(key)) {
            if ("7".equals(String.valueOf(newValue))) {
                ((TextEdit)this.getView().getControl("leqiid")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4f7f\u7528\u5355\u4f4d\u4e50\u4f01ID", (String)"OrgEditPlugin_59", (String)"imc-bdm-formplugin", (Object[])new Object[0])));
            } else {
                ((TextEdit)this.getView().getControl("leqiid")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e50\u4f01ID", (String)"OrgEditPlugin_60", (String)"imc-bdm-formplugin", (Object[])new Object[0])));
            }
        }
    }

    public void click(EventObject evt) {
        IDataModel model;
        String filePath;
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals(KEY_INVOICE_SETTING_ADD)) {
            this.openInvoiceSettingView(true);
        } else if (key.equals(KEY_INVOICE_SETTING_EDIT)) {
            this.openInvoiceSettingView(false);
        } else if (key.equals(KEY_INVOICE_SETTING_DELETE)) {
            this.deleteInvoiceSetting();
        } else if (key.equals(KEY_INVOICE_SETTING_DEFAULT)) {
            this.setInvoiceSettingDefault();
        } else if ("deletefile".equals(key) && StringUtils.isNotBlank((CharSequence)(filePath = (String)(model = this.getModel()).getValue("filepath")))) {
            FileServiceFactory.getAttachmentFileService().delete(filePath);
            model.setValue("filename", null);
            this.visibleDelete();
        }
    }

    private void visibleDelete() {
        Object fileName = this.getModel().getValue("filename");
        if (StringUtils.isBlank((Object)fileName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"deletefile"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"deletefile"});
        }
    }

    private void deleteInvoiceSetting() {
        QFilter addrFilter = new QFilter(TAX_NO, "=", this.getModel().getValue(TAX_NO));
        DynamicObject[] settings = BusinessDataServiceHelper.load((String)"sim_invoice_setting", (String)"id", (QFilter[])addrFilter.toArray());
        if (settings.length <= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u9500\u65b9\u4fe1\u606f", (String)"OrgEditPlugin_32", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664?", (String)"OrgEditPlugin_33", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (String)KEY_INVOICE_SETTING_DELETE);
    }

    private void setInvoiceSettingDefault() {
        DynamicObject[] load;
        EntryGrid entryGrid = (EntryGrid)this.getControl("sim_invoice_setting");
        int[] rows = entryGrid.getSelectRows();
        Object setId = this.getModel().getValue("setId", rows[0]);
        QFilter addrFilter = new QFilter(TAX_NO, "=", this.getModel().getValue(TAX_NO));
        for (DynamicObject obj : load = BusinessDataServiceHelper.load((String)"sim_invoice_setting", (String)"ischeck", (QFilter[])addrFilter.toArray())) {
            obj.set("ischeck", (Object)"0");
        }
        SaveServiceHelper.update((DynamicObject[])load);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)setId, (String)"sim_invoice_setting");
        obj.set("ischeck", (Object)"1");
        ImcSaveServiceHelper.save((DynamicObject)obj);
        this.getView().invokeOperation("refresh");
        this.initData(Long.valueOf(this.getPageCache().get(EDIT_ORGID)), Boolean.TRUE);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u6210\u529f", (String)"OrgEditPlugin_34", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
    }

    private void initAddr() {
        String fields = "id,taxno,invoiceaddr,openuserbank,ischeck,shop_referred,shop_no,filter,filter_tag";
        QFilter addrFilter = new QFilter(TAX_NO, "=", this.getModel().getValue(TAX_NO));
        DynamicObjectCollection sellerAddrList = QueryServiceHelper.query((String)"sim_invoice_setting", (String)fields, (QFilter[])addrFilter.toArray(), (String)" ischeck desc");
        if (sellerAddrList.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SELLER_ADDR_FLEX});
            return;
        }
        boolean isDefaultExists = false;
        int length = sellerAddrList.size();
        for (int i = 0; i < length; ++i) {
            this.getModel().createNewEntryRow("sim_invoice_setting");
            this.getModel().setValue("invoiceaddr", ((DynamicObject)sellerAddrList.get(i)).get("invoiceaddr"), i);
            this.getModel().setValue("openuserbank", ((DynamicObject)sellerAddrList.get(i)).get("openuserbank"), i);
            this.getModel().setValue("shop_referred", ((DynamicObject)sellerAddrList.get(i)).get("shop_referred"), i);
            this.getModel().setValue("shop_no", ((DynamicObject)sellerAddrList.get(i)).get("shop_no"), i);
            this.getModel().setValue("setId", ((DynamicObject)sellerAddrList.get(i)).get("id"), i);
            this.getModel().setValue("ischeck", (Object)("1".equals(((DynamicObject)sellerAddrList.get(i)).get("ischeck")) ? ResManager.loadKDString((String)"\u662f", (String)"OrgEditPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"OrgEditPlugin_35", (String)"imc-bdm-formplugin", (Object[])new Object[0])), i);
            if (!"1".equals(((DynamicObject)sellerAddrList.get(i)).get("ischeck") + "")) continue;
            isDefaultExists = true;
        }
        if (!isDefaultExists && length > 0) {
            this.getModel().setValue("ischeck", (Object)ResManager.loadKDString((String)"\u662f", (String)"OrgEditPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]), 0);
            DynamicObject main = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)sellerAddrList.get(0)).get("id"), (String)"sim_invoice_setting");
            main.set("ischeck", (Object)"1");
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{main});
        }
        this.getView().updateView();
    }

    private void fillUsedName(DynamicObject orgDynamicObject) {
        QFilter filter = new QFilter("id", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)orgDynamicObject.get("epinfo")));
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_enterprise_baseinfo", (String)"usednameentry.used_name as used_name,usednameentry.used_name_date as used_name_date", (QFilter[])filter.toArray());
        this.getModel().deleteEntryData("usednameentry");
        for (DynamicObject obj : collect) {
            String usedName = obj.getString("used_name");
            if (!StringUtils.isNotEmpty((CharSequence)usedName)) continue;
            int attachIndex = this.getModel().createNewEntryRow("usednameentry");
            this.getModel().setValue("used_name", obj.get("used_name"), attachIndex);
            this.getModel().setValue("used_name_date", obj.get("used_name_date"), attachIndex);
        }
    }

    private void fillIsvField(DynamicObject orgDynamicObject, String entityKey) {
        List fieldList = MetadataUtil.getIsvEntityItems((String)entityKey);
        for (String field : fieldList) {
            try {
                Control control = this.getView().getControl(field);
                if (control == null) continue;
                orgDynamicObject.set(field, this.getModel().getValue(field));
            }
            catch (Exception e) {
                LOGGER.info("\u6269\u5c55\u5b57\u6bb5\u8bbe\u7f6e\u9519\u8bef{},{}", (Object)entityKey, (Object)field);
            }
        }
    }

    private void loadIsvField(DynamicObject orgDynamicObject, String entityKey) {
        List fieldList = MetadataUtil.getIsvEntityItems((String)entityKey);
        for (String field : fieldList) {
            try {
                Control control = this.getView().getControl(field);
                if (control == null) continue;
                this.getModel().setValue(field, orgDynamicObject.get(field));
            }
            catch (Exception e) {
                LOGGER.info("\u6269\u5c55\u5b57\u6bb5\u8bbe\u7f6e\u9519\u8bef{},{}", (Object)entityKey, (Object)field);
            }
        }
    }

    private void openInvoiceSettingView(boolean isAdd) {
        EntryGrid entryGrid;
        int[] rows;
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        if (!isAdd && (rows = (entryGrid = (EntryGrid)this.getControl("sim_invoice_setting")).getSelectRows()).length != 0) {
            Object setId = this.getModel().getValue("setId", rows[0]);
            customParams.put("id", setId);
            customParams.put("invoiceaddr", this.getModel().getValue("invoiceaddr", rows[0]));
            customParams.put("openuserbank", this.getModel().getValue("openuserbank", rows[0]));
            customParams.put("shop_referred", this.getModel().getValue("shop_referred", rows[0]));
            customParams.put("shop_no", this.getModel().getValue("shop_no", rows[0]));
            customParams.put("filter_tag", this.getModel().getValue("filter_tag", rows[0]));
            customParams.put("ischeck", OrgEditPlugin.getYES().equals(this.getModel().getValue("ischeck", rows[0])));
        }
        customParams.put(TAX_NO, this.getPageCache().get("currentTaxNo"));
        ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)SIM_INVOICE_SETTING, (String)SIM_INVOICE_SETTING);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (CLIENT_CALL_BACK_DISABLE_CUSTOM_VIEW.equals(e.getName())) {
            OrgEditControl.sendToCustomViewDisableView(this, false);
        }
    }

    private void formatData() {
        for (String formatDatum : FORMAT_DATA) {
            this.getModel().setValue(formatDatum, (Object)this.getModel().getValue(formatDatum).toString().trim());
        }
    }
}

