/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.imc.bdm.common.constant.CommonConstant;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.model.LevelTreeNode;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.SearchUtil;
import kd.imc.bdm.common.util.TreeUtils;

public class OrgImportPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeCheckListener,
TreeNodeDragListener,
SearchEnterListener {
    private static final String LEFT_TREE = "left_tree";
    private static final String RIGHT_TREE = "right_tree";
    private static final String BTN_SUBMIT = "btn_submit";
    private static final String BTN_CANCEL = "btn_cancel";
    public static final String BTN_GO = "btngo";
    private static final String BTN_BACK = "btnback";
    private static final String LList = "llist";
    private static final String CHECK_CHILD = "checkchild";
    private static final int MAXLEVEL = 20;
    private Boolean lazyLoad = null;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_SUBMIT, BTN_CANCEL, BTN_GO, BTN_BACK});
        this.addClickListeners(new String[]{"searchbefore_l", "searchnext_l", "searchbefore_r", "searchnext_r"});
        TreeView leftTreeView = (TreeView)this.getView().getControl(LEFT_TREE);
        leftTreeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search sl = (Search)this.getControl("searchapleft");
        sl.addEnterListener((SearchEnterListener)this);
        if (this.isLazyLoad().booleanValue()) {
            leftTreeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        }
        TreeView rightTreeView = (TreeView)this.getView().getControl(RIGHT_TREE);
        rightTreeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        rightTreeView.addTreeNodeDragListener((TreeNodeDragListener)this);
        Search sr = (Search)this.getControl("searchapright");
        sr.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadLeftTree();
        this.initRightTree();
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btngo": {
                PermissionHelper.checkPermission((String)"bdm", (String)"bdm_org", (ImcPermItemEnum)ImcPermItemEnum.BDM_IMPORT_ORG);
                this.goClick();
                break;
            }
            case "btnback": {
                this.backClick();
                break;
            }
            case "btn_submit": {
                PermissionHelper.checkPermission((String)"bdm", (String)"bdm_org", (ImcPermItemEnum)ImcPermItemEnum.BDM_IMPORT_ORG);
                this.submitClick();
                break;
            }
            case "searchbefore_l": 
            case "searchnext_l": {
                SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key.substring(0, key.length() - 2), (TreeView)((TreeView)this.getControl(LEFT_TREE)), (String[])new String[]{"searchbefore", "searchnext"}, (String)LEFT_TREE);
                break;
            }
            case "searchbefore_r": 
            case "searchnext_r": {
                SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key.substring(0, key.length() - 2), (TreeView)((TreeView)this.getControl(RIGHT_TREE)), (String[])new String[]{"searchbefore", "searchnext"}, (String)RIGHT_TREE);
            }
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        TreeView treeView = (TreeView)event.getSource();
        Boolean checkChild = (Boolean)this.getModel().getValue(LEFT_TREE.equals(treeView.getKey()) ? CHECK_CHILD : "checkchildright");
        TreeNode root = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)treeView.getKey());
        TreeNode node = root.getTreeNode(event.getNodeId().toString(), 20);
        if (checkChild.booleanValue()) {
            if (event.getChecked().booleanValue()) {
                TreeUtils.checkChilds((TreeView)treeView, (TreeNode)node);
            } else {
                TreeUtils.unCheckChilds((TreeView)treeView, (TreeNode)node);
            }
        }
    }

    private void initRightTree() {
        TreeNode rootNode = this.getROOT();
        TreeView treeRight = (TreeView)this.getView().getControl(RIGHT_TREE);
        Map orgMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_org"), null);
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(orgMap.size());
        Set entries = orgMap.entrySet();
        for (Map.Entry ent : entries) {
            nodeList.add(this.buildRightTreeNode((DynamicObject)ent.getValue()));
        }
        List roots = TreeUtils.findRoot(nodeList);
        for (TreeNode root : roots) {
            TreeUtils.findChildren((TreeNode)root, nodeList);
            rootNode.addChild(root);
        }
        treeRight.addNode(rootNode);
        rootNode.setIsOpened(true);
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE, (Object)rootNode);
    }

    private TreeNode buildRightTreeNode(DynamicObject obj) {
        boolean isBindEp;
        TreeNode node = new TreeNode();
        String number = obj.getString("number");
        String name = obj.getString("name");
        node.setId(obj.getString("id"));
        if (obj.get("parent") instanceof DynamicObject) {
            node.setParentid(obj.getDynamicObject("parent").getString("id"));
        } else {
            node.setParentid(obj.getString("parent"));
        }
        node.setText(number + "_" + name);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", node.getId());
        data.put("number", number);
        data.put("name", name);
        data.put("status", obj.getString("status"));
        boolean bl = isBindEp = obj.get("epinfo") == null;
        if (!isBindEp) {
            node.setColor("gray");
        }
        data.put("epinfo", isBindEp ? "0" : "1");
        node.setData(data);
        return node;
    }

    private TreeNode getROOT() {
        TreeNode rootRight = new TreeNode();
        rootRight.setId("-1");
        rootRight.setText(ResManager.loadKDString((String)"\u6839\u7ec4\u7ec7", (String)"OrgImportPlugin_10", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        rootRight.setParentid("");
        return rootRight;
    }

    public void backClick() {
        TreeView rightTreeView = (TreeView)this.getView().getControl(RIGHT_TREE);
        List checkedNodeIds = rightTreeView.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u8282\u70b9\u3002", (String)"OrgImportPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
            return;
        }
        TreeNode rightRoot = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE);
        for (String checkedNodeId : checkedNodeIds) {
            TreeNode focusNode = rightRoot.getTreeNode(checkedNodeId, 20);
            if ("-1".equals(focusNode.getId())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7ec4\u7ec7\u4e3a\u6839\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5de6\u79fb\u5220\u9664", (String)"OrgImportPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.checkTreeBindEp(focusNode)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7ec4\u7ec7\u4e2d\u5305\u542b\u5df2\u7ed1\u5b9a\u4f01\u4e1a\uff0c\u4e0d\u80fd\u5de6\u79fb\u5220\u9664", (String)"OrgImportPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        rightTreeView.deleteNodes(checkedNodeIds);
        for (String checkedNodeId : checkedNodeIds) {
            rightRoot.deleteChildNode(checkedNodeId);
        }
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE, (Object)rightRoot);
        rightTreeView.treeNodeClick(null, rightRoot.getId());
    }

    private boolean checkTreeBindEp(TreeNode focusNode) {
        return !CollectionUtils.isEmpty(this.checkTreeBindEp(new ArrayList<TreeNode>(), focusNode));
    }

    private List<TreeNode> checkTreeBindEp(List<TreeNode> nodes, TreeNode focusNode) {
        String ep;
        Map data = (Map)focusNode.getData();
        if (data != null && "1".equals(ep = data.getOrDefault("epinfo", "0"))) {
            nodes.add(focusNode);
            return nodes;
        }
        if (!CollectionUtils.isEmpty((Collection)focusNode.getChildren())) {
            focusNode.getChildren().forEach(node -> this.checkTreeBindEp(nodes, (TreeNode)node));
        }
        return nodes;
    }

    public void goClick() {
        TreeView leftTreeView = (TreeView)this.getView().getControl(LEFT_TREE);
        List selectIds = leftTreeView.getTreeState().getSelectedNodeId();
        if (!selectIds.isEmpty()) {
            selectIds.remove("root");
        }
        if (selectIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u8282\u70b9\u3002", (String)"OrgImportPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        TreeView rightTreeView = (TreeView)this.getView().getControl(RIGHT_TREE);
        List checkedNodeIds = rightTreeView.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u53f3\u6811\u8282\u70b9\u3002", (String)"OrgImportPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        TreeNode rightRoot = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE);
        TreeNode focusNode = rightRoot.getTreeNode((String)checkedNodeIds.get(0), 20);
        List<TreeNode> selectList = this.getLeftSelectNode((String)checkedNodeIds.get(0));
        rightTreeView.addNodes(selectList);
        focusNode.addChildren(selectList);
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE, (Object)rightRoot);
    }

    public void submitClick() {
        TreeNode rightRoot = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE);
        List rightNodeIds = TreeUtils.getNodeIdList((TreeNode)rightRoot);
        Map<String, DynamicObject> existsOrgMap = this.queryExistsOrg();
        ArrayList<String> existOrgIds = new ArrayList<String>(existsOrgMap.keySet());
        List deleteOrgIds = existOrgIds.stream().filter(o -> !rightNodeIds.contains(o)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(deleteOrgIds)) {
            DeleteServiceHelper.delete((String)"bdm_org_tree_list", (QFilter[])new QFilter("id", "in", (Object)deleteOrgIds.stream().map(Long::parseLong).toArray()).toArray());
        }
        ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>();
        LevelTreeNode levelTreeNode = new LevelTreeNode(Long.valueOf(0L), rightRoot);
        OrgImportPlugin.parseSaveData(insertList, levelTreeNode, null, existsOrgMap, "");
        if (insertList.size() != 0) {
            ImcSaveServiceHelper.save(insertList);
        }
        this.getView().returnDataToParent((Object)"refresh");
        this.getView().close();
    }

    public static void parseSaveData(List<DynamicObject> dataList, LevelTreeNode levelTreeNode, LevelTreeNode parentNode, Map<String, DynamicObject> existsOrgMap, String parentLongNum) {
        TreeNode node = levelTreeNode.getTreeNode();
        if (!node.getId().equals("-1")) {
            parentLongNum = !"".equals(parentLongNum) ? parentLongNum + "." + node.getId() : node.getId();
            Map data = (Map)node.getData();
            DynamicObject dObj = existsOrgMap.get(node.getId());
            if (StringUtils.isBlank((CharSequence)((CharSequence)data.get("name")))) {
                return;
            }
            if (dObj != null) {
                dObj.set("parent", (Object)node.getParentid());
                dObj.set("longnumber", (Object)parentLongNum);
                dObj.set("orgbasedatafield", (Object)node.getId());
                OrgImportPlugin.fillInParent(dObj, parentNode);
            } else {
                dObj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_org_tree_list");
                dObj.set("id", (Object)node.getId());
                dObj.set("number", data.get("number"));
                dObj.set("longnumber", (Object)parentLongNum);
                dObj.set("name", data.get("name"));
                dObj.set("basename", data.get("name"));
                dObj.set("enterprisemainorg", (Object)"0");
                dObj.set("status", (Object)"C");
                dObj.set("createtime", (Object)new Date());
                dObj.set("modifytime", (Object)new Date());
                dObj.set("orgbasedatafield", (Object)node.getId());
                dObj.set("creator", (Object)RequestContext.get().getUserId());
                dObj.set("enable", (Object)"1");
                dObj.set("enable", (Object)"1");
                if (null == parentNode) {
                    dObj.set("level", (Object)0);
                    OrgImportPlugin.fillInParent(dObj, null);
                } else {
                    dObj.set("level", (Object)(parentNode.getLevel() + 1L));
                    OrgImportPlugin.fillInParent(dObj, parentNode);
                }
            }
            dataList.add(dObj);
        }
        if (!CollectionUtils.isEmpty((Collection)node.getChildren())) {
            for (TreeNode child : node.getChildren()) {
                LevelTreeNode levelChild = new LevelTreeNode(Long.valueOf(levelTreeNode.getLevel() + 1L), child);
                OrgImportPlugin.parseSaveData(dataList, levelChild, levelTreeNode, existsOrgMap, parentLongNum);
            }
        }
    }

    private static void fillInParent(DynamicObject dObj, LevelTreeNode parentLevelNode) {
        if (parentLevelNode == null) {
            dObj.set("parent", (Object)"-1");
            dObj.set("parentid", (Object)"-1");
            dObj.set("parentname", (Object)" ");
            return;
        }
        TreeNode parentNode = parentLevelNode.getTreeNode();
        if (parentNode != null) {
            dObj.set("parent", (Object)parentNode.getId());
            dObj.set("parentid", (Object)parentNode.getId());
            Map data1 = (Map)parentNode.getData();
            if (data1 != null) {
                dObj.set("parentname", data1.get("name"));
            } else {
                dObj.set("parentname", (Object)" ");
            }
        } else {
            dObj.set("parent", (Object)"-1");
            dObj.set("parentid", (Object)"-1");
            dObj.set("parentname", (Object)" ");
        }
    }

    private List<TreeNode> getLeftSelectNode(String rightFocusId) {
        TreeView leftTreeView = (TreeView)this.getView().getControl(LEFT_TREE);
        TreeNode leftRoot = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)LEFT_TREE);
        List selectIds = leftTreeView.getTreeState().getSelectedNodeId();
        List existsIdList = TreeUtils.getNodeIdList((TreeNode)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE));
        Boolean checkChild = (Boolean)this.getModel().getValue(CHECK_CHILD);
        ArrayList<String> longNumberList = new ArrayList<String>();
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>();
        int existsSize = 0;
        for (Object nodeId : selectIds) {
            if (existsIdList.contains(nodeId)) {
                ++existsSize;
                continue;
            }
            TreeNode treeMode = leftRoot.getTreeNode((String)nodeId, 20);
            if (!checkChild.booleanValue()) {
                longNumberList.add(treeMode.getLongNumber());
                treeNodeList.add(TreeUtils.copyNode((TreeNode)treeMode));
                continue;
            }
            List subList = TreeUtils.getNodeList((TreeNode)treeMode);
            for (TreeNode node : subList) {
                if (existsIdList.contains(node.getId()) || longNumberList.contains(node.getLongNumber())) continue;
                longNumberList.add(node.getLongNumber());
                treeNodeList.add(TreeUtils.copyNode((TreeNode)node));
            }
        }
        if (selectIds.size() == existsSize) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u7ec4\u7ec7\u5df2\u5168\u90e8\u52a0\u5165\u5230\u53f3\u8fb9\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"OrgImportPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        Map<String, String> parentIdMap = this.getParentIdMap(longNumberList);
        for (TreeNode treeMode : treeNodeList) {
            treeMode.setParentid(parentIdMap.get(treeMode.getId()));
        }
        List roots = TreeUtils.findRoot(treeNodeList);
        for (TreeNode root : roots) {
            TreeUtils.findChildren((TreeNode)root, treeNodeList);
            root.setParentid(rightFocusId);
        }
        return roots;
    }

    private Map<String, String> getParentIdMap(List<String> longNumberList) {
        HashMap<String, String> parentIdMap = new HashMap<String, String>(16);
        Iterator<String> iterator = longNumberList.iterator();
        while (iterator.hasNext()) {
            String longNum;
            String id = longNum = iterator.next();
            int index = longNum.lastIndexOf(46);
            if (index >= 0) {
                id = longNum.substring(index + 1);
            }
            String parent = "";
            while (index >= 0) {
                String sub = longNum.substring(0, index);
                if (longNumberList.contains(sub)) {
                    int subIndex = sub.lastIndexOf(46);
                    if (subIndex <= 0) {
                        parent = sub;
                        break;
                    }
                    parent = sub.substring(subIndex + 1);
                    break;
                }
                index = sub.lastIndexOf(46);
            }
            parentIdMap.put(id, parent);
        }
        return parentIdMap;
    }

    private Map<String, DynamicObject> queryExistsOrg() {
        try (DataSet ds = ORM.create().queryDataSet("BusinessDataServiceHelper.load", "bdm_org_tree_list", "id", null);){
            ArrayList idList = new ArrayList();
            ds.forEach(row -> idList.add(row.get(0)));
            DynamicObject[] orgList = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_org_tree_list"));
            Map<String, DynamicObject> map = Stream.of(orgList).collect(Collectors.toMap(k -> k.getString("id"), v -> v, (v1, v2) -> v2));
            return map;
        }
    }

    private void loadLeftTree() {
        Long root = null;
        if (this.isLazyLoad().booleanValue()) {
            root = 0L;
        }
        List<TreeNode> nodeList = this.queryOrgStructure(root);
        TreeView treeLeftView = (TreeView)this.getView().getControl(LEFT_TREE);
        TreeUtils.build((TreeView)treeLeftView, nodeList, (IPageCache)this.getPageCache(), (boolean)false);
    }

    private List<TreeNode> queryOrgStructure(Long parent) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        QFilter qFilter = new QFilter("view.treetype", "=", (Object)"15");
        if (parent != null) {
            qFilter.and("parent", "=", (Object)parent);
        }
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)OrgViewServiceHelper.class.getName(), (String)"bos_org_structure", (String)"org.id, org.number, org.name, parent.id, level, view.treetype", (QFilter[])qFilter.toArray(), (String)"level");){
            for (Row rootRow : ds) {
                TreeNode rootLeft = new TreeNode();
                Long leftRootId = rootRow.getLong("org.id");
                if (ids.contains(leftRootId)) continue;
                ids.add(leftRootId);
                rootLeft.setId(leftRootId.toString());
                rootLeft.setParentid(rootRow.getLong("parent.id").toString());
                rootLeft.setLongNumber(rootLeft.getId());
                rootLeft.setText(rootRow.getString("org.number") + " " + rootRow.getString("org.name"));
                if (parent != null) {
                    rootLeft.setChildren(new ArrayList());
                }
                HashMap data = Maps.newHashMapWithExpectedSize((int)8);
                data.put("isNew", "1");
                data.put("name", rootRow.getString("org.name"));
                data.put("number", rootRow.getString("org.number"));
                data.put("id", rootRow.getLong("org.id").toString());
                data.put("epinfo", "0");
                data.put("level", rootRow.getString("level"));
                rootLeft.setData((Object)data);
                nodeList.add(rootLeft);
            }
        }
        return nodeList;
    }

    public void treeNodeDragged(TreeNodeDragEvent event) {
        String nodeId;
        String fromParentId;
        if (event == null) {
            return;
        }
        String toParentId = event.getToParentId().toString();
        if (toParentId.equals(fromParentId = event.getFromParentId().toString())) {
            return;
        }
        TreeNode root = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE);
        TreeNode currNode = root.getTreeNode(nodeId = event.getNodeId().toString(), 20);
        if (currNode == null) {
            return;
        }
        List childList = TreeUtils.getChildIdList((TreeNode)currNode);
        if (childList.contains(toParentId)) {
            return;
        }
        currNode.setParentid(toParentId);
        TreeView rightTreeView = (TreeView)this.getView().getControl(RIGHT_TREE);
        rightTreeView.deleteNode(currNode.getId());
        rightTreeView.addNode(currNode);
        TreeNode toNode = root.getTreeNode(toParentId, 20);
        TreeNode fromNode = root.getTreeNode(fromParentId, 20);
        if (fromNode != null) {
            fromNode.deleteChildNode(nodeId);
        } else {
            root.deleteChildNode(nodeId);
        }
        if (toNode != null) {
            toNode.addChild(currNode);
        }
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE, (Object)root);
    }

    public void search(SearchEnterEvent event) {
        Search search = (Search)event.getSource();
        boolean leftSearch = "searchapleft".equals(search.getKey());
        String text = event.getText();
        if (StringUtils.isNotBlank((CharSequence)text)) {
            String control = leftSearch ? LEFT_TREE : RIGHT_TREE;
            SearchUtil.searchMember((String)text.toLowerCase().trim(), (boolean)leftSearch, (IFormView)this.getView(), (IPageCache)this.getPageCache(), (TreeView)((TreeView)this.getView().getControl(control)), (String)control);
        } else {
            this.getPageCache().put(leftSearch ? LList : "_resultlist", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"OrgImportPlugin_9", (String)"imc-bdm-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
        String nodeId = (String)arg0.getNodeId();
        TreeView treeView = (TreeView)arg0.getSource();
        List<TreeNode> nodeList = this.queryOrgStructure(Long.parseLong(nodeId));
        TreeNode root = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)treeView.getKey());
        TreeNode node = root.getTreeNode(nodeId, 20);
        node.setChildren(nodeList);
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)treeView.getKey(), (Object)root);
        if (nodeList.isEmpty()) {
            treeView.addNode(null);
        } else {
            treeView.addNodes(nodeList);
        }
    }

    private Boolean isLazyLoad() {
        if (this.lazyLoad == null) {
            this.lazyLoad = "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.BDM_ORG_LAZYLOAD));
            return this.lazyLoad;
        }
        return this.lazyLoad;
    }
}

