/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.riskcontrolconfig;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.table.RiskControlConfigConstant;
import kd.imc.bdm.common.constant.table.RiskControlRangeEnum;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.util.NumberGenerateUtil;
import kd.imc.bdm.common.util.ViewUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class RiskControlConfigFormPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(RiskControlConfigFormPlugin.class);
    private static final String SCOPE_START_LABEL = "scopestartlabel";
    private static final String SCOPE_END_LABEL = "scopeendlabel";
    private static final String HEAD_SETTING_BTN = "headsettingbtn";
    private static final String ITEM_SETTING_BTN = "itemsettingbtn";
    private static final String LABEL_AP_HEAD_NAMES = "labelapheadnames";
    private static final String LABEL_AP_ITEM_NAMES = "labelapitemnames";
    private static final String FLEX_PANEL_AP_REPLAY = "flexpanelapreplay";
    private static final String FLEX_PANEL_AP_BLACK = "flexpanelapblack";
    private static final String FLEX_PANEL_AP_CONDITION = "flexpanelapcondition";
    public static final String BLACK_ENTITY = "blackentity";
    public static final String FILTER_CONTROL = "filtercontrol";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"range", "type", HEAD_SETTING_BTN, ITEM_SETTING_BTN});
    }

    public void afterCreateNewData(EventObject e) {
        this.initData(false);
    }

    public void afterBindData(EventObject e) {
        this.initData(true);
    }

    private void initData(boolean bindInitFlag) {
        String number;
        String type = (String)this.getModel().getValue("type");
        this.setTypeView(type, bindInitFlag);
        String range = (String)this.getModel().getValue("range");
        this.setRangeView(range, bindInitFlag);
        String scopeUnit = (String)this.getModel().getValue("scopeunit");
        this.setScopeUnitView(scopeUnit);
        Object createOrg = this.getModel().getValue("createorg");
        if (createOrg == null) {
            long orgId = RequestContext.get().getOrgId();
            this.getModel().setValue("createorg", (Object)orgId);
        }
        if (StringUtils.isEmpty((CharSequence)(number = (String)this.getModel().getValue("number")))) {
            number = NumberGenerateUtil.generateByPrefixWithRandom((String)"FK", (int)3);
            this.getModel().setValue("number", (Object)number);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int index = changeData.getRowIndex();
        if (newValue != null && !newValue.equals(oldValue)) {
            switch (name) {
                case "range": {
                    this.setRangeView((String)newValue, false);
                    break;
                }
                case "type": {
                    this.setTypeView((String)newValue, false);
                    break;
                }
                case "scopeunit": {
                    this.setScopeUnitView((String)newValue);
                    break;
                }
                case "headselectflag": {
                    this.setSelectFlagView(newValue, "headselectkeys", "headselectnames", "salertaxno,buyertaxno,totalamount");
                    break;
                }
                case "itemselectflag": {
                    this.setSelectFlagView(newValue, "itemselectkeys", "itemselectnames", "goodsname,goodscode,taxrate,taxamount");
                    break;
                }
                case "epname": {
                    if (!StringUtils.isEmpty((CharSequence)((String)newValue))) break;
                    String errMsg = ResManager.loadKDString((String)"\u8d2d\u65b9\u9ed1\u540d\u5355\u81ea\u5b9a\u4e49\u6570\u636e\u6e90\u4e2d\u7b2c%s\u884c\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"RiskControlConfigFormPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[]{index + 1});
                    this.getView().showErrorNotification(errMsg);
                    break;
                }
                case "taxno": {
                    this.checkBuyerBlackTaxNo(index);
                }
            }
        }
    }

    private void checkBuyerBlackTaxNo(int index) {
        DynamicObjectCollection blackListEntity = this.getModel().getEntryEntity(BLACK_ENTITY);
        if (blackListEntity == null || blackListEntity.isEmpty()) {
            return;
        }
        String epName = StringUtils.defaultString((String)((String)this.getModel().getValue("epname", index)));
        String taxNo = StringUtils.defaultString((String)((String)this.getModel().getValue("taxno", index)));
        String errMsg = null;
        for (int i = 0; i < blackListEntity.size(); ++i) {
            if (index == i) continue;
            DynamicObject dynamicObject = (DynamicObject)blackListEntity.get(i);
            String currentTaxNo = StringUtils.defaultString((String)dynamicObject.getString("taxno"));
            String currentEpName = StringUtils.defaultString((String)dynamicObject.getString("epname"));
            if (!epName.equals(currentEpName) || !taxNo.equals(currentTaxNo)) continue;
            errMsg = String.format(ResManager.loadKDString((String)"\u8d2d\u65b9\u9ed1\u540d\u5355\u81ea\u5b9a\u4e49\u6570\u636e\u6e90\u4e2d\u7b2c%1$s\u884c\u4f01\u4e1a\u7a0e\u53f7\u3010%2$s\u3011\u4e0e\u4f01\u4e1a\u540d\u79f0\u3010%3$s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RiskControlConfigFormPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]), index + 1, taxNo, epName);
            break;
        }
        if (errMsg != null) {
            this.getView().showErrorNotification(errMsg);
        }
    }

    private boolean checkBuyerBlackList() {
        DynamicObjectCollection blackListEntity = this.getModel().getEntryEntity(BLACK_ENTITY);
        if (blackListEntity == null || blackListEntity.isEmpty()) {
            return false;
        }
        HashSet<String> dataKeySet = new HashSet<String>(blackListEntity.size());
        String errMsg = null;
        for (int i = 0; i < blackListEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)blackListEntity.get(i);
            String epName = StringUtils.defaultString((String)dynamicObject.getString("epname"));
            String taxNo = StringUtils.defaultString((String)dynamicObject.getString("taxno"));
            if (StringUtils.isEmpty((CharSequence)epName)) {
                errMsg = ResManager.loadKDString((String)"\u8d2d\u65b9\u9ed1\u540d\u5355\u81ea\u5b9a\u4e49\u6570\u636e\u6e90\u4e2d\u7b2c%s\u884c\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"RiskControlConfigFormPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[]{i + 1});
                break;
            }
            String key = epName + " " + taxNo;
            if (dataKeySet.contains(key)) {
                errMsg = String.format(ResManager.loadKDString((String)"\u8d2d\u65b9\u9ed1\u540d\u5355\u81ea\u5b9a\u4e49\u6570\u636e\u6e90\u4e2d\u7b2c%1$s\u884c\u4f01\u4e1a\u7a0e\u53f7\u3010%2$s\u3011\u4e0e\u4f01\u4e1a\u540d\u79f0\u3010%3$s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RiskControlConfigFormPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]), i + 1, taxNo, epName);
                break;
            }
            dataKeySet.add(key);
        }
        if (errMsg != null) {
            this.getView().showErrorNotification(errMsg);
            return true;
        }
        return false;
    }

    private void setSelectFlagView(Object selectValue, String selectKeys, String selectNames, String defaultField) {
        if (Boolean.TRUE.equals(selectValue)) {
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(selectKeys))) {
                this.getModel().setValue(selectKeys, (Object)defaultField);
            }
        } else {
            this.getModel().setValue(selectKeys, null);
            this.getModel().setValue(selectNames, null);
        }
    }

    private void clearRangeData() {
        this.getModel().setValue("headselectkeys", null);
        this.getModel().setValue("headselectnames", null);
        this.getModel().setValue("itemselectkeys", null);
        this.getModel().setValue("itemselectnames", null);
        this.getModel().setValue("scopeunit", (Object)RiskControlConfigConstant.ScopeUnitEnum.SCOPE_UNIT_MONTH.getCode());
        this.getModel().setValue("scopestartvalue", (Object)0);
        this.getModel().setValue("scopeendvalue", (Object)2);
    }

    private void setScopeUnitView(String scopeUnit) {
        RiskControlConfigConstant.ScopeUnitEnum scopeUnitEnum = RiskControlConfigConstant.ScopeUnitEnum.getScopeUnitEnumByCode((String)scopeUnit);
        if (scopeUnitEnum != null) {
            Label scopeStartLabel = (Label)this.getView().getControl(SCOPE_START_LABEL);
            scopeStartLabel.setText(scopeUnitEnum.getDesc());
            Label scopeEndLabel = (Label)this.getView().getControl(SCOPE_END_LABEL);
            scopeEndLabel.setText(scopeUnitEnum.getDesc());
        }
    }

    private void setRangeView(String range, boolean bindInitFlag) {
        if (StringUtils.isEmpty((CharSequence)range)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_PANEL_AP_CONDITION, LABEL_AP_HEAD_NAMES, LABEL_AP_ITEM_NAMES});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_PANEL_AP_CONDITION, LABEL_AP_HEAD_NAMES, LABEL_AP_ITEM_NAMES});
        RiskControlRangeEnum riskControlRangeEnum = RiskControlRangeEnum.getRiskControlRangeEnumByFormId((String)range);
        if (riskControlRangeEnum == null) {
            return;
        }
        Label labelApHead = (Label)this.getView().getControl("labelaphead");
        labelApHead.setText(riskControlRangeEnum.getDesc());
        Label labelApItem = (Label)this.getView().getControl("labelapitem");
        labelApItem.setText(riskControlRangeEnum.getDesc());
        if (!bindInitFlag) {
            this.clearRangeData();
            this.getModel().setValue("headselectkeys", (Object)"salertaxno,buyertaxno,totalamount");
            this.getModel().setValue("itemselectkeys", (Object)"goodsname,goodscode,taxrate,taxamount");
        }
        String formId = riskControlRangeEnum.getFormId();
        ImmutableSet filterSet = riskControlRangeEnum.getFilterSet();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        List entityColumns = EntityTypeUtil.getInstance().getFilterColumns((IDataEntityType)entityType);
        ArrayList<Map> filterColumns = new ArrayList<Map>(filterSet.size());
        for (Map entityColumn : entityColumns) {
            String fieldName = (String)entityColumn.get("fieldName");
            if (!filterSet.contains((Object)fieldName)) continue;
            RiskControlConfigConstant.SelectFieldEnum selectFieldEnum = RiskControlConfigConstant.SelectFieldEnum.getSelectFieldEnumByCode((String)fieldName);
            if (selectFieldEnum != null) {
                entityColumn.put("fieldCaption", selectFieldEnum.getName());
            }
            filterColumns.add(entityColumn);
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_CONTROL);
        filterGrid.SetValue(Collections.EMPTY_LIST);
        filterGrid.setEntityNumber(formId);
        filterGrid.setFilterColumns(filterColumns);
        String filterStr = (String)this.getModel().getValue("filter_tag");
        if (StringUtils.isNotBlank((CharSequence)filterStr) && bindInitFlag) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
        this.getView().updateView(FILTER_CONTROL);
    }

    private void setTypeView(String type, boolean bindInitFlag) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("type");
        if (StringUtils.isEmpty((CharSequence)type)) {
            comboEdit.hideTips();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_PANEL_AP_BLACK, FLEX_PANEL_AP_REPLAY});
            return;
        }
        if (!bindInitFlag) {
            this.clearRangeData();
            this.getModel().deleteEntryData(BLACK_ENTITY);
            this.getModel().setValue("headselectkeys", (Object)"salertaxno,buyertaxno,totalamount");
            this.getModel().setValue("itemselectkeys", (Object)"goodsname,goodscode,taxrate,taxamount");
        }
        boolean blackListFlag = "buyerBlackList".equals(type);
        boolean isTaxRate = "taxrateControl".equals(type);
        LocaleString content = blackListFlag ? ResManager.getLocaleString((String)"\u914d\u7f6e\u540e\uff0c\u5f00\u7968\u6570\u636e\u7684\u8d2d\u65b9\u4fe1\u606f\u4e3a\u9ed1\u540d\u5355\u4f01\u4e1a\uff0c\u5c06\u6309\u7ba1\u63a7\u5f3a\u5ea6\u63a7\u5236", (String)"RiskControlConfigFormPlugin_5", (String)"imc-bdm-formplugin") : ResManager.getLocaleString((String)"\u6309\u91cd\u590d\u5f00\u7968\u6bd4\u5bf9\u89c4\u5219\uff0c\u6bd4\u5bf9\u5f00\u7968\u6570\u636e\u548c\u5df2\u5f00\u7968\u6570\u636e\uff0c\u6bd4\u5bf9\u4e00\u81f4\u65f6\uff0c\u6309\u7ba1\u63a7\u5f3a\u5ea6\u963b\u65ad\u64cd\u4f5c", (String)"RiskControlConfigFormPlugin_4", (String)"imc-bdm-formplugin");
        Tips tips = new Tips();
        tips.setTitle(ResManager.getLocaleString((String)"\u7ba1\u63a7\u8bf4\u660e", (String)"RiskControlConfigFormPlugin_3", (String)"imc-bdm-formplugin"));
        tips.setContent(content);
        tips.setType("text");
        comboEdit.addTips(tips);
        if (!isTaxRate) {
            this.getView().setVisible(Boolean.valueOf(blackListFlag), new String[]{FLEX_PANEL_AP_BLACK});
            this.getView().setVisible(Boolean.valueOf(!blackListFlag), new String[]{FLEX_PANEL_AP_REPLAY});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_PANEL_AP_BLACK, FLEX_PANEL_AP_REPLAY});
        }
        boolean rangeNull = StringUtils.isNotEmpty((CharSequence)((String)this.getModel().getValue("range")));
        this.getView().setVisible(Boolean.valueOf(rangeNull), new String[]{LABEL_AP_HEAD_NAMES, LABEL_AP_ITEM_NAMES});
        this.setRangeList(type);
    }

    private void setRangeList(String type) {
        boolean blackListFlag = "buyerBlackList".equals(type);
        ImmutableSet currentSet = blackListFlag ? RiskControlRangeEnum.BLACK_LIST_RANGE_ENUM : ("taxrateControl".equals(type) ? RiskControlRangeEnum.TAXRATE_ENUM : RiskControlRangeEnum.ANTI_REPLAY_RANGE_ENUM);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(currentSet.size());
        for (RiskControlRangeEnum riskControlRangeEnum : currentSet) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(riskControlRangeEnum.getDesc()));
            comboItem.setValue(riskControlRangeEnum.getFormId());
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("range");
        comboEdit.setComboItems(comboItems);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String range = (String)this.getModel().getValue("range");
        switch (control.getKey()) {
            case "headsettingbtn": {
                this.openFieldConfigPage(range, false);
                break;
            }
            case "itemsettingbtn": {
                this.openFieldConfigPage(range, true);
            }
        }
    }

    private void openFieldConfigPage(String formId, boolean itemFlag) {
        RiskControlRangeEnum riskControlRangeEnum = RiskControlRangeEnum.getRiskControlRangeEnumByFormId((String)formId);
        if (riskControlRangeEnum == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ba1\u63a7\u8303\u56f4\uff01", (String)"RiskControlConfigFormPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("formId", formId);
        String selectKeys = "headselectkeys";
        String selectNames = "headselectnames";
        String detailTitle = ResManager.loadKDString((String)"\u3010\u5355\u636e\u5934\u3011", (String)"RiskControlConfigFormPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        if (itemFlag) {
            customParam.put("itemId", riskControlRangeEnum.getItemId());
            detailTitle = ResManager.loadKDString((String)"\u3010\u5355\u636e\u4f53\u3011", (String)"RiskControlConfigFormPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            selectKeys = "itemselectkeys";
            selectNames = "itemselectnames";
        }
        customParam.put("selectKeys", selectKeys);
        customParam.put("selectNames", selectNames);
        customParam.put("selectKeysValue", this.getModel().getValue(selectKeys));
        customParam.put("selectNamesValue", this.getModel().getValue(selectNames));
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)(riskControlRangeEnum.getDesc() + detailTitle), customParam, (String)"bdm_risk_ct_field_config", (String)"bdm_risk_ct_field_config");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("bdm_risk_ct_field_config")) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            String selectKeys = String.valueOf(returnData.get("selectKeys"));
            String selectNames = String.valueOf(returnData.get("selectNames"));
            String selectKeysValue = String.valueOf(returnData.get("displaySelectKeys"));
            String selectNamesValue = String.valueOf(returnData.get("displaySelectNames"));
            if (StringUtils.isNotEmpty((CharSequence)selectNamesValue)) {
                selectNamesValue = "_" + selectNamesValue;
            }
            this.getModel().setValue(selectKeys, (Object)selectKeysValue);
            this.getModel().setValue(selectNames, (Object)selectNamesValue);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)((FormOperate)args.getSource()).getOperateKey())) {
            args.setCancel(this.checkBuyerBlackList());
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_CONTROL);
            String filterStr = SchemeHelper.getFilterStr((FilterGrid)filterGrid);
            this.getModel().setValue("filter_tag", (Object)filterStr);
            String range = (String)this.getModel().getValue("range");
            SchemeHelper.getQFilerByTag((String)filterStr, (String)range);
        }
    }
}

