/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org.webapi;

import java.util.Collection;
import java.util.Date;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import org.apache.commons.lang3.StringUtils;

public class AddorgService {
    public OrgParam addOrg(String tenantNo, String tenantName, String orgNo, String orgName, String taxNo, Long root) {
        DynamicObject newThirdOrg;
        String newOrgNo;
        QFilter idFilter = new QFilter("third_org_no", "=", (Object)orgNo);
        DynamicObject thirdOrg = QueryServiceHelper.queryOne((String)"bdm_third_org", (String)"id,third_org_no,org_no,orgid", (QFilter[])new QFilter[]{idFilter});
        if (thirdOrg == null) {
            newOrgNo = String.valueOf(ID.genLongId());
            newThirdOrg = BusinessDataServiceHelper.newDynamicObject((String)"bdm_third_org");
            newThirdOrg.set("third_org_no", (Object)orgNo);
            newThirdOrg.set("org_no", (Object)newOrgNo);
            newThirdOrg.set("create_time", (Object)new Date());
        } else {
            newOrgNo = thirdOrg.getString("org_no");
            newThirdOrg = BusinessDataServiceHelper.loadSingle((Object)thirdOrg.get("id"), (String)"bdm_third_org");
        }
        Long orgId = this.addOrg(newOrgNo, orgName, taxNo, root);
        newThirdOrg.set("orgid", (Object)orgId);
        newThirdOrg.set("update_time", (Object)new Date());
        newThirdOrg.set("tenant_no", (Object)tenantNo);
        newThirdOrg.set("tenant_name", (Object)tenantName);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newThirdOrg});
        OrgParam orgParam = new OrgParam();
        orgParam.setId(orgId.longValue());
        orgParam.setNumber(newOrgNo);
        return orgParam;
    }

    public Long addOrg(String orgNo, String orgName, String taxNo, Long root) {
        QFilter idFilter = new QFilter("number", "=", (Object)orgNo);
        DynamicObject[] org = BusinessDataServiceHelper.load((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter[]{idFilter});
        if (org == null || org.length < 1) {
            OrgParam orgParam = new OrgParam();
            orgParam.setName(orgName);
            orgParam.setNumber(orgNo);
            orgParam.setDuty("15");
            if (root <= 0L) {
                orgParam.setParentId(OrgUnitServiceHelper.getRootOrgId());
            } else {
                orgParam.setParentId(root.longValue());
            }
            TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
            OrgDutyView view = new OrgDutyView();
            view.setParentId(orgParam.getParentId());
            multiViewMap.put("10", view);
            view = new OrgDutyView();
            view.setParentId(orgParam.getParentId());
            multiViewMap.put("01", view);
            orgParam.setMultiViewMap(multiViewMap);
            OrgUnitServiceHelper.add((OrgParam)orgParam);
            if (!orgParam.isSuccess()) {
                throw new KDException(new ErrorCode("0003", orgParam.getMsg()), new Object[0]);
            }
            return orgParam.getId();
        }
        return DynamicObjectUtil.getDynamicObjectLongValue((Object)org[0].get("id"));
    }

    public void addBdmOrg(Long parentId, Long orgId, String orgNumber, String orgName, String taxNo, String name) {
        DynamicObject epInfo;
        DynamicObject orgObj;
        QFilter filter;
        DynamicObject parentObj;
        String longNum = "";
        String parentName = "";
        if (parentId > 0L && (parentObj = QueryServiceHelper.queryOne((String)"bdm_org", (String)"id,longnumber,name", (QFilter[])new QFilter[]{filter = new QFilter("id", "=", (Object)parentId)})) != null) {
            longNum = parentObj.getString("longnumber");
            parentName = parentObj.getString("name");
        }
        filter = new QFilter("id", "=", (Object)orgId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdm_org", (String)"id,longnumber,epinfo.id as epinfo", (QFilter[])new QFilter[]{filter});
        RequestContext request = RequestContext.get();
        Long epId = this.addEpInfo(taxNo, name);
        if (CollectionUtils.isEmpty((Collection)collection)) {
            orgObj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_org");
            orgObj.set("id", (Object)orgId);
            orgObj.set("orgbasedatafield", (Object)orgId);
            orgObj.set("number", (Object)orgNumber);
            orgObj.set("name", (Object)orgName);
            orgObj.set("status", (Object)"C");
            if (StringUtils.isEmpty((CharSequence)taxNo)) {
                orgObj.set("enterprisemainorg", (Object)"0");
            } else {
                orgObj.set("enterprisemainorg", (Object)"1");
            }
            orgObj.set("createtime", (Object)new Date());
        } else {
            orgObj = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)collection.get(0)).get("id"), (String)"bdm_org");
        }
        orgObj.set("orgbasedatafield", orgObj.get("id"));
        orgObj.set("parent", (Object)parentId);
        orgObj.set("parentname", (Object)parentName);
        orgObj.set("epinfo", (Object)epId);
        orgObj.set("modifierid", (Object)request.getUserId());
        orgObj.set("modifytime", (Object)new Date());
        if (!StringUtils.isEmpty((CharSequence)longNum)) {
            orgObj.set("longnumber", (Object)(longNum + "." + orgId));
        } else {
            orgObj.set("longnumber", (Object)orgId);
        }
        if (CollectionUtils.isEmpty((Collection)collection)) {
            ImcSaveServiceHelper.save((DynamicObject)orgObj);
        } else {
            ImcSaveServiceHelper.update((DynamicObject)orgObj);
        }
        if ("1".equals(orgObj.getString("enterprisemainorg")) && epId != 0L && (epInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"org", (QFilter[])new QFilter("id", "=", (Object)epId).toArray())) != null && DynamicObjectUtil.getDynamicObjectLongValue((Object)epInfo.get("org")) == 0L) {
            epInfo.set("org", orgObj.getPkValue());
            ImcSaveServiceHelper.update((DynamicObject)epInfo);
        }
    }

    public Long addEpInfo(String taxNo, String name) {
        if (StringUtils.isNotEmpty((CharSequence)taxNo)) {
            QFilter numberfilter = new QFilter("number", "=", (Object)taxNo);
            DynamicObjectCollection epcollection = QueryServiceHelper.query((String)"bdm_enterprise_baseinfo", (String)"id,name", (QFilter[])new QFilter[]{numberfilter});
            if (!CollectionUtils.isEmpty((Collection)epcollection)) {
                DynamicObject ep = (DynamicObject)epcollection.get(0);
                String taxName = ep.getString("name");
                Long epId = ep.getLong("id");
                if (StringUtils.isNotEmpty((CharSequence)name) && name.equals(taxName)) {
                    ep = BusinessDataServiceHelper.loadSingle((Object)epId, (String)"bdm_enterprise_baseinfo");
                    ep.set("name", (Object)taxName);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ep});
                }
                return epId;
            }
            DynamicObject epobj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_enterprise_baseinfo");
            epobj.set("name", (Object)name);
            epobj.set("number", (Object)taxNo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{epobj});
            return epobj.getLong("id");
        }
        return 0L;
    }

    public void addClient(Long orgId, String taxNo, String name, String clientId, String clientSecret, String encKey) {
        if (StringUtils.isNotEmpty((CharSequence)clientId)) {
            QFilter enableQFilter = new QFilter("org", "=", (Object)orgId);
            DynamicObject configResult = QueryServiceHelper.queryOne((String)"er_bd_kdinvoicecloudcfg", (String)"id,org,taxregnum,firmname,client_id,client_secret,encrypt_key", (QFilter[])new QFilter[]{enableQFilter});
            configResult = configResult == null ? BusinessDataServiceHelper.newDynamicObject((String)"er_bd_kdinvoicecloudcfg") : BusinessDataServiceHelper.loadSingle((Object)configResult.get("id"), (String)"er_bd_kdinvoicecloudcfg");
            configResult.set("org", (Object)orgId);
            configResult.set("taxregnum", (Object)taxNo);
            configResult.set("firmname", (Object)name);
            configResult.set("client_id", (Object)clientId);
            configResult.set("client_secret", (Object)clientSecret);
            if (clientId.length() > 3) {
                configResult.set("clients", (Object)AddorgService.encrypt(clientId));
            }
            configResult.set("clientkey", (Object)AddorgService.encrypt(clientSecret));
            configResult.set("encrypt_key", (Object)encKey);
            configResult.set("enable", (Object)Boolean.TRUE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{configResult});
        }
    }

    public static String encrypt(String value) {
        if (value == null) {
            return "";
        }
        try {
            int length = value.length();
            if (length > 4) {
                return value.replaceAll("(.{2}).{" + (value.length() - 4) + "}(.{" + 2 + "})", "$1****$2");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

