/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.constant;

import kd.bos.dataentity.utils.StringUtils;
import kd.imc.bdm.common.constant.MultiLangEnumBridge;
import kd.sdk.annotation.SdkDeprecated;

public enum InvoiceType {
    ELECTRICAL_NORMAL_INVOICE(new MultiLangEnumBridge("\u7535\u5b50\u666e\u901a\u53d1\u7968", "InvoiceType_0", "imc-bdm-common"), "026", "51", new MultiLangEnumBridge("\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968", "InvoiceType_1", "imc-bdm-common"), "1", "", "10"),
    ELECTRICAL_SPECIAL_INVOICE(new MultiLangEnumBridge("\u7535\u5b50\u4e13\u7528\u53d1\u7968", "InvoiceType_2", "imc-bdm-common"), "028", "61", new MultiLangEnumBridge("\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968", "InvoiceType_3", "imc-bdm-common"), "2", "", "08"),
    PAPER_NOMAL_INVOICE(new MultiLangEnumBridge("\u7eb8\u8d28\u666e\u901a\u53d1\u7968", "InvoiceType_4", "imc-bdm-common"), "007", "2", new MultiLangEnumBridge("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968", "InvoiceType_5", "imc-bdm-common"), "3", "", "04"),
    PAPER_SPECIAL_INVOICE(new MultiLangEnumBridge("\u7eb8\u8d28\u4e13\u7528\u53d1\u7968", "InvoiceType_6", "imc-bdm-common"), "004", "0", new MultiLangEnumBridge("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", "InvoiceType_7", "imc-bdm-common"), "4", "", "01"),
    PAPER_VOLUME_INVOICE(new MultiLangEnumBridge("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff08\u5377\u7968\uff09", "InvoiceType_8", "imc-bdm-common"), "025", "41", new MultiLangEnumBridge("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff08\u5377\u7968\uff09", "InvoiceType_9", "imc-bdm-common"), "5", "", "11"),
    PAPER_VEHICLE_INVOICE(new MultiLangEnumBridge("\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", "InvoiceType_10", "imc-bdm-common"), "006", "12", new MultiLangEnumBridge("\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", "InvoiceType_11", "imc-bdm-common"), "12", "", "03"),
    PAPER_USED_CAR_INVOICE(new MultiLangEnumBridge("\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", "InvoiceType_21", "imc-bdm-common"), "036", "12", new MultiLangEnumBridge("\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", "InvoiceType_21", "imc-bdm-common"), "13", "", "03"),
    ALL_E_SPECIAL(new MultiLangEnumBridge("\u6570\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09", "InvoiceType_12", "imc-bdm-common"), "08xdp", "27", new MultiLangEnumBridge("\u6570\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09", "InvoiceType_13", "imc-bdm-common"), "27", "01", "81"),
    ALL_E_NORMAL(new MultiLangEnumBridge("\u6570\u7535\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", "InvoiceType_14", "imc-bdm-common"), "10xdp", "26", new MultiLangEnumBridge("\u6570\u7535\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", "InvoiceType_15", "imc-bdm-common"), "26", "02", "82"),
    ALL_E_PAPER_USED_CAR(new MultiLangEnumBridge("\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff08\u6570\u7535\u7eb8\u7968\uff09", "InvoiceType_18", "imc-bdm-common"), "51xdp", "", new MultiLangEnumBridge("\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff08\u6570\u7535\u7eb8\u7968\uff09", "InvoiceType_18", "imc-bdm-common"), "13", "", ""),
    ALL_E_VEHICLE_NORMAL(new MultiLangEnumBridge("\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff08\u6570\u7535\u7eb8\u7968\uff09", "InvoiceType_16", "imc-bdm-common"), "06xdp", "", new MultiLangEnumBridge("\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff08\u6570\u7535\u7eb8\u7968\uff09", "InvoiceType_16", "imc-bdm-common"), "12", "", ""),
    ALL_E_PAPER_USED_CAR_ELE(new MultiLangEnumBridge("\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff08\u6570\u7535\u7535\u7968\uff09", "InvoiceType_20", "imc-bdm-common"), "84xdp", "", new MultiLangEnumBridge("\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff08\u6570\u7535\u7535\u7968\uff09", "InvoiceType_20", "imc-bdm-common"), "84", "", ""),
    ALL_E_VEHICLE_NORMAL_ELE(new MultiLangEnumBridge("\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff08\u6570\u7535\u7535\u7968\uff09", "InvoiceType_19", "imc-bdm-common"), "83xdp", "", new MultiLangEnumBridge("\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff08\u6570\u7535\u7535\u7968\uff09", "InvoiceType_19", "imc-bdm-common"), "83", "", "");

    private MultiLangEnumBridge bridge;
    private final String typeCode;
    private final String typeCodeHx;
    private MultiLangEnumBridge invoiceBridge;
    private final String baseCode;
    private final String lqptCode;
    private final String rimLqptCode;
    public static final String[] VehicleTypeCodes;

    private InvoiceType(MultiLangEnumBridge bridge, String typeCode, String typeCodeHx, MultiLangEnumBridge invoiceBridge, String baseCode, String lqptCode, String rimLqptCode) {
        this.bridge = bridge;
        this.typeCode = typeCode;
        this.typeCodeHx = typeCodeHx;
        this.invoiceBridge = invoiceBridge;
        this.baseCode = baseCode;
        this.lqptCode = lqptCode;
        this.rimLqptCode = rimLqptCode;
    }

    public String getRimLqptCode() {
        return this.rimLqptCode;
    }

    public static String getInvoiceTypeCodeByBaseCode(String baseCode) {
        for (InvoiceType c : InvoiceType.values()) {
            if (!c.baseCode.equals(baseCode)) continue;
            return c.typeCode;
        }
        return null;
    }

    public static String getBaseCodeByInvoiceTypeCode(String typeCode) {
        for (InvoiceType c : InvoiceType.values()) {
            if (!c.getTypeCode().equals(typeCode)) continue;
            return c.baseCode;
        }
        return null;
    }

    public static String getDescription(String typeCode) {
        for (InvoiceType c : InvoiceType.values()) {
            if (!c.getTypeCode().equals(typeCode)) continue;
            return c.bridge.loadKDString();
        }
        return null;
    }

    public static String getInvoiceDescription(String typeCode) {
        for (InvoiceType c : InvoiceType.values()) {
            if (!c.getTypeCode().equals(typeCode)) continue;
            return c.invoiceBridge.loadKDString();
        }
        return null;
    }

    public static String getTypeCodeHx(String typeCode) {
        for (InvoiceType c : InvoiceType.values()) {
            if (!c.getTypeCode().equals(typeCode)) continue;
            return c.typeCodeHx;
        }
        return null;
    }

    @SdkDeprecated
    public static String getCodeByDesc(String desc) {
        for (InvoiceType value : InvoiceType.values()) {
            if (!value.getDescription().equals(desc)) continue;
            return value.typeCode;
        }
        return "";
    }

    public static String getLqptCodeByTypeCode(String typeCode) {
        for (InvoiceType value : InvoiceType.values()) {
            if (!value.getTypeCode().equals(typeCode)) continue;
            return value.lqptCode;
        }
        return "";
    }

    public static String getRimLqptCodeByTypeCode(String typeCode) {
        for (InvoiceType value : InvoiceType.values()) {
            if (!value.getTypeCode().equals(typeCode)) continue;
            return value.rimLqptCode;
        }
        return "";
    }

    public static String getTypeCodeByBase(String baseCode) {
        for (InvoiceType c : InvoiceType.values()) {
            if (!c.getBaseCode().equals(baseCode)) continue;
            return c.getTypeCode();
        }
        return "";
    }

    @SdkDeprecated
    public static String getInvoiceDesc(String typeCode) {
        for (InvoiceType value : InvoiceType.values()) {
            if (!StringUtils.equals((CharSequence)typeCode, (CharSequence)value.getTypeCode())) continue;
            return value.invoiceBridge.loadKDString();
        }
        return "";
    }

    public static String blueTypeToAllEType(String originalInvoiceType) {
        if (StringUtils.equals((CharSequence)originalInvoiceType, (CharSequence)InvoiceType.ALL_E_NORMAL.typeCode) || StringUtils.equals((CharSequence)originalInvoiceType, (CharSequence)InvoiceType.ALL_E_SPECIAL.typeCode)) {
            return originalInvoiceType;
        }
        if (StringUtils.equals((CharSequence)originalInvoiceType, (CharSequence)InvoiceType.ELECTRICAL_NORMAL_INVOICE.typeCode) || StringUtils.equals((CharSequence)originalInvoiceType, (CharSequence)InvoiceType.PAPER_NOMAL_INVOICE.typeCode)) {
            return InvoiceType.ALL_E_NORMAL.typeCode;
        }
        if (StringUtils.equals((CharSequence)originalInvoiceType, (CharSequence)InvoiceType.ELECTRICAL_SPECIAL_INVOICE.typeCode) || StringUtils.equals((CharSequence)originalInvoiceType, (CharSequence)InvoiceType.PAPER_SPECIAL_INVOICE.typeCode)) {
            return InvoiceType.ALL_E_SPECIAL.typeCode;
        }
        return null;
    }

    public static boolean checkIsTaxInvoice(String invoiceType) {
        return ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(invoiceType) || ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) || PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType) || PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) || PAPER_VOLUME_INVOICE.getTypeCode().equals(invoiceType) || PAPER_VEHICLE_INVOICE.getTypeCode().equals(invoiceType);
    }

    public String getTypeCodeHx() {
        return this.typeCodeHx;
    }

    @SdkDeprecated
    public String getDescription() {
        return this.bridge.loadKDString();
    }

    @SdkDeprecated
    public String getTypeCode() {
        return this.typeCode;
    }

    public String getBaseCode() {
        return this.baseCode;
    }

    public String getLqptCode() {
        return this.lqptCode;
    }

    public static String matchRimLqCodeFromBaseCode(String baseCode) {
        for (InvoiceType value : InvoiceType.values()) {
            if (!value.getBaseCode().equals(baseCode)) continue;
            return value.getRimLqptCode();
        }
        return "";
    }

    static {
        VehicleTypeCodes = new String[]{ALL_E_VEHICLE_NORMAL.getTypeCode(), ALL_E_VEHICLE_NORMAL_ELE.getTypeCode()};
    }
}

