/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.constant;

import java.math.BigDecimal;
import kd.bos.dataentity.utils.StringUtils;

public enum TaxRate {
    ZERO_PERCENT("0", "zeropercent", new BigDecimal("0")),
    ONE_PERCENT("0.01", "onepercent", new BigDecimal("0.01")),
    ONE_POINT_FIVE_PERCENT("0.015", "onepointfivepercent", new BigDecimal("0.015")),
    TWO_PERCENT("0.02", "twopercent", new BigDecimal("0.02")),
    THREE_PERCENT("0.03", "threepercent", new BigDecimal("0.03")),
    FOUR_PERCENT("0.04", "fourpercent", new BigDecimal("0.04")),
    FIVE_PERCENT("0.05", "fivepercent", new BigDecimal("0.05")),
    SIX_PERCENT("0.06", "sixpercent", new BigDecimal("0.06")),
    NINE_PERCENT("0.09", "ninepercent", new BigDecimal("0.09")),
    TEN_PERCENT("0.10", "tenpercent", new BigDecimal("0.10")),
    ELEVEN_PERCENT("0.11", "elevenpercent", new BigDecimal("0.11")),
    THIRTEEN_PERCENT("0.13", "thirteenpercent", new BigDecimal("0.13")),
    SIXTEEN_PERCENT("0.16", "sixteenpercent", new BigDecimal("0.16")),
    SEVENTEEN_PERCENT("0.17", "seventeenpercent", new BigDecimal("0.17"));

    private String rateValue;
    private String description;
    private BigDecimal numValue;

    private TaxRate(String rate, String description, BigDecimal numValue) {
        this.rateValue = rate;
        this.description = description;
        this.numValue = numValue;
    }

    public static String getRateStr(BigDecimal rate) {
        if (null == rate) {
            return "";
        }
        for (TaxRate value : TaxRate.values()) {
            if (value.getNumValue().compareTo(rate) != 0) continue;
            return value.getRateValue();
        }
        return "";
    }

    public static boolean isStandardTaxRateStr(String inputTaxRate) {
        if (StringUtils.isBlank((CharSequence)inputTaxRate)) {
            return false;
        }
        for (TaxRate value : TaxRate.values()) {
            if (!inputTaxRate.equals(value.getRateValue())) continue;
            return true;
        }
        return false;
    }

    public static String standardTaxRateDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TaxRate value : TaxRate.values()) {
            stringBuilder.append('[').append(value.getRateValue()).append(']');
        }
        return stringBuilder.toString();
    }

    public String getRateValue() {
        return this.rateValue;
    }

    public String getDescription() {
        return this.description;
    }

    public BigDecimal getNumValue() {
        return this.numValue;
    }
}

