/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.constant.table;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import kd.imc.bdm.common.constant.MultiLangEnumBridge;
import kd.imc.bdm.common.constant.table.RiskControlConfigConstant;

public enum RiskControlRangeEnum {
    SIM_ORIGINAL_BILL("sim_original_bill", "sim_original_bill_item", new MultiLangEnumBridge("\u5f00\u7968\u7533\u8bf7\u5355", "RiskControlRangeEnum_0", "imc-bdm-common"), RiskControlConfigConstant.FILTER_SIM_ORIGINAL_BILL, RiskControlConfigConstant.RECORD_MAP_SIM_ORIGINAL_BILL),
    SIM_INVOICE_WAIT("sim_invoice_wait", "items", new MultiLangEnumBridge("\u5f85\u5f00\u53d1\u7968", "RiskControlRangeEnum_1", "imc-bdm-common"), RiskControlConfigConstant.FILTER_SIM_INVOICE_WAIT, RiskControlConfigConstant.RECORD_MAP_INVOICE),
    SIM_VAT_INVOICE("sim_vatinvoice", "items", new MultiLangEnumBridge("\u5355\u5f20\u5f00\u7968", "RiskControlRangeEnum_2", "imc-bdm-common"), RiskControlConfigConstant.FILTER_SIM_VAT_INVOICE, RiskControlConfigConstant.RECORD_MAP_INVOICE),
    SIM_RED_CONFIRM_BILL("sim_red_confirm_bill", "items", new MultiLangEnumBridge("\u7ea2\u5b57\u786e\u8ba4\u5355", "RiskControlRangeEnum_3", "imc-bdm-common"), RiskControlConfigConstant.FILTER_SIM_VAT_INVOICE, RiskControlConfigConstant.RECORD_MAP_RED_CONFIRM_BILL),
    SIM_RED_INFO("sim_red_info", "items", new MultiLangEnumBridge("\u7ea2\u5b57\u4fe1\u606f\u8868", "RiskControlRangeEnum_4", "imc-bdm-common"), RiskControlConfigConstant.FILTER_SIM_VAT_INVOICE, RiskControlConfigConstant.RECORD_MAP_RED_INFO);

    public static final ImmutableSet<RiskControlRangeEnum> BLACK_LIST_RANGE_ENUM;
    public static final ImmutableSet<RiskControlRangeEnum> TAXRATE_ENUM;
    public static final ImmutableSet<RiskControlRangeEnum> ANTI_REPLAY_RANGE_ENUM;
    private final String formId;
    private final String itemId;
    private final MultiLangEnumBridge bridge;
    private final ImmutableSet<String> filterSet;
    private final ImmutableMap<String, String> recordMap;

    public String getFormId() {
        return this.formId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getDesc() {
        return this.bridge.loadKDString();
    }

    public ImmutableSet<String> getFilterSet() {
        return this.filterSet;
    }

    public ImmutableMap<String, String> getRecordMap() {
        return this.recordMap;
    }

    private RiskControlRangeEnum(String formId, String itemId, MultiLangEnumBridge bridge, ImmutableSet<String> filterSet, ImmutableMap<String, String> recordMap) {
        this.formId = formId;
        this.itemId = itemId;
        this.bridge = bridge;
        this.filterSet = filterSet;
        this.recordMap = recordMap;
    }

    public static RiskControlRangeEnum getRiskControlRangeEnumByFormId(String formId) {
        for (RiskControlRangeEnum riskControlRangeEnum : RiskControlRangeEnum.values()) {
            if (!riskControlRangeEnum.getFormId().equals(formId)) continue;
            return riskControlRangeEnum;
        }
        return null;
    }

    static {
        BLACK_LIST_RANGE_ENUM = new ImmutableSet.Builder().add((Object[])new RiskControlRangeEnum[]{SIM_ORIGINAL_BILL, SIM_INVOICE_WAIT, SIM_VAT_INVOICE}).add((Object[])new RiskControlRangeEnum[]{SIM_RED_CONFIRM_BILL, SIM_RED_INFO}).build();
        TAXRATE_ENUM = new ImmutableSet.Builder().add((Object[])new RiskControlRangeEnum[]{SIM_ORIGINAL_BILL, SIM_INVOICE_WAIT, SIM_VAT_INVOICE}).build();
        ANTI_REPLAY_RANGE_ENUM = new ImmutableSet.Builder().add((Object[])new RiskControlRangeEnum[]{SIM_ORIGINAL_BILL, SIM_INVOICE_WAIT, SIM_VAT_INVOICE}).build();
    }
}

