/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.dto.allele.AllEleActiveProcessDTO;
import kd.imc.bdm.common.dto.allele.AllEleInfoDTO;
import kd.imc.bdm.common.dto.allele.AllEleQueryEpinfoDTO;
import kd.imc.bdm.common.dto.allele.TenantAuthDTO;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.util.IsmcToken;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.AES128;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AllEleAuthHelper {
    public static final String queryTenantAuthUrl = "/trdPlatform/digital/query/tenant/by/code";
    public static final String queryActivedCompanyUrl = "/trdPlatform/digital/query/activate/company";
    public static final String updateTaxNoDefaultAccount = "/m28/bill/digital/update/default";
    public static final String platformClientId = "PLT_kZXHgUhlCUHYygD3";
    public static final String platformClientSecret = "b810ef9ca5a74f3fa5e36097fd3f1621";
    public static final String issueElePaper = "1";
    private static Log LOGGER = LogFactory.getLog(AllEleAuthHelper.class);

    public static AllEleActiveProcessDTO saveAuthAndEpInfo(String code) {
        AllEleActiveProcessDTO process = new AllEleActiveProcessDTO();
        DynamicObject[] allAccounts = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_einvoice_account", true), null);
        AllEleAuthHelper.addIsAllEledEps(allAccounts);
        HashMap<String, TenantAuthDTO> authInfoMap = AllEleAuthHelper.queryAwsAuthInfo(code);
        HashMap<String, AllEleInfoDTO> authedEpMap = AllEleAuthHelper.queryAuthedEpFromDB();
        HashMap<String, DynamicObject> dbAccountMap = new HashMap<String, DynamicObject>();
        Arrays.stream(allAccounts).forEach(o -> dbAccountMap.put(o.getString("taxno"), (DynamicObject)o));
        int successNum = 0;
        HashMap<Object, DynamicObject> needUpdateAccountMap = new HashMap<Object, DynamicObject>();
        for (Map.Entry<String, TenantAuthDTO> entry : authInfoMap.entrySet()) {
            List<AllEleQueryEpinfoDTO> epInfos = AllEleAuthHelper.queryActivedEpInfo(entry.getValue().getClientId());
            LOGGER.info("epInfoFromAws:" + JSONObject.toJSONString((Object)entry.getValue()) + "onceNum:" + epInfos.size());
            if (epInfos.size() == 0) continue;
            AllEleAuthHelper.logEpInfo(epInfos);
            process.setTotalQueryNum(Integer.valueOf(process.getTotalQueryNum() + epInfos.size()));
            HashMap<String, Set<String>> queryedTaxNoAccountsMap = new HashMap<String, Set<String>>();
            AllEleAuthHelper.checkAuthed(epInfos, authedEpMap, process, queryedTaxNoAccountsMap);
            AllEleAuthHelper.removeErrorEpInfos(epInfos, process, queryedTaxNoAccountsMap);
            successNum = AllEleAuthHelper.saveOneQueryEpAccountInfo(successNum, dbAccountMap, epInfos, needUpdateAccountMap, entry.getValue(), process);
            HashMap<Object, DynamicObject> needUpdateTaxNoAccountMap = new HashMap<Object, DynamicObject>();
            for (DynamicObject accountInfo : needUpdateAccountMap.values()) {
                needUpdateTaxNoAccountMap.put(accountInfo.getString("taxno"), accountInfo);
            }
            AllEleAuthHelper.removeAccountItems(queryedTaxNoAccountsMap, needUpdateTaxNoAccountMap);
        }
        process.setSuccessNum(Integer.valueOf(successNum));
        if (needUpdateAccountMap.size() > 0) {
            AllEleAuthHelper.setDefaultBusiness(needUpdateAccountMap.values());
            SaveServiceHelper.save((DynamicObject[])needUpdateAccountMap.values().toArray(new DynamicObject[0]));
        }
        AllEleAuthHelper.logFailedInfo(process);
        return process;
    }

    private static void logFailedInfo(AllEleActiveProcessDTO process) {
        try {
            JSONObject json = new JSONObject();
            json.put("notEpNameTaxNoAuthed", (Object)process.getNotAuthedNameTaxNoEpInfos());
            json.put("currentListNotExistTaxNo", (Object)process.getNoExistTaxNoEpInfos());
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"invsm_botp_callback_log");
            log.set("createtime", (Object)new Date());
            log.set("business", (Object)issueElePaper);
            log.set("param_tag", (Object)json.toJSONString());
            log.set("invoiceno", (Object)"queryAccountLog");
            ImcSaveServiceHelper.save(log);
        }
        catch (Exception e) {
            LOGGER.error("addLogFail" + e.getMessage(), (Throwable)e);
        }
    }

    public static void logEpInfo(List<AllEleQueryEpinfoDTO> epInfos) {
        ArrayList list = Lists.newArrayListWithCapacity((int)20);
        int i = 0;
        for (AllEleQueryEpinfoDTO epInfo : epInfos) {
            list.add(epInfo);
            if (list.size() != 20) continue;
            LOGGER.info(String.format("\u67e5\u8be2\u7684\u4f01\u4e1a\u4fe1\u606f\u8bb0\u5f55\u65e5\u5fd7\u7b2c\uff1a%s\u90e8\u5206,epInfos:%s", i, JSONObject.toJSONString((Object)list)));
            list.clear();
            ++i;
        }
        LOGGER.info(String.format("\u67e5\u8be2\u7684\u4f01\u4e1a\u4fe1\u606f\u8bb0\u5f55\u65e5\u5fd7\u7b2c\uff1a%s\u90e8\u5206,epInfos:%s", i, JSONObject.toJSONString((Object)list)));
    }

    private static void removeAccountItems(Map<String, Set<String>> queryedTaxNoAccountsMap, HashMap<Object, DynamicObject> needUpdateAccountMap) {
        for (Map.Entry<String, Set<String>> entry : queryedTaxNoAccountsMap.entrySet()) {
            String taxNo = entry.getKey();
            Set<String> queryedAccounts = entry.getValue();
            if (!needUpdateAccountMap.containsKey(taxNo)) continue;
            DynamicObject accountObj = needUpdateAccountMap.get(taxNo);
            DynamicObjectCollection dbAccount = accountObj.getDynamicObjectCollection("entryentity");
            Iterator dbAccountIt = dbAccount.iterator();
            while (dbAccountIt.hasNext()) {
                DynamicObject items = (DynamicObject)dbAccountIt.next();
                String itemAccount = items.getString("account");
                if (!StringUtils.isNotBlank((CharSequence)itemAccount) || queryedAccounts.contains(itemAccount)) continue;
                LOGGER.info(String.format("taxNo:%s,deleteAccount:%s", taxNo, itemAccount));
                dbAccountIt.remove();
            }
        }
    }

    public static void setDefaultBusiness(Collection<DynamicObject> values) {
        for (DynamicObject accounts : values) {
            DynamicObjectCollection items = accounts.getDynamicObjectCollection("entryentity");
            int issueBusiness = 0;
            int inputBusiness = 0;
            if (items.size() <= 0) continue;
            for (DynamicObject item : items) {
                if (AllEleAuthHelper.isInputBusiness(item.getString("defaultbusiness"))) {
                    ++inputBusiness;
                }
                if (!AllEleAuthHelper.isOutputBusiness(item.getString("defaultbusiness"))) continue;
                ++issueBusiness;
            }
            if (issueBusiness == 0) {
                AllEleAuthHelper.randomAIssueBusiness(items);
            }
            if (inputBusiness != 0) continue;
            AllEleAuthHelper.randomAInputBusiness(items);
        }
    }

    public static void randomAInputBusiness(DynamicObjectCollection items) {
        for (DynamicObject item : items) {
            if ("2".equals(item.getString("accounttype"))) {
                item.set("defaultbusiness", (Object)"2");
                return;
            }
            if (!"3".equals(item.getString("accounttype"))) continue;
            if (issueElePaper.equals(item.getString("defaultbusiness"))) {
                item.set("defaultbusiness", (Object)"3");
            } else {
                item.set("defaultbusiness", (Object)"2");
            }
            return;
        }
    }

    public static void randomAIssueBusiness(DynamicObjectCollection items) {
        for (DynamicObject item : items) {
            if (issueElePaper.equals(item.getString("accounttype"))) {
                item.set("defaultbusiness", (Object)issueElePaper);
                return;
            }
            if (!"3".equals(item.getString("accounttype"))) continue;
            if ("2".equals(item.getString("defaultbusiness"))) {
                item.set("defaultbusiness", (Object)"3");
            } else {
                item.set("defaultbusiness", (Object)issueElePaper);
            }
            return;
        }
    }

    private static HashMap<String, TenantAuthDTO> queryAwsAuthInfo(String code) {
        HashMap<String, TenantAuthDTO> authInfoMap = new HashMap<String, TenantAuthDTO>();
        HashSet<String> clientIdSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            TenantAuthDTO authInfo = AllEleAuthHelper.queryAuthInfo(code);
            authInfoMap.put(authInfo.getTenantNo(), authInfo);
        } else {
            Map<String, String> awsConfigMap = ImcConfigUtil.getValue("ALL_E_AWS_CONFIG");
            String dbClientId = null;
            if (AllEleAuthHelper.isTenantAuthed()) {
                dbClientId = AllEleAuthHelper.invsmConfigAuthInfo(authInfoMap, clientIdSet, awsConfigMap, dbClientId);
            }
            AllEleAuthHelper.accountListAuthInfo(authInfoMap, clientIdSet, dbClientId);
        }
        return authInfoMap;
    }

    public static boolean isListExistAuthInfo() {
        QFilter filter = new QFilter("clientid", "!=", null);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_einvoice_account"), (QFilter[])filter.toArray());
        return accounts.length > 0;
    }

    private static void accountListAuthInfo(HashMap<String, TenantAuthDTO> authInfoMap, HashSet<String> clientIdSet, String dbClientId) {
        DynamicObject[] accounts;
        QFilter filter = new QFilter("clientid", "!=", null);
        if (StringUtils.isNotBlank((CharSequence)dbClientId)) {
            filter = filter.and(new QFilter("clientid", "!=", (Object)dbClientId));
        }
        for (DynamicObject account : accounts = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_einvoice_account"), (QFilter[])filter.toArray())) {
            String clientId = account.getString("clientid");
            if (!StringUtils.isNotBlank((CharSequence)clientId) || clientIdSet.contains(clientId)) continue;
            TenantAuthDTO accountInfo = new TenantAuthDTO();
            String clientSecret = account.getString("clientsecret");
            String encKey = account.getString("encryptkey");
            String tenantName = account.getString("tenantname");
            String tenantNo = account.getString("tenantno");
            accountInfo.setClientSecret(clientSecret);
            accountInfo.setEncKey(encKey);
            accountInfo.setTenantName(tenantName);
            accountInfo.setTenantNo(tenantNo);
            accountInfo.setClientId(clientId);
            authInfoMap.put(tenantNo, accountInfo);
        }
    }

    public static String invsmConfigAuthInfo(HashMap<String, TenantAuthDTO> authInfoMap, HashSet<String> clientIdSet, Map<String, String> awsConfigMap, String dbClientId) {
        if (null != awsConfigMap && StringUtils.isNotBlank((CharSequence)awsConfigMap.get("client_id"))) {
            TenantAuthDTO dbInfo = new TenantAuthDTO();
            dbInfo.setClientId(awsConfigMap.get("client_id"));
            dbClientId = awsConfigMap.get("client_id");
            dbInfo.setClientSecret(awsConfigMap.get("client_secret"));
            dbInfo.setEncKey(awsConfigMap.get("encrypt_key"));
            dbInfo.setTenantName(awsConfigMap.get("tenant_name"));
            dbInfo.setTenantNo(awsConfigMap.get("tenant_no"));
            clientIdSet.add(dbClientId);
            authInfoMap.put(awsConfigMap.get("tenant_no"), dbInfo);
        }
        return dbClientId;
    }

    private static HashMap<String, AllEleInfoDTO> queryAuthedEpFromDB() {
        QFilter filter = new QFilter("authstate", "=", (Object)issueElePaper);
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_invoice_permission", (String)"epinfo", (QFilter[])filter.toArray());
        HashMap<String, AllEleInfoDTO> authedEpMap = new HashMap<String, AllEleInfoDTO>();
        for (DynamicObject permission : array) {
            DynamicObject epinfo = permission.getDynamicObject("epinfo");
            if (null == epinfo) continue;
            String name = epinfo.getString("name");
            String taxNo = epinfo.getString("number");
            if (authedEpMap.containsKey(name + taxNo)) continue;
            AllEleInfoDTO info = new AllEleInfoDTO();
            info.setSalerName(name);
            info.setTaxNo(taxNo);
            info.setEpInfoPk(Long.valueOf(epinfo.getLong("id")));
            authedEpMap.put(name + taxNo, info);
        }
        return authedEpMap;
    }

    public static int saveOneQueryEpAccountInfo(int successNum, HashMap<String, DynamicObject> dbAccountMap, List<AllEleQueryEpinfoDTO> epInfos, HashMap<Object, DynamicObject> needUpdateAccountMap, TenantAuthDTO tenantInfo, AllEleActiveProcessDTO process) {
        List noExistTaxNoEpInfos = process.getNoExistTaxNoEpInfos();
        int successNumCount = 0;
        for (AllEleQueryEpinfoDTO epInfo : epInfos) {
            String taxNo = epInfo.getTaxNo();
            String accountUid = epInfo.getLoginAccountUid();
            if (StringUtils.isBlank((CharSequence)accountUid)) {
                LOGGER.info(String.format("AllEleEpInfo:%s,\u7a0e\u53f7\u672a\u8fd4\u56de\u6570\u7535\u8d26\u53f7:%s", SerializationUtils.toJsonString((Object)epInfo), taxNo));
            } else {
                LOGGER.info(String.format("AllEleEpInfo:%s", SerializationUtils.toJsonString((Object)epInfo)));
            }
            String cityName = epInfo.getCityName();
            boolean isContainsTaxNo = dbAccountMap.containsKey(taxNo);
            if (isContainsTaxNo) {
                LOGGER.info(String.format("tenantName:%s,successTaxNo:%s,succeessIndex:%s", tenantInfo.getTenantName(), taxNo, ++successNumCount));
                DynamicObject accountInfo = dbAccountMap.get(taxNo);
                DynamicObjectCollection accounts = accountInfo.getDynamicObjectCollection("entryentity");
                boolean isContainsAccount = false;
                if (CollectionUtils.isEmpty((Collection)accounts)) {
                    AllEleAuthHelper.updateDbMainAccount(tenantInfo, epInfo, accountInfo);
                } else {
                    Iterator accountItemsIt = accounts.iterator();
                    while (accountItemsIt.hasNext()) {
                        DynamicObject account = (DynamicObject)accountItemsIt.next();
                        String allEleAccount = account.getString("account");
                        if (Objects.equals(allEleAccount, accountUid) && StringUtils.isNotBlank((CharSequence)allEleAccount)) {
                            isContainsAccount = true;
                            AllEleAuthHelper.updateDbMainAccount(tenantInfo, epInfo, accountInfo);
                            AllEleAuthHelper.updateAccount(account, epInfo);
                        }
                        if (!StringUtils.isBlank((CharSequence)allEleAccount)) continue;
                        accountItemsIt.remove();
                    }
                }
                accountInfo.set("modifytime", (Object)new Date());
                ++successNum;
                if (!isContainsAccount && StringUtils.isNotBlank((CharSequence)accountUid)) {
                    AllEleAuthHelper.addNewAccount(tenantInfo, epInfo, accountUid, cityName, accountInfo, accounts);
                }
                needUpdateAccountMap.put(accountInfo.getPkValue(), accountInfo);
                continue;
            }
            noExistTaxNoEpInfos.add(epInfo);
            LOGGER.info(String.format("\u6570\u7535\u5347\u7ea7\u5217\u8868\u65e0\u6b64\u7a0e\u53f7:%s", SerializationUtils.toJsonString((Object)epInfo)));
        }
        return successNum;
    }

    private static void updateAccount(DynamicObject account, AllEleQueryEpinfoDTO epInfo) {
        account.set("accounttype", (Object)epInfo.geteTaxAccountType());
        account.set("isdefault", (Object)String.valueOf(epInfo.getDefaultFlag()));
        account.set("drawer", (Object)epInfo.getDrawer());
        AllEleAuthHelper.setDefaultBusiness(account, epInfo);
        if (StringUtils.isBlank((CharSequence)account.getString("logintype"))) {
            account.set("logintype", (Object)issueElePaper);
        }
        String channelType = StringUtils.isBlank((CharSequence)epInfo.getChannelType()) ? issueElePaper : epInfo.getChannelType();
        account.set("channeltype", (Object)channelType);
    }

    private static void setDefaultBusiness(DynamicObject account, AllEleQueryEpinfoDTO epInfo) {
        int NoBusiness = 0;
        if (null == epInfo.getDefaultType() || NoBusiness == epInfo.getDefaultType()) {
            account.set("defaultbusiness", null);
        } else {
            account.set("defaultbusiness", (Object)String.valueOf(epInfo.getDefaultType()));
        }
    }

    private static void addNewAccount(TenantAuthDTO tenantInfo, AllEleQueryEpinfoDTO epInfo, String accountUid, String cityName, DynamicObject accountInfo, DynamicObjectCollection accounts) {
        DynamicObject newAccount = accounts.addNew();
        newAccount.set("account", (Object)accountUid);
        newAccount.set("isenable", (Object)issueElePaper);
        newAccount.set("accounttype", (Object)epInfo.geteTaxAccountType());
        String channelType = StringUtils.isBlank((CharSequence)epInfo.getChannelType()) ? issueElePaper : epInfo.getChannelType();
        newAccount.set("channeltype", (Object)channelType);
        newAccount.set("drawer", (Object)(null == epInfo.getDrawer() ? "" : epInfo.getDrawer()));
        newAccount.set("logintype", (Object)issueElePaper);
        newAccount.set("isdefault", (Object)String.valueOf(epInfo.getDefaultFlag()));
        AllEleAuthHelper.setDefaultBusiness(newAccount, epInfo);
        accountInfo.set("modifytime", (Object)new Date());
        accountInfo.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        accountInfo.set("cityname", (Object)cityName);
        accountInfo.set("companyouno", (Object)epInfo.getCompanyOuNo());
        accountInfo.set("clientid", (Object)tenantInfo.getClientId());
        accountInfo.set("clientsecret", (Object)tenantInfo.getClientSecret());
        accountInfo.set("encryptkey", (Object)tenantInfo.getEncKey());
        accountInfo.set("tenantname", (Object)tenantInfo.getTenantName());
        accountInfo.set("tenantno", (Object)tenantInfo.getTenantNo());
    }

    private static void updateDbMainAccount(TenantAuthDTO tenantInfo, AllEleQueryEpinfoDTO epInfo, DynamicObject accountInfo) {
        if (StringUtils.isBlank((CharSequence)accountInfo.getString("companyouno"))) {
            accountInfo.set("companyouno", (Object)epInfo.getCompanyOuNo());
        }
        if (StringUtils.isBlank((CharSequence)accountInfo.getString("clientid"))) {
            accountInfo.set("clientid", (Object)(StringUtils.isNotBlank((CharSequence)epInfo.getClientId()) ? epInfo.getClientId() : tenantInfo.getClientId()));
        }
        if (StringUtils.isBlank((CharSequence)accountInfo.getString("clientsecret"))) {
            accountInfo.set("clientsecret", (Object)(StringUtils.isNotBlank((CharSequence)epInfo.getClientSecret()) ? epInfo.getClientSecret() : tenantInfo.getClientSecret()));
        }
        if (StringUtils.isBlank((CharSequence)accountInfo.getString("encryptkey"))) {
            accountInfo.set("encryptkey", (Object)tenantInfo.getEncKey());
        }
        if (StringUtils.isBlank((CharSequence)accountInfo.getString("tenantno"))) {
            accountInfo.set("tenantno", (Object)tenantInfo.getTenantNo());
        }
        if (StringUtils.isBlank((CharSequence)accountInfo.getString("tenantname"))) {
            accountInfo.set("tenantname", (Object)tenantInfo.getTenantName());
        }
    }

    private static void addIsAllEledEps(DynamicObject[] allAccounts) {
        String isMarkEle = issueElePaper;
        QFilter filter = new QFilter("isallele", "=", (Object)isMarkEle);
        DynamicObject[] eleEpInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"", (QFilter[])filter.toArray());
        Set taxNoSet = Arrays.stream(allAccounts).map(o -> o.getString("taxno")).collect(Collectors.toSet());
        ArrayList<DynamicObject> needAddEps = new ArrayList<DynamicObject>();
        for (DynamicObject eleEpInfo : eleEpInfos) {
            String taxNo = eleEpInfo.getString("number");
            if (!StringUtils.isNotBlank((CharSequence)taxNo) || taxNoSet.contains(taxNo)) continue;
            needAddEps.add(eleEpInfo);
        }
        ArrayList<DynamicObject> addAccounts = new ArrayList<DynamicObject>();
        for (DynamicObject ep : needAddEps) {
            addAccounts.add(AllEleAuthHelper.newEleAccount(ep));
        }
        SaveServiceHelper.save((DynamicObject[])addAccounts.toArray(new DynamicObject[0]));
    }

    private static void checkAuthed(List<AllEleQueryEpinfoDTO> epInfos, HashMap<String, AllEleInfoDTO> authedEpMap, AllEleActiveProcessDTO process, Map<String, Set<String>> queryedTaxNoAccountsMap) {
        Iterator<AllEleQueryEpinfoDTO> it = epInfos.iterator();
        HashSet errorTaxNos = process.getErrorTaxNos();
        List notAuthedInfo = process.getNotAuthedNameTaxNoEpInfos();
        HashSet processNotAuthedTaxNos = process.getNotAuthedTaxNos();
        while (it.hasNext()) {
            boolean isEpAuthed;
            AllEleQueryEpinfoDTO currentDto = it.next();
            String epName = currentDto.getEpName();
            String taxNo = currentDto.getTaxNo();
            Set accountSet = queryedTaxNoAccountsMap.computeIfAbsent(taxNo, k -> new HashSet());
            String loginAccountUid = currentDto.getLoginAccountUid();
            if (StringUtils.isNotBlank((CharSequence)loginAccountUid)) {
                accountSet.add(loginAccountUid);
            }
            if (!(isEpAuthed = authedEpMap.containsKey(epName + taxNo))) {
                errorTaxNos.add(taxNo);
                processNotAuthedTaxNos.add(taxNo);
                notAuthedInfo.add(currentDto);
            }
            LOGGER.info(String.format("epInfos:%s,\u662f\u5426\u7a0e\u53f7\u8fdb\u884c\u4e86\u8bb8\u53ef\u6388\u6743\uff1a%s", JSONObject.toJSONString((Object)currentDto), isEpAuthed));
        }
    }

    public static MsgResponse sendAuthEmail(String email, List<String> taxNoList) {
        LOGGER.info("sendAuthEmail");
        MsgResponse response = new MsgResponse();
        response.setErrorCode(ErrorType.FAIL.getCode());
        try {
            boolean isDebug = "debugOpenInvoice".equals(ImcConfigUtil.getValue("debugOpenInvoice", "debugOpenInvoice"));
            String proLable = "";
            if (!isDebug) {
                proLable = "_Pro";
            }
            Map<String, String> paramMap = ImcConfigUtil.getValue("Operation_Platform_Config" + proLable);
            LOGGER.info(String.format("Operation_Platform_ConfigparmaMap:%s", JSONObject.toJSONString(paramMap)));
            String baseUrl = paramMap.get("operationPlatformBaseUrl");
            String proxyUrl = paramMap.get("operationPlatformBaseUrl_proxy");
            String accessToken = AllEleAuthHelper.getOperationPlateformAccessToken(paramMap, baseUrl, proxyUrl);
            String url = baseUrl + "/kapi/app/ocm/OcmGetEmail?access_token=" + accessToken;
            JSONObject json = new JSONObject();
            json.put("sendEmail", (Object)email);
            JSONArray taxNoJsonList = new JSONArray();
            for (String taxNo : taxNoList) {
                JSONObject taxNoJson = new JSONObject();
                taxNoJson.put("taxNo", (Object)taxNo);
                taxNoJsonList.add((Object)taxNoJson);
            }
            json.put("taxNoList", (Object)taxNoJsonList);
            JSONObject param = new JSONObject();
            param.put("opType", (Object)"notice_activate_email");
            param.put("content", (Object)json);
            String reqStr = param.toJSONString();
            LOGGER.info(String.format("url:%s,param:%s", url, reqStr));
            AllEleAuthHelper.postOperationPlateform(response, url, proxyUrl, reqStr);
        }
        catch (KDBizException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.setErrorMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.setErrorMsg(String.format(ResManager.loadKDString((String)"\u53d1\u9001\u6fc0\u6d3b\u90ae\u7bb1\u5931\u8d25\uff1a%1$s", (String)"AllEleAuthHelper_27", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage()));
        }
        return response;
    }

    private static String getOperationPlateformAccessToken(Map<String, String> paramMap, String baseUrl, String proxyUrl) {
        String accessToken = CacheHelper.get("operationPlatformAccessToken");
        if (StringUtils.isNotBlank((CharSequence)accessToken) && !"null".equalsIgnoreCase(accessToken)) {
            return accessToken;
        }
        String appid = paramMap.get("appid");
        String appSecret = paramMap.get("appSecret");
        String accountId = paramMap.get("accountId");
        String user = paramMap.get("user");
        accessToken = UnitTestHelper.isUnitTest() ? "unittestToken" : IsmcToken.login(baseUrl, proxyUrl, appid, appSecret, accountId, user, "");
        LOGGER.info("operationPlatformAccessToken:" + accessToken);
        CacheHelper.put("operationPlatformAccessToken", accessToken, 60);
        return accessToken;
    }

    private static void postOperationPlateform(MsgResponse response, String url, String proxyUrl, String reqStr) throws IOException {
        String respStr = UnitTestHelper.isUnitTest() ? "{\n    \"data\":[\n        \"3232@qq.com\"\n    ],\n    \"message\":\"success\",\n    \"errorCode\":\"0000\",\n    \"status\":true,\n    \"success\":true\n}" : HttpUtil.doPostJson(url, proxyUrl, null, reqStr, 50000, 50000);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("response:%s", respStr));
        }
        JSONObject result = JSONObject.parseObject((String)respStr);
        response.setErrorCode(result.getString("errorCode"));
        response.setErrorMsg(result.getString("message"));
    }

    public static List<AllEleQueryEpinfoDTO> queryActivedEpInfo(String tenantClientId) {
        try {
            Map<String, String> headers = AllEleAuthHelper.getPlatformAuthorizationHeader();
            JSONObject body = new JSONObject();
            body.put("clientId", (Object)tenantClientId);
            AwsFpyService awsConfig = AwsFpyService.newInstance();
            String baseUrl = awsConfig.getBaseUrl();
            String proxyUrl = awsConfig.getProxy();
            String url = baseUrl + queryActivedCompanyUrl + "?rightsClass=2&clientId=" + tenantClientId;
            LOGGER.info(String.format("queryActivedEpInfoUrl:%s,%s,%s", url, JSONObject.toJSONString(headers), body.toJSONString()));
            String response = UnitTestHelper.isUnitTest() ? "{}" : HttpUtil.doGet(url, proxyUrl, null, headers);
            LOGGER.info(String.format("queryActivedEpInfoResponse:%s", response));
            if (StringUtils.isBlank((CharSequence)response)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u79df\u6237\u6388\u6743\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,\u5730\u5740:%s", (String)"AllEleAuthHelper_7", (String)"imc-bdm-common", (Object[])new Object[0]), baseUrl));
            }
            JSONObject jsonResponse = JSONObject.parseObject((String)response);
            if (!ErrorType.SUCCESS.getCode().equals(jsonResponse.get((Object)"errcode"))) {
                throw new KDBizException(jsonResponse.getString("description"));
            }
            Object data = jsonResponse.get((Object)"data");
            if (StringUtils.isBlank((Object)data)) {
                return new ArrayList<AllEleQueryEpinfoDTO>();
            }
            JSONArray array = jsonResponse.getJSONArray("data");
            return JSONObject.parseArray((String)array.toJSONString(), AllEleQueryEpinfoDTO.class);
        }
        catch (KDBizException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5df2\u6fc0\u6d3b\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25:%s", (String)"AllEleAuthHelper_23", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public static TenantAuthDTO queryAuthInfo(String activeCode) {
        try {
            JSONObject body = new JSONObject();
            body.put("code", (Object)activeCode);
            Map<String, String> headers = AllEleAuthHelper.getPlatformAuthorizationHeader();
            AwsFpyService awsConfig = AwsFpyService.newInstance();
            String baseUrl = awsConfig.getBaseUrl();
            String proxy = awsConfig.getProxy();
            String url = baseUrl + queryTenantAuthUrl + "?code=" + activeCode;
            LOGGER.info(String.format("queryAuthInfoUrl:%s,%s,%s", url, JSONObject.toJSONString(headers), body.toJSONString()));
            String response = UnitTestHelper.isUnitTest() ? "{\n    \"data\":{\n        \"tenantNo\":\"%qIK\",\n        \"tenantName\":\"TdDn8\",\n        \"clientId\":\"FxyEe@\",\n        \"clientSecret\":\"QxHs35\",\n        \"encKey\":\"$)6yE@\"\n    },\n    \"description\":\"ZCu\",\n    \"errcode\":\"0000\"\n}" : HttpUtil.doGet(url, proxy, null, headers);
            LOGGER.info(String.format("queryAuthInfoUrlResponse:%s", response));
            if (StringUtils.isBlank((CharSequence)response)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u79df\u6237\u6388\u6743\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,\u5730\u5740:%s", (String)"AllEleAuthHelper_7", (String)"imc-bdm-common", (Object[])new Object[0]), baseUrl));
            }
            JSONObject jsonResponse = JSONObject.parseObject((String)response);
            if (!ErrorType.SUCCESS.getCode().equals(jsonResponse.get((Object)"errcode"))) {
                throw new KDBizException(jsonResponse.getString("description"));
            }
            JSONObject json = jsonResponse.getJSONObject("data");
            return (TenantAuthDTO)JSONObject.parseObject((String)json.toJSONString(), TenantAuthDTO.class);
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5931\u8d25:%s", (String)"AllEleAuthHelper_24", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public static Set<Long> needShowEpIdSet() {
        Set<Long> authedSet = AllEleAuthHelper.queryAuthedEpPkSet();
        Set<Long> permEpSet = AllEleAuthHelper.getUserHasPermEpPk();
        Set<Long> commonSet2 = AllEleAuthHelper.commonSet(authedSet, permEpSet);
        Set<Long> eleEpSet = AllEleAuthHelper.queryWithAllEleAccountEpInfoPk();
        return AllEleAuthHelper.needShowSet(commonSet2, eleEpSet);
    }

    private static Set<Long> needShowSet(Set<Long> commonSet, Set<Long> eleEpSet) {
        HashSet<Long> differSet = new HashSet<Long>();
        for (Long epPk : commonSet) {
            if (eleEpSet.contains(epPk)) continue;
            differSet.add(epPk);
        }
        return differSet;
    }

    public static Set<Long> commonSet(Set<Long> set1, Set<Long> set2) {
        HashSet<Long> commonSet = new HashSet<Long>();
        for (Long epPk : set1) {
            if (!set2.contains(epPk)) continue;
            commonSet.add(epPk);
        }
        return commonSet;
    }

    public static Map<String, String> getPlatformAuthorizationHeader() {
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String encryptData = "PLT_kZXHgUhlCUHYygD3b810ef9ca5a74f3fa5e36097fd3f1621" + timeStamp;
        String sign = DigestUtils.sha256Hex((String)encryptData);
        String rst = "SHA256 clientId=PLT_kZXHgUhlCUHYygD3,sign=" + sign + ",timestamp=" + timeStamp;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", rst);
        return headers;
    }

    public static boolean isTenantAuthed() {
        QFilter tenantAuthedByAWSFilter = new QFilter("config_type", "=", (Object)"ALL_E_AWS_CONFIG").and("config_key", "=", (Object)"TENANT_AUTHED").and("config_value", "=", (Object)issueElePaper);
        return QueryServiceHelper.exists((String)"invsm_param_configuration", (QFilter[])tenantAuthedByAWSFilter.toArray());
    }

    public static StringBuilder getTaxNoDescription(HashSet<String> notAuthedTaxNos) {
        StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"\u7a0e\u53f7", (String)"AllEleAuthHelper_29", (String)"imc-bdm-common", (Object[])new Object[0]));
        if (notAuthedTaxNos.size() == 1) {
            builder.append(notAuthedTaxNos.iterator().next());
        } else if (notAuthedTaxNos.size() > 0) {
            Iterator<String> taxNoIt = notAuthedTaxNos.iterator();
            int size = notAuthedTaxNos.size();
            int currentSize = 0;
            while (taxNoIt.hasNext()) {
                builder.append(taxNoIt.next());
                if (++currentSize == size) continue;
                builder.append('\u3001');
            }
        }
        return builder;
    }

    public static Set<Long> queryAuthedEpPkSet() {
        QFilter filter = new QFilter("servergroup", "in", (Object)new String[]{"0", issueElePaper});
        filter = filter.and("authstate", "=", (Object)issueElePaper);
        DynamicObject[] permission = BusinessDataServiceHelper.load((String)"bdm_invoice_permission", (String)"epinfo", (QFilter[])filter.toArray());
        HashSet<Long> epIdSet = new HashSet<Long>();
        for (DynamicObject invPermission : permission) {
            DynamicObject epInfo = invPermission.getDynamicObject("epinfo");
            if (null == epInfo) continue;
            epIdSet.add(epInfo.getLong("id"));
        }
        return epIdSet;
    }

    public static Set<Long> queryNotBasePlatEpInfoPk() {
        QFilter filter = new QFilter("isallele", "!=", (Object)issueElePaper);
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"id", (QFilter[])filter.toArray());
        HashSet<Long> notAllEleEpSet = new HashSet<Long>();
        for (DynamicObject epInfo : array) {
            notAllEleEpSet.add(epInfo.getLong("id"));
        }
        return notAllEleEpSet;
    }

    public static Set<Long> queryWithAllEleAccountEpInfoPk() {
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_einvoice_account", true), null);
        HashSet<Long> withEleEpPkSet = new HashSet<Long>();
        for (DynamicObject dynamicObject : array) {
            DynamicObject epInfo = dynamicObject.getDynamicObject("epinfo");
            DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("entryentity");
            if (null == epInfo || items.size() <= 0) continue;
            withEleEpPkSet.add(epInfo.getLong("id"));
        }
        return withEleEpPkSet;
    }

    public static Set<Long> getUserHasPermEpPk() {
        return OrgHelper.getUserHasPermEpPk();
    }

    private static void removeErrorEpInfos(List<AllEleQueryEpinfoDTO> epInfos, AllEleActiveProcessDTO process, Map<String, Set<String>> queryedTaxNoAccountsMap) {
        HashSet errorTaxNos = process.getErrorTaxNos();
        Iterator<AllEleQueryEpinfoDTO> it = epInfos.iterator();
        while (it.hasNext()) {
            AllEleQueryEpinfoDTO current = it.next();
            String taxNo = current.getTaxNo();
            if (!errorTaxNos.contains(taxNo)) continue;
            it.remove();
            queryedTaxNoAccountsMap.remove(taxNo);
        }
    }

    public static void markEnterpriseIsAllSendEmail(ArrayList<String> taxNoList) {
        QFilter filter = new QFilter("number", "in", (Object)taxNoList.toArray(new Object[0]));
        DynamicObject[] epArrays = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_enterprise_baseinfo", true), (QFilter[])filter.toArray());
        DynamicObject[] allAccounts = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)"taxno", null);
        Set taxNoSet = Arrays.stream(allAccounts).map(o -> o.getString("taxno")).collect(Collectors.toSet());
        ArrayList<DynamicObject> addAccounts = new ArrayList<DynamicObject>();
        if (epArrays.length > 0) {
            for (DynamicObject ep : epArrays) {
                ep.set("isallele", (Object)issueElePaper);
                if (taxNoSet.contains(ep.getString("number"))) continue;
                DynamicObject accountObj = AllEleAuthHelper.newEleAccount(ep);
                addAccounts.add(accountObj);
            }
            SaveServiceHelper.update((DynamicObject[])epArrays);
            if (addAccounts.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])addAccounts.toArray(new DynamicObject[0]));
            }
        }
    }

    public static DynamicObject newEleAccount(DynamicObject ep) {
        DynamicObject accountObj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_einvoice_account");
        accountObj.set("epinfo", ep.getPkValue());
        accountObj.set("taxno", (Object)ep.getString("number"));
        accountObj.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        accountObj.set("createtime", (Object)new Date());
        accountObj.set("modifytime", (Object)new Date());
        accountObj.set("status", (Object)"C");
        return accountObj;
    }

    public static boolean isAllEpSendEmail() {
        QFilter notEmailFilter = new QFilter("isallele", "!=", (Object)issueElePaper);
        DynamicObject[] epArray = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"id", (QFilter[])notEmailFilter.toArray());
        return epArray.length == 0;
    }

    public static String getDescription() {
        return String.format(ResManager.loadKDString((String)"\u5982\u679c\u60a8\u9700\u8981\u7684\u7a0e\u53f7\u672a\u5bfc\u5165\uff0c\u8bf7\u6838\u5b9e\u4ee5\u4e0b\u4fe1\u606f\u540e\uff0c\u70b9\u51fb\u3010\u66f4\u65b0\u4f01\u4e1a\u3011\u518d\u6b21\u5c1d\u8bd5\u5bfc\u5165\u3002%1$s1\u3001\u7a0e\u53f7\u5df2\u5b8c\u6210\u661f\u701a\u7684\u8bb8\u53ef\u6388\u6743\uff0c\u60a8\u53ef\u4ee5\u8fdb\u5165\u53d1\u7968\u4e91\u2192\u57fa\u7840\u8d44\u6599\u2192\u8bb8\u53ef\u6388\u6743\u9875\u9762\u67e5\u770b\u6216\u8005\u6388\u6743\u3002%2$s2\u3001\u7a0e\u53f7\u5df2\u5728\u5ba2\u6237\u7aef\u914d\u7f6e\u7535\u5b50\u53d1\u7968\u670d\u52a1\u5e73\u53f0\u8d26\u53f7\u3002%3$s3\u3001\u5f53\u524d\u767b\u5f55\u7684\u661f\u701a\u7528\u6237\uff0c\u5177\u5907\u8be5\u7a0e\u53f7\u6240\u5c5e\u7ec4\u7ec7\u7684\u6743\u9650\u3002", (String)"AllEleAuthHelper_25", (String)"imc-bdm-common", (Object[])new Object[0]), System.lineSeparator(), System.lineSeparator(), System.lineSeparator());
    }

    public static void setDefault(TenantAuthDTO tenantInfo, String account, String companyOuNo, String defaultBusiness) {
        try {
            String retCode;
            JSONObject response;
            AwsFpyService awsFpyService = AwsFpyService.newInstance();
            String token = awsFpyService.getAccessToken(tenantInfo.getClientId(), tenantInfo.getClientSecret());
            String url = awsFpyService.getBaseUrl() + updateTaxNoDefaultAccount + "?access_token=" + token + "&encry_type=GCM";
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("loginAccountUid", account);
            body.put("companyOuNo", companyOuNo);
            int defaultType = StringUtils.isBlank((CharSequence)defaultBusiness) ? 0 : Integer.parseInt(defaultBusiness);
            body.put("defaultType", defaultType);
            String req = AES128.ecbEncrypt(JSONObject.toJSONString(body), tenantInfo.getEncKey());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(MessageFormat.format("\u8bbe\u7f6e\u9ed8\u8ba4\u8d26\u53f7,\u8bf7\u6c42\u5730\u5740{0},\u8bf7\u6c42\u53c2\u6570{1},\u8bf7\u6c42key{2},\u52a0\u5bc6\u540e\u5b57\u7b26\u4e32{3}", url, JSONObject.toJSONString(body), tenantInfo.getEncKey(), req));
            }
            if ((response = awsFpyService.postAppJson(url, req)) == null || response.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0aws\u4f01\u4e1a\u9ed8\u8ba4\u8d26\u53f7\u8fd4\u56de\u4e3a\u7a7a", (String)"AllEleAuthHelper_16", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("response:%s", response.toJSONString()));
            }
            if (!"0000".equals(retCode = response.getString("errcode"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0aws\u4f01\u4e1a\u9ed8\u8ba4\u8d26\u53f7\u5931\u8d25\uff1a%s", (String)"AllEleAuthHelper_26", (String)"imc-bdm-common", (Object[])new Object[0]), response.getString("description")));
            }
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("setDefaultAccount:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0aws\u4f01\u4e1a\u9ed8\u8ba4\u8d26\u53f7\u5931\u8d25\uff1a%s", (String)"AllEleAuthHelper_26", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public static boolean isOutputAccount(String defaultBusiness, String accountType) {
        return AllEleAuthHelper.isOutputBusiness(defaultBusiness) && AllEleAuthHelper.isOutputAuth(accountType);
    }

    public static boolean isInputAccount(String defaultBusiness, String accountType) {
        return AllEleAuthHelper.isInputBusiness(defaultBusiness) && AllEleAuthHelper.isInputAuth(accountType);
    }

    private static boolean isInputAuth(String accountType) {
        return "2".equals(accountType) || "3".equals(accountType);
    }

    public static boolean isOutputBusiness(String defaultBusiness) {
        return issueElePaper.equals(defaultBusiness) || "3".equals(defaultBusiness);
    }

    public static boolean isInputBusiness(String defaultBusiness) {
        return "2".equals(defaultBusiness) || "3".equals(defaultBusiness);
    }

    private static boolean isOutputAuth(String accountType) {
        return issueElePaper.equals(accountType) || "3".equals(accountType);
    }

    public static DynamicObject getAccountByTaxNo(String taxNo) {
        QFilter qFilter = new QFilter("taxno", "=", (Object)taxNo);
        return BusinessDataServiceHelper.loadSingle((String)"bdm_einvoice_account", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_einvoice_account", true), (QFilter[])qFilter.toArray());
    }

    public static Pair<String, Map<String, String>> getAccountList(DynamicObject account) {
        return AllEleAuthHelper.getAccountList(account, false);
    }

    public static Pair<String, Map<String, String>> getBusinessAccountList(DynamicObject account, boolean ignoreVal, boolean isIssueBusiness) {
        HashMap<String, String> accountMap = new HashMap<String, String>(16);
        if (account == null) {
            return Pair.of((Object)"", accountMap);
        }
        DynamicObjectCollection items = account.getDynamicObjectCollection("entryentity");
        DynamicObject epInfo = account.getDynamicObject("epinfo");
        if (null == epInfo) {
            LOGGER.info(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u7684\u6570\u7535\u8d26\u53f7\u7684\u4f01\u4e1a\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u5728\u53d1\u7968\u4e91\u300b\u57fa\u7840\u8d44\u6599\u300b\u6570\u7535\u8d26\u53f7\u4e2d\u68c0\u67e5\u6539\u7a0e\u53f7\u7684\u4f01\u4e1a\u4fe1\u606f", (String)"AllEleAuthHelper_20", (String)"imc-bdm-common", (Object[])new Object[0]), account.getString("taxno")));
            return Pair.of((Object)"", accountMap);
        }
        boolean isLeqiCombineChannel = UnitTestHelper.isUnitTest() ? false : EnterpriseHelper.isLeqiCombineChannel(epInfo.getString("number"));
        String defaultAccount = "";
        for (DynamicObject item : items) {
            if (isLeqiCombineChannel && !"2".equals(item.getString("channeltype")) || !isLeqiCombineChannel && "2".equals(item.getString("channeltype")) || !issueElePaper.equals(item.getString("isenable"))) continue;
            String accountType = item.getString("accounttype");
            if (!isIssueBusiness ? StringUtils.isBlank((CharSequence)accountType) || issueElePaper.equals(accountType) || "4".equals(accountType) : StringUtils.isBlank((CharSequence)accountType) || "2".equals(accountType) || "4".equals(accountType)) continue;
            if (AllEleAuthHelper.checkUserAuthority(item, Long.parseLong(RequestContext.get().getUserId()))) continue;
            String defaultBusiness = item.getString("defaultbusiness");
            if (isIssueBusiness) {
                if (issueElePaper.equals(item.getString("isdefault")) && (issueElePaper.equals(defaultBusiness) || "3".equals(defaultBusiness))) {
                    defaultAccount = item.getString("account");
                }
            } else if (issueElePaper.equals(item.getString("isdefault")) && ("2".equals(defaultBusiness) || "3".equals(defaultBusiness))) {
                defaultAccount = item.getString("account");
            }
            accountMap.put(item.getString("account") + " | " + item.getString("drawer"), ignoreVal ? item.getString("account") : item.getString("drawer"));
        }
        return Pair.of((Object)defaultAccount, accountMap);
    }

    public static Pair<String, Map<String, String>> getAccountList(DynamicObject account, boolean ignoreVal) {
        return AllEleAuthHelper.getBusinessAccountList(account, ignoreVal, true);
    }

    public static boolean checkUserAuthority(DynamicObject dynamicObject, Long userId) {
        DynamicObjectCollection users = (DynamicObjectCollection)dynamicObject.get("user");
        if (users.size() == 0) {
            return false;
        }
        boolean[] authority = new boolean[]{true};
        String userInfo = JSON.parseArray((String)SerializationUtils.toJsonString((Object)users)).stream().map(obj -> {
            JSONObject jsonObject = (JSONObject)obj;
            JSONObject fBaseDataId = jsonObject.getJSONObject("fbasedataid");
            String zhCN = fBaseDataId.getJSONObject("name").getString("zh_CN");
            if (userId.equals(fBaseDataId.getLong("id"))) {
                authority[0] = false;
            }
            return fBaseDataId.getLong("id") + "_" + zhCN;
        }).collect(Collectors.joining(";"));
        LOGGER.info(String.format("\u67e5\u8be2\u6570\u7535\u8d26\u53f7\u7528\u6237\u6743\u9650\u4fe1\u606f,\u8d26\u53f7:[%s],\u62e5\u6709\u4f7f\u7528\u6743\u7684\u7528\u6237:[%s],\u5f53\u524d\u7528\u6237ID:[%s]", dynamicObject.getString("account"), userInfo, userId));
        return authority[0];
    }

    public static String getEleAccount(String taxNo, boolean isOutput) {
        return AllEleAuthHelper.getAccount(taxNo, isOutput, false);
    }

    public static String getAccount(String taxNo, boolean isOutput, boolean isHisotrySync) {
        QFilter filter = new QFilter("taxno", "=", (Object)taxNo);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_einvoice_account", true), (QFilter[])filter.toArray());
        boolean isVirtual = StringUtils.isNotBlank((CharSequence)ImcConfigUtil.getValue("all_ele_mock_invoice", taxNo));
        if (isVirtual && accounts.length == 0) {
            return "";
        }
        DynamicObject account = AllEleAuthHelper.getAccountByTaxNo(taxNo);
        if (account == null) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"AllEleAuthHelper_18", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo));
        }
        return AllEleAuthHelper.getEpDefaultAccount(account, isOutput, isHisotrySync);
    }

    public static String getEpDefaultAccount(DynamicObject account, boolean isOutput, boolean closeCheckUser) {
        DynamicObjectCollection items = account.getDynamicObjectCollection("entryentity");
        String taxNo = account.getString("taxno");
        boolean isLeqiCombine = EnterpriseHelper.isLeqiCombineChannel(taxNo);
        if (CollectionUtils.isEmpty((Collection)items)) {
            return null;
        }
        for (DynamicObject item : items) {
            if (isLeqiCombine && !"2".equals(item.getString("channeltype")) || !isLeqiCombine && "2".equals(item.getString("channeltype")) || !issueElePaper.equals(item.getString("isenable")) || !issueElePaper.equals(item.getString("isdefault")) || isOutput && !closeCheckUser && AllEleAuthHelper.checkUserAuthority(item, Long.parseLong(RequestContext.get().getUserId())) || !(isOutput ? AllEleAuthHelper.isOutputAccount(item.getString("defaultbusiness"), item.getString("accounttype")) : AllEleAuthHelper.isInputAccount(item.getString("defaultbusiness"), item.getString("accounttype")))) continue;
            return item.getString("account");
        }
        return null;
    }

    public static boolean elePaperSetValue(IDataModel model) {
        Object sellerTaxNo = model.getValue("salertaxno");
        Object invoiceType = model.getValue("invoicetype");
        return InvoiceUtils.isPaperInvoice((String)invoiceType) && AllEleAuthHelper.isElePaperInvoiceConfiged(sellerTaxNo);
    }

    @SdkDeprecated
    public static boolean elePaperSetValue(Object sellerTaxNo, Object invoiceType) {
        return InvoiceUtils.isPaperInvoice((String)invoiceType) && AllEleAuthHelper.isElePaperInvoiceConfiged(sellerTaxNo);
    }

    @SdkDeprecated
    public static boolean isElePaperInvoiceConfiged(Object taxNo) {
        Map<String, String> map = ImcConfigUtil.getValue("elePaperInvoice");
        return issueElePaper.equals(map.get((String)taxNo));
    }

    public static boolean isElePaper(Object isElePaper) {
        return issueElePaper.equals(isElePaper);
    }

    public static String checkIssueAccount(String taxNo, String account) {
        QFilter filter = new QFilter("taxno", "=", (Object)taxNo);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_einvoice_account", true), (QFilter[])filter.toArray());
        boolean isVirtual = StringUtils.isNotBlank((CharSequence)ImcConfigUtil.getValue("all_ele_mock_invoice", taxNo));
        if (isVirtual && accounts.length == 0) {
            return "";
        }
        if (accounts.length == 0) {
            return String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%1$s]\u4e0b\u4e0d\u5b58\u5728\u6570\u7535\u8d26\u53f7[%2$s]", (String)"AllEleAuthHelper_30", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo, account);
        }
        DynamicObjectCollection items = accounts[0].getDynamicObjectCollection("entryentity");
        boolean isContains = false;
        for (DynamicObject item : items) {
            if (!account.equals(item.getString("account"))) continue;
            isContains = true;
            if ("0".equals(item.getString("isenable"))) {
                return String.format(ResManager.loadKDString((String)"\u6570\u7535\u8d26\u53f7[%s]\u4e3a\u7981\u7528\u72b6\u6001", (String)"AllEleAuthHelper_31", (String)"imc-bdm-common", (Object[])new Object[0]), account);
            }
            Object accountType = item.get("accounttype");
            if (issueElePaper.equals(accountType) || "3".equals(accountType)) continue;
            return String.format(ResManager.loadKDString((String)"\u6570\u7535\u8d26\u53f7[%s]\u6ca1\u6709\u5f00\u7968\u6743\u9650", (String)"AllEleAuthHelper_32", (String)"imc-bdm-common", (Object[])new Object[0]), account);
        }
        if (!isContains) {
            return String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%1$s\u4e0b\u4e0d\u5b58\u5728\u6570\u7535\u8d26\u53f7[%2$s]", (String)"AllEleAuthHelper_33", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo, account);
        }
        return "";
    }

    public static String getDrawerByAccount(String taxNo, String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            return null;
        }
        QFilter filter = new QFilter("taxno", "=", (Object)taxNo);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_einvoice_account", true), (QFilter[])filter.toArray());
        if (accounts.length == 0) {
            return "";
        }
        DynamicObjectCollection items = accounts[0].getDynamicObjectCollection("entryentity");
        for (DynamicObject item : items) {
            if (!account.equals(item.getString("account"))) continue;
            return item.getString("drawer");
        }
        return "";
    }

    public static String getLeqiLianYongAccountByDrawer(DynamicObject account, String drawer) {
        if (StringUtils.isBlank((CharSequence)drawer) || null == account) {
            return "";
        }
        DynamicObject epInfo = account.getDynamicObject("epinfo");
        if (null == epInfo) {
            LOGGER.info(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u7684\u6570\u7535\u8d26\u53f7\u7684\u4f01\u4e1a\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u5728\u53d1\u7968\u4e91\u300b\u57fa\u7840\u8d44\u6599\u300b\u6570\u7535\u8d26\u53f7\u4e2d\u68c0\u67e5\u6539\u7a0e\u53f7\u7684\u4f01\u4e1a\u4fe1\u606f", (String)"AllEleAuthHelper_20", (String)"imc-bdm-common", (Object[])new Object[0]), account.getString("taxno")));
            return "";
        }
        if (EnterpriseHelper.isLeqiCombineChannel(epInfo.getString("number"))) {
            DynamicObjectCollection items = account.getDynamicObjectCollection("entryentity");
            if (null == items) {
                return "";
            }
            for (DynamicObject item : items) {
                Object accountType = item.get("accounttype");
                if (!"2".equals(item.getString("channeltype")) || !drawer.equals(item.getString("drawer")) || !"isenable".equals(item.getString("isenable")) || !issueElePaper.equals(accountType) && !"3".equals(accountType)) continue;
                return item.getString("account");
            }
        }
        return "";
    }
}

