/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.BaseInvoiceConstant;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.dto.ArBillRelationExtensionDTO;
import kd.imc.bdm.common.dto.AutoBotpConfigVo;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.RelationProcessDTO;
import kd.imc.bdm.common.enums.CancelRedEum;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.helper.bill.BillHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.BaseInvoice;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.collections4.ListUtils;

public class BotpHelper {
    private static Log LOGGER = LogFactory.getLog(BotpHelper.class);
    public static String ArFiTipKEY = "ArFiTip";
    public static final String CANCEL_OR_RED_AR_INVOICE = "cancelOrRedArInvoice";
    public static final String CANCEL_OR_RED_AR_INVOICE_BILL_PKS = "cancelOrRedArInvoiceBillPks";

    public static String getArFiTip() {
        return ResManager.loadKDString((String)"\u53d1\u7968\u5173\u8054\u7684\u5f00\u7968\u7533\u8bf7\u5355\u5bf9\u5e94\u7684\u5e94\u6536\u5f00\u7968\u6838\u9500\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u5f00\u7968\u6210\u529f\u540e\u8bf7\u624b\u5de5\u5904\u7406\u6838\u9500\u8bb0\u5f55\u76f8\u5173\u51ed\u8bc1\u540e\u53cd\u6838\u9500\u3002", (String)"BotpHelper_62", (String)"imc-bdm-common", (Object[])new Object[0]);
    }

    public static String getRedFiTip() {
        return ResManager.loadKDString((String)"\u539f\u84dd\u7968\u5173\u8054\u7684\u5f00\u7968\u7533\u8bf7\u5355\u5bf9\u5e94\u7684\u5e94\u6536\u5f00\u7968\u6838\u9500\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u5f00\u7968\u6210\u529f\u540e\u8bf7\u624b\u5de5\u5904\u7406\u6838\u9500\u8bb0\u5f55\u76f8\u5173\u51ed\u8bc1\u540e\u53cd\u6838\u9500\u3002", (String)"BotpHelper_63", (String)"imc-bdm-common", (Object[])new Object[0]);
    }

    public static boolean isFromBotp(String billSource) {
        return "3".equals(billSource);
    }

    public static boolean isBotpSystemSource(String systemSource) {
        if (StringUtils.isBlank((CharSequence)systemSource)) {
            return false;
        }
        if (systemSource.contains("PMGT_BILL") || systemSource.contains("REPC_BILL")) {
            return true;
        }
        return "\u8d22\u52a1\u5e94\u6536\u5355".equals(systemSource) || "AR_FINARBILL".equals(systemSource) || "OCPOS_SALEORDER".equals(systemSource) || "OCPOS_SALEORDER_RETURN".equals(systemSource) || "CQOMS".equals(systemSource) || "AR_BUSBILL".equals(systemSource);
    }

    public static boolean isBotpCreateBill(AbstractFormPlugin that) {
        return BotpHelper.isFromAr(that.getView().getModel().getValue("systemsource")) && OperationStatus.ADDNEW.equals((Object)that.getView().getFormShowParameter().getStatus());
    }

    @SdkDeprecated
    public static boolean isFromAr(Object systemSource) {
        return "AR_FINARBILL".equals(systemSource) || "\u8d22\u52a1\u5e94\u6536\u5355".equals(systemSource) || "AR_BUSBILL".equals(systemSource);
    }

    public static boolean isArEdit(Object systemSource, OperationStatus status) {
        return BotpHelper.isFromAr(systemSource) && !OperationStatus.ADDNEW.equals((Object)status);
    }

    public static boolean isBillNotComplete(Object billComplete) {
        return "1".equals(billComplete);
    }

    public static boolean isFromXMY(Object systemSource) {
        String systemSourceStr = String.valueOf(systemSource);
        return systemSourceStr.contains("REPC_BILL") || systemSourceStr.contains("PMGT_BILL");
    }

    public static boolean isNotComplete(Object complete) {
        return "1".equals(complete);
    }

    @SdkDeprecated
    public static void closeBills(DynamicObject[] originalBills) {
        Set billPks = Arrays.stream(originalBills).map(o -> o.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] dbRelate = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)String.join((CharSequence)",", "id", "serialno"), (QFilter[])new QFilter("originalbillid", "in", (Object)billPks.toArray()).and(BillHelper.notCancelFilter()).toArray());
        Set relateBillPks = Arrays.stream(dbRelate).map(o -> o.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject originalBill : originalBills) {
            if (!relateBillPks.contains(originalBill.getLong("id"))) {
                BotpHelper.calBillCombineData(originalBill);
            }
            originalBill.set("closestatus", (Object)"1");
            BotpHelper.clearInfoData(originalBill);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"writebacksave", (String)"sim_original_bill", (DynamicObject[])originalBills, null);
        if (!operationResult.isSuccess()) {
            String errMsg = operationResult.getMessage();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5173\u95ed\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f[%s]", (String)"BotpHelper_64", (String)"imc-bdm-common", (Object[])new Object[0]), errMsg));
        }
    }

    private static void clearInfoData(DynamicObject originalBill) {
        if ("0".equals(originalBill.getString("confirmstate"))) {
            originalBill.set("infocode", null);
            originalBill.set("blueinvoicecode", null);
            originalBill.set("blueinvoiceno", null);
            originalBill.set("originaletaxinvoiceno", null);
            originalBill.set("originalissuetime", null);
            originalBill.set("blueinvoicetype", null);
        }
    }

    public static void calBillCombineData(DynamicObject originalBill) {
        String hsbz = originalBill.getString("hsbz");
        DynamicObject curr = originalBill.getDynamicObject("fromcurr");
        boolean isFrom = CurrencyHelper.isFrom(curr);
        DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject currentRow = (DynamicObject)items.get(i);
            String rowType = currentRow.getString("rowtype");
            if ("1".equals(rowType)) {
                BotpHelper.calDiscountRowCombineAmt(hsbz, isFrom, items, i, currentRow);
                continue;
            }
            BotpHelper.calNormalRowCombineAmt(hsbz, isFrom, currentRow);
        }
    }

    private static void calNormalRowCombineAmt(String hsbz, boolean isFrom, DynamicObject currentRow) {
        BigDecimal remainTax = currentRow.getBigDecimal("remainvalidtax");
        BigDecimal remainAmount = currentRow.getBigDecimal("remainvalidamount");
        BigDecimal remainNum = currentRow.getBigDecimal("remainvalidnum");
        BigDecimal oriCombineNum = currentRow.getBigDecimal("num");
        BigDecimal itemTaxAmount = currentRow.getBigDecimal("taxamount");
        BigDecimal fromIssuedAmount = currentRow.getBigDecimal("fromissuedamount");
        BigDecimal fromIssuedTax = currentRow.getBigDecimal("fromissuedtax");
        BigDecimal fromCombineAmount = fromIssuedAmount.add(fromIssuedTax);
        BigDecimal realCombineAmount = "1".equals(hsbz) ? itemTaxAmount.subtract(remainAmount) : itemTaxAmount.subtract(remainAmount).subtract(remainTax);
        if (isFrom) {
            currentRow.set("combinelocalamount", (Object)realCombineAmount);
            currentRow.set("combineamount", (Object)fromCombineAmount);
        } else {
            currentRow.set("combineamount", (Object)realCombineAmount);
            currentRow.set("combinelocalamount", (Object)realCombineAmount);
        }
        BigDecimal modelNumRate = currentRow.getBigDecimal("modelnumrate");
        BigDecimal combineNum = !BigDecimalUtil.compareZero(modelNumRate) ? oriCombineNum.subtract(remainNum).divide(modelNumRate, 8, 4) : oriCombineNum.subtract(remainNum);
        currentRow.set("combinenum", (Object)combineNum);
    }

    public static void calDiscountRowCombineAmt(String hsbz, boolean isFrom, DynamicObjectCollection items, int i, DynamicObject currentRow) {
        BigDecimal remainTax = currentRow.getBigDecimal("remainvalidtax");
        BigDecimal remainAmount = currentRow.getBigDecimal("remainvalidamount");
        BigDecimal currentRowTaxAmount = currentRow.getBigDecimal("taxamount");
        DynamicObject lastRow = (DynamicObject)items.get(i - 1);
        BigDecimal lastRowTaxAmount = lastRow.getBigDecimal("taxamount");
        BigDecimal lastRowRemainTax = lastRow.getBigDecimal("remainvalidtax");
        BigDecimal lastRowRemainAmount = lastRow.getBigDecimal("remainvalidamount");
        BigDecimal row2TotalTaxAmount = currentRowTaxAmount.add(lastRowTaxAmount);
        BigDecimal row2TotalRemainTax = remainTax.add(lastRowRemainTax);
        BigDecimal row2TotalRemainAmount = remainAmount.add(lastRowRemainAmount);
        BigDecimal fromIssuedAmount = currentRow.getBigDecimal("fromissuedamount");
        BigDecimal lastRowIssuedAmount = lastRow.getBigDecimal("fromissuedamount");
        BigDecimal fromIssuedTax = currentRow.getBigDecimal("fromissuedtax");
        BigDecimal lastRowIssuedTax = lastRow.getBigDecimal("fromissuedtax");
        BigDecimal from2RowIssuedAmount = fromIssuedAmount.add(lastRowIssuedAmount).add(fromIssuedTax).add(lastRowIssuedTax);
        BigDecimal realCombineAmount = "1".equals(hsbz) ? row2TotalTaxAmount.subtract(row2TotalRemainAmount) : row2TotalTaxAmount.subtract(row2TotalRemainAmount).subtract(row2TotalRemainTax);
        if (isFrom) {
            lastRow.set("combineamount", (Object)from2RowIssuedAmount);
            lastRow.set("combinelocalamount", (Object)realCombineAmount);
        } else {
            lastRow.set("combineamount", (Object)realCombineAmount);
            lastRow.set("combinelocalamount", (Object)realCombineAmount);
        }
    }

    public static HashMap<Object, String> checkCloseStatusClosed(DynamicObject[] arr, HashMap<Object, String> billStatusMap, DynamicObject originBillDynamicObject) {
        String closeStatus;
        if (null == billStatusMap) {
            ArrayList<String> billList = new ArrayList<String>();
            Long orgPk = null;
            for (DynamicObject bill : arr) {
                billList.add(bill.getString("billno"));
                Object org = bill.get("orgid");
                orgPk = DynamicObjectUtil.getDynamicObjectLongValue(org);
            }
            QFilter filter = new QFilter("billno", "in", (Object)billList.toArray(new String[0])).and("orgid", "=", orgPk);
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"closestatus,billno", (QFilter[])filter.toArray());
            billStatusMap = new HashMap();
            for (DynamicObject bill : bills) {
                billStatusMap.put(bill.getString("billno"), bill.getString("closestatus"));
            }
        }
        if ("1".equals(closeStatus = billStatusMap.get(originBillDynamicObject.getString("billno"))) && !closeStatus.equals(originBillDynamicObject.getString("closestatus"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5176\u4ed6\u7528\u6237\u5173\u95ed\u5355\u636e:%s\u5f15\u8d77\u7f51\u7edc\u4e92\u65a5\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u64cd\u4f5c", (String)"BotpHelper_65", (String)"imc-bdm-common", (Object[])new Object[0]), originBillDynamicObject.getString("billno")));
        }
        return billStatusMap;
    }

    public static void checkBillsComplete(DynamicObject[] bills) {
        String firstBillComplete = null;
        String firstBillSystemSource = null;
        for (DynamicObject bill : bills) {
            String billComplete = bill.getString("billcomplete");
            billComplete = "1".equals(billComplete) ? "1" : "0";
            String systemSource = bill.getString("systemsource");
            if (null == firstBillComplete) {
                firstBillComplete = billComplete;
            }
            if (!firstBillComplete.equals(billComplete)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u540c\u4e00\u6279\u5355\u636e\uff0c\u4e0d\u80fd\u540c\u65f6\u5305\u542b\u7a7a\u5355\u8865\u5145\u5b8c\u6574\u7684\u5355\u636e\u548c\u975e\u7a7a\u5355\u7684\u5355\u636e", (String)"BotpHelper_66", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            if (null == firstBillSystemSource) {
                firstBillSystemSource = systemSource;
            }
            if (firstBillSystemSource.equals(systemSource)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u540c\u4e00\u6279\u5355\u636e\uff0c\u7cfb\u7edf\u6765\u6e90\u4e0d\u4e00\u81f4\u4e0d\u80fd\u8fdb\u884c\u5355\u636e\u5408\u5e76", (String)"BotpHelper_67", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
    }

    public static AutoBotpConfigVo getSystemConfigVo(String systemSource) {
        AutoBotpConfigVo result = new AutoBotpConfigVo();
        result.setAutoBotpSystem(false);
        String cacheConfig = CacheHelper.get("sim_invoice_call_back");
        if (StringUtils.isNotBlank((CharSequence)cacheConfig)) {
            JSONObject json = JSONObject.parseObject((String)cacheConfig);
            for (String system : json.keySet()) {
                if (!system.equals(systemSource)) continue;
                result.setAutoBotpSystem(true);
                JSONObject callBackConfig = json.getJSONObject(systemSource);
                result.setCallBackConfig(callBackConfig);
            }
            return result;
        }
        BotpHelper.createResult(systemSource, result);
        return result;
    }

    public static void createResult(String systemSource, AutoBotpConfigVo result) {
        DynamicObject[] allAutoConfigs = BusinessDataServiceHelper.load((String)"sim_invoice_call_back", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_invoice_call_back", true), null);
        HashMap<String, JSONObject> param = new HashMap<String, JSONObject>();
        for (DynamicObject allAutoConfig : allAutoConfigs) {
            JSONObject json = new JSONObject();
            String dbSystemSource = allAutoConfig.getString("systemsource");
            json.put("factoryQualifiedPrefix", (Object)allAutoConfig.getString("factoryQualifiedPrefix"));
            json.put("systemsource", (Object)dbSystemSource);
            json.put("cloudid", (Object)allAutoConfig.getString("cloudid"));
            json.put("appid", (Object)allAutoConfig.getString("appid"));
            json.put("servicename", (Object)allAutoConfig.getString("servicename"));
            json.put("methodname", (Object)allAutoConfig.getString("methodname"));
            param.put(allAutoConfig.getString("systemsource"), json);
            if (!systemSource.equals(dbSystemSource)) continue;
            result.setAutoBotpSystem(true);
            result.setCallBackConfig(json);
        }
        CacheHelper.put("sim_invoice_call_back", JSONObject.toJSONString(param), 86400);
    }

    public static boolean isFromArBlueInvoice(String blueInvoiceCode, String blueInvoiceNo) {
        DynamicObject[] invoiceArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])InvoiceUtils.getInvoiceFilter(blueInvoiceCode, blueInvoiceNo).toArray());
        if (invoiceArray.length == 0) {
            return false;
        }
        DynamicObject[] relations = RelationHelper.getRelationByInvoice(invoiceArray[0]);
        if (relations.length == 0) {
            return false;
        }
        Object sBillPk = relations[0].get("sbillid");
        DynamicObject[] oriBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"systemsource", (QFilter[])new QFilter("id", "=", sBillPk).toArray());
        if (oriBills.length == 0) {
            return false;
        }
        return String.valueOf(oriBills[0].getString("systemsource")).contains("AR_FINARBILL") || String.valueOf(oriBills[0].getString("systemsource")).contains("AR_BUSBILL");
    }

    public static boolean isExistBillByInvoiceOrderNo(BaseInvoice invoice) {
        QFilter relationFilter;
        QFilter qFilter;
        if (InvoiceUtils.isSpecialInvoice(invoice.getInvoicetype()) && invoice.getInvoiceamount().compareTo(BigDecimal.ZERO) < 0) {
            qFilter = new QFilter("infocode", "=", (Object)invoice.getInfoCode()).and("org", "=", (Object)Long.parseLong(invoice.getOrgid()));
            DynamicObject redInfo = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)"", (QFilter[])qFilter.toArray());
            relationFilter = new QFilter("tbillid", "=", redInfo.getPkValue());
        } else if (InvoiceUtils.isAllEInvoice(invoice.getInvoicetype()) && invoice.getInvoiceamount().compareTo(BigDecimal.ZERO) < 0) {
            qFilter = new QFilter("number", "=", (Object)invoice.getInfoCode());
            DynamicObject redConfirm = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)"", (QFilter[])qFilter.toArray());
            relationFilter = new QFilter("tbillid", "=", redConfirm.getPkValue());
        } else {
            if (StringUtils.isBlank((CharSequence)invoice.getOrderno())) {
                return false;
            }
            QFilter filter = new QFilter("orderno", "=", (Object)invoice.getOrderno());
            DynamicObject invoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])filter.toArray());
            if (invoiceObj == null) {
                return false;
            }
            relationFilter = new QFilter("tbillid", "=", invoiceObj.getPkValue());
        }
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])relationFilter.toArray());
        return QueryServiceHelper.exists((String)"sim_original_bill", (QFilter[])new QFilter("id", "in", (Object)Arrays.stream(relations).map(relation -> relation.getLong("sbillid")).toArray()).toArray());
    }

    public static void checkRedConfirmPartRed(DynamicObject[] redConfirms) {
        ArrayList<DynamicObject> needCheckList = BotpHelper.filterWithBillInfos(redConfirms);
        redConfirms = needCheckList.toArray(new DynamicObject[0]);
        if (needCheckList.size() == 0) {
            return;
        }
        HashMap<String, DynamicObject> redConfirmsMap = new HashMap<String, DynamicObject>();
        List redConfirmLists = ListUtils.partition(Arrays.asList(redConfirms), (int)50);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(redConfirmLists.size());
        for (List redConfirmList : redConfirmLists) {
            QFilter filter = null;
            for (DynamicObject redConfirm : redConfirmList) {
                String oriBlueInvoiceCode = redConfirm.getString("originalinvoicecode");
                String oriBlueInvoiceNo = redConfirm.getString("originalinvoiceno");
                if (!StringUtils.isNotBlank((CharSequence)oriBlueInvoiceNo)) continue;
                QFilter oneFilter = new QFilter("invoiceno", "=", (Object)oriBlueInvoiceNo);
                if (StringUtils.isNotBlank((CharSequence)oriBlueInvoiceCode)) {
                    oneFilter = oneFilter.and("invoicecode", "=", (Object)oriBlueInvoiceCode);
                }
                filter = filter == null ? oneFilter : filter.or(oneFilter);
                redConfirmsMap.put(oriBlueInvoiceNo + oriBlueInvoiceCode, redConfirm);
            }
            filters.add(filter);
        }
        for (QFilter filter : filters) {
            BotpHelper.checkRedConfirmOrRedInfoPartIssued(filter, redConfirmsMap);
        }
    }

    private static void checkRedConfirmOrRedInfoPartIssued(QFilter filter, HashMap<String, DynamicObject> redConfirmsMap) {
        if (null == filter) {
            return;
        }
        DynamicObject[] blueInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice"), (QFilter[])filter.toArray());
        if (blueInvoices.length == 0) {
            return;
        }
        for (DynamicObject blueInvoice : blueInvoices) {
            DynamicObject[] bills = RelationHelper.getOriBillByInvoice(blueInvoice);
            String key = BotpHelper.getKey(blueInvoice);
            if (bills.length == 0) {
                return;
            }
            if (!BotpHelper.isBillFromArFi(bills[0])) continue;
            BotpHelper.checkRedInfoPartRed(blueInvoice, redConfirmsMap.get(key));
        }
    }

    public static String getKey(DynamicObject blueInvoice) {
        String invoiceCode = blueInvoice.getString("invoicecode");
        String invoiceNo = blueInvoice.getString("invoiceno");
        if (InvoiceUtils.isAllEInvoice(blueInvoice.getString("invoicetype"))) {
            return invoiceNo;
        }
        return invoiceNo + invoiceCode;
    }

    public static void checkRedInfoPartRed(DynamicObject[] redInfos) {
        ArrayList<DynamicObject> needCheckList = BotpHelper.filterWithBillInfos(redInfos);
        redInfos = needCheckList.toArray(new DynamicObject[0]);
        if (needCheckList.size() == 0) {
            return;
        }
        HashMap<String, DynamicObject> redInfoBlueInfoMap = new HashMap<String, DynamicObject>();
        List redInfoList = ListUtils.partition(Arrays.asList(redInfos), (int)50);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(redInfoList.size());
        for (List redInfoLists : redInfoList) {
            QFilter filter = null;
            for (DynamicObject redInfo : redInfoLists) {
                String oriBlueInvoiceCode = redInfo.getString("originalinvoicecode");
                String oriBlueInvoiceNo = redInfo.getString("originalinvoiceno");
                if (!StringUtils.isNotBlank((CharSequence)oriBlueInvoiceNo)) continue;
                QFilter oneFilter = new QFilter("invoiceno", "=", (Object)oriBlueInvoiceNo);
                if (StringUtils.isNotBlank((CharSequence)oriBlueInvoiceCode)) {
                    oneFilter = oneFilter.and("invoicecode", "=", (Object)oriBlueInvoiceCode);
                }
                filter = filter == null ? oneFilter : filter.or(oneFilter);
                redInfoBlueInfoMap.put(oriBlueInvoiceNo + oriBlueInvoiceCode, redInfo);
            }
            filters.add(filter);
        }
        for (QFilter filter : filters) {
            BotpHelper.checkRedConfirmOrRedInfoPartIssued(filter, redInfoBlueInfoMap);
        }
    }

    private static ArrayList<DynamicObject> filterWithBillInfos(DynamicObject[] redInfos) {
        ArrayList<DynamicObject> needCheckList = new ArrayList<DynamicObject>();
        for (DynamicObject redInfo : redInfos) {
            DynamicObject[] bills = new DynamicObject[]{};
            if ("10".equals(redInfo.getString("source"))) {
                List<BillRelationDTO> relations = RelationHelper.getMatchInvRelation(redInfo.getLong("id"));
                Set billPks = relations.stream().map(o -> o.gettBillId()).collect(Collectors.toSet());
                if (billPks.size() > 0) {
                    bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"id", (QFilter[])new QFilter("id", "in", billPks).toArray());
                }
            } else {
                bills = RelationHelper.getBillsByRedInfoPk(redInfo.getPkValue());
            }
            if (bills.length != 0) continue;
            needCheckList.add(redInfo);
        }
        return needCheckList;
    }

    private static void checkRedInfoPartRed(DynamicObject blueInvoice, DynamicObject redInfo) {
        BigDecimal redInfoTotalAmount;
        if (null == redInfo) {
            return;
        }
        BigDecimal blueTotalAmount = blueInvoice.getBigDecimal("totalamount");
        if (blueTotalAmount.compareTo((redInfoTotalAmount = redInfo.getBigDecimal("totalamount")).abs()) > 0) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u5e94\u6536\u4e0b\u63a8\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u90e8\u5206\u7ea2\u51b2\uff08\u4ef7\u7a0e\u5408\u8ba1\u548c\u539f\u84dd\u7968\u7684\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u76f8\u7b49\uff09\uff0c\u5355\u636e\u7f16\u53f7\uff1a%s", (String)"BotpHelper_68", (String)"imc-bdm-common", (Object[])new Object[0]), redInfo.getString("billno")));
        }
    }

    public static boolean isBillFromArFi(DynamicObject bill) {
        return "3".equals(bill.getString("billsource")) && BotpHelper.isFromAr(bill.getString("systemsource"));
    }

    public static boolean isInvoiceExistBill(Object batchFid) {
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice"), (QFilter[])new QFilter("id", "=", batchFid).toArray());
        return BotpHelper.isRelateBillExist(invoices);
    }

    private static boolean isRelateBillExist(DynamicObject[] invoices) {
        if (invoices.length > 0) {
            DynamicObject[] bills = RelationHelper.getOriBillByInvoice(invoices[0]);
            return bills.length > 0;
        }
        return false;
    }

    public static void checkSingleIssuePartRed(AbstractFormPlugin plugin, String ars) {
        String batchFid = plugin.getPageCache().get("invoiceBatchFid");
        if (StringUtils.isBlank((CharSequence)batchFid)) {
            return;
        }
        IDataModel model = plugin.getView().getModel();
        Object issueType = model.getValue("issuetype");
        if (!IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
            return;
        }
        if (BotpHelper.isInvoiceExistBill(Long.parseLong(batchFid))) {
            return;
        }
        BotpHelper.checkOriInvoicePartedIssue(ars, model.getValue("originalinvoicecode"), model.getValue("originalinvoiceno"));
    }

    public static void checkOriInvoicePartedIssue(String ars, Object oriInvoiceCode, Object oriInvoiceNo) {
        if (!BotpHelper.isFromArBlueInvoice(String.valueOf(oriInvoiceCode), String.valueOf(oriInvoiceNo))) {
            return;
        }
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])InvoiceUtils.getInvoiceFilter(oriInvoiceCode, oriInvoiceNo).toArray());
        JSONArray itemJSONArray = JSON.parseArray((String)ars);
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        for (int i = 0; i < itemJSONArray.size(); ++i) {
            JSONObject itemJson = itemJSONArray.getJSONObject(i);
            String xmje = itemJson.getString("xmje");
            String se = itemJson.getString("se");
            if (StringUtils.isNotBlank((CharSequence)xmje)) {
                invoiceAmount = invoiceAmount.add(new BigDecimal(xmje));
            }
            if (!StringUtils.isNotBlank((CharSequence)se)) continue;
            totalTax = totalTax.add(new BigDecimal(se));
        }
        BigDecimal totalAmount = invoiceAmount.add(totalTax);
        BigDecimal blueTotalAmount = array[0].getBigDecimal("totalamount");
        BigDecimal blueInvoiceAmount = array[0].getBigDecimal("invoiceamount");
        BigDecimal blueTotalTax = array[0].getBigDecimal("totaltax");
        if (blueTotalTax.compareTo(totalTax.abs()) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u6536\u4e0b\u63a8\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u90e8\u5206\u7ea2\u51b2\uff08\u7a0e\u989d\u548c\u539f\u84dd\u7968\u7684\u7a0e\u989d\u4e0d\u76f8\u7b49\uff09", (String)"BotpHelper_69", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        if (blueTotalAmount.compareTo(totalAmount.abs()) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u6536\u4e0b\u63a8\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u90e8\u5206\u7ea2\u51b2\uff08\u4ef7\u7a0e\u5408\u8ba1\u548c\u539f\u84dd\u7968\u7684\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u76f8\u7b49\uff09", (String)"BotpHelper_70", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        if (blueInvoiceAmount.compareTo(invoiceAmount.abs()) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u6536\u4e0b\u63a8\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u90e8\u5206\u7ea2\u51b2\uff08\u5408\u8ba1\u91d1\u989d\u548c\u539f\u84dd\u7968\u7684\u5408\u91d1\u91d1\u989d\u4e0d\u76f8\u7b49\uff09", (String)"BotpHelper_71", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
    }

    public static boolean isForceGoodsMatch() {
        String botpForceMatchConfig = ImcConfigUtil.getValue("sim_botp_config", "enforce_goods_match");
        if (StringUtils.isBlank((CharSequence)botpForceMatchConfig)) {
            return true;
        }
        return "1".equals(botpForceMatchConfig);
    }

    public static boolean needReCalAmount() {
        String botpConfig = ImcConfigUtil.getValue("sim_botp_config", "sim_ar_push_recal");
        if (StringUtils.isBlank((CharSequence)botpConfig)) {
            boolean greaterThan527 = BotpHelper.isGreaterThan518();
            botpConfig = greaterThan527 ? "1" : "0";
            QFilter filter = new QFilter("config_type", "=", (Object)"sim_botp_config").and("config_key", "=", (Object)"sim_ar_push_recal");
            if (!QueryServiceHelper.exists((String)"invsm_param_configuration", (QFilter[])filter.toArray())) {
                DynamicObject config = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
                config.set("config_type", (Object)"sim_botp_config");
                config.set("config_key", (Object)"sim_ar_push_recal");
                config.set("config_value", (Object)botpConfig);
                ImcSaveServiceHelper.save(config);
            }
        }
        return !"1".equals(botpConfig);
    }

    public static boolean isGreaterThan518() {
        try {
            JSONArray param = BotpHelper.getVersionInfos();
            for (Object o : param) {
                String allVersionReplacedValue;
                JSONObject json = (JSONObject)o;
                String version = json.getString("version");
                if (!StringUtils.isNotBlank((CharSequence)version)) continue;
                String firstChar = version.substring(0, 1);
                String allVersion = null;
                int firstValue = Integer.parseInt(firstChar);
                if (firstValue > 5) {
                    return true;
                }
                if (firstValue != 5 || Integer.parseInt(allVersionReplacedValue = (allVersion = version.substring(0, 7)).replaceAll("\\.", "")) <= 50018) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static JSONArray getVersionInfos() {
        String sql = "select fid, fproductnumber, fversion, fupgradetime from t_bas_industry_version where fproductnumber in (?, ?);";
        Object[] params = new Object[]{"constellation_fi", "cosmic_fi"};
        List versions = Collections.emptyList();
        try {
            versions = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, resultSet -> {
                ArrayList<Version> result = new ArrayList<Version>(resultSet.getRow());
                while (resultSet.next()) {
                    Version version = new Version();
                    version.setId(resultSet.getString("fid"));
                    version.setVersion(resultSet.getString("fversion"));
                    version.setProductNumber(resultSet.getString("fproductnumber"));
                    version.setUpgradeTime(resultSet.getDate("fupgradetime"));
                    result.add(version);
                }
                return result;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != versions) {
            return JSONObject.parseArray((String)JSONObject.toJSONString((Object)versions));
        }
        return new JSONArray();
    }

    public static BigDecimal getNumBeforeNumRate(BigDecimal billNum, DynamicObject currentRow) {
        BigDecimal modelNumRate = currentRow.getBigDecimal("modelnumrate");
        if (BigDecimalUtil.compareZero(billNum)) {
            return billNum;
        }
        if (BigDecimalUtil.compareZero(modelNumRate)) {
            return billNum;
        }
        return billNum.divide(modelNumRate, 8, RoundingMode.HALF_UP);
    }

    public static void setBeforeModelNumRate(BigDecimal billNum, ArBillRelationExtensionDTO dto, DynamicObject currentRow) {
        BigDecimal modelNumRate = currentRow.getBigDecimal("modelnumrate");
        if (BigDecimalUtil.compareZero(billNum)) {
            return;
        }
        if (BigDecimalUtil.compareZero(modelNumRate)) {
            return;
        }
        dto.setNum(billNum.divide(modelNumRate, 8, RoundingMode.HALF_UP));
    }

    public static String getMergeKey(DynamicObject invoice, boolean isValid) {
        String invoiceCode = invoice.getString("invoicecode");
        String invoiceNo = invoice.getString("invoiceno");
        String invoiceCodeNoStr = invoiceCode + invoiceNo;
        return isValid ? invoiceCodeNoStr + "CANCEL" : invoiceCodeNoStr;
    }

    public static String getFillInMergeKey(String invoiceCode, String invoiceNo, String callBackNo) {
        String codeNo = StringUtils.isBlank((CharSequence)invoiceCode) ? invoiceNo : invoiceCode + invoiceNo;
        return BotpHelper.getFillInMergeKey(codeNo, callBackNo);
    }

    public static String getFillInMergeKey(String invoiceCodeNo, String callBackNo) {
        return invoiceCodeNo + callBackNo;
    }

    public static void manualWriteOffArBill(Set<Object> billPkSet) {
        Set<Long> originalBIllSet = billPkSet.stream().map(o -> (Long)o).collect(Collectors.toSet());
        ArrayList<Long> arBill = BotpHelper.getArBillPksFromOriginalBillPks(originalBIllSet);
        BotpHelper.confirm(arBill);
    }

    public static boolean onlySubmitCheck(DynamicObject oriBill) {
        if (oriBill == null) {
            return false;
        }
        if (BotpHelper.isBillNotComplete(oriBill.getString("billcomplete"))) {
            return true;
        }
        if (BotpHelper.needReCalAmount()) {
            return false;
        }
        return BotpHelper.isFromAr(oriBill.getString("systemsource"));
    }

    public static boolean isArBotpCompleteBill(Object systemSource, Object billComplete) {
        return BotpHelper.isFromAr(systemSource) && !BotpHelper.isNotComplete(billComplete);
    }

    @SdkDeprecated
    public static void dealPushArFields(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            try {
                String validState;
                String closeStatus;
                String confirmState = bill.getString("confirmstate");
                if (!"0".equals(confirmState) || "1".equals(closeStatus = bill.getString("closestatus")) || !"0".equals(validState = bill.getString("validstate"))) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            BotpHelper.dealBillPushFields(bill, BotpHelper.isFromArFiOrArInv(bill.getString("systemsource")));
        }
    }

    public static void dealBillPushFields(DynamicObject bill, boolean isFromArFi) {
        String firstRowType;
        DynamicObject fromCurr = bill.getDynamicObject("fromcurr");
        boolean isFrom = CurrencyHelper.isFrom(fromCurr);
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        if (items.size() > 0 && "1".equals(firstRowType = ((DynamicObject)items.get(0)).getString("rowtype"))) {
            return;
        }
        if (isFrom) {
            BotpHelper.dealFromItem(items, bill, isFromArFi);
        } else {
            BotpHelper.dealRMBItem(items, bill, isFromArFi);
        }
    }

    public static void dealFromItem(DynamicObjectCollection items, DynamicObject bill, boolean isFromArFi) {
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            String rowType = item.getString("rowtype");
            if ("1".equals(rowType)) {
                DynamicObject lastRow = (DynamicObject)items.get(i - 1);
                if (isFromArFi) {
                    lastRow.set("pushlocalamt", (Object)lastRow.getBigDecimal("taxamount").add(item.getBigDecimal("taxamount")));
                    lastRow.set("pushamt", (Object)lastRow.getBigDecimal("fromtaxamount").add(item.getBigDecimal("fromtaxamount")));
                    continue;
                }
                lastRow.set("unpushlocalamt", (Object)lastRow.getBigDecimal("taxamount").add(item.getBigDecimal("taxamount")));
                lastRow.set("unpushamt", (Object)lastRow.getBigDecimal("fromtaxamount").add(item.getBigDecimal("fromtaxamount")));
                continue;
            }
            if (isFromArFi) {
                item.set("pushnum", (Object)item.getBigDecimal("num").subtract(item.getBigDecimal("unpushnum")));
                item.set("pushlocalamt", (Object)item.getBigDecimal("taxamount").subtract(item.getBigDecimal("unpushlocalamt")));
                item.set("pushamt", (Object)item.getBigDecimal("fromtaxamount").subtract(item.getBigDecimal("unpushamt")));
                continue;
            }
            item.set("unpushnum", (Object)item.getBigDecimal("num").subtract(item.getBigDecimal("pushnum")));
            item.set("unpushlocalamt", (Object)item.getBigDecimal("taxamount").subtract(item.getBigDecimal("pushlocalamt")));
            item.set("unpushamt", (Object)item.getBigDecimal("fromtaxamount").subtract(item.getBigDecimal("pushamt")));
        }
        BotpHelper.countHeadPushAmt(items, bill);
    }

    private static void dealRMBItem(DynamicObjectCollection items, DynamicObject bill, boolean isFromArFi) {
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            String rowType = item.getString("rowtype");
            if ("1".equals(rowType)) {
                if (i == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6298\u6263\u884c\u4e0d\u80fd\u4e3a\u7b2c\u4e00\u884c", (String)"BotpHelper_95", (String)"imc-bdm-common", (Object[])new Object[0]));
                }
                DynamicObject lastRow = (DynamicObject)items.get(i - 1);
                if (isFromArFi) {
                    lastRow.set("pushamt", (Object)lastRow.getBigDecimal("taxamount").add(item.getBigDecimal("taxamount")));
                    lastRow.set("pushlocalamt", (Object)lastRow.getBigDecimal("pushamt"));
                    lastRow.set("unpushamt", (Object)BigDecimal.ZERO);
                    lastRow.set("unpushlocalamt", (Object)BigDecimal.ZERO);
                    continue;
                }
                lastRow.set("unpushamt", (Object)lastRow.getBigDecimal("taxamount").add(item.getBigDecimal("taxamount")));
                lastRow.set("unpushlocalamt", (Object)lastRow.getBigDecimal("unpushamt"));
                lastRow.set("pushamt", (Object)BigDecimal.ZERO);
                lastRow.set("pushlocalamt", (Object)BigDecimal.ZERO);
                continue;
            }
            if (isFromArFi) {
                item.set("pushnum", (Object)item.getBigDecimal("num").subtract(item.getBigDecimal("unpushnum")));
                item.set("pushamt", (Object)item.getBigDecimal("taxamount").subtract(item.getBigDecimal("unpushamt")));
                item.set("pushlocalamt", (Object)item.getBigDecimal("taxamount").subtract(item.getBigDecimal("unpushlocalamt")));
                item.set("unpushnum", (Object)BigDecimal.ZERO);
                item.set("unpushlocalamt", (Object)BigDecimal.ZERO);
                item.set("unpushamt", (Object)BigDecimal.ZERO);
                continue;
            }
            item.set("unpushnum", (Object)item.getBigDecimal("num").subtract(item.getBigDecimal("pushnum")));
            item.set("unpushamt", (Object)item.getBigDecimal("taxamount").subtract(item.getBigDecimal("pushamt")));
            item.set("unpushlocalamt", (Object)item.getBigDecimal("taxamount").subtract(item.getBigDecimal("pushlocalamt")));
            item.set("pushnum", (Object)BigDecimal.ZERO);
            item.set("pushlocalamt", (Object)BigDecimal.ZERO);
            item.set("pushamt", (Object)BigDecimal.ZERO);
        }
        BotpHelper.countHeadPushAmt(items, bill);
    }

    private static void countHeadPushAmt(DynamicObjectCollection items, DynamicObject bill) {
        BigDecimal totalUnPushAmt = BigDecimal.ZERO;
        BigDecimal totalUnPushLocalAmt = BigDecimal.ZERO;
        BigDecimal totalPushAmt = BigDecimal.ZERO;
        BigDecimal totalPushLocalAmt = BigDecimal.ZERO;
        for (DynamicObject item : items) {
            totalUnPushAmt = totalUnPushAmt.add(item.getBigDecimal("unpushamt"));
            totalUnPushLocalAmt = totalUnPushLocalAmt.add(item.getBigDecimal("unpushlocalamt"));
            totalPushAmt = totalPushAmt.add(item.getBigDecimal("pushamt"));
            totalPushLocalAmt = totalPushLocalAmt.add(item.getBigDecimal("pushlocalamt"));
        }
        bill.set("pushamount", (Object)totalPushAmt);
        bill.set("pushlocalamount", (Object)totalPushLocalAmt);
        bill.set("unpushlocalamount", (Object)totalUnPushLocalAmt);
        bill.set("unpushamount", (Object)totalUnPushAmt);
    }

    public static JSONObject cancelOrRedArInvoice(DynamicObject[] redInfos, CancelRedEum opertae) {
        LOGGER.info("cancelOrRedArInvoicePk:" + redInfos[0].getPkValue());
        ArrayList<Long> needConfirms = new ArrayList<Long>();
        Set<Object> billPks = new HashSet();
        switch (opertae) {
            case ISSUE_RED_NORMAL: {
                billPks = BotpHelper.canRedArInvoice(redInfos, needConfirms);
                break;
            }
            case ISSUE_RED_INFO: {
                billPks = BotpHelper.canIssueArRedInfo(redInfos, needConfirms);
                break;
            }
            case ISSUE_RED_CONFIRM: {
                billPks = BotpHelper.canIssueArRedConfirm(redInfos, needConfirms);
                break;
            }
            case CANCEL_INVOICE: {
                billPks = BotpHelper.canCancelArInvoices(redInfos, needConfirms);
            }
        }
        JSONObject param = new JSONObject();
        param.put("billPks", billPks);
        param.put("needConfirms", needConfirms);
        param.put("billPksSize", (Object)billPks.size());
        return param;
    }

    public static void writeOffArBillAndAddMark(String paramStr, String tableKey) {
        if (StringUtils.isBlank((CharSequence)paramStr)) {
            return;
        }
        JSONObject json = JSONObject.parseObject((String)paramStr);
        JSONArray needConfirms = json.getJSONArray("needConfirms");
        DynamicObject[] confirms = BusinessDataServiceHelper.load((String)tableKey, (String)"cancelredlable", (QFilter[])new QFilter("id", "in", (Object)needConfirms.toArray()).toArray());
        JSONArray billPks = json.getJSONArray("billPks");
        BotpHelper.comfirmArBills(billPks, confirms);
    }

    public static void cancelOrRedInvoice(String paramStr, String tableKey) {
    }

    private static void comfirmArBills(JSONArray billPks, DynamicObject[] needConfirms) {
        HashSet<Long> billPkSet = new HashSet<Long>();
        Collections.addAll(billPkSet, billPks.toArray((Object[])new Long[0]));
        ArrayList<Long> arPkList = BotpHelper.getArBillPksFromOriginalBillPks(billPkSet);
        LOGGER.info("needConfrimArPks:" + billPks.toJSONString());
        boolean isConfirm = BotpHelper.confirm(arPkList);
        if (isConfirm) {
            BotpHelper.updateCancelRedStatus(needConfirms);
        }
    }

    private static Set<Long> canIssueArRedInfo(DynamicObject[] redInfos, List<Long> needConfirmInvoices) {
        HashMap<String, DynamicObject> blueMap = BotpHelper.getBlueMap(redInfos);
        HashSet<Long> billPkSet = new HashSet<Long>();
        for (DynamicObject redInfo : redInfos) {
            DynamicObject[] relations = RelationHelper.getBillsByRedInfoPk(redInfo.getPkValue());
            BotpHelper.checkBillsConfirmAr(needConfirmInvoices, blueMap, billPkSet, redInfo, relations, ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868", (String)"BotpHelper_96", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return billPkSet;
    }

    private static Set<Long> canIssueArRedConfirm(DynamicObject[] redConfirms, List<Long> needConfirmInvoices) {
        HashMap<String, DynamicObject> blueMap = BotpHelper.getBlueMap(redConfirms);
        HashSet<Long> billPkSet = new HashSet<Long>();
        for (DynamicObject redConfirm : redConfirms) {
            DynamicObject[] relations = RelationHelper.getRelationsByTBillId(redConfirm.getPkValue());
            BotpHelper.checkBillsConfirmAr(needConfirmInvoices, blueMap, billPkSet, redConfirm, relations, ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"BotpHelper_97", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return billPkSet;
    }

    private static void checkBillsConfirmAr(List<Long> needConfirmInvoices, HashMap<String, DynamicObject> blueMap, HashSet<Long> billPkSet, DynamicObject redConfirm, DynamicObject[] relations, String billName) {
        if (relations.length != 0) {
            LOGGER.info("checkBillsConfirmAr:RelationQueried");
            return;
        }
        if (BaseInvoiceConstant.CanCancelLable.YES.equals(redConfirm.getString("cancelredlable"))) {
            return;
        }
        String oriInvoiceCode = redConfirm.getString("originalinvoicecode");
        String oriInvoiceNo = redConfirm.getString("originalinvoiceno");
        DynamicObject[] blueInvoices = InvoiceUtils.getInvoice(redConfirm.getString("salertaxno"), oriInvoiceCode, oriInvoiceNo, false);
        if (blueInvoices.length > 0) {
            DynamicObject blueInvoice = blueInvoices[0];
            if (!"4".equals(blueInvoice.getString("buyertype"))) {
                LOGGER.info("checkBillsConfirmAr:isNotBillSplit");
                return;
            }
            DynamicObject[] blueRelations = RelationHelper.getRelationByInvoice(blueInvoice);
            RelationProcessDTO process = RelationHelper.getProcess(blueRelations);
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"pushamount,closestatus,systemsource", (QFilter[])new QFilter("id", "in", (Object)process.getsBillIdSet().toArray(new Object[0])).toArray());
            Set<Long> tbillIds = RelationHelper.queryTbillIds(bills);
            boolean isConfirmAr = BotpHelper.isConfirm(bills);
            LOGGER.info("checkBillsConfirmAr:" + isConfirmAr);
            if (isConfirmAr) {
                DynamicObject[] billRelateBillInvoices;
                Set<Long> billIdSet = Arrays.stream(bills).map(o -> o.getLong("id")).collect(Collectors.toSet());
                ArrayList<Long> arBillPkList = BotpHelper.getArBillPksFromOriginalBillPks(billIdSet);
                Set<Long> allBillPks = BotpHelper.queryUploadPks(arBillPkList);
                if (allBillPks.size() != 1) {
                    tbillIds = RelationHelper.queryTbillIdsByBillIds(allBillPks);
                }
                for (DynamicObject billRelateBillInvoice : billRelateBillInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"invoicecode,invoiceno,remainredamount", (QFilter[])new QFilter("id", "in", (Object)tbillIds.toArray()).toArray())) {
                    if (BigDecimal.ZERO.compareTo(billRelateBillInvoice.getBigDecimal("remainredamount")) == 0) {
                        LOGGER.info("checkBillsConfirmArIssued:" + billRelateBillInvoice.getString("invoiceno"));
                        continue;
                    }
                    if (blueMap.containsKey(billRelateBillInvoice.getString("invoicecode") + billRelateBillInvoice.getString("invoiceno"))) continue;
                    LOGGER.info(String.format("\u6839\u636e\u7ea2\u5b57\u4fe1\u606f\u8868\u6216\u5219\u7ea2\u5b57\u786e\u8ba4\u5355%s\u67e5\u8be2\u7684\u5355\u636e\u603b\u5173\u8054\u53d1\u7968\uff0c\u4e0d\u5305\u542b\u84dd\u7968\u53f7\u7801id\uff1a%s", redConfirm.getPkValue(), billRelateBillInvoice.getString("invoiceno")));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684%2$s\u6240\u5173\u8054\u7684\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u786e\u8ba4\u5e94\u6536\uff0c\u9700\u5c06\u8be5\u5f00\u7968\u7533\u8bf7\u6240\u5173\u8054\u7684\u6240\u6709\u53d1\u7968\u8fdb\u884c\u7ea2\u51b2\uff0c \u8bf7\u68c0\u67e5\u3002", (String)"BotpHelper_93", (String)"imc-bdm-common", (Object[])new Object[0]), redConfirm.getString("billno"), billName));
                }
                needConfirmInvoices.add(redConfirm.getLong("id"));
                Collections.addAll(billPkSet, allBillPks.toArray(new Long[0]));
            }
        } else {
            LOGGER.info("checkBillsConfirmAr:blueInvoiceNotFind");
        }
    }

    public static boolean isFromArFi(Object systemSource) {
        return "AR_FINARBILL".equals(systemSource) || "\u8d22\u52a1\u5e94\u6536\u5355".equals(systemSource);
    }

    public static boolean isFromArFiOrArInv(Object systemSource) {
        return "AR_FINARBILL".equals(systemSource) || "\u8d22\u52a1\u5e94\u6536\u5355".equals(systemSource) || "KINGDEE_FI".equals(systemSource);
    }

    public static boolean isFromArZANGU(Object systemSource) {
        return "AR_BUSBILL".equals(systemSource);
    }

    private static HashMap<String, DynamicObject> getBlueMap(DynamicObject[] redConfirms) {
        HashMap<String, DynamicObject> blueMap = new HashMap<String, DynamicObject>();
        for (DynamicObject redConfirm : redConfirms) {
            if (!StringUtils.isNotBlank((CharSequence)redConfirm.getString("originalinvoiceno"))) continue;
            blueMap.put(redConfirm.getString("originalinvoicecode") + redConfirm.getString("originalinvoiceno"), redConfirm);
        }
        return blueMap;
    }

    private static Set<Long> canRedArInvoice(DynamicObject[] invoices, List<Long> needConfirmInvoices) {
        HashSet<Object> invoicePkSet = new HashSet<Object>();
        HashSet<Long> billPkSet = new HashSet<Long>();
        for (DynamicObject invoice : invoices) {
            invoicePkSet.add(invoice.getPkValue());
            if (!InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype")) && !InvoiceUtils.isSpecialInvoice(invoice.getString("invoicetype"))) continue;
            return billPkSet;
        }
        for (DynamicObject invoice : invoices) {
            if (!"4".equals(invoice.getString("buyertype")) || BaseInvoiceConstant.CanCancelLable.YES.equals(invoice.getString("cancelredlable"))) continue;
            DynamicObject[] relations = RelationHelper.getRelationByInvoice(invoice);
            RelationProcessDTO process = RelationHelper.getProcess(relations);
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"pushamount,closestatus,systemsource", (QFilter[])new QFilter("id", "in", (Object)process.getsBillIdSet().toArray(new Object[0])).toArray());
            Set<Long> tbillIds = RelationHelper.queryTbillIds(bills);
            boolean isConfirmAr = BotpHelper.isConfirm(bills);
            if (!isConfirmAr) continue;
            Set<Long> billIdSet = Arrays.stream(bills).map(o -> o.getLong("id")).collect(Collectors.toSet());
            ArrayList<Long> arBillPkList = BotpHelper.getArBillPksFromOriginalBillPks(billIdSet);
            Set<Long> allBillPks = BotpHelper.queryUploadPks(arBillPkList);
            if (allBillPks.size() != 1) {
                tbillIds = RelationHelper.queryTbillIdsByBillIds(allBillPks);
            }
            String operateDescription = ResManager.loadKDString((String)"\u7ea2\u51b2", (String)"BotpHelper_76", (String)"imc-bdm-common", (Object[])new Object[0]);
            for (Long relatePk : tbillIds) {
                if (invoicePkSet.contains(relatePk) || BotpHelper.isCreateTBill(relatePk, invoice)) continue;
                LOGGER.info(String.format("\u6839\u636e\u53d1\u7968%s\u67e5\u8be2\u7684\u5355\u636e\u603b\u5173\u8054\u53d1\u7968\uff0c\u6240\u9009\u53d1\u7968\u4e0d\u5305\u542b\u53d1\u7968id\uff1a%s", invoice.getPkValue(), relatePk));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e3a\uff1a%1$s\u6240\u5173\u8054\u7684\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u786e\u8ba4\u5e94\u6536\uff0c\u9700\u5c06\u8be5\u5f00\u7968\u7533\u8bf7\u6240\u5173\u8054\u7684\u6240\u6709\u53d1\u7968\u8fdb\u884c%2$s\uff0c \u8bf7\u68c0\u67e5\u3002", (String)"BotpHelper_92", (String)"imc-bdm-common", (Object[])new Object[0]), invoice.getString("invoiceno"), operateDescription));
            }
            needConfirmInvoices.add(invoice.getLong("id"));
            Collections.addAll(billPkSet, allBillPks.toArray(new Long[0]));
        }
        return billPkSet;
    }

    public static Set<Long> queryUploadPks(List<Long> arBillPkList) {
        HashSet<Long> billPkSet = new HashSet<Long>();
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)"ar_finarbill", (Long[])arBillPkList.toArray(new Long[0]), null);
        for (BFRowLinkUpNode node : bfRowLinkUpNodes) {
            Map sNodes = node.getSNodes();
            for (Map.Entry entry : sNodes.entrySet()) {
                BFRowId key = (BFRowId)entry.getKey();
                billPkSet.add(key.getBillId());
            }
        }
        return billPkSet;
    }

    public static boolean isCreateTBill(Object blueInvoicePk, DynamicObject invoice) {
        DynamicObject[] invoiceArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"invoicecode,invoiceno", (QFilter[])new QFilter("id", "=", blueInvoicePk).toArray());
        if (invoiceArray.length > 0) {
            QFilter filter = new QFilter("originalinvoicecode", "=", (Object)invoiceArray[0].getString("invoicecode")).and("originalinvoiceno", "=", (Object)invoiceArray[0].getString("invoiceno"));
            if (InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype"))) {
                return QueryServiceHelper.exists((String)"sim_red_confirm_bill", (QFilter[])filter.toArray());
            }
            if (InvoiceUtils.isSpecialInvoice(invoice.getString("invoicetype"))) {
                return QueryServiceHelper.exists((String)"sim_red_info", (QFilter[])filter.toArray());
            }
            return QueryServiceHelper.exists((String)"sim_vatinvoice", (QFilter[])filter.toArray());
        }
        return false;
    }

    private static void updateCancelRedStatus(DynamicObject[] invoices) {
        Arrays.stream(invoices).forEach(o -> o.set("cancelredlable", (Object)BaseInvoiceConstant.CanCancelLable.YES));
        SaveServiceHelper.update((DynamicObject[])invoices);
    }

    public static Set<Object> queryBotpTPks(List<Object> otherBillIds) {
        Set<Long> billPks = otherBillIds.stream().map(o -> (Long)o).collect(Collectors.toSet());
        ArrayList<Long> list = BotpHelper.getArBillPksFromOriginalBillPks(billPks);
        return new HashSet<Object>(list);
    }

    private static ArrayList<Long> getArBillPksFromOriginalBillPks(Set<Long> billPkSet) {
        if (billPkSet.isEmpty()) {
            return new ArrayList<Long>();
        }
        HashSet<Long> arPkSet = new HashSet<Long>();
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)"sim_original_bill", (Long[])billPkSet.toArray(new Long[0]), null);
        if (bfRowLinkDownNodes.size() > 0) {
            for (BFRowLinkDownNode node : bfRowLinkDownNodes) {
                Map tNodes = node.getTNodes();
                for (Map.Entry entry : tNodes.entrySet()) {
                    BFRowId key = (BFRowId)entry.getKey();
                    Long arBillPk = key.getBillId();
                    arPkSet.add(arBillPk);
                }
            }
            if (QueryServiceHelper.exists((String)"ar_finarbill", (QFilter[])new QFilter("id", "in", (Object)arPkSet.toArray(new Object[0])).toArray())) {
                return new ArrayList<Long>(arPkSet);
            }
        }
        return new ArrayList<Long>();
    }

    private static Set<Long> canCancelArInvoices(DynamicObject[] invoices, List<Long> needConfirmInvoices) {
        HashSet<Object> invoicePkSet = new HashSet<Object>();
        HashSet<Long> billPkSet = new HashSet<Long>();
        for (DynamicObject invoice : invoices) {
            invoicePkSet.add(invoice.getLong("id"));
        }
        for (DynamicObject invoice : invoices) {
            String issueType = invoice.getString("issuetype");
            if (BaseInvoiceConstant.CanCancelLable.YES.equals(invoice.getString("cancelredlable"))) continue;
            if (IssueType.BLUE_INVOICE.getTypeCode().equals(issueType)) {
                if (!"4".equals(invoice.getString("buyertype"))) continue;
                BotpHelper.checkRelateInvoiceChoosed(invoicePkSet, needConfirmInvoices, invoice, ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"BotpHelper_98", (String)"imc-bdm-common", (Object[])new Object[0]), billPkSet);
                continue;
            }
            if (!"4".equals(invoice.getString("buyertype"))) {
                DynamicObject[] oriInvoice = InvoiceUtils.getInvoice(invoice.getString("salertaxno"), invoice.getString("originalinvoicecode"), invoice.getString("originalinvoiceno"));
                if (oriInvoice.length <= 0 || !BotpHelper.isInvoiceBillsConfirmAr(oriInvoice[0])) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e3a\uff1a%s\u7684\u539f\u84dd\u7968\u5173\u8054\u7684\u5355\u636e\u5df2\u7ecf\u786e\u8ba4\u5e94\u6536\uff0c\u4e0d\u5141\u8bb8\u5bf9\u5176\u8fdb\u884c\u4f5c\u5e9f", (String)"BotpHelper_94", (String)"imc-bdm-common", (Object[])new Object[0]), invoice.getString("invoiceno")));
            }
            DynamicObject[] relations = RelationHelper.getRelationByInvoice(invoice);
            RelationProcessDTO process = RelationHelper.getProcess(relations);
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"pushamount,closestatus,systemsource", (QFilter[])new QFilter("id", "in", (Object)process.getsBillIdSet().toArray(new Object[0])).toArray());
            boolean isConfirmAr = BotpHelper.isConfirm(bills);
            if (!isConfirmAr) continue;
            Set<Long> billIdSet = Arrays.stream(bills).map(o -> o.getLong("id")).collect(Collectors.toSet());
            ArrayList<Long> arBillPkList = BotpHelper.getArBillPksFromOriginalBillPks(billIdSet);
            Set<Long> allBillPks = BotpHelper.queryUploadPks(arBillPkList);
            DynamicObject[] allRelations = RelationHelper.getRelationsBySBillIdWithoutDelete(allBillPks.toArray(new Long[0]));
            List<DynamicObject> allInvoices = RelationHelper.getInvoicesByRelations(allRelations, invoice.getDynamicObject("orgid").getLong("id"));
            for (DynamicObject allInvoice : allInvoices) {
                if ("6".equals(allInvoice.getString("invoicestatus")) || invoicePkSet.contains(allInvoice.getPkValue())) continue;
                LOGGER.info(String.format("\u6839\u636e\u53d1\u7968%s\u67e5\u8be2\u7684\u5355\u636e\u603b\u5173\u8054\u53d1\u7968\uff0c\u6240\u9009\u53d1\u7968\u4e0d\u5305\u542b\u53d1\u7968id\uff1a%s", invoice.getPkValue(), allInvoice.getPkValue()));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e3a\uff1a%s\u6240\u5173\u8054\u7684\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u786e\u8ba4\u5e94\u6536\uff0c\u9700\u5c06\u8be5\u5f00\u7968\u7533\u8bf7\u6240\u5173\u8054\u7684\u6240\u6709\u53d1\u7968\u8fdb\u884c\u4f5c\u5e9f\uff0c \u8bf7\u68c0\u67e5\u3002", (String)"BotpHelper_81", (String)"imc-bdm-common", (Object[])new Object[0]), invoice.getString("invoiceno")));
            }
            needConfirmInvoices.add(invoice.getLong("id"));
            Collections.addAll(billPkSet, allBillPks.toArray(new Long[0]));
        }
        return billPkSet;
    }

    private static void checkRelateInvoiceChoosed(HashSet<Object> invoicePkSet, List<Long> needConfirmInvoices, DynamicObject invoice, String operateDescription, HashSet<Long> invoiceRelateBills) {
        DynamicObject[] relations = RelationHelper.getRelationByInvoice(invoice);
        RelationProcessDTO process = RelationHelper.getProcess(relations);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"pushamount,closestatus,systemsource", (QFilter[])new QFilter("id", "in", (Object)process.getsBillIdSet().toArray(new Object[0])).toArray());
        Set<Long> tbillIds = RelationHelper.queryTbillIds(bills);
        boolean isConfirmAr = BotpHelper.isConfirm(bills);
        if (isConfirmAr) {
            Set<Long> billIdSet = Arrays.stream(bills).map(o -> o.getLong("id")).collect(Collectors.toSet());
            ArrayList<Long> arBillPkList = BotpHelper.getArBillPksFromOriginalBillPks(billIdSet);
            Set<Long> allBillPks = BotpHelper.queryUploadPks(arBillPkList);
            if (allBillPks.size() != 1) {
                tbillIds = RelationHelper.queryTbillIdsByBillIds(allBillPks);
            }
            BotpHelper.containsAllRelateInvoices(invoicePkSet, tbillIds, invoice, operateDescription);
            needConfirmInvoices.add(invoice.getLong("id"));
            Collections.addAll(invoiceRelateBills, allBillPks.toArray(new Long[0]));
        }
    }

    public static boolean confirm(List<Long> arPks) {
        Map map;
        try {
            map = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"ArWriteoffByInvCloudService", (String)"execute", (Object[])new Object[]{arPks});
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        boolean isSuccess = false;
        LOGGER.info(String.format("ArWriteoffByInvCloudServiceResult:%s", JSONObject.toJSONString((Object)map)));
        if (null != map) {
            isSuccess = (Boolean)map.get("isSuccess");
            String errMsg = String.valueOf(map.get("errMsg"));
            if (!isSuccess && !BotpHelper.isAllFiArBillWriteOff(arPks)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5173\u8054\u5e94\u6536\u5355\u636e\u51b2\u9500\u5931\u8d25\uff1a%s", (String)"BotpHelper_82", (String)"imc-bdm-common", (Object[])new Object[0]), errMsg));
            }
            if (!isSuccess && StringUtils.isNotBlank((CharSequence)errMsg)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5173\u8054\u5e94\u6536\u5355\u636e\u51b2\u9500\u5931\u8d25\uff1a%s", (String)"BotpHelper_82", (String)"imc-bdm-common", (Object[])new Object[0]), errMsg));
            }
        }
        return isSuccess;
    }

    public static boolean isAllFiArBillWriteOff(List<Long> arPks) {
        DynamicObject[] fiBills;
        boolean isAllWriteOff = true;
        for (DynamicObject fiBill : fiBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"hadwrittenoff", (QFilter[])new QFilter("id", "in", (Object)arPks.toArray(new Object[0])).toArray())) {
            if (fiBill.getBoolean("hadwrittenoff")) continue;
            isAllWriteOff = false;
            break;
        }
        return isAllWriteOff;
    }

    public static boolean isInvoiceBillsConfirmAr(DynamicObject invoice) {
        DynamicObject[] relations = RelationHelper.getRelationByInvoice(invoice);
        RelationProcessDTO process = RelationHelper.getProcess(relations);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"pushamount,closestatus,systemsource", (QFilter[])new QFilter("id", "in", (Object)process.getsBillIdSet().toArray(new Object[0])).toArray());
        return BotpHelper.isConfirm(bills);
    }

    public static boolean isConfirm(DynamicObject[] bills) {
        Set<Long> billPks = Arrays.stream(bills).map(o -> o.getLong("id")).collect(Collectors.toSet());
        ArrayList<Long> arBill = BotpHelper.getArBillPksFromOriginalBillPks(billPks);
        boolean isPushAr = arBill.size() > 0;
        boolean isConfirmAr = false;
        for (DynamicObject bill : bills) {
            boolean fromArFi = BotpHelper.isFromArFi(bill.getString("systemsource"));
            boolean isClosed = "1".equals(bill.getString("closestatus"));
            if (fromArFi || !isPushAr || !isClosed) continue;
            isConfirmAr = true;
            break;
        }
        return isConfirmAr;
    }

    public static void containsAllRelateInvoices(Set<Object> invoicePkSet, Set<Long> relateInvoices, DynamicObject invoice, String operateDescription) {
        DynamicObject[] tInvoices;
        if (StringUtils.isBlank((CharSequence)operateDescription)) {
            operateDescription = ResManager.loadKDString((String)"\u7ea2\u51b2", (String)"BotpHelper_76", (String)"imc-bdm-common", (Object[])new Object[0]);
        }
        for (DynamicObject tInvoice : tInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "remainredamount", "invoicestatus", "id"), (QFilter[])new QFilter("id", "in", (Object)relateInvoices.toArray()).toArray())) {
            if ("6".equals(tInvoice.getString("invoicestatus")) || BigDecimal.ZERO.compareTo(tInvoice.getBigDecimal("remainredamount")) == 0 || invoicePkSet.contains(tInvoice.get("id"))) continue;
            LOGGER.info(String.format(ResManager.loadKDString((String)"\u6839\u636e\u53d1\u7968%1$s\u67e5\u8be2\u7684\u5355\u636e\u603b\u5173\u8054\u53d1\u7968\uff0c\u6240\u9009\u53d1\u7968\u4e0d\u5305\u542b\u53d1\u7968id\uff1a%2$s", (String)"BotpHelper_77", (String)"imc-bdm-common", (Object[])new Object[0]), invoice.getPkValue(), tInvoice.get("id")));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e3a\uff1a%1$s\u6240\u5173\u8054\u7684\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u786e\u8ba4\u5e94\u6536\uff0c\u9700\u5c06\u8be5\u5f00\u7968\u7533\u8bf7\u6240\u5173\u8054\u7684\u6240\u6709\u53d1\u7968\u8fdb\u884c%2$s\uff0c \u8bf7\u68c0\u67e5\u3002", (String)"BotpHelper_92", (String)"imc-bdm-common", (Object[])new Object[0]), invoice.getString("invoiceno"), operateDescription));
        }
    }

    public static boolean isSrcCancelRedMarked(DynamicObject waitInvoice) {
        DynamicObject[] froms;
        if (IssueType.BLUE_INVOICE.getTypeCode().equals(waitInvoice.getString("issuetype"))) {
            return false;
        }
        if (InvoiceUtils.isAllEInvoice(waitInvoice.getString("invoicetype"))) {
            Long orgPk = DynamicObjectUtil.getDynamicObjectLongValue(waitInvoice.get("orgid"));
            Object infoCode = waitInvoice.get("infocode");
            QFilter baseFilter = ImcBaseDataHelper.getRedConfirmFilter(orgPk);
            QFilter filter = new QFilter("number", "=", infoCode).and(baseFilter);
            froms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"cancelredlable", (QFilter[])filter.toArray());
        } else if (InvoiceUtils.isSpecialInvoice(waitInvoice.getString("invoicetype"))) {
            Long orgPk = DynamicObjectUtil.getDynamicObjectLongValue(waitInvoice.get("orgid"));
            Object infoCode = waitInvoice.get("infocode");
            QFilter filter = new QFilter("infocode", "=", infoCode).and("org", "=", (Object)orgPk);
            froms = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"cancelredlable", (QFilter[])filter.toArray());
        } else {
            String oriInvoiceCode = waitInvoice.getString("originalinvoicecode");
            String oriInvoiceNo = waitInvoice.getString("originalinvoiceno");
            String sellerTaxNo = waitInvoice.getString("salertaxno");
            froms = InvoiceUtils.getInvoice(sellerTaxNo, oriInvoiceCode, oriInvoiceNo);
        }
        return froms.length > 0 && BaseInvoiceConstant.CanCancelLable.YES.equals(froms[0].getString("cancelredlable"));
    }

    public static void dealHistoryData() {
        String tenant = RequestContext.get().getTenantId();
        final String endCacheKey = tenant + "originalBillHistoryDealEnd";
        if (endCacheKey.equals(CacheHelper.get(endCacheKey))) {
            return;
        }
        QFilter filter = new QFilter("config_key", "=", (Object)"originalBillHistoryDealEnd").and("config_value", "=", (Object)"end");
        if (QueryServiceHelper.exists((String)"invsm_param_configuration", (QFilter[])filter.toArray())) {
            CacheHelper.put(endCacheKey, endCacheKey, 25920000);
            return;
        }
        final String dealingKey = tenant + "originalBillHistoryDealing";
        if (dealingKey.equals(CacheHelper.get(dealingKey))) {
            return;
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"dealHistoryPushData", (Runnable)new Runnable(){

            @Override
            public void run() {
                BotpHelper.startDealData(endCacheKey, dealingKey);
            }
        });
    }

    private static void startDealData(String endCacheKey, String dealingKey) {
        try {
            DynamicObject startConfig;
            Date start = new Date();
            CacheHelper.put(dealingKey, dealingKey);
            QFilter startFilter = new QFilter("config_type", "=", (Object)"originalBillHistoryDealStart");
            DynamicObject[] config = BusinessDataServiceHelper.load((String)"invsm_param_configuration", (String)PropertieUtil.getAllPropertiesSplitByComma("invsm_param_configuration"), (QFilter[])startFilter.toArray());
            if (config.length == 0) {
                startConfig = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
                startConfig.set("config_type", (Object)"originalBillHistoryDealStart");
                Date end = new Date();
                String endStr = DateUtils.format(end, "yyyy-MM-dd HH:mm:ss");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(end);
                calendar.add(2, -6);
                Date startTime = calendar.getTime();
                startConfig.set("config_key", (Object)DateUtils.format(startTime, "yyyy-MM-dd HH:mm:ss"));
                startConfig.set("config_value", (Object)endStr);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{startConfig});
            } else {
                startConfig = config[0];
            }
            String endTimeStr = startConfig.getString("config_value");
            String startTimeStr = startConfig.getString("config_key");
            Date endDate = DateUtils.stringToDate(endTimeStr, "yyyy-MM-dd HH:mm:ss");
            Date startDate = DateUtils.stringToDate(startTimeStr, "yyyy-MM-dd HH:mm:ss");
            QFilter filter = new QFilter("createdate", "<=", (Object)endDate).and("createdate", ">=", (Object)startDate).and("unpushamount", "=", (Object)0).and("pushamount", "=", (Object)0);
            for (int i = 0; i < 1000; ++i) {
                String fields = "billno,systemsource,fromcurr,pushlocalamount,unpushlocalamount,unpushamount,totalamount,pushamount,foreigntotalamount,sim_original_bill_item.unpushnum,sim_original_bill_item.num,sim_original_bill_item.unpushlocalamt,sim_original_bill_item.taxamount,sim_original_bill_item.fromtaxamount,sim_original_bill_item.rowtype,sim_original_bill_item.pushnum,sim_original_bill_item.pushamt,sim_original_bill_item.unpushamt,sim_original_bill_item.pushlocalamt,sim_original_bill_item.unpushlocalamt";
                DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)fields, (QFilter[])filter.toArray(), (String)"id desc", (int)500);
                if (bills.length == 0) {
                    BotpHelper.markEnd();
                    Date dateEnd = new Date();
                    int seconds = DateUtils.timeDifferenceSecond(dateEnd, start);
                    LOGGER.info("originalBillHistoryDealEndTime:" + seconds);
                    CacheHelper.put(endCacheKey, endCacheKey, 25920000);
                    break;
                }
                BotpHelper.dealBusiness(bills);
            }
            LOGGER.info("originalBillHistoryDealEnd1000");
        }
        catch (Exception e) {
            LOGGER.error(String.format("originalBillHistoryDealEnd:%s", e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            CacheHelper.remove(dealingKey);
        }
    }

    private static void markEnd() {
        DynamicObject endConfig = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
        endConfig.set("config_type", (Object)"originalBillHistoryDealStart");
        endConfig.set("config_key", (Object)"originalBillHistoryDealEnd");
        endConfig.set("config_value", (Object)"end");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{endConfig});
    }

    public static void dealBusiness(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            String systemSource = bill.getString("systemsource");
            BotpHelper.dealBillPushFields(bill, BotpHelper.isFromArFiOrArInv(systemSource));
            DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
            BigDecimal unpushAmount = bill.getBigDecimal("unpushamount");
            BigDecimal pushAmount = bill.getBigDecimal("pushamount");
            if (items.size() != 0 && (BigDecimal.ZERO.compareTo(pushAmount) != 0 || BigDecimal.ZERO.compareTo(unpushAmount) != 0)) continue;
            bill.set("unpushamount", (Object)BigDecimal.ONE);
            bill.set("pushamount", (Object)BigDecimal.ONE);
        }
        if (bills.length > 0) {
            SaveServiceHelper.update((DynamicObject[])bills);
        }
    }

    public static boolean isArNeedShowTip(Set<Long> billPks) {
        String ids = JSONObject.toJSONString(billPks);
        boolean isShowTip = false;
        try {
            isShowTip = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"ArOriginalMessageService", (String)"isExistIsVoucher", (Object[])new Object[]{ids});
            LOGGER.info("isArNeedShowTipResult" + isShowTip);
        }
        catch (Exception e) {
            LOGGER.info("isArNeedShowTip" + e.getMessage(), (Object)e);
        }
        return isShowTip;
    }

    public static boolean isRedConfirmOrInfoNeedShowArTips(DynamicObject[] confirmObjs) {
        for (DynamicObject confirmObj : confirmObjs) {
            if (!BotpHelper.isRedConfirmOrInfoNeedShowArTip(confirmObj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRedConfirmOrInfoNeedShowArTip(DynamicObject confirmObj) {
        if (!BotpHelper.isFromAr(confirmObj.getString("systemsource"))) {
            return false;
        }
        QFilter filter = new QFilter("tbillid", "=", confirmObj.getPkValue());
        if (QueryServiceHelper.exists((String)"sim_bill_inv_relation", (QFilter[])filter.toArray())) {
            return false;
        }
        String oriInvoiceCode = confirmObj.getString("originalinvoicecode");
        String oriInvoiceNo = confirmObj.getString("originalinvoiceno");
        DynamicObject[] blueInvoics = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice"), (QFilter[])InvoiceUtils.getInvoiceFilter(oriInvoiceCode, oriInvoiceNo).toArray());
        if (blueInvoics.length == 0) {
            return false;
        }
        if (!BotpHelper.isFromAr(blueInvoics[0].getString("systemsource"))) {
            return false;
        }
        DynamicObject[] oriBills = RelationHelper.getOriBillByInvoice(blueInvoics[0]);
        if (oriBills.length == 0) {
            return false;
        }
        Set<Long> billPkSet = Arrays.stream(oriBills).map(o -> o.getLong("id")).collect(Collectors.toSet());
        return BotpHelper.isArNeedShowTip(billPkSet);
    }

    public static boolean isRedNeedShowArTip(DynamicObject invoice) {
        String systemSource = invoice.getString("systemsource");
        if (!BotpHelper.isFromAr(systemSource)) {
            return false;
        }
        String issueType = invoice.getString("issuetype");
        if (IssueType.BLUE_INVOICE.getTypeCode().equals(issueType)) {
            return false;
        }
        DynamicObject[] relations = RelationHelper.getRelationByInvoice(invoice);
        if (relations.length > 0) {
            return false;
        }
        String oriInvoiceCode = invoice.getString("originalinvoicecode");
        String oriInvoiceNo = invoice.getString("originalinvoiceno");
        QFilter allFilter = new QFilter("invoicecode", "=", (Object)oriInvoiceCode).and(new QFilter("invoiceno", "=", (Object)oriInvoiceNo));
        DynamicObject[] oriBlueInvoice = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])allFilter.toArray());
        if (oriBlueInvoice.length == 0) {
            return false;
        }
        String blueSystemSource = oriBlueInvoice[0].getString("systemsource");
        if (!BotpHelper.isFromAr(blueSystemSource)) {
            return false;
        }
        DynamicObject[] bills = RelationHelper.getOriBillByInvoice(oriBlueInvoice[0]);
        if (bills.length == 0) {
            return false;
        }
        Set<Long> oriPks = Arrays.stream(bills).map(o -> o.getLong("id")).collect(Collectors.toSet());
        return BotpHelper.isArNeedShowTip(oriPks);
    }

    public static boolean needCancelShowArTip(DynamicObject[] invoiceList) {
        HashSet<Long> billPks = new HashSet<Long>();
        for (DynamicObject invoice : invoiceList) {
            DynamicObject[] bills;
            if (!BotpHelper.isFromAr(invoice.getString("systemsource")) || (bills = RelationHelper.getOriBillByInvoice(invoice)).length <= 0) continue;
            billPks.addAll(Arrays.stream(bills).map(o -> o.getLong("id")).collect(Collectors.toSet()));
        }
        if (billPks.size() > 0) {
            return BotpHelper.isArNeedShowTip(billPks);
        }
        return false;
    }

    static class Version {
        private String id;
        private String ownVersion;
        private String productNumber;
        private Date upgradeTime;

        Version() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getVersion() {
            return this.ownVersion;
        }

        public void setVersion(String ownVersion) {
            this.ownVersion = ownVersion;
        }

        String getProductNumber() {
            return this.productNumber;
        }

        void setProductNumber(String productNumber) {
            this.productNumber = productNumber;
        }

        Date getUpgradeTime() {
            return this.upgradeTime;
        }

        void setUpgradeTime(Date upgradeTime) {
            this.upgradeTime = upgradeTime;
        }
    }
}

