/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.ComponentRequest;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.dto.MoudleDataDTO;
import kd.imc.bdm.common.dto.PaperInvoiceRollInfoDTO;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.sdk.annotation.SdkDeprecated;

public class EquipmentHelper {
    public static final String CACHE_KEY_EQUIPMENT_VOLUMN_INFO = "EQUIPMENT:VOLUMN:INFO:";
    private static final Log LOGGER = LogFactory.getLog(EquipmentHelper.class);

    public static String getEquipmentTypeByNo(String equipmentNo) {
        String cacheEquipmengType;
        String equipmentType = "";
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)equipmentNo)) {
            QFilter filter = new QFilter("equipmentno", "=", (Object)equipmentNo);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_tax_equipment", (String)"equipmenttype", (QFilter[])filter.toArray());
            String string = equipmentType = dynamicObject == null ? "" : dynamicObject.getString("equipmenttype");
        }
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)(cacheEquipmengType = CacheHelper.get("equipment_type_for_unit_test")))) {
            return cacheEquipmengType;
        }
        return equipmentType;
    }

    public static Set<String> getInvoiceTypeByEquipmentType(String equipmentType) {
        switch (equipmentType) {
            case "3": {
                return ImmutableSet.of((Object)InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), (Object)InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode());
            }
            case "0": 
            case "1": 
            case "2": {
                return ImmutableSet.of((Object)InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), (Object)InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), (Object)InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode());
            }
        }
        return ImmutableSet.of();
    }

    public static boolean checkIsSupportSelectInvoiceRoll(String invoiceType, String equipmentType) {
        return InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType) && equipmentType.equals("2");
    }

    public static PaperInvoiceRollInfoDTO queryPaperInvoiceRollInfo(String invoiceType, String equipmentNo) {
        return EquipmentHelper.queryComponentEquipmentInfo(invoiceType, equipmentNo, 1);
    }

    public static PaperInvoiceRollInfoDTO queryComponentEquipmentInfo(String invoiceType, String equipmentNo, int type) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)equipmentNo)) {
            return null;
        }
        String typeCodeHx = InvoiceType.getTypeCodeHx(invoiceType);
        PaperInvoiceRollInfoDTO paperInvoiceRollInfoDTO = null;
        ComponentRequest request = new ComponentRequest(ComponentInterfaceTypeEnum.GETINVOICEINFO.getCzlx(), null, null, "");
        request.setInvoice_type(typeCodeHx);
        String url = ComponentServiceHelper.getComponentRequestUrl((String)equipmentNo);
        ComponentResponse response = UnitTestHelper.isUnitTest() ? new ComponentResponse("0000", "0000") : ComponentServiceHelper.doPost((String)url, (String)JSON.toJSONString((Object)request), PaperInvoiceRollInfoDTO.class);
        if (!response.isSucess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u5377\u4fe1\u606f\u5931\u8d25:%s", (String)"EquipmentHelper_22", (String)"imc-bdm-common", (Object[])new Object[0]), response.getDescription()));
        }
        if (type == 1) {
            if (response.getResponse() != null && ((PaperInvoiceRollInfoDTO)response.getResponse()).getVolumn().size() > 1) {
                paperInvoiceRollInfoDTO = (PaperInvoiceRollInfoDTO)response.getResponse();
                CacheHelper.put(CACHE_KEY_EQUIPMENT_VOLUMN_INFO + equipmentNo, JSONObject.toJSONString((Object)paperInvoiceRollInfoDTO));
            }
        } else {
            paperInvoiceRollInfoDTO = (PaperInvoiceRollInfoDTO)response.getResponse();
            CacheHelper.put(CACHE_KEY_EQUIPMENT_VOLUMN_INFO + equipmentNo, JSONObject.toJSONString((Object)paperInvoiceRollInfoDTO));
        }
        return paperInvoiceRollInfoDTO;
    }

    public static void AsyncSaveDevicesStockData(String remoteUrl, String equipmentNo) {
        String cacheKey = "queryEquipemntData" + equipmentNo;
        if (org.apache.commons.lang.StringUtils.isBlank((String)CacheHelper.get(cacheKey))) {
            ThreadPools.executeOnceIncludeRequestContext((String)"saveDeviceStockData", () -> EquipmentHelper.saveDeviceStockData(remoteUrl, equipmentNo));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveDeviceStockData(String remoteUrl, String equipmentNo) {
        LOGGER.info(String.format("saveDeviceStockData:%s", equipmentNo));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u5b58\u50a8\u5e93\u5b58\u4fe1\u606f,\u8bbe\u5907\u53f7:%s", equipmentNo));
        }
        String lockKey = "saveDeviceStockData" + equipmentNo;
        try (DLock lock = DLock.create((String)lockKey);){
            if (!lock.tryLock(100L)) throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"EquipmentHelper_3", (String)"imc-bdm-common", (Object[])new Object[0]));
            MoudleDataDTO moudleDataDTO = EquipmentHelper.queryEquipemntData(remoteUrl, equipmentNo);
            if (null == moudleDataDTO) return false;
            DynamicObject stock = EquipmentHelper.dealStock(equipmentNo, moudleDataDTO);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stock});
            LOGGER.info(String.format("\u5b58\u50a8\u5e93\u5b58\u4fe1\u606f\u6210\u529f,\u8bbe\u5907\u53f7:%s", equipmentNo));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error(String.format("saveDeviceStockData\u5931\u8d25:%s", e.getMessage()), (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveDeviceStockDataWithoutCache(String remoteUrl, String equipmentNo) {
        LOGGER.info(String.format("saveDeviceStockData:%s", equipmentNo));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u5b58\u50a8\u5e93\u5b58\u4fe1\u606f,\u8bbe\u5907\u53f7:%s", equipmentNo));
        }
        String lockKey = "saveDeviceStockData" + equipmentNo;
        try (DLock lock = DLock.create((String)lockKey);){
            if (!lock.tryLock(100L)) throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"EquipmentHelper_3", (String)"imc-bdm-common", (Object[])new Object[0]));
            MoudleDataDTO moudleDataDTO = EquipmentHelper.queryEquipemntDataWithoutCache(remoteUrl);
            if (ErrorType.FAIL.getCode().equals(moudleDataDTO.getErrcode())) return false;
            DynamicObject stock = EquipmentHelper.dealStock(equipmentNo, moudleDataDTO);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stock});
            LOGGER.info(String.format("\u5b58\u50a8\u5e93\u5b58\u4fe1\u606f\u6210\u529f,\u8bbe\u5907\u53f7:%s", equipmentNo));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error(String.format("saveDeviceStockData\u5931\u8d25:%s", e.getMessage()), (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicObject dealStock(String equipmentNo, MoudleDataDTO moudleDataDTO) throws Exception {
        DynamicObject stock;
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_stock_manage", (String)"einvoicestock,especialinvoicestock,invoicestock,specialinvoicestock,modifier,modifytime,taxno", (QFilter[])new QFilter("equipmentno", "=", (Object)equipmentNo).toArray());
        if (null == array || array.length == 0) {
            boolean isSuccess = EquipmentHelper.refreshEquipmentRelateOrg(new Object[]{equipmentNo});
            if (!isSuccess) throw new Exception(String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u53f7\uff1a%s\u521b\u5efa\u65b0\u7684\u8bbe\u5907\u5e93\u5b58\u5931\u8d25", (String)"EquipmentHelper_5", (String)"imc-bdm-common", (Object[])new Object[0]), equipmentNo));
            DynamicObject[] newArray = BusinessDataServiceHelper.load((String)"bdm_stock_manage", (String)"einvoicestock,especialinvoicestock,invoicestock,specialinvoicestock,modifier,modifytime,taxno", (QFilter[])new QFilter("equipmentno", "=", (Object)equipmentNo).toArray());
            stock = newArray[0];
        } else {
            stock = array[0];
        }
        EquipmentHelper.updateInvoiceStock(moudleDataDTO, stock);
        return stock;
    }

    public static void checkTerminalNo(String jqbh, String taxNo, String terminalNoObj) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)jqbh)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bbe\u5907\u7f16\u53f7", (String)"EquipmentHelper_6", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        DynamicObject equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNo(jqbh, taxNo);
        if (equipment != null) {
            if ("8".equals(equipment.getString("equipmenttype")) && (terminalNoObj == null || StringUtils.isEmpty((CharSequence)terminalNoObj))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u767e\u671b\u670d\u52a1\u5668\u5f00\u7968\u7c7b\u578b\uff0c\u7ec8\u7aef\u53f7\u5fc5\u586b", (String)"EquipmentHelper_7", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%1$s\u5bf9\u5e94\u7684\u7ec4\u7ec7\u672a\u627e\u5230\u8bbe\u5907\u7f16\u53f7\u4e3a%2$s\u7684\u8bbe\u5907", (String)"EquipmentHelper_23", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo, jqbh));
        }
    }

    public static void checkTerminalNo(String jqbh, String taxNo, String terminalNoObj, String invoiceType) {
        DynamicObject equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNo(jqbh, taxNo);
        if (null != equipment && !"8".equals(equipment.getString("equipmenttype")) && org.apache.commons.lang.StringUtils.isEmpty((String)jqbh)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bbe\u5907\u7f16\u53f7", (String)"EquipmentHelper_6", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        if (equipment != null) {
            if ("8".equals(equipment.getString("equipmenttype")) && ("004".equals(invoiceType) || "007".equals(invoiceType)) && (terminalNoObj == null || StringUtils.isEmpty((CharSequence)terminalNoObj))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u767e\u671b\u670d\u52a1\u5668\u5f00\u7eb8\u7968\uff0c\u7ec8\u7aef\u53f7\u5fc5\u586b", (String)"EquipmentHelper_9", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%1$s\u5bf9\u5e94\u7684\u7ec4\u7ec7\u672a\u627e\u5230\u8bbe\u5907\u7f16\u53f7\u4e3a%2$s\u7684\u8bbe\u5907", (String)"EquipmentHelper_23", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo, jqbh));
        }
    }

    public static void checkTerminalNo(Object equipmentTypeObj, Object terminalNoObj, int i) {
        String equipmentType = (String)equipmentTypeObj;
        if ("8".equals(equipmentType) && (terminalNoObj == null || StringUtils.isEmpty((CharSequence)((String)terminalNoObj)))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u662f\u767e\u671b\u670d\u52a1\u5668\u5f00\u7968\u7c7b\u578b\uff0c\u7ec8\u7aef\u53f7\u5fc5\u586b", (String)"EquipmentHelper_10", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1));
        }
    }

    public static boolean isHostModeDevice(String issueSource) {
        return ImmutableSet.of((Object)"4", (Object)"6", (Object)"7").contains((Object)issueSource);
    }

    public static boolean isBlockChainOrHostModeDevice(String issueSource) {
        return ImmutableSet.of((Object)"4", (Object)"6", (Object)"7", (Object)"5").contains((Object)issueSource);
    }

    public static boolean isComponentDevice(String issueSource) {
        return ImmutableSet.of((Object)"2", (Object)"1", (Object)"0").contains((Object)issueSource);
    }

    public static void updateInvoiceStock(MoudleDataDTO moudleDataDTO, DynamicObject stock) {
        stock.set("einvoicestock", org.apache.commons.lang.StringUtils.isBlank((String)moudleDataDTO.getDjdpfpsyfs()) ? Integer.valueOf(0) : moudleDataDTO.getDjdpfpsyfs());
        stock.set("especialinvoicestock", org.apache.commons.lang.StringUtils.isBlank((String)moudleDataDTO.getDjdpzyfpsyfs()) ? Integer.valueOf(0) : moudleDataDTO.getDjdpzyfpsyfs());
        stock.set("invoicestock", org.apache.commons.lang.StringUtils.isBlank((String)moudleDataDTO.getPtfpsyfs()) ? Integer.valueOf(0) : moudleDataDTO.getPtfpsyfs());
        stock.set("specialinvoicestock", org.apache.commons.lang.StringUtils.isBlank((String)moudleDataDTO.getZyfpsyfs()) ? Integer.valueOf(0) : moudleDataDTO.getZyfpsyfs());
        stock.set("modifier", (Object)RequestContext.get().getUserId());
        stock.set("modifytime", (Object)new Date());
    }

    public static MoudleDataDTO queryEquipemntData(String remoteUrl, String equipmentNo) {
        String cacheKey = "queryEquipemntData" + equipmentNo;
        if (org.apache.commons.lang.StringUtils.isBlank((String)CacheHelper.get(cacheKey))) {
            CacheHelper.put(cacheKey, cacheKey, 300);
            SaleInfo saleInfo = UnitTestHelper.isUnitTest() ? new SaleInfo() : TaxUtils.getSaleInfoByOrg();
            ComponentRequest request = new ComponentRequest(ComponentInterfaceTypeEnum.GETTAXDISKINFO.getCzlx(), null, null, saleInfo.getDefaultTerminal());
            ComponentResponse response = UnitTestHelper.isUnitTest() ? new ComponentResponse("0", ResManager.loadKDString((String)"\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"EquipmentHelper_28", (String)"imc-bdm-common", (Object[])new Object[0])) : ComponentServiceHelper.doPost((String)remoteUrl, (String)JSON.toJSONString((Object)request), MoudleDataDTO.class);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("queryEquipemntData\u8fd4\u56de:%s", SerializationUtils.toJsonString((Object)response)));
            }
            if ("0".equals(response.getErrcode())) {
                return (MoudleDataDTO)response.getResponse();
            }
        }
        return null;
    }

    public static MoudleDataDTO queryEquipemntDataWithoutCache(String remoteUrl) {
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg();
        ComponentRequest request = new ComponentRequest(ComponentInterfaceTypeEnum.GETTAXDISKINFO.getCzlx(), null, null, saleInfo.getDefaultTerminal());
        ComponentResponse response = UnitTestHelper.isUnitTest() ? new ComponentResponse("0", ResManager.loadKDString((String)"NoHttpResponseException,\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"EquipmentHelper_29", (String)"imc-bdm-common", (Object[])new Object[0])) : ComponentServiceHelper.doPost((String)remoteUrl, (String)JSON.toJSONString((Object)request), MoudleDataDTO.class);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("queryEquipemntData\u8fd4\u56de:%s", SerializationUtils.toJsonString((Object)response)));
        }
        if ("0".equals(response.getErrcode())) {
            return (MoudleDataDTO)response.getResponse();
        }
        MoudleDataDTO dto = new MoudleDataDTO();
        dto.setDescription(response.getDescription());
        dto.setErrcode(ErrorType.FAIL.getCode());
        return dto;
    }

    public static BigDecimal getDevLimitAmountByInvoiceType(String invoiceType, String equipmentNo) {
        LOGGER.info(String.format("getDevLimitAmountByInvoiceType\uff1a%s%s", invoiceType, equipmentNo));
        String selectStr = "";
        if ("004".equals(invoiceType)) {
            selectStr = "paperzticketquota";
        } else if ("007".equals(invoiceType)) {
            selectStr = "paperpticketquota";
        } else if ("028".equals(invoiceType)) {
            selectStr = "electzticketquota";
        } else if ("026".equals(invoiceType)) {
            selectStr = "electpticketquota";
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_tax_equipment", (String)selectStr, (QFilter[])new QFilter("equipmentno", "=", (Object)equipmentNo).toArray());
        if (dynamicObject == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7%s\u4e0d\u5b58\u5728", (String)"EquipmentHelper_14", (String)"imc-bdm-common", (Object[])new Object[0]), equipmentNo));
        }
        return dynamicObject.getBigDecimal(selectStr);
    }

    public static DynamicObject[] queryEquipmentRelateOrgs(Object equipmentNo) {
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)"id", (QFilter[])new QFilter("equipmentno", "=", equipmentNo).toArray());
        if (array.length > 0) {
            Object pkValue = array[0].getPkValue();
            return BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", (QFilter[])new QFilter("devlist_tag", "like", (Object)("%" + pkValue + "%")).toArray());
        }
        return new DynamicObject[0];
    }

    public static void asyncRefreshEuipmentRelateOrg(Object[] devNos) {
        ThreadPools.executeOnceIncludeRequestContext((String)"asyncRefreshEuipmentRelateOrg", () -> EquipmentHelper.refreshEquipmentRelateOrg(devNos));
    }

    public static boolean refreshEquipmentRelateOrg(Object[] devNos) {
        try {
            LOGGER.info("refreshEquipmentRelateOrg:" + JSONObject.toJSONString((Object)devNos));
            HashSet<Object> oldOrgs = new HashSet<Object>();
            for (Object devNo : devNos) {
                DynamicObject stock;
                if (org.apache.commons.lang.StringUtils.isBlank((String)((String)devNo))) continue;
                DynamicObject[] dynamicObjects = EquipmentHelper.queryEquipmentRelateOrgs(devNo);
                if (dynamicObjects.length <= 0) {
                    LOGGER.info(String.format("refreshEquipmentRelateOrg\u8bbe\u5907\uff1a%s\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u5173\u8054\u7684\u7ec4\u7ec7", devNo));
                    continue;
                }
                DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bdm_stock_manage", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_stock_manage", true), (QFilter[])new QFilter("equipmentno", "=", devNo).toArray());
                DynamicObject[] equipments = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_tax_equipment", true), (QFilter[])new QFilter("equipmentno", "=", devNo).toArray());
                if (equipments.length <= 0) {
                    LOGGER.info(String.format("refreshEquipmentRelateOrg\u8bbe\u5907\uff1a%s\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u8bbe\u5907\u57fa\u7840\u8d44\u6599", devNo));
                    continue;
                }
                DynamicObject equipment = equipments[0];
                boolean isNew = false;
                if (ids.length > 0) {
                    stock = ids[0];
                } else {
                    isNew = true;
                    stock = BusinessDataServiceHelper.newDynamicObject((String)"bdm_stock_manage");
                    stock.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
                    stock.set("createtime", (Object)new Date());
                }
                stock.set("taxno", equipment.get("epinfo.number"));
                stock.set("epname", equipment.get("epinfo.name"));
                stock.set("equipmentno", devNo);
                stock.set("equipmenttype", equipment.get("equipmenttype"));
                stock.set("billstatus", (Object)"C");
                stock.set("modifytime", (Object)new Date());
                stock.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                DynamicObjectCollection collection = stock.getDynamicObjectCollection("items");
                if (collection.size() > 0) {
                    for (DynamicObject object : collection) {
                        oldOrgs.add(object.getDynamicObject("useorg").getPkValue());
                    }
                }
                for (DynamicObject object : dynamicObjects) {
                    if (oldOrgs.contains(object.getPkValue())) continue;
                    DynamicObject item = collection.addNew();
                    item.set("useorg", (Object)object);
                }
                oldOrgs.clear();
                if (isNew) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stock});
                } else {
                    SaveServiceHelper.update((DynamicObject)stock);
                }
                LOGGER.info(devNo + "refreshEquipmentRelateOrg:SUCCESS");
            }
            LOGGER.info("refreshEquipmentRelateOrg:SUCCESS");
            return true;
        }
        catch (Throwable e) {
            LOGGER.error("refreshEquipmentRelateOrg:" + e.getMessage(), e);
            return false;
        }
    }

    public static Boolean isDevOnline(String devNo) {
        Boolean result = Boolean.FALSE;
        try {
            JSONObject object;
            if (UnitTestHelper.isUnitTest()) {
                object = new JSONObject();
                object.put("errcode", (Object)"0000");
            } else {
                object = EquipmentHelper.getComponentDevInfo(devNo);
            }
            String errcode = object.getString("errcode");
            if ("0".equals(errcode) || "0000".equals(errcode) || "7011".equals(errcode)) {
                result = Boolean.TRUE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static JSONObject getComponentDevInfo(String devNo) {
        String componentRequestUrl = ComponentServiceHelper.getComponentRequestUrl((String)devNo);
        JSONObject requestData = new JSONObject();
        requestData.put("czlx", (Object)"7");
        requestData.put("sfrz", null);
        requestData.put("hxbzdh", (Object)"");
        return ComponentServiceHelper.doPost((String)componentRequestUrl, (String)JSONObject.toJSONString((Object)requestData));
    }

    public static boolean isEnable(Object salerTaxNo, Object devNo) {
        QFilter filter = new QFilter("equipmentno", "=", devNo).and("epinfo.number", "=", salerTaxNo).and("disen", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"bdm_tax_equipment", (QFilter[])filter.toArray());
    }

    public static boolean isDisable(Object salerTaxNo, Object devNo) {
        QFilter filter = new QFilter("equipmentno", "=", devNo).and("epinfo.number", "=", salerTaxNo).and("disen", "=", (Object)"0");
        return QueryServiceHelper.exists((String)"bdm_tax_equipment", (QFilter[])filter.toArray());
    }

    public static boolean isDisableJQBH(Object salerTaxNo, Object devNo) {
        if (null == devNo || org.apache.commons.lang.StringUtils.isBlank((String)String.valueOf(devNo))) {
            return false;
        }
        return !EquipmentHelper.isEnable(salerTaxNo, devNo);
    }

    public static QFilter getEnableFilter() {
        return new QFilter("disen", "=", (Object)"1");
    }

    public static boolean isBatchEnablefromCache(String salerTaxNo, String devNo, String batchNo) {
        boolean enable;
        if (org.apache.commons.lang.StringUtils.isBlank((String)batchNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"batchNo\u4e0d\u80fd\u4e3a\u7a7a", (String)"EquipmentHelper_17", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        String cacheKey = "CacheDevNo" + batchNo + salerTaxNo + devNo;
        String isEnable = CacheHelper.get(cacheKey);
        if (org.apache.commons.lang.StringUtils.isBlank((String)isEnable)) {
            enable = EquipmentHelper.isEnable(salerTaxNo, devNo);
            CacheHelper.put(cacheKey, enable ? "1" : "0", 60);
        } else {
            enable = "1".equalsIgnoreCase(isEnable);
        }
        return enable;
    }

    public static void checkOriginalBillJQBH(DynamicObject bill) {
        EquipmentHelper.checkOriginalBillsJQBH(new DynamicObject[]{bill}, null);
    }

    @SdkDeprecated
    public static void checkIssueOriginalBillJQBH(DynamicObject bill) {
        String description = ResManager.loadKDString((String)"\u7a0e\u53f7\uff1a%1$s\u4e0b\u4e0d\u5b58\u5728\u542f\u7528\u7684\u8bbe\u5907%2$s\uff0c\u65e0\u6cd5\u5f00\u7968\u3002\u8bf7\u542f\u7528\u8be5\u8bbe\u5907\u6216\u91cd\u65b0\u9009\u62e9\u8bbe\u5907\u540e\u518d\u4e0b\u63a8\u5355\u636e\u5f00\u7968\u3002", (String)"EquipmentHelper_30", (String)"imc-bdm-common", (Object[])new Object[0]);
        EquipmentHelper.checkOriginalBillsJQBH(new DynamicObject[]{bill}, description);
    }

    private static void checkOriginalBillsJQBH(DynamicObject[] bills, String descriptionFormat) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)descriptionFormat)) {
            descriptionFormat = ResManager.loadKDString((String)"\u7a0e\u53f7\uff1a%1$s\u4e0b\u4e0d\u5b58\u5728\u542f\u7528\u7684\u8bbe\u5907\uff1a%2$s\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8bbe\u5907", (String)"EquipmentHelper_25", (String)"imc-bdm-common", (Object[])new Object[0]);
        }
        for (DynamicObject bill : bills) {
            String jqbh;
            String salerTaxNo;
            if (InvoiceUtils.isAllEInvoice(bill.getString("invoicetype")) || !EquipmentHelper.isDisableJQBH(salerTaxNo = bill.getString("salertaxno"), jqbh = bill.getString("jqbh"))) continue;
            throw new KDBizException(String.format(descriptionFormat, salerTaxNo, jqbh));
        }
    }

    public static void checkJQBH(DynamicObject[] invoices) {
        EquipmentHelper.checkJQBH(invoices, null);
    }

    public static void checkIssueJQBH(DynamicObject[] invoices) {
        String descriptionFormat = ResManager.loadKDString((String)"\u7a0e\u53f7%1$s\u4e0b\u4e0d\u5b58\u5728\u542f\u7528\u7684\u8bbe\u5907%2$s\uff0c\u8bf7\u542f\u7528\u8bbe\u5907\u6216\u8005\u91cd\u65b0\u9009\u62e9\u8bbe\u5907\u540e\u5728\u5f00\u7968\u3002", (String)"EquipmentHelper_31", (String)"imc-bdm-common", (Object[])new Object[0]);
        EquipmentHelper.checkJQBH(invoices, descriptionFormat);
    }

    private static void checkJQBH(DynamicObject[] invoices, String descriptionFormat) {
    }
}

