/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.imc.bdm.common.model.CellValue;
import kd.imc.bdm.common.model.FileField;
import kd.imc.bdm.common.model.RowValue;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelHelper {
    public static final String UPLOAD_FILENAME = "filename";
    public static final String UPLOAD_FILEPATH = "filepath";
    public static final String UPLOAD_FILEPANEL = "filepanel";
    public static final String UPLOAD_PANEL = "uploadpanel";
    private static Map<String, String> normalMap;
    private static Map<String, String> percentMap;
    private static Map<String, String> hundredMap;
    private static Log LOGGER;

    @SdkDeprecated
    public static boolean isExcelFile(String suffix) {
        return Lists.newArrayList((Object[])new String[]{".xlsx", ".XLSX", ".xls", ".XLS"}).contains(suffix);
    }

    public static void downloadTemplate(AbstractFormPlugin formPlugin, String templateDir, String templateName) {
        String path = ExcelHelper.getCustomTemplate(templateDir, templateName);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            formPlugin.getView().openUrl(UrlService.getAttachmentFullUrl((String)path));
        } else {
            try (InputStream inStream = formPlugin.getClass().getClassLoader().getResourceAsStream(templateDir + '/' + templateName);){
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(templateName, inStream, 5000);
                formPlugin.getView().openUrl(urls);
            }
            catch (IOException e) {
                LOGGER.error("downloadTemplateFail:" + e.getMessage(), (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff1a%s", (String)"ExcelHelper_13", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    public static void downloadTemplate(AbstractFormPlugin formPlugin, String path) {
        formPlugin.getView().openUrl(UrlService.getAttachmentFullUrl((String)path));
    }

    public static String getCustomTemplate(String templateDir, String templateName) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"bdm_excel_config", (String)"template_path", (QFilter[])ExcelHelper.getCustomQFilter(templateDir, templateName).toArray());
        if (object != null) {
            return object.getString("template_path");
        }
        return null;
    }

    private static Map<String, FileField> getCustomFileField(String templateDir, String templateName) {
        HashMap<String, FileField> fieldMap = new HashMap<String, FileField>(4);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_excel_config", (String)"item.fieldcode,item.fieldname,item.fieldorder,item.required,item.maxlength,item.regex,item.defaultvalue,item.containscontent,item.regexerrormsg,item.checktitle", (QFilter[])ExcelHelper.getCustomQFilter(templateDir, templateName).toArray());
        for (DynamicObject obj : collect) {
            FileField field = new FileField();
            field.setFieldCode(obj.getString("item.fieldcode"));
            if (StringUtils.isEmpty((CharSequence)field.getFieldCode())) continue;
            field.setFieldName(obj.getString("item.fieldname"));
            field.setFieldOrder(obj.getString("item.fieldorder"));
            field.setRequired(obj.getBoolean("item.required"));
            field.setMaxLength(obj.getInt("item.maxlength"));
            field.setRegex(obj.getString("item.regex"));
            field.setRegexErrorMsg(obj.getString("item.regexerrormsg"));
            field.setContainsContent(obj.getString("item.containscontent"));
            field.setCheckTitle(obj.getBoolean("item.checktitle"));
            field.setDefaultValue(obj.getString("item.defaultvalue"));
            field.setIsIsv(Boolean.TRUE);
            fieldMap.put(field.getFieldCode(), field);
        }
        return fieldMap;
    }

    private static QFilter getCustomQFilter(String templateDir, String templateName) {
        int indx = templateName.lastIndexOf(46);
        if (indx > 0) {
            templateName = templateName.substring(0, indx);
        }
        return new QFilter("template_type", "=", (Object)(templateDir + '|' + templateName)).and("status", "=", (Object)"1");
    }

    public static List<FileField> getIsvFieldList(Map<String, FileField> fieldMap) {
        ArrayList<FileField> list = new ArrayList<FileField>(fieldMap.size());
        for (Map.Entry<String, FileField> entry : fieldMap.entrySet()) {
            if (!entry.getValue().getIsIsv().booleanValue()) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public static void setIsvField(DynamicObject object, Map<String, Object> excelvalMap, MainEntityType mainEntityType, List<FileField> fieldlist, Map<String, Object> valCache) {
        if (fieldlist != null && !fieldlist.isEmpty()) {
            block0: for (FileField field : fieldlist) {
                Object exitsVal;
                Object excelVal = excelvalMap.get(field.getFieldCode());
                if (excelVal == null) continue;
                String fieldCode = field.getFieldCode();
                int index = fieldCode.indexOf(46);
                String filterField = null;
                if (index > 0) {
                    filterField = fieldCode.substring(index + 1);
                    fieldCode = fieldCode.substring(0, index);
                }
                if ((exitsVal = valCache.get(field.getFieldCode() + excelVal)) != null) {
                    object.set(fieldCode, exitsVal);
                    continue;
                }
                DynamicProperty property = mainEntityType.getProperty(fieldCode);
                if (property instanceof BasedataProp) {
                    DynamicObject baseobject;
                    BasedataProp basedataProp = (BasedataProp)property;
                    String baseentity = basedataProp.getBaseEntityId();
                    Object filterVal = excelVal.toString();
                    if (filterField == null) {
                        filterField = "id";
                        filterVal = BigDecimalUtil.transDecimal(excelVal);
                    }
                    if ((baseobject = BusinessDataServiceHelper.loadSingleFromCache((String)baseentity, (QFilter[])new QFilter(filterField, "=", filterVal).toArray())) == null) continue;
                    object.set(fieldCode, baseobject.getPkValue());
                    valCache.put(field.getFieldCode() + excelVal, baseobject.getPkValue());
                    continue;
                }
                if (property instanceof ComboProp) {
                    ComboProp comboProp = (ComboProp)property;
                    List comboitem = comboProp.getComboItems();
                    if (comboitem == null) continue;
                    for (ValueMapItem item : comboitem) {
                        if (item.getName() == null || !item.getName().getLocaleValue().equals(excelVal.toString())) continue;
                        object.set(fieldCode, (Object)item.getValue());
                        continue block0;
                    }
                    continue;
                }
                if (property instanceof BooleanProp) {
                    if (!StringUtils.isNotEmpty((CharSequence)field.getContainsContent())) continue;
                    String[] vals = field.getContainsContent().split("~~~");
                    if (excelVal.equals(vals[0])) {
                        object.set(fieldCode, (Object)Boolean.TRUE);
                        continue;
                    }
                    object.set(fieldCode, (Object)Boolean.FALSE);
                    continue;
                }
                if (property instanceof DateTimeProp) {
                    object.set(fieldCode, (Object)TypeUtils.castToDate((Object)excelVal.toString()));
                    continue;
                }
                if (property instanceof DecimalProp) {
                    object.set(fieldCode, (Object)BigDecimalUtil.transDecimal(excelVal));
                    continue;
                }
                if (property == null) continue;
                object.set(fieldCode, (Object)excelVal.toString());
            }
        }
    }

    @SdkDeprecated
    public static List<FileField> readTemplate(String templateDir, String templateName) {
        Map<String, FileField> customField;
        List<FileField> fields;
        block18: {
            fields = new ArrayList<FileField>();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try (InputStream inStream = classLoader.getResourceAsStream(templateDir + '/' + templateName);){
                if (inStream != null) {
                    String str = IOUtils.toString((InputStream)inStream, (String)"utf-8");
                    fields = JSONObject.parseArray((String)str, FileField.class);
                }
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block18;
                LOGGER.error((Throwable)e);
            }
        }
        if (!(customField = ExcelHelper.getCustomFileField(templateDir, templateName)).isEmpty()) {
            for (int i = 0; i < fields.size(); ++i) {
                FileField field2 = (FileField)fields.get(i);
                FileField custom = customField.get(field2.getFieldCode());
                if (custom == null) continue;
                fields.set(i, custom);
                customField.remove(field2.getFieldCode());
            }
            for (Map.Entry<String, FileField> entry : customField.entrySet()) {
                FileField field3 = entry.getValue();
                field3.setIsIsv(Boolean.TRUE);
                fields.add(field3);
            }
        }
        fields.forEach(field -> field.setColIndex(ExcelHelper.excelColStrToNum(field.getFieldOrder(), field.getFieldOrder().length())));
        return fields;
    }

    public static void setIsvField(DynamicObject[] collect, List<FileField> fields) {
    }

    public static void setUploadView(UploadEvent evt, IFormView view, IDataModel model) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String url = (String)urls[0];
            view.setVisible(Boolean.TRUE, new String[]{UPLOAD_FILEPANEL});
            view.setVisible(Boolean.FALSE, new String[]{UPLOAD_PANEL});
            model.setValue(UPLOAD_FILENAME, (Object)url.substring(url.lastIndexOf(47) + 1));
            model.setValue(UPLOAD_FILEPATH, (Object)url);
        }
    }

    @SdkDeprecated
    public static List<Map<String, Object>> doParse(Workbook workbook, List<FileField> fields, int starRow, boolean errorContinue, Map<String, String> errMap) {
        Sheet sheet = workbook.getSheetAt(0);
        if (null == sheet) {
            return new LinkedList<Map<String, Object>>();
        }
        return ExcelHelper.doParse(sheet, fields, starRow, errorContinue, errMap);
    }

    @SdkDeprecated
    public static List<Map<String, Object>> doParse(Sheet sheet, List<FileField> fields, int starRow, boolean errorContinue, Map<String, String> errMap) {
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        int rowNum = sheet.getLastRowNum();
        for (int i = starRow; i <= rowNum; ++i) {
            Map<String, Object> row;
            Row hss = sheet.getRow(i);
            if (!ExcelHelper.isRowNotEmpty(hss) || hss.getPhysicalNumberOfCells() <= 0 || null == (row = ExcelHelper.parseRows(hss, fields, errorContinue, errMap))) continue;
            list.add(row);
        }
        return list;
    }

    public static List<RowValue> doParseAndWriteError(Sheet sheet, List<FileField> fileFieldList, int starRow, Map<String, String> errMap) {
        ArrayList<RowValue> list = new ArrayList<RowValue>(32);
        HashMap<Integer, FileField> fieldConfigMap = new HashMap<Integer, FileField>(fileFieldList.size());
        fileFieldList.forEach(field -> fieldConfigMap.put(field.getColIndex() - 1, (FileField)field));
        int rowNum = sheet.getLastRowNum();
        for (int i = starRow; i <= rowNum; ++i) {
            Row hss = sheet.getRow(i);
            if (hss == null) continue;
            list.add(ExcelHelper.getRowValue(hss, fieldConfigMap, errMap));
        }
        return list;
    }

    private static RowValue getRowValue(Row headRow, Map<Integer, FileField> fieldConfigMap, Map<String, String> errMap) {
        RowValue rowValue = new RowValue();
        rowValue.setRowIndex(headRow.getRowNum());
        rowValue.setSheetName(headRow.getSheet().getSheetName());
        ArrayList<CellValue> cellList = new ArrayList<CellValue>(32);
        Iterator cellIt = headRow.cellIterator();
        boolean rowRight = true;
        StringBuilder rowError = new StringBuilder();
        while (cellIt.hasNext()) {
            List<String> arr;
            Cell cell = (Cell)cellIt.next();
            if (cell == null) continue;
            String cellVal = ExcelHelper.getStringValueFromCell(cell);
            CellValue cellValue = new CellValue(headRow.getRowNum(), cell.getColumnIndex(), cellVal);
            FileField config = fieldConfigMap.get(cell.getColumnIndex());
            if (config == null) continue;
            if (StringUtils.isBlank((CharSequence)cellVal) && StringUtils.isNotBlank((CharSequence)config.getDefaultValue())) {
                cellValue.setFieldValue(config.getDefaultValue());
            }
            cellValue.setFieldCode(config.getFieldCode());
            cellValue.setFieldName(config.getFieldName());
            StringBuilder sb = new StringBuilder();
            boolean right = true;
            if (config.getMaxLength() != null) {
                int length;
                cellVal = cellVal == null ? "" : cellVal;
                int n = length = config.getGbkLength() != false ? GBKUtils.getGBKLength(cellVal).intValue() : cellVal.length();
                if (length > config.getMaxLength()) {
                    right = false;
                    String msg = null;
                    msg = config.getGbkLength() != false ? String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e%2$s,\u4e00\u4e2a\u6c49\u5b57\u5360\u4e24\u4e2a\u5b57\u8282", (String)"ExcelHelper_17", (String)"imc-bdm-common", (Object[])new Object[0]), config.getFieldName(), config.getMaxLength()) : String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e%2$s", (String)"ExcelHelper_18", (String)"imc-bdm-common", (Object[])new Object[0]), config.getFieldName(), config.getMaxLength());
                    sb.append(msg);
                    ExcelHelper.setErrorMessage(headRow, config, msg, errMap);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)config.getRegex()) && StringUtils.isNotBlank((CharSequence)cellVal) && !Pattern.matches(config.getRegex(), cellVal.trim())) {
                if (!right) {
                    sb.append(';');
                }
                right = false;
                sb.append(StringUtils.isNotBlank((CharSequence)config.getRegexErrorMsg()) ? config.getRegexErrorMsg() : ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u9519\u8bef", (String)"ExcelHelper_19", (String)"imc-bdm-common", (Object[])new Object[0]));
                ExcelHelper.setErrorMessage(headRow, config, StringUtils.isNotBlank((CharSequence)config.getRegexErrorMsg()) ? config.getRegexErrorMsg() : ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u9519\u8bef", (String)"ExcelHelper_19", (String)"imc-bdm-common", (Object[])new Object[0]), errMap);
            }
            if (StringUtils.isNotBlank((CharSequence)config.getContainsContent()) && StringUtils.isNotBlank((CharSequence)cellVal) && !(arr = Arrays.asList(config.getContainsContent().split("~~~"))).contains(cellVal)) {
                if (!right) {
                    sb.append(';');
                }
                right = false;
                sb.append(String.format(ResManager.loadKDString((String)"%s\u5185\u5bb9\u586b\u5199\u9519\u8bef", (String)"ExcelHelper_20", (String)"imc-bdm-common", (Object[])new Object[0]), config.getFieldName()));
                ExcelHelper.setErrorMessage(headRow, config, String.format(ResManager.loadKDString((String)"%s\u5185\u5bb9\u586b\u5199\u9519\u8bef", (String)"ExcelHelper_20", (String)"imc-bdm-common", (Object[])new Object[0]), config.getFieldName()), errMap);
            }
            cellValue.setRight(right);
            if (!right) {
                cellValue.setErrorMsg(sb.toString());
                rowError.append((CharSequence)sb);
                rowRight = false;
            }
            cellList.add(cellValue);
        }
        if (!rowRight) {
            rowValue.setErrorMsg(rowError.toString());
            rowValue.setRight(rowRight);
            short lastCell = headRow.getLastCellNum();
            Cell hSSFCell = headRow.createCell((int)lastCell);
            hSSFCell.setCellValue(rowError.toString());
        }
        rowValue.setCellList(cellList);
        return rowValue;
    }

    public static boolean isRowNotEmpty(Row row) {
        if (row == null) {
            return false;
        }
        for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
            Cell cell = row.getCell(c);
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Object> parseRows(Row hss, List<FileField> fields, boolean errorContinue, Map<String, String> errMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(fields.size(), 1.0f);
        map.put("row", hss);
        boolean flag = true;
        String rowType = "";
        try {
            for (FileField field : fields) {
                try {
                    List<String> arr;
                    int index = field.getColIndex() - 1;
                    String value = ExcelHelper.getStringValueFromCell(hss.getCell(index));
                    if (index == 12) {
                        rowType = value;
                    }
                    if (StringUtils.isBlank((CharSequence)value) && StringUtils.isNotBlank((CharSequence)field.getDefaultValue())) {
                        value = field.getDefaultValue();
                    }
                    map.put(field.getFieldCode(), value);
                    if (field.getRequired().booleanValue() && StringUtils.isBlank((CharSequence)value) && (!"\u6574\u5355\u6298\u6263".equals(rowType) || !"\u91d1\u989d".equals(field.getFieldName()))) {
                        ExcelHelper.setErrorMessage(hss, field, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExcelHelper_21", (String)"imc-bdm-common", (Object[])new Object[0]), field.getFieldName()), errMap);
                        flag = false;
                        continue;
                    }
                    if (field.getMaxLength() != null) {
                        value = value == null ? "" : value;
                        int length = field.getGbkLength() != false ? GBKUtils.getGBKLength(value).intValue() : value.length();
                        if (length <= field.getMaxLength()) continue;
                        flag = false;
                        String msg = null;
                        msg = field.getGbkLength() != false ? String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e%2$s,\u4e00\u4e2a\u6c49\u5b57\u5360\u4e24\u4e2a\u5b57\u8282", (String)"ExcelHelper_17", (String)"imc-bdm-common", (Object[])new Object[0]), field.getFieldName(), field.getMaxLength()) : String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e%2$s", (String)"ExcelHelper_18", (String)"imc-bdm-common", (Object[])new Object[0]), field.getFieldName(), field.getMaxLength());
                        ExcelHelper.setErrorMessage(hss, field, msg, errMap);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)field.getRegex()) && StringUtils.isNotBlank((CharSequence)value) && !Pattern.matches(field.getRegex(), value.trim())) {
                        ExcelHelper.setErrorMessage(hss, field, StringUtils.isNotBlank((CharSequence)field.getRegexErrorMsg()) ? field.getRegexErrorMsg() : ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u9519\u8bef", (String)"ExcelHelper_19", (String)"imc-bdm-common", (Object[])new Object[0]), errMap);
                        flag = false;
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)field.getContainsContent()) || !StringUtils.isNotBlank((CharSequence)value) || (arr = Arrays.asList(field.getContainsContent().split("~~~"))).contains(value)) continue;
                    ExcelHelper.setErrorMessage(hss, field, String.format(ResManager.loadKDString((String)"%s\u5185\u5bb9\u586b\u5199\u9519\u8bef", (String)"ExcelHelper_20", (String)"imc-bdm-common", (Object[])new Object[0]), field.getFieldName()), errMap);
                    flag = false;
                }
                catch (IllegalArgumentException e) {
                    ExcelHelper.setErrorMessage(hss, field, String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", (String)"ExcelHelper_22", (String)"imc-bdm-common", (Object[])new Object[0]), field.getFieldName()), errMap);
                    flag = false;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        map.put("flag", flag ? Boolean.TRUE : Boolean.FALSE);
        return errorContinue ? map : (flag ? map : null);
    }

    @SdkDeprecated
    public static synchronized void setErrorMessage(Row hss, FileField field, String errorMsg, Map<String, String> errMap) {
        String rowIndex;
        String string = rowIndex = hss.getRowNum() < 9 ? "0" + (hss.getRowNum() + 1) : "" + (hss.getRowNum() + 1);
        if (field == null) {
            errMap.put(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u8868 %1$s\u7b2c%2$s\u884c\u6ca1\u6709\u5bf9\u5e94\u5217", (String)"ExcelHelper_14", (String)"imc-bdm-common", (Object[])new Object[0]), hss.getSheet().getSheetName(), rowIndex), errorMsg);
            return;
        }
        int index = field.getColIndex() - 1;
        ExcelHelper.setCellErrorComment(hss.getCell(index), errorMsg, hss, index);
        if (errMap != null) {
            errMap.put(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u8868 %1$s\u7b2c%2$s\u884c%3$s\u5217", (String)"ExcelHelper_15", (String)"imc-bdm-common", (Object[])new Object[0]), hss.getSheet().getSheetName(), rowIndex, ExcelHelper.excelColIndexToStr(field.getColIndex())), errorMsg);
        }
    }

    public static synchronized void setEpRepeatErrorMessage(Row hss, String errorMsg, Map<String, String> errMap, int startIndex, int endIndex, String rowName) {
        String rowIndex = hss.getRowNum() < 9 ? "0" + (hss.getRowNum() + 1) : "" + (hss.getRowNum() + 1);
        for (int i = startIndex; i < endIndex; ++i) {
            ExcelHelper.setCellErrorComment(hss.getCell(i), errorMsg, hss, i);
        }
        if (errMap != null) {
            errMap.put(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u8868 %1$s\u7b2c%2$s\u884c%3$s\u5217", (String)"ExcelHelper_15", (String)"imc-bdm-common", (Object[])new Object[0]), hss.getSheet().getSheetName(), rowIndex, rowName), errorMsg);
        }
    }

    private static int excelColStrToNum(String colStr, int length) {
        int result = 0;
        for (int i = 0; i < length; ++i) {
            char ch = colStr.charAt(length - i - 1);
            int num = ch - 65 + 1;
            num = (int)((double)num * Math.pow(26.0, i));
            result += num;
        }
        return result;
    }

    public static String excelColIndexToStr(int columnIndex) {
        if (columnIndex <= 0) {
            return null;
        }
        StringBuilder columnStr = new StringBuilder();
        --columnIndex;
        do {
            if (columnStr.length() > 0) {
                --columnIndex;
            }
            columnStr.insert(0, (char)(columnIndex % 26 + 65));
        } while ((columnIndex = (columnIndex - columnIndex % 26) / 26) > 0);
        return columnStr.toString();
    }

    public static String getStringValueFromCell(Cell cell) {
        if (null == cell) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case STRING: {
                return cell.getStringCellValue().trim();
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue()).trim();
            }
            case FORMULA: {
                try {
                    return String.valueOf(cell.getNumericCellValue());
                }
                catch (IllegalStateException e) {
                    return String.valueOf(cell.getRichStringCellValue());
                }
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return sdf.format(cell.getDateCellValue());
                }
                String cellValue = new BigDecimal(String.valueOf(cell.getNumericCellValue())).stripTrailingZeros().toPlainString();
                return cellValue.trim();
            }
        }
        return cell.getStringCellValue().trim();
    }

    public static void setCellErrorComment(Cell cell, String failedColumn, Row row, int index) {
        Sheet sheet = row.getSheet();
        CellStyle style = sheet.getWorkbook().createCellStyle();
        style.setFillForegroundColor(IndexedColors.RED1.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cell = cell == null ? row.createCell(index) : cell;
        cell.setCellStyle(style);
        Comment cellComment = cell.getCellComment();
        if (null != cellComment) {
            cell.removeCellComment();
        }
        cell.setCellComment(ExcelHelper.createCellComment(sheet, failedColumn));
    }

    private static Comment createCellComment(Sheet sheet, String content) {
        CreationHelper factory = sheet.getWorkbook().getCreationHelper();
        Drawing drawing = sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment(factory.createClientAnchor());
        RichTextString str0 = factory.createRichTextString(content);
        comment.setString(str0);
        return comment;
    }

    @SdkDeprecated
    public static String getErrorExcelFileName(String filepath, String suffix) {
        StringBuilder str = new StringBuilder();
        String fileName = filepath.substring(filepath.lastIndexOf(47) + 1, filepath.lastIndexOf(46));
        str.append(fileName).append(ResManager.loadKDString((String)"-\u9519\u8bef\u4fe1\u606f", (String)"ExcelHelper_23", (String)"imc-bdm-common", (Object[])new Object[0])).append(suffix);
        return str.toString();
    }

    @SdkDeprecated
    public static List<FileField> getFileFields(Row titleRow, List<FileField> fileFieldList) {
        ArrayList fileFields = Lists.newArrayListWithCapacity((int)fileFieldList.size());
        Map<String, FileField> EXCEL_FIELD_MAP = fileFieldList.stream().collect(Collectors.toMap(FileField::getFieldName, v -> v, (v1, v2) -> v2));
        for (int i = 0; i <= titleRow.getLastCellNum(); ++i) {
            FileField fileField;
            String commentName;
            RichTextString richTextString;
            Comment cellComment;
            Cell cell = titleRow.getCell(i);
            String titleName = ExcelHelper.getStringValueFromCell(cell).replace("*", "");
            if (cell != null && (cellComment = cell.getCellComment()) != null && (richTextString = cellComment.getString()) != null && (commentName = richTextString.getString()).contains(titleName)) {
                titleName = commentName;
            }
            if (null == (fileField = EXCEL_FIELD_MAP.get(titleName))) continue;
            fileField.setColIndex(i + 1);
            fileField.setFieldOrder(ExcelHelper.excelColIndexToStr(fileField.getColIndex()));
            fileFields.add(fileField);
        }
        ExcelHelper.checkMustTitle(titleRow, fileFieldList.stream().filter(FileField::getCheckTitle).map(FileField::getFieldName).collect(Collectors.toList()));
        return fileFields;
    }

    private static void checkMustTitle(Row titleRow, List<String> mustList) {
        List<String> titleCellList = ExcelHelper.replaceAsterisk(titleRow);
        titleCellList.retainAll(mustList);
        mustList.removeAll(titleCellList);
        if (!CollectionUtils.isEmpty(mustList)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c%s\u9879\u7f3a\u5931\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f", (String)"ExcelHelper_16", (String)"imc-bdm-common", (Object[])new Object[0]), ArrayUtils.toString(mustList, (String)",")));
        }
    }

    public static List<String> replaceAsterisk(Row titleRow) {
        ArrayList<String> titleCellList = new ArrayList<String>(titleRow.getPhysicalNumberOfCells());
        for (int i = 0; i < titleRow.getPhysicalNumberOfCells(); ++i) {
            titleCellList.add(titleRow.getCell(i).getStringCellValue().replace("*", ""));
        }
        return titleCellList;
    }

    @SdkDeprecated
    public static void showErrorResult(Workbook workbook, int dataNum, int successSize, Map<String, String> errMap, String errFileName, AbstractFormPlugin formPlugin, String callbackKey, String formId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("totalline", dataNum);
        customParams.put("successline", successSize);
        customParams.put("failline", dataNum - successSize);
        customParams.put("url", ExcelHelper.getErrFileUrl(workbook, errFileName));
        customParams.put("errMap", errMap);
        ViewUtil.openDialog(formPlugin, customParams, formId, callbackKey);
    }

    public static LinkedHashMap<String, String> mapOrderByKey(Map<String, String> map) {
        Set<Map.Entry<String, String>> set = map.entrySet();
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(set);
        list.sort((o1, o2) -> {
            String key01 = (String)o1.getKey();
            String key02 = (String)o2.getKey();
            return key01.compareTo(key02);
        });
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(map.size());
        for (Map.Entry entry : list) {
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getErrFileUrl(Workbook workbook, String errFileName) {
        InputStream in = null;
        try {
            String string;
            Throwable throwable;
            ByteArrayOutputStream out;
            block24: {
                block25: {
                    out = new ByteArrayOutputStream();
                    throwable = null;
                    workbook.write((OutputStream)out);
                    byte[] bookByteAry = out.toByteArray();
                    in = new ByteArrayInputStream(bookByteAry);
                    string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(errFileName, in, 5000);
                    if (out == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block24;
                }
                out.close();
            }
            return string;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "";
    }

    public static boolean isNormalTaxRate(String uploadTaxRate) {
        if (normalMap.containsKey(uploadTaxRate)) {
            return true;
        }
        if (percentMap.containsKey(uploadTaxRate)) {
            return true;
        }
        return hundredMap.containsKey(uploadTaxRate);
    }

    public static String getDBTaxRate(String uploadTaxRate) {
        String taxRate = normalMap.get(uploadTaxRate);
        if (taxRate != null) {
            return taxRate;
        }
        taxRate = hundredMap.get(uploadTaxRate);
        if (taxRate != null) {
            return taxRate;
        }
        taxRate = percentMap.get(uploadTaxRate);
        if (taxRate != null) {
            return taxRate;
        }
        return null;
    }

    private static Map<String, String> getResultMap(String[] standardArray, String[] otherArray) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (int i = 0; i < otherArray.length; ++i) {
            resultMap.put(otherArray[i], standardArray[i]);
        }
        return resultMap;
    }

    public static String parseExcelDiscountRate(String discountRate) {
        if (StringUtils.isBlank((CharSequence)discountRate)) {
            return null;
        }
        if ("0".equals(discountRate)) {
            return null;
        }
        boolean isPointNum = discountRate.matches("[+]?[0]+(\\.[0-9]{1,2})?");
        if (isPointNum) {
            return discountRate;
        }
        if ("100".equals(discountRate)) {
            return "1";
        }
        if (ExcelHelper.checkNumber(discountRate)) {
            return new BigDecimal(discountRate).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP).toPlainString();
        }
        return null;
    }

    private static boolean checkNumber(String str) {
        if (str.length() > 2) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (i == 0 && '0' == c) {
                return false;
            }
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isNormalExcelDiscountAmount(String discountAmount) {
        return discountAmount.matches("([1-9]\\d*(\\.\\d*[1-9])?)");
    }

    @SdkDeprecated
    public static void replaceFieldName(List<FileField> fileFields, String entityName) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection collect = entityType.getProperties();
        HashMap<String, String> keyNameMap = new HashMap<String, String>(collect.size());
        ExcelHelper.setFieldKeyNameMap(keyNameMap, collect);
        for (FileField fileField : fileFields) {
            if (!fileField.getNeedReplaceName().booleanValue()) continue;
            fileField.setFieldName((String)keyNameMap.get(fileField.getFieldCode()));
        }
    }

    private static void setFieldKeyNameMap(Map<String, String> keyNameMap, DataEntityPropertyCollection collect) {
        for (IDataEntityProperty property : collect) {
            if (property.getDisplayName() == null) continue;
            if (property instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)property;
                ExcelHelper.setFieldKeyNameMap(keyNameMap, entryProp.getDynamicCollectionItemPropertyType().getProperties());
                continue;
            }
            keyNameMap.put(property.getName(), property.getDisplayName().getLocaleValue());
        }
    }

    static {
        String taxRateStrNormal = "0~~~0.01~~~0.015~~~0.02~~~0.03~~~0.04~~~0.05~~~0.06~~~0.09~~~0.1~~~0.10~~~0.11~~~0.13~~~0.16~~~0.17";
        String[] normalTaxRateArray = taxRateStrNormal.split("~~~");
        String taxRatePercent = "0%~~~1%~~~1.5%~~~2%~~~3%~~~4%~~~5%~~~6%~~~9%~~~10%~~~10%~~~11%~~~13%~~~16%~~~17%";
        String[] percentTaxRateArray = taxRatePercent.split("~~~");
        String taxRate100 = "0~~~1~~~1.5~~~2~~~3~~~4~~~5~~~6~~~9~~~10~~~10~~~11~~~13~~~16~~~17";
        String[] taxRate100Array = taxRate100.split("~~~");
        String taxRateStandard = "0~~~0.01~~~0.015~~~0.02~~~0.03~~~0.04~~~0.05~~~0.06~~~0.09~~~0.10~~~0.10~~~0.11~~~0.13~~~0.16~~~0.17";
        String[] standardArray = taxRateStandard.split("~~~");
        normalMap = ExcelHelper.getResultMap(standardArray, normalTaxRateArray);
        percentMap = ExcelHelper.getResultMap(standardArray, percentTaxRateArray);
        hundredMap = ExcelHelper.getResultMap(standardArray, taxRate100Array);
        LOGGER = LogFactory.getLog(ExcelHelper.class);
    }
}

