/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.MetadataUtil;

public class FieldSelectHelper {
    private static final ImmutableSet<String> FIELD_STANDARD_SET = new ImmutableSet.Builder().add((Object[])new String[]{"invoicecode", "invoiceno", "totalamount", "issuetime", "billno", "salername", "buyername"}).build();

    private static Map<String, String> initInvoiceFieldMethod() {
        LinkedHashMap<String, String> invoiceFieldMap = new LinkedHashMap<String, String>(16);
        HashSet<String> fieldSet = new HashSet<String>((Collection<String>)FIELD_STANDARD_SET);
        try {
            String fieldValues = ImcConfigUtil.getValue("sim_vatinvoice", "sim_vatinvoice_fields");
            if (StringUtils.isNotBlank((CharSequence)fieldValues)) {
                fieldSet.addAll(Splitter.on((String)";").omitEmptyStrings().splitToList((CharSequence)fieldValues));
            }
        }
        catch (Exception fieldValues) {
            // empty catch block
        }
        List<String> fieldList = MetadataUtil.getIsvEntityItems("sim_vatinvoice");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice");
        if (mainEntityType != null) {
            DataEntityPropertyCollection propertyCollection = mainEntityType.getProperties();
            for (IDataEntityProperty property : propertyCollection) {
                String fieldKey = property.getName();
                String fieldName = "";
                if (property.getDisplayName() != null) {
                    fieldName = property.getDisplayName().getLocaleValue();
                }
                if (fieldSet.contains(fieldKey)) {
                    invoiceFieldMap.put(fieldKey, fieldName);
                }
                if (!fieldList.contains(fieldKey)) continue;
                invoiceFieldMap.put(fieldKey, fieldName);
            }
        }
        return invoiceFieldMap;
    }

    public static String getShowFileNameBySelected(String selected, String split) {
        return FieldSelectHelper.getShowFileNameBySelected(selected, split, FieldSelectHelper.initInvoiceFieldMethod());
    }

    public static String getShowFileNameBySelected(String selected, String split, Map<String, String> fieldMap) {
        if ("\u6362\u884c".equals(split)) {
            split = System.lineSeparator();
        }
        Object[] selects = selected.split(",");
        for (int i = 0; i < selects.length; ++i) {
            selects[i] = fieldMap.get(selects[i]);
        }
        return StringUtils.join((Object[])selects, (String)split);
    }

    public static Map<String, String> getInvoiceFieldMap() {
        return FieldSelectHelper.initInvoiceFieldMethod();
    }
}

