/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.util.AES128;
import kd.imc.bdm.common.util.AesUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.MD5;

public class ImcLicenseServiceHelper {
    private static final Log LOG = LogFactory.getLog(ImcLicenseServiceHelper.class);
    public static final String SYNC_PERMISSION_2_AWS = "0";
    private static final String SYNC_PERMISSION_2_AWS_URL = "/m3/bill/firmament/auth/sync/license";
    public static final String SYNC_CANCEL_PERMISSION_2_AWS = "1";
    private static final String SYNC_CANCEL_PERMISSION_2_AWS_URL = "/m3/bill/firmament/auth/cancel/license";
    public static final String SYNC_QUERY_PERMISSION = "3";
    public static final String SYNC_QUERY_PERMISSION_URL = "/m3/bill/firmament/auth/query/license";

    public static int getLicenseTotalNumber(String permissionType) {
        String authType = ImcLicenseServiceHelper.getAuthType();
        if (PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(permissionType) || PermissionEnum.INVOICE_WARNING_SERVICE.getPermissionNo().equals(permissionType)) {
            return ImcLicenseServiceHelper.getInputLicenseNumber(authType, permissionType);
        }
        switch (authType) {
            case "private": {
                return ImcLicenseServiceHelper.getPrivateNumber();
            }
            case "basic": {
                int count = ImcLicenseServiceHelper.getLicenseNumberFromAws(permissionType);
                if (count == 0) {
                    count = ImcLicenseServiceHelper.getOutPutLicenseNumer();
                }
                return count;
            }
        }
        int count = ImcLicenseServiceHelper.getOutPutLicenseNumer();
        if (count == 0) {
            count = ImcLicenseServiceHelper.getLicenseNumberFromAws(permissionType);
        }
        return count;
    }

    private static int getInputLicenseNumber(String authType, String permissionType) {
        String licenseGroupId;
        String string = licenseGroupId = PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(permissionType) ? CacheKeyEnum.RIM_INVOICE_PERMISSION_AUTH_GROUP_ID.getDefaultValue() : CacheKeyEnum.IREW_INVOICE_PERMISSION_AUTH_GROUP_ID.getDefaultValue();
        if ("cosmic".equals(authType)) {
            int count = ImcLicenseServiceHelper.getCosmicLicenseNumber(licenseGroupId);
            if (count == 0) {
                count = ImcLicenseServiceHelper.getLicenseNumberFromAws(permissionType);
            }
            return count;
        }
        int count = ImcLicenseServiceHelper.getLicenseNumberFromAws(permissionType);
        if (count == 0) {
            count = ImcLicenseServiceHelper.getCosmicLicenseNumber(licenseGroupId);
        }
        return count;
    }

    private static int getOutPutLicenseNumer() {
        BigDecimal productVersion = new BigDecimal("5.0");
        try {
            productVersion = new BigDecimal(LicenseServiceHelper.getProductVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (productVersion.compareTo(new BigDecimal("5.0")) >= 0) {
            return ImcLicenseServiceHelper.getCosmicLicenseNumber(ImcConfigUtil.getValue(CacheKeyEnum.BDM_INVOICE_PERMISSION_AUTH_IMC_SBI_GROUP_ID));
        }
        return ImcLicenseServiceHelper.getCosmicLicenseNumber(ImcConfigUtil.getValue(CacheKeyEnum.BDM_INVOICE_PERMISSION_AUTH_IMC_DJ_GROUP_ID)) + ImcLicenseServiceHelper.getCosmicLicenseNumber(ImcConfigUtil.getValue(CacheKeyEnum.BDM_INVOICE_PERMISSION_AUTH_IMC_TG_GROUP_ID));
    }

    private static int getCosmicLicenseNumber(String groupId) {
        try {
            return LicenseServiceHelper.getTotalNumber((Object)groupId);
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u82cd\u7a79\u8bb8\u53ef\u6570\u91cf\u62a5\u9519", (Throwable)e);
            return 0;
        }
    }

    public static int getInvoiceMsgAuth() {
        return 1;
    }

    private static String getAuthType() {
        String authType = "cosmic";
        try {
            String authTypeStr = ImcConfigUtil.getValue(CacheKeyEnum.BDM_INVOICE_PERMISSION_AUTH_TYPE);
            if (StringUtils.isNotBlank((CharSequence)authTypeStr)) {
                authType = AesUtil.decrypt(authTypeStr, RequestContext.get().getTenantId() + "_license");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return authType;
    }

    private static int getPrivateNumber() {
        int privateNumer = 0;
        try {
            String privateNumberStr = ImcConfigUtil.getValue(CacheKeyEnum.BDM_INVOICE_PERMISSION_PRIVATE_NUMBER);
            if (StringUtils.isNotBlank((CharSequence)privateNumberStr)) {
                privateNumer = Integer.parseInt(AesUtil.decrypt(privateNumberStr, RequestContext.get().getTenantId() + "_license"));
            }
        }
        catch (Exception e) {
            LOG.error(String.format("\u79c1\u6709\u5316\u6570\u91cf\u89e3\u5bc6\u51fa\u9519,\u79df\u6237\u662f[%s]", RequestContext.get().getTenantId()), (Throwable)e);
        }
        return privateNumer;
    }

    private static int getLicenseNumberFromAws(String permissionType) {
        String CACHE_KEY = "awsLicenseNumber" + permissionType;
        String cache = CacheHelper.get(CACHE_KEY);
        if (!StringUtils.isEmpty((CharSequence)cache)) {
            LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cfkey{},value{}", (Object)CACHE_KEY, (Object)cache);
            return Integer.parseInt(cache);
        }
        Map<String, String> map = ImcConfigUtil.getValue("dim_imc_config_fpy");
        String url = ImcConfigUtil.getValue(map, "url", "dim_imc_config_fpy_url");
        String proxy = ImcConfigUtil.getValue(map, "proxy", "dim_imc_config_fpy_proxy");
        String clientId = ImcConfigUtil.getValue(map, "clientid", "dim_imc_config_fpy_clientid");
        String clientsecret = ImcConfigUtil.getValue(map, "clientsecret", "dim_imc_config_fpy_clientsecret");
        String encryptkey = ImcConfigUtil.getValue(map, "encryptkey", "dim_imc_config_fpy_encryptkey");
        if (StringUtils.isEmpty((CharSequence)url) || StringUtils.isEmpty((CharSequence)clientId) || StringUtils.isEmpty((CharSequence)clientsecret)) {
            LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u672a\u914d\u7f6e\u8fde\u63a5\u4fe1\u606f" + map);
            return 0;
        }
        try {
            String token = ImcLicenseServiceHelper.getAccessToken(url, proxy, clientId, clientsecret);
            if (!StringUtils.isEmpty((CharSequence)token)) {
                RequestContext request = RequestContext.get();
                JSONObject json = new JSONObject();
                json.put("tenantId", (Object)request.getTenantId());
                json.put("permissionType", (Object)permissionType);
                if (encryptkey == null || "".equals(encryptkey)) {
                    LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u5931\u8d25\u52a0\u5bc6\u9519\u8bef");
                    return 0;
                }
                String content = AES128.ecbEncrypt(json.toJSONString(), encryptkey);
                if (StringUtils.isEmpty((CharSequence)content)) {
                    LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u5931\u8d25\u52a0\u5bc6\u9519\u8bef");
                    return 0;
                }
                String countUrl = url + "/m3/bill/firmament/auth/count?access_token=" + token;
                LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf{},{},{}", new Object[]{countUrl, json.toJSONString(), content});
                String result = HttpUtil.doPostJson(countUrl, proxy, null, content);
                LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf{}", (Object)result);
                JSONObject countResult = JSONObject.parseObject((String)result);
                if (countResult != null && "0000".equals(countResult.getString("errcode"))) {
                    String countStr = countResult.getString("data");
                    CacheHelper.put(CACHE_KEY, countStr, 600);
                    return Integer.parseInt(countStr);
                }
            } else {
                LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u5931\u8d25\u52a0\u5bc6\u9519\u8beftoken\u4e3a\u7a7a");
            }
        }
        catch (Exception e1) {
            LOG.error("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u5931\u8d25", (Throwable)e1);
        }
        return 0;
    }

    public static String getAccessToken(String baseurl, String proxy, String clientId, String clientSecret) {
        String CACHE_KEY = "aws_token_cache";
        String token = CacheHelper.get(CACHE_KEY);
        if (!StringUtils.isEmpty((CharSequence)token)) {
            return token;
        }
        JSONObject param = new JSONObject();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5Hex(clientId + clientSecret + timestamp);
        String url = baseurl + "/base/oauth/token";
        param.put("client_id", (Object)clientId);
        param.put("sign", (Object)sign);
        param.put("timestamp", (Object)timestamp);
        try {
            String result = HttpUtil.doPostJson(url, proxy, null, param.toJSONString());
            JSONObject json = JSONObject.parseObject((String)result);
            if (json != null && "0000".equals(json.getString("errcode"))) {
                token = json.getString("access_token");
                CacheHelper.put(CACHE_KEY, token, 300);
            }
        }
        catch (Exception e1) {
            LOG.error("\u83b7\u53d6aws token\u5931\u8d25", (Throwable)e1);
        }
        return token;
    }

    public static Map<String, Date> getDateRange(Long groupId) {
        try {
            Map dateRange = LicenseServiceHelper.getGroupTimeRange((Long)groupId);
            return dateRange;
        }
        catch (RuntimeException e) {
            LOG.info("\u83b7\u53d6\u6388\u6743\u7684\u8d77\u59cb\u65f6\u95f4\u5931\u8d25{},{}", (Object)groupId, (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isShowPop(boolean isOutput) {
        List infos = LicenseServiceHelper.getProductInfos();
        if (infos != null && infos.size() > 0) {
            for (Map info : infos) {
                if (!String.valueOf(info.get("softwarename")).contains(ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"ImcLicenseServiceHelper_3", (String)"imc-bdm-common", (Object[])new Object[0])) || !((String)info.get("type")).equals(SYNC_CANCEL_PERMISSION_2_AWS)) continue;
                return false;
            }
        }
        if (isOutput) {
            return StringUtils.isBlank((CharSequence)ImcLicenseServiceHelper.getProductNum(true));
        }
        return StringUtils.isBlank((CharSequence)ImcLicenseServiceHelper.getProductNum(false));
    }

    public static String getProductNum(boolean isOutput) {
        String dbProductNumber = ImcLicenseServiceHelper.getProductFromDB(isOutput);
        if (StringUtils.isNotBlank((CharSequence)dbProductNumber)) {
            return dbProductNumber;
        }
        List infos = LicenseServiceHelper.getProductInfos();
        if (infos != null && infos.size() > 0) {
            for (Map info : infos) {
                if (!String.valueOf(info.get("softwarename")).contains(ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"ImcLicenseServiceHelper_3", (String)"imc-bdm-common", (Object[])new Object[0])) || !((String)info.get("type")).equals(SYNC_CANCEL_PERMISSION_2_AWS)) continue;
                return (String)info.get("productNo");
            }
        }
        return "";
    }

    private static String getProductFromDB(boolean isOutput) {
        if (isOutput) {
            QFilter filter = new QFilter("config_type", "=", (Object)CacheKeyEnum.BDM_ISSUE_PRODUCT_NUM.getConfigType()).and("config_key", "=", (Object)CacheKeyEnum.BDM_ISSUE_PRODUCT_NUM.getConfigKey());
            DynamicObject[] configs = BusinessDataServiceHelper.load((String)"invsm_param_configuration", (String)"config_value", (QFilter[])filter.toArray());
            if (configs.length > 0) {
                return configs[0].getString("config_value");
            }
            return "";
        }
        QFilter filter = new QFilter("config_type", "=", (Object)CacheKeyEnum.BDM_RECEIVE_PRODUCT_NUM.getConfigType()).and("config_key", "=", (Object)CacheKeyEnum.BDM_RECEIVE_PRODUCT_NUM.getConfigKey());
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"invsm_param_configuration", (String)"config_value", (QFilter[])filter.toArray());
        if (configs.length > 0) {
            return configs[0].getString("config_value");
        }
        return "";
    }

    public static String syncPermssion2Aws(DynamicObject[] objs, String authBusinessType) {
        try {
            LOG.info("syncPermssion2AwsStart");
            if (objs.length == 0) {
                return "";
            }
            List permissionList = Arrays.stream(objs).collect(Collectors.toList());
            List partitions = Lists.partition(permissionList, (int)50);
            HashSet<Object> epInfoSet = new HashSet<Object>();
            for (DynamicObject dynamicObject : objs) {
                DynamicObject epInfo = (DynamicObject)dynamicObject.get("epinfo");
                if (null == epInfo) continue;
                epInfoSet.add(epInfo.getPkValue());
            }
            String fields = String.join((CharSequence)",", "country_area", "number", "name");
            DynamicObject[] epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)fields, (QFilter[])new QFilter("id", "in", epInfoSet).toArray());
            HashMap<Object, DynamicObject> epInfoMap = new HashMap<Object, DynamicObject>(epInfos.length);
            for (DynamicObject epInfo : epInfos) {
                epInfoMap.put(epInfo.getPkValue(), epInfo);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (List groupPermissionList : partitions) {
                DynamicObject[] groupPermissions = groupPermissionList.toArray(new DynamicObject[0]);
                JSONObject json = ImcLicenseServiceHelper.createParamJson(epInfoMap, groupPermissions, authBusinessType);
                JSONObject resultJson = ImcLicenseServiceHelper.postAws(json, authBusinessType);
                ImcLicenseServiceHelper.handleResult(epInfoMap, groupPermissions, resultJson, authBusinessType, stringBuilder);
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            LOG.error("\u540c\u6b65\u6743\u9650\u5230aws\u5931\u8d25", (Throwable)e);
            return String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff1a%s", (String)"ImcLicenseServiceHelper_6", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage());
        }
    }

    private static void handleResult(Map<Object, DynamicObject> epInfoMap, DynamicObject[] groupPermissions, JSONObject resultJson, String authBusinessType, StringBuilder errorTipBuilder) {
        if (resultJson != null && "0000".equals(resultJson.getString("errcode"))) {
            JSONArray companyInfos;
            JSONObject data = resultJson.getJSONObject("data");
            HashMap<String, JSONObject> companyInfoMap = new HashMap<String, JSONObject>();
            if (null != data && null != (companyInfos = data.getJSONArray("companyInfos"))) {
                for (Object info : companyInfos) {
                    JSONObject infoJson = (JSONObject)info;
                    companyInfoMap.put(infoJson.getString("taxNo"), infoJson);
                }
            }
            for (DynamicObject permission : groupPermissions) {
                DynamicObject ep;
                String taxNo;
                JSONObject companyInfo;
                DynamicObject epInfo = (DynamicObject)permission.get("epinfo");
                if (null == epInfo || null == (companyInfo = (JSONObject)companyInfoMap.get(taxNo = (ep = epInfoMap.get(epInfo.getPkValue())).getString("number")))) continue;
                Object status = companyInfo.get((Object)"status");
                if (SYNC_CANCEL_PERMISSION_2_AWS.equals(status)) {
                    permission.set("syncstatus", (Object)SYNC_CANCEL_PERMISSION_2_AWS);
                }
                if (SYNC_PERMISSION_2_AWS.equals(status)) {
                    permission.set("syncstatus", (Object)SYNC_PERMISSION_2_AWS);
                    if (errorTipBuilder.length() == 0) {
                        errorTipBuilder.append(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"ImcLicenseServiceHelper_5", (String)"imc-bdm-common", (Object[])new Object[0])).append(System.lineSeparator());
                    }
                    errorTipBuilder.append(taxNo).append(":").append(companyInfo.getString("description")).append(System.lineSeparator());
                }
                if (null != companyInfo.getDate("benefitStartDate")) {
                    permission.set("validstarttime", (Object)companyInfo.getDate("benefitStartDate"));
                }
                if (null == companyInfo.getDate("benefitEndDate")) continue;
                permission.set("validendtime", (Object)companyInfo.getDate("benefitEndDate"));
            }
            ImcSaveServiceHelper.save((DynamicObject[])groupPermissions);
            return;
        }
        if (resultJson != null) {
            if (errorTipBuilder.length() == 0) {
                errorTipBuilder.append(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"ImcLicenseServiceHelper_5", (String)"imc-bdm-common", (Object[])new Object[0])).append(System.lineSeparator());
            }
            if (StringUtils.isNotBlank((CharSequence)resultJson.getString("description"))) {
                errorTipBuilder.append(resultJson.getString("description")).append(System.lineSeparator());
            }
            return;
        }
        if (errorTipBuilder.length() == 0) {
            errorTipBuilder.append(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"ImcLicenseServiceHelper_5", (String)"imc-bdm-common", (Object[])new Object[0])).append(System.lineSeparator());
        }
    }

    private static JSONObject postAws(JSONObject param, String authBusinessType) throws Exception {
        Map<String, String> map = ImcConfigUtil.getValue("dim_imc_config_fpy");
        String url = ImcConfigUtil.getValue(map, "url", "dim_imc_config_fpy_url");
        String proxy = ImcConfigUtil.getValue(map, "proxy", "dim_imc_config_fpy_proxy");
        String clientId = ImcConfigUtil.getValue(map, "clientid", "dim_imc_config_fpy_clientid");
        String clientsecret = ImcConfigUtil.getValue(map, "clientsecret", "dim_imc_config_fpy_clientsecret");
        String encryptkey = ImcConfigUtil.getValue(map, "encryptkey", "dim_imc_config_fpy_encryptkey");
        String token = ImcLicenseServiceHelper.getAccessToken(url, proxy, clientId, clientsecret);
        if (!StringUtils.isEmpty((CharSequence)token)) {
            if (StringUtils.isBlank((CharSequence)encryptkey)) {
                LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u5931\u8d25\u52a0\u5bc6\u9519\u8bef");
                return null;
            }
            String content = AES128.ecbEncrypt(param.toJSONString(), encryptkey);
            if (StringUtils.isEmpty((CharSequence)content)) {
                LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u5931\u8d25\u52a0\u5bc6\u9519\u8bef");
                return null;
            }
            String countUrl = url + ImcLicenseServiceHelper.getBusinessUrl(authBusinessType) + "?access_token=" + token;
            LOG.info("\u540c\u6b65\u8bb8\u53ef\u6388\u6743\u4fe1\u606f{},{},{}", new Object[]{countUrl, param.toJSONString(), content});
            String result = UnitTestHelper.isUnitTest() ? ImcLicenseServiceHelper.matchResult(ImcLicenseServiceHelper.getBusinessUrl(authBusinessType)) : HttpUtil.doPostJson(countUrl, proxy, null, content);
            LOG.info("\u540c\u6b65\u8bb8\u53ef\u6388\u6743\u4fe1\u606f\u7ed3\u679c{}", (Object)result);
            return JSONObject.parseObject((String)result);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6aws\u8bb8\u53eftoken\u5931\u8d25", (String)"ImcLicenseServiceHelper_4", (String)"imc-bdm-common", (Object[])new Object[0]));
    }

    private static String matchResult(String url) {
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"bdm_unittest_config", (String)"value", (QFilter[])new QFilter("configkey", "=", (Object)url).toArray());
        if (configs.length > 0) {
            return configs[0].getString("value_tag");
        }
        return "{}";
    }

    private static String getBusinessUrl(String authBusinessType) {
        if (SYNC_PERMISSION_2_AWS.equals(authBusinessType)) {
            return SYNC_PERMISSION_2_AWS_URL;
        }
        if (SYNC_CANCEL_PERMISSION_2_AWS.equals(authBusinessType)) {
            return SYNC_CANCEL_PERMISSION_2_AWS_URL;
        }
        if (SYNC_QUERY_PERMISSION.equals(authBusinessType)) {
            return SYNC_QUERY_PERMISSION_URL;
        }
        return null;
    }

    private static JSONObject createParamJson(Map<Object, DynamicObject> epInfoMap, DynamicObject[] groupPermissions, String authBusinessType) {
        JSONObject json = new JSONObject();
        JSONArray array = new JSONArray();
        json.put("companyInfos", (Object)array);
        boolean isIssue = PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(groupPermissions[0].getString("servergroup"));
        String rightType = isIssue ? "01" : "02";
        json.put("rightsType", (Object)rightType);
        json.put("productSerialNo", (Object)ImcLicenseServiceHelper.getProductNum(isIssue));
        for (DynamicObject permission : groupPermissions) {
            DynamicObject epInfo = (DynamicObject)permission.get("epinfo");
            if (null == epInfo) continue;
            DynamicObject ep = epInfoMap.get(epInfo.getPkValue());
            if (null == ep) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f01\u4e1a\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ImcLicenseServiceHelper_1", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            JSONObject param = new JSONObject();
            array.add((Object)param);
            param.put("taxNo", (Object)ep.getString("number"));
            if (!SYNC_PERMISSION_2_AWS.equals(authBusinessType)) continue;
            String countryCode = "CN";
            if (null != ep.getDynamicObject("country_area")) {
                Object countryPk = ep.getDynamicObject("country_area").getPkValue();
                DynamicObject countryObj = BusinessDataServiceHelper.loadSingle((Object)countryPk, (String)"bd_country");
                countryCode = countryObj.getString("twocountrycode");
            }
            param.put("companyName", (Object)ep.getString("name"));
            param.put("countryAndArea", (Object)countryCode);
            param.put("taxCity", (Object)"");
        }
        return json;
    }
}

