/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.leqicombine.AllEleLeqiCombineIssueRequestDTO;
import kd.imc.bdm.common.dto.allele.leqicombine.AllEleLeqiRedConfirmUploadRequestDTO;
import kd.imc.bdm.common.dto.allele.leqicombine.CombineItems;
import kd.imc.bdm.common.dto.allele.leqicombine.CombineOriginalInvoiceInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.InvoiceUtils;

public class LeqiCombineHelper {
    public static String AGREE = "Y";
    public static String NOT_AGREE = "N";
    public static String CANCEL = "C";

    public static AllEleRequestDTO covertRequest2LeqiCobineRequest(AllEleRequestDTO request) {
        String combinePath = request.getCombinePatch();
        String jsonStr = JSONObject.toJSONString((Object)request);
        JSONObject param = JSONObject.parseObject((String)jsonStr);
        String redConfirmBillNo = param.getString("redConfirmBillNo");
        String originalInvoiceNo = param.getString("originalInvoiceNo");
        String originalInvoiceCode = param.getString("originalInvoiceCode");
        String orderNo = param.getString("serialNo");
        if (AllEleInterfaceTypeEnum.OPEN_INVOICE.getCombinePath().equals(combinePath)) {
            return LeqiCombineHelper.reBuildOpenInvoiceDTO(jsonStr, param, redConfirmBillNo, originalInvoiceNo);
        }
        if (AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_APPLY.getCombinePath().equals(combinePath)) {
            return LeqiCombineHelper.reBuildRedConfirmUploadDTO(jsonStr, orderNo, originalInvoiceNo, originalInvoiceCode);
        }
        return request;
    }

    private static AllEleLeqiCombineIssueRequestDTO reBuildOpenInvoiceDTO(String jsonStr, JSONObject param, String redConfirmBillNo, String originalInvoiceNo) {
        QFilter filter;
        DynamicObject[] arrays;
        AllEleLeqiCombineIssueRequestDTO dto = (AllEleLeqiCombineIssueRequestDTO)JSONObject.parseObject((String)jsonStr, AllEleLeqiCombineIssueRequestDTO.class);
        CombineOriginalInvoiceInfo originInvoiceInfo = new CombineOriginalInvoiceInfo();
        dto.setOriginInvoiceInfo(originInvoiceInfo);
        originInvoiceInfo.setOriginalInvoiceNo(param.getString("originalInvoiceNo"));
        originInvoiceInfo.setOriginalInvoiceCode(param.getString("originalInvoiceCode"));
        originInvoiceInfo.setRedConfirmBillNo(param.getString("redConfirmBillNo"));
        originInvoiceInfo.setOriginalInvoiceDate(param.getString("originalInvoiceDate"));
        originInvoiceInfo.setOriginalEtaxInvoiceNo(param.getString("originalEtaxInvoiceNo"));
        originInvoiceInfo.setOriginalGovInvoiceType(InvoiceType.matchRimLqCodeFromBaseCode(param.getString("originalInvoiceType")));
        if ("0".equals(dto.getDifferenceTaxType())) {
            dto.setDifferenceTaxType(null);
        }
        originInvoiceInfo.setRedReason(param.getString("redReason"));
        originInvoiceInfo.setGovRedConfirmBillUuid(param.getString("govRedConfirmBillUuid"));
        if ("1".equals(param.getString("type")) && StringUtils.isNotBlank((CharSequence)param.getString("redConfirmBillNo")) && (arrays = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"uploaddate", (QFilter[])(filter = new QFilter("number", "=", (Object)redConfirmBillNo).and("originalinvoiceno", "=", (Object)originalInvoiceNo)).toArray())).length > 0) {
            originInvoiceInfo.setRedConfirmEnterDate(DateUtils.format(arrays[0].getDate("uploaddate"), "yyyy-MM-dd HH:mm:ss"));
        }
        LeqiCombineHelper.rebuildItemLineNumber(dto.getItems());
        return dto;
    }

    private static AllEleLeqiRedConfirmUploadRequestDTO reBuildRedConfirmUploadDTO(String jsonStr, String orderNo, String originalInvoiceNo, String originalInvoiceCode) {
        AllEleLeqiRedConfirmUploadRequestDTO dto = (AllEleLeqiRedConfirmUploadRequestDTO)JSONObject.parseObject((String)jsonStr, AllEleLeqiRedConfirmUploadRequestDTO.class);
        LeqiCombineHelper.rebuildItemLineNumber(dto.getItems());
        QFilter filter = new QFilter("orderno", "=", (Object)orderNo).and("originalinvoiceno", "=", (Object)originalInvoiceNo);
        DynamicObject[] arrays = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"applicant", (QFilter[])filter.toArray());
        if (arrays.length > 0) {
            String applicant = "2".equals(arrays[0].getString("applicant")) ? "1" : "2";
            dto.setApplicant(applicant);
        }
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceNo)) {
            QFilter invoiceFilter = InvoiceUtils.getInvoiceFilter(originalInvoiceCode, originalInvoiceNo);
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoiceamount", "totaltax", "totalamount"), (QFilter[])invoiceFilter.toArray());
            if (invoices.length > 0) {
                dto.setOriginalTotalAmount(invoices[0].getBigDecimal("invoiceamount").setScale(2, RoundingMode.HALF_UP));
                dto.setOriginalTotalTaxAmount(invoices[0].getBigDecimal("totaltax").setScale(2, RoundingMode.HALF_UP));
                dto.setOriginalInvoiceAmount(invoices[0].getBigDecimal("invoiceamount").setScale(2, RoundingMode.HALF_UP));
                String redType = "1";
                if (invoices[0].getBigDecimal("totalamount").compareTo(dto.getTotalAmount().abs()) != 0) {
                    redType = "2";
                }
                dto.setRedType(redType);
            }
        }
        return dto;
    }

    private static void rebuildItemLineNumber(List<CombineItems> items) {
        for (int i = 0; i < items.size(); ++i) {
            items.get(i).setIndex(i + 1);
            String policy = items.get(i).getPreferentialPolicy();
            if (!StringUtils.isBlank((CharSequence)policy)) continue;
            items.get(i).setPreferentialPolicy("0");
        }
    }
}

